/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.cmd.SelectionCmds;
import com.sigrity.orbit.ui.SwapPinsUI;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class DeviceTemplatePortUI {
    DeviceTemplatePortUI() {
    }

    public static void addUnusedPins() {
        Db db = OrbitIO.getCurDb();
        for (Device d : db.getObjects(Device.class)) {
            d.addUnusedPins();
        }
    }

    public static void selectPinsInArea(Db db, String devicePathString) {
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logWarn((String)"DevicePath '%s' does not exist", (Object[])new Object[]{devicePathString});
            return;
        }
        Selection s = Design.getSelection((Db)db);
        s.clear();
        AGeom bounds = devicePath.getDeviceTemplate().getBounds();
        AGeom wBounds = bounds.transform(devicePath.getTransform());
        Substrate originalS = devicePath.getSubstrate();
        DevicePath topPath = devicePath.pathToSubstrate();
        for (DevicePath desc : topPath.getDescendants()) {
            if (!desc.getLast().getSubstrate().equals((Object)originalS)) continue;
            for (PinInstance pi : desc.getLast().getPins()) {
                HierPin hp = new HierPin(desc, pi);
                if (!wBounds.intersects((AGeom)hp.getWorldBounds())) continue;
                s.add(desc, (DbObject)pi);
            }
        }
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static List<HierInst<PinTemplate>> getPinsInRect(DevicePath devicePath, long extra) {
        ARect bounds = devicePath.getBB().expandBy(extra);
        DeviceTemplate substrateDevT = devicePath.getSubstrateDeviceTemplate();
        ArrayList<HierInst<PinTemplate>> pinsInRect = new ArrayList<HierInst<PinTemplate>>();
        for (HierInst hierPin : substrateDevT.getPinsAndDescendants(true)) {
            if (!DeviceTemplatePortUI.isIntersects(bounds, (HierInst<PinTemplate>)hierPin)) continue;
            pinsInRect.add((HierInst<PinTemplate>)hierPin);
        }
        return pinsInRect;
    }

    private static boolean isIntersects(ARect bounds, HierInst<PinTemplate> hierPin) {
        PinTemplate dbObject = (PinTemplate)hierPin.getDbObject();
        APoint2D loc = dbObject.getLoc();
        if (loc == null) {
            return false;
        }
        APoint2D pinBounds = loc.transform(hierPin.getPathTransform());
        return bounds.contains(pinBounds);
    }

    public static void selectUnmappedPins(String devicePathString) {
        Db db = OrbitIO.getCurDb();
        DevicePath devicePath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (devicePath == null) {
            ALog.logWarn((String)"DevicePath '%s' does not exist", (Object[])new Object[]{devicePathString});
            return;
        }
        Selection s = Design.getSelection((Db)db);
        s.clear();
        Substrate originalS = devicePath.getSubstrate();
        for (DevicePath desc : devicePath.getDescendants()) {
            if (!desc.getSubstrate().equals((Object)originalS)) continue;
            for (PinInstance pi : desc.getLast().getPins()) {
                boolean justOnThisSubstrate = true;
                PinTemplate pt = pi.getPinTemplate();
                for (HierPin hp : NetMap.getConnectedDevicePathPorts((Net)pt.getNet(), (DevicePath)desc)) {
                    if (hp.getPath().getLast().getSubstrate() == originalS) continue;
                    justOnThisSubstrate = false;
                    break;
                }
                if (!justOnThisSubstrate) continue;
                s.add(desc, (DbObject)pi);
            }
        }
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void setSelectedType(PinTemplate.Type t) {
        Db db = OrbitIO.getCurDb();
        Design design = Design.getDesign((Db)db);
        Selection s = design.getCurSelection();
        int count = 0;
        for (PinInstance p : s.get(PinInstance.class)) {
            PinTemplate tp = p.getPinTemplate();
            tp.setType(t);
            ++count;
        }
        ALog.logInfo((String)(count + " pins have been set to " + t.name()));
    }

    public static void selectType(PinTemplate.Type t) {
        Db db = OrbitIO.getCurDb();
        Selection s = Design.getSelection((Db)db);
        for (PinInstance p : db.getObjects(PinInstance.class)) {
            if (p.getPinTemplate().getType() != t) continue;
            s.add((DbObject)p);
        }
    }

    public static void selectPortsByName(String name) {
        Db db = OrbitIO.getCurDb();
        Selection s = Design.getSelection((Db)db);
        Pattern pattern = Pattern.compile(name);
        for (PinInstance dp : db.getObjects(PinInstance.class)) {
            String thisName = dp.getPinInstanceName();
            if (thisName == null || !pattern.matcher(thisName).matches()) continue;
            s.add((DbObject)dp);
        }
    }

    public static void selectPortLikeSelected() {
        Selection s = Design.getSelection((Db)OrbitIO.getCurDb());
        SelectionCmds.selectPortLikeSelected((Selection)s, (Selection)s);
    }

    public static void swapSelectedPorts() {
        SwapPinsUI.swapSelectedPins();
    }

    public static void selectPortsByTemplatePortName(String name) {
        Db db = OrbitIO.getCurDb();
        Selection s = Design.getSelection((Db)db);
        Pattern pattern = Pattern.compile(name);
        for (PinTemplate dtp : db.getObjects(PinTemplate.class)) {
            String thisName = dtp.getName();
            if (thisName == null || !pattern.matcher(thisName).matches()) continue;
            for (PinInstance dp : dtp.getPinInstances()) {
                s.add((DbObject)dp);
            }
        }
    }

    public static void autoCreateNetNameOnSelectedPins(Db db) {
        Selection s = Design.getSelection((Db)db);
        LinkedList<HierPin> hps = new LinkedList<HierPin>();
        for (PinInstance pi : s.get(PinInstance.class)) {
            for (DevicePath dp : s.getSelectedPaths((DbObject)pi)) {
                HierPin hp = new HierPin(dp, pi);
                hps.add(hp);
            }
        }
        for (HierPin hp : hps) {
            DevicePath path = hp.getPath();
            DeviceTemplate substrateTemplate = path.getSubstrateDeviceTemplate();
            DevicePath relativePath = path.getRelativePath(substrateTemplate);
            PinInstance pi = hp.getPin();
            PinTemplate pt = hp.getPinTemplate();
            String netName = null;
            Net startedNet = null;
            if (path.getDevice().isPin()) {
                netName = path.getDevice().getName();
                startedNet = pt.getNet();
                if (startedNet == null || startedNet.isUnused()) {
                    startedNet = Net.getOrCreate((DeviceTemplate)path.getDeviceTemplate(), (String)pt.getName());
                    pt.setNet(startedNet);
                }
            } else {
                netName = pi.getName();
                startedNet = Net.getOrCreate((DeviceTemplate)pt.getDeviceTemplate(), (String)pt.getName());
                pt.setNet(startedNet);
            }
            NetMap.mapThroughPath((DevicePath)relativePath, (Net)startedNet, (String)netName);
            Net topNet = NetMap.getNetAt((Net)startedNet, (DevicePath)path, (DeviceTemplate)substrateTemplate);
            if (topNet.getDeviceTemplate() == substrateTemplate) {
                ALog.flogInfo((String)"Pin '%s' on %s is mapped to net '%s'", (Object[])new Object[]{pi.getName(), path.getLast().getName(), topNet.getName()});
                continue;
            }
            ALog.flogWarn((String)"There was a problem mapping Pin '%s' on %s to '%s'", (Object[])new Object[]{pi.getName(), path.getLast().getName(), topNet.getName()});
        }
        DbExplorerPanel.refreshAll();
    }

    public static void addport(String templateKeyStr, String portName, String layerName, PinTemplate.Type t, double llx, double lly, double urx, double ury) {
        Db db = OrbitIO.getCurDb();
        DeviceTemplate dt = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, templateKeyStr);
        if (dt == null) {
            ALog.logWarn((String)("Device Template " + templateKeyStr + " not found"));
            return;
        }
        Substrate s = dt.getSubstrate();
        Layer l = s.getLayer(layerName);
        if (l == null) {
            ALog.logWarn((String)("Layer " + layerName + " not found"));
        }
        if (l == null && (l = Layer.create((Substrate)s, (String)"padLayer")) == null) {
            ALog.logError((String)"Could not add layer 'padLayer' into '%s'", (Object[])new Object[]{s});
            return;
        }
        PadTemplate padTemplate = PadTemplate.create((Db)db, (Substrate)s, (String)"S");
        Net net = dt.getNetUnused();
        Design design = Design.getDesign((Db)db);
        PinTemplate dtp = PinTemplate.create((Net)net, (String)portName);
        ARect r = new ARect(design.getInternal(llx), design.getInternal(lly), design.getInternal(urx), design.getInternal(ury));
        dtp.setLoc(r.center());
        r.moveCenterTo(0L, 0L);
        LayerShape.create((Layer)l, (DbObject)padTemplate, (AGeom)r);
        dtp.setPadTemplate(padTemplate);
        dtp.setType(t);
        dtp.setIsSynthesized(true);
        for (Device d : dt.getDeviceInstances()) {
            d.addUnusedPins();
        }
    }

    public static void selectPinsNotConnectedToDeviceT(Db db, String devTKey) {
        DeviceTemplate devT = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, devTKey);
        if (devT == null) {
            ALog.logError((String)"The DeviceTemplate specified by key '%s' to selectPinsNotConnectedToDeviceT does not exist, no pins are being selected.", (Object[])new Object[]{devTKey});
            return;
        }
        Substrate subst = devT.getSubstrate();
        Predicate<DeviceTemplate.DescendantPin> filterOnSubst = dp -> dp.getDevicePath().getSubstrate() == subst;
        Predicate<DeviceTemplate.DescendantPin> filterUnconn = dp -> {
            Net n = NetMap.getNetAt((Net)((PinTemplate)dp.getDbObject()).getNet(), (DevicePath)dp.getPath(), (DeviceTemplate)devT, null);
            return n == null || n.isUnused();
        };
        Selection s = Design.getSelection((Db)db);
        Stream<DeviceTemplate.DescendantPin> selectPins = devT.getDescendantPins().stream().filter(filterOnSubst).filter(filterUnconn);
        selectPins.forEach(dp -> devT.getHierarchicalInstances().stream().forEach(pathStart -> s.add(pathStart.addPath(dp.getDevicePath()), (DbObject)PinInstance.getPinInstance((Device)dp.getDevicePath().getLast(), (PinTemplate)((PinTemplate)dp.getDbObject())))));
        OrbitIO.refreshViewsOf(db);
    }

    public static void selectAllPins(Db db, String devPath) {
        DevicePath path = DevicePath.fromEscapedString((Db)db, (String)devPath);
        if (path == null) {
            ALog.logError((String)"The DevicePath '%s' specified to selectAllPins does not exist, no pins are being selected.", (Object[])new Object[]{devPath});
            return;
        }
        if (!path.getIsAbsolute()) {
            ALog.logError((String)"The DevicePath '%s' specified to selectAllPins is not an absolute path, no pins are being selected.", (Object[])new Object[]{path});
            return;
        }
        Selection s = Design.getSelection((Db)db);
        path.getLast().getDescendantPins().stream().filter(dp -> dp.getPinInstance() != null).forEach(dp -> s.add(dp.getDevicePath().getAbsolutePath(path), (DbObject)dp.getPinInstance()));
        OrbitIO.refreshViewsOf(db);
    }

    public static void selectPinsNotConnectedToSubstrate(Db db, String devPath) {
        DevicePath path = DevicePath.fromEscapedString((Db)db, (String)devPath);
        if (path == null) {
            ALog.logError((String)"The DevicePath '%s' specified to selectPinsNotConnectedToSubstrate does not exist, no pins are being selected.", (Object[])new Object[]{devPath});
            return;
        }
        if (!path.getIsAbsolute()) {
            ALog.logError((String)"The DevicePath '%s' specified to selectPinsNotConnectedToSubstrate is not an absolute path, no pins are being selected.", (Object[])new Object[]{path});
            return;
        }
        Substrate subst = path.getSubstrate();
        Predicate<DeviceTemplate.DescendantPin> filterOnSubst = dp -> dp.getDevicePath().getSubstrate() == subst;
        Predicate<DeviceTemplate.DescendantPin> filterUnconn = dp -> {
            Net n = NetMap.getSubstrateNet((Net)((PinTemplate)dp.getDbObject()).getNet(), (DevicePath)dp.getPath(), (boolean)true);
            return n == null || n.isUnused();
        };
        Selection s = Design.getSelection((Db)db);
        path.getDeviceTemplate().getDescendantPins().stream().filter(filterOnSubst).filter(filterUnconn).forEach(dp -> s.add(path.addPath(dp.getDevicePath()), (DbObject)PinInstance.getPinInstance((Device)dp.getDevicePath().getLast(), (PinTemplate)((PinTemplate)dp.getDbObject()))));
        OrbitIO.refreshViewsOf(db);
    }
}

