/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.geom.ATransform;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.ui.log.ALogHelper;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.cmd.SelectionCmds;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

public class DeviceTemplateUI {
    public static void deleteUnusedDeviceTemplates() {
        Db db = OrbitIO.getCurDb();
        ArrayList<DeviceTemplate> toBeDeletedTemplates = new ArrayList<DeviceTemplate>();
        for (DeviceTemplate dt : db.getObjects(DeviceTemplate.class)) {
            if (dt instanceof Design || !dt.hasNoDeviceInstance()) continue;
            toBeDeletedTemplates.add(dt);
        }
        for (DeviceTemplate dt : toBeDeletedTemplates) {
            ALog.logInfo((String)"Template %s deleted", (Object[])new Object[]{dt.getName()});
            dt.deleteFromDb();
        }
        ArrayList<Substrate> toBeDeletedSubstrates = new ArrayList<Substrate>();
        for (Substrate s : db.getObjects(Substrate.class)) {
            int dtCount = s.getDeviceTemplateCount();
            if (dtCount != 0 && (dtCount != 1 || !(s.getDeviceTemplates().next() instanceof Design))) continue;
            toBeDeletedSubstrates.add(s);
        }
        for (Substrate s : toBeDeletedSubstrates) {
            ALog.logInfo((String)"Substrate %s deleted", (Object[])new Object[]{s.getName()});
            s.deleteFromDb();
        }
    }

    public static void deleteIODevices(boolean deleteAllTemplates) {
        Db curDb = OrbitIO.getCurDb();
        DeviceTemplateUI.deleteIODevices(Design.getDesignPath((Db)curDb), deleteAllTemplates);
    }

    public static void deleteIODevices(String diePathString, boolean deleteAllTemplates) {
        DeviceTemplateUI.deleteIODevices(diePathString, deleteAllTemplates, true);
    }

    public static void deleteIODevices(String diePathString, boolean deleteAllTemplates, boolean includingRoot) {
        Db db = OrbitIO.getCurDb();
        DevicePath dp = DevicePath.fromString((Db)db, (String)diePathString);
        if (dp == null) {
            ALogHelper.logInvalidDevicePath(diePathString);
            return;
        }
        DeviceTemplateUI.deleteIODevices(dp, deleteAllTemplates, includingRoot);
    }

    protected static void deleteIODevices(DevicePath dp, boolean deleteAllTemplates) {
        DeviceTemplateUI.deleteIODevices(dp, deleteAllTemplates, true);
    }

    protected static void deleteIODevices(DevicePath dp, boolean deleteAllTemplates, boolean includingRoot) {
        ArrayList<Device> toBeDeletedDevices = new ArrayList<Device>();
        ArrayList<DeviceTemplate> toBeDeletedTemplates = new ArrayList<DeviceTemplate>();
        ArrayList<Personality> toBeDeletedPersonalities = new ArrayList<Personality>();
        for (DevicePath child : dp.getDescendants(includingRoot)) {
            Device d = child.getLast();
            DeviceTemplate t = d.getTemplate();
            if (d.getSourceType() == Device.SourceType.DIESPREADSHEET || d.getSourceType() == Device.SourceType.DECORATOR) {
                DeviceTemplate p;
                Personality personality;
                toBeDeletedDevices.add(d);
                if (deleteAllTemplates && !toBeDeletedTemplates.contains(t)) {
                    toBeDeletedTemplates.add(t);
                }
                if ((personality = d.getPersonality()) != null && !toBeDeletedPersonalities.contains(personality)) {
                    toBeDeletedPersonalities.add(personality);
                }
                if ((p = d.getParent()).getType() != DeviceTemplate.Type.PERSONALITY) continue;
                if (!toBeDeletedTemplates.contains(p)) {
                    toBeDeletedTemplates.add(p);
                }
                for (Device parentInstance : p.getDeviceInstances()) {
                    if (toBeDeletedDevices.contains(parentInstance)) continue;
                    toBeDeletedDevices.add(parentInstance);
                }
                continue;
            }
            ALog.flogWarn((String)"%s will not be deleted", (Object[])new Object[]{d.getName()});
        }
        for (Device d : toBeDeletedDevices) {
            if (d.getDb() == null) continue;
            d.deleteFromDb(false);
        }
        for (DeviceTemplate t : toBeDeletedTemplates) {
            t.deleteFromDb();
        }
        for (Personality p : toBeDeletedPersonalities) {
            p.deleteFromDb();
        }
        OrbitIO.getApp().refreshCurrentView(false);
        DbExplorerPanel.refreshAll();
    }

    public static void selectDevicesLikeSelected() {
        Selection s = Design.getSelection((Db)OrbitIO.getCurDb());
        SelectionCmds.selectDevicesLikeSelected((Selection)s, (Selection)s);
    }

    public static void swapSelectedDevices() {
        Db db = OrbitIO.getCurDb();
        Selection s = Design.getSelection((Db)db);
        Device dev1 = null;
        Device dev2 = null;
        for (Device d : s.get(Device.class)) {
            if (d.getIsFixed()) continue;
            if (dev1 == null) {
                dev1 = d;
                continue;
            }
            dev2 = d;
            break;
        }
        if (dev1 == null || dev2 == null) {
            ALog.logError((String)"Please select two free devices");
            return;
        }
        if (dev1.getParent() != dev2.getParent()) {
            ALog.logError((String)"Devices must have the same parent to swap");
            return;
        }
        ATransform t1 = dev1.getTransform();
        ATransform t2 = dev2.getTransform();
        dev1.setTransform(t2);
        dev2.setTransform(t1);
        ALog.logInfo((String)(dev1.getName() + " swapped with " + dev2.getName()));
    }

    protected static DeviceTemplate validateParams(String path) {
        DeviceTemplate dt = null;
        Db db = OrbitIO.getCurDb();
        DevicePath dp = DevicePath.fromString((Db)db, (String)path);
        if (dp == null) {
            ALogHelper.logInvalidDevicePath(path);
            return dt;
        }
        Device d = dp.getLast();
        if (d == null) {
            ALog.logError((String)"%s is not a valid device path", (Object[])new Object[]{path});
            return dt;
        }
        dt = d.getTemplate();
        if (dt == null) {
            ALog.logError((String)"%s has no device template", (Object[])new Object[]{d.getName()});
            return dt;
        }
        return dt;
    }

    public static void changeDeviceTemplate(String path, String type) {
        DeviceTemplate dt = DeviceTemplateUI.validateParams(path);
        if (dt != null) {
            dt.setType(DeviceTemplate.Type.valueOf((String)type));
        }
    }

    public static void setSelectedType(DeviceTemplate.Type t) {
        Db db = OrbitIO.getCurDb();
        Design design = Design.getDesign((Db)db);
        Selection s = design.getCurSelection();
        int count = 0;
        for (Device p : s.get(Device.class)) {
            DeviceTemplate tp = p.getTemplate();
            tp.setType(t);
            ++count;
        }
        ALog.logInfo((String)"%d devices have been set to %s", (Object[])new Object[]{count, t.name()});
    }

    public static void setDeviceTemplateOrigin(String path, long width, long height, boolean lowerLeft) {
        DeviceTemplate dt = DeviceTemplateUI.validateParams(path);
        if (dt != null) {
            ARect r = lowerLeft ? new ARect(0L, 0L, width, height) : new ARect(-width / 2L, -height / 2L, width - width / 2L, height - height / 2L);
            dt.setBounds((AGeom)r);
        }
    }

    public static void changeDeviceTemplate(String path, long width, long height, boolean keepLLPegged) {
        DeviceTemplate dt = DeviceTemplateUI.validateParams(path);
        if (dt != null) {
            dt.changeDimension(width, height, keepLLPegged);
        }
    }

    public static void cloneSelected(String newName, int num) {
        Design currentDesign = Design.getDesign((Db)OrbitIO.getCurDb(), (boolean)false);
        if (currentDesign == null) {
            ALogHelper.logInvalidDesign();
            return;
        }
        Selection s = currentDesign.getCurSelection();
        for (Device d : s.get(Device.class)) {
            DeviceTemplateUI.cloneInstance(d, newName, num);
        }
        Device.manageAllUnplaceQs();
        currentDesign.binAllDevices();
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static void createInstance(String templateKeyStr, String baseInstanceName, int num) {
        DeviceTemplateUI.createInstance(templateKeyStr, baseInstanceName, null, num);
    }

    public static void createInstance(String templateKeyStr, String baseInstanceName, String parentTemplateKeyStr, int num) {
        Object parent;
        Db db = OrbitIO.getCurDb();
        Design currentDesign = Design.getDesign((Db)db, (boolean)false);
        if (currentDesign == null) {
            ALogHelper.logInvalidDesign();
            return;
        }
        DeviceTemplate t = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, templateKeyStr);
        Substrate s = t.getSubstrate();
        Device parentDevice = null;
        DeviceTemplate destinationTemplate = null;
        destinationTemplate = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, parentTemplateKeyStr);
        if (destinationTemplate == null) {
            Iterator iterator;
            if (t.getType() == DeviceTemplate.Type.BOARD || t.getType() == DeviceTemplate.Type.PACKAGE || t.getType() == DeviceTemplate.Type.DIE) {
                parentDevice = null;
            } else if (s != null && (iterator = s.getInstances().iterator()).hasNext()) {
                Device d;
                parentDevice = d = (Device)iterator.next();
            }
            if (parentDevice != null && parentDevice.getTemplate() == t) {
                parentDevice = null;
            }
            parent = parentDevice == null ? currentDesign : parentDevice.getTemplate();
        } else {
            parent = destinationTemplate;
            parentDevice = parent.getAnInstance();
        }
        for (int i = 0; i < num; ++i) {
            int uniqueify = i;
            Object thisInstanceName = baseInstanceName;
            Device d = Device.getInstance((DeviceTemplate)parent, (String)thisInstanceName);
            while (d != null) {
                thisInstanceName = baseInstanceName + uniqueify;
                d = Device.getInstance((DeviceTemplate)parent, (String)thisInstanceName);
                ++uniqueify;
            }
            Device newDevice = new Device((String)thisInstanceName, (DeviceTemplate)currentDesign, t);
            newDevice.setSynthesized(true);
            newDevice.setIsPlaced(false);
            newDevice.setLoc(new APoint2D(0L, 0L));
            if (!db.add((DbObject)newDevice)) {
                ALog.logInfo((String)"Could not create device %s", (Object[])new Object[]{baseInstanceName + i});
            }
            newDevice.addUnusedPins();
            if (parentDevice == null) continue;
            newDevice.setParent(parentDevice, true);
        }
        Device.manageAllUnplaceQs();
        currentDesign.binAllDevices();
        OrbitIO.getApp().refreshCurrentView(false);
    }

    public static Action getGroupSelectedAction() {
        return new AbstractAction("Group Selected Devices", UIUtil.getScaledIcon((Icon)UIManager.getIcon("CDNS.hierarchyAscendIcon"), (int)16, (int)16)){

            @Override
            public void actionPerformed(ActionEvent e) {
                Cp.exec((String)"com.sigrity.orbit.ui.DeviceTemplateUI.groupSelected()", (Object[])new Object[0]);
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitIO.getCurDb() != null;
            }
        };
    }

    public static void groupSelected() {
        DeviceTemplateUI.groupSelected("UserGroup");
    }

    public static void groupSelected(String groupName) {
        Design currentDesign = Design.getDesign((Db)OrbitIO.getCurDb(), (boolean)false);
        if (currentDesign == null) {
            ALogHelper.logInvalidDesign();
            return;
        }
        Selection s = currentDesign.getCurSelection();
        ArrayList<Device> devices = new ArrayList<Device>();
        for (Device d : s.get(Device.class)) {
            devices.add(d);
        }
        s.clear();
        Device.group(devices, (String)groupName);
        OrbitIO.getApp().refreshCurrentView(false);
    }

    protected static void cloneInstance(Device d, String newName, int num) {
        if (d == null) {
            ALog.logError((String)"Can not find instance");
            return;
        }
        Db db = d.getDb();
        Design currentDesign = Design.getDesign((Db)db, (boolean)false);
        if (currentDesign == null) {
            ALogHelper.logInvalidDesign();
            return;
        }
        Device lastDevice = d;
        DeviceTemplate parentTemplate = d.getParent();
        parentTemplate.reindex();
        for (int i = 0; i < num; ++i) {
            int uniqueify = i;
            String thisInstanceName = newName + uniqueify;
            Device newDevice = Device.get((Db)db, (String)thisInstanceName, (DeviceTemplate)parentTemplate);
            while (newDevice != null) {
                thisInstanceName = d.getName() + ++uniqueify;
                newDevice = Device.get((Db)db, (String)thisInstanceName, (DeviceTemplate)parentTemplate);
            }
            newDevice = new Device(thisInstanceName, parentTemplate, d.getTemplate());
            newDevice.setTransform(lastDevice.getTransform());
            newDevice.setSynthesized(true);
            newDevice.setIsPlaced(false);
            newDevice.assignToPersonality(d.getPersonality());
            if (!db.add((DbObject)newDevice)) {
                ALog.logInfo((String)("Could not create device " + newName + i));
            }
            for (PinInstance port : d.getPins()) {
                PinInstance newPort = new PinInstance(port.getName(), newDevice, port.getPinTemplate());
                db.add((DbObject)newPort);
            }
            lastDevice = newDevice;
        }
    }

    public static void updateScribe(Db db, String devTempKeyStr, boolean hasScribe, long north, long south, long east, long west) {
        DeviceTemplate dt = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, devTempKeyStr);
        if (dt != null) {
            if (!hasScribe || north == 0L && south == 0L && east == 0L && west == 0L) {
                dt.removeScribe();
            } else {
                dt.setScribe(north, south, east, west);
            }
        }
    }

    public static void updateSealRing(Db db, String devTempKeyStr, boolean hasRing, long north, long south, long east, long west) {
        DeviceTemplate dt = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, devTempKeyStr);
        if (dt != null) {
            if (!hasRing || north == 0L && south == 0L && east == 0L && west == 0L) {
                dt.removeSealRing();
            } else {
                dt.setSealRing(north, south, east, west);
            }
        }
    }

    public static void updateSiliconRemainder(Db db, String devTempKeyStr, boolean hasRemainder, long north, long south, long east, long west) {
        DeviceTemplate dt = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, devTempKeyStr);
        if (dt != null) {
            if (!hasRemainder || north == 0L && south == 0L && east == 0L && west == 0L) {
                dt.removeSiliconRemainder();
            } else {
                dt.setSiliconRemainder(north, south, east, west);
            }
        }
    }

    private DeviceTemplateUI() {
    }

    public static class CopyDlg
    extends DbDialog {
        protected String mOrigName;
        protected JTextField mTxtNewName = new JTextField(20);
        protected JButton mBtnOk = new JButton("OK");
        protected JButton mBtnCancel = new JButton("Cancel");
        protected DeviceTemplate srcTemplate;
        protected ActionListener mOk = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!this.validateFields()) {
                    return;
                }
                String newName = mTxtNewName.getText();
                if (DeviceTemplate.getDeviceTemplate((Substrate)srcTemplate.getSubstrate(), (String)newName) != null) {
                    String msg = String.format("A DeviceTemplate named '%s' already exists.", newName);
                    mTxtNewName.requestFocus();
                    JOptionPane.showMessageDialog((Component)((Object)this), msg, "Duplicate Name", 0);
                    return;
                }
                Object o = Cp.exec((String)"DeviceTemplate.copyTemplate(curDb(), \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{mOrigName, newName, srcTemplate.getSubstrate().getName()});
                if (!(o instanceof DeviceTemplate)) {
                    String msg = "An error occurred copying the template.";
                    JOptionPane.showMessageDialog((Component)((Object)this), msg, "Copy Error", 0);
                    return;
                }
                UIUtil.closeWindow((Window)((Object)this));
            }
        };

        public CopyDlg(Component owner, DeviceTemplate src) {
            super(src.getDb(), owner, String.format("Copy Template '%s'", src.getKeyStr()));
            this.srcTemplate = src;
            this.mOrigName = src.getName();
            this.setModal(true);
            GridBagManager l = new GridBagManager(this.getContentPane());
            l.add("New template name:").setLabelFor(this.mTxtNewName);
            this.mTxtNewName = (JTextField)l.add((Component)this.mTxtNewName, (GridBagConstraints)GridBagManager.FILLX);
            l.newline();
            l.addFillY();
            l.pushFillXRemainX();
            l.addFillX();
            l.add((Component)this.mBtnOk);
            l.add((Component)this.mBtnCancel);
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)this.mBtnCancel, (JButton)this.mBtnOk);
            this.pack();
            this.setMinimumSize(this.getPreferredSize());
            UIUtil.center((Component)((Object)this));
            this.mTxtNewName.setText(String.format("Copy_of_%s", src.getName()));
            this.mBtnOk.addActionListener(this.mOk);
            this.setVisible(true);
        }

        protected boolean validateFields() {
            try {
                AFieldValidator.validateText((JTextComponent)this.mTxtNewName);
                return true;
            }
            catch (AFieldValidator.AFieldValidationException e) {
                return false;
            }
        }
    }
}

