/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.Unit;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.edaMgrs.HConnEngine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.ui.AActionGroup;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.AMenuUtil;
import com.sigrity.acl.ui.ActionOnPlaceableItem;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.ObjectActionRegistry;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.AutoBundleNetUI;
import com.sigrity.orbit.automation.iocellplacement.ui.DriverRespacerUI;
import com.sigrity.orbit.cmd.DeviceCommands;
import com.sigrity.orbit.ui.ContactToParentUI;
import com.sigrity.orbit.ui.DeviceDimensionUI;
import com.sigrity.orbit.ui.DevicePathChooser;
import com.sigrity.orbit.ui.DimensionsUI;
import com.sigrity.orbit.ui.OrbitGuiObjectActionRegistry;
import com.sigrity.orbit.ui.OrbitGuiShortcutActionRegistry;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.TextUI;
import com.sigrity.orbit.ui.canvas_modes.EditDeviceBoundsMode;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class DeviceUI {
    public static final ObjectActionRegistry.ActionFactory<Selection> ActionFactorySelection = (selection, constraints) -> {
        long count = 0L;
        ArrayList<Device> dev = new ArrayList<Device>();
        for (Device d : selection.get(Device.class)) {
            dev.add(d);
        }
        count = dev.size();
        if (count == 0L) {
            return AEmptyItr.create();
        }
        LinkedList<AbstractAction> actions = new LinkedList<AbstractAction>();
        if (count == 2L) {
            actions.add(new ActionAutoBundleDevice((Device)dev.get(0), (Device)dev.get(1)));
        }
        if (count > 0L) {
            ArrayList devInsts = AUtil.arrayList((Iterator)selection.getSelectedHierInsts(Device.class));
            actions.add(new OrbitGuiObjectActionRegistry.ActionSelectMultiDbObject<Device>(devInsts, Device.class));
        }
        return actions.iterator();
    };
    public static final OrbitGuiShortcutActionRegistry.ViewActionFactory ViewActionFactory = new OrbitGuiShortcutActionRegistry.ViewActionFactory(){

        private JMenu createAlignDeviceMenu(APoint2D worldPoint) {
            JMenu alignSelBy = new JMenu("Align Selected by");
            JMenu byX = new JMenu("Common X");
            JMenu byY = new JMenu("Common Y");
            alignSelBy.add(byX);
            alignSelBy.add(byY);
            long x = worldPoint.getX();
            long y = worldPoint.getY();
            byX.add(new JMenuItem(new ActionAlign(x, y, true, ActionAlign.ALIGN_DIR.LEFT)));
            byX.add(new JMenuItem(new ActionAlign(x, y, true, ActionAlign.ALIGN_DIR.CENTER)));
            byX.add(new JMenuItem(new ActionAlign(x, y, true, ActionAlign.ALIGN_DIR.RIGHT)));
            byX.add(new JMenuItem(new ActionAlign(x, y, true, ActionAlign.ALIGN_DIR.PIN_CENTER)));
            byX.add(new JMenuItem(new ActionAlign(x, y, true, ActionAlign.ALIGN_DIR.ORIGIN)));
            byY.add(new JMenuItem(new ActionAlign(x, y, false, ActionAlign.ALIGN_DIR.TOP)));
            byY.add(new JMenuItem(new ActionAlign(x, y, false, ActionAlign.ALIGN_DIR.CENTER)));
            byY.add(new JMenuItem(new ActionAlign(x, y, false, ActionAlign.ALIGN_DIR.BOTTOM)));
            byY.add(new JMenuItem(new ActionAlign(x, y, false, ActionAlign.ALIGN_DIR.PIN_CENTER)));
            byY.add(new JMenuItem(new ActionAlign(x, y, false, ActionAlign.ALIGN_DIR.ORIGIN)));
            return alignSelBy;
        }

        private JMenu createSelectIODriversMenu(List<DevicePath> pths, Selection selection) {
            JMenu p0 = new JMenu("Select Connected I/O Drivers");
            LinkedList<JMenuItem> menuItems = new LinkedList<JMenuItem>();
            for (DevicePath devPath : pths) {
                Object txt = DevicePath.getUserDisplayName((DevicePath)devPath);
                txt = (String)txt + " (" + selection.numberOfConnectionsEndingOnDieDriver(devPath) + ")";
                JMenuItem p1 = new JMenuItem((String)txt);
                Icon icon = DbExplorerPanel.getIconForDevice(devPath.getLast());
                p1.setIcon(icon);
                p1.addActionListener(new ActionSelectedIODriversOfSelectedConnections(devPath));
                menuItems.add(p1);
            }
            LinkedList sortedItems = AMenuUtil.groupByFirstWord(menuItems.iterator());
            AMenuUtil.sort((List)sortedItems, (boolean)true);
            for (JMenuItem a : sortedItems) {
                p0.add(a);
            }
            return p0;
        }

        @Override
        public Iterator<Object> getActions(Db db, Selection selection, APoint2D worldPoint) {
            HierInst hierDevice;
            DevicePath best;
            int selPinCount = selection.getCount(db.getDbClass(PinInstance.class));
            int selDeviceCount = selection.getCount(db.getDbClass(Device.class));
            int selItemCount = selPinCount + selDeviceCount;
            DbClass devClz = db.getDbClass(Device.class);
            int numDrivers = selection.numberOfDevicesAreDrivers();
            int numConnections = selection.numberOfConnectionsIncludedBetweenDriversBallsOrBumps();
            DesignView2D view = (DesignView2D)OrbitIO.getCurView();
            LinkedList<Serializable> actions = new LinkedList<Serializable>();
            if (selItemCount == 0 && worldPoint != null && view != null && (best = view.getDeviceAt(worldPoint)) != null) {
                Device device = best.getDevice();
                String deviceName = device.getName();
                Object label = String.format("Move Device '%s' Interactively", deviceName);
                ActionOnPlaceableItem a = new ActionOnPlaceableItem(best, (DbObject)device, ActionOnPlaceableItem.ACTION.MOVE_OBJ_INT, true, "false,false", (String)label);
                a.setStartLoc(worldPoint);
                actions.add(a);
                label = String.format("Copy Device '%s'...", deviceName);
                actions.add(new ActionOnPlaceableItem(best, (DbObject)device, ActionOnPlaceableItem.ACTION.COPY, (String)label));
                label = String.format("Move Device '%s'...", deviceName);
                actions.add(new ActionOnPlaceableItem(best, (DbObject)device, ActionOnPlaceableItem.ACTION.MOVE, (String)label));
                label = String.format("Text for '%s'...", deviceName);
                actions.add(new TextUI.ActionTextDevice(best, (String)label));
                label = String.format("Dimensions for '%s'...", deviceName);
                actions.add(new DimensionsUI.ActionDimsDevice(best, (String)label));
            }
            if (selDeviceCount == 1 && (hierDevice = (HierInst)selection.getSelectedHierInsts(Device.class).findFirst().orElse(null)) != null) {
                actions.add(new ActionRatsFrom1((HierInst<Device>)hierDevice));
            }
            if (selDeviceCount == 2) {
                IterableIterator selDevice = selection.get(Device.class);
                Device d1 = (Device)selDevice.next();
                Device d2 = (Device)selDevice.next();
                actions.add(new ActionAutoBundleDevice(d1, d2));
            }
            if (selDeviceCount > 1 && worldPoint != null) {
                actions.add(this.createAlignDeviceMenu(worldPoint));
            }
            if (numConnections > 0) {
                List pths = null;
                for (Connection connection : selection.get(Connection.class)) {
                    pths = connection.addDriversOrPackagesToList(pths, true, false);
                }
                if (pths != null && !pths.isEmpty()) {
                    actions.add(this.createSelectIODriversMenu(pths, selection));
                }
            }
            Set connections = selection.connectionsOfDriversBallsOrBumps();
            Set driversList = null;
            if (!connections.isEmpty()) {
                driversList = Connection.driversListedInConnections((Set)connections);
                List pths = null;
                for (Connection connection : connections) {
                    pths = connection.addDriversAndPackagesToList(pths);
                }
                JMenu p0 = new JMenu("Optimize");
                LinkedList<JMenuItem> menuItems = new LinkedList<JMenuItem>();
                if (pths != null) {
                    for (Iterator devPath : pths) {
                        Object txt = DevicePath.getUserDisplayName((DevicePath)devPath);
                        DeviceTemplate.Type type = devPath.getDeviceTemplate().getType();
                        txt = type == DeviceTemplate.Type.PACKAGE || type == DeviceTemplate.Type.COVER ? (String)txt + " pins placement(" + selection.numberOfConnectionsEndingOnPackagePin(devPath) + ")" : (String)txt + " drivers placement(" + selection.numberOfConnectionsEndingOnDieDriver(devPath) + ")";
                        JMenuItem p1 = new JMenuItem((String)txt);
                        Icon icon = DbExplorerPanel.getIconForDevice(devPath.getLast());
                        p1.setIcon(icon);
                        p1.addActionListener(new ActionAlignSelectedIODriversWithConnected((DevicePath)devPath, true));
                        menuItems.add(p1);
                    }
                    LinkedList sortedItems = AMenuUtil.groupByFirstWord(menuItems.iterator());
                    AMenuUtil.sort((List)sortedItems, (boolean)true);
                    for (JMenuItem a : sortedItems) {
                        p0.add(a);
                    }
                    if (p0.getMenuComponentCount() > 0) {
                        actions.add(p0);
                    }
                }
            }
            HierInst device1 = null;
            HierInst device2 = null;
            HierInst refDevice = null;
            Selection.SelSet selSet = selection.getSelSet(devClz);
            for (APair thePair : selSet.getElements()) {
                Device device = (Device)thePair.second;
                if (refDevice == null && view != null && view.getDevicePathAt(worldPoint, device) != null) {
                    refDevice = HierInst.create((DevicePath)((DevicePath)thePair.first), (DbObject)device);
                }
                if (device1 == null) {
                    device1 = HierInst.create((DevicePath)((DevicePath)thePair.first), (DbObject)device);
                    continue;
                }
                device2 = HierInst.create((DevicePath)((DevicePath)thePair.first), (DbObject)device);
            }
            if (driversList != null && !driversList.isEmpty() && worldPoint != null) {
                JMenu p0 = new JMenu("Align IO Drivers to");
                LinkedList<JMenuItem> menuItems = new LinkedList<JMenuItem>();
                for (DevicePath devPath : Connection.devicePathsConnectedToDrivers((Set)connections)) {
                    JMenuItem p1 = new JMenuItem(new ActionAlignToBumpsOrBalls(devPath, worldPoint.getX(), worldPoint.getY()));
                    Icon icon = DbExplorerPanel.getIconForDevice(devPath.getLast());
                    p1.setIcon(icon);
                    p1.setText(DevicePath.getUserDisplayName((DevicePath)devPath));
                    menuItems.add(p1);
                }
                LinkedList sortedItems = AMenuUtil.groupByFirstWord(menuItems.iterator());
                AMenuUtil.sort((List)sortedItems, (boolean)true);
                for (JMenuItem a : sortedItems) {
                    p0.add(a);
                }
                if (p0.getMenuComponentCount() > 0) {
                    actions.add(p0);
                }
            }
            if (numDrivers == 2 && device1 != null && device2 != null) {
                DevicePath driverDiePath2;
                DevicePath driverDiePath1 = device1.getPath().pathToLowestOfType(DeviceTemplate.Type.DIE);
                if (driverDiePath1.equals((Object)(driverDiePath2 = device2.getPath().pathToLowestOfType(DeviceTemplate.Type.DIE)))) {
                    actions.add(new ActionSwapIODrivers((Device)device1.getDbObject(), (Device)device2.getDbObject(), driverDiePath1));
                }
                if (refDevice != null) {
                    actions.add(new ActionAlignIODrivers((Device)refDevice.getDbObject(), refDevice.getPath(), device1.getDbObject() == refDevice.getDbObject() ? (Device)device2.getDbObject() : (Device)device1.getDbObject(), device1.getDbObject() == refDevice.getDbObject() ? device2.getPath() : device1.getPath()));
                }
            }
            if (numDrivers >= 1 && worldPoint != null && (refDevice = selection.getClosestDriver(worldPoint)) != null) {
                JMenu respace = new JMenu("Respace IO Drivers");
                respace.setIcon(OrbitIcons.SPACE);
                JMenuItem byX = new JMenuItem(new ActionRespaceIODrivers((Device)refDevice.getDbObject(), refDevice.getPath(), true));
                JMenuItem byY = new JMenuItem(new ActionRespaceIODrivers((Device)refDevice.getDbObject(), refDevice.getPath(), false));
                byX.setText("by X");
                byY.setText("by Y");
                respace.add(byX);
                respace.add(byY);
                actions.add(respace);
            }
            if (selDeviceCount > 1) {
                actions.add(new ActionShowRatsBetweenN(selection));
            }
            int selPinCnt = selection.getCount(db.getDbClass(PinInstance.class));
            if (selDeviceCount > 0 && selPinCnt == 0) {
                actions.add(new ActionShowRatsOnDevice(selection));
            }
            if (selDeviceCount > 0) {
                actions.add(new ActionOnPlaceableItem(selection, devClz, ActionOnPlaceableItem.ACTION.COPY, "Copy Selected Devices..."));
                actions.add(new ActionOnPlaceableItem(selection, selDeviceCount, "Device", ActionOnPlaceableItem.ACTION.MOVE_SEL_INT, true, "true, false", "Copy Selected Devices Interactively"));
                actions.add(new ActionOnPlaceableItem(selection, devClz, ActionOnPlaceableItem.ACTION.MOVE, "Move Selected Devices..."));
                actions.add(new ActionOnPlaceableItem(selection, selDeviceCount, "Device", ActionOnPlaceableItem.ACTION.MOVE_SEL_INT, true, "false, false", "Move Selected Devices Interactively"));
                actions.add(new ActionOnPlaceableItem(selection, selDeviceCount, "Device", ActionOnPlaceableItem.ACTION.DELETE_SEL, false, "", "Delete Selected Devices"));
                actions.add(new ActionGroupDevices(selection));
            }
            return actions.iterator();
        }

        @Override
        public String getGroupName() {
            return "Device Actions";
        }
    };

    private DeviceUI() {
    }

    static AActionGroup getDimensionActions(Device device) {
        boolean hasSelPorts;
        LinkedList<ActionDimensions> actions = new LinkedList<ActionDimensions>();
        actions.add(new ActionDimensionsDevice(device));
        boolean hasPorts = device.getPins().hasNext();
        boolean bl = hasSelPorts = hasPorts && DeviceDimensionUI.getSelectedPorts(device).hasNext();
        if (hasPorts) {
            actions.add(new ActionDimensionsAllPorts(device));
            actions.add(new ActionDimensionsAllPortsAdjacent(device));
        }
        if (hasSelPorts) {
            actions.add(new ActionDimensionsSelPorts(device));
            actions.add(new ActionDimensionsSelPortsAdjacent(device));
        }
        return new AActionGroup("Show dimensions", actions.iterator());
    }

    protected static class ActionSelectPadsOfType
    extends AbstractAction {
        public static final String TITLE_FORMAT = "Select %ss";
        protected DevicePath mDevicePath;
        protected PinTemplate.Type mPadType;

        static APair<Boolean, Boolean> getPadSelectStatus(DevicePath path, PinTemplate.Type padType) {
            Selection s = Design.getSelection((Db)path.getDb());
            boolean found = false;
            for (DevicePath dp : path.getDescendants()) {
                Device d = dp.getLast();
                if (d == null) continue;
                for (PinInstance port : d.getPins()) {
                    PinTemplate dtp = port.getPinTemplate();
                    if (dtp.getType() != padType) continue;
                    found = true;
                    if (s.contains(dp, (DbObject)port)) continue;
                    return new APair((Object)true, (Object)false);
                }
            }
            if (!found) {
                return new APair((Object)false, (Object)false);
            }
            return new APair((Object)true, (Object)true);
        }

        public ActionSelectPadsOfType(DevicePath path, PinTemplate.Type type) {
            super(String.format(TITLE_FORMAT, type.getUserName()));
            this.mDevicePath = path;
            this.mPadType = type;
            APair<Boolean, Boolean> s = ActionSelectPadsOfType.getPadSelectStatus(this.mDevicePath, this.mPadType);
            if (!((Boolean)s.first).booleanValue()) {
                String n = (String)this.getValue("Name");
                this.putValue("Name", n + " (None)");
                this.setEnabled(false);
            }
            this.putValue("SwingSelectedKey", s.second);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean select = (Boolean)this.getValue("SwingSelectedKey");
            try (DbHistory.DbTransaction txt = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                Cp.exec((String)"Device.selectPadsOfType(\"%s\", PinTemplate.Type.%s, %s);", (Object[])new Object[]{this.mDevicePath.toString(), this.mPadType.name(), Boolean.toString(select)});
                OrbitIO.getApp().refreshCurrentView(false);
            }
        }
    }

    protected static class ActionDimensionsAllPortsAdjacent
    extends ActionDimensions {
        public ActionDimensionsAllPortsAdjacent(Device d) {
            super("All Pin Clearances", d);
        }

        @Override
        public void display(boolean b) {
            this.mUI.drawAdjacentDimension((Iterator<PinInstance>)this.mDevice.getPins(), b);
        }

        @Override
        public boolean displayed() {
            return this.mUI.isShowAdjacentDimensions((Iterator<PinInstance>)this.mDevice.getPins());
        }
    }

    protected static class ActionDimensionsSelPortsAdjacent
    extends ActionDimensions {
        public ActionDimensionsSelPortsAdjacent(Device d) {
            super("Selected Pin Clearances", d);
        }

        @Override
        public void display(boolean b) {
            this.mUI.drawAdjacentDimension(DeviceDimensionUI.getSelectedPorts(this.mDevice), b);
        }

        @Override
        public boolean displayed() {
            return this.mUI.isShowAdjacentDimensions(DeviceDimensionUI.getSelectedPorts(this.mDevice));
        }
    }

    protected static class ActionDimensionsAllPorts
    extends ActionDimensions {
        public ActionDimensionsAllPorts(Device d) {
            super("All Pin Dimensions", d);
        }

        @Override
        public void display(boolean b) {
            this.mUI.drawPortDimension((Iterator<PinInstance>)this.mDevice.getPins(), b);
        }

        @Override
        public boolean displayed() {
            return this.mUI.isShowPortDimensions((Iterator<PinInstance>)this.mDevice.getPins());
        }
    }

    protected static class ActionDimensionsSelPorts
    extends ActionDimensions {
        public ActionDimensionsSelPorts(Device d) {
            super("Selected Pin Dimensions", d);
        }

        @Override
        public void display(boolean b) {
            this.mUI.drawPortDimension(DeviceDimensionUI.getSelectedPorts(this.mDevice), b);
        }

        @Override
        public boolean displayed() {
            return this.mUI.isShowPortDimensions(DeviceDimensionUI.getSelectedPorts(this.mDevice));
        }
    }

    protected static class ActionDimensionsDevice
    extends ActionDimensions {
        public ActionDimensionsDevice(Device d) {
            super("Device Dimensions", d);
        }

        @Override
        public void display(boolean b) {
            this.mUI.drawDeviceDimension(b);
        }

        @Override
        public boolean displayed() {
            return this.mUI.isShowDeviceDimension();
        }
    }

    protected static abstract class ActionDimensions
    extends AbstractAction {
        Device mDevice = null;
        AAppView mView = null;
        DeviceDimensionUI mUI = null;

        public ActionDimensions(String name, Device d) {
            super(name);
            this.mDevice = d;
            this.mView = OrbitIO.getCurView();
            this.mUI = DeviceDimensionUI.getDimensionUI(this.mView, this.mDevice);
            this.putValue("SwingSelectedKey", this.mUI != null && this.displayed());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.mUI == null) {
                this.mUI = DeviceDimensionUI.createInstance(this.mView, this.mDevice);
            }
            this.display(!this.displayed());
        }

        public abstract boolean displayed();

        public abstract void display(boolean var1);
    }

    protected static class ActionAssignBumpsToPersonalities
    extends AbstractAction {
        protected final DevicePath mDevicePath;

        public ActionAssignBumpsToPersonalities(DevicePath path) {
            super("Auto-Assign Personalities (Bump Pad)");
            this.putValue("ShortDescription", "Assign personalities for `BUMPPAD` pins");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                Cp.exec((String)"com.sigrity.orbit.ui.PersonalityUI.assignBumpsToPersonalities(\"%s\");", (Object[])new Object[]{this.mDevicePath.toString()});
            }
        }
    }

    protected static class ActionAssignPinsToPersonalities
    extends AbstractAction {
        protected final DevicePath mDevicePath;

        public ActionAssignPinsToPersonalities(DevicePath path) {
            super("Auto-Assign Personalities");
            this.putValue("ShortDescription", "Assign personalities for all pins");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                Cp.exec((String)"com.sigrity.orbit.ui.PersonalityUI.assignPCBPinsToPersonalities(\"%s\");", (Object[])new Object[]{this.mDevicePath.toString()});
            }
        }
    }

    protected static class ActionAssignBallsToPersonalities
    extends AbstractAction {
        protected final DevicePath mDevicePath;

        public ActionAssignBallsToPersonalities(DevicePath path) {
            super("Auto-Assign Personalities (Ball Pad)");
            this.putValue("ShortDescription", "Assign personalities for `BALLPAD` pins");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                Cp.exec((String)"com.sigrity.orbit.ui.PersonalityUI.assignBallsToPersonalities(\"%s\");", (Object[])new Object[]{this.mDevicePath.toString()});
            }
        }
    }

    public static class ActionEditDevice
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionEditDevice(DevicePath path) {
            super("Edit Device");
            this.mDevicePath = path;
            if (this.mDevicePath == null) {
                this.setEnabled(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EditDeviceBoundsMode.create(OrbitIO.getMainWindow(), this.mDevicePath);
        }
    }

    protected static class ActionCenterDevice
    extends AbstractAction {
        DevicePath mDevicePath;

        public ActionCenterDevice(DevicePath path) {
            super("Move Device to Parent Center");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction txt = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                Cp.exec((String)"Device.centerOnParent(\"%s\");", (Object[])new Object[]{this.mDevicePath.toString()});
                OrbitIO.getApp().refreshCurrentView(false);
            }
        }
    }

    protected static class ActionUngroupDevices
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionUngroupDevices(DevicePath path) {
            super("Ungroup", UIUtil.getScaledIcon((Icon)UIManager.getIcon("CDNS.hierarchyDescendIcon"), (int)16, (int)16));
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                Cp.exec((String)"com.sigrity.acl.db.std.Device.unGroup (\"%s\");", (Object[])new Object[]{this.mDevicePath.toString()});
            }
        }
    }

    static class ActionMoveOrigin
    extends AbstractAction {
        private final DevicePath path;
        private final DeviceCommands.ORIGIN_POS pos;

        public ActionMoveOrigin(DevicePath path, DeviceCommands.ORIGIN_POS pos) {
            super(pos.getText(), pos.getIcon());
            this.path = path;
            this.pos = pos;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)"Move Origin");){
                Cp.exec((String)"com.sigrity.orbit.cmd.DeviceCommands.moveDeviceOrigin(curDb(), \"%s\", %s.%s);", (Object[])new Object[]{this.path.escapedString(), DeviceCommands.ORIGIN_POS.class.getName(), this.pos.name()});
            }
        }
    }

    public static class ActionMoveDevice
    extends AbstractAction {
        protected DevicePath mPath;
        protected Device mSrc;

        public ActionMoveDevice(DevicePath path, Device device) {
            super("Move Device to New Parent...");
            this.mSrc = device;
            this.mPath = path;
            if (this.mPath != null && this.mPath.getDevice() != device) {
                throw new IllegalArgumentException("Not match path and device");
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            DevicePath dPath = DevicePathChooser.Dialog.createDialog(OrbitIO.getMainWindow(), this.mSrc.getDb());
            if (dPath == null || dPath.getDeviceTemplate() == null) {
                return;
            }
            if (this.mPath == null) {
                DeviceTemplate dest = dPath.getDeviceTemplate();
                try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                    Object res = Cp.exec((String)"Device.move(curDb(), \"%s\", \"%s\", \"%s\", false)", (Object[])new Object[]{this.mSrc.getParent().getKeyStr(), this.mSrc.getName(), dest.getKeyStr()});
                    if (res == null) return;
                    Device d = (Device)res;
                    ALog.logInfo((String)"Device '%s' created as a child of '%s'.", (Object[])new Object[]{d.getName(), dest.getName()});
                    OrbitIO.refreshViewsOf(d.getDb());
                    if (dest instanceof Design || !d.getIsSubstrate()) return;
                    ContactToParentUI.showUI(d.getADevicePath());
                    return;
                }
            } else {
                DeviceCommands.setDeviceToNewParent(this.mPath.getDb(), this.mPath, dPath);
            }
        }
    }

    public static class ActionCopyDevice
    extends AbstractAction {
        protected Device mSrc;

        public ActionCopyDevice(Device device) {
            super("Copy Device to New Parent...");
            this.mSrc = device;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DevicePath dPath = DevicePathChooser.Dialog.createDialog(OrbitIO.getMainWindow(), this.mSrc.getDb());
            if (dPath == null || dPath.getDeviceTemplate() == null) {
                return;
            }
            DeviceTemplate dest = dPath.getDeviceTemplate();
            Object res = null;
            try (DbHistory.DbTransaction txt = DbHistory.newDbTransaction((Db)dest.getDb(), (AbstractAction)this);){
                res = Cp.exec((String)"Device.copy(curDb(), \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{this.mSrc.getParent().getKeyStr(), this.mSrc.getName(), dest.getKeyStr()});
            }
            if (res != null) {
                Device d = (Device)res;
                ALog.logInfo((String)"Device '%s' created as a child of '%s'.", (Object[])new Object[]{d.getName(), dest.getName()});
                OrbitIO.refreshViewsOf(OrbitIO.getCurDb());
                if (!(dest instanceof Design) && d.getIsSubstrate()) {
                    ContactToParentUI.showUI(d.getADevicePath());
                }
            }
        }
    }

    public static class ActionShowRatsOnDevice
    extends AbstractAction {
        Selection mSelection;

        public ActionShowRatsOnDevice(Selection selection) {
            Db db = selection.getDb();
            int selDeviceCount = selection.getCount(db.getDbClass(Device.class));
            this.putValue("Name", String.format("Show Connections on (%d)", selDeviceCount));
            String tooltip = new HConnEngine.ShowOnDevicesOrPins().getDescription();
            this.putValue("ShortDescription", tooltip);
            this.mSelection = selection;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)"Show Connections On Selected Devices");){
                Cp.exec((String)"_show = new com.sigrity.acl.edaMgrs.HConnEngine.ShowOnDevicesOrPins();", (Object[])new Object[0]);
                for (HierInst hierDevice : this.mSelection.getSelectedHierInsts(Device.class)) {
                    DevicePath path = hierDevice.getPath().withChild((Device)hierDevice.getDbObject());
                    Cp.exec((String)"_show.addDevicePath(\"%s\");", (Object[])new Object[]{path.escapedString()});
                }
                Cp.exec((String)"_show.showOn();", (Object[])new Object[0]);
                Cp.exec((String)"unset(\"_show\");", (Object[])new Object[0]);
                OrbitIO.getApp().refreshCurrentView(false);
            }
        }
    }

    public static class ActionShowRatsBetweenN
    extends AbstractAction {
        Selection mSelection;

        public ActionShowRatsBetweenN(Selection selection) {
            super("", OrbitIcons.SHOW_RATS);
            Db db = selection.getDb();
            int selDeviceCount = selection.getCount(db.getDbClass(Device.class));
            this.putValue("Name", String.format("Show Connections between (%d)", selDeviceCount));
            String tooltip = new HConnEngine.ShowOnOrBetweenDevices().getDescription();
            this.putValue("ShortDescription", tooltip);
            this.mSelection = selection;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)"Show Connections Between Selected Devices");){
                Cp.exec((String)"_show = new com.sigrity.acl.edaMgrs.HConnEngine.ShowOnOrBetweenDevices();", (Object[])new Object[0]);
                for (HierInst d : this.mSelection.getSelectedHierInsts(Device.class)) {
                    Cp.exec((String)"_show.addDevicePath(\"%s\");", (Object[])new Object[]{new DevicePath(d.getPath(), (Device)d.getDbObject()).escapedString()});
                }
                Cp.exec((String)"_show.showOn();", (Object[])new Object[0]);
                Cp.exec((String)"unset(\"_show\");", (Object[])new Object[0]);
                OrbitIO.getApp().refreshCurrentView(false);
            }
        }
    }

    private static class SpaceDriversDlg
    extends DbDialog {
        protected Unit mUnit;
        protected JTextField mTxtSpace;
        protected Device mRefDriver;
        protected DevicePath mRefDriverPath;
        private boolean mXAsRef;
        protected ActionListener mApplyListener = e -> {
            try {
                this.apply();
            }
            catch (AFieldValidator.AFieldValidationException fve) {
                ALog.logDebug((Throwable)fve, (String)"?", (Object[])new Object[0]);
            }
        };

        protected void apply() throws AFieldValidator.AFieldValidationException {
            long spacing = this.mUnit.fromUserString(AFieldValidator.validateDouble((JTextField)this.mTxtSpace));
            Cp.exec((String)"com.sigrity.orbit.UserCommands.spaceSelectedIODrivers(curDb(), \"%s\", \"%s\", %dL, %s);", (Object[])new Object[]{this.mRefDriver.getKeyStr(), this.mRefDriverPath.escapedString(), spacing, Boolean.toString(this.mXAsRef)});
        }

        protected SpaceDriversDlg(Component uiOwner, Db db, AAppView view, Device refDriver, DevicePath refDriverPath, boolean xAsRef) {
            super(db, uiOwner);
            this.mRefDriver = refDriver;
            this.mRefDriverPath = refDriverPath;
            this.mUnit = view.getUnit();
            this.mXAsRef = xAsRef;
            String title = "Space IO Drivers By " + (this.mXAsRef ? "X" : "Y");
            this.setTitle(title);
            GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
            String refText = refDriver.getName();
            l.add("Anchor Device: ", (GridBagConstraints)GridBagManager.LEFT);
            l.add(refText, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            l.add("Spacing:", (GridBagConstraints)GridBagManager.LEFT);
            this.mTxtSpace = (JTextField)l.add((Component)new JTextField(10));
            this.mTxtSpace.setText("0");
            l.addFillY();
            l.pushFillXRemainX();
            l.addFillX();
            JButton btnApply = (JButton)l.add((Component)new JButton("Apply"), (GridBagConstraints)GridBagManager.RIGHT);
            JButton btnClose = (JButton)l.add((Component)new JButton("Close"), (GridBagConstraints)GridBagManager.RIGHT);
            btnApply.addActionListener(this.mApplyListener);
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, (JButton)btnApply);
            this.pack();
            UIUtil.center((Component)((Object)this));
        }
    }

    public static class ActionRespaceIODrivers
    extends AbstractAction {
        protected Device mRefDriver;
        protected DevicePath mRefDriverPath;
        private boolean mXAsRef;

        public ActionRespaceIODrivers(Device refDriver, DevicePath driverPath, boolean xAsRef) {
            this.mRefDriver = refDriver;
            this.mRefDriverPath = driverPath;
            this.mXAsRef = xAsRef;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SpaceDriversDlg dlg = new SpaceDriversDlg(OrbitIO.getMainWindow(), OrbitIO.getCurDb(), OrbitIO.getCurView(), this.mRefDriver, this.mRefDriverPath, this.mXAsRef);
            dlg.setVisible(true);
        }
    }

    public static class ActionAlignIODrivers
    extends AbstractAction {
        protected Device mRefDriver;
        protected Device mDriver;
        protected DevicePath mRefDriverPath;
        protected DevicePath mDriverPath;

        public ActionAlignIODrivers(Device refDriver, DevicePath refDevicePath, Device driver, DevicePath refDriverPath) {
            super("Align IO Drivers");
            this.mRefDriver = refDriver;
            this.mDriver = driver;
            this.mRefDriverPath = refDevicePath;
            this.mDriverPath = refDriverPath;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                Cp.exec((String)"com.sigrity.orbit.UserCommands.alignIODrivers(curDb(), \"%s\", \"%s\", \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{this.mRefDriver.getKeyStr(), this.mRefDriverPath.escapedString(), this.mDriver.getKeyStr(), this.mDriverPath.escapedString(), "IOpad center"});
            }
        }
    }

    public static class ActionSwapIODrivers
    extends AbstractAction {
        protected Device mDriver1;
        protected Device mDriver2;
        protected DevicePath mDiePath;

        public ActionSwapIODrivers(Device driver1, Device driver2, DevicePath diePath) {
            super("Swap IO Drivers");
            this.mDriver1 = driver1;
            this.mDriver2 = driver2;
            this.mDiePath = diePath;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec((String)"com.sigrity.orbit.UserCommands.swapIODrivers(curDb(), \"%s\", \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{this.mDriver1.getKeyStr(), this.mDriver2.getKeyStr(), this.mDiePath.escapedString(), "IOpad center"});
        }
    }

    public static class ActionAlignToBumpsOrBalls
    extends AbstractAction {
        protected DevicePath mDevPath;
        protected long mWorldPointX;
        protected long mWorldPointY;

        public ActionAlignToBumpsOrBalls(DevicePath path, long worldPointX, long worldPointY) {
            this.mDevPath = path;
            this.mWorldPointX = worldPointX;
            this.mWorldPointY = worldPointY;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                Cp.exec((String)"com.sigrity.orbit.UserCommands.alignSelectedToBumpsOrBalls(curDb(), \"%s\", %dL, %dL)", (Object[])new Object[]{this.mDevPath.escapedString(), this.mWorldPointX, this.mWorldPointY});
            }
        }
    }

    public static class ActionAlignSelectedIODriversWithConnected
    extends AbstractAction {
        private DevicePath mDevPath;
        private boolean mDoReschedule;

        public ActionAlignSelectedIODriversWithConnected(DevicePath path, boolean reschedule) {
            this.mDevPath = path;
            this.mDoReschedule = reschedule;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean status;
            DevicePath substratePath = this.mDevPath.pathToSubstrate();
            if (substratePath.getDevice().isDie() && !(status = DriverRespacerUI.showMe(OrbitApp.getCurDb(), substratePath.escapedString()))) {
                return;
            }
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                Cp.exec((String)"com.sigrity.orbit.UserCommands.alignSelectedTo(curDb(), \"%s\", %s)", (Object[])new Object[]{this.mDevPath.escapedString(), this.mDoReschedule});
            }
        }
    }

    public static class ActionSelectedIODriversOfSelectedConnections
    extends AbstractAction {
        protected DevicePath mDevPath;

        public ActionSelectedIODriversOfSelectedConnections(DevicePath path) {
            this.mDevPath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec((String)"com.sigrity.orbit.UserCommands.selectDriversConnectedToSelectedConnections(curDb(), \"%s\")", (Object[])new Object[]{this.mDevPath.escapedString()});
        }
    }

    public static class ActionRatsFrom1
    extends AbstractAction {
        final HierInst<Device> mDevInst;

        public ActionRatsFrom1(HierInst<Device> devInst) {
            super(String.format("Show Connections on '%s'", ((Device)devInst.getDbObject()).getName()), OrbitIcons.SHOW_RATS);
            String tooltip = new HConnEngine.ShowOnOrBetweenDevices().getDescription();
            this.putValue("ShortDescription", tooltip);
            this.mDevInst = devInst.copy();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)"Show Connections From One Device");){
                Cp.exec((String)"_show = new com.sigrity.acl.edaMgrs.HConnEngine.ShowOnOrBetweenDevices();", (Object[])new Object[0]);
                Cp.exec((String)"_show.addDevicePath(\"%s\");", (Object[])new Object[]{new DevicePath(this.mDevInst.getPath(), (Device)this.mDevInst.getDbObject()).escapedString()});
                Cp.exec((String)"_show.showOn();", (Object[])new Object[0]);
                Cp.exec((String)"unset(\"_show\");", (Object[])new Object[0]);
                OrbitIO.getApp().refreshCurrentView(false);
            }
        }
    }

    public static class ActionGroupDevices
    extends AbstractAction {
        private final Selection selection;

        public ActionGroupDevices(Selection selection) {
            super(String.format("Group Devices (%d)", selection.getCount(Device.class)), UIUtil.getScaledIcon((Icon)UIManager.getIcon("CDNS.hierarchyAscendIcon"), (int)16, (int)16));
            this.selection = selection;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                if (this.selection != null && this.selection != OrbitIO.getCurDesign().getCurSelection()) {
                    CpHelper.cpClearSelection();
                    CpHelper.cpHierSelect(this.selection.getSelectedHierInsts(Device.class));
                }
                Cp.exec((String)"com.sigrity.orbit.ui.DeviceTemplateUI.groupSelected()", (Object[])new Object[0]);
            }
        }
    }

    public static class ActionAlign
    extends AbstractAction {
        private long mRefX;
        private long mRefY;
        private boolean mCommonX;
        String mStrType;

        private ActionAlign(long refX, long refY, boolean commonX, ALIGN_DIR dir) {
            super(dir.text, dir.icon);
            if (dir == ALIGN_DIR.CENTER) {
                this.putValue("SmallIcon", commonX ? OrbitIcons.ALIGN_CENTER_X : OrbitIcons.ALIGN_CENTER_Y);
            }
            this.mCommonX = commonX;
            this.mStrType = dir.command;
            this.mRefX = refX;
            this.mRefY = refY;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (AbstractAction)this);){
                Cp.exec((String)"com.sigrity.orbit.UserCommands.alignSelected(curDb(), %s, \"%s\", %dL, %dL)", (Object[])new Object[]{Boolean.toString(this.mCommonX), this.mStrType, this.mRefX, this.mRefY});
            }
        }

        public static enum ALIGN_DIR {
            LEFT("left edge", "left", OrbitIcons.ALIGN_LEFT),
            RIGHT("right edge", "right", OrbitIcons.ALIGN_RIGHT),
            CENTER("center", "center", null),
            ORIGIN("origin", "origin", null),
            BOTTOM("bottom edge", "bottom", OrbitIcons.ALIGN_BOTTOM),
            TOP("top edge", "top", OrbitIcons.ALIGN_TOP),
            PIN_CENTER("pin center", "pin center", null);

            public final String text;
            public final String command;
            public final Icon icon;

            private ALIGN_DIR(String text, String command, Icon icon) {
                this.text = text;
                this.command = command;
                this.icon = icon;
            }

            public static ALIGN_DIR valueFromCommand(String command) {
                for (ALIGN_DIR d : ALIGN_DIR.values()) {
                    if (!d.command.equals(command)) continue;
                    return d;
                }
                return null;
            }
        }
    }

    public static class ActionAutoBundleDevice
    extends AbstractAction {
        Device d1;
        Device d2;

        public ActionAutoBundleDevice(Device d1, Device d2) {
            super("Auto Bundle between (2)");
            this.d1 = d1;
            this.d2 = d2;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AutoBundleNetUI.go(this.d1.getKeyStr(), this.d2.getKeyStr());
        }
    }
}

