/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Scribe;
import com.sigrity.acl.db.std.SealRing;
import com.sigrity.acl.db.std.SiliconRemainder;
import com.sigrity.acl.ui.AComponentTitledBorder;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.ScribePanelUI;
import com.sigrity.orbit.ui.SealRingPanelUI;
import com.sigrity.orbit.ui.SiliconRemainderPanelUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;

public class DieExtentsUI
extends ADialog {
    protected final DeviceTemplate mDieDevT;
    protected DieExtentPanel mDieExtentPanel;
    private ActionListener mOkListener = ae -> {
        this.mDieExtentPanel.apply();
        UIUtil.closeWindow((Window)((Object)this));
    };

    public static DieExtentsUI showDialog(Device die) {
        return DieExtentsUI.showDialog(die == null ? null : die.getTemplate());
    }

    public static DieExtentsUI showDialog(DeviceTemplate die) {
        if (die == null || !die.isDie()) {
            throw new IllegalArgumentException(String.format("Invalid device type for '%s', should be DIE", die));
        }
        DieExtentsUI ui = new DieExtentsUI(OrbitIO.getMainWindow(), die);
        ui.setVisible(true);
        return ui;
    }

    public static Action getAction(final DeviceTemplate devT) {
        return new AbstractAction("Edit Die Extents"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DieExtentsUI.showDialog(devT);
            }
        };
    }

    protected DieExtentsUI(Window owner, DeviceTemplate dieDevT) {
        super(owner, "Die Extents");
        this.mDieDevT = dieDevT;
        this.mDieExtentPanel = new DieExtentPanel(dieDevT);
        GridBagManager l = new GridBagManager((Container)((Object)this));
        l.add((Component)this.mDieExtentPanel, (GridBagConstraints)GridBagManager.FILLALL);
        l.newline();
        this.addOKAction(l);
        this.pack();
        this.setMinimumSize(this.getMinimumSize());
        UIUtil.center((Component)((Object)this));
    }

    protected void addOKAction(GridBagManager l) {
        l.pushFillXRemainX();
        l.addFillX();
        JButton btnOK = (JButton)l.add((Component)new JButton("OK"));
        btnOK.addActionListener(this.mOkListener);
        JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
        l.pop();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOK);
    }

    public static class DieExtentPanel
    extends JPanel {
        protected DeviceTemplate mDieDevT;
        protected JPanel mPnlScribe;
        protected JCheckBox mCbScribe;
        protected ScribePanelUI mScribePanelUI;
        protected JPanel mPnlSealRing;
        protected JCheckBox mCbSealRing;
        protected SealRingPanelUI mSealRingPanelUI;
        protected JPanel mPnlSiliconRemainder;
        protected JCheckBox mCbSiliconRemainder;
        protected SiliconRemainderPanelUI mSiliconRemainderUI;
        private ChangeListener mScribeListener = ae -> {
            boolean isSelected = this.mCbScribe.isSelected();
            this.mScribePanelUI.setContentsEnabled(isSelected);
        };
        private ChangeListener mSealRingListener = ae -> {
            boolean isSelected = this.mCbSealRing.isSelected();
            this.mSealRingPanelUI.setContentsEnabled(isSelected);
        };
        private ChangeListener mSiliconRemainderListener = ae -> {
            boolean isSelected = this.mCbSiliconRemainder.isSelected();
            this.mSiliconRemainderUI.setContentsEnabled(isSelected);
        };

        public DieExtentPanel(DeviceTemplate devT) {
            this.mDieDevT = devT;
            GridBagManager l = new GridBagManager((Container)this);
            this.addScribe(l);
            this.addSealRing(l);
            this.addSiliconRemainder(l);
            this.fillScribeIfExist();
            this.fillSealRingIfExist();
            this.fillSiliconRemaidnerIfExist();
        }

        protected void addScribe(GridBagManager l) {
            this.mCbScribe = new JCheckBox("Scribe Line");
            this.mCbScribe.addChangeListener(this.mScribeListener);
            this.mPnlScribe = l.push("Scribe", (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            this.mPnlScribe.setBorder(new AComponentTitledBorder(this.mCbScribe, this.mPnlScribe));
            this.mScribePanelUI = new ScribePanelUI(Design.getDesign((Db)OrbitIO.getCurDb()));
            l.add((Component)this.mScribePanelUI, (GridBagConstraints)GridBagManager.FILLX);
            this.mScribePanelUI.setContentsEnabled(false);
            l.popNl();
        }

        protected void addSealRing(GridBagManager l) {
            this.mCbSealRing = new JCheckBox("Seal Ring");
            this.mCbSealRing.addChangeListener(this.mSealRingListener);
            this.mPnlSealRing = l.push("Seal Ring", (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            this.mPnlSealRing.setBorder(new AComponentTitledBorder(this.mCbSealRing, this.mPnlSealRing));
            this.mSealRingPanelUI = new SealRingPanelUI(Design.getDesign((Db)OrbitIO.getCurDb()));
            l.add((Component)this.mSealRingPanelUI, (GridBagConstraints)GridBagManager.FILLX);
            this.mSealRingPanelUI.setContentsEnabled(false);
            l.popNl();
        }

        protected void addSiliconRemainder(GridBagManager l) {
            this.mCbSiliconRemainder = new JCheckBox("Silicon Remainder");
            this.mCbSiliconRemainder.addChangeListener(this.mSiliconRemainderListener);
            this.mPnlSiliconRemainder = l.push("Silicon Remainder", (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            this.mPnlSiliconRemainder.setBorder(new AComponentTitledBorder(this.mCbSiliconRemainder, this.mPnlSiliconRemainder));
            this.mSiliconRemainderUI = new SiliconRemainderPanelUI(Design.getDesign((Db)OrbitIO.getCurDb()));
            l.add((Component)this.mSiliconRemainderUI, (GridBagConstraints)GridBagManager.FILLX);
            this.mSiliconRemainderUI.setContentsEnabled(false);
            l.popNl();
        }

        protected void fillScribeIfExist() {
            Scribe scribe = this.mDieDevT.getScribe();
            if (scribe != null) {
                this.mCbScribe.setSelected(true);
                this.mScribePanelUI.initValues(scribe);
            }
        }

        protected void fillSealRingIfExist() {
            SealRing ring = this.mDieDevT.getSealRing();
            if (ring != null) {
                this.mCbSealRing.setSelected(true);
                this.mSealRingPanelUI.initValues(ring);
            }
        }

        protected void fillSiliconRemaidnerIfExist() {
            SiliconRemainder remainder = this.mDieDevT.getSiliconRemainder();
            if (remainder != null) {
                this.mCbSiliconRemainder.setSelected(true);
                this.mSiliconRemainderUI.initValues(remainder);
            }
        }

        public void apply() {
            if (!this.validateFields()) {
                return;
            }
            if (this.mDieDevT == null || this.mDieDevT.getType() != DeviceTemplate.Type.DIE) {
                return;
            }
            this.mScribePanelUI.updateDB(this.mCbScribe.isSelected(), this.mDieDevT);
            this.mSealRingPanelUI.updateDB(this.mCbSealRing.isSelected(), this.mDieDevT);
            this.mSiliconRemainderUI.updateDB(this.mCbSiliconRemainder.isSelected(), this.mDieDevT);
        }

        public void setContentsEnabled(boolean b) {
            this.mScribePanelUI.setContentsEnabled(b);
            this.mSealRingPanelUI.setContentsEnabled(b);
            this.mSiliconRemainderUI.setContentsEnabled(b);
        }

        public void setDeviceTemplate(DeviceTemplate devT) {
            this.mDieDevT = devT;
        }

        public boolean validateFields() {
            if (this.mCbScribe.isSelected() && !this.mScribePanelUI.validateFields()) {
                return false;
            }
            if (this.mCbSealRing.isSelected() && !this.mSealRingPanelUI.validateFields()) {
                return false;
            }
            return !this.mCbSiliconRemainder.isSelected() || this.mSiliconRemainderUI.validateFields();
        }
    }
}

