/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.Dimensions;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.dbui.render.LayerListRenderer;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.ui.AColorChooserDlg;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.AFloatWindow;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.canvas_modes.RulerMode;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.JTextComponent;

public class DimensionsUI {
    public static final String DESIGN = "<Design>";
    public static final String DIMUI_NO_LAYER_MSG = "No valid Artwork layer found. Create an Artwork layer on the device substrate to display the Dimensions object.";

    protected DimensionsUI() {
    }

    public static DimensionsDlg createDlg(Window owner, Db db, DevicePath devPath) {
        return new DimensionsDlg(owner, db, devPath);
    }

    public static class ActionDimsDevice
    extends AbstractAction {
        protected final DevicePath mDevicePath;

        public ActionDimsDevice(DevicePath path, String str) {
            super(str == null ? "Dimensions..." : str);
            this.mDevicePath = path;
            this.setEnabled(this.mDevicePath != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DimensionsUI.createDlg(OrbitIO.getMainWindow(), OrbitApp.getCurDb(), this.mDevicePath);
        }
    }

    public static class EditDimensionsDlg
    extends DbDialog
    implements RulerMode.SubMode {
        protected DevicePath mDevPath;
        protected Device mDev;
        protected Dimensions mDim;
        protected int mNewLayerOrder = -1;
        protected DesignView2D.ViewMode mOldMode = null;
        protected RulerMode mRulerMode = null;
        protected LinkedList<Component> mContextMenu = null;
        protected boolean mSavedData = false;
        protected JTextField mDimDesc;
        protected JComboBox<Layer> mCboLayer;
        protected JSpinner mSpinSize;
        protected JCheckBox mChkDefaultSize;
        protected JButton mBtnColor;
        protected JRadioButton mRadDevice;
        protected JRadioButton mRadFree;
        protected JCheckBox mChkKeep;
        protected JButton mBtnOk;
        protected JButton mBtnCancel;

        public static EditDimensionsDlg create(Component owner, DevicePath devPath, Dimensions dim) {
            if (devPath == null || devPath.getDevice() == null) {
                String msg = "A path to a Device instance must be provided.";
                ALog.logError((Throwable)new IllegalArgumentException(msg), (String)msg, (Object[])new Object[0]);
                return null;
            }
            return new EditDimensionsDlg(owner, devPath, dim);
        }

        protected EditDimensionsDlg(Component owner, DevicePath devPath, Dimensions dim) {
            super(devPath.getLast().getDb(), owner);
            this.mDevPath = devPath;
            this.mDev = devPath.getLast();
            this.mDim = dim;
            this.setTitle("Dimensions for device " + this.mDev.getName());
            GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
            l.push("Dimensions", (GridBagConstraints)GridBagManager.LEFT);
            l.add("Id:");
            this.mDimDesc = (JTextField)l.add((Component)new JTextField(20), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            l.newline();
            l.add("Layer:");
            this.mCboLayer = (JComboBox)l.add(new JComboBox());
            this.mCboLayer.setRenderer(new LayerListRenderer());
            this.updateLayerCombo(this.mDev.getSubstrate(), this.mCboLayer);
            l.newline();
            l.add("Text size");
            SpinnerNumberModel sm = new SpinnerNumberModel(24, 0, 100, 1);
            this.mSpinSize = new JSpinner(sm);
            this.mSpinSize.setToolTipText("Set the size of the text");
            l.add((Component)this.mSpinSize);
            this.mChkDefaultSize = (JCheckBox)l.addNl((Component)new JCheckBox("Use best-fit size"));
            this.mChkDefaultSize.setToolTipText("Use a varying size based on zoom level");
            this.mChkDefaultSize.addItemListener(e -> this.mSpinSize.setEnabled(!this.mChkDefaultSize.isSelected()));
            l.add("Color");
            this.mBtnColor = (JButton)l.addNl((Component)new JButton());
            this.mBtnColor.setPreferredSize(new Dimension(25, 25));
            this.mBtnColor.setBackground(Color.blue);
            this.mBtnColor.setToolTipText("Edit the text color");
            this.mBtnColor.addActionListener(e -> {
                AColorChooserDlg ccd = AColorChooserDlg.createDialog((Component)((Object)this), "Select Color", Color.red);
                ccd.setShowOpacity(true);
                Color c = ccd.doModal();
                this.mBtnColor.setBackground(c);
            });
            this.mRadDevice = (JRadioButton)l.add((Component)new JRadioButton("Device Dimensions"));
            this.mRadDevice.setToolTipText("Dimensions for device");
            this.mRadDevice.addItemListener(e -> this.mChkKeep.setEnabled(!this.mRadDevice.isSelected() && this.mDim != null && this.mDim.getDimensionsType() != Dimensions.DimensionsType.Device));
            this.mRadFree = (JRadioButton)l.add((Component)new JRadioButton("Freestyle"));
            this.mRadFree.setToolTipText("Dimensions between 2 points");
            this.mRadFree.addItemListener(e -> this.mChkKeep.setEnabled(this.mRadFree.isSelected() && this.mDim != null && this.mDim.getDimensionsType() != Dimensions.DimensionsType.Device));
            UIUtil.groupButtons((AbstractButton[])new AbstractButton[]{this.mRadDevice, this.mRadFree});
            this.mChkKeep = (JCheckBox)l.add((Component)new JCheckBox("Keep existing"));
            this.mChkKeep.setToolTipText("Keep existing freestyle dimensions");
            l.pop();
            l.newline();
            l.pushFillXRemainX();
            l.addFillX();
            this.mBtnOk = (JButton)l.add((Component)new JButton("OK"));
            this.mBtnOk.setEnabled(true);
            if (this.mCboLayer.getSelectedItem() == null) {
                JOptionPane.showMessageDialog(null, DimensionsUI.DIMUI_NO_LAYER_MSG);
                this.mBtnOk.setEnabled(false);
            }
            this.mBtnCancel = (JButton)l.add((Component)new JButton("Cancel"));
            l.pop();
            this.mBtnOk.addActionListener(e -> {
                if (!this.validateData()) {
                    return;
                }
                String desc = this.mDimDesc.getText();
                Layer layer = (Layer)this.mCboLayer.getSelectedItem();
                int size = this.mChkDefaultSize.isSelected() ? 24 : (Integer)this.mSpinSize.getValue();
                Color col = this.mBtnColor.getBackground();
                int type = this.mRadDevice.isSelected() ? 0 : 1;
                APair pts = null;
                if (layer == null) {
                    ALog.logInfo((String)DimensionsUI.DIMUI_NO_LAYER_MSG);
                    return;
                }
                if (this.mDim != null) {
                    Cp.exec((String)"_dim = %s;", (Object[])new Object[]{CpHelper.getObjCmdStr(this.mDim)});
                    if (this.mChkKeep.isEnabled() && this.mChkKeep.isSelected()) {
                        pts = this.mDim.getPoints();
                    }
                    Cp.exec((String)"_dim.deleteFromDb()", (Object[])new Object[0]);
                }
                this.mDim = (Dimensions)Cp.exec((String)"Dimensions.create(curDb(), \"Device\", \"%s\", \"%s\", \"%s\", null, %d, \"%s\", %d, %d);", (Object[])new Object[]{this.mDev.getKeyStr(), layer.getSubstrate().getKeyStr(), layer.getName(), type, desc, size, col.getRGB()});
                if (pts != null) {
                    Cp.exec((String)"_dim = %s;", (Object[])new Object[]{CpHelper.getObjCmdStr(this.mDim)});
                    Cp.exec((String)"_dim.setPoints(%dL, %dL, %dL, %dL);", (Object[])new Object[]{((APoint2D)pts.first).getX(), ((APoint2D)pts.first).getY(), ((APoint2D)pts.second).getX(), ((APoint2D)pts.second).getY()});
                    Cp.exec((String)"unset(\"_dim\");", (Object[])new Object[0]);
                }
                this.mSavedData = true;
                UIUtil.closeWindow((Window)((Object)this));
                if (!(!this.mRadFree.isSelected() || this.mChkKeep.isSelected() && this.mChkKeep.isEnabled())) {
                    this.startRulerMode();
                }
                OrbitIO.getApp().refreshCurrentView(false);
            });
            if (this.mDim != null) {
                this.mDimDesc.setText(Dimensions.removeHtml((String)this.mDim.getId()));
                this.mCboLayer.setSelectedItem(this.mDim.getLayer());
                this.mRadDevice.setSelected(this.mDim.getDimensionsType() == Dimensions.DimensionsType.Device);
                this.mRadFree.setSelected(!this.mRadDevice.isSelected());
                this.mChkKeep.setEnabled(this.mRadFree.isSelected() && this.mDim.getDimensionsType() != Dimensions.DimensionsType.Device);
                this.mChkDefaultSize.setSelected(true);
                int size = Dimensions.getSize((Dimensions)this.mDim);
                if (size != 24) {
                    this.mSpinSize.setValue(Dimensions.getSize((Dimensions)this.mDim));
                    this.mSpinSize.setEnabled(true);
                    this.mChkDefaultSize.setSelected(false);
                }
            } else {
                this.mChkKeep.setEnabled(false);
                this.mRadDevice.setSelected(true);
                this.mSpinSize.setEnabled(false);
                this.mChkDefaultSize.setSelected(true);
            }
            this.mChkKeep.setSelected(true);
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)this.mBtnCancel, (JButton)this.mBtnOk);
            this.pack();
            this.setMinimumSize(this.getPreferredSize());
            UIUtil.center((Component)((Object)this));
        }

        private void startRulerMode() {
            DesignView2D v = (DesignView2D)OrbitIO.getCurView();
            this.mOldMode = v.getCurMode();
            this.mRulerMode = new RulerMode();
            this.mRulerMode.startSubMode(this);
            v.setMode(this.mRulerMode);
        }

        @Override
        public List<Component> getContextMenu(Point loc) {
            if (this.mContextMenu != null) {
                return this.mContextMenu;
            }
            this.mContextMenu = new LinkedList();
            this.mContextMenu.add(new JSeparator());
            this.mContextMenu.add(new JMenuItem(new AbstractAction("End & Commit Dimensions"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    APoint2D st = mRulerMode.getStartPt();
                    APoint2D end = mRulerMode.getEndPt();
                    AFloatWindow win = mRulerMode.getWindow();
                    Cp.exec((String)"_dim = %s;", (Object[])new Object[]{CpHelper.getObjCmdStr(mDim)});
                    Cp.exec((String)"_dim.setPoints( %dL, %dL, %dL, %dL);", (Object[])new Object[]{st.getX(), st.getY(), end.getX(), end.getY()});
                    Cp.exec((String)"unset(\"_dim\");", (Object[])new Object[0]);
                    DesignView2D v = (DesignView2D)OrbitIO.getCurView();
                    mRulerMode.endSubmode();
                    UIUtil.closeWindow((Window)((Object)win));
                    v.setMode(mOldMode);
                    OrbitIO.getApp().refreshCurrentView(true);
                }
            }));
            this.mContextMenu.add(new JSeparator());
            return this.mContextMenu;
        }

        public boolean doModal() {
            this.setModal(true);
            this.setVisible(true);
            return this.mSavedData;
        }

        public Dimensions getDimension() {
            return this.mDim;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected boolean validateData() {
            try {
                AFieldValidator.validateText((JTextComponent)this.mDimDesc);
                String newDesc = this.mDimDesc.getText();
                if (this.mDim != null && newDesc.equals(this.mDim.getId())) return true;
            }
            catch (AFieldValidator.AFieldValidationException e) {
                return false;
            }
            return true;
        }

        protected void updateLayerCombo(Substrate s, JComboBox<Layer> box) {
            ArrayList<Layer> sortedLayers = new ArrayList<Layer>();
            for (Layer l : s.getLayers()) {
                sortedLayers.add(l);
            }
            if (!sortedLayers.isEmpty()) {
                Collections.sort(sortedLayers);
                Collections.reverse(sortedLayers);
                for (Layer l : sortedLayers) {
                    box.addItem(l);
                }
            }
        }
    }

    protected static class DimListModel
    extends AbstractListModel<Dimensions> {
        protected ArrayList<Dimensions> mDims = new ArrayList();

        protected DimListModel() {
        }

        @Override
        public int getSize() {
            return this.mDims.size();
        }

        @Override
        public Dimensions getElementAt(int index) {
            return this.mDims.get(index);
        }

        public void clear() {
            int size = this.mDims.size();
            if (size == 0) {
                return;
            }
            this.mDims.clear();
            this.fireIntervalRemoved(this, 0, size - 1);
        }

        public void addDims(Dimensions t) {
            int index = this.mDims.size();
            this.mDims.add(t);
            this.fireIntervalAdded(this, index, index);
        }
    }

    public static class DimListCellRenderer
    extends JLabel
    implements ListCellRenderer<Dimensions> {
        @Override
        public Component getListCellRendererComponent(JList<? extends Dimensions> list, Dimensions value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (!(value instanceof Dimensions)) {
                this.setText((String)(value == null ? "" : "" + value));
                return this;
            }
            Dimensions dim = value;
            Color color = Dimensions.getColor((Dimensions)dim);
            this.setForeground(color);
            this.setOpaque(true);
            this.setText(Dimensions.removeHtml((String)dim.getId()));
            return this;
        }
    }

    public static class DimensionsDlg
    extends DbDialog {
        protected Device mDev;
        protected DevicePath mDevPath;
        protected JList<Dimensions> mDimList = new JList();
        protected DimListModel mDims = new DimListModel();
        protected JButton mBtnAdd;
        protected JButton mBtnEdit;
        protected JButton mBtnDelete;

        public DimensionsDlg(Window owner, Db db, DevicePath devPath) {
            super(db, (Component)owner);
            this.mDevPath = devPath;
            this.mDev = devPath.getLast();
            this.setTitle("Dimensions for " + this.mDev.getName());
            GridBagManager l = new GridBagManager(this.getContentPane());
            l.newline();
            l.addNl("Dimensions:", (GridBagConstraints)GridBagManager.LEFT.insetBottom(0));
            this.mDimList = new JList<Dimensions>(this.mDims);
            JScrollPane spLayers = new JScrollPane(this.mDimList);
            l.add((Component)spLayers, (GridBagConstraints)GridBagManager.FILLALL);
            this.mDimList.setCellRenderer(new DimListCellRenderer());
            this.mDimList.setSelectionMode(0);
            this.mDimList.addListSelectionListener(e -> this.enableButtons());
            this.mDimList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1 && e.getClickCount() == 2) {
                        mBtnEdit.doClick();
                    }
                }
            });
            l.newline();
            l.push((GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
            GridBagManager.GridBagConstraintsEx btnCs = GridBagManager.LEFT.insetTop(0).insetBottom(12);
            l.addFillX();
            this.mBtnAdd = new JButton("Add...");
            this.mBtnAdd.setMargin(new Insets(1, 0, 1, 0));
            this.mBtnAdd.setToolTipText("Add new dimensions");
            this.mBtnAdd.addActionListener(e -> {
                EditDimensionsDlg dlg = EditDimensionsDlg.create(this.mBtnAdd, this.mDevPath, null);
                if (dlg != null && dlg.doModal()) {
                    this.updateDimList();
                    this.mDimList.setSelectedValue(dlg.getDimension(), true);
                }
            });
            l.add((Component)this.mBtnAdd, (GridBagConstraints)btnCs);
            this.mBtnEdit = new JButton("Edit...");
            this.mBtnEdit.setMargin(new Insets(1, 0, 1, 0));
            this.mBtnEdit.setToolTipText("Edit the selected dimensions");
            this.mBtnEdit.addActionListener(e -> {
                EditDimensionsDlg dlg = EditDimensionsDlg.create(this.mBtnAdd, this.mDevPath, this.getDimension());
                if (dlg != null && dlg.doModal()) {
                    this.updateDimList();
                    this.mDimList.setSelectedValue(dlg.getDimension(), true);
                }
            });
            l.add((Component)this.mBtnEdit, (GridBagConstraints)btnCs);
            this.mBtnDelete = new JButton("Delete");
            this.mBtnDelete.setMargin(new Insets(1, 0, 1, 0));
            this.mBtnDelete.setToolTipText("Delete the selected dimensions");
            this.mBtnDelete.addActionListener(e -> {
                Dimensions t = this.getDimension();
                int idx = this.mDimList.getSelectedIndex();
                try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)"Delete Dimension");){
                    Cp.exec((String)"%s.deleteFromDb();", (Object[])new Object[]{CpHelper.getObjCmdStr(t)});
                }
                this.updateDimList();
                if (idx >= this.mDims.getSize()) {
                    --idx;
                }
                if (idx >= 0) {
                    this.mDimList.setSelectedIndex(idx);
                }
                OrbitIO.getApp().refreshCurrentView(false);
            });
            l.add((Component)this.mBtnDelete, (GridBagConstraints)btnCs);
            l.popNl();
            l.pushFillXRemainX();
            l.addFillX();
            JButton btnClose = new JButton("Close");
            l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
            l.pop();
            this.updateDimList();
            this.enableButtons();
            this.setVisible(true);
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, null);
            this.pack();
            UIUtil.center((Component)((Object)this));
        }

        protected void updateSubstrates(String substrateToUse) {
            this.enableButtons();
        }

        protected void updateDimList() {
            this.mDims.clear();
            if (this.mDb == null) {
                return;
            }
            for (Dimensions t : Dimensions.getDimensions((DbObject)this.mDev, (Comparator)Dimensions.NameComparator)) {
                this.mDims.addDims(t);
            }
        }

        protected Dimensions getDimension() {
            return this.mDimList.getSelectedValue();
        }

        protected void enableButtons() {
            int selIdx = this.mDimList.getSelectedIndex();
            this.mBtnEdit.setEnabled(selIdx >= 0);
            this.mBtnDelete.setEnabled(selIdx >= 0);
        }
    }
}

