/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.MutableDouble;
import com.sigrity.acl.Unit;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.AFileChooserControl;
import com.sigrity.acl.ui.ASplitPane;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DeviceFilters;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.inter_substrate_checks.PinMapCheck;
import com.sigrity.orbit.inter_substrate_checks.PinOffsetCheck;
import com.sigrity.orbit.inter_substrate_checks.PortContactCheck;
import com.sigrity.orbit.inter_substrate_checks.ReferenceCsvCheck;
import com.sigrity.orbit.inter_substrate_checks.ui.PinMapCheckEngineUI;
import com.sigrity.orbit.ui.ContactDeviceFactoryUI;
import com.sigrity.orbit.ui.DeleteContactUI;
import com.sigrity.orbit.ui.DesignDialog;
import com.sigrity.orbit.ui.DevicePathChooser;
import com.sigrity.orbit.ui.ExportContactLayerDlg;
import com.sigrity.orbit.ui.ImportContactLayerDlg;
import com.sigrity.orbit.ui.LayerChooser;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.PinMapExportUI;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import com.sigrity.tools.dbexplorer.DBEResources;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.ArrayUtils;

public class EditContactLayerUI
extends DesignDialog {
    private static final String ACTION_TITLE = "Edit Contact Layer";
    private static final String DIALOG_TITLE = "Contact Layer Editor";
    private static final DeviceFilters.DeviceFilter FILTER_CONTACT_TYPE = d -> ContactLayer.DEFAULT_CONTACT_TYPE.contains(d.getType());
    private final Options mDefaultOptions;
    private JButton mBtnCancel;
    private ToolsBarPanel mToolsBarPanel;
    private ContactLayersPanel mContactLayersPnl;

    public static Action getAction() {
        return new AbstractAction(ACTION_TITLE){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditContactLayerUI.showUI();
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitIO.getCurDb() != null;
            }
        };
    }

    public static void showUI() {
        EditContactLayerUI.showUI(OrbitIO.getApp().getCurrentDb(), OrbitIO.getMainWindow(), Dialog.ModalityType.MODELESS);
    }

    public static void showUI(Db db, Window owner, Dialog.ModalityType modality) {
        EditContactLayerUI dlg = new EditContactLayerUI(db, owner, modality);
        dlg.setVisible(true);
    }

    protected EditContactLayerUI(Db db, Window owner) {
        this(db, owner, Dialog.ModalityType.MODELESS);
    }

    protected EditContactLayerUI(Db db, Window owner, Dialog.ModalityType modality) {
        super(db, owner, DIALOG_TITLE, modality);
        this.mDefaultOptions = new Options(db);
        GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
        this.mToolsBarPanel = new ToolsBarPanel();
        l.add((Component)this.mToolsBarPanel, (GridBagConstraints)GridBagManager.LEFT);
        l.newline();
        this.mContactLayersPnl = new ContactLayersPanel();
        l.add((Component)this.mContactLayersPnl, (GridBagConstraints)GridBagManager.FILLALL);
        l.newline();
        l.pushFillXRemainX();
        l.addFillX();
        this.mBtnCancel = (JButton)l.add((Component)new JButton("Close"));
        l.pop();
        UIUtil.enableEscCloseMinSize((Window)((Object)this), (AbstractButton)this.mBtnCancel);
        this.pack();
        this.setMinimumSize(this.getMinimumSize());
        UIUtil.center((Component)((Object)this));
    }

    public void hideCloseButton(boolean hide) {
        this.mBtnCancel.setVisible(!hide);
    }

    private static void cpSetContactLayerValue(ContactLayer contactLayer, String fieldName, boolean value) {
        Cp.exec((String)"%s.setValue(\"%s\", %b)", (Object[])new Object[]{CpHelper.getObjCmdStr(contactLayer), fieldName, value});
    }

    private static void cpSetContactLayerValue(ContactLayer contactLayer, String fieldName, double value) {
        Cp.exec((String)"%s.setValue(\"%s\", %f)", (Object[])new Object[]{CpHelper.getObjCmdStr(contactLayer), fieldName, value});
    }

    private static void cpSetContactLayerValue(ContactLayer contactLayer, String fieldName, String value) {
        Cp.exec((String)"%s.setValue(\"%s\", \"%s\")", (Object[])new Object[]{CpHelper.getObjCmdStr(contactLayer), fieldName, value});
    }

    private static void cpRecreatePinMaps(ContactLayer contactLayer) {
        Cp.exec((String)"unset(\"_contactLayer\");", (Object[])new Object[0]);
        Cp.exec((String)"_contactLayer = curDb().getByKeyStr(ContactLayer.class, \"%s\")", (Object[])new Object[]{contactLayer.getKeyStr()});
        Cp.exec((String)"com.sigrity.acl.db.std.PinMap.delete(_contactLayer)", (Object[])new Object[0]);
        Cp.exec((String)"com.sigrity.orbit.automation.pinMap.PinMapGenerator.createPinMapFromPhysicalContact(curDb(), _contactLayer)", (Object[])new Object[0]);
        Cp.exec((String)"unset(\"_contactLayer\");", (Object[])new Object[0]);
    }

    public static class ContactDeviceWarning {
        private Window owner;
        private Db db;
        private ContactLayer contactLayer;

        public static void check(Window owner, Db db, ContactLayer contactLayer) {
            if (db == null || contactLayer == null) {
                return;
            }
            ContactDeviceWarning contactDeviceWarning = new ContactDeviceWarning(owner, db, contactLayer);
            contactDeviceWarning.checkContactPins();
        }

        private ContactDeviceWarning(Window owner, Db db, ContactLayer contactLayer) {
            this.owner = owner;
            this.db = db;
            this.contactLayer = contactLayer;
        }

        private void checkContactPins() {
            assert (this.contactLayer != null);
            PortContactCheck check = new PortContactCheck(this.db);
            check.addContactLayer(this.contactLayer);
            check.execute();
            if (check.getViolationCount() != 0) {
                this.showContactPinsWarning();
            }
        }

        private void showContactPinsWarning() {
            int op = 0;
            if (AApp.getApp().getMainWin() != null && !OrbitApp.suppressWaringDialogs()) {
                String message = "Contact pins mismatch. Create a contact device?";
                op = OrbitApp.showWarningConfirmDialog((String)message, (String)"Contact Device");
            }
            if (op == 0) {
                this.showContactDeviceFactoryDlg();
            }
        }

        private void showContactDeviceFactoryDlg() {
            ContactDeviceFactoryUI.createDialog(this.owner, this.db, this.contactLayer);
        }
    }

    protected static class DevPathAndLayerPanel
    extends JPanel {
        private JCheckBox abstractCheckBox;
        protected LayerChooser.LCPanel layerChooser = new LayerChooser.LCPanel();
        protected DevicePathChooser.Panel deviceChooser;

        public DevPathAndLayerPanel(Db db, String title) {
            this.setBorder(BorderFactory.createTitledBorder(title));
            GridBagManager l = new GridBagManager((Container)this);
            this.deviceChooser = this.newDevicePathChooser(db);
            ASplitPane outerSplit = new ASplitPane(1, this.deviceChooser, this.layerChooser);
            outerSplit.setDividerLocation(200);
            l.add((Component)outerSplit, (GridBagConstraints)GridBagManager.FILLX);
            l.newline();
            this.abstractCheckBox = new JCheckBox("Abstract contact device");
            this.abstractCheckBox.setToolTipText("Mark the contact device as an abstract device that is not a substrate instance.");
            l.add((Component)this.abstractCheckBox, (GridBagConstraints)GridBagManager.FILLX);
            l.newline();
            l.addFillX();
            this.setMinimumSize(this.getPreferredSize());
        }

        public void setSelectedPath(DevicePath devPath) {
            this.deviceChooser.setSelectedPath(devPath);
        }

        public void setSelectedLayer(Layer layer) {
            this.layerChooser.setSelectedLayer(layer);
        }

        public boolean isAbstract() {
            return this.abstractCheckBox.isSelected();
        }

        private DevicePathChooser.Panel newDevicePathChooser(Db db) {
            return new DevicePathChooser.Panel(db, FILTER_CONTACT_TYPE){

                @Override
                protected void fireDeviceSelected(DevicePath p) {
                    if (p == null) {
                        return;
                    }
                    super.fireDeviceSelected(p);
                    Comparator layerComparator = p.getFlipped() ? Layer.BottomFirstSort : Layer.TopFirstSort;
                    layerChooser.setSortComparator(layerComparator);
                    layerChooser.setSubstrate(p.getSubstrate());
                    abstractCheckBox.setSelected(this.getIsDefaultAbstract(p));
                }
            };
        }

        private boolean getIsDefaultAbstract(DevicePath devPath) {
            if (devPath.getDeviceTemplate().getIsAbstractContactDevice()) {
                return true;
            }
            if (devPath.getDeviceTemplate().getSourceType() == DeviceTemplate.SourceType.ORBITIO_CONTACT) {
                return true;
            }
            Device dev = devPath.getDevice();
            Device parentDev = devPath.getParent().getDevice();
            if (dev == null || parentDev == null || parentDev.getType() == DeviceTemplate.Type.GROUP) {
                return false;
            }
            Substrate substrate = dev.getSubstrate();
            Substrate parentSubstrate = parentDev.getSubstrate();
            DeviceTemplate.Type type = dev.getType();
            DeviceTemplate.Type parentType = parentDev.getType();
            return dev.getIsSubstrate() && parentDev.getIsSubstrate() && substrate == parentSubstrate && type != parentType;
        }

        protected DevicePath getDevicePath() {
            return this.deviceChooser.getSelectedPath();
        }

        protected Layer getLayer() {
            return this.layerChooser.getSelectedLayer();
        }
    }

    public static class AddContactLayerDlg
    extends DbDialog {
        DevPathAndLayerPanel devPathAndLayerPanel1;
        DevPathAndLayerPanel devPathAndLayerPanel2;

        public AddContactLayerDlg(Db db, Window owner) {
            super(db, (Component)owner, "Add Contact Layer", Dialog.ModalityType.APPLICATION_MODAL);
            GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
            this.devPathAndLayerPanel1 = new DevPathAndLayerPanel(db, "Contact Device 1");
            this.devPathAndLayerPanel2 = new DevPathAndLayerPanel(db, "Contact Device 2");
            l.add((Component)this.devPathAndLayerPanel1, (GridBagConstraints)GridBagManager.FILLX);
            l.add((Component)this.devPathAndLayerPanel2, (GridBagConstraints)GridBagManager.FILLX);
            l.newline();
            l.pushFillXRemainX();
            l.addFillX();
            JButton btnOk = (JButton)l.add((Component)new JButton("Add"));
            btnOk.addActionListener(this.getAddActionListener());
            JButton btnCancel = (JButton)l.add((Component)new JButton("Close"));
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOk);
            this.pack();
            this.setMinimumSize(this.getMinimumSize());
            UIUtil.center((Component)((Object)this));
        }

        protected ActionListener getAddActionListener() {
            return e -> {
                String devicePathBStr;
                if (this.devPathAndLayerPanel1.getDevicePath() == null || this.devPathAndLayerPanel2.getDevicePath() == null || this.devPathAndLayerPanel1.getLayer() == null || this.devPathAndLayerPanel2.getLayer() == null) {
                    return;
                }
                String devicePathAStr = this.devPathAndLayerPanel1.getDevicePath().toString();
                if (devicePathAStr.equals(devicePathBStr = this.devPathAndLayerPanel2.getDevicePath().toString())) {
                    ALog.logError((String)"Cannot set a contact layer with the same devicePath. Need to Choose two different devicePaths.");
                    return;
                }
                String layerAName = this.devPathAndLayerPanel1.getLayer().getName();
                String layerBName = this.devPathAndLayerPanel2.getLayer().getName();
                Cp.exec((String)"_contactLayer = com.sigrity.acl.db.std.ContactLayer.create(curDb(), \"%s\", \"%s\", \"%s\", \"%s\");", (Object[])new Object[]{devicePathAStr, layerAName, devicePathBStr, layerBName});
                if (this.devPathAndLayerPanel1.isAbstract()) {
                    this.setDevTAbstract(this.devPathAndLayerPanel1.getDevicePath().getDeviceTemplate());
                }
                if (this.devPathAndLayerPanel2.isAbstract()) {
                    this.setDevTAbstract(this.devPathAndLayerPanel2.getDevicePath().getDeviceTemplate());
                }
                this.createPinMapFromPhysicalContact();
                ContactLayer contactLayer = this.getContactLayer();
                if (!this.devPathAndLayerPanel1.isAbstract() && !this.devPathAndLayerPanel2.isAbstract()) {
                    ContactDeviceWarning.check((Window)((Object)this), this.mDb, contactLayer);
                }
            };
        }

        private void setDevTAbstract(DeviceTemplate devT) {
            Cp.exec((String)"if ( _contactLayer != null) %s.setIsAbstractContactDevice(true)", (Object[])new Object[]{CpHelper.getObjCmdStr(devT)});
        }

        private void createPinMapFromPhysicalContact() {
            Cp.exec((String)"if ( _contactLayer != null) com.sigrity.orbit.automation.pinMap.PinMapGenerator.createPinMapFromPhysicalContact(curDb(), _contactLayer)", (Object[])new Object[0]);
        }

        private ContactLayer getContactLayer() {
            return ContactLayer.get((DevicePath)this.devPathAndLayerPanel1.getDevicePath(), (Layer)this.devPathAndLayerPanel1.getLayer(), (DevicePath)this.devPathAndLayerPanel2.getDevicePath(), (Layer)this.devPathAndLayerPanel2.getLayer());
        }
    }

    public static class OptionsDlg
    extends DbDialog {
        private final Options mDefaultOptions;
        private CheckingPanel checkingPanel;
        private List<ContactLayer> contactLayers;

        protected OptionsDlg(Db db, Window owner, Options options) {
            this(db, owner, options, Collections.emptyList());
        }

        protected OptionsDlg(Db db, Window owner, Options options, ContactLayer contactLayer) {
            this(db, owner, options, AUtil.arrayList((Object[])new ContactLayer[]{contactLayer}));
        }

        public OptionsDlg(Db db, Window owner, Options options, List<ContactLayer> contactLayers) {
            super(db, (Component)owner, "Options", Dialog.ModalityType.DOCUMENT_MODAL);
            this.contactLayers = contactLayers;
            this.mDefaultOptions = options;
            this.initializePanel();
        }

        private void initializePanel() {
            GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
            this.checkingPanel = new CheckingPanel();
            l.add((Component)this.checkingPanel, (GridBagConstraints)GridBagManager.FILLX);
            this.loadSetting();
            l.newline();
            l.pushFillXRemainX();
            l.addFillX();
            JButton btnOk = (JButton)l.add((Component)new JButton("Ok"));
            btnOk.addActionListener(this.getOkActionListener());
            JButton btnCancel = (JButton)l.add((Component)new JButton("Close"));
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOk);
            this.pack();
            this.setMinimumSize(this.getMinimumSize());
            UIUtil.center((Component)((Object)this));
        }

        protected ActionListener getOkActionListener() {
            return e -> {
                this.saveSetting();
                UIUtil.closeWindow((Window)((Object)this));
            };
        }

        public void loadSetting() {
            this.checkingPanel.loadSetting();
        }

        public boolean saveSetting() {
            try (DbHistory.DbTransaction dbT = DbHistory.newDbTransaction((Db)this.getDb(), (String)"Save contact layer settings");){
                this.checkingPanel.saveSetting();
            }
            return true;
        }

        private class CheckingPanel
        extends JPanel {
            private JCheckBox pinOffsetButton = new JCheckBox("Pin offset");
            private JTextField mTxtMaxOffset = new JTextField(5);
            private JCheckBox pinCountMismatchButton = new JCheckBox("Pin count mismatch");
            private JCheckBox pinDirectionButton = new JCheckBox("Pin direction");
            private JCheckBox portContactButton = new JCheckBox("Pin contact");
            private JCheckBox pinNameButton = new JCheckBox("Pin name");
            private JCheckBox designNetNameButton = new JCheckBox("Design net name");
            private JCheckBox localNetNameButton = new JCheckBox("Local net name");
            private JCheckBox netMappingButton = new JCheckBox("Net mapping");
            private JCheckBox netPersonalityButton = new JCheckBox("Net personality");
            protected JCheckBox refCompareButton = new JCheckBox("Reference pin map");
            protected AFileChooserControl refFileChooser = new AFileChooserControl();

            public CheckingPanel() {
                this.setBorder(BorderFactory.createTitledBorder("Checking"));
                GridBagManager l = new GridBagManager((Container)this);
                this.portContactButton.setToolTipText("Check if the port on the contact layer has a contact pad.");
                l.add((Component)this.portContactButton, (GridBagConstraints)GridBagManager.LEFT);
                l.newline();
                JPanel pinOffsetPanel = new JPanel();
                this.pinOffsetButton.setToolTipText("Check the offset of contact pin based on center of pad.");
                pinOffsetPanel.add((Component)this.pinOffsetButton, GridBagManager.LEFT.noInsets());
                pinOffsetPanel.add((Component)this.mTxtMaxOffset, GridBagManager.LEFT.noInsets());
                pinOffsetPanel.setMinimumSize(pinOffsetPanel.getMinimumSize());
                l.add((Component)pinOffsetPanel, (GridBagConstraints)GridBagManager.LEFT.noInsets());
                l.newline();
                this.pinCountMismatchButton.setToolTipText("Check if a pin has only one contact pin.");
                l.add((Component)this.pinCountMismatchButton, (GridBagConstraints)GridBagManager.LEFT);
                l.newline();
                this.pinDirectionButton.setToolTipText("Check if dircetion of two contact pins.");
                l.add((Component)this.pinDirectionButton, (GridBagConstraints)GridBagManager.LEFT);
                l.newline();
                this.pinNameButton.setToolTipText("Check if the pin name of contact pins match.");
                l.add((Component)this.pinNameButton, (GridBagConstraints)GridBagManager.LEFT);
                l.newline();
                this.designNetNameButton.setToolTipText("Check the name of the net at the design(substrate instance) level.");
                l.add((Component)this.designNetNameButton, (GridBagConstraints)GridBagManager.LEFT);
                l.newline();
                this.localNetNameButton.setToolTipText("Check the name of the net at the contact device level.");
                l.add((Component)this.localNetNameButton, (GridBagConstraints)GridBagManager.LEFT);
                l.newline();
                this.netMappingButton.setToolTipText("Check if physical connectivity match to logic connectivity.");
                l.add((Component)this.netMappingButton, (GridBagConstraints)GridBagManager.LEFT);
                l.newline();
                l.add((Component)this.netPersonalityButton, (GridBagConstraints)GridBagManager.LEFT);
                l.newline();
                if (OptionsDlg.this.contactLayers.size() == 1) {
                    JPanel externalCsvPanel = new JPanel();
                    this.refCompareButton.setToolTipText("Compare the csv file with the current design");
                    this.refFileChooser.addChoosableFileFilter(AFileFilter.CSV);
                    this.refFileChooser.setUseSaveChooser(false);
                    this.refFileChooser.setEnabled(false);
                    externalCsvPanel.add((Component)this.refCompareButton, GridBagManager.LEFT.noInsets());
                    externalCsvPanel.add((Component)this.refFileChooser, GridBagManager.LEFT.noInsets());
                    l.add((Component)externalCsvPanel, (GridBagConstraints)GridBagManager.LEFT.noInsets());
                    l.newline();
                    this.refCompareButton.addActionListener(e -> this.refFileChooser.setEnabled(this.refCompareButton.isSelected()));
                }
                l.addFillX();
                this.setMinimumSize(this.getPreferredSize());
            }

            private boolean checkPinCountMismatch() {
                return this.pinCountMismatchButton.isSelected();
            }

            private boolean checkNetMapping() {
                return this.netMappingButton.isSelected();
            }

            private boolean checkNetPersonality() {
                return this.netPersonalityButton.isSelected();
            }

            private boolean checkPinDirection() {
                return this.pinDirectionButton.isSelected();
            }

            private boolean checkPinName() {
                return this.pinNameButton.isSelected();
            }

            private boolean checkDesignNetName() {
                return this.designNetNameButton.isSelected();
            }

            private boolean checkLocalNetName() {
                return this.localNetNameButton.isSelected();
            }

            private boolean checkPortContact() {
                return this.portContactButton.isSelected();
            }

            private boolean checkPinOffset() {
                return this.pinOffsetButton.isSelected();
            }

            private double getPinMaxOffset() {
                double maxOffset = 0.0;
                try {
                    MutableDouble d = new MutableDouble();
                    String s = AFieldValidator.validateDouble((String)this.mTxtMaxOffset.getText(), (Component)this.mTxtMaxOffset, (MutableDouble)d);
                    if (d.getValue() < 0.0) {
                        throw AFieldValidator.createException((String)s, (String)"non-negative", null, (Component)this.mTxtMaxOffset);
                    }
                    maxOffset = Double.parseDouble(this.mTxtMaxOffset.getText());
                }
                catch (AFieldValidator.AFieldValidationException e) {
                    return 0.0;
                }
                return maxOffset;
            }

            private boolean checkRefCompare() {
                return this.refCompareButton.isSelected();
            }

            private String getRefFile() {
                return this.refFileChooser.getPath();
            }

            public void loadSetting() {
                ContactLayer contactLayer = OptionsDlg.this.contactLayers.isEmpty() ? null : OptionsDlg.this.contactLayers.get(0);
                this.portContactButton.setSelected(OptionsDlg.this.mDefaultOptions.isCheckPortContact(contactLayer));
                this.pinOffsetButton.setSelected(OptionsDlg.this.mDefaultOptions.isCheckPinOffset(contactLayer));
                this.mTxtMaxOffset.setText(Double.toString(OptionsDlg.this.mDefaultOptions.getPinMaxOffset(contactLayer)));
                this.pinCountMismatchButton.setSelected(OptionsDlg.this.mDefaultOptions.isCheckPinCountMismatch(contactLayer));
                this.pinDirectionButton.setSelected(OptionsDlg.this.mDefaultOptions.isCheckPinDirection(contactLayer));
                this.pinNameButton.setSelected(OptionsDlg.this.mDefaultOptions.isCheckPinName(contactLayer));
                this.designNetNameButton.setSelected(OptionsDlg.this.mDefaultOptions.isCheckDesignNetName(contactLayer));
                this.localNetNameButton.setSelected(OptionsDlg.this.mDefaultOptions.isCheckLocalNetName(contactLayer));
                this.netMappingButton.setSelected(OptionsDlg.this.mDefaultOptions.isCheckNetMapping(contactLayer));
                this.netPersonalityButton.setSelected(OptionsDlg.this.mDefaultOptions.isCheckNetPersonality(contactLayer));
                this.refCompareButton.setSelected(OptionsDlg.this.mDefaultOptions.isCheckRefCompare(contactLayer));
                this.refFileChooser.setEnabled(OptionsDlg.this.mDefaultOptions.isCheckRefCompare(contactLayer));
                this.refFileChooser.setPath(OptionsDlg.this.mDefaultOptions.getRefCompareFile(contactLayer));
            }

            public void saveSetting() {
                if (OptionsDlg.this.contactLayers.isEmpty()) {
                    this.saveDefaultSetting();
                    this.saveGlobalSetting();
                } else {
                    this.saveContactLayerSetting();
                }
            }

            private void saveDefaultSetting() {
                OptionsDlg.this.mDefaultOptions.setCheckPortContact(this.checkPortContact());
                OptionsDlg.this.mDefaultOptions.setCheckPinMaxOffset(this.checkPinOffset(), this.getPinMaxOffset());
                OptionsDlg.this.mDefaultOptions.setCheckPinCountMismatch(this.checkPinCountMismatch());
                OptionsDlg.this.mDefaultOptions.setCheckPinDirection(this.checkPinDirection());
                OptionsDlg.this.mDefaultOptions.setCheckPinName(this.checkPinName());
                OptionsDlg.this.mDefaultOptions.setCheckDesignNetName(this.checkDesignNetName());
                OptionsDlg.this.mDefaultOptions.setCheckLocalNetName(this.checkLocalNetName());
                OptionsDlg.this.mDefaultOptions.setCheckNetMapping(this.checkNetMapping());
                OptionsDlg.this.mDefaultOptions.setCheckNetPersonality(this.checkNetPersonality());
                OptionsDlg.this.mDefaultOptions.save();
            }

            private void saveGlobalSetting() {
                ContactLayer.getValid((Db)OptionsDlg.this.mDb).forEach(this::saveContactLayerSetting);
            }

            private void saveContactLayerSetting() {
                OptionsDlg.this.contactLayers.forEach(this::saveContactLayerSetting);
            }

            private void saveContactLayerSetting(ContactLayer contactLayer) {
                EditContactLayerUI.cpSetContactLayerValue(contactLayer, "CheckPinOffset", this.checkPinOffset());
                EditContactLayerUI.cpSetContactLayerValue(contactLayer, "CheckPinMaxOffset", this.getPinMaxOffset());
                EditContactLayerUI.cpSetContactLayerValue(contactLayer, "CheckPinCountMismatch", this.checkPinCountMismatch());
                EditContactLayerUI.cpSetContactLayerValue(contactLayer, "CheckPinDirection", this.checkPinDirection());
                EditContactLayerUI.cpSetContactLayerValue(contactLayer, "CheckPortContact", this.checkPortContact());
                EditContactLayerUI.cpSetContactLayerValue(contactLayer, "CheckPinName", this.checkPinName());
                EditContactLayerUI.cpSetContactLayerValue(contactLayer, "CheckDesignNetName", this.checkDesignNetName());
                EditContactLayerUI.cpSetContactLayerValue(contactLayer, "CheckLocalNetName", this.checkLocalNetName());
                EditContactLayerUI.cpSetContactLayerValue(contactLayer, "CheckNetMapping", this.checkNetMapping());
                EditContactLayerUI.cpSetContactLayerValue(contactLayer, "CheckNetPersonality", this.checkNetPersonality());
                EditContactLayerUI.cpSetContactLayerValue(contactLayer, "CheckReferenceCompare", this.checkRefCompare());
                EditContactLayerUI.cpSetContactLayerValue(contactLayer, "ReferenceCompareFile", this.getRefFile());
            }
        }
    }

    private class ToolsBarPanel
    extends JPanel {
        JButton refreshBtn;
        JButton defaultOptionsBtn;
        JButton autoNetMapBtn;

        public ToolsBarPanel() {
            GridBagManager l = new GridBagManager((Container)this);
            this.refreshBtn = this.createJButton(OrbitIcons.REFRESH);
            this.refreshBtn.setToolTipText("Refresh");
            this.refreshBtn.addActionListener(this.getRefreshActionListener());
            l.add((Component)this.refreshBtn, (GridBagConstraints)GridBagManager.LEFT);
            this.defaultOptionsBtn = this.createJButton(DBEResources.ICON_COG_EDIT);
            this.defaultOptionsBtn.setToolTipText("Edit options");
            this.defaultOptionsBtn.addActionListener(this.getShowOptionsUIActionListener());
            l.add((Component)this.defaultOptionsBtn, (GridBagConstraints)GridBagManager.LEFT);
            this.autoNetMapBtn = this.createJButton(OrbitIcons.NETMAP);
            this.autoNetMapBtn.setToolTipText("Auto-connect net for all contactLayers");
            this.autoNetMapBtn.addActionListener(this.getAutoNetMapActionListener());
            l.add((Component)this.autoNetMapBtn, (GridBagConstraints)GridBagManager.LEFT);
            l.addFillX();
            this.setMinimumSize(this.getPreferredSize());
        }

        private ActionListener getRefreshActionListener() {
            return e -> {
                try (DbHistory.DbTransaction dbT = DbHistory.newDbTransaction((Db)EditContactLayerUI.this.getDb(), (String)"Refresh");){
                    ContactLayer.getValid((Db)EditContactLayerUI.this.mDb).stream().forEach(x$0 -> EditContactLayerUI.cpRecreatePinMaps(x$0));
                }
                EditContactLayerUI.this.mContactLayersPnl.loadDb();
            };
        }

        private ActionListener getShowOptionsUIActionListener() {
            return e -> {
                OptionsDlg dlg = new OptionsDlg(EditContactLayerUI.this.mDb, (Window)((Object)EditContactLayerUI.this), EditContactLayerUI.this.mDefaultOptions);
                dlg.setVisible(true);
            };
        }

        private ActionListener getAutoNetMapActionListener() {
            return e -> {
                try (DbHistory.DbTransaction dbT = DbHistory.newDbTransaction((Db)EditContactLayerUI.this.getDb(), (String)"Auto-connect Net");){
                    Cp.exec((String)"com.sigrity.orbit.automation.pinMap.NetMapGenerator.execute(curDb(), false)", (Object[])new Object[0]);
                }
                EditContactLayerUI.this.mContactLayersPnl.refershChecks(PinMapCheck.CheckType.NET_MAPPING);
                EditContactLayerUI.this.mContactLayersPnl.rebuildTable();
            };
        }

        private JButton createJButton(Icon icon) {
            JButton toggleBtn = new JButton(icon);
            toggleBtn.setPreferredSize(new Dimension(25, 25));
            toggleBtn.setOpaque(false);
            toggleBtn.setBackground(Color.WHITE);
            return toggleBtn;
        }
    }

    public static class Options {
        private final Db mDb;
        private Settings settings = Settings.getSettings((String)"ContactLayerCheck");
        private boolean checkPinOffset;
        private double pinMaxOffset;
        private boolean checkPinCountMismatch;
        private boolean checkPinDirection;
        private boolean checkPortContact;
        private boolean checkPinName;
        private boolean checkDesignNetName;
        private boolean checkLocalNetName;
        private boolean checkNetMapping;
        private boolean checkNetPersonality;
        private boolean checkRefCompare;

        public Options(Db db) {
            this.mDb = db;
            this.checkPinOffset = (Boolean)this.settings.getSetting("CheckPinOffset", (Object)true);
            this.pinMaxOffset = (Double)this.settings.getSetting("CheckPinMaxOffset", (Object)0.0);
            this.checkPinCountMismatch = (Boolean)this.settings.getSetting("CheckPinCountMismatch", (Object)true);
            this.checkPinDirection = (Boolean)this.settings.getSetting("CheckPinDirection", (Object)true);
            this.checkPortContact = (Boolean)this.settings.getSetting("CheckPortContact", (Object)true);
            this.checkPinName = (Boolean)this.settings.getSetting("CheckPinName", (Object)true);
            this.checkDesignNetName = (Boolean)this.settings.getSetting("CheckDesignNetName", (Object)false);
            this.checkLocalNetName = (Boolean)this.settings.getSetting("CheckLocalNetName", (Object)false);
            this.checkNetMapping = (Boolean)this.settings.getSetting("CheckNetMapping", (Object)true);
            this.checkNetPersonality = (Boolean)this.settings.getSetting("CheckNetPersonality", (Object)false);
            this.checkRefCompare = (Boolean)this.settings.getSetting("CheckReferenceCompare", (Object)false);
        }

        public void setCheckPinMaxOffset(boolean checkPinOffset, double pinMaxOffset) {
            this.checkPinOffset = checkPinOffset;
            this.pinMaxOffset = pinMaxOffset;
            this.settings.putSetting("CheckPinOffset", (Object)checkPinOffset);
            this.settings.putSetting("CheckPinMaxOffset", (Object)pinMaxOffset);
        }

        public void setCheckPinCountMismatch(boolean checkPinCountMismatch) {
            this.checkPinCountMismatch = checkPinCountMismatch;
            this.settings.putSetting("CheckPinCountMismatch", (Object)checkPinCountMismatch);
        }

        public void setCheckPinDirection(boolean checkPinDirection) {
            this.checkPinDirection = checkPinDirection;
            this.settings.putSetting("CheckPinDirection", (Object)checkPinDirection);
        }

        public void setCheckPortContact(boolean checkPortContact) {
            this.checkPortContact = checkPortContact;
            this.settings.putSetting("CheckPortContact", (Object)checkPortContact);
        }

        public void setCheckPinName(boolean checkPinName) {
            this.checkPinName = checkPinName;
            this.settings.putSetting("CheckPinName", (Object)checkPinName);
        }

        public void setCheckDesignNetName(boolean checkNetName) {
            this.checkDesignNetName = checkNetName;
            this.settings.putSetting("CheckDesignNetName", (Object)checkNetName);
        }

        public void setCheckLocalNetName(boolean checkNetName) {
            this.checkLocalNetName = checkNetName;
            this.settings.putSetting("CheckLocalNetName", (Object)checkNetName);
        }

        public void setCheckNetMapping(boolean checkNetMapping) {
            this.checkNetMapping = checkNetMapping;
            this.settings.putSetting("CheckNetMapping", (Object)checkNetMapping);
        }

        public void setCheckNetPersonality(boolean checkNetPersonality) {
            this.checkNetPersonality = checkNetPersonality;
            this.settings.putSetting("CheckNetPersonality", (Object)checkNetPersonality);
        }

        public void save() {
            this.settings.save();
        }

        public PinMapCheck getCheckEngine(ContactLayer contactLayer) {
            String csvFile;
            PinMapCheck engine = new PinMapCheck(this.mDb);
            if (this.isCheckPortContact(contactLayer)) {
                engine.addCheck(PinMapCheck.CheckType.PORT_CONTACT);
            }
            if (this.isCheckPinOffset(contactLayer)) {
                PinOffsetCheck pinOffsetCheck = new PinOffsetCheck(this.mDb);
                pinOffsetCheck.setMaxOffset(this.getPinMaxOffset(contactLayer));
                engine.addCheck(pinOffsetCheck);
            }
            if (this.isCheckPinCountMismatch(contactLayer)) {
                engine.addCheck(PinMapCheck.CheckType.PIN_COUNT_MISMATCH);
            }
            if (this.isCheckPinDirection(contactLayer)) {
                engine.addCheck(PinMapCheck.CheckType.PIN_DIRECTION);
            }
            if (this.isCheckPinName(contactLayer)) {
                engine.addCheck(PinMapCheck.CheckType.PIN_NAME);
            }
            if (this.isCheckDesignNetName(contactLayer)) {
                engine.addCheck(PinMapCheck.CheckType.DESIGN_NET_NAME);
            }
            if (this.isCheckLocalNetName(contactLayer)) {
                engine.addCheck(PinMapCheck.CheckType.LOCAL_NET_NAME);
            }
            if (this.isCheckNetMapping(contactLayer)) {
                engine.addCheck(PinMapCheck.CheckType.NET_MAPPING);
            }
            if (this.isCheckNetPersonality(contactLayer)) {
                engine.addCheck(PinMapCheck.CheckType.NET_PERSONALITY);
            }
            if (this.isCheckRefCompare(contactLayer) && (csvFile = this.getRefCompareFile(contactLayer)) != null) {
                ReferenceCsvCheck refCsvCheck = new ReferenceCsvCheck(this.mDb);
                refCsvCheck.addCsvFile(contactLayer, csvFile);
                engine.addCheck(refCsvCheck);
            }
            engine.addContactLayer(contactLayer);
            return engine;
        }

        private boolean isCheckPinOffset(ContactLayer contactLayer) {
            if (contactLayer == null) {
                return this.checkPinOffset;
            }
            Boolean objValue = (Boolean)contactLayer.getValue("CheckPinOffset", Boolean.class);
            if (objValue == null) {
                EditContactLayerUI.cpSetContactLayerValue(contactLayer, "CheckPinOffset", this.checkPinOffset);
                return this.checkPinOffset;
            }
            return objValue;
        }

        private double getPinMaxOffset(ContactLayer contactLayer) {
            if (contactLayer == null) {
                return this.pinMaxOffset;
            }
            Double objValue = (Double)contactLayer.getValue("CheckPinMaxOffset", Double.class);
            if (objValue == null) {
                EditContactLayerUI.cpSetContactLayerValue(contactLayer, "CheckPinMaxOffset", this.pinMaxOffset);
                return this.pinMaxOffset;
            }
            return objValue;
        }

        private boolean isCheckPinCountMismatch(ContactLayer contactLayer) {
            if (contactLayer == null) {
                return this.checkPinCountMismatch;
            }
            Boolean objValue = (Boolean)contactLayer.getValue("CheckPinCountMismatch", Boolean.class);
            if (objValue == null) {
                EditContactLayerUI.cpSetContactLayerValue(contactLayer, "CheckPinCountMismatch", this.checkPinCountMismatch);
                return this.checkPinCountMismatch;
            }
            return objValue;
        }

        private boolean isCheckPinDirection(ContactLayer contactLayer) {
            if (contactLayer == null) {
                return this.checkPinDirection;
            }
            Boolean objValue = (Boolean)contactLayer.getValue("CheckPinDirection", Boolean.class);
            if (objValue == null) {
                EditContactLayerUI.cpSetContactLayerValue(contactLayer, "CheckPinDirection", this.checkPinDirection);
                return this.checkPinDirection;
            }
            return objValue;
        }

        private boolean isCheckPortContact(ContactLayer contactLayer) {
            if (contactLayer == null) {
                return this.checkPortContact;
            }
            Boolean objValue = (Boolean)contactLayer.getValue("CheckPortContact", Boolean.class);
            if (objValue == null) {
                EditContactLayerUI.cpSetContactLayerValue(contactLayer, "CheckPortContact", this.checkPortContact);
                return this.checkPortContact;
            }
            return objValue;
        }

        private boolean isCheckPinName(ContactLayer contactLayer) {
            if (contactLayer == null) {
                return this.checkPinName;
            }
            Boolean objValue = (Boolean)contactLayer.getValue("CheckPinName", Boolean.class);
            if (objValue == null) {
                EditContactLayerUI.cpSetContactLayerValue(contactLayer, "CheckPinName", this.checkPinName);
                return this.checkPinName;
            }
            return objValue;
        }

        private boolean isCheckDesignNetName(ContactLayer contactLayer) {
            if (contactLayer == null) {
                return this.checkDesignNetName;
            }
            Boolean objValue = (Boolean)contactLayer.getValue("CheckDesignNetName", Boolean.class);
            if (objValue == null) {
                EditContactLayerUI.cpSetContactLayerValue(contactLayer, "CheckLocalNetName", this.checkDesignNetName);
                return this.checkDesignNetName;
            }
            return objValue;
        }

        private boolean isCheckLocalNetName(ContactLayer contactLayer) {
            if (contactLayer == null) {
                return this.checkLocalNetName;
            }
            Boolean objValue = (Boolean)contactLayer.getValue("CheckLocalNetName", Boolean.class);
            if (objValue == null) {
                EditContactLayerUI.cpSetContactLayerValue(contactLayer, "CheckLocalNetName", this.checkLocalNetName);
                return this.checkLocalNetName;
            }
            return objValue;
        }

        private boolean isCheckNetMapping(ContactLayer contactLayer) {
            if (contactLayer == null) {
                return this.checkNetMapping;
            }
            Boolean objValue = (Boolean)contactLayer.getValue("CheckNetMapping", Boolean.class);
            if (objValue == null) {
                EditContactLayerUI.cpSetContactLayerValue(contactLayer, "CheckNetMapping", this.checkNetMapping);
                return this.checkNetMapping;
            }
            return objValue;
        }

        private boolean isCheckNetPersonality(ContactLayer contactLayer) {
            if (contactLayer == null) {
                return this.checkNetPersonality;
            }
            Boolean objValue = (Boolean)contactLayer.getValue("CheckNetPersonality", Boolean.class);
            if (objValue == null) {
                EditContactLayerUI.cpSetContactLayerValue(contactLayer, "CheckNetPersonality", this.checkNetPersonality);
                return this.checkNetPersonality;
            }
            return objValue;
        }

        private boolean isCheckRefCompare(ContactLayer contactLayer) {
            if (contactLayer == null) {
                return false;
            }
            Boolean objValue = (Boolean)contactLayer.getValue("CheckReferenceCompare", Boolean.class);
            if (objValue == null) {
                EditContactLayerUI.cpSetContactLayerValue(contactLayer, "CheckReferenceCompare", this.checkRefCompare);
                return this.checkRefCompare;
            }
            return objValue;
        }

        private String getRefCompareFile(ContactLayer contactLayer) {
            if (contactLayer == null) {
                return null;
            }
            return contactLayer.getRefPinMapCsv();
        }
    }

    protected class ContactLayersPanel
    extends JPanel {
        protected JTable mTable;
        protected ContactLayerList mContactLayerListModel;
        protected JButton mBtnAdd;
        protected JButton mBtnImportCsv;
        protected JButton mBtnExportCsv;
        static final int COLUMN_WIDTH_UNIT = 20;
        static final int TABLE_WIDTH = 600;
        static final int TABLE_HEIGHT = 180;

        protected ContactLayersPanel() {
            this.initialPanel();
            this.loadDb();
        }

        private void initialPanel() {
            this.setBorder(BorderFactory.createTitledBorder("Contact Layer"));
            GridBagManager l = new GridBagManager((Container)this);
            this.mTable = new JTable();
            JTableHeader tableHeader = this.mTable.getTableHeader();
            tableHeader.setReorderingAllowed(false);
            this.mTable.setRowSelectionAllowed(true);
            this.mTable.setSelectionMode(2);
            this.mTable.setAutoResizeMode(4);
            this.mContactLayerListModel = new ContactLayerList();
            this.mTable.setModel(this.mContactLayerListModel);
            this.mTable.setRowHeight(this.mTable.getRowHeight() + 8);
            ColumnHeaderRender columnHeaderRender = new ColumnHeaderRender();
            TableColumn col = this.mTable.getColumnModel().getColumn(TableHeader.CHECK.ordinal());
            col.setMinWidth(40);
            col.setMaxWidth(40);
            col.setIdentifier((Object)TableHeader.CHECK);
            col.setResizable(false);
            col.setHeaderRenderer(columnHeaderRender);
            col = this.mTable.getColumnModel().getColumn(TableHeader.DEVICEPATH1.ordinal());
            col.setMinWidth(160);
            col.setIdentifier((Object)TableHeader.DEVICEPATH1);
            col.setResizable(true);
            col.setHeaderRenderer(columnHeaderRender);
            col = this.mTable.getColumnModel().getColumn(TableHeader.CONTACTLAYER1.ordinal());
            col.setMinWidth(80);
            col.setIdentifier((Object)TableHeader.CONTACTLAYER1);
            col.setResizable(true);
            col.setHeaderRenderer(columnHeaderRender);
            col = this.mTable.getColumnModel().getColumn(TableHeader.DEVICEPATH2.ordinal());
            col.setMinWidth(160);
            col.setIdentifier((Object)TableHeader.DEVICEPATH2);
            col.setResizable(true);
            col.setHeaderRenderer(columnHeaderRender);
            col = this.mTable.getColumnModel().getColumn(TableHeader.CONTACTLAYER2.ordinal());
            col.setMinWidth(80);
            col.setIdentifier((Object)TableHeader.CONTACTLAYER2);
            col.setResizable(true);
            col.setHeaderRenderer(columnHeaderRender);
            col = this.mTable.getColumnModel().getColumn(TableHeader.HEIGHT.ordinal());
            col.setMinWidth(80);
            col.setIdentifier((Object)TableHeader.HEIGHT);
            col.setResizable(true);
            col.setHeaderRenderer(columnHeaderRender);
            col.setCellEditor(new HeightCellEditor());
            this.mTable.setDefaultRenderer(Object.class, new ContactLayerRowRenderer());
            this.mTable.addMouseListener(new TableButtonMouseListener(this.mTable));
            JScrollPane scrollPane = new JScrollPane(this.mTable);
            scrollPane.setMinimumSize(new Dimension(600, 180));
            l.add((Component)scrollPane, (GridBagConstraints)GridBagManager.FILLALL);
            l.newline();
            JPanel btnPnl = new JPanel();
            this.mBtnAdd = new JButton("Add");
            this.mBtnAdd.addActionListener(this.getAddActionListener());
            btnPnl.add(this.mBtnAdd);
            this.mBtnImportCsv = new JButton("Import Csv");
            this.mBtnImportCsv.addActionListener(this.getImportCsvActionListener());
            btnPnl.add(this.mBtnImportCsv);
            this.mBtnExportCsv = new JButton("Export Csv");
            this.mBtnExportCsv.addActionListener(this.getExportCsvActionListener());
            btnPnl.add(this.mBtnExportCsv);
            l.add((Component)btnPnl);
            l.newline();
            l.addFillX();
            this.setPreferredSize(this.getMinimumSize());
        }

        private ActionListener getAddActionListener() {
            return e -> {
                AddContactLayerDlg addContactLayerDlg = new AddContactLayerDlg(EditContactLayerUI.this.mDb, (Window)((Object)EditContactLayerUI.this));
                addContactLayerDlg.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        ContactLayersPanel.this.removeInvalidContactLayer();
                        ContactLayersPanel.this.addMissingContactLayer();
                        ContactLayersPanel.this.rebuildTable();
                    }
                });
                addContactLayerDlg.setVisible(true);
            };
        }

        private ActionListener getImportCsvActionListener() {
            return e -> {
                ImportContactLayerDlg.showUI();
                this.addMissingContactLayer();
                this.rebuildTable();
            };
        }

        private ActionListener getExportCsvActionListener() {
            return e -> ExportContactLayerDlg.showUI();
        }

        private void refershChecks(PinMapCheck.CheckType checkType) {
            this.mContactLayerListModel.refreshChecks(checkType);
        }

        private void rebuildTable() {
            this.mContactLayerListModel.rebuildTable();
        }

        private void loadDb() {
            this.mContactLayerListModel.clearTable();
            ContactLayer.getValid((Db)EditContactLayerUI.this.mDb).forEach(this.mContactLayerListModel::addContactLayer);
            this.mContactLayerListModel.rebuildTable();
        }

        private void addMissingContactLayer() {
            for (ContactLayer cl : ContactLayer.getValid((Db)EditContactLayerUI.this.mDb)) {
                if (this.mContactLayerListModel.containContactLayer(cl)) continue;
                this.mContactLayerListModel.addContactLayer(cl);
            }
        }

        private void removeInvalidContactLayer() {
            this.mContactLayerListModel.removeInvalidContactLayer();
        }

        private void reloadCheckEngine(List<ContactLayer> contactLayers) {
            contactLayers.forEach(contactLayer -> this.mContactLayerListModel.loadCheckEngine((ContactLayer)contactLayer));
            this.mContactLayerListModel.rebuildTable();
        }

        public class HeightCellEditor
        extends AbstractCellEditor
        implements TableCellEditor {
            protected Unit unit;
            protected JTextField height;

            public HeightCellEditor() {
                this.unit = EditContactLayerUI.this.getUnitDist();
                this.height = new JTextField();
            }

            @Override
            public Object getCellEditorValue() {
                return this.height.getText();
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
                ContactLayer def = ContactLayersPanel.this.mContactLayerListModel.getContactLayer(rowIndex);
                if (def == null || !def.isValid()) {
                    ContactLayersPanel.this.mContactLayerListModel.removeContactLayer(def);
                    ContactLayersPanel.this.mContactLayerListModel.rebuildTable();
                    return this.height;
                }
                this.height.setText(this.unit.toUserStr(def.getHeight()));
                TableModel model = table.getModel();
                model.setValueAt(value, rowIndex, vColIndex);
                return this.height;
            }

            protected boolean validate() {
                boolean isValid = true;
                try {
                    AFieldValidator.validateDouble((JTextField)this.height);
                }
                catch (AFieldValidator.AFieldValidationException e) {
                    isValid = false;
                }
                return isValid;
            }

            @Override
            public boolean stopCellEditing() {
                boolean state = super.stopCellEditing();
                if (!this.validate()) {
                    return false;
                }
                ContactLayer def = ContactLayersPanel.this.mContactLayerListModel.getContactLayer(ContactLayersPanel.this.mTable.getSelectedRow());
                Long fromUserHeight = this.unit.fromUserString(this.height.getText());
                if (def.getHeight() != fromUserHeight.longValue()) {
                    Cp.exec((String)"_contactLayer = curDb().getByKeyStr(ContactLayer.class, \"%s\")", (Object[])new Object[]{def.getKeyStr()});
                    Cp.exec((String)"_contactLayer.setHeight(%dL)", (Object[])new Object[]{fromUserHeight});
                }
                return state;
            }
        }

        class TableButtonMouseListener
        extends MouseAdapter {
            protected JTable table;

            public TableButtonMouseListener(JTable table) {
                this.table = table;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopUpMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopUpMenu(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopUpMenu(e);
                } else if (e.getClickCount() > 1) {
                    this.triggerTableCellAction(e);
                }
            }

            private int getRow(MouseEvent e) {
                return e.getY() / ContactLayersPanel.this.mTable.getRowHeight();
            }

            private int getCol(MouseEvent e) {
                TableColumnModel columnModel = ContactLayersPanel.this.mTable.getColumnModel();
                return columnModel.getColumnIndexAtX(e.getX());
            }

            private void showPopUpMenu(MouseEvent e) {
                int mouseRow = this.getRow(e);
                if (mouseRow >= ContactLayersPanel.this.mTable.getRowCount()) {
                    return;
                }
                JPopupMenu pop = this.getPopupMenu(mouseRow);
                this.showPopupMenu(e, pop);
            }

            private boolean hasViolation(int mouseRow) {
                return ContactLayersPanel.this.mContactLayerListModel.getCheckEngine(mouseRow).getViolationCount() != 0;
            }

            private JPopupMenu getPopupMenu(int mouseRow) {
                JPopupMenu pop = new JPopupMenu();
                JMenuItem refreshMenu = this.getRefreshMenuItem(mouseRow);
                pop.add(refreshMenu);
                pop.addSeparator();
                JMenuItem optionsMenu = this.getOptionsMenuItem(mouseRow);
                pop.add(optionsMenu);
                if (this.hasViolation(mouseRow)) {
                    JMenuItem checkingDetailMenu = this.getCheckDetailMenuItem(mouseRow);
                    pop.add(checkingDetailMenu);
                }
                pop.addSeparator();
                if (this.hasViolation(mouseRow)) {
                    JMenuItem contactDevMenu = this.getGenerateContactDevMenuItem(mouseRow);
                    pop.add(contactDevMenu);
                }
                JMenuItem exportPinMapMenu = this.getExportPinMapMenuItem(mouseRow);
                pop.add(exportPinMapMenu);
                JMenuItem autoNetMapMenu = this.getAutoNetMapMenuItem(mouseRow);
                pop.add(autoNetMapMenu);
                JMenu deleteMenu = this.getDeleteMenu(mouseRow);
                pop.add(deleteMenu);
                return pop;
            }

            private JMenuItem getGenerateContactDevMenuItem(final int mouseRow) {
                JMenuItem contactDevMenu = new JMenuItem(new AbstractAction("Generate Contacts"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ContactLayer cl = ContactLayersPanel.this.mContactLayerListModel.getContactLayer(mouseRow);
                        ContactDeviceFactoryUI contactDeviceFactoryDlg = ContactDeviceFactoryUI.createDialog((Window)((Object)EditContactLayerUI.this), EditContactLayerUI.this.mDb, cl);
                        contactDeviceFactoryDlg.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e) {
                                EditContactLayerUI.this.mContactLayersPnl.removeInvalidContactLayer();
                                EditContactLayerUI.this.mContactLayersPnl.addMissingContactLayer();
                                EditContactLayerUI.this.mContactLayersPnl.rebuildTable();
                            }
                        });
                    }
                });
                contactDevMenu.setIcon(DbExplorerPanel.getIconForTemplateType(DeviceTemplate.Type.CONTACT_DEVICE));
                return contactDevMenu;
            }

            private JMenu getDeleteMenu(int mouseRow) {
                JMenu menu = new JMenu("Delete");
                menu.setIcon(OrbitIcons.CROSS);
                JMenuItem deleteContactLayerItem = this.getDeleteContactLayerMenuItem(mouseRow);
                menu.add(deleteContactLayerItem);
                JMenuItem deleteContactsItem = this.getDeleteContactsMenuItem(mouseRow);
                menu.add(deleteContactsItem);
                return menu;
            }

            private JMenuItem getDeleteContactLayerMenuItem(final int mouseRow) {
                return new JMenuItem(new AbstractAction("Contact Layer"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try (DbHistory.DbTransaction dbTransaction = DbHistory.newDbTransaction((Db)EditContactLayerUI.this.getDb(), (String)"Delete contact layer");){
                            if (ContactLayersPanel.this.mTable.getSelectedRowCount() == 0) {
                                TableButtonMouseListener.this.deleteContactLayer(mouseRow);
                                ContactLayersPanel.this.mContactLayerListModel.removeContactLayer(mouseRow);
                            } else {
                                int[] selectedRows;
                                for (int row : selectedRows = ContactLayersPanel.this.mTable.getSelectedRows()) {
                                    TableButtonMouseListener.this.deleteContactLayer(row);
                                }
                                ContactLayersPanel.this.mContactLayerListModel.removeContactLayers(selectedRows);
                            }
                        }
                        ContactLayersPanel.this.mContactLayerListModel.rebuildTable();
                    }
                });
            }

            private JMenuItem getDeleteContactsMenuItem(final int mouseRow) {
                return new JMenuItem(new AbstractAction("Contacts"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try (DbHistory.DbTransaction dbTransaction = DbHistory.newDbTransaction((Db)EditContactLayerUI.this.getDb(), (String)"Delete contacts");){
                            if (ContactLayersPanel.this.mTable.getSelectedRowCount() == 0) {
                                this.deleteContacts(mouseRow);
                            } else {
                                int[] selectedRows;
                                for (int row : selectedRows = ContactLayersPanel.this.mTable.getSelectedRows()) {
                                    this.deleteContacts(row);
                                }
                            }
                        }
                        ContactLayersPanel.this.mContactLayerListModel.rebuildTable();
                    }

                    private void deleteContacts(int row) {
                        ContactLayer cl = ContactLayersPanel.this.mContactLayerListModel.getContactLayer(row);
                        if (!cl.isValid()) {
                            ContactLayersPanel.this.mContactLayerListModel.removeContactLayer(cl);
                            return;
                        }
                        DeleteContactUI.DeleteActionType op = DeleteContactUI.DeleteActionType.PIN;
                        if (cl.getDevicePathB().getIsAbstractContactDevice()) {
                            op = this.showWarningDialog(cl.getDevicePathB());
                        }
                        if (op == DeleteContactUI.DeleteActionType.PIN) {
                            DeleteContactUI.cpDeletePins(cl.getKeyStr(), false);
                            ContactLayersPanel.this.mContactLayerListModel.refreshCheck(cl);
                        } else if (op == DeleteContactUI.DeleteActionType.DEVICE) {
                            DevicePath devPathA = cl.getDevicePathA();
                            Layer layerA = cl.getContactLayerA();
                            DevicePath devPathB = cl.getDevicePathB().getParent();
                            Layer layerB = cl.getContactLayerB();
                            ContactLayersPanel.this.mContactLayerListModel.removeContactLayer(cl);
                            DeleteContactUI.cpDeleteDevs(cl.getKeyStr(), false);
                            ContactLayer newCl = ContactLayer.get((DevicePath)devPathA, (Layer)layerA, (DevicePath)devPathB, (Layer)layerB);
                            if (newCl != null && newCl.isValid()) {
                                ContactLayersPanel.this.mContactLayerListModel.addContactLayer(newCl);
                            }
                        }
                    }

                    private DeleteContactUI.DeleteActionType showWarningDialog(DevicePath devPath) {
                        if (AApp.getApp().getMainWin() == null || OrbitApp.suppressWaringDialogs()) {
                            return DeleteContactUI.DeleteActionType.DEVICE;
                        }
                        String title = "Delete Contacts";
                        String message = String.format("'%s' is a contact device", devPath);
                        Object obj = OrbitApp.showWarningConfirmDialog((String)message, (String)title, (Object[])DeleteContactUI.DeleteActionType.values(), (Object)((Object)DeleteContactUI.DeleteActionType.DEVICE));
                        return (DeleteContactUI.DeleteActionType)((Object)obj);
                    }
                });
            }

            private JMenuItem getAutoNetMapMenuItem(final int mouseRow) {
                return new JMenuItem(new AbstractAction("Auto-Connect Net"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LinkedList<Integer> targetRows = new LinkedList<Integer>();
                        if (ContactLayersPanel.this.mTable.getSelectedRowCount() == 0) {
                            targetRows.add(mouseRow);
                        } else {
                            for (int row2 : ContactLayersPanel.this.mTable.getSelectedRows()) {
                                targetRows.add(row2);
                            }
                        }
                        try (DbHistory.DbTransaction dbTransaction = DbHistory.newDbTransaction((Db)EditContactLayerUI.this.getDb(), (String)"Auto-Connect Net");){
                            this.cpAutoNetMap(targetRows);
                        }
                        targetRows.forEach(row -> ContactLayersPanel.this.mContactLayerListModel.refreshCheck((int)row, PinMapCheck.CheckType.NET_MAPPING));
                        ContactLayersPanel.this.mContactLayerListModel.rebuildTable();
                    }

                    private void cpAutoNetMap(List<Integer> contactLayers) {
                        Cp.exec((String)"unset(\"_netMapGenerator\");", (Object[])new Object[0]);
                        Cp.exec((String)"_netMapGenerator = new com.sigrity.orbit.automation.pinMap.NetMapGenerator(curDb());", (Object[])new Object[0]);
                        for (int row : contactLayers) {
                            ContactLayer contactLayer = ContactLayersPanel.this.mContactLayerListModel.getContactLayer(row);
                            String contactLayerStr = String.format("curDb().getByKeyStr(ContactLayer.class, \"%s\")", contactLayer.getKeyStr());
                            Cp.exec((String)"_netMapGenerator.addContactLayer(%s)", (Object[])new Object[]{contactLayerStr});
                        }
                        Cp.exec((String)"_netMapGenerator.createNetMapFromPinMap()", (Object[])new Object[0]);
                        Cp.exec((String)"unset(\"_netMapGenerator\");", (Object[])new Object[0]);
                    }
                });
            }

            private JMenuItem getExportPinMapMenuItem(final int mouseRow) {
                return new JMenuItem(new AbstractAction("Export PinMaps Csv"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LinkedList<ContactLayer> contactLayers = new LinkedList<ContactLayer>();
                        if (ContactLayersPanel.this.mTable.getSelectedRowCount() == 0) {
                            contactLayers.add(ContactLayersPanel.this.mContactLayerListModel.getContactLayer(mouseRow));
                        } else {
                            for (int row : ContactLayersPanel.this.mTable.getSelectedRows()) {
                                contactLayers.add(ContactLayersPanel.this.mContactLayerListModel.getContactLayer(row));
                            }
                        }
                        PinMapExportUI ui = new PinMapExportUI(contactLayers);
                        ui.showUI();
                    }
                });
            }

            private JMenuItem getCheckDetailMenuItem(final int mouseRow) {
                return new JMenuItem(new AbstractAction("Checking Details..."){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        List<Integer> rows = Arrays.stream(TableButtonMouseListener.this.table.getSelectedRows()).boxed().collect(Collectors.toList());
                        if (rows.isEmpty()) {
                            rows.add(mouseRow);
                        }
                        List<PinMapCheck> checkEngines = ContactLayersPanel.this.mContactLayerListModel.getCheckEngine(rows);
                        PinMapCheckEngineUI.createDialog(OrbitIO.getMainWindow(), OrbitIO.getApp().getCurrentDb(), checkEngines);
                    }
                });
            }

            private JMenuItem getOptionsMenuItem(final int mouseRow) {
                JMenuItem optionsMenu = new JMenuItem(new AbstractAction("Options"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        final LinkedList<ContactLayer> contactLayers = new LinkedList<ContactLayer>();
                        if (ContactLayersPanel.this.mTable.getSelectedRowCount() == 0) {
                            contactLayers.add(ContactLayersPanel.this.mContactLayerListModel.getContactLayer(mouseRow));
                        } else {
                            for (int row : ContactLayersPanel.this.mTable.getSelectedRows()) {
                                contactLayers.add(ContactLayersPanel.this.mContactLayerListModel.getContactLayer(row));
                            }
                        }
                        OptionsDlg dlg = new OptionsDlg(EditContactLayerUI.this.mDb, (Window)((Object)EditContactLayerUI.this), EditContactLayerUI.this.mDefaultOptions, contactLayers);
                        dlg.setVisible(true);
                        dlg.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e) {
                                Platform.runLater(() -> EditContactLayerUI.this.mContactLayersPnl.reloadCheckEngine(contactLayers));
                            }
                        });
                    }
                });
                optionsMenu.setIcon(DBEResources.ICON_COG_EDIT);
                return optionsMenu;
            }

            private JMenuItem getRefreshMenuItem(final int mouseRow) {
                JMenuItem refreshMenu = new JMenuItem(new AbstractAction("Refresh"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LinkedList<Integer> rows = new LinkedList<Integer>();
                        if (ContactLayersPanel.this.mTable.getSelectedRowCount() == 0) {
                            rows.add(mouseRow);
                        } else {
                            for (int row : ContactLayersPanel.this.mTable.getSelectedRows()) {
                                rows.add(row);
                            }
                        }
                        this.refreshPinMap(rows);
                        this.refreshCheck(rows);
                        ContactLayersPanel.this.mContactLayerListModel.rebuildTable();
                    }

                    private void refreshPinMap(List<Integer> rows) {
                        rows.forEach(row -> {
                            ContactLayer contactLayer = ContactLayersPanel.this.mContactLayerListModel.getContactLayer((int)row);
                            EditContactLayerUI.cpRecreatePinMaps(contactLayer);
                        });
                    }

                    private void refreshCheck(List<Integer> rows) {
                        rows.forEach(row -> ContactLayersPanel.this.mContactLayerListModel.getCheckEngine((int)row).execute());
                    }
                });
                refreshMenu.setIcon(OrbitIcons.REFRESH);
                return refreshMenu;
            }

            private void showPopupMenu(MouseEvent e, JPopupMenu pop) {
                if (pop == null) {
                    return;
                }
                pop.show(e.getComponent(), e.getX(), e.getY());
            }

            private void triggerTableCellAction(MouseEvent e) {
                int mouseRow = this.getRow(e);
                int mouseCol = this.getCol(e);
                if (mouseCol == 0 && mouseRow < ContactLayersPanel.this.mTable.getRowCount()) {
                    PinMapCheck checkEngine = ContactLayersPanel.this.mContactLayerListModel.getCheckEngine(mouseRow);
                    PinMapCheckEngineUI.createDialog(OrbitIO.getMainWindow(), OrbitIO.getApp().getCurrentDb(), checkEngine);
                }
            }

            private void deleteContactLayer(int row) {
                ContactLayer cl = ContactLayersPanel.this.mContactLayerListModel.getContactLayer(row);
                this.resetIsAbstract(cl.getDeviceTemplateA());
                this.resetIsAbstract(cl.getDeviceTemplateB());
                Cp.exec((String)"%s.deleteFromDb()", (Object[])new Object[]{CpHelper.getObjCmdStr(cl)});
            }

            private void resetIsAbstract(DeviceTemplate devT) {
                if (devT.getSourceType() == DeviceTemplate.SourceType.ORBITIO_CONTACT) {
                    return;
                }
                long numContactLayer = ContactLayer.getValid((Db)EditContactLayerUI.this.mDb).stream().filter(cl -> cl.getDeviceTemplateA() == devT || cl.getDeviceTemplateB() == devT).count();
                if (numContactLayer > 1L) {
                    Cp.exec((String)"%s.setIsAbstractContactDevice(false)", (Object[])new Object[]{CpHelper.getObjCmdStr(devT)});
                }
            }
        }

        public class ContactLayerRowRenderer
        extends DefaultTableCellRenderer {
            @Override
            public Component getTableCellRendererComponent(JTable table, Object o, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, o, isSelected, hasFocus, row, column);
                ContactLayer def = ContactLayersPanel.this.mContactLayerListModel.getContactLayer(row);
                if (def == null || !def.isValid()) {
                    ContactLayersPanel.this.mContactLayerListModel.removeContactLayer(def);
                    ContactLayersPanel.this.mContactLayerListModel.rebuildTable();
                    return this;
                }
                this.setIcon(null);
                this.setText(null);
                this.setForeground(Color.black);
                this.setBackground(Color.white);
                this.setToolTipText(null);
                this.setHorizontalAlignment(2);
                if (isSelected) {
                    this.setBackground(Color.orange);
                }
                switch (TableHeader.get(column)) {
                    case CHECK: {
                        this.setHorizontalAlignment(0);
                        int violationCount = ContactLayersPanel.this.mContactLayerListModel.getViolationCount(row);
                        if (violationCount == 0) {
                            this.setIcon(OrbitIcons.CHECK);
                            break;
                        }
                        this.setIcon(OrbitIcons.EXCLAMATION);
                        this.setToolTipText(String.format("Violation Count: %d", violationCount));
                        break;
                    }
                    case DEVICEPATH1: {
                        this.setText(this.getUsertPathText(def.getDevicePathA()));
                        this.setIcon(DbExplorerPanel.getIconForTemplate(def.getDeviceTemplateA()));
                        break;
                    }
                    case CONTACTLAYER1: {
                        this.setText(def.getContactLayerA().getName());
                        break;
                    }
                    case DEVICEPATH2: {
                        this.setText(this.getUsertPathText(def.getDevicePathB()));
                        this.setIcon(DbExplorerPanel.getIconForTemplate(def.getDeviceTemplateB()));
                        break;
                    }
                    case CONTACTLAYER2: {
                        this.setText(def.getContactLayerB().getName());
                        break;
                    }
                    case HEIGHT: {
                        this.setText(EditContactLayerUI.this.getUnitDist().toUserStr(def.getHeight()));
                    }
                }
                return this;
            }

            private String getUsertPathText(DevicePath relPath) {
                DevicePath fullPathA = relPath.getAFullPath();
                return fullPathA == null ? relPath.escapedString() : fullPathA.toString();
            }
        }

        public class ColumnHeaderRender
        implements TableCellRenderer {
            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                TableCellRenderer tableHeaderRenderer = table.getTableHeader().getDefaultRenderer();
                Component component = tableHeaderRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                JLabel label = null;
                if (!(component instanceof JLabel)) {
                    return null;
                }
                label = (JLabel)component;
                label.setToolTipText(null);
                label.setIcon(null);
                if (TableHeader.get(column) == TableHeader.CHECK) {
                    label.setIcon(DBEResources.ICON_DBRELATION);
                }
                return component;
            }
        }

        class ContactLayerList
        extends AbstractTableModel {
            List<ContactLayer> contactLayerRows = new LinkedList<ContactLayer>();
            Map<ContactLayer, PinMapCheck> contactLayer2CheckEngine = new HashMap<ContactLayer, PinMapCheck>();

            ContactLayerList() {
            }

            public ContactLayer getContactLayer(int row) {
                if (row < this.contactLayerRows.size()) {
                    return this.contactLayerRows.get(row);
                }
                return null;
            }

            public List<ContactLayer> getContactLayer(List<Integer> rows) {
                LinkedList<ContactLayer> contactLayers = new LinkedList<ContactLayer>();
                rows.forEach(row -> {
                    if (row < this.contactLayerRows.size()) {
                        contactLayers.add(this.contactLayerRows.get((int)row));
                    }
                });
                return contactLayers;
            }

            public PinMapCheck getCheckEngine(int row) {
                return this.getCheckEngine(this.getContactLayer(row));
            }

            public List<PinMapCheck> getCheckEngine(List<Integer> rows) {
                List<ContactLayer> contactLayers = this.getContactLayer(rows);
                LinkedList<PinMapCheck> pinMapChecks = new LinkedList<PinMapCheck>();
                contactLayers.forEach(cl -> pinMapChecks.add(this.getCheckEngine((ContactLayer)cl)));
                return pinMapChecks;
            }

            private PinMapCheck getCheckEngine(ContactLayer contactLayer) {
                return this.contactLayer2CheckEngine.get(contactLayer);
            }

            public boolean containContactLayer(ContactLayer contactLayer) {
                return this.contactLayer2CheckEngine.containsKey(contactLayer);
            }

            public void removeInvalidContactLayer() {
                Iterator<ContactLayer> itr = this.contactLayerRows.iterator();
                while (itr.hasNext()) {
                    ContactLayer cl = itr.next();
                    if (cl != null && cl.isValid()) continue;
                    this.contactLayer2CheckEngine.remove(cl);
                    itr.remove();
                }
            }

            public int getViolationCount(int row) {
                return this.getCheckEngine(row).getViolationCount();
            }

            public void addContactLayer(DevicePath devicePathA, Layer layerA, DevicePath devicePathB, Layer layerB) {
                this.addContactLayer(ContactLayer.create((DevicePath)devicePathA, (Layer)layerA, (DevicePath)devicePathB, (Layer)layerB));
            }

            public void addContactLayer(ContactLayer contactLayer) {
                this.contactLayerRows.add(contactLayer);
                this.loadCheckEngine(contactLayer);
            }

            private void loadCheckEngine(ContactLayer contactLayer) {
                PinMapCheck checkEngine = EditContactLayerUI.this.mDefaultOptions.getCheckEngine(contactLayer);
                this.contactLayer2CheckEngine.put(contactLayer, checkEngine);
                checkEngine.execute();
            }

            public void removeContactLayer(ContactLayer contactLayer) {
                this.contactLayerRows.remove(contactLayer);
                this.contactLayer2CheckEngine.remove(contactLayer);
            }

            public void removeContactLayer(int row) {
                ContactLayer removedCL = this.contactLayerRows.remove(row);
                this.contactLayer2CheckEngine.remove(removedCL);
            }

            public void removeContactLayers(int[] rows) {
                Arrays.sort(rows);
                ArrayUtils.reverse((int[])rows);
                for (int row : rows) {
                    this.removeContactLayer(row);
                }
            }

            public void refreshChecks() {
                this.contactLayer2CheckEngine.values().stream().forEach(PinMapCheck::execute);
            }

            public void refreshChecks(PinMapCheck.CheckType checkType) {
                this.contactLayer2CheckEngine.values().stream().forEach(engine -> engine.execute(checkType));
            }

            public void refreshCheck(int row, PinMapCheck.CheckType checkType) {
                PinMapCheck checkEngine = this.getCheckEngine(row);
                if (checkEngine != null) {
                    checkEngine.execute(checkType);
                }
            }

            public void refreshCheck(int row) {
                PinMapCheck checkEngine = this.getCheckEngine(row);
                if (checkEngine != null) {
                    checkEngine.execute();
                }
            }

            public void refreshCheck(ContactLayer contactLayer) {
                PinMapCheck checkEngine = this.getCheckEngine(contactLayer);
                if (checkEngine != null) {
                    checkEngine.execute();
                }
            }

            public void clearTable() {
                this.contactLayerRows.clear();
            }

            public void rebuildTable() {
                ContactLayersPanel.this.mTable.clearSelection();
                this.removeInvalidContactLayer();
                Collections.sort(this.contactLayerRows);
                ContactLayersPanel.this.mTable.revalidate();
                ContactLayersPanel.this.mTable.repaint();
            }

            @Override
            public int getColumnCount() {
                return TableHeader.values().length;
            }

            @Override
            public String getColumnName(int col) {
                return TableHeader.get(col).getName();
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == TableHeader.HEIGHT.ordinal();
            }

            @Override
            public int getRowCount() {
                return this.contactLayerRows.size();
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return null;
            }
        }
    }

    public static final class TableHeader
    extends Enum<TableHeader> {
        public static final /* enum */ TableHeader CHECK = new TableHeader("");
        public static final /* enum */ TableHeader DEVICEPATH1 = new TableHeader("DevicePath A");
        public static final /* enum */ TableHeader CONTACTLAYER1 = new TableHeader("Layer A");
        public static final /* enum */ TableHeader DEVICEPATH2 = new TableHeader("DevicePath B");
        public static final /* enum */ TableHeader CONTACTLAYER2 = new TableHeader("Layer B");
        public static final /* enum */ TableHeader HEIGHT = new TableHeader("Height");
        private String name;
        private static final /* synthetic */ TableHeader[] $VALUES;

        public static TableHeader[] values() {
            return (TableHeader[])$VALUES.clone();
        }

        public static TableHeader valueOf(String name) {
            return Enum.valueOf(TableHeader.class, name);
        }

        static TableHeader get(int i) {
            assert (i < TableHeader.values().length);
            TableHeader[] instructionHeader = TableHeader.values();
            return instructionHeader[i];
        }

        private TableHeader(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        static {
            $VALUES = new TableHeader[]{CHECK, DEVICEPATH1, CONTACTLAYER1, DEVICEPATH2, CONTACTLAYER2, HEIGHT};
        }
    }
}

