/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.db.DbFieldDef;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.ui.editors.DbFieldEditor;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class EditDbFieldUI
extends DbDialog {
    protected DbObject mDbObj;
    protected DbFieldDef mDbField;
    Object mNewVal = null;
    protected DbFieldEditor<?> mFieldEditor;
    protected ActionListener mOK = e -> {
        if (this.mFieldEditor.hasNewValue()) {
            if (!this.mFieldEditor.validateNewValue()) {
                this.mFieldEditor.getEditor().requestFocus();
                JOptionPane.showMessageDialog(this.mFieldEditor.getEditor(), "Invalid value.", "Error", 0);
                return;
            }
            if (!this.save()) {
                JOptionPane.showMessageDialog(this.mFieldEditor.getEditor(), "Error saving value.", "Error", 0);
                this.mNewVal = null;
                return;
            }
        }
        UIUtil.closeWindow((Window)((Object)this));
    };

    public static boolean edit(DbObject dbo, DbFieldDef dbfd, Component owner) {
        DbFieldEditor fe = DbFieldEditor.getFieldEditor(dbfd, dbo);
        if (fe == null) {
            return false;
        }
        EditDbFieldUI dlg = new EditDbFieldUI(dbo, dbfd, fe, owner);
        dlg.setVisible(true);
        return dlg.mNewVal != null;
    }

    public static boolean editSet(Set<DbObject> dbos, DbFieldDef dbfd, Component owner) {
        DbObject dbo = dbos.iterator().next();
        DbFieldEditor fe = DbFieldEditor.getFieldEditor(dbfd, dbo);
        if (fe == null) {
            return false;
        }
        EditDbFieldUI dlg = new EditDbFieldUI(dbo, dbfd, fe, owner);
        dlg.setTitle(String.format("Edit Field ... (%d)", dbos.size()));
        dlg.setVisible(true);
        boolean change = dlg.mNewVal != null;
        for (DbObject obj : dbos) {
            dlg.changeTarget(obj);
            change |= dlg.save();
        }
        return change;
    }

    public <T> EditDbFieldUI(DbObject dbo, DbFieldDef dbfd, DbFieldEditor<T> fe, Component owner) {
        super(dbo.getDb(), owner, "Edit Field", Dialog.ModalityType.DOCUMENT_MODAL);
        this.setRecallBounds(false);
        this.mDbObj = dbo;
        this.mDbField = dbfd;
        this.mFieldEditor = fe;
        this.setTitle(String.format("Edit Field '%s'", this.mDbObj.toString()));
        GridBagManager l = GridBagManager.layout((Container)this.getContentPane());
        l.add("Field:");
        JTextField lblFieldName = (JTextField)l.add((Component)new JTextField(dbfd.getName()));
        lblFieldName.setEditable(false);
        lblFieldName.setBackground(null);
        lblFieldName.setBorder(null);
        String type = dbfd.getFieldClass() == null ? "[runtime]" : dbfd.getFieldClass().getName();
        String tt = String.format("Decalared Type: %s", type);
        lblFieldName.setToolTipText(tt);
        l.newline();
        l.add("Old value:", (GridBagConstraints)GridBagManager.TOPLEFT);
        JTextField txtOld = (JTextField)l.add((Component)new JTextField(fe.getValueAsString(fe.getOldValue())), (GridBagConstraints)GridBagManager.FILLX);
        txtOld.setEditable(false);
        l.newline();
        l.add("New value:", (GridBagConstraints)GridBagManager.TOPLEFT);
        GridBagConstraints newEditorConstraints = this.mFieldEditor.getPreferredConstraints();
        l.add((Component)this.mFieldEditor.getEditor(), newEditorConstraints);
        Dimension oldDim = txtOld.getPreferredSize();
        Dimension newDim = this.mFieldEditor.getEditor().getPreferredSize();
        if (oldDim.width > newDim.width) {
            txtOld.setPreferredSize(new Dimension(newDim.width, oldDim.height));
        }
        if (newEditorConstraints.fill != 3 && newEditorConstraints.fill != 1) {
            l.addFillY();
        }
        l.newline();
        l.push((GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
        l.addFillX();
        JButton btnOK = (JButton)l.add((Component)new JButton("OK"));
        btnOK.addActionListener(this.mOK);
        JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
        l.pop();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOK);
        this.pack();
        this.setMinimumSize(this.getMinimumSize());
        UIUtil.center((Component)((Object)this));
    }

    public void addNotify() {
        super.addNotify();
        this.mFieldEditor.getEditor().requestFocus();
    }

    private void changeTarget(DbObject obj) {
        this.mFieldEditor.changeTarget(obj);
        this.mDbObj = obj;
    }

    private boolean save() {
        this.mNewVal = this.mFieldEditor.getNewValue();
        return this.mFieldEditor.saveNewValue();
    }
}

