/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.ATransformUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.dbui.render.DeviceTemplateTypeListRenderer;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.DesignDialog;
import com.sigrity.orbit.ui.DeviceTemplateUI;
import com.sigrity.orbit.ui.DieExtentsUI;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.AffineTransform;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class EditDeviceUI
extends DesignDialog {
    protected static final int NUM_COLS = 12;
    protected static DesignView2D.ViewMode mOldMode;
    protected JButton mBtnCancel = new JButton("Cancel");
    protected JButton mBtnOk = new JButton("Ok");
    protected JComboBox<DeviceTemplate.Type> mType;
    protected JTextField mX;
    protected JTextField mY;
    protected JTextField mRotate;
    protected JCheckBox mMirror;
    protected long mDeviceCanvasLLX = 0L;
    protected long mDeviceCanvasLLY = 0L;
    protected long mDeviceCanvasWidth = 0L;
    protected long mDeviceCanvasHeight = 0L;
    protected boolean mDirectionLL;
    protected boolean mDbChanged = false;
    protected JPanel mPnlSize;
    protected JButton mSpecifyExtents;
    protected JRadioButton mAnchorCenter;
    protected JRadioButton mAnchorLL;
    protected JTextField mHeight = new JTextField(12);
    protected JTextField mWidth = new JTextField(12);
    protected final DevicePath mDevicePath;
    protected final Device mDevice;
    protected DeviceTemplate mTemplate;
    protected DbHistory.DbTransaction mTransaction;
    private WindowListener mUninstallModeListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            AAppView v = OrbitIO.getCurView();
            if (v instanceof DesignView2D) {
                ((DesignView2D)v).setMode(mOldMode);
            }
        }
    };
    static final String ARBITRARY = "Arbitrary";
    protected static boolean mRefreshBoundsFromUI;
    protected ActionListener mExtendChanged = e -> {
        this.mDirectionLL = !this.mAnchorCenter.isSelected();
    };
    protected ActionListener mTypeChangeListener = e -> {
        boolean isDieType = this.isEditingDie();
        this.mSpecifyExtents.setEnabled(isDieType);
    };
    protected ActionListener mApplyListener = e -> this.applyChangesFromUI();
    protected FocusListener mFocusListener = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent e) {
            EditDeviceUI.this.applyChangesFromUI();
        }
    };
    protected ActionListener mCancelListener = e -> {
        this.cancelTransaction();
        this.mTransaction.close();
        ((DesignView2D)OrbitIO.getCurView()).setMode(mOldMode);
        OrbitIO.getApp().refreshCurrentView(false);
        DbExplorerPanel.refreshAll();
    };
    protected ActionListener mOkListener = e -> {
        this.mTransaction.close();
        ((DesignView2D)OrbitIO.getCurView()).setMode(mOldMode);
        OrbitIO.getApp().refreshCurrentView(false);
        DbExplorerPanel.refreshAll();
    };

    public static boolean getNeedRefreshBound() {
        return mRefreshBoundsFromUI;
    }

    public static void clearNeedRefreshBound() {
        mRefreshBoundsFromUI = false;
    }

    public static EditDeviceUI showMe(Window owner, DevicePath path, DesignView2D.ViewMode oldMode) {
        if (path == null || path.isEmpty()) {
            ALog.logDebug((String)"Cannot Edit Device without path");
            return null;
        }
        EditDeviceUI ui = new EditDeviceUI(owner, path);
        ui.setVisible(true);
        mOldMode = oldMode;
        return ui;
    }

    public String getAnchorStr() {
        return this.mAnchorCenter.toString();
    }

    public void setDeviceCanvasLLX(long x) {
        this.mDeviceCanvasLLX = x;
    }

    public void setDeviceCanvasLLY(long y) {
        this.mDeviceCanvasLLY = y;
    }

    public void setDeviceCanvasWidth(long width) {
        this.mDeviceCanvasWidth = width;
    }

    public void setDeviceCanvasHeight(long height) {
        this.mDeviceCanvasHeight = height;
    }

    public void setFieldMX(long mx) {
        String value = this.formatUserDist(mx);
        this.mX.setText(value);
    }

    public void setFieldMY(long my) {
        String value = this.formatUserDist(my);
        this.mY.setText(value);
    }

    public void setFieldMHeight(long height) {
        String value = this.formatUserDistAbs(height);
        this.mHeight.setText(value);
    }

    public void setFieldMWidth(long width) {
        String value = this.formatUserDistAbs(width);
        this.mWidth.setText(value);
    }

    public void updateDb(boolean fromUI) {
        if (this.mDevicePath == null) {
            return;
        }
        if (this.mDevice == null) {
            return;
        }
        if (!this.validateFields()) {
            return;
        }
        APoint2D loc = this.mDevice.getLoc();
        float r = this.mDevice.getRotate();
        boolean m = this.mDevice.getMirror();
        Unit u = this.getUnitDist();
        long x = u.fromUserString(this.mX.getText());
        long y = u.fromUserString(this.mY.getText());
        float rotate = Float.parseFloat(this.mRotate.getText());
        boolean mirror = this.mMirror.isSelected();
        long height = u.fromUserString(this.mHeight.getText());
        long width = u.fromUserString(this.mWidth.getText());
        if (fromUI) {
            if (x != loc.getX() || y != loc.getY() || rotate != r || mirror != m) {
                Cp.exec((String)"UserCommands.moveDevice(\"%s\", %dL, %dL, %fF, %s, false, false, false, false, true, false)", (Object[])new Object[]{this.mDevicePath.toString(), x, y, Float.valueOf(rotate), Boolean.toString(mirror)});
            }
            Cp.exec((String)"%s.changeDeviceTemplate(\"%s\", %dL, %dL, %b)", (Object[])new Object[]{DeviceTemplateUI.class.getName(), this.mDevicePath.toString(), width, height, this.mDirectionLL});
        } else {
            AffineTransform worldTransform = this.mDevicePath.getTransform();
            ARect newWorldBounds = new ARect(this.mDeviceCanvasLLX, this.mDeviceCanvasLLY, this.mDeviceCanvasLLX + this.mDeviceCanvasWidth, this.mDeviceCanvasLLY + this.mDeviceCanvasHeight);
            AffineTransform inverseWorldTransform = ATransformUtil.inverse((AffineTransform)worldTransform);
            ARect newLocalBounds = newWorldBounds.transform(inverseWorldTransform).getBounds();
            String execRectCmd = newLocalBounds.getAsStringArg();
            Cp.exec((String)"curDb().getByKeyStr(com.sigrity.acl.db.std.DeviceTemplate.class, \"%s\").setValue(\"bounds\", %s)", (Object[])new Object[]{this.mTemplate.getKeyStr(), execRectCmd});
            this.mHeight.setText(this.formatUserDistAbs(this.mTemplate.getBounds(true).getBounds().height()));
            this.mWidth.setText(this.formatUserDistAbs(this.mTemplate.getBounds(true).getBounds().width()));
        }
        String type = this.mType.getSelectedItem().toString();
        if (this.mTemplate.getType() != DeviceTemplate.Type.valueOf((String)type)) {
            Cp.exec((String)"com.sigrity.orbit.ui.DeviceTemplateUI.changeDeviceTemplate(\"%s\", \"%s\")", (Object[])new Object[]{this.mDevicePath, this.mType.getSelectedItem()});
        }
        OrbitIO.getApp().refreshCurrentView(false);
        DbExplorerPanel.refreshAll();
        this.mDbChanged = true;
    }

    protected EditDeviceUI(Window owner, DevicePath path) {
        super(path.getLast().getDb(), owner);
        this.mDevicePath = path;
        this.mDevice = path.getLast();
        Objects.requireNonNull(this.mDevice);
        this.mTemplate = this.mDevice.getTemplate();
        Objects.requireNonNull(this.mTemplate);
        this.setTitle(String.format("Edit Device '%s'", this.mDevice.getName()));
        GridBagManager l = new GridBagManager((Container)((Object)this));
        l.pushRemainX("Placement");
        l.add("X:", (GridBagConstraints)GridBagManager.LEFT);
        this.mX = new JTextField(this.formatUserDist(this.mDevice.getLoc().getX()), 12);
        this.mX.addFocusListener(this.mFocusListener);
        this.mX.addActionListener(this.mApplyListener);
        l.add((Component)this.mX, (GridBagConstraints)GridBagManager.LEFT);
        l.add("Y:", (GridBagConstraints)GridBagManager.LEFT);
        this.mY = new JTextField(this.formatUserDist(this.mDevice.getLoc().getY()), 12);
        this.mY.addFocusListener(this.mFocusListener);
        this.mY.addActionListener(this.mApplyListener);
        l.add((Component)this.mY, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        l.newline();
        l.add((Component)new JLabel("Rotation:"), (GridBagConstraints)GridBagManager.LEFT);
        this.mRotate = new JTextField(Float.toString(this.mDevice.getRotate()), 12);
        this.mRotate.addFocusListener(this.mFocusListener);
        this.mRotate.addActionListener(this.mApplyListener);
        l.add((Component)this.mRotate, (GridBagConstraints)GridBagManager.LEFT);
        l.newline();
        this.mMirror = new JCheckBox("Mirror and invert layer stack");
        this.mMirror.setToolTipText("Sets the device mirror and, if modified, inverts the device's current flip");
        this.mMirror.setSelected(this.mDevice.getMirror());
        this.mMirror.addFocusListener(this.mFocusListener);
        this.mMirror.addActionListener(this.mApplyListener);
        l.add((Component)this.mMirror, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        l.popNl();
        l.pushFillX("Device Template Parameters:");
        l.pushFillX();
        l.add((Component)new JLabel("Type:"), (GridBagConstraints)GridBagManager.LEFT);
        this.mType = new JComboBox();
        this.mType.setRenderer(new DeviceTemplateTypeListRenderer());
        l.add(this.mType, (GridBagConstraints)GridBagManager.FILLX);
        l.popNl();
        DeviceTemplate.Type[] s = DeviceTemplate.Type.values();
        DeviceTemplate.Type tType = this.mTemplate.getType();
        for (DeviceTemplate.Type t : s) {
            if (t.getUserName() == null) continue;
            this.mType.addItem(t);
        }
        if (tType.getUserName() == null) {
            this.mType.addItem(tType);
        }
        this.mType.setSelectedItem(tType);
        this.mType.addActionListener(this.mApplyListener);
        this.mType.addActionListener(this.mTypeChangeListener);
        this.mAnchorCenter = new JRadioButton("Center");
        this.mAnchorLL = new JRadioButton("Lower Left");
        ARect r = this.mTemplate.getBounds(true).getBounds();
        long height = r.height();
        long width = r.width();
        this.mWidth.setName("Width");
        this.mWidth.setText(this.formatUserDistAbs(width));
        this.mWidth.addFocusListener(this.mFocusListener);
        this.mWidth.addActionListener(this.mApplyListener);
        this.mHeight.setName("Height");
        this.mHeight.setText(this.formatUserDistAbs(height));
        this.mHeight.addFocusListener(this.mFocusListener);
        this.mHeight.addActionListener(this.mApplyListener);
        this.mPnlSize = l.pushFillX("Size");
        l.add("Extend From:", (GridBagConstraints)GridBagManager.LEFT);
        l.pushFill();
        l.add((Component)this.mAnchorLL);
        l.add((Component)this.mAnchorCenter);
        UIUtil.groupButtons((AbstractButton[])new AbstractButton[]{this.mAnchorLL, this.mAnchorCenter});
        if (Math.abs(r.getLL().getX()) == Math.abs(r.getUR().getX()) && Math.abs(r.getLL().getY()) == Math.abs(r.getUR().getY())) {
            this.mAnchorLL.setSelected(false);
            this.mDirectionLL = false;
        } else {
            this.mAnchorLL.setSelected(true);
            this.mDirectionLL = true;
        }
        this.mAnchorCenter.addActionListener(this.mExtendChanged);
        this.mAnchorLL.addActionListener(this.mExtendChanged);
        l.addFillX();
        l.popNl();
        l.newline();
        l.add("Width:").setLabelFor(this.mWidth);
        l.add((Component)this.mWidth, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        l.newline();
        l.add("Height:").setLabelFor(this.mHeight);
        l.add((Component)this.mHeight, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        l.popNl();
        this.mSpecifyExtents = new JButton("Edit Die Extents");
        this.mSpecifyExtents.setEnabled(tType == DeviceTemplate.Type.DIE);
        this.mSpecifyExtents.setIcon(OrbitIcons.COG_EDIT);
        this.mSpecifyExtents.setToolTipText("Check to specify the extents for the Die");
        this.mSpecifyExtents.addActionListener(e -> DieExtentsUI.showDialog(this.mTemplate));
        l.add((Component)this.mSpecifyExtents, (GridBagConstraints)GridBagManager.RIGHT);
        l.popNl();
        l.addFillY();
        l.addFillX();
        l.add((Component)this.mBtnOk, (GridBagConstraints)GridBagManager.RIGHT);
        l.add((Component)this.mBtnCancel, (GridBagConstraints)GridBagManager.RIGHT);
        this.setModal(false);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        UIUtil.enableDefaultBtn((JDialog)((Object)this), (JButton)this.mBtnOk);
        UIUtil.enableEscapeClose((Window)((Object)this), (AbstractButton)this.mBtnOk);
        UIUtil.enableEscapeClose((Window)((Object)this), (AbstractButton)this.mBtnCancel);
        UIUtil.center((Component)((Object)this));
        this.mBtnCancel.addActionListener(this.mCancelListener);
        this.mBtnOk.addActionListener(this.mOkListener);
        this.addWindowListener(this.mUninstallModeListener);
        this.mTransaction = this.createTransaction();
    }

    public void removeUninstallModeListener() {
        this.removeWindowListener(this.mUninstallModeListener);
    }

    private DbHistory.DbTransaction createTransaction() {
        return DbHistory.newDbTransaction((Db)this.mDb, (String)"Edit Device");
    }

    private void cancelTransaction() {
        if (this.mTransaction != null) {
            this.mTransaction.cancel();
        }
    }

    protected void validateWidthHeight() {
        Unit u = this.getUnitDist();
        long height = Math.max(u.fromUserString(this.mHeight.getText()), 1L);
        long width = Math.max(u.fromUserString(this.mWidth.getText()), 1L);
        this.setFieldMHeight(height);
        this.setFieldMWidth(width);
    }

    private boolean isEditingDie() {
        return this.mType.getSelectedItem().equals(DeviceTemplate.Type.DIE);
    }

    void applyChangesFromUI() {
        this.validateWidthHeight();
        this.updateDb(true);
        mRefreshBoundsFromUI = true;
    }

    protected String formatUserDist(long v) {
        return this.getUnitDist().toUserStr(v);
    }

    protected String formatUserDistAbs(long v) {
        return this.getUnitDist().toUserStr(Math.abs(v));
    }

    protected boolean validateFields() {
        try {
            AFieldValidator.validateDouble((JTextField)this.mX);
            AFieldValidator.validateDouble((JTextField)this.mY);
            AFieldValidator.validateDouble((JTextField)this.mRotate);
        }
        catch (AFieldValidator.AFieldValidationException fve) {
            return false;
        }
        return true;
    }

    static {
        mRefreshBoundsFromUI = false;
    }
}

