/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class EditPortUI
extends ADialog {
    protected static final int NUM_COLS = 12;
    protected DevicePath mDevicePath;
    protected PinTemplate mPinTemplate;
    protected JButton mBtnEdit = new JButton("Apply");
    protected JButton mBtnCancel = new JButton("Cancel");
    protected JComboBox<String> mNets;
    protected ActionListener mEditListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EditPortUI.this.mDevicePath == null) {
                return;
            }
            if (EditPortUI.this.mPinTemplate == null) {
                return;
            }
            String newNetName = EditPortUI.this.mNets.getSelectedItem().toString();
            if (!EditPortUI.this.mPinTemplate.getNet().getName().equalsIgnoreCase(newNetName)) {
                String command = "com.sigrity.orbit.ui.NetUI.reAssignNet (\"" + EditPortUI.this.mDevicePath.toString() + "\", \"" + EditPortUI.this.mPinTemplate.getName() + "\", \"" + newNetName + "\")";
                Cp.exec((String)command, (Object[])new Object[0]);
            }
            OrbitIO.getApp().refreshCurrentView(false);
            DbExplorerPanel.refreshAll();
        }
    };

    public static void showMe(Window owner, String pathString, PinTemplate dtp) {
        Db db = OrbitIO.getCurDb();
        DevicePath path = DevicePath.fromString((Db)db, (String)pathString);
        if (path == null) {
            return;
        }
        EditPortUI ui = new EditPortUI(owner, path, dtp);
        ui.setVisible(true);
    }

    public static void showMe(Window owner, DevicePath path, PinTemplate dtp) {
        if (path == null) {
            return;
        }
        EditPortUI ui = new EditPortUI(owner, path, dtp);
        ui.setVisible(true);
    }

    protected EditPortUI(Window owner, DevicePath path, PinTemplate dtp) {
        super(owner);
        this.mDevicePath = path;
        this.mPinTemplate = dtp;
        this.init();
    }

    protected void init() {
        Device d;
        String title = "Edit Pin";
        Device device = d = this.mDevicePath == null ? null : this.mDevicePath.getLast();
        if (d != null && this.mPinTemplate != null) {
            title = String.format("%s '%s-%s'", title, d.getName(), this.mPinTemplate.getName());
        }
        this.setTitle(title);
        GridBagManager l = new GridBagManager((Container)((Object)this));
        l.add((Component)new JLabel("Net:"), (GridBagConstraints)GridBagManager.LEFT);
        this.mNets = new JComboBox();
        l.add(this.mNets, (GridBagConstraints)GridBagManager.LEFT);
        l.newline();
        DeviceTemplate dt = d == null ? null : d.getTemplate();
        Net currentNet = this.mPinTemplate.getNet();
        currentNet = NetMap.getTopmostNet((Net)currentNet, (DevicePath)this.mDevicePath);
        int i = 0;
        for (Net n : dt.getNets()) {
            n = NetMap.getTopmostNet((Net)n, (DevicePath)this.mDevicePath);
            this.mNets.addItem(n.getName());
            if (n == currentNet) {
                this.mNets.setSelectedIndex(i);
            }
            ++i;
        }
        l.addFillAll();
        l.newline();
        l.addFillX();
        l.add((Component)this.mBtnEdit, (GridBagConstraints)GridBagManager.RIGHT);
        l.add((Component)this.mBtnCancel, (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        this.setModal(true);
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)this.mBtnCancel, (JButton)this.mBtnEdit);
        this.pack();
        UIUtil.center((Component)((Object)this));
        this.mBtnEdit.addActionListener(this.mEditListener);
    }
}

