/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.orbit.OrbitIO;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class ExportAIFUI {
    public static boolean showMe(String devicePathString) {
        AFileChooser fc = new AFileChooser();
        AFileFilter filter = new AFileFilter("aif", "AIF Files");
        fc.setFileFilter((FileFilter)filter);
        ExportAIFOptionsPanel options = new ExportAIFOptionsPanel();
        fc.setAccessory((JComponent)options);
        fc.setDialogTitle("Export AIF");
        if (fc.showSaveDialog((Component)OrbitIO.getMainWindow()) != 0) {
            return false;
        }
        File f = fc.getSelectedFile();
        Object path = f.getPath();
        if (fc.getFileFilter() == filter && !f.getName().contains(".")) {
            path = (String)path + ".aif";
        }
        Cp.exec((String)"OrbitIO.exportAIF(%s, \"%s\", %s, %s)", (Object[])new Object[]{Cp.getFileAsArgument((String)path), devicePathString, options.isWYSIWYG(), options.sortDiePads()});
        return true;
    }

    private static class ExportAIFOptionsPanel
    extends JPanel {
        JCheckBox mWYSIWYG;
        JCheckBox mSortDiePads;

        public ExportAIFOptionsPanel() {
            this.setBorder(BorderFactory.createTitledBorder("Export options"));
            GridBagManager l = new GridBagManager((Container)this);
            this.mWYSIWYG = new JCheckBox("WYSIWYG");
            l.add((Component)this.mWYSIWYG, (GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
            this.mWYSIWYG.setToolTipText("<html>Disabled switch will output the AIF of the Package <br>(or Die) in it's 0 rotation, non-mirrored orientation. <br> Enabled will  output theAIF of the Package (or Die) <br> as is in OIO... this will be the AIF default 0 rotation, <br>non-mirrored orientation</html>");
            l.newline();
            this.mSortDiePads = new JCheckBox("Sort Die Pads");
            l.add((Component)this.mSortDiePads, (GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
            this.mSortDiePads.setToolTipText("Radially sort (CCW) the die pads, die pads will be renumbered");
            l.newline();
            this.mSortDiePads.setSelected(true);
            l.addFillY();
        }

        @Override
        public void addNotify() {
            super.addNotify();
        }

        public boolean isWYSIWYG() {
            return this.mWYSIWYG.isSelected();
        }

        public boolean sortDiePads() {
            return this.mSortDiePads.isSelected();
        }
    }
}

