/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.ui.AComboBox;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.orbit.CCTFile.CCTFile;
import com.sigrity.orbit.OrbitIO;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class ExportCCTUI {
    public static boolean showMe(String devicePathString) {
        AFileChooser fc = new AFileChooser();
        ExportCCTOptionsPanel options = new ExportCCTOptionsPanel(fc);
        fc.setAccessory((JComponent)options);
        if (fc.showSaveDialog((Component)OrbitIO.getMainWindow()) != 0) {
            return false;
        }
        String fileType = "DesignFile";
        String ext = ".dsn";
        if (fc.getFileFilter().getDescription().contains("Route")) {
            fileType = "RouteFile";
            ext = ".rte";
        } else if (fc.getFileFilter().getDescription().contains("Wire")) {
            fileType = "WireFile";
            ext = ".wir";
        }
        File f = fc.getSelectedFile();
        Object path = f.getPath();
        if (!f.getName().contains(".")) {
            path = (String)path + ext;
        }
        Cp.exec((String)"OrbitIO.exportCCTFile(%s, \"%s\", \"%s\", %s)", (Object[])new Object[]{Cp.getFileAsArgument((String)path), devicePathString, fileType, options.isSelectedOnly()});
        return true;
    }

    private static class ExportCCTOptionsPanel
    extends JPanel {
        JCheckBox mSelectedOnly;
        AComboBox<String> mFileType;
        AFileChooser mFc;
        AFileFilter mFilter = new AFileFilter("dsn", "Design Files");

        public ExportCCTOptionsPanel(AFileChooser fc) {
            this.mFc = fc;
            this.setBorder(BorderFactory.createTitledBorder("Export options"));
            GridBagManager l = new GridBagManager((Container)this);
            JLabel la = new JLabel("File Type:");
            l.add((Component)la, (GridBagConstraints)GridBagManager.LEFT);
            this.mFileType = new AComboBox();
            l.add(this.mFileType, (GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
            l.newline();
            int n = CCTFile.FileType.values().length;
            CCTFile.FileType[] s = CCTFile.FileType.values();
            for (int i = 0; i < n; ++i) {
                this.mFileType.addItem((Object)s[i].name());
            }
            this.mFileType.addActionListener((ActionListener)new FileTypeSelect());
            this.mFileType.setSelectedItem((Object)CCTFile.FileType.DesignFile);
            this.mFc.setFileFilter((FileFilter)this.mFilter);
            this.mSelectedOnly = new JCheckBox("Selected Only");
            l.add((Component)this.mSelectedOnly, (GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
            this.mSelectedOnly.setToolTipText("<html>Disabled switch will output all wires <br> Enabled will  output selected wires only </html>");
            l.newline();
            l.addFillY();
        }

        @Override
        public void addNotify() {
            super.addNotify();
        }

        public boolean isSelectedOnly() {
            return this.mSelectedOnly.isSelected();
        }

        protected class FileTypeSelect
        implements ActionListener {
            protected FileTypeSelect() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportCCTOptionsPanel.this.mFilter = ExportCCTOptionsPanel.this.mFileType.getSelectedItem().equals("DesignFile") ? new AFileFilter("dsn", "Design Files") : (ExportCCTOptionsPanel.this.mFileType.getSelectedItem().equals("WireFile") ? new AFileFilter("wir", "Wire Files") : new AFileFilter("rte", "Route Files"));
                ExportCCTOptionsPanel.this.mFc.setFileFilter((FileFilter)ExportCCTOptionsPanel.this.mFilter);
            }
        }
    }
}

