/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ACsvWriter;
import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.app.ABuildInfo;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.ImportContactLayerDlg;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.filechooser.FileFilter;

public class ExportContactLayerDlg {
    static final String[] CONTACT_CONFIGURATION_FILE_HEADER = ImportContactLayerDlg.CONTACT_CONFIGURATION_FILE_HEADER;

    public static Action getAction() {
        return new AbstractAction("Export Contact Layer"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportContactLayerDlg.showUI();
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitIO.getCurDb() != null;
            }
        };
    }

    public static void showUI() {
        AFileChooser fc = new AFileChooser();
        fc.addChoosableFileFilter((FileFilter)AFileFilter.CSV);
        fc.setFileFilter((FileFilter)AFileFilter.CSV);
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(false);
        fc.setDialogTitle("Export CSV Contact Layer");
        if (fc.showSaveDialog((Component)OrbitIO.getMainWindow()) != 0) {
            return;
        }
        File fRuleFile = fc.getSelectedFile();
        if (fRuleFile == null) {
            return;
        }
        Cp.exec((String)"com.sigrity.orbit.ui.ExportContactLayerDlg.exportContactLayer(%s);", (Object[])new Object[]{Cp.getFileAsArgument((File)fRuleFile)});
    }

    public static void exportContactLayer(String filePath) {
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            ALog.logWarn((String)"Open an orbit design before runing this command.");
            return;
        }
        ExportContactLayer export = new ExportContactLayer(db);
        export.writeContactLayerCsv(filePath);
    }

    static class ExportContactLayer {
        private Db mDb;
        private ACsvWriter mCsvWriter;

        ExportContactLayer(Db db) {
            this.mDb = db;
        }

        private void writeContactLayerCsv(String filePath) {
            assert (this.mDb != null);
            try (ACsvWriter csvWriter = ACsvWriter.open((String)filePath);){
                this.mCsvWriter = csvWriter;
                this.writeDesignInfo();
                this.writeTopHeader();
                this.writeContactLayer();
                ALog.logInfo((String)"Top module configuration file output complete.");
            }
            catch (Exception excep) {
                ALog.logError((Throwable)excep, (String)"There was an unexpected exception while writing configuration file.", (Object[])new Object[0]);
                return;
            }
        }

        private void writeDesignInfo() {
            this.mCsvWriter.row(new String[]{String.format("#. %s version %s", OrbitIO.getApp().getName(true), OrbitIO.getApp().getVersion())});
            this.mCsvWriter.row(new String[]{String.format("#. Build: %s (%s)", ABuildInfo.getVersion(), ABuildInfo.getTimestamp())});
            this.mCsvWriter.row(new String[]{String.format("#. User: %s", System.getProperty("user.name"))});
            this.mCsvWriter.row(new String[]{String.format("#. Time: %s", new Date())});
            String file = OrbitIO.getCurDb().getCanonicalPath();
            this.mCsvWriter.row(new String[]{String.format("#. Source design: %s", file != null ? file : "<Unsaved Design>")});
            this.mCsvWriter.endRow();
        }

        private void writeTopHeader() {
            this.mCsvWriter.header(CONTACT_CONFIGURATION_FILE_HEADER);
        }

        private void writeContactLayer() {
            this.mDb.getObjects(ContactLayer.class).forEach(contactLayer -> {
                this.mCsvWriter.colData(contactLayer.getDevicePathA().getAFullPath().toString());
                this.mCsvWriter.colData(contactLayer.getContactLayerA().getName());
                this.mCsvWriter.colData(contactLayer.getDevicePathB().getAFullPath().toString());
                this.mCsvWriter.colData(contactLayer.getContactLayerB().getName());
                this.mCsvWriter.endRow();
            });
        }
    }
}

