/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.APair;
import com.sigrity.acl.AReflection;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.export.LEFOut;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileFilter;

public class ExportDEFUI {
    private ExportDEFUI() {
    }

    private static APair<String, LEFDEFExportOptionsPanel> queryDEFOptions() {
        AFileChooser fc = new AFileChooser();
        fc.setDialogTitle("Export DEF");
        AFileFilter filter = AFileFilter.DEF;
        fc.setFileFilter((FileFilter)filter);
        LEFDEFExportOptionsPanel options = new LEFDEFExportOptionsPanel();
        fc.setAccessory((JComponent)options);
        if (fc.showSaveDialog((Component)OrbitIO.getMainWindow()) != 0) {
            return null;
        }
        options.save();
        File f = fc.getSelectedFile();
        Object path = f.getPath();
        if (fc.getFileFilter() == filter && !f.getName().contains(".")) {
            path = (String)path + ".def";
        }
        return APair.create((Object)path, (Object)options);
    }

    public static boolean showMe(DevicePath devicePath) {
        APair<String, LEFDEFExportOptionsPanel> config = ExportDEFUI.queryDEFOptions();
        if (config == null) {
            return false;
        }
        String path = (String)config.getFirst();
        LEFDEFExportOptionsPanel options = (LEFDEFExportOptionsPanel)config.getSecond();
        boolean exportNets = options.getDEFExportNets();
        boolean exportWire = options.getDEFExportWire();
        boolean exportVia = options.getDEFExportVia();
        boolean inclSynDevices = options.getDEFIncludeSynthesized();
        boolean inclSynTemplates = options.getLEFIncludeSynTemplaes();
        Cp.exec(() -> OrbitIO.exportDEF(path, devicePath.toString(), exportNets, inclSynDevices, false, options.getDEFOverwriteNames(), options.getDEFExportTerm(), exportWire, exportVia), (String)"OrbitIO.exportDEF(%s, \"%s\", %s, %s, false, %b, %b, %b, %b)", (Object[])new Object[]{Cp.getFileAsArgument((String)path), devicePath, exportNets, inclSynDevices, options.getDEFOverwriteNames(), options.getDEFExportTerm(), exportWire, exportVia});
        if (options.getDEFExportLEF()) {
            String lefFileName = ExportDEFUI.getLefName(path);
            Cp.exec(() -> {
                LEFOut loUnused = LEFOut.create(OrbitApp.getCurDb());
                loUnused.writeDescendantsWithSubstrates(devicePath.toString(), lefFileName, inclSynTemplates);
            }, (String)"unset(\"_lo\")", (Object[])new Object[0]);
            Cp.exec((String)"_lo = %s.create(curDb())", (Object[])new Object[]{AReflection.getJavaClassName(LEFOut.class)});
            Cp.exec((String)"_lo.writeDescendantsWithSubstrates(\"%s\", %s, %s)", (Object[])new Object[]{devicePath, Cp.getFileAsArgument((String)lefFileName), inclSynTemplates ? "true" : "false"});
            Cp.exec((String)"unset(\"_lo\")", (Object[])new Object[0]);
        }
        return true;
    }

    private static String getLefName(String defPath) {
        String lefPath = defPath.replaceAll(".gz$", "");
        lefPath = lefPath.replaceAll(".def$", "");
        return lefPath + ".lef";
    }

    private static class LEFDEFExportOptionsPanel
    extends JPanel {
        JTabbedPane mOptions;
        DEFExportOptionsPanel mDEFOptions;
        LEFExportOptionsPanel mLEFOptions;
        private static final String OPT_WRITE_NETS = "WriteNets";
        private static final String OPT_WRITE_WIRES = "ExportWires";
        private static final String OPT_WRITE_VIAS = "ExportVias";
        private static final String OPT_WRITE_LEF = "WriteLef";
        private static final String OPT_ONLY_SYNTH_LEF = "OnlySynthLef";
        private static final String OPT_OVERWRITE_NAMES = "OverwriteNames";
        private static final String OPT_WRITE_PINS = "WritePins";
        private static final String OPT_INCL_SYN_LEFS = "InclSynLefs";

        public LEFDEFExportOptionsPanel() {
            this.setBorder(BorderFactory.createTitledBorder("Export Options"));
            GridBagManager l = new GridBagManager((Container)this);
            this.mOptions = new JTabbedPane();
            l.add((Component)this.mOptions, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            this.mDEFOptions = new DEFExportOptionsPanel();
            this.mOptions.add("DEF", this.mDEFOptions);
            this.mLEFOptions = new LEFExportOptionsPanel();
            this.mOptions.add("LEF", this.mLEFOptions);
            l.newline();
            this.load();
        }

        public boolean getDEFExportNets() {
            return this.mDEFOptions.mCbExportNets.isSelected();
        }

        public boolean getDEFExportLEF() {
            return this.mDEFOptions.mCbExportLef.isSelected();
        }

        public boolean getDEFIncludeSynthesized() {
            return this.mDEFOptions.mCbInclSynth.isEnabled() && this.mDEFOptions.mCbInclSynth.isSelected();
        }

        public boolean getDEFOverwriteNames() {
            return this.mDEFOptions.mCbOverwriteDefOutNames.isSelected();
        }

        public boolean getDEFExportTerm() {
            return this.mDEFOptions.mCbExportTerms.isSelected();
        }

        public boolean getLEFIncludeSynTemplaes() {
            return this.mDEFOptions.mCbInclSynth.isEnabled() && this.mLEFOptions.mCbInclSynTemplates.isSelected();
        }

        public boolean getDEFExportWire() {
            return this.mDEFOptions.mCbExportNets.isSelected() && this.mDEFOptions.mCbExportWires.isSelected();
        }

        public boolean getDEFExportVia() {
            return this.getDEFExportWire() && this.mDEFOptions.mCbExportVias.isSelected();
        }

        public void save() {
            Settings s = Settings.getSettings((String)AReflection.getClassNameOfObject((Object)this));
            s.putSetting(OPT_WRITE_NETS, (Object)this.getDEFExportNets());
            s.putSetting(OPT_WRITE_WIRES, (Object)this.getDEFExportWire());
            s.putSetting(OPT_WRITE_VIAS, (Object)this.getDEFExportVia());
            s.putSetting(OPT_WRITE_LEF, (Object)this.getDEFExportLEF());
            s.putSetting(OPT_ONLY_SYNTH_LEF, (Object)this.getDEFIncludeSynthesized());
            s.putSetting(OPT_OVERWRITE_NAMES, (Object)this.getDEFOverwriteNames());
            s.putSetting(OPT_WRITE_PINS, (Object)this.getDEFExportTerm());
            s.putSetting(OPT_INCL_SYN_LEFS, (Object)this.getLEFIncludeSynTemplaes());
            s.save();
        }

        public void load() {
            Settings s = Settings.getSettings((String)AReflection.getClassNameOfObject((Object)this));
            this.mDEFOptions.mCbExportNets.setSelected((Boolean)s.getSetting(OPT_WRITE_NETS, (Object)true));
            this.mDEFOptions.mCbExportWires.setSelected((Boolean)s.getSetting(OPT_WRITE_WIRES, (Object)true));
            this.mDEFOptions.mCbExportVias.setSelected((Boolean)s.getSetting(OPT_WRITE_VIAS, (Object)true));
            this.mDEFOptions.mCbExportLef.setSelected((Boolean)s.getSetting(OPT_WRITE_LEF, (Object)false));
            this.mDEFOptions.mCbInclSynth.setSelected((Boolean)s.getSetting(OPT_ONLY_SYNTH_LEF, (Object)false));
            this.mDEFOptions.mCbOverwriteDefOutNames.setSelected((Boolean)s.getSetting(OPT_OVERWRITE_NAMES, (Object)false));
            this.mDEFOptions.mCbExportTerms.setSelected((Boolean)s.getSetting(OPT_WRITE_PINS, (Object)true));
            this.mLEFOptions.mCbInclSynTemplates.setSelected((Boolean)s.getSetting(OPT_INCL_SYN_LEFS, (Object)true));
            this.updateControls();
        }

        protected void updateControls() {
            boolean exportLEF = this.getDEFExportLEF();
            this.mDEFOptions.mCbInclSynth.setEnabled(exportLEF);
            this.setLEFOptionsEnabled(exportLEF);
            boolean inclSynth = this.getDEFIncludeSynthesized();
            if (inclSynth) {
                this.setIncludeSynthesizedTemplates(true);
            }
            boolean exportNet = this.getDEFExportNets();
            this.mDEFOptions.mCbExportWires.setEnabled(exportNet);
            boolean exportWire = this.getDEFExportWire();
            this.mDEFOptions.mCbExportVias.setEnabled(exportNet && exportWire);
        }

        void setLEFOptionsEnabled(boolean enable) {
            this.mOptions.setEnabledAt(this.mOptions.indexOfComponent(this.mLEFOptions), enable);
        }

        void setIncludeSynthesizedTemplates(boolean selected) {
            this.mLEFOptions.mCbInclSynTemplates.setSelected(selected);
        }

        protected class DEFExportOptionsPanel
        extends JPanel {
            JCheckBox mCbExportNets;
            JCheckBox mCbExportLef;
            JCheckBox mCbInclSynth;
            JCheckBox mCbOverwriteDefOutNames;
            JCheckBox mCbExportTerms;
            JCheckBox mCbExportWires;
            JCheckBox mCbExportVias;

            public DEFExportOptionsPanel() {
                GridBagManager l = new GridBagManager((Container)this);
                GridBagManager.GridBagConstraintsEx leftNoInsets = GridBagManager.LEFT.noInsets();
                this.mCbExportTerms = (JCheckBox)l.add((Component)new JCheckBox("Export Terms"), (GridBagConstraints)leftNoInsets);
                this.mCbExportTerms.setToolTipText("Export Terms as PINS in DEF file.");
                l.newline();
                this.mCbExportNets = (JCheckBox)l.add((Component)new JCheckBox("Export Nets"), (GridBagConstraints)leftNoInsets);
                this.mCbExportNets.setToolTipText("Export SPECIALNETS section.");
                l.newline();
                this.mCbExportWires = (JCheckBox)l.add((Component)new JCheckBox("Export Wires"), (GridBagConstraints)leftNoInsets);
                this.mCbExportWires.setToolTipText("Export wires in SPECIALNETS section.");
                l.newline();
                this.mCbExportVias = (JCheckBox)l.add((Component)new JCheckBox("Export Vias"), (GridBagConstraints)leftNoInsets);
                this.mCbExportVias.setToolTipText("Export vias in SPECIALNETS section.");
                l.newline();
                this.mCbExportLef = (JCheckBox)l.add((Component)new JCheckBox("Export LEF"), (GridBagConstraints)leftNoInsets);
                l.newline();
                this.mCbInclSynth = (JCheckBox)l.add((Component)new JCheckBox("Include from synthesized templates"), (GridBagConstraints)leftNoInsets);
                this.mCbInclSynth.setToolTipText("Devices of synthesized templates would be included in the output DEF.");
                l.newline();
                this.mCbOverwriteDefOutNames = (JCheckBox)l.add((Component)new JCheckBox("Overwrite stored DEFOut names"), (GridBagConstraints)leftNoInsets);
                this.mCbOverwriteDefOutNames.setToolTipText("Overwrite DEFOutNames previously stored in the design with new names; otherwise, existing names will output to the DEF file.");
                l.addFillY();
                ActionListener updateUI = e -> LEFDEFExportOptionsPanel.this.updateControls();
                this.mCbExportNets.addActionListener(updateUI);
                this.mCbExportWires.addActionListener(updateUI);
                this.mCbExportLef.addActionListener(updateUI);
                this.mCbInclSynth.addActionListener(updateUI);
            }
        }

        protected class LEFExportOptionsPanel
        extends JPanel {
            JCheckBox mCbInclSynTemplates;

            public LEFExportOptionsPanel() {
                GridBagManager l = new GridBagManager((Container)this);
                GridBagManager.GridBagConstraintsEx leftNoInsets = GridBagManager.LEFT.noInsets();
                this.mCbInclSynTemplates = (JCheckBox)l.add((Component)new JCheckBox("Include synthesized"), (GridBagConstraints)leftNoInsets);
                this.mCbInclSynTemplates.setToolTipText("Syntehsized templates would be written to the LEF file with suffix of _syn, e.g a_syn.lef.");
                l.addFillX();
                l.addFillY();
            }
        }
    }
}

