/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.orbit.OrbitIO;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class ExportNetsText {
    static AFileChooser fc = null;
    static ExportNetsTextOptionsPanel options = null;
    static AFileFilter csvFilter = null;
    static AFileFilter txtFilter = null;

    public static boolean showMe(String devicePathString) {
        AFileFilter filter;
        fc = new AFileChooser();
        options = new ExportNetsTextOptionsPanel();
        fc.setAccessory((JComponent)options);
        options.setIncIntfHier((Boolean)Settings.get((String)"App", (String)"ExportNetsTxtIncIntf", (Object)true));
        if (options.isIncIntfHier()) {
            csvFilter = filter = AFileFilter.CSV;
            if (!((String)Settings.get((String)"App", (String)"ExportNetsCSV", (Object)"")).isEmpty()) {
                fc.setSelectedFile(new File((String)Settings.get((String)"App", (String)"ExportNetsCSV", (Object)"")));
            }
        } else {
            txtFilter = filter = AFileFilter.TXT;
            if (!((String)Settings.get((String)"App", (String)"ExportNetsTxt", (Object)"")).isEmpty()) {
                fc.setSelectedFile(new File((String)Settings.get((String)"App", (String)"ExportNetsTxt", (Object)"")));
            }
        }
        fc.setFileFilter((FileFilter)filter);
        fc.setDialogTitle("Export Net-Interface Map");
        if (fc.showSaveDialog((Component)OrbitIO.getMainWindow()) != 0) {
            return false;
        }
        File f = fc.getSelectedFile();
        Object path = f.getPath();
        if (fc.getFileFilter() == filter && !f.getName().contains(".")) {
            path = (String)path + (options.isIncIntfHier() ? ".csv" : ".txt");
        }
        Cp.exec((String)"OrbitIO.exportCSVNetlist(%s, \"%s\", %b)", (Object[])new Object[]{Cp.getFileAsArgument((String)path), devicePathString, options.isIncIntfHier()});
        if (options.isIncIntfHier()) {
            Settings.set((String)"App", (String)"ExportNetsCSV", (Object)path);
        } else {
            Settings.set((String)"App", (String)"ExportNetsTxt", (Object)path);
        }
        Settings.set((String)"App", (String)"ExportNetsTxtIncIntf", (Object)options.isIncIntfHier());
        Settings.save((String)"App");
        return true;
    }

    private static class ExportNetsTextOptionsPanel
    extends JPanel {
        JCheckBox mIncIntfHier;
        ActionListener setFileFilterAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AFileFilter filter;
                if (options.isIncIntfHier()) {
                    if (csvFilter == null) {
                        csvFilter = AFileFilter.CSV;
                    }
                    filter = csvFilter;
                } else {
                    if (txtFilter == null) {
                        txtFilter = AFileFilter.TXT;
                    }
                    filter = txtFilter;
                }
                fc.setFileFilter((FileFilter)filter);
            }
        };

        public ExportNetsTextOptionsPanel() {
            this.setBorder(BorderFactory.createTitledBorder("Export options"));
            GridBagManager l = new GridBagManager((Container)this);
            this.mIncIntfHier = new JCheckBox("include interface hierarchy");
            this.mIncIntfHier.addActionListener(this.setFileFilterAction);
            l.add((Component)this.mIncIntfHier, (GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
            this.mIncIntfHier.setToolTipText("<html>Disabled switch will output only net names. <br> Enabled will output interfaces in second column <br></html>");
            l.newline();
            l.addFillY();
        }

        @Override
        public void addNotify() {
            super.addNotify();
        }

        public boolean isIncIntfHier() {
            return this.mIncIntfHier.isSelected();
        }

        public void setIncIntfHier(boolean val) {
            this.mIncIntfHier.setSelected(val);
        }
    }
}

