/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.AFileChooserControl;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.export.VerilogExport;
import com.sigrity.orbit.ui.OrbitUIMisc;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ExportVerilogUI2
extends DbDialog {
    protected static HashSet<DeviceTemplate.Type> DeviceTypeGroups = new HashSet(AUtil.hashSet((Object[])OrbitUIMisc.GroupDeviceTemplateTypes));
    protected DevicePath mExportPath;
    protected AFileChooserControl mFileChooser;
    protected ExportOptionsPanel mExportOptionsPnl;
    protected HashSet<DeviceTemplate> mStopDevTs = new HashSet();
    protected ActionListener mOkHandler = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                AFieldValidator.validateFileWritable((JTextField)ExportVerilogUI2.this.mFileChooser.getTextField());
            }
            catch (AFieldValidator.AFieldValidationException e1) {
                return;
            }
            if (!ExportVerilogUI2.this.mFileChooser.getApproveOverwriteCurrent()) {
                return;
            }
            ExportVerilogUI2.this.mExportOptionsPnl.saveSettings();
            Cp.exec((String)"unset(\"_ve\")", (Object[])new Object[0]);
            Cp.exec((String)"_ve = new com.sigrity.orbit.export.VerilogExport(curDb(), %s)", (Object[])new Object[]{Cp.getFileAsArgument((String)ExportVerilogUI2.this.mFileChooser.getPath())});
            if (!ExportVerilogUI2.this.mExportOptionsPnl.exportLeafDefs()) {
                Cp.exec((String)"_ve.setExportLeafDefs(false)", (Object[])new Object[0]);
            } else {
                if (!ExportVerilogUI2.this.mExportOptionsPnl.exportLeafDefsSynth()) {
                    Cp.exec((String)"_ve.setExportLeafDefsSynth(false)", (Object[])new Object[0]);
                }
                if (!ExportVerilogUI2.this.mExportOptionsPnl.exportLeafDefsLef()) {
                    Cp.exec((String)"_ve.setExportLefDefinedLeafs(false)", (Object[])new Object[0]);
                }
            }
            if (ExportVerilogUI2.this.mExportOptionsPnl.exportPinNamesForUndefinedLefLeafInstances()) {
                Cp.exec((String)"_ve.setUnexportedLeafModuleInstancesUsePinNames(true)", (Object[])new Object[0]);
            }
            if (ExportVerilogUI2.this.mExportOptionsPnl.exportDefOutNames()) {
                Cp.exec((String)"_ve.setUseDefOutNames(true)", (Object[])new Object[0]);
            }
            if (ExportVerilogUI2.this.mExportOptionsPnl.exportUseNetUnusedForUnconnected()) {
                Cp.exec((String)"_ve.setUseNetUnusedForUnconnectedPorts(true)", (Object[])new Object[0]);
            }
            if (ExportVerilogUI2.this.mExportOptionsPnl.exportUsePhysPinNames()) {
                Cp.exec((String)"_ve.setUsePhysPinNamesForPorts(true)", (Object[])new Object[0]);
                if (ExportVerilogUI2.this.mExportOptionsPnl.exportLeavesOmitSignalInfo()) {
                    Cp.exec((String)"_ve.setLeafsOmitSignalInfo(true)", (Object[])new Object[0]);
                }
            }
            if (ExportVerilogUI2.this.mExportOptionsPnl.getExportAsPortsTop() != VerilogExport.ExportAsPorts.NetsMappedUp) {
                Cp.exec((String)"_ve.setExportAsPortsTop(com.sigrity.orbit.export.VerilogExport.ExportAsPorts.%s)", (Object[])new Object[]{ExportVerilogUI2.this.mExportOptionsPnl.getExportAsPortsTop().name()});
            }
            if (ExportVerilogUI2.this.mExportOptionsPnl.getExportAsPorts() != VerilogExport.ExportAsPorts.NetsMappedUp) {
                Cp.exec((String)"_ve.setExportAsPorts(com.sigrity.orbit.export.VerilogExport.ExportAsPorts.%s)", (Object[])new Object[]{ExportVerilogUI2.this.mExportOptionsPnl.getExportAsPorts().name()});
            }
            for (DeviceTemplate stopDevT : ExportVerilogUI2.this.mStopDevTs) {
                Cp.exec((String)"_ve.addStopTemplate(\"%s\")", (Object[])new Object[]{stopDevT.getKeyStr()});
            }
            Object res = Cp.exec((String)"_ve.write(\"%s\")", (Object[])new Object[]{ExportVerilogUI2.this.mExportPath.toString()});
            Cp.exec((String)"unset(\"_ve\")", (Object[])new Object[0]);
            if (Boolean.TRUE.equals(res)) {
                UIUtil.closeWindow((Window)((Object)ExportVerilogUI2.this));
            }
        }
    };

    public static void show(Window owner, DevicePath devPath) {
        ExportVerilogUI2 dlg = new ExportVerilogUI2(owner, devPath);
        dlg.setVisible(true);
    }

    protected ExportVerilogUI2(Window owner, DevicePath devicePath) {
        super(devicePath.getDb(), (Component)owner, "Export Verilog", Dialog.ModalityType.DOCUMENT_MODAL);
        this.mExportPath = devicePath;
        GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
        this.mExportOptionsPnl = new ExportOptionsPanel();
        this.mExportOptionsPnl.loadSettings();
        l.push((GridBagConstraints)GridBagManager.FILLX_REMAINX);
        l.add("Output file:");
        this.mFileChooser = (AFileChooserControl)l.add((Component)new AFileChooserControl(), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        this.mFileChooser.addChoosableFileFilter(AFileFilter.VERILOG);
        this.mFileChooser.setUseSaveChooser(true);
        this.mFileChooser.getTextField().setText(devicePath.getDeviceTemplate().getName() + ".v");
        l.pop();
        l.newline();
        l.push("Device selection", (GridBagConstraints)GridBagManager.FILLALL);
        final Tree topTree = new Tree(devicePath.getDeviceTemplate());
        ((JScrollPane)l.add((Component)new JScrollPane(topTree), (GridBagConstraints)GridBagManager.FILLALL)).setMinimumSize(new Dimension(150, 150));
        l.pop();
        l.pushFill("Options");
        l.add((Component)this.mExportOptionsPnl);
        this.mExportOptionsPnl.mExportLeafDefsLef.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                topTree.repaint();
            }
        });
        l.addFillY();
        l.addFillX();
        l.pop();
        l.newline();
        l.pushFillXRemainX();
        l.addFillX();
        JButton btnOk = (JButton)l.add((Component)new JButton("OK"));
        btnOk.addActionListener(this.mOkHandler);
        JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOk);
        l.pop();
        this.pack();
        this.setMinimumSize(this.getMinimumSize());
        UIUtil.center((Component)((Object)this));
    }

    protected static class ExportOptionsPanel
    extends JPanel {
        protected JCheckBox mUseDefOutNames;
        protected JCheckBox mExportLeafDefs;
        protected JCheckBox mExportLeafDefsLef;
        protected JCheckBox mExportLeafDefsSynth;
        protected JCheckBox mUsePinNamesInUndefinedLefLeafInstantiations;
        protected JCheckBox mUseNetUnusedForUnconnected;
        protected JComboBox<VerilogExport.ExportAsPorts> mCboExportAsPortsTop;
        protected JComboBox<VerilogExport.ExportAsPorts> mCboExportAsPorts;
        protected JCheckBox mUsePhysPinNames;
        protected JCheckBox mLeavesOmitSignals;
        public static final String SETTING_SECTION = "ExportVerilogUI";
        public static final String SETTING_UseDefOutNames = "UseDefOutNames";
        public static final String SETTING_ExportLeafDefs = "ExportLeafDefs";
        public static final String SETTING_ExportLeafDefsLef = "ExportLeafDefsLef";
        public static final String SETTING_ExportLeafDefsSynth = "ExportLeafDefsSynth";
        public static final String SETTING_LeafInstsUsePinNames = "LeafInstsUsePinNames";
        public static final String SETTING_UseNetUnusedForUnconnectedPorts = "UseNetUnusedForUnconnectedPorts";
        public static final String SETTING_UsePhysPinNames = "UsePhysicalPinNamesForPorts";
        public static final String SETTING_LeavesOmitSignalInfo = "LeavesOmitSignalInfo";
        public static final String SETTING_ExportAsTopPorts = "ExportAsTopPorts";
        public static final String SETTING_ExportAsPorts = "ExportAsPorts";
        protected ActionListener mUpdatesListener = new ActionListener(){
            boolean inUpdate = false;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.inUpdate) {
                    return;
                }
                this.inUpdate = true;
                try {
                    this.updateControls();
                }
                finally {
                    this.inUpdate = false;
                }
            }

            void updateControls() {
                boolean exportLeafDefs = mExportLeafDefs.isSelected();
                mExportLeafDefsSynth.setEnabled(exportLeafDefs);
                if (!exportLeafDefs) {
                    mExportLeafDefsSynth.setSelected(false);
                }
                mExportLeafDefsLef.setEnabled(exportLeafDefs);
                if (!exportLeafDefs) {
                    mExportLeafDefsLef.setSelected(false);
                }
                boolean exportLeafDefsAll = exportLeafDefs && mExportLeafDefsSynth.isSelected() && mExportLeafDefsLef.isSelected();
                mUsePinNamesInUndefinedLefLeafInstantiations.setEnabled(!exportLeafDefsAll);
                if (exportLeafDefsAll) {
                    mUsePinNamesInUndefinedLefLeafInstantiations.setSelected(false);
                }
                boolean exportOnlyPinNames = mUsePhysPinNames.isSelected();
                mLeavesOmitSignals.setEnabled(exportOnlyPinNames);
            }
        };
        protected ListCellRenderer<Object> mEportAsPortsCellRender = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                this.setText(((VerilogExport.ExportAsPorts)((Object)value)).getLabel());
                return this;
            }
        };

        public ExportOptionsPanel() {
            GridBagManager l = new GridBagManager((Container)this);
            this.mUseDefOutNames = (JCheckBox)l.add((Component)new JCheckBox("Use DEF-output names"), (GridBagConstraints)GridBagManager.LEFT.noInsets());
            this.mUseDefOutNames.setToolTipText("<html>If selected, DEF-output names will be used for Verilog module instantiations instead of the Device name in the Design.");
            this.mUseDefOutNames.setSelected(false);
            l.newline();
            this.mExportLeafDefs = (JCheckBox)l.add((Component)new JCheckBox("Export leaf definitions"), (GridBagConstraints)GridBagManager.LEFT.noInsets());
            this.mExportLeafDefs.setToolTipText("<html>If deselected, no Verilog module definitions are output for DeviceTemplates that have no child Devices.");
            this.mExportLeafDefs.setSelected(true);
            this.mExportLeafDefs.addActionListener(this.mUpdatesListener);
            l.newline();
            this.mExportLeafDefsSynth = (JCheckBox)l.add((Component)new JCheckBox("Export synthesized leaf definitions"), (GridBagConstraints)GridBagManager.LEFT.noInsets().indent());
            this.mExportLeafDefsSynth.setToolTipText("<html>If deselected, no Verilog module definitions are output for DeviceTemplates that have no children and are marked as 'synthesized' (i.e., the DeviceTemplate was created in OrbitIO).");
            this.mExportLeafDefsSynth.setSelected(true);
            this.mExportLeafDefsSynth.addActionListener(this.mUpdatesListener);
            l.newline();
            this.mExportLeafDefsLef = (JCheckBox)l.add((Component)new JCheckBox("Export LEF-defined leaf definitions"), (GridBagConstraints)GridBagManager.LEFT.noInsets().indent());
            this.mExportLeafDefsLef.setToolTipText("<html>If deselected, no Verilog module definitions are output for DeviceTemplates that have no children and were imported from a LEF file.");
            this.mExportLeafDefsLef.setSelected(true);
            this.mExportLeafDefsLef.addActionListener(this.mUpdatesListener);
            l.newline();
            this.mUsePinNamesInUndefinedLefLeafInstantiations = (JCheckBox)l.add((Component)new JCheckBox("External leaf instances use pin names for ports"), (GridBagConstraints)GridBagManager.LEFT.noInsets());
            this.mUsePinNamesInUndefinedLefLeafInstantiations.setToolTipText("<html>If selected, module instantiations for leaf nodes where no Verilog module definition is being output will use the pin name for the Verilog port name.");
            this.mUsePinNamesInUndefinedLefLeafInstantiations.setSelected(true);
            l.newline();
            this.mUseNetUnusedForUnconnected = (JCheckBox)l.add((Component)new JCheckBox("Use \"NetUnused\" for unconnected ports"), (GridBagConstraints)GridBagManager.LEFT.noInsets());
            this.mUseNetUnusedForUnconnected.setToolTipText("<html>If selected, instead of ommitting the parameter value altogether for an unconnected port, the value \"NetUnused\" is output.");
            l.newline();
            this.mCboExportAsPortsTop = new JComboBox<VerilogExport.ExportAsPorts>(VerilogExport.ExportAsPorts.values());
            this.mCboExportAsPortsTop.setSelectedItem((Object)VerilogExport.ExportAsPorts.NetsMappedUp);
            this.mCboExportAsPortsTop.setRenderer(this.mEportAsPortsCellRender);
            String tt = "Set which nets should be exported as Verilog ports for the topmost device.";
            JLabel lbl = l.add("Export as ports for top device:");
            l.newline();
            l.add(this.mCboExportAsPortsTop, (GridBagConstraints)GridBagManager.LEFT.insetTop(0).indent());
            lbl.setLabelFor(this.mCboExportAsPortsTop);
            lbl.setToolTipText(tt);
            this.mCboExportAsPortsTop.setToolTipText(tt);
            l.newline();
            this.mCboExportAsPorts = new JComboBox<VerilogExport.ExportAsPorts>(VerilogExport.ExportAsPorts.values());
            this.mCboExportAsPorts.setSelectedItem((Object)VerilogExport.ExportAsPorts.NetsMappedUp);
            this.mCboExportAsPorts.setToolTipText(tt);
            this.mCboExportAsPorts.setRenderer(this.mEportAsPortsCellRender);
            tt = "Set which nets should be exported as Verilog ports for all descendant devices.";
            lbl = l.add("Export as ports for descendants:");
            l.newline();
            l.add(this.mCboExportAsPorts, (GridBagConstraints)GridBagManager.LEFT.insetTop(0).indent());
            lbl.setLabelFor(this.mCboExportAsPorts);
            lbl.setToolTipText(tt);
            this.mCboExportAsPorts.setToolTipText(tt);
            l.newline();
            this.mUsePhysPinNames = (JCheckBox)l.add((Component)new JCheckBox("Use pin names for all ports"), (GridBagConstraints)GridBagManager.LEFT.noInsets());
            this.mUsePhysPinNames.setToolTipText("<html>When selected, Verilog ports are named using Orbit pin names instead of Orbit Net names. Verilog 'tran' statements are used to connect the Nets to the pins.");
            this.mUsePhysPinNames.addActionListener(this.mUpdatesListener);
            l.newline();
            this.mLeavesOmitSignals = (JCheckBox)l.add((Component)new JCheckBox("Leaf nodes omit signal information"), (GridBagConstraints)GridBagManager.LEFT.noInsets().indent());
            this.mLeavesOmitSignals.setToolTipText("<html>When selected, leaf nodes will not have wires defined for Nets nor have the Nets connected to the pins via 'tran' statements.");
            l.addFillY();
            this.mUpdatesListener.actionPerformed(new ActionEvent(this, 1001, "init"));
            this.setMinimumSize(this.getPreferredSize());
        }

        public boolean exportDefOutNames() {
            return this.mUseDefOutNames.isSelected();
        }

        public boolean exportLeafDefs() {
            return this.mExportLeafDefs.isSelected();
        }

        public boolean exportLeafDefsLef() {
            return this.mExportLeafDefsLef.isSelected();
        }

        public boolean exportLeafDefsSynth() {
            return this.mExportLeafDefsSynth.isSelected();
        }

        public boolean exportPinNamesForUndefinedLefLeafInstances() {
            return this.mUsePinNamesInUndefinedLefLeafInstantiations.isSelected();
        }

        public boolean exportUseNetUnusedForUnconnected() {
            return this.mUseNetUnusedForUnconnected.isSelected();
        }

        public boolean exportUsePhysPinNames() {
            return this.mUsePhysPinNames.isSelected();
        }

        public boolean exportLeavesOmitSignalInfo() {
            return this.mLeavesOmitSignals.isSelected();
        }

        public VerilogExport.ExportAsPorts getExportAsPortsTop() {
            return (VerilogExport.ExportAsPorts)((Object)this.mCboExportAsPortsTop.getSelectedItem());
        }

        public VerilogExport.ExportAsPorts getExportAsPorts() {
            return (VerilogExport.ExportAsPorts)((Object)this.mCboExportAsPorts.getSelectedItem());
        }

        public boolean omitLefLeaf(DeviceTemplate devT) {
            return !this.exportLeafDefsLef() && VerilogExport.isLefLeaf(devT);
        }

        public void saveSettings() {
            Settings settings = Settings.getSettings((String)SETTING_SECTION);
            settings.putSetting(SETTING_UseDefOutNames, (Object)this.exportDefOutNames());
            settings.putSetting(SETTING_ExportLeafDefs, (Object)this.exportLeafDefs());
            settings.putSetting(SETTING_ExportLeafDefsLef, (Object)this.exportLeafDefsLef());
            settings.putSetting(SETTING_ExportLeafDefsSynth, (Object)this.exportLeafDefsSynth());
            settings.putSetting(SETTING_LeafInstsUsePinNames, (Object)this.exportPinNamesForUndefinedLefLeafInstances());
            settings.putSetting(SETTING_UseNetUnusedForUnconnectedPorts, (Object)this.exportUseNetUnusedForUnconnected());
            settings.putSetting(SETTING_UsePhysPinNames, (Object)this.exportUsePhysPinNames());
            settings.putSetting(SETTING_LeavesOmitSignalInfo, (Object)this.exportLeavesOmitSignalInfo());
            settings.putSetting(SETTING_ExportAsTopPorts, (Object)this.getExportAsPortsTop());
            settings.putSetting(SETTING_ExportAsPorts, (Object)this.getExportAsPorts());
            settings.save();
        }

        public void loadSettings() {
            Settings settings = Settings.getSettings((String)SETTING_SECTION);
            this.mUseDefOutNames.setSelected((Boolean)settings.getSetting(SETTING_UseDefOutNames, (Object)this.mUseDefOutNames.isSelected()));
            this.mExportLeafDefs.setSelected((Boolean)settings.getSetting(SETTING_ExportLeafDefs, (Object)this.mExportLeafDefs.isSelected()));
            this.mExportLeafDefsLef.setSelected((Boolean)settings.getSetting(SETTING_ExportLeafDefsLef, (Object)this.mExportLeafDefsLef.isSelected()));
            this.mExportLeafDefsSynth.setSelected((Boolean)settings.getSetting(SETTING_ExportLeafDefsSynth, (Object)this.mExportLeafDefsSynth.isSelected()));
            this.mUsePinNamesInUndefinedLefLeafInstantiations.setSelected((Boolean)settings.getSetting(SETTING_LeafInstsUsePinNames, (Object)this.mUsePinNamesInUndefinedLefLeafInstantiations.isSelected()));
            this.mUseNetUnusedForUnconnected.setSelected((Boolean)settings.getSetting(SETTING_UseNetUnusedForUnconnectedPorts, (Object)this.mUseNetUnusedForUnconnected.isSelected()));
            this.mUsePhysPinNames.setSelected((Boolean)settings.getSetting(SETTING_UsePhysPinNames, (Object)this.mUsePhysPinNames.isSelected()));
            this.mLeavesOmitSignals.setSelected((Boolean)settings.getSetting(SETTING_LeavesOmitSignalInfo, (Object)this.mLeavesOmitSignals.isSelected()));
            this.mCboExportAsPortsTop.setSelectedItem(settings.getSetting(SETTING_ExportAsTopPorts, (Object)((VerilogExport.ExportAsPorts)((Object)this.mCboExportAsPortsTop.getSelectedItem()))));
            this.mCboExportAsPorts.setSelectedItem(settings.getSetting(SETTING_ExportAsPorts, (Object)((VerilogExport.ExportAsPorts)((Object)this.mCboExportAsPorts.getSelectedItem()))));
            this.mUpdatesListener.actionPerformed(null);
        }
    }

    protected class Tree
    extends JTree {
        protected DeviceTemplate mRootDevT;
        protected Action mSelectAll = new AbstractAction("Select All Descendants"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportVerilogUI2.this.mStopDevTs.clear();
                Tree.this.repaint();
            }
        };
        protected Action mDeselectAll = new AbstractAction("Deselect All Descendants"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportVerilogUI2.this.mStopDevTs.clear();
                for (Device d : Tree.this.mRootDevT.getChildren()) {
                    ExportVerilogUI2.this.mStopDevTs.add(d.getTemplate());
                }
                Tree.this.repaint();
            }
        };

        public Tree(DeviceTemplate rootDevT) {
            this.mRootDevT = rootDevT;
            this.setShowsRootHandles(true);
            this.setLargeModel(true);
            this.setModel(new Model());
            this.setCellRenderer(new Renderer());
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            TreePath path = this.getPathForLocation(e.getX(), e.getY());
            if (path != null) {
                Rectangle pb = this.getPathBounds(path);
                Point rendererPoint = new Point(e.getX() - pb.x, e.getY() - pb.y);
                Renderer cr = (Renderer)this.getCellRenderer();
                if (cr.mCheckBox.contains(rendererPoint) && this.processCheckboxMouseEvent(path, e)) {
                    return;
                }
            }
            super.processMouseEvent(e);
            if (e.isPopupTrigger()) {
                TreePath p = this.getPathForLocation(e.getX(), e.getY());
                Node n = p == null ? null : (Node)p.getLastPathComponent();
                LinkedList<JMenuItem> menuItems = new LinkedList<JMenuItem>();
                menuItems.add(new JMenuItem(this.mSelectAll));
                menuItems.add(new JMenuItem(this.mDeselectAll));
                if (n != null) {
                    // empty if block
                }
                if (menuItems.size() > 0) {
                    JPopupMenu m = new JPopupMenu();
                    for (JMenuItem mi : menuItems) {
                        if (mi == null) {
                            m.addSeparator();
                            continue;
                        }
                        m.add(mi);
                        UIUtil.setUniqueMnemonic((JPopupMenu)m, (AbstractButton)mi);
                    }
                    m.show(this, e.getX(), e.getY());
                }
            }
        }

        protected boolean processCheckboxMouseEvent(TreePath path, MouseEvent me) {
            int meId = me.getID();
            int meButton = me.getButton();
            int clicks = me.getClickCount();
            if (meId == 500 && meButton == 1) {
                Node node = (Node)path.getLastPathComponent();
                if (clicks == 1) {
                    node.toggleSelected();
                }
                this.invalidate();
                return true;
            }
            return meId == 501 && meButton == 1;
        }

        protected int populateChildDeviceNodes(Node parentNode, DeviceTemplate devT) {
            int totalChildren = 0;
            HashMap<DeviceTemplate.Type, DeviceTypeGroupNode> groupNodes = new HashMap<DeviceTemplate.Type, DeviceTypeGroupNode>();
            for (Device d : AUtil.sort((IterableIterator)devT.getChildren())) {
                ++totalChildren;
                DeviceNode devNode = new DeviceNode(d);
                DeviceTemplate.Type type = d.getTemplate().getType();
                if (DeviceTypeGroups.contains(type)) {
                    DeviceTypeGroupNode grpNode = (DeviceTypeGroupNode)groupNodes.get(type);
                    if (grpNode == null) {
                        grpNode = new DeviceTypeGroupNode(devT, type);
                        groupNodes.put(type, grpNode);
                        parentNode.insert(grpNode, 0);
                        grpNode.add(devNode);
                    }
                    grpNode.add(devNode);
                    continue;
                }
                parentNode.add(devNode);
            }
            return totalChildren;
        }

        protected boolean isOrDescendantOfStopTemplate(DeviceNode dn) {
            return this.isStopTemplate(dn.getDevice().getTemplate()) || this.isDescendantOfStopTemplate(dn);
        }

        protected boolean isStopTemplate(DeviceTemplate devT) {
            return ExportVerilogUI2.this.mStopDevTs.contains(devT);
        }

        protected boolean isDescendantOfStopTemplate(DeviceNode dn) {
            TreeNode parentNode;
            for (parentNode = dn.getParent(); parentNode != null && !(parentNode instanceof DeviceNode); parentNode = parentNode.getParent()) {
            }
            if (parentNode == null) {
                return false;
            }
            DeviceNode parentDeviceNode = (DeviceNode)parentNode;
            if (this.isStopTemplate(parentDeviceNode.getDevice().getTemplate())) {
                return true;
            }
            return this.isDescendantOfStopTemplate(parentDeviceNode);
        }

        protected void setStopTemplate(DeviceTemplate t, boolean stop) {
            if (stop) {
                ExportVerilogUI2.this.mStopDevTs.add(t);
            } else {
                ExportVerilogUI2.this.mStopDevTs.remove(t);
            }
        }

        protected class Renderer
        extends JPanel
        implements TreeCellRenderer {
            protected DefaultTreeCellRenderer mDelegate = new DefaultTreeCellRenderer();
            protected JCheckBox mCheckBox = new JCheckBox();

            public Renderer() {
                this.setLayout(new BorderLayout());
                this.setOpaque(false);
                this.setBackground(new Color(0, 0, 0, 0));
                this.add((Component)this.mCheckBox, "West");
                this.mCheckBox.setOpaque(false);
                this.mCheckBox.setBackground(new Color(0, 0, 0, 0));
                this.add((Component)this.mDelegate, "Center");
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                this.mDelegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                Node n = (Node)value;
                this.mDelegate.setText(n.getText());
                this.mDelegate.setIcon(n.getIcon());
                Boolean isSel = n.getSelected();
                if (isSel == null) {
                    UIUtil.setEnabled((Container)this, (boolean)false);
                    this.mCheckBox.setVisible(false);
                } else {
                    UIUtil.setEnabled((Container)this, (boolean)true);
                    if (n instanceof RootDeviceTemplateNode) {
                        this.mCheckBox.setVisible(false);
                    } else if (n instanceof DeviceNode && ExportVerilogUI2.this.mExportOptionsPnl.omitLefLeaf(((DeviceNode)n).getDevice().getTemplate())) {
                        this.mCheckBox.setVisible(false);
                    } else if (n instanceof DeviceTypeGroupNode && ((DeviceTypeGroupNode)n).allChildrenAreOmittedLefLeaves()) {
                        this.mCheckBox.setVisible(false);
                    } else {
                        this.mCheckBox.setVisible(true);
                    }
                    this.mCheckBox.setSelected(isSel);
                }
                this.setToolTipText(n.getToolTip());
                this.invalidate();
                return this;
            }
        }

        protected class DeviceNode
        extends Node {
            Device mDev;
            int mDeviceCount;

            public DeviceNode(Device dev) {
                this.mDev = dev;
                this.mDeviceCount = Tree.this.populateChildDeviceNodes(this, dev.getTemplate());
            }

            public Device getDevice() {
                return this.mDev;
            }

            @Override
            public String getNodeName() {
                return this.mDev.getName();
            }

            @Override
            public String getToolTip() {
                return null;
            }

            @Override
            public Icon getNodeIcon() {
                return DbExplorerPanel.getIconForDevice(this.mDev);
            }

            @Override
            public int getDeviceCount() {
                return this.mDeviceCount;
            }

            @Override
            public Boolean getSelected() {
                DeviceTemplate devT = this.mDev.getTemplate();
                if (Tree.this.isDescendantOfStopTemplate(this)) {
                    return null;
                }
                if (ExportVerilogUI2.this.mExportOptionsPnl.omitLefLeaf(devT)) {
                    return false;
                }
                if (Tree.this.isStopTemplate(devT)) {
                    return false;
                }
                return true;
            }

            @Override
            public void toggleSelected() {
                boolean stop = this.getSelected() == null || this.getSelected() == false;
                Tree.this.setStopTemplate(this.mDev.getTemplate(), !stop);
                Tree.this.repaint();
            }
        }

        protected class DeviceTypeGroupNode
        extends Node {
            DeviceTemplate mOwnerDevT;
            DeviceTemplate.Type mGroupType;

            public DeviceTypeGroupNode(DeviceTemplate devT, DeviceTemplate.Type groupType) {
                this.mOwnerDevT = devT;
                this.mGroupType = groupType;
            }

            public boolean allChildrenAreOmittedLefLeaves() {
                for (int i = 0; i < this.getChildCount(); ++i) {
                    if (ExportVerilogUI2.this.mExportOptionsPnl.omitLefLeaf(((DeviceNode)this.getChildAt(i)).getDevice().getTemplate())) continue;
                    return false;
                }
                return true;
            }

            @Override
            public String getNodeName() {
                return this.mGroupType.name() + "s";
            }

            @Override
            public String getToolTip() {
                return null;
            }

            @Override
            public Icon getNodeIcon() {
                return DbExplorerPanel.getIconForTemplateType(this.mGroupType);
            }

            @Override
            public int getDeviceCount() {
                return this.getChildCount();
            }

            @Override
            public Boolean getSelected() {
                Boolean parentSel = ((Node)this.getParent()).getSelected();
                if (parentSel == null || !parentSel.booleanValue()) {
                    return null;
                }
                for (int i = 0; i < this.getChildCount(); ++i) {
                    Boolean childSel = ((Node)this.getChildAt(i)).getSelected();
                    if (childSel != null && childSel.booleanValue()) continue;
                    return false;
                }
                return true;
            }

            @Override
            public void toggleSelected() {
                Boolean selected = this.getSelected();
                if (selected == null) {
                    return;
                }
                boolean newSelected = selected == false;
                for (int i = 0; i < this.getChildCount(); ++i) {
                    DeviceNode devNode = (DeviceNode)this.getChildAt(i);
                    DeviceTemplate childDevT = devNode.getDevice().getTemplate();
                    if (newSelected) {
                        ExportVerilogUI2.this.mStopDevTs.remove(childDevT);
                        continue;
                    }
                    ExportVerilogUI2.this.mStopDevTs.add(childDevT);
                }
                Tree.this.repaint();
            }
        }

        protected class RootDeviceTemplateNode
        extends Node {
            DeviceTemplate mDevT;
            int mDeviceCount;

            public RootDeviceTemplateNode(DeviceTemplate devT) {
                this.mDevT = devT;
                this.mDeviceCount = Tree.this.populateChildDeviceNodes(this, devT);
            }

            public DeviceTemplate getDeviceTemplate() {
                return this.mDevT;
            }

            @Override
            public String getNodeName() {
                return this.mDevT.getName();
            }

            @Override
            public String getToolTip() {
                return null;
            }

            @Override
            public Icon getNodeIcon() {
                return DbExplorerPanel.getIconForTemplate(this.mDevT);
            }

            @Override
            public int getDeviceCount() {
                return this.mDeviceCount;
            }

            @Override
            public Boolean getSelected() {
                return true;
            }

            @Override
            public void toggleSelected() {
            }
        }

        protected abstract class Node
        extends DefaultMutableTreeNode {
            protected Node() {
            }

            public abstract String getNodeName();

            public abstract String getToolTip();

            public abstract Icon getNodeIcon();

            public abstract int getDeviceCount();

            public abstract Boolean getSelected();

            public abstract void toggleSelected();

            @Override
            public boolean isLeaf() {
                return this.getChildCount() == 0;
            }

            public String getText() {
                int devCount = this.getDeviceCount();
                String countDesc = devCount == 0 ? "" : String.format(" (%d)", devCount);
                return String.format("%s%s", this.getNodeName(), countDesc);
            }

            public Icon getIcon() {
                return this.getNodeIcon();
            }

            @Override
            public String toString() {
                return this.getText();
            }
        }

        protected class Model
        extends DefaultTreeModel {
            public Model() {
                super(new RootDeviceTemplateNode(Tree.this.mRootDevT));
            }
        }
    }
}

