/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Attachment;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.AFileChooserControl;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class ExternalAttachmentUI
extends ADialog {
    protected DbObject mAttachmentOwner;
    protected JTextField mTxtType;
    protected AFileChooserControl mTxtFilePath;
    protected Attachment mCreatedAttachment = null;
    protected ActionListener mOk = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                AFieldValidator.validateText((JTextComponent)ExternalAttachmentUI.this.mTxtType);
            }
            catch (AFieldValidator.AFieldValidationException e1) {
                return;
            }
            String type = ExternalAttachmentUI.this.mTxtType.getText();
            String uri = new File(ExternalAttachmentUI.this.mTxtFilePath.getPath()).toURI().toString();
            Object result = Cp.exec((String)"com.sigrity.orbit.cmd.ExternalAttachment.add(\"%s\", \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{ExternalAttachmentUI.this.mAttachmentOwner.getDbClass().getName(), ExternalAttachmentUI.this.mAttachmentOwner.getKeyStr(), type, uri});
            if (Boolean.TRUE.equals(result)) {
                ExternalAttachmentUI.this.mCreatedAttachment = Attachment.lookup((DbObject)ExternalAttachmentUI.this.mAttachmentOwner, (String)type, (String)uri);
                UIUtil.closeWindow((Window)((Object)ExternalAttachmentUI.this));
            } else {
                JOptionPane.showMessageDialog((Component)((Object)ExternalAttachmentUI.this), "Unable to add attachment", "Add Attachment Error", 0);
            }
        }
    };

    public static boolean add(String dbClass, String keyStr) {
        return ExternalAttachmentUI.addAttachment(dbClass, keyStr) != null;
    }

    public static Attachment addAttachment(String dbClass, String keyStr) {
        Db db = OrbitIO.getCurDb();
        DbObject dbo = db.get(dbClass, keyStr);
        if (dbo == null) {
            ALog.logError((String)"There is no '%s' with key '%s' in the current database.", (Object[])new Object[]{dbClass, keyStr});
            return null;
        }
        ExternalAttachmentUI ui = ExternalAttachmentUI.create(OrbitIO.getMainWindow(), dbo);
        ui.setVisible(true);
        return ui.getCreatedAttachment();
    }

    public static ExternalAttachmentUI create(Window owner, DbObject attachmentOwner) {
        final ExternalAttachmentUI d = new ExternalAttachmentUI(owner, attachmentOwner);
        d.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                d.removeWindowListener(this);
            }
        });
        return d;
    }

    public ExternalAttachmentUI(DbObject attachmentOwner) {
        this.init(attachmentOwner);
    }

    public ExternalAttachmentUI(Window owner, DbObject attachmentOwner) {
        super(owner);
        this.init(attachmentOwner);
    }

    protected void init(DbObject attachmentOwner) {
        this.mAttachmentOwner = attachmentOwner;
        this.setDefaultCloseOperation(2);
        this.setTitle("Add Attachment");
        this.setModal(true);
        GridBagManager l = new GridBagManager(this.getContentPane());
        l.add("Owner:");
        l.add(String.format("%s '%s'", attachmentOwner.getDbClass().getName(), attachmentOwner.getKeyStr()));
        l.newline();
        l.add("Type:");
        this.mTxtType = new JTextField(10);
        l.add((Component)this.mTxtType, (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        l.add("File:");
        this.mTxtFilePath = new AFileChooserControl();
        l.add((Component)this.mTxtFilePath, (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        l.push((GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        JButton btnOk = new JButton("OK");
        btnOk.addActionListener(this.mOk);
        JButton btnClose = new JButton("Cancel");
        l.add((Component)btnOk);
        l.add((Component)btnClose);
        l.pop();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, (JButton)btnOk);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        UIUtil.center((Component)((Object)this));
    }

    public Attachment getCreatedAttachment() {
        return this.mCreatedAttachment;
    }
}

