/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.StreamIterableIterator;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.SelectionContext;
import com.sigrity.acl.db.Selector;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.AHistoryTextField;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.tools.dbexplorer.DBEResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionListener;

public class FilterByPropertyNameValuePanel {
    protected SelectionContext mSelCtx;
    protected FilterByPropertyListener mFilterByPropertyListener = null;
    protected JPanel mMainPanel = null;
    protected JLabel mLblFilterProperty = null;
    protected JLabel mLblFilterOperator = null;
    protected JLabel mLblFilterValue = null;
    protected AHistoryTextField mPropertyValueFilter = null;
    protected JLabel mLblHelpPatternName = null;
    protected JLabel mLblHelpPatternValue = null;
    protected JLabel mLblFilterSummary = null;
    private JComboBox<String> mFilterOperator = null;
    protected JLabel mPropNameLblStatus = new JLabel();
    protected JLabel mPropValueLblStatus = new JLabel();
    protected ObjectCellRenderer mObjectCellRenderer = null;
    protected DefaultComboBoxModel<Selector.Property<?>> mAllPropNameSelectionData;
    protected Selector.Property<?> mDefaultToSelect = null;
    protected int mDefaultIndexToSelect = -1;
    protected Vector<Object> mAllPropValueSelectionData;
    protected AHistoryTextField.UpdateListener mNameFilterChanged = new AHistoryTextField.UpdateListener(){

        @Override
        public void update(AHistoryTextField.UpdateHint hint) {
            FilterByPropertyNameValuePanel.this.updateFilteredPropNameData();
        }
    };
    protected AHistoryTextField.UpdateListener mFilterChanged = new AHistoryTextField.UpdateListener(){

        @Override
        public void update(AHistoryTextField.UpdateHint hint) {
            FilterByPropertyNameValuePanel.this.updateFilteredPropValueData();
        }
    };
    protected JList<Object> mListPropValueSelections = new JList<Object>(){

        @Override
        public void setModel(ListModel<Object> model) {
            super.setModel(model);
            this.setSelectionMode(2);
            this.setSelectionInterval(0, model.getSize() - 1);
        }
    };
    protected JComboBox<Selector.Property<?>> mListPropNameSelections = new JComboBox();
    protected ItemListener mPropNameSelectionListener = e -> this.selectedSelectByPropertyChanged();
    protected ListSelectionListener mPropValueSelectionListener = e -> this.updateFilterSummary();
    protected ActionListener mDoModifierChanged = e -> this.updateFilterSummary();

    protected void updateAllPropNameSelData() {
        this.mAllPropNameSelectionData = new DefaultComboBoxModel();
        if (this.mFilterByPropertyListener.getDescriptor() != null) {
            this.mAllPropNameSelectionData.addElement(null);
            List<Selector.Property<?>> list = this.mFilterByPropertyListener.getOverridePropertyList();
            int i = 1;
            this.mDefaultIndexToSelect = -1;
            if (list != null) {
                for (Selector.Property<?> prop : list) {
                    if (prop.getName().equals(this.mDefaultToSelect.getName())) {
                        this.mDefaultIndexToSelect = i;
                    }
                    this.mAllPropNameSelectionData.addElement(prop);
                    ++i;
                }
            } else {
                for (Selector.Property prop : this.mFilterByPropertyListener.getDescriptor().getProperties(this.mSelCtx.getDb())) {
                    if (this.mDefaultToSelect != null && prop.getName().equals(this.mDefaultToSelect.getName())) {
                        this.mDefaultIndexToSelect = i;
                    }
                    this.mAllPropNameSelectionData.addElement(prop);
                    ++i;
                }
            }
        }
        this.updateFilteredPropNameData();
    }

    public void updateAllPropValueSelData() {
        this.mAllPropValueSelectionData = new Vector();
        Selector.Property<?> prop = this.getFilterProperty();
        if (prop != null) {
            List<Object> list = this.mFilterByPropertyListener.getOverridePropertyValueList(prop);
            if (list != null) {
                for (Object s : list) {
                    this.mAllPropValueSelectionData.add(s);
                }
            } else if (this.mSelCtx != null && this.mSelCtx.isValid()) {
                for (Object s : AIterableItr.itr((Iterator)prop.getAllValues(this.mSelCtx))) {
                    this.mAllPropValueSelectionData.add(s.toString());
                }
            }
            Collections.sort(this.mAllPropValueSelectionData, (a, b) -> AUtil.compareAlphaNumericAccountForNone((Object)a, (Object)b));
        }
        this.updateFilteredPropValueData();
    }

    protected void updateFilteredPropNameData() {
        if (this.mAllPropNameSelectionData != null) {
            this.mListPropNameSelections.setModel(this.mAllPropNameSelectionData);
        }
        if (this.mListPropNameSelections.getItemCount() > 0) {
            this.mListPropNameSelections.setSelectedIndex(this.mDefaultIndexToSelect < 0 ? 0 : this.mDefaultIndexToSelect);
        }
        this.mListPropNameSelections.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object val, int idx, boolean selected, boolean hasFocus) {
                super.getListCellRendererComponent(list, val, idx, selected, hasFocus);
                if (val == null) {
                    this.setText("<NONE>");
                } else if (val instanceof Selector.Property) {
                    this.setText(((Selector.Property)val).getUserName());
                } else {
                    this.setText("" + val);
                }
                return this;
            }
        });
        this.mPropNameLblStatus.setText("Property (all listed)");
    }

    protected void updateFilteredPropValueData() {
        this.mListPropValueSelections.setListData(this.mAllPropValueSelectionData);
        if (!this.mPropertyValueFilter.isEnabled()) {
            this.mPropValueLblStatus.setText("Value");
            return;
        }
        Object filter = this.mPropertyValueFilter.getText();
        Selector.Property<?> prop = this.getFilterProperty();
        if (prop == null) {
            return;
        }
        String propName = prop.getUserName();
        if (((String)filter).length() == 0 || ((String)filter).equals("*")) {
            this.mPropValueLblStatus.setText("Value (all " + propName + "s listed)");
            return;
        }
        if (((String)filter).indexOf(42) == -1 && ((String)filter).indexOf(63) == -1) {
            filter = (String)filter + ".*";
        }
        try {
            Pattern pattern = Pattern.compile((String)filter);
            Vector<String> filteredData = new Vector<String>(this.mAllPropValueSelectionData.size());
            for (int i = 0; i < this.mAllPropValueSelectionData.size(); ++i) {
                String value = this.mAllPropValueSelectionData.get(i).toString();
                if (!pattern.matcher(value).find()) continue;
                filteredData.add(value);
            }
            this.updateFilterSummary();
            this.mListPropValueSelections.setListData(filteredData);
            this.mPropValueLblStatus.setText("Value (" + filteredData.size() + " of " + this.mAllPropValueSelectionData.size() + " " + propName + "s listed)");
        }
        catch (PatternSyntaxException e) {
            this.mPropValueLblStatus.setText("Value (Invalid pattern, all " + propName + "s listed).");
            this.mListPropValueSelections.setListData(this.mAllPropValueSelectionData);
        }
    }

    protected void updateFilterSummary() {
        if (this.mLblFilterSummary == null) {
            return;
        }
        Selector.Property<?> prop = this.getFilterProperty();
        String text = "No filters applied.";
        if (prop != null) {
            int numPickedValues = this.mListPropValueSelections.getSelectedIndices().length;
            String op = this.getFilterOperator().getSelectedItem().toString();
            text = numPickedValues == 1 ? String.format("%s's %s %s '%s'.", this.mFilterByPropertyListener.objTypeName(), prop.getUserName(), op, this.mListPropValueSelections.getSelectedValue()) : String.format("%s's %s %s %d values.", this.mFilterByPropertyListener.objTypeName(), prop.getUserName(), op, numPickedValues);
        }
        this.mLblFilterSummary.setText("Filter: " + text);
    }

    public Selector.Property<?> getFilterProperty() {
        return (Selector.Property)this.mListPropNameSelections.getSelectedItem();
    }

    public void setFilterProperty(String name) {
        ComboBoxModel<Selector.Property<?>> lm = this.mListPropNameSelections.getModel();
        for (int i = 0; i < lm.getSize(); ++i) {
            Selector.Property p = (Selector.Property)lm.getElementAt(i);
            if (p == null || !p.getName().equals(name)) continue;
            this.mListPropNameSelections.setSelectedIndex(i);
            this.selectedSelectByPropertyChanged();
            break;
        }
    }

    public void clearFilterPropValSelection() {
        this.mListPropValueSelections.clearSelection();
    }

    public void addFilterPropValSelection(String val) {
        ListModel<Object> lm = this.mListPropValueSelections.getModel();
        for (int i = 0; i < lm.getSize(); ++i) {
            String s = lm.getElementAt(i).toString();
            if (!s.equals(val)) continue;
            this.mListPropValueSelections.addSelectionInterval(i, i);
        }
    }

    public String getFilter() {
        return this.mPropertyValueFilter.getText();
    }

    public IterableIterator<Object> getPropValueSelectedItems() {
        return new StreamIterableIterator(this.mListPropValueSelections.getSelectedValuesList().stream());
    }

    public JPanel getMainPanel() {
        return this.mMainPanel;
    }

    public void selectedObjectTypeChanged() {
        this.updateAllPropNameSelData();
        this.selectedSelectByPropertyChanged();
    }

    protected void selectedSelectByPropertyChanged() {
        boolean enableFilter;
        Selector.Property<?> prop = this.getFilterProperty();
        boolean enableProp = this.mFilterByPropertyListener.objTypeName() != null;
        boolean bl = enableFilter = prop != null;
        if (this.selectedSelectByPropertyChanged(enableProp)) {
            this.mPropertyValueFilter.setEnabled(enableFilter);
            this.mLblHelpPatternName.setEnabled(enableProp);
            this.mLblHelpPatternValue.setEnabled(enableFilter);
            this.mLblFilterSummary.setEnabled(true);
            this.mListPropValueSelections.setEnabled(enableFilter);
            if (!enableFilter) {
                this.mListPropValueSelections.removeAll();
                this.mListPropValueSelections.setListData(new Vector());
                this.mListPropValueSelections.clearSelection();
            }
            this.updateFilterSummary();
            this.updateAllPropValueSelData();
        }
    }

    protected void updateOperators() {
        LinkedList modifiers = AUtil.linkedList((Iterator)Selection.getOperators());
        Collections.sort(modifiers);
        this.getFilterOperator().removeAllItems();
        for (String d : modifiers) {
            this.getFilterOperator().addItem(d);
        }
    }

    public FilterByPropertyNameValuePanel(GridBagManager l, Db db, FilterByPropertyListener filterByPropertytListener) {
        this.init(l, db, filterByPropertytListener);
    }

    public boolean selectedSelectByPropertyChanged(boolean enableProp) {
        boolean ans = false;
        if (this.mLblFilterProperty != null) {
            ans = true;
            this.mLblFilterProperty.setEnabled(enableProp);
        }
        if (this.mLblFilterOperator != null) {
            ans = true;
            this.mLblFilterOperator.setEnabled(enableProp);
        }
        if (this.mLblFilterValue != null) {
            ans = true;
            this.mLblFilterValue.setEnabled(enableProp);
        }
        return ans;
    }

    protected void init(GridBagManager parentLayout, Db db, FilterByPropertyListener filterByPropertytListener) {
        this.mMainPanel = new JPanel();
        GridBagManager l = new GridBagManager((Container)this.mMainPanel);
        this.mFilterByPropertyListener = filterByPropertytListener;
        this.mDefaultToSelect = this.mFilterByPropertyListener.getDefaultToSelect();
        this.mSelCtx = SelectionContext.create((Db)db);
        this.mLblHelpPatternName = new JLabel(DBEResources.ICON_UNKNOWN);
        this.mPropertyValueFilter = new AHistoryTextField("GUI", "Selection_PropertyValue", 12);
        this.mPropertyValueFilter.setUpdateListener(this.mFilterChanged);
        this.mPropertyValueFilter.setInvokeActionOnTextUpdate(true);
        this.mPropertyValueFilter.setToolTipText("Regular expression filter for the list of values. Leave blank to see all values.");
        this.mLblHelpPatternValue = new JLabel(DBEResources.ICON_UNKNOWN);
        this.mFilterOperator = new JComboBox();
        this.mFilterOperator.addActionListener(this.mDoModifierChanged);
        this.updateOperators();
        if (!this.mFilterByPropertyListener.onlyShowList()) {
            this.mLblFilterProperty = (JLabel)l.add((Component)this.mPropNameLblStatus, (GridBagConstraints)GridBagManager.LEFT.insetVert(0));
            l.newline();
            l.add(this.mListPropNameSelections, (GridBagConstraints)GridBagManager.FILLX);
            l.newline();
            l.push((GridBagConstraints)GridBagManager.LEFT.anchor(18).insetHoriz(0));
            this.mLblFilterOperator = l.add("Operator:", (GridBagConstraints)GridBagManager.LEFT.insetVert(0));
            HashMap<Boolean, Integer> opMap = new HashMap<Boolean, Integer>();
            for (int i = 0; i < this.mFilterOperator.getItemCount(); ++i) {
                String op = this.getFilterOperator().getItemAt(i);
                if (op.equals("Equals")) {
                    opMap.put(true, i);
                    continue;
                }
                if (op.equals("NotEquals")) {
                    opMap.put(false, i);
                    continue;
                }
                throw new UnsupportedOperationException("Need to update UI design by developer");
            }
            l.add(this.mFilterOperator, (GridBagConstraints)GridBagManager.LEFT);
            l.pop();
            l.newline();
            this.mLblFilterValue = (JLabel)l.add((Component)this.mPropValueLblStatus, (GridBagConstraints)GridBagManager.LEFT.insetVert(0));
            this.mLblFilterValue.setLabelFor(this.mLblFilterProperty);
            l.newline();
            l.add((Component)((Object)this.mPropertyValueFilter), (GridBagConstraints)GridBagManager.FILLX.insetVert(0));
            this.mLblFilterProperty.setLabelFor((Component)((Object)this.mPropertyValueFilter));
            l.newline();
        } else {
            this.mLblFilterProperty = (JLabel)l.add((Component)this.mPropNameLblStatus);
            this.mLblFilterProperty.setVisible(false);
        }
        this.mListPropNameSelections.addItemListener(this.mPropNameSelectionListener);
        this.mListPropNameSelections.setToolTipText("Pick the property to filter by, or <NONE> to disable filtering.");
        this.mListPropValueSelections.addListSelectionListener(this.mPropValueSelectionListener);
        this.mListPropValueSelections.setToolTipText("Pick the value(s) desired.");
        this.mObjectCellRenderer = new ObjectCellRenderer();
        this.mListPropValueSelections.setCellRenderer(this.mObjectCellRenderer);
        JScrollPane scrollPropValueSelections = new JScrollPane(this.mListPropValueSelections, 20, 30);
        scrollPropValueSelections.setPreferredSize(new Dimension(200, 100));
        l.add((Component)scrollPropValueSelections, (GridBagConstraints)GridBagManager.FILLALL);
        if (!this.mFilterByPropertyListener.onlyShowList()) {
            l.newline();
            l.pushFillXRemainX();
        }
        this.mLblFilterSummary = l.add("Filter Summary: none", (GridBagConstraints)GridBagManager.FILLX.insetVert(0));
        if (this.mFilterByPropertyListener.onlyShowList()) {
            this.mLblFilterSummary.setVisible(false);
        }
        if (!this.mFilterByPropertyListener.onlyShowList()) {
            l.pop();
        }
        this.selectedObjectTypeChanged();
        parentLayout.add((Component)this.mMainPanel);
    }

    public void setVisible(boolean visible) {
        this.mMainPanel.setVisible(visible);
    }

    public JComboBox<String> getFilterOperator() {
        return this.mFilterOperator;
    }

    public static interface FilterByPropertyListener {
        public Selector.Descriptor<?> getDescriptor();

        public String objTypeName();

        public List<Selector.Property<?>> getOverridePropertyList();

        public Selector.Property<?> getDefaultToSelect();

        public List<Object> getOverridePropertyValueList(Selector.Property<?> var1);

        public boolean onlyShowList();
    }

    static class ObjectCellRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        public ObjectCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                this.setText("<NONE>");
                this.setIcon(null);
            } else if (value instanceof Personality) {
                this.setText(((Personality)value).getName());
                this.setIcon((Icon)new AColorIcon(16, 16, ((Personality)value).getColor()));
            } else if (value instanceof Color) {
                this.setText(((Personality)value).getName());
                this.setIcon((Icon)new AColorIcon(16, 16, (Color)value));
            } else {
                this.setIcon(null);
                this.setText(value.toString());
            }
            if (isSelected) {
                this.setBackground(Color.lightGray);
            } else {
                this.setBackground(Color.white);
            }
            return this;
        }
    }
}

