/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AAlphaNumComp;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.BondFingerUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Floorplan;
import com.sigrity.acl.db.std.FloorplanPin;
import com.sigrity.acl.db.std.Interface;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PersonalityMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.optimizer.PortPairOpt;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.ADecoratedIcon;
import com.sigrity.acl.ui.ATreeUtil;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.InterfaceTreeUI;
import com.sigrity.orbit.ui.PersonalityUI;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import com.sigrity.tools.dbexplorer.DBEResources;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FixedFreePinSelection
extends JPanel {
    private static DevicePath mDevicePathA;
    private static DevicePath mDevicePathB;
    protected final AAppView mView;
    private final Design mDesign;
    private final Db mDb;
    private DefaultTreeModel mSubstrateTreeModelA;
    private DefaultTreeModel mSubstrateTreeModelB;
    protected JTree mSubstrateTreeA;
    protected JTree mSubstrateTreeB;
    private JButton mSetA;
    private JButton mSetB;
    private JLabel mFixedLabel;
    private JLabel mFreeLabel;
    private int mACount;
    private int mBCount;
    protected boolean mRemoveNetMapping = PortPairOpt.isRemoveNetMappingOnToSide();
    protected boolean mOnePinOneNet = !PortPairOpt.getTreatFromAsIndividuals();
    protected Floorplan mLastFloorPlan = null;
    boolean refreshPending = false;
    protected ActionListener setAActionListener = e -> this.setASetAction();
    protected ActionListener setBActionListener = e -> this.setBSetAction();
    protected LinkedList<SetAListener> mSetAListeners = new LinkedList();

    public FixedFreePinSelection() {
        this.mView = OrbitIO.getCurView();
        this.mDb = this.mView.getDb();
        this.mDesign = Design.getDesign((Db)this.mDb);
        Cp.exec((String)"UserCommands.unselectAll()", (Object[])new Object[0]);
        GridBagManager l = new GridBagManager((Container)this);
        this.populateMe();
        l.push("Pin Selection", (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        this.mACount = 0;
        this.mFixedLabel = new JLabel("Fixed end: 0 pins");
        this.mFixedLabel.setForeground(Color.RED);
        l.add((Component)this.mFixedLabel, (GridBagConstraints)GridBagManager.LEFT);
        this.mBCount = 0;
        this.mFreeLabel = new JLabel("Free end: 0 pins");
        l.add((Component)this.mFreeLabel, (GridBagConstraints)GridBagManager.LEFT);
        Color darkGreen = Color.GREEN;
        darkGreen = darkGreen.darker().darker();
        this.mFreeLabel.setForeground(darkGreen);
        l.newline();
        this.mSubstrateTreeA = new JTree(this.mSubstrateTreeModelA);
        this.mSubstrateTreeA.setEditable(false);
        this.mSubstrateTreeA.setCellRenderer(new SubstrateTreeRenderer());
        this.mSubstrateTreeA.setShowsRootHandles(true);
        this.mSubstrateTreeA.getSelectionModel().setSelectionMode(4);
        this.mSubstrateTreeA.setRootVisible(false);
        this.mSubstrateTreeA.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                if (evt.getNewLeadSelectionPath() == null) {
                    return;
                }
                mDevicePathA = FixedFreePinSelection.this.makeTheDevicePathFromTreePath(evt.getNewLeadSelectionPath());
                FixedFreePinSelection.this.doTreeASelectionAction();
                mDevicePathA = null;
            }
        });
        JScrollPane pA = new JScrollPane(this.mSubstrateTreeA);
        pA.setPreferredSize(new Dimension(200, 100));
        pA.setMinimumSize(pA.getPreferredSize());
        l.add((Component)pA, (GridBagConstraints)GridBagManager.FILLALL);
        this.mSubstrateTreeB = new JTree(this.mSubstrateTreeModelB);
        this.mSubstrateTreeB.setEditable(false);
        this.mSubstrateTreeB.setCellRenderer(new SubstrateTreeRenderer());
        this.mSubstrateTreeB.setShowsRootHandles(true);
        this.mSubstrateTreeB.getSelectionModel().setSelectionMode(1);
        this.mSubstrateTreeB.setRootVisible(false);
        this.mSubstrateTreeB.getSelectionModel().setSelectionMode(4);
        this.mSubstrateTreeB.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                if (evt.getNewLeadSelectionPath() == null) {
                    return;
                }
                mDevicePathB = FixedFreePinSelection.this.makeTheDevicePathFromTreePath(evt.getNewLeadSelectionPath());
                FixedFreePinSelection.this.doTreeBSelectionAction();
                mDevicePathB = null;
            }
        });
        JScrollPane pB = new JScrollPane(this.mSubstrateTreeB);
        pB.setPreferredSize(new Dimension(200, 100));
        pB.setMinimumSize(pB.getPreferredSize());
        l.add((Component)pB, (GridBagConstraints)GridBagManager.FILLALL);
        l.newline();
        this.mSetA = new JButton("Set Fixed From Canvas");
        this.mSetA.setForeground(Color.RED);
        this.mSetA.addActionListener(this.setAActionListener);
        l.add((Component)this.mSetA, (GridBagConstraints)GridBagManager.LEFT);
        this.mSetB = new JButton("Set Free From Canvas");
        this.mSetB.setForeground(Color.GREEN.darker().darker());
        this.mSetB.addActionListener(this.setBActionListener);
        l.add((Component)this.mSetB, (GridBagConstraints)GridBagManager.LEFT);
        l.pop();
        l.newline();
        this.setMinimumSize(this.getPreferredSize());
        UIUtil.center((Component)this);
        this.setVisible(true);
    }

    public Floorplan getLastFloorPlan() {
        return this.mLastFloorPlan;
    }

    public int getACount() {
        return this.mACount;
    }

    public int getBCount() {
        return this.mBCount;
    }

    public void setRemoveNetMapping(boolean value) {
        this.mRemoveNetMapping = value;
    }

    public void setOnePinOneNet(boolean value) {
        this.mOnePinOneNet = value;
    }

    public void setDevicePathA(String devicePathString) {
        mDevicePathA = DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)devicePathString);
    }

    private void insert(MutableTreeNode tn, PortRefNode n) {
        int len = tn.getChildCount();
        for (int i = 0; i < len; ++i) {
            PortRefNode curNode = (PortRefNode)tn.getChildAt(i);
            if (n.compareTo(curNode) >= 0) continue;
            tn.insert(n, i);
            return;
        }
        tn.insert(n, len);
    }

    protected void createInterfaceTree(PortRefNode parentNode, ATreeNode parentTreeNode) {
        for (ATreeNode child : parentTreeNode.children) {
            String intfName = child.fp.getMyInterface().getName();
            PortRefNode fpNode = new PortRefNode(intfName);
            fpNode.setNodeType(NodeType.FLOORPLANS);
            fpNode.setFloorplan(child.fp);
            parentNode.add(fpNode);
            this.createInterfaceTree(fpNode, child);
        }
    }

    protected ATreeNode buildInterfaceTree(List<Floorplan> set) {
        if (set.isEmpty()) {
            return null;
        }
        FloorplanTree fpt = new FloorplanTree();
        for (Floorplan fp : set) {
            Floorplan parent;
            ATreeNode thisNode = fpt.exists(fp);
            if (thisNode == null) {
                thisNode = fpt.newNode(fp);
            }
            if ((parent = fp.getParentFloorplan()) == null) continue;
            ATreeNode parentNode = fpt.exists(parent);
            if (parentNode == null) {
                parentNode = fpt.newNode(parent);
            }
            fpt.addChild(parentNode, thisNode);
        }
        return fpt.createRoot();
    }

    private static List<Floorplan> deriveFloorplans(DevicePath path, Device d) {
        assert (path.getDevice() == d);
        if (!d.getTemplate().amIASubstrate()) {
            return new LinkedList<Floorplan>();
        }
        LinkedHashSet<Floorplan> fps = new LinkedHashSet<Floorplan>();
        for (Net net : d.getNets()) {
            Interface intf = net.getInterface(path);
            if (intf == null) continue;
            for (Floorplan fp = intf.getFloorplan(d.getTemplate(), true); fp != null; fp = fp.getParentFloorplan()) {
                fps.add(fp);
            }
        }
        return new LinkedList<Floorplan>(fps);
    }

    private void addMeAndMyChildren(DevicePath path, MutableTreeNode tn) {
        Device d = path.getDevice();
        if (d.getType() == DeviceTemplate.Type.BUMP) {
            return;
        }
        DeviceTemplate t = d.getTemplate();
        PortRefNode n = new PortRefNode(d.getName());
        n.mDevice = d;
        if (d.getIsSubstrate()) {
            Substrate s = d.getTemplate().getSubstrate();
            n.setType(t.getType(), true);
            n.setNodeType(NodeType.SUBSTRATE);
            PortRefNode floorplanFolder = new PortRefNode("Floor Plans");
            floorplanFolder.setNodeType(NodeType.FLOORPLANFOLDER);
            List<Floorplan> fps = FixedFreePinSelection.deriveFloorplans(path, d);
            if (!fps.isEmpty()) {
                Collections.sort(fps, AAlphaNumComp::comp);
                this.insert(n, floorplanFolder);
                ATreeNode root = this.buildInterfaceTree(fps);
                this.createInterfaceTree(floorplanFolder, root);
            }
            boolean hasPersonalities = false;
            PortRefNode pinPersFolder = new PortRefNode("Pin Personalities");
            pinPersFolder.setNodeType(NodeType.PERSONALITYFOLDER);
            ArrayList personalityList = new ArrayList();
            for (DeviceTemplate devTemp : s.getDeviceTemplates()) {
                Personality.getPersonalities((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.PORT).forEach(personalityList::add);
            }
            personalityList.sort((a, b) -> a.getName().compareTo(b.getName()));
            for (Personality p : personalityList) {
                PortRefNode pinPersNode = new PortRefNode(FixedFreePinSelection.getPinPersNodeText(p, t));
                pinPersNode.setNodeType(NodeType.PORTPERSONALITY);
                pinPersNode.setPersonality(p);
                pinPersFolder.add(pinPersNode);
                hasPersonalities = true;
            }
            if (hasPersonalities) {
                this.insert(n, pinPersFolder);
            }
            if (d.getType() == DeviceTemplate.Type.DIE || d.getType() == DeviceTemplate.Type.INTERPOSER) {
                PortRefNode bfNode = new PortRefNode("Bumps");
                bfNode.setNodeType(NodeType.BUMPSFOLDER);
                this.insert(n, bfNode);
            }
        } else {
            n.setNodeType(NodeType.DEVICE);
            n.setType(d.getDeviceType(), false);
            boolean hasPersonalities = false;
            PortRefNode pinPersFolder = new PortRefNode("Pin Personalities");
            pinPersFolder.setNodeType(NodeType.PERSONALITYFOLDER);
            ArrayList personalityList = new ArrayList();
            Personality.getPersonalities((DeviceTemplate)d.getTemplate(), (Personality.Type)Personality.Type.PORT).forEach(personalityList::add);
            personalityList.sort((a, b) -> a.getName().compareTo(b.getName()));
            for (Personality p : personalityList) {
                PortRefNode pinPersNode = new PortRefNode(FixedFreePinSelection.getPinPersNodeText(p, t));
                pinPersNode.setNodeType(NodeType.PORTPERSONALITY);
                pinPersNode.setPersonality(p);
                pinPersFolder.add(pinPersNode);
                hasPersonalities = true;
            }
            if (hasPersonalities) {
                this.insert(n, pinPersFolder);
            }
        }
        this.insert(tn, n);
        if (d.getType() == DeviceTemplate.Type.PACKAGE && BondFingerUtil.hasBondFingers((DeviceTemplate)d.getTemplate())) {
            PortRefNode bfNode = new PortRefNode("Bond Fingers");
            bfNode.setNodeType(NodeType.BONDFINGERSFOLDER);
            this.insert(n, bfNode);
        }
        for (Device child : d.getChildren()) {
            if (d.getType() == DeviceTemplate.Type.BUMP) {
                return;
            }
            this.addMeAndMyChildren(new DevicePath(path, child), n);
        }
    }

    private static String getPinPersNodeText(Personality p, DeviceTemplate refOwner) {
        Object s = p.getName() == null ? "null" : p.getName();
        DeviceTemplate owner = p.getOwner();
        if (owner != null && refOwner != null && !AUtil.equals((Object)owner, (Object)refOwner)) {
            Stream<DevicePath> relInstPaths = owner.getHierarchicalInstances().stream().filter(path -> !path.isEmpty()).filter(path -> path.containsDeviceTemplate(refOwner)).map(path -> path.getRelativePathFromAnchor(refOwner));
            Stream<String> relPathDescs = relInstPaths.map(path -> path.stream().map(Device::getName).collect(Collectors.joining("/")));
            String pathDescs = relPathDescs.collect(Collectors.joining(", "));
            s = (String)s + " (" + pathDescs + ")";
        }
        return s;
    }

    public void refreshTrees() {
        if (this.refreshPending) {
            return;
        }
        this.refreshPending = true;
        ATreeUtil.NodeTextTreeState treeStateA = ATreeUtil.NodeTextTreeState.from((JTree)this.mSubstrateTreeA);
        ATreeUtil.NodeTextTreeState treeStateB = ATreeUtil.NodeTextTreeState.from((JTree)this.mSubstrateTreeB);
        EventQueue.invokeLater(() -> {
            this.populateMe();
            this.mSubstrateTreeA.setModel(this.mSubstrateTreeModelA);
            this.mSubstrateTreeB.setModel(this.mSubstrateTreeModelB);
            treeStateA.to(this.mSubstrateTreeA);
            treeStateB.to(this.mSubstrateTreeB);
            this.refreshPending = false;
        });
    }

    private void populateMe() {
        PortRefNode root = new PortRefNode("Design");
        for (Device t : this.mDesign.getRootDevices()) {
            this.addMeAndMyChildren(new DevicePath(t), root);
        }
        this.mSubstrateTreeModelA = new DefaultTreeModel(root);
        this.mSubstrateTreeModelB = new DefaultTreeModel(root);
    }

    protected void doTreeBSelectionAction() {
        Cp.exec((String)"curSelection().clear()", (Object[])new Object[0]);
        TreePath[] tp = this.mSubstrateTreeB.getSelectionPaths();
        if (tp == null) {
            return;
        }
        for (TreePath aTp : tp) {
            PortRefNode nodeB = (PortRefNode)aTp.getLastPathComponent();
            DevicePath bPath = this.makeTheDevicePathFromTreePath(aTp);
            this.selectPorts(bPath, nodeB);
        }
        UIUtil.pushButton((AbstractButton)this.mSetB, (boolean)false);
        this.updatePPOptions();
        OrbitIO.getApp().refreshCurrentView(true);
    }

    protected void updatePPOptions() {
        PortPairOpt ppo = PortPairOpt.getActive(OrbitIO.getCurDb());
        if (ppo == null) {
            return;
        }
        PortPairOpt.setRemoveNetMappingOnToSide(this.mRemoveNetMapping);
        PortPairOpt.setTreatFromAsIndividuals(!this.mOnePinOneNet);
        ppo.setUseOnlyUsedPortsOnFixedSide(false);
        ppo.setUseOnlyUnusedPortsOnFreeSide(false);
        ppo.filterSets();
        this.updateACount();
        this.updateBCount();
    }

    protected void doTreeASelectionAction() {
        Cp.exec((String)"curSelection().clear()", (Object[])new Object[0]);
        TreePath[] tp = this.mSubstrateTreeA.getSelectionPaths();
        if (tp == null) {
            return;
        }
        for (TreePath aTp : tp) {
            PortRefNode nodeA = (PortRefNode)aTp.getLastPathComponent();
            DevicePath aPath = this.makeTheDevicePathFromTreePath(aTp);
            this.selectPorts(aPath, nodeA);
            if (nodeA.getNodeType() != NodeType.FLOORPLANS) continue;
            this.mLastFloorPlan = nodeA.getFloorplan();
        }
        UIUtil.pushButton((AbstractButton)this.mSetA, (boolean)false);
        this.updatePPOptions();
    }

    protected DevicePath makeTheDevicePathFromTreePath(TreePath tp) {
        DevicePath dp = new DevicePath();
        for (int i = 1; i < tp.getPathCount(); ++i) {
            Object o = tp.getPathComponent(i);
            PortRefNode prn = (PortRefNode)o;
            if (prn.mDevice == null) continue;
            dp.add(prn.mDevice);
        }
        return dp;
    }

    public void updateCounts() {
        this.updateACount();
        this.updateBCount();
    }

    protected void updateACount() {
        List<HierPin> list = PortPairOpt.getActive(OrbitIO.getCurDb()).getAPorts();
        this.mACount = list != null ? list.size() : 0;
        this.mFixedLabel.setText("Fixed end: " + this.mACount + " pins");
        this.mFixedLabel.updateUI();
    }

    protected void updateBCount() {
        this.mBCount = 0;
        List<HierPin> list = PortPairOpt.getActive(OrbitIO.getCurDb()).getBPorts();
        this.mBCount = list != null ? list.size() : 0;
        this.mFreeLabel.setText("Free end: " + this.mBCount + " pins");
        this.mFreeLabel.updateUI();
    }

    protected void setASetAction() {
        Cp.exec((String)"com.sigrity.orbit.ui.FixedFreePinSelection.retrieveSelectedPathObjectsOnA(\"%s\");", (Object[])new Object[]{mDevicePathA != null ? mDevicePathA.toString() : null});
        this.updatePPOptions();
        this.updateACount();
        this.fireSetAChanged(this.mACount);
    }

    protected void setBSetAction() {
        Cp.exec((String)"com.sigrity.orbit.ui.FixedFreePinSelection.retrieveSelectedPathObjectsOnB(\"%s\");", (Object[])new Object[]{mDevicePathB != null ? mDevicePathB.toString() : null});
        this.updatePPOptions();
        this.updateBCount();
    }

    public void addSetAListener(SetAListener l) {
        if (l != null) {
            this.mSetAListeners.push(l);
        }
    }

    public void removeSetAListener(SetAListener l) {
        this.mSetAListeners.remove(l);
    }

    protected void fireSetAChanged(int aCount) {
        for (SetAListener l : this.mSetAListeners) {
            l.setAChanged(aCount);
        }
    }

    public static void retrieveSelectedPathObjectsOnA(String devicePathString) {
        if (devicePathString != null) {
            mDevicePathA = DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)devicePathString);
        }
        FixedFreePinSelection.retrieveSelectedPathObjectsOnA(false);
    }

    public static void retrieveSelectedPathObjectsOnB(String devicePathString) {
        if (devicePathString != null) {
            mDevicePathB = DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)devicePathString);
        }
        FixedFreePinSelection.retrieveSelectedPathObjectsOnB(false);
    }

    public static void retrieveSelectedPathObjectsOnA() {
        FixedFreePinSelection.retrieveSelectedPathObjectsOnA(false);
    }

    public static void retrieveSelectedPathObjectsOnA(boolean add) {
        Db db = OrbitIO.getCurDb();
        PortPairOpt ppo = PortPairOpt.getActive(db);
        if (ppo == null) {
            ppo = new PortPairOpt();
        }
        ArrayList<HierPin> dp = new ArrayList<HierPin>();
        Selection s = Design.getSelection((Db)db);
        for (PinInstance o : s.get(PinInstance.class)) {
            for (DevicePath dpath : s.getSelectedPaths((DbObject)o)) {
                if (mDevicePathA != null && mDevicePathA.getDb() == db && !mDevicePathA.contains(dpath)) continue;
                dp.add(new HierPin(dpath, o));
            }
        }
        ppo.setAPorts(dp, add);
    }

    public static void retrieveSelectedPathObjectsOnB() {
        FixedFreePinSelection.retrieveSelectedPathObjectsOnB(false);
    }

    public static void retrieveSelectedPathObjectsOnB(boolean add) {
        Db db = OrbitIO.getCurDb();
        PortPairOpt ppo = PortPairOpt.getActive(db);
        if (ppo == null) {
            ppo = new PortPairOpt();
        }
        ArrayList<HierPin> dp = new ArrayList<HierPin>();
        Selection s = Design.getSelection((Db)db);
        for (PinInstance o : s.get(PinInstance.class)) {
            for (DevicePath dpath : s.getSelectedPaths((DbObject)o)) {
                if (mDevicePathB != null && mDevicePathB.getDb() == db && !mDevicePathB.contains(dpath)) continue;
                dp.add(new HierPin(dpath, o));
            }
        }
        ppo.setBPorts(dp, add);
    }

    public static void selectPortOnPersonality(String devicePath, String pinPersonalityKey) {
        Db db = OrbitIO.getCurDb();
        DevicePath dp = DevicePath.fromString((Db)db, (String)devicePath);
        Personality pinPersonality = pinPersonalityKey == null ? null : Personality.getByKeyStr((Db)db, (String)pinPersonalityKey);
        FixedFreePinSelection.selectPortOnPersonality(dp, pinPersonality);
    }

    public static void selectPortOnPersonality(DevicePath dp, Personality pinPersonality) {
        Selection selection = Design.getSelection((Db)dp.getDb());
        Substrate s = dp.getSubstrate();
        for (DevicePath descendent : dp.getDescendants()) {
            if (descendent.getSubstrate() != s) continue;
            for (PinInstance pinInstance : descendent.getLast().getPins()) {
                if (pinPersonality != null && !PersonalityMap.getPersonalities((Personality.Type)Personality.Type.PORT, (DbObject)pinInstance).anyMatch(pm -> pm.getPersonality().equals(pinPersonality))) continue;
                selection.add(descendent, (DbObject)pinInstance);
            }
        }
    }

    public static void selectBondFingerPorts(String dPathString) {
        Design design = OrbitIO.getCurDesign();
        Db db = design.getDb();
        Selection selection = design.getCurSelection();
        DevicePath dp = DevicePath.fromString((Db)db, (String)dPathString);
        for (PinInstance pinInstance : dp.getLast().getPins()) {
            if (pinInstance.getType() != PinTemplate.Type.BONDFINGERPAD) continue;
            selection.add(dp, (DbObject)pinInstance);
        }
    }

    private void selectPorts(DevicePath dp, PortRefNode n) {
        if (n.getNodeType() == NodeType.PERSONALITYFOLDER) {
            return;
        }
        if (n.getNodeType() == NodeType.FLOORPLANFOLDER) {
            return;
        }
        if (n.getNodeType() == NodeType.BONDFINGERSFOLDER) {
            Cp.exec((String)"%s.selectBondFingerPorts(\"%s\")", (Object[])new Object[]{FixedFreePinSelection.class.getName(), dp.toString()});
        } else if (n.getNodeType() == NodeType.BUMPSFOLDER) {
            Cp.exec((String)"Device.selectPadsOfType(\"%s\", PinTemplate.Type.%s, %s);", (Object[])new Object[]{dp.toString(), PinTemplate.Type.BUMPPAD.name(), true});
        } else if (n.getNodeType() == NodeType.FLOORPLANS) {
            Floorplan fp = n.getFloorplan();
            Cp.exec((String)"com.sigrity.orbit.ui.FixedFreePinSelection.selectPortsOnFloorplan(\"%s\", %s)", (Object[])new Object[]{fp.getKeyStr(), CpHelper.getCmdStr(dp)});
        } else {
            String persKey = n.getNodeType() == NodeType.PORTPERSONALITY ? String.format("\"%s\"", n.mPersonality.getKeyStr()) : "null";
            Cp.exec((String)"%s.selectPortOnPersonality(\"%s\", %s)", (Object[])new Object[]{FixedFreePinSelection.class.getName(), dp.toString(), persKey});
        }
        OrbitIO.getApp().refreshCurrentView(true);
    }

    @Deprecated
    public static void selectPortsOnFloorplan(String floorPlanKey) {
        FixedFreePinSelection.selectPortsOnFloorplan(floorPlanKey, null);
    }

    public static void selectPortsOnFloorplan(String floorPlanKey, DevicePath devPath) {
        Floorplan fp = (Floorplan)OrbitIO.getCurDb().getByKeyStr(Floorplan.class, floorPlanKey);
        FixedFreePinSelection.selectPortsOnFloorplan(fp, devPath);
    }

    public static void selectPortsOnFloorplan(Floorplan fp, DevicePath devPath) {
        if (fp == null) {
            return;
        }
        Selection s = Design.getSelection((Db)fp.getDb());
        try {
            for (FloorplanPin fpPin : fp.getIOPins()) {
                fpPin.addToSelection(s, devPath);
            }
        }
        catch (Floorplan.InvalidDataException e) {
            ALog.logError((Throwable)e);
        }
    }

    public static DevicePath deriveLeastCommonDevicePath(List<HierPin> aList, List<HierPin> bList) {
        DevicePath common = null;
        List<HierPin> listA = null;
        List<HierPin> listB = null;
        PortPairOpt ppo = PortPairOpt.getActive(OrbitIO.getCurDb());
        if (aList != null) {
            listA = aList;
        }
        if (bList != null) {
            listB = bList;
        }
        if (listA == null && ppo != null) {
            listA = ppo.getAPorts();
        }
        if (listB == null && ppo != null) {
            listB = ppo.getBPorts();
        }
        if (listA != null) {
            for (HierPin dpp : listA) {
                common = dpp.getPath().commonParent(common);
            }
        }
        if (listB != null) {
            for (HierPin dpp : listB) {
                common = dpp.getPath().commonParent(common);
            }
        }
        if (common == null || common.isEmpty() && common.getRoot() == null) {
            ALog.logInfo((String)"There is no common device path");
        } else {
            common = new DevicePath(common);
        }
        return common;
    }

    public class PortRefNode
    extends DefaultMutableTreeNode
    implements Comparable<PortRefNode> {
        protected boolean mIsSubstrate;
        protected NodeType mNodeType;
        protected DeviceTemplate.Type mDevType;
        protected Device mDevice;
        protected Personality mPersonality;
        protected Floorplan mFloorplan;

        PortRefNode(String s) {
            super(s);
        }

        public void setFloorplan(Floorplan fp) {
            this.mFloorplan = fp;
        }

        public Floorplan getFloorplan() {
            return this.mFloorplan;
        }

        public void setPersonality(Personality p) {
            this.mPersonality = p;
        }

        public DeviceTemplate.Type getSubstrateType() {
            return this.mDevType;
        }

        public NodeType getNodeType() {
            return this.mNodeType;
        }

        public void setNodeType(NodeType t) {
            this.mNodeType = t;
        }

        public DeviceTemplate.Type getDeviceType() {
            return this.mDevType;
        }

        public void setType(DeviceTemplate.Type type, boolean isSubstrate) {
            this.mDevType = type;
            this.mIsSubstrate = isSubstrate;
        }

        public boolean getIsSubstrate() {
            return this.mIsSubstrate;
        }

        @Override
        public int compareTo(PortRefNode o) {
            int r = this.getNodeType().getSortOrder() - o.getNodeType().getSortOrder();
            if (r == 0) {
                r = this.toString().compareTo("" + o);
            }
            return r;
        }

        @Override
        public String toString() {
            if (this.mPersonality != null && this.mPersonality.getType() == Personality.Type.PORT) {
                TreeNode grandparentNode;
                DeviceTemplate nodeOwner = null;
                TreeNode treeNode = grandparentNode = this.getParent() == null ? null : this.getParent().getParent();
                if (grandparentNode instanceof PortRefNode) {
                    PortRefNode prn = (PortRefNode)grandparentNode;
                    if (prn.mNodeType == NodeType.SUBSTRATE && prn.mDevice != null) {
                        nodeOwner = prn.mDevice.getTemplate();
                    }
                }
                return FixedFreePinSelection.getPinPersNodeText(this.mPersonality, nodeOwner);
            }
            return super.toString();
        }
    }

    public static class SetAAdapter
    implements SetAListener {
        @Override
        public void setAChanged(int count) {
        }
    }

    public static interface SetAListener {
        public void setAChanged(int var1);
    }

    public static class SubstrateTreeRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object val, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, val, selected, expanded, leaf, row, hasFocus);
            PortRefNode n = (PortRefNode)val;
            if (n.getNodeType() == NodeType.SUBSTRATE) {
                this.setIcon(DbExplorerPanel.getIconForTemplateType(n.getSubstrateType()));
            } else if (n.getNodeType() == NodeType.PORTPERSONALITY) {
                Personality p = n.mPersonality;
                Color color = p.getColor();
                this.setIcon((Icon)new AColorIcon(12, 12, color));
            } else if (n.getNodeType() == NodeType.FLOORPLANS) {
                Color color = n.getFloorplan().getMyInterface().getColor();
                this.setIcon((Icon)new AColorIcon(12, 12, color));
            } else if (n.getNodeType() == NodeType.BUMPSFOLDER) {
                ADecoratedIcon icon = new ADecoratedIcon(DBEResources.ICON_FOLDER, UIUtil.getScaledIcon((Icon)DbExplorerPanel.getIconForTemplateType(DeviceTemplate.Type.BUMP), (int)10, (int)10));
                this.setIcon((Icon)icon);
            } else if (n.getNodeType() == NodeType.PERSONALITYFOLDER) {
                this.setIcon(PersonalityUI.getIconForPersonalityType(Personality.Type.PORT));
            } else if (n.getNodeType() == NodeType.FLOORPLANFOLDER) {
                this.setIcon(InterfaceTreeUI.ICON_FLOORPLAN);
            } else if (n.getNodeType() == NodeType.BONDFINGERSFOLDER) {
                this.setIcon(DBEResources.ICON_BONDFINGERS);
            } else if (n.mDevice != null) {
                this.setIcon(DbExplorerPanel.getIconForDevice(n.mDevice));
            }
            return this;
        }
    }

    class FloorplanTree {
        LinkedList<ATreeNode> tree = new LinkedList();
        ATreeNode root = new ATreeNode();

        FloorplanTree() {
        }

        public ATreeNode newNode(Floorplan fp) {
            ATreeNode tn = new ATreeNode();
            tn.fp = fp;
            this.tree.add(tn);
            return tn;
        }

        public void addChild(ATreeNode parent, ATreeNode child) {
            parent.children.add(child);
            child.parent = parent;
        }

        public ATreeNode exists(Floorplan fp) {
            for (ATreeNode candidate : this.tree) {
                if (!candidate.fp.equals(fp)) continue;
                return candidate;
            }
            return null;
        }

        public ATreeNode createRoot() {
            for (ATreeNode atn : this.tree) {
                if (atn.parent != null) continue;
                this.root.children.add(atn);
            }
            return this.root;
        }
    }

    class ATreeNode {
        ATreeNode parent = null;
        LinkedList<ATreeNode> children = new LinkedList();
        Floorplan fp;

        ATreeNode() {
        }

        public String toString() {
            if (this.fp != null) {
                return this.fp.getMyInterface().getName();
            }
            return "no interface";
        }

        public void sort() {
            Collections.sort(this.children, (a, b) -> a.fp.getMyInterface().getName().compareTo(b.fp.getMyInterface().getName()));
            for (ATreeNode child : this.children) {
                child.sort();
            }
        }
    }

    public static enum NodeType {
        SUBSTRATE(40),
        DEVICE(50),
        FLOORPLANS(35),
        FLOORPLANFOLDER(34),
        PORTPERSONALITY(20),
        PERSONALITYFOLDER(10),
        BONDFINGERSFOLDER(30),
        BUMPSFOLDER(40);

        int mSortOrder;

        private NodeType(int sortOrder) {
            this.mSortOrder = sortOrder;
        }

        public int getSortOrder() {
            return this.mSortOrder;
        }
    }
}

