/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AColor;
import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Floorplan;
import com.sigrity.acl.db.std.FloorplanPin;
import com.sigrity.acl.db.std.Interface;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.geom.ACompositeGeom;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.AActionGroup;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.InterfaceCmds;
import com.sigrity.orbit.ObjectActionRegistry;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.ui.InterfaceTreeUI;
import com.sigrity.orbit.ui.InterfaceUI;
import com.sigrity.orbit.ui.core.DesignView2D;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class FloorplanUI {
    public static final ObjectActionRegistry.ActionFactory<Selection> ActionFactorySelection = (selection, constraints) -> {
        long count = 0L;
        ArrayList<Floorplan> fps = new ArrayList<Floorplan>();
        for (Floorplan fp : selection.get(Floorplan.class)) {
            fps.add(fp);
        }
        count = fps.size();
        if (count == 0L) {
            return AEmptyItr.create();
        }
        LinkedList<AbstractAction> actions = new LinkedList<AbstractAction>();
        Floorplan[] fpsa = fps.toArray(new Floorplan[0]);
        if (count == 1L) {
            Floorplan fp = (Floorplan)fps.get(0);
            if (selection.getSelectedPaths((DbObject)fp).count() == 0L) {
                actions.add(new ActionSelectFloorplanPinMenu(fp));
            } else {
                actions.add(new ActionSelectFloorplanPinMenu(fp, (IterableIterator<DevicePath>)selection.getSelectedPaths((DbObject)fp)));
            }
            actions.add(new ActionDynamicGlobMenu(fp));
            actions.add(new ActionEditFloorplanPinMenu(fp));
            actions.add(new ActionMovePinOnCursor(fp));
            actions.add(new ActionZoomToFloorplan(fp));
        }
        if (count > 0L) {
            actions.add(new ActionShowFloorplanMenu(fpsa));
            actions.add(new ActionPartitionFloorplanByPersonality(fpsa));
            List<Interface> intfs = fps.stream().map(Floorplan::getMyInterface).collect(Collectors.toList());
            Interface[] intfsa = intfs.toArray(new Interface[0]);
            actions.add(new InterfaceUI.ActionContractInterfaces(intfsa));
        }
        if (count > 1L) {
            actions.add(new ActionSwapFloorplanPin(fpsa));
        }
        return actions.iterator();
    };

    private FloorplanUI() {
    }

    public static class ActionPartitionFloorplanByPersonality
    extends AbstractAction {
        private Floorplan[] fps;

        public ActionPartitionFloorplanByPersonality(Floorplan ... fps) {
            super("Partition by Pin Personality");
            this.fps = fps;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            for (Floorplan fp : this.fps) {
                Cp.exec((String)"com.sigrity.orbit.InterfaceCmds.partitionFloorplanByPinPersonality(curDb(), \"%s\");", (Object[])new Object[]{fp.getKeyStr()});
            }
        }
    }

    public static class ActionSwapFloorplanPin
    extends AbstractAction {
        protected Floorplan first;
        protected Floorplan second;

        public ActionSwapFloorplanPin(Floorplan ... floorplans) {
            super("Swap Pins");
            if (floorplans.length != 2) {
                this.setEnabled(false);
            } else {
                this.first = floorplans[0];
                this.second = floorplans[1];
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List personalities2;
            if (this.first.hasChildren() || this.second.hasChildren()) {
                ALog.logWarn((String)"Floorplan has children. Cannot swap.");
                return;
            }
            if (this.first.getPinCount() != this.second.getPinCount()) {
                ALog.logWarn((String)"Floorplan pin counts do not match. Cannot swap.");
                return;
            }
            List personalities1 = this.first.getPersonalitiesOfPins();
            if (!personalities1.equals(personalities2 = this.second.getPersonalitiesOfPins())) {
                ALog.logWarn((String)"Floorplan pin personalities do not match. Cannot swap.");
                return;
            }
            for (Personality personality : personalities1) {
                if (this.first.getPersonalityCount(personality) == this.second.getPersonalityCount(personality)) continue;
                ALog.logWarn((String)"Floorplan pin personality counts do not match. Cannot swap.");
                return;
            }
            Cp.exec((String)("com.sigrity.orbit.ui.InterfaceTreeUI.swapPins(curDb(), \"" + this.first.getKeyStr() + "\", \"" + this.second.getKeyStr() + "\");"), (Object[])new Object[0]);
        }
    }

    public static class ActionMovePinOnCursor
    extends AbstractAction {
        protected Floorplan fp;

        public ActionMovePinOnCursor(Floorplan fp) {
            super("Move Pins on Cursor");
            this.fp = fp;
            if (fp.getNumFloorplanPins() == 0) {
                this.setEnabled(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DesignView2D view = (DesignView2D)OrbitIO.getCurView();
            ARect rect = view.getViewBounds();
            DevicePath devPath = this.fp.getADevicePathNear(rect.centerX(), rect.centerY());
            if (devPath != null) {
                Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.DoFloorplan.Start()", (Object[])new Object[0]);
                Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.moveFloorplanInteractively(curDb(),\"%s\", \"%s\")", (Object[])new Object[]{this.fp.getKeyStr(), devPath.toString()});
            } else {
                ALog.logWarn((String)("Floorplan '" + this.fp.getName() + "' has no pins. Select a floorplan with pins to use this command."));
            }
        }
    }

    public static class ActionEditFloorplanPin
    extends AbstractAction {
        protected boolean isRemoveMode;
        protected Floorplan fp;

        public ActionEditFloorplanPin(boolean isRemoveMode, Floorplan ... floorplans) {
            super(isRemoveMode ? "Remove Selected Pins" : "Add Selected Pins");
            if (floorplans.length == 1) {
                this.fp = floorplans[0];
            } else {
                this.setEnabled(false);
            }
            this.isRemoveMode = isRemoveMode;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Interface intf = this.fp.getMyInterface();
            Cp.exec((String)"com.sigrity.orbit.InterfaceCmds.associateSelectedPinsWithFloorplan(curDb(), \"%s\", \"%s\", %b);", (Object[])new Object[]{intf.toStringPath(), this.fp.getKeyStr(), this.isRemoveMode});
            if (InterfaceTreeUI.getTheInterfaceTreeUI() != null) {
                InterfaceTreeUI.getTheInterfaceTreeUI().rePopulateTree();
                InterfaceTreeUI.getTheInterfaceTreeUI().refreshNetTable();
            }
            OrbitApp.getApp().refreshCurrentView(false);
        }
    }

    public static class ActionEditFloorplanPinMenu
    extends AActionGroup {
        public ActionEditFloorplanPinMenu(Floorplan ... floorplans) {
            this.putValue("Name", "Edit Pins");
            ActionEditFloorplanPin addSelected = new ActionEditFloorplanPin(false, floorplans);
            ActionEditFloorplanPin removeSelected = new ActionEditFloorplanPin(true, floorplans);
            this.addActions(AUtil.arrayList((Object[])new Action[]{addSelected, removeSelected}).iterator());
        }
    }

    public static class ActionDynamicGlobMenu
    extends AActionGroup {
        protected Floorplan fp;

        public ActionDynamicGlobMenu(Floorplan fp) {
            this.putValue("Name", "Dynamic Glob");
            this.fp = fp;
            ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>();
            ActionDynamicGlob dft = new ActionDynamicGlob(fp);
            dft.putValue("Name", this.defaultBtnText());
            actions.add(dft);
            Personality dftPersonality = null;
            if (fp.getIOPersonalities().size() == 1) {
                fp.getIOPersonalities().getFirst();
            }
            DeviceTemplate dt = fp.getDeviceTemplate();
            actions.add(null);
            actions.add(new ActionCustomizeDynamicGlob(fp, null));
            Personality.getPersonalities((DeviceTemplate)dt, (Personality.Type)Personality.Type.PORT).forEach(p -> {
                if (p == dftPersonality) {
                    return;
                }
                actions.add(new ActionCustomizeDynamicGlob(fp, (Personality)p));
            });
            this.addActions(AUtil.arrayList(actions).iterator());
        }

        public String defaultBtnText() {
            StringBuilder sb = new StringBuilder("<html>");
            sb.append("Default:");
            int added = 0;
            if (this.fp.getIncludeNoneInIOPersonalityList()) {
                sb.append(" NONE");
                ++added;
            }
            for (Personality p : this.fp.getIOPersonalities()) {
                if (added > 0) {
                    sb.append(",");
                }
                ++added;
                Color c = p.getColor();
                sb.append(String.format(" <font color='%s'>&#9632;</font> %s", AColor.formatColor((Color)c), p.getName()));
            }
            return sb.toString();
        }
    }

    public static class ActionCustomizeDynamicGlob
    extends AbstractAction {
        protected Floorplan fp;
        protected Personality p;

        public ActionCustomizeDynamicGlob(Floorplan fp, Personality p) {
            super(p == null ? "NONE" : String.format("<html><font color='%s'>&#9632;</font> %s</html>", AColor.formatColor((Color)p.getColor()), p.getName()));
            this.fp = fp;
            this.p = p;
            if (InterfaceTreeUI.getTheInterfaceTreeUI() == null) {
                InterfaceTreeUI.createDialog(OrbitIO.getMainWindow(), fp.getDb());
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.p == null) {
                Cp.exec((String)"Floorplan.setIncludeNoneInIOPersonalityList(curDb(), \"%s\", %b)", (Object[])new Object[]{this.fp.getKeyStr(), true});
            } else {
                for (Personality ioPersonality : this.fp.getIOPersonalities()) {
                    Cp.exec((String)"com.sigrity.orbit.ui.PersonalityUI.removeDbObjectFromPersonality(\"Floorplan\", \"%s\", \"%s\", %b);", (Object[])new Object[]{this.fp.getKeyStr(), ioPersonality.getKeyStr(), true});
                }
                Cp.exec((String)"com.sigrity.orbit.ui.PersonalityUI.addFloorplanToPersonality(\"Floorplan\", \"%s\", \"%s\", %b);", (Object[])new Object[]{this.fp.getKeyStr(), this.p.getKeyStr(), true});
            }
            Cp.exec((String)"com.sigrity.orbit.ui.InterfaceTreeUI.startGlobber(curDb(), \"%s\", %b, true, %b);", (Object[])new Object[]{this.fp.getKeyStr(), InterfaceTreeUI.getTheInterfaceTreeUI().mAllowStealing, InterfaceTreeUI.getTheInterfaceTreeUI().mUseIOPads});
        }
    }

    public static class ActionDynamicGlob
    extends AbstractAction {
        protected Floorplan fp;

        public ActionDynamicGlob(Floorplan fp) {
            super("Dynamic Glob");
            this.fp = fp;
            if (InterfaceTreeUI.getTheInterfaceTreeUI() == null) {
                InterfaceTreeUI.createDialog(OrbitIO.getMainWindow(), fp.getDb());
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec((String)"com.sigrity.orbit.ui.InterfaceTreeUI.startGlobber(curDb(), \"%s\", %b, true, %b);", (Object[])new Object[]{this.fp.getKeyStr(), InterfaceTreeUI.getTheInterfaceTreeUI().mAllowStealing, InterfaceTreeUI.getTheInterfaceTreeUI().mUseIOPads});
        }
    }

    public static class ActionSelectFloorplanPin
    extends AbstractAction {
        protected Floorplan fp;
        protected boolean ioOnly;
        protected DevicePath limitPath;

        public ActionSelectFloorplanPin(Floorplan fp, boolean ioOnly) {
            super(ioOnly ? "Select Floorplan Pins" : "Select Descendant Floorplan Pins");
            this.fp = fp;
            this.ioOnly = ioOnly;
        }

        public ActionSelectFloorplanPin(Floorplan fp, DevicePath path, boolean ioOnly) {
            this(fp, ioOnly);
            this.limitPath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Design currentDesign = OrbitIO.getCurDesign();
            Selection s = currentDesign.getCurSelection();
            if (this.ioOnly) {
                InterfaceCmds.selectFloorplanIOPins(s, this.fp, this.limitPath);
            } else {
                InterfaceCmds.selectFloorplanPins(s, this.fp, this.limitPath);
            }
            OrbitApp.getApp().refreshCurrentView(false);
        }
    }

    public static class ActionSelectFloorplanPinMenu
    extends AActionGroup {
        public ActionSelectFloorplanPinMenu(Floorplan fp) {
            this.putValue("Name", "Select");
            ActionSelectFloorplanPin self = new ActionSelectFloorplanPin(fp, true);
            ActionSelectFloorplanPin descendant = new ActionSelectFloorplanPin(fp, false);
            self.putValue("Name", "Floorplan Pins");
            descendant.putValue("Name", "Floorplan Descendant Pins");
            this.addActions(AUtil.arrayList((Object[])new Action[]{self, descendant}).iterator());
        }

        public ActionSelectFloorplanPinMenu(Floorplan fp, IterableIterator<DevicePath> paths) {
            this.putValue("Name", "Select");
            for (DevicePath path : paths) {
                ActionSelectFloorplanPin self = new ActionSelectFloorplanPin(fp, path, true);
                ActionSelectFloorplanPin descendant = new ActionSelectFloorplanPin(fp, path, false);
                self.putValue("Name", String.format("Floorplan Pins (%s)", path.toString()));
                descendant.putValue("Name", String.format("Floorplan Descendant Pins (%s)", path.toString()));
                this.addActions(AUtil.arrayList((Object[])new Action[]{self, descendant}).iterator());
            }
        }
    }

    public static class ActionZoomToFloorplan
    extends AbstractAction {
        protected Floorplan fp;

        public ActionZoomToFloorplan(Floorplan fp) {
            super("Zoom To");
            this.fp = fp;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ACompositeGeom composite = new ACompositeGeom();
            for (DevicePath devPath : this.fp.getDeviceTemplate().getHierarchicalInstances()) {
                AGeom cur = this.fp.getHull(devPath, true);
                if (cur == null) continue;
                assert (cur instanceof ACompositeGeom) : "" + cur;
                ACompositeGeom hull = (ACompositeGeom)cur;
                for (AGeom g : hull.getChildren()) {
                    composite.addChild(g);
                }
            }
            ARect overallBounds = composite.getBounds();
            overallBounds.changeSizeBy(0.1);
            ((DesignView2D)OrbitIO.getCurView()).getCanvas().getXForm().setWorld(overallBounds);
            ((DesignView2D)OrbitIO.getCurView()).getCanvas().refresh();
        }
    }

    public static class ActionShowFloorplanPin
    extends AbstractAction {
        private Floorplan[] fps;
        private ARect showBounds;

        public ActionShowFloorplanPin(Floorplan ... floorplans) {
            super("Show Me All Pins");
            this.fps = (Floorplan[])floorplans.clone();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.showBounds = null;
            for (Floorplan fp : this.fps) {
                for (FloorplanPin fpp : fp.getPins()) {
                    for (PinInstance pinInst : AIterableItr.itr((Stream)fpp.getPinInstances())) {
                        Device device = pinInst.getDevice();
                        if (device == null) continue;
                        for (DevicePath pinDevPath : device.getHierarchicalInstances()) {
                            if (!fpp.getDevicePath().isEndOf(pinDevPath)) continue;
                            ShowMeTheWay.addHierPin(new HierPin(pinDevPath, pinInst));
                            if (this.showBounds == null) {
                                this.showBounds = pinInst.getWorldBounds(pinDevPath);
                                continue;
                            }
                            this.showBounds.expand(pinInst.getWorldBounds(pinDevPath));
                        }
                    }
                }
            }
        }

        public ARect getShowBounds() {
            return this.showBounds;
        }
    }

    public static class ActionShowZoomFloorplanPin
    extends AbstractAction {
        private Floorplan[] fps;

        public ActionShowZoomFloorplanPin(Floorplan ... floorplans) {
            super("Show Me All Pins And Zoom");
            this.fps = (Floorplan[])floorplans.clone();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ActionShowFloorplanPin v = new ActionShowFloorplanPin(this.fps);
            v.actionPerformed(null);
            ARect ans = v.getShowBounds();
            if (ans != null) {
                ans.changeSizeBy(0.1);
                ((DesignView2D)OrbitIO.getCurView()).getCanvas().getXForm().setWorld(ans);
                ((DesignView2D)OrbitIO.getCurView()).getCanvas().refresh();
            }
        }
    }

    public static class ActionShowFloorplanRats
    extends AbstractAction {
        private Floorplan[] fps;

        public ActionShowFloorplanRats(Floorplan ... floorplans) {
            super(String.format("Show Connections On (%d)", floorplans.length));
            this.fps = (Floorplan[])floorplans.clone();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)"Show Connections On Floorplan Pins");){
                Cp.exec((String)"_show = new com.sigrity.acl.edaMgrs.HConnEngine.ShowOnDevicesOrPins();", (Object[])new Object[0]);
                for (Floorplan fp : this.fps) {
                    for (FloorplanPin fpp : fp.getPins()) {
                        fpp.getPinInstances().forEach(pinInst -> Cp.exec((String)"_show.addPin(\"%s\");", (Object[])new Object[]{pinInst.getKeyStr()}));
                    }
                }
                Cp.exec((String)"_show.showOn();", (Object[])new Object[0]);
                Cp.exec((String)"unset(\"_show\");", (Object[])new Object[0]);
                OrbitIO.getApp().refreshCurrentView(false);
            }
        }
    }

    public static class ActionShowFloorplanMenu
    extends AActionGroup {
        public ActionShowFloorplanMenu(Floorplan ... floorplans) {
            this.putValue("Name", "Show");
            ActionShowFloorplanPin me = new ActionShowFloorplanPin(floorplans);
            ActionShowZoomFloorplanPin meAndZoom = new ActionShowZoomFloorplanPin(floorplans);
            ActionShowFloorplanRats rats = new ActionShowFloorplanRats(floorplans);
            me.putValue("Name", "Me All Pins");
            meAndZoom.putValue("Name", "Me All Pins and Zoom");
            rats.putValue("Name", "Connections");
            this.addActions(AUtil.arrayList((Object[])new Action[]{me, meAndZoom, rats}).iterator());
        }
    }
}

