/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.SelectionContext;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.AHistoryTextField;
import com.sigrity.acl.ui.APatternHelpButton;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.ui.FilterByPropertyNameValuePanel;
import com.sigrity.tools.dbexplorer.DBEResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GetAnObjectChooserDlg
extends DbDialog {
    protected SelectionContext mSelCtx;
    protected FilterByPropertyNameValuePanel mFilterByPropertyValuePanel = null;
    protected GetAnObjectChooserHelper mHelper = null;
    protected AHistoryTextField mPropertyValueFilter = null;
    protected JLabel mLblHelpPatternValue = null;
    protected JLabel mObjectListLabel = null;
    protected int mFilteredSize = 0;
    protected Vector<Object> mAllObjectsSelectionData = null;
    protected List<JCheckBox> mCheckboxes = null;
    protected AHistoryTextField.UpdateListener mFilterChanged = new AHistoryTextField.UpdateListener(){

        @Override
        public void update(AHistoryTextField.UpdateHint hint) {
            GetAnObjectChooserDlg.this.updateFilteredPropValueData();
        }
    };
    protected JList<Object> mListObjects = new JList<Object>(){

        @Override
        public void setModel(ListModel<Object> model) {
            super.setModel(model);
            this.setSelectionMode(2);
            this.setSelectionInterval(0, model.getSize() - 1);
        }
    };
    protected ListSelectionListener mCurrentListListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
        }
    };
    protected ListSelectionListener mListListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int numPicked = GetAnObjectChooserDlg.this.mListObjects.getSelectedValuesList().size();
            if (GetAnObjectChooserDlg.this.mFilteredSize != 0) {
                GetAnObjectChooserDlg.this.mObjectListLabel.setText(GetAnObjectChooserDlg.this.mHelper.getUserObjectName() + "s (" + GetAnObjectChooserDlg.this.mListObjects.getSelectedValuesList().size() + " / " + GetAnObjectChooserDlg.this.mAllObjectsSelectionData.size() + " picked, " + GetAnObjectChooserDlg.this.mFilteredSize + " filtered) " + numPicked + " picked");
            } else {
                GetAnObjectChooserDlg.this.mObjectListLabel.setText(GetAnObjectChooserDlg.this.mHelper.getUserObjectName() + "s (" + GetAnObjectChooserDlg.this.mListObjects.getSelectedValuesList().size() + " / " + GetAnObjectChooserDlg.this.mAllObjectsSelectionData.size() + " picked) " + numPicked + " picked");
            }
        }
    };
    protected JButton mButDone = new JButton("Ok");
    protected JButton mButCancel = new JButton("Cancel");
    protected ActionListener mCheckboxListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractButton absB = (AbstractButton)e.getSource();
            GetAnObjectChooserDlg.this.mHelper.notifyCheckboxChanged(absB.getText(), absB.getModel().isSelected());
        }
    };
    protected ListSelectionListener mListObjectListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int numPicked = GetAnObjectChooserDlg.this.mListObjects.getSelectedValuesList().size();
            GetAnObjectChooserDlg.this.mObjectListLabel.setText(GetAnObjectChooserDlg.this.mHelper.getUserObjectName() + " (" + GetAnObjectChooserDlg.this.mAllObjectsSelectionData.size() + " total) " + numPicked + " picked");
        }
    };
    protected ActionListener mCountChanged = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    };
    protected ActionListener mNameChanged = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    };
    protected ActionListener mDone = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GetAnObjectChooserDlg.this.mHelper != null) {
                Vector<Object> list = new Vector<Object>();
                for (Object obj : GetAnObjectChooserDlg.this.mListObjects.getSelectedValuesList()) {
                    list.add(obj);
                }
                GetAnObjectChooserDlg.this.mHelper.doDoneCommand(list);
            }
            UIUtil.closeWindow((Window)((Object)GetAnObjectChooserDlg.this));
        }
    };

    protected void updateAllObjects() {
        this.mAllObjectsSelectionData = new Vector();
        List<Object> list = this.mHelper.getSortedObjectList();
        for (Object s : list) {
            this.mAllObjectsSelectionData.add(s);
        }
        int numPicked = this.mListObjects.getSelectedValuesList().size();
        this.mObjectListLabel.setText(this.mHelper.getUserObjectName() + "s (" + this.mAllObjectsSelectionData.size() + ")" + numPicked + " picked");
        this.updateFilteredPropValueData();
    }

    public GetAnObjectChooserDlg(Window owner, GetAnObjectChooserHelper listener) {
        super(listener.getDb(), (Component)owner);
        this.mDb = listener.getDb();
        this.mHelper = listener;
    }

    public static GetAnObjectChooserDlg createDialog(Window owner, GetAnObjectChooserHelper listener, boolean modal) {
        GetAnObjectChooserDlg dlg = null;
        dlg = new GetAnObjectChooserDlg(owner, listener);
        dlg.init(modal);
        return dlg;
    }

    protected void init(boolean modal) {
        this.setTitle(this.mHelper.getTitle());
        this.mSelCtx = SelectionContext.create((Db)this.mDb);
        GridBagManager l = new GridBagManager(this.getContentPane());
        l.pushFillX();
        l.add("Filter:");
        this.mPropertyValueFilter = new AHistoryTextField("GUI", "Selection_PropertyValue", 12);
        l.add((Component)((Object)this.mPropertyValueFilter), (GridBagConstraints)GridBagManager.FILLX);
        this.mPropertyValueFilter.setUpdateListener(this.mFilterChanged);
        this.mPropertyValueFilter.setInvokeActionOnTextUpdate(true);
        this.mPropertyValueFilter.setToolTipText("Regular expression filter for the list of values. Leave blank to see all values.");
        this.mLblHelpPatternValue = new JLabel(DBEResources.ICON_UNKNOWN);
        APatternHelpButton help2 = new APatternHelpButton();
        l.add((Component)help2, (GridBagConstraints)GridBagManager.RIGHT);
        l.popNl();
        this.mObjectListLabel = new JLabel(this.mHelper.getUserObjectName());
        l.add((Component)this.mObjectListLabel, (GridBagConstraints)GridBagManager.LEFT);
        l.newline();
        JScrollPane scrollObjectSelections = new JScrollPane(this.mListObjects, 20, 30);
        this.mListObjects.setToolTipText("Pick the value(s) desired to add.");
        this.mListObjects.addListSelectionListener(this.mListObjectListener);
        scrollObjectSelections.setPreferredSize(new Dimension(280, 100));
        this.mListObjects.setCellRenderer(new ObjectCellRenderer());
        l.add((Component)scrollObjectSelections, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        l.newline();
        if (this.mHelper.getNumCheckboxes() > 0) {
            l.push((GridBagConstraints)GridBagManager.LEFT_REMAINX.insetHoriz(0));
            this.mCheckboxes = new LinkedList<JCheckBox>();
            for (int i = 0; i < this.mHelper.getNumCheckboxes(); ++i) {
                JCheckBox cBox = new JCheckBox(this.mHelper.getCheckboxTitle(i));
                cBox.setToolTipText(this.mHelper.getCheckboxTooltip(i));
                cBox.setSelected(this.mHelper.getDefaultCheckboxValue(i));
                cBox.addActionListener(this.mCheckboxListener);
                l.add((Component)cBox, (GridBagConstraints)GridBagManager.LEFT);
                l.newline();
            }
            l.pop();
            l.newline();
        }
        l.pushFillXRemainX();
        l.addFillX();
        l.add((Component)this.mButDone, (GridBagConstraints)GridBagManager.RIGHT);
        this.mButDone.addActionListener(this.mDone);
        l.add((Component)this.mButCancel, (GridBagConstraints)GridBagManager.RIGHT);
        this.updateAllObjects();
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        UIUtil.center((Component)((Object)this));
        UIUtil.enableDefaultBtn((JDialog)((Object)this), (JButton)this.mButDone);
        UIUtil.enableEscapeClose((Window)((Object)this), (AbstractButton)this.mButCancel);
        UIUtil.enforceDialogMinSize((Window)((Object)this));
        this.setModal(modal);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GetAnObjectChooserDlg.this.mHelper.doClosingCommand();
            }
        });
    }

    protected void updateFilteredPropValueData() {
        if (!this.mPropertyValueFilter.isEnabled()) {
            return;
        }
        Object filter = this.mPropertyValueFilter.getText();
        this.mFilteredSize = 0;
        int numPicked = this.mListObjects.getSelectedValuesList().size();
        if (((String)filter).length() == 0 || ((String)filter).equals("*")) {
            this.mListObjects.setListData(this.mAllObjectsSelectionData);
            this.mObjectListLabel.setText(this.mHelper.getUserObjectName() + " (" + this.mAllObjectsSelectionData.size() + " total) " + numPicked + " picked");
            this.mListObjects.clearSelection();
            return;
        }
        if (((String)filter).indexOf(42) == -1 && ((String)filter).indexOf(63) == -1) {
            filter = (String)filter + "*";
        }
        try {
            Pattern pattern = Pattern.compile((String)filter);
            Vector<Object> filteredData = new Vector<Object>(this.mAllObjectsSelectionData.size());
            for (int i = 0; i < this.mAllObjectsSelectionData.size(); ++i) {
                if (!pattern.matcher(this.mHelper.getObjectString(this.mAllObjectsSelectionData.get(i))).matches()) continue;
                filteredData.add(this.mAllObjectsSelectionData.get(i));
            }
            this.mListObjects.setListData(filteredData);
            this.mFilteredSize = filteredData.size();
            this.mObjectListLabel.setText(this.mHelper.getUserObjectName() + " (" + this.mFilteredSize + " total / " + this.mAllObjectsSelectionData.size() + " filtered) " + numPicked + " picked");
            this.mListObjects.clearSelection();
        }
        catch (PatternSyntaxException e) {
            this.mListObjects.setListData(this.mAllObjectsSelectionData);
            this.mObjectListLabel.setText(this.mHelper.getUserObjectName() + " (" + this.mAllObjectsSelectionData.size() + " total) " + numPicked + " picked");
            this.mListObjects.clearSelection();
            return;
        }
    }

    class ObjectCellRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        public ObjectCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                this.setText("<NONE>");
                this.setIcon(null);
            } else {
                this.setText(GetAnObjectChooserDlg.this.mHelper.getObjectString(value));
                this.setToolTipText(GetAnObjectChooserDlg.this.mHelper.getObjectTip(value));
                if (GetAnObjectChooserDlg.this.mHelper.getObjectColor(value) != null) {
                    this.setIcon((Icon)new AColorIcon(16, 16, GetAnObjectChooserDlg.this.mHelper.getObjectColor(value)));
                }
            }
            if (isSelected) {
                this.setBackground(Color.lightGray);
            } else {
                this.setBackground(Color.white);
            }
            return this;
        }
    }

    public static interface GetAnObjectChooserHelper {
        public Db getDb();

        public String getTitle();

        public String getUserObjectName();

        public String getObjectString(Object var1);

        public Color getObjectColor(Object var1);

        default public String getObjectTip(Object obj) {
            return null;
        }

        public void doDoneCommand(List<Object> var1);

        public void doClosingCommand();

        public List<Object> getSortedObjectList();

        public int getNumCheckboxes();

        public String getCheckboxTitle(int var1);

        public String getCheckboxTooltip(int var1);

        public boolean getDefaultCheckboxValue(int var1);

        public void notifyCheckboxChanged(String var1, boolean var2);
    }
}

