/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.SelectionContext;
import com.sigrity.acl.ui.AHistoryTextField;
import com.sigrity.acl.ui.APatternHelpButton;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.ui.FilterByPropertyNameValuePanel;
import com.sigrity.tools.dbexplorer.DBEResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Position;

public class GetObjectsChooserDlg
extends DbDialog {
    protected SelectionContext mSelCtx;
    protected GetObjectsChooserDlg theDialog = null;
    protected FilterByPropertyNameValuePanel mFilterByPropertyValuePanel = null;
    protected GetObjectsChooserHelper mHelper = null;
    protected JComboBox<Object> mRelatedFilterCB = null;
    protected Object relObject;
    protected AHistoryTextField mPropertyValueFilter = null;
    protected JLabel mLblHelpPatternValue = null;
    protected JLabel mObjectListLabel = null;
    protected int mFilteredSize = 0;
    protected JLabel mCurrentListLabel = null;
    protected Vector<Object> mAllPropValueSelectionData = null;
    protected Vector<Object> mCurSelectionData = null;
    List<JCheckBox> mCheckboxes = null;
    protected AHistoryTextField.UpdateListener mFilterChanged = new AHistoryTextField.UpdateListener(){

        @Override
        public void update(AHistoryTextField.UpdateHint hint) {
            GetObjectsChooserDlg.this.updateFilteredPropValueData();
        }
    };
    protected JList<Object> mListPropValueSelections = new JList<Object>(){

        @Override
        public void setModel(ListModel<Object> model) {
            super.setModel(model);
            this.setSelectionMode(2);
            this.setSelectionInterval(0, model.getSize() - 1);
        }
    };
    protected JList<Object> mListCurrentValueSelections = new JList<Object>(){

        @Override
        public void setModel(ListModel<Object> model) {
            super.setModel(model);
            this.setSelectionMode(2);
            this.setSelectionInterval(0, model.getSize() - 1);
        }
    };
    protected ListSelectionListener mCurrentListListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            GetObjectsChooserDlg.this.mCurrentListLabel.setText("Current " + GetObjectsChooserDlg.this.mHelper.getUserObjectName() + "s (" + GetObjectsChooserDlg.this.mListCurrentValueSelections.getSelectedValuesList().size() + " / " + GetObjectsChooserDlg.this.mCurSelectionData.size() + " picked)");
        }
    };
    protected ListSelectionListener mListListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (GetObjectsChooserDlg.this.mFilteredSize != 0) {
                GetObjectsChooserDlg.this.mObjectListLabel.setText(GetObjectsChooserDlg.this.mHelper.getUserObjectName() + "s (" + GetObjectsChooserDlg.this.mListPropValueSelections.getSelectedValuesList().size() + " / " + GetObjectsChooserDlg.this.mAllPropValueSelectionData.size() + " picked, " + GetObjectsChooserDlg.this.mFilteredSize + " filtered)");
            } else {
                GetObjectsChooserDlg.this.mObjectListLabel.setText(GetObjectsChooserDlg.this.mHelper.getUserObjectName() + "s (" + GetObjectsChooserDlg.this.mListPropValueSelections.getSelectedValuesList().size() + " / " + GetObjectsChooserDlg.this.mAllPropValueSelectionData.size() + " picked)");
            }
        }
    };
    protected JButton mButAdd = new JButton("Add");
    protected JButton mButRemove = new JButton("Remove");
    protected JButton mButDone = new JButton("Done");
    protected JButton mButCancel = new JButton("Cancel");
    protected ActionListener mCheckboxListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractButton absB = (AbstractButton)e.getSource();
            GetObjectsChooserDlg.this.mHelper.notifyCheckboxChanged(absB.getText(), absB.getModel().isSelected());
            GetObjectsChooserDlg.this.updateAllPropValueSelData();
        }
    };
    protected ActionListener mRelObjectActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GetObjectsChooserDlg.this.mHelper.doValidateRelObjectChange(GetObjectsChooserDlg.this.mHelper.includeRelObjectFilter() ? GetObjectsChooserDlg.this.mRelatedFilterCB.getSelectedItem() : null, GetObjectsChooserDlg.this.mCurSelectionData)) {
                GetObjectsChooserDlg.this.updateAllPropValueSelData();
                GetObjectsChooserDlg.this.mCurSelectionData.removeAllElements();
                GetObjectsChooserDlg.this.mCurrentListLabel.setText("Current " + GetObjectsChooserDlg.this.mHelper.getUserObjectName() + "s (0 / " + GetObjectsChooserDlg.this.mCurSelectionData.size() + " picked)");
                GetObjectsChooserDlg.this.mListCurrentValueSelections.setListData(GetObjectsChooserDlg.this.mCurSelectionData);
                GetObjectsChooserDlg.this.relObject = GetObjectsChooserDlg.this.mRelatedFilterCB.getSelectedItem();
            } else {
                GetObjectsChooserDlg.this.mRelatedFilterCB.setSelectedItem(GetObjectsChooserDlg.this.relObject);
            }
        }
    };
    protected ActionListener mCountChanged = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    };
    protected ActionListener mNameChanged = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    };
    protected ActionListener mDone = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GetObjectsChooserDlg.this.mHelper != null) {
                GetObjectsChooserDlg.this.mHelper.doDoneCommand(GetObjectsChooserDlg.this.mCurSelectionData, GetObjectsChooserDlg.this.mHelper.includeRelObjectFilter() ? GetObjectsChooserDlg.this.mRelatedFilterCB.getSelectedItem() : null);
            }
            GetObjectsChooserDlg.this.theDialog.dispatchEvent(new WindowEvent((Window)((Object)GetObjectsChooserDlg.this.theDialog), 201));
        }
    };
    protected ActionListener mAdd = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            for (Object object : GetObjectsChooserDlg.this.mListPropValueSelections.getSelectedValuesList()) {
                if (GetObjectsChooserDlg.this.mCurSelectionData.contains(object) || !GetObjectsChooserDlg.this.mHelper.getObjectCanBeAdded(object, GetObjectsChooserDlg.this.mRelatedFilterCB.getSelectedItem())) continue;
                GetObjectsChooserDlg.this.mCurSelectionData.add(object);
            }
            Collections.sort(GetObjectsChooserDlg.this.mCurSelectionData, GetObjectsChooserDlg.this.mHelper.getComparator());
            GetObjectsChooserDlg.this.mListCurrentValueSelections.setListData(GetObjectsChooserDlg.this.mCurSelectionData);
            GetObjectsChooserDlg.this.mCurrentListLabel.setText("Current " + GetObjectsChooserDlg.this.mHelper.getUserObjectName() + "s (0 / " + GetObjectsChooserDlg.this.mCurSelectionData.size() + " picked)");
            GetObjectsChooserDlg.this.mListCurrentValueSelections.clearSelection();
            LinkedList<Integer> indices = new LinkedList<Integer>();
            if (GetObjectsChooserDlg.this.mListCurrentValueSelections.getSelectedValuesList().size() > 0) {
                for (Object s : GetObjectsChooserDlg.this.mListPropValueSelections.getSelectedValuesList()) {
                    indices.add(GetObjectsChooserDlg.this.mListCurrentValueSelections.getNextMatch(GetObjectsChooserDlg.this.mHelper.getObjectString(s), 0, Position.Bias.Forward));
                }
            }
            if (!indices.isEmpty()) {
                boolean bl = false;
                int[] ints = new int[indices.size()];
                Iterator iterator = indices.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    ints[++var3_7] = i;
                }
                GetObjectsChooserDlg.this.mListCurrentValueSelections.setSelectedIndices(ints);
                GetObjectsChooserDlg.this.mListCurrentValueSelections.ensureIndexIsVisible((Integer)indices.get(0));
            }
            if (!GetObjectsChooserDlg.this.mHelper.includeItemsInCurSelectionInMainList()) {
                GetObjectsChooserDlg.this.updateAllPropValueSelData();
            }
        }
    };
    protected ActionListener mRemove = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            for (Object str : GetObjectsChooserDlg.this.mListCurrentValueSelections.getSelectedValuesList()) {
                if (!GetObjectsChooserDlg.this.mHelper.getObjectCanBeRemoved(str, GetObjectsChooserDlg.this.mRelatedFilterCB.getSelectedItem())) continue;
                int index = GetObjectsChooserDlg.this.mCurSelectionData.indexOf(str);
                GetObjectsChooserDlg.this.mCurSelectionData.remove(index);
            }
            GetObjectsChooserDlg.this.mListCurrentValueSelections.setListData(GetObjectsChooserDlg.this.mCurSelectionData);
            GetObjectsChooserDlg.this.mCurrentListLabel.setText("Current " + GetObjectsChooserDlg.this.mHelper.getUserObjectName() + "s (0 / " + GetObjectsChooserDlg.this.mCurSelectionData.size() + " picked)");
            GetObjectsChooserDlg.this.mListCurrentValueSelections.clearSelection();
            if (!GetObjectsChooserDlg.this.mHelper.includeItemsInCurSelectionInMainList()) {
                GetObjectsChooserDlg.this.updateAllPropValueSelData();
            }
        }
    };

    public GetObjectsChooserDlg(Window owner, GetObjectsChooserHelper listener) {
        super(listener.getDb(), (Component)owner);
        this.mDb = listener.getDb();
        this.mHelper = listener;
    }

    public static GetObjectsChooserDlg createDialog(Window owner, GetObjectsChooserHelper listener, boolean modal) {
        GetObjectsChooserDlg dlg = null;
        dlg = new GetObjectsChooserDlg(owner, listener);
        dlg.init(modal);
        return dlg;
    }

    protected void init(boolean modal) {
        this.mCurSelectionData = new Vector();
        this.setTitle(this.mHelper.getTitle());
        this.mSelCtx = SelectionContext.create((Db)this.mDb);
        GridBagManager l = new GridBagManager(this.getContentPane());
        if (this.mHelper.includeRelObjectFilter()) {
            l.push((GridBagConstraints)GridBagManager.LEFT_REMAINX.insetHoriz(0));
            l.add(this.mHelper.relObjectLabel());
            this.mRelatedFilterCB = new JComboBox<Object>(){
                private boolean layingOut = false;

                @Override
                public void doLayout() {
                    this.layingOut = true;
                    try {
                        super.doLayout();
                    }
                    finally {
                        this.layingOut = false;
                    }
                }

                @Override
                public Dimension getSize() {
                    Dimension dim = super.getSize();
                    if (!this.layingOut) {
                        dim.width = Math.max(dim.width, this.getPreferredSize().width);
                    }
                    return dim;
                }
            };
            l.add(this.mRelatedFilterCB, (GridBagConstraints)GridBagManager.FILLX);
            this.mRelatedFilterCB.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object val, int idx, boolean selected, boolean hasFocus) {
                    super.getListCellRendererComponent(list, val, idx, selected, hasFocus);
                    if (GetObjectsChooserDlg.this.mHelper.includeRelObjectNone()) {
                        this.setText(val == null ? "<NONE>" : GetObjectsChooserDlg.this.mHelper.getRelObjectToString(val));
                    } else if (val != null) {
                        this.setText(GetObjectsChooserDlg.this.mHelper.getRelObjectToString(val));
                    }
                    return this;
                }
            });
            l.popNl();
        }
        if (!this.mHelper.onlyShowList()) {
            l.pushFill();
            l.add("Filter:");
        }
        this.mPropertyValueFilter = new AHistoryTextField("GUI", "Selection_PropertyValue", 12);
        if (!this.mHelper.onlyShowList()) {
            l.add((Component)((Object)this.mPropertyValueFilter), (GridBagConstraints)GridBagManager.FILLX);
        }
        this.mPropertyValueFilter.setUpdateListener(this.mFilterChanged);
        this.mPropertyValueFilter.setInvokeActionOnTextUpdate(true);
        this.mPropertyValueFilter.setToolTipText("Regular expression filter for the list of values. Leave blank to see all values.");
        this.mLblHelpPatternValue = new JLabel(DBEResources.ICON_UNKNOWN);
        APatternHelpButton help2 = new APatternHelpButton();
        if (!this.mHelper.onlyShowList()) {
            l.add((Component)help2, (GridBagConstraints)GridBagManager.RIGHT);
            l.newline();
            l.popNl();
        }
        if (this.mHelper.getNumCheckboxes() > 0) {
            l.push((GridBagConstraints)GridBagManager.LEFT_REMAINX.insetHoriz(0));
            this.mCheckboxes = new LinkedList<JCheckBox>();
            for (int i = 0; i < this.mHelper.getNumCheckboxes(); ++i) {
                JCheckBox cBox = new JCheckBox(this.mHelper.getCheckboxTitle(i));
                cBox.setToolTipText(this.mHelper.getCheckboxTooltip(i));
                cBox.setSelected(this.mHelper.getCheckboxChecked(i));
                cBox.addActionListener(this.mCheckboxListener);
                l.add((Component)cBox, (GridBagConstraints)GridBagManager.LEFT);
                l.newline();
            }
            l.pop();
            l.newline();
        }
        this.mObjectListLabel = new JLabel(this.mHelper.getUserObjectName() + "s");
        if (this.mHelper.getDefaultCurrentList() != null) {
            this.mCurrentListLabel = new JLabel("Current " + this.mHelper.getUserObjectName() + "s (" + this.mHelper.getDefaultCurrentList().size() + ")");
        }
        l.push((GridBagConstraints)GridBagManager.FILLALL);
        l.add((Component)this.mObjectListLabel, (GridBagConstraints)GridBagManager.LEFT.insetVert(0));
        if (this.mCurrentListLabel != null) {
            l.add((Component)this.mCurrentListLabel, (GridBagConstraints)GridBagManager.LEFT);
        }
        l.newline();
        JScrollPane scrollPropValueSelections = new JScrollPane(this.mListPropValueSelections, 20, 30);
        this.mListPropValueSelections.setToolTipText("Pick the value(s) desired to add.");
        scrollPropValueSelections.setPreferredSize(new Dimension(280, 100));
        this.mListPropValueSelections.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object val, int idx, boolean selected, boolean hasFocus) {
                super.getListCellRendererComponent(list, val, idx, selected, hasFocus);
                this.setText(val == null ? "<NONE>" : GetObjectsChooserDlg.this.mHelper.getObjectString(val));
                Color color = GetObjectsChooserDlg.this.mHelper.getObjectBackground(val, selected, GetObjectsChooserDlg.this.mRelatedFilterCB.getSelectedItem(), true);
                if (color != null) {
                    this.setBackground(color);
                }
                this.setToolTipText(GetObjectsChooserDlg.this.mHelper.getCompleteListToolTipText(val, GetObjectsChooserDlg.this.mRelatedFilterCB.getSelectedItem()));
                return this;
            }
        });
        l.add((Component)scrollPropValueSelections, (GridBagConstraints)GridBagManager.FILLALL);
        JScrollPane scrollCurrentValueSelections = new JScrollPane(this.mListCurrentValueSelections, 20, 30);
        this.mListCurrentValueSelections.setToolTipText("Pick the value(s) desired to remove.");
        scrollCurrentValueSelections.setPreferredSize(new Dimension(280, 100));
        this.mListCurrentValueSelections.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object val, int idx, boolean selected, boolean hasFocus) {
                super.getListCellRendererComponent(list, val, idx, selected, hasFocus);
                this.setText(val == null ? "<NONE>" : GetObjectsChooserDlg.this.mHelper.getObjectString(val));
                Color color = GetObjectsChooserDlg.this.mHelper.getObjectBackground(val, selected, GetObjectsChooserDlg.this.mRelatedFilterCB.getSelectedItem(), false);
                if (color != null) {
                    this.setBackground(color);
                }
                this.setToolTipText(GetObjectsChooserDlg.this.mHelper.getCurrentListToolTipText(val, GetObjectsChooserDlg.this.mRelatedFilterCB.getSelectedItem()));
                return this;
            }
        });
        l.add((Component)scrollCurrentValueSelections, (GridBagConstraints)GridBagManager.FILLALL);
        l.popNl();
        l.newline();
        l.pushFill();
        l.add((Component)this.mButAdd, (GridBagConstraints)GridBagManager.RIGHT);
        this.mButAdd.addActionListener(this.mAdd);
        l.add((Component)this.mButRemove, (GridBagConstraints)GridBagManager.RIGHT);
        this.mButRemove.addActionListener(this.mRemove);
        l.add((Component)this.mButDone, (GridBagConstraints)GridBagManager.RIGHT);
        this.mButDone.addActionListener(this.mDone);
        l.add((Component)this.mButCancel, (GridBagConstraints)GridBagManager.RIGHT);
        if (this.mHelper.getDefaultCurrentList() != null) {
            this.mCurSelectionData = new Vector<Object>(this.mHelper.getDefaultCurrentList());
        }
        Collections.sort(this.mCurSelectionData, this.mHelper.getComparator());
        this.mListCurrentValueSelections.setListData(this.mCurSelectionData);
        this.initRelObjects();
        this.mRelatedFilterCB.addActionListener(this.mRelObjectActionListener);
        this.updateAllPropValueSelData();
        this.mListCurrentValueSelections.addListSelectionListener(this.mCurrentListListener);
        this.mListPropValueSelections.addListSelectionListener(this.mListListener);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        this.theDialog = this;
        UIUtil.center((Component)((Object)this));
        UIUtil.enableDefaultBtn((JDialog)((Object)this), (JButton)this.mButDone);
        UIUtil.enableEscapeClose((Window)((Object)this), (AbstractButton)this.mButCancel);
        UIUtil.enforceDialogMinSize((Window)((Object)this));
        this.setModal(modal);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GetObjectsChooserDlg.this.mHelper.doClosingCommand();
            }
        });
    }

    protected void initRelObjects() {
        if (this.mHelper.includeRelObjectNone()) {
            this.mRelatedFilterCB.addItem(null);
        }
        this.relObject = this.mHelper.getDefaultRelObject();
        LinkedList<Object> relObjs = this.mHelper.getSortedRelObjectList();
        if (relObjs == null) {
            return;
        }
        for (Object e : relObjs) {
            if (this.relObject == null) {
                this.relObject = e;
            }
            this.mRelatedFilterCB.addItem(e);
        }
        this.mRelatedFilterCB.setSelectedItem(this.relObject);
        this.mRelatedFilterCB.setPreferredSize(null);
        this.mRelatedFilterCB.setPreferredSize(this.mRelatedFilterCB.getPreferredSize());
        this.mRelatedFilterCB.setMinimumSize(this.mRelatedFilterCB.getPreferredSize());
    }

    protected void updateAllPropValueSelData() {
        this.mAllPropValueSelectionData = new Vector();
        Object obj = this.mHelper.includeRelObjectFilter() ? this.mRelatedFilterCB.getSelectedItem() : null;
        List<Object> list = this.mHelper.getPropertyValueList(obj);
        if (list != null) {
            for (Object s : list) {
                if (!this.mHelper.includeItemsInCurSelectionInMainList() && this.mCurSelectionData.contains(s)) continue;
                this.mAllPropValueSelectionData.add(s);
            }
        }
        Collections.sort(this.mAllPropValueSelectionData, this.mHelper.getComparator());
        this.mObjectListLabel.setText(this.mHelper.getUserObjectName() + "s (" + this.mAllPropValueSelectionData.size() + ")");
        this.updateFilteredPropValueData();
    }

    protected void updateFilteredPropValueData() {
        if (!this.mPropertyValueFilter.isEnabled()) {
            return;
        }
        Object filter = this.mPropertyValueFilter.getText();
        this.mFilteredSize = 0;
        if (((String)filter).length() == 0 || ((String)filter).equals("*")) {
            this.mListPropValueSelections.setListData(this.mAllPropValueSelectionData);
            this.mObjectListLabel.setText(this.mHelper.getUserObjectName() + "s (" + this.mAllPropValueSelectionData.size() + ")");
            this.mListPropValueSelections.clearSelection();
            return;
        }
        if (((String)filter).indexOf(42) == -1 && ((String)filter).indexOf(63) == -1) {
            filter = (String)filter + "*";
        }
        try {
            Pattern pattern = Pattern.compile((String)filter);
            Vector<Object> filteredData = new Vector<Object>(this.mAllPropValueSelectionData.size());
            for (int i = 0; i < this.mAllPropValueSelectionData.size(); ++i) {
                if (!pattern.matcher(this.mHelper.getObjectString(this.mAllPropValueSelectionData.get(i))).matches()) continue;
                filteredData.add(this.mAllPropValueSelectionData.get(i));
            }
            this.mListPropValueSelections.setListData(filteredData);
            this.mFilteredSize = filteredData.size();
            this.mObjectListLabel.setText(this.mHelper.getUserObjectName() + "s (" + this.mFilteredSize + " / " + this.mAllPropValueSelectionData.size() + " filtered)");
            this.mListPropValueSelections.clearSelection();
        }
        catch (PatternSyntaxException e) {
            this.mListPropValueSelections.setListData(this.mAllPropValueSelectionData);
            this.mObjectListLabel.setText(this.mHelper.getUserObjectName() + "s (" + this.mAllPropValueSelectionData.size() + ")");
            this.mListPropValueSelections.clearSelection();
            return;
        }
    }

    public static interface GetObjectsChooserHelper {
        public Db getDb();

        public String getTitle();

        public String getUserObjectName();

        public String getObjectString(Object var1);

        public Color getObjectBackground(Object var1, boolean var2, Object var3, boolean var4);

        public boolean getObjectCanBeAdded(Object var1, Object var2);

        public boolean getObjectCanBeRemoved(Object var1, Object var2);

        public void doDoneCommand(Vector<Object> var1, Object var2);

        public void doClosingCommand();

        public boolean doValidateRelObjectChange(Object var1, Vector<Object> var2);

        public List<Object> getPropertyValueList(Object var1);

        public List<Object> getDefaultCurrentList();

        public boolean includeRelObjectFilter();

        public boolean includeRelObjectNone();

        public boolean onlyShowList();

        public boolean includeItemsInCurSelectionInMainList();

        public String relObjectLabel();

        public String getRelObjectToString(Object var1);

        public Object getDefaultRelObject();

        public LinkedList<Object> getSortedRelObjectList();

        public <T> Comparator<T> getComparator();

        public String getCurrentListToolTipText(Object var1, Object var2);

        public String getCompleteListToolTipText(Object var1, Object var2);

        public int getNumCheckboxes();

        public String getCheckboxTitle(int var1);

        public String getCheckboxTooltip(int var1);

        public boolean getCheckboxChecked(int var1);

        public void notifyCheckboxChanged(String var1, boolean var2);
    }
}

