/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AColor;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.ui.ACanvasInfo;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.AbstractPin;
import com.sigrity.orbit.CandidatePairs;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.DiffPairFinder;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.HierPinHull;
import com.sigrity.orbit.HierPinT;
import com.sigrity.orbit.HierPort;
import com.sigrity.orbit.ObjectActionRegistry;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.canvas_modes.AbstractViewMode;
import com.sigrity.orbit.ui.canvas_views.DefaultViewDrawer;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public class Globber
extends AbstractViewMode {
    public static final String MODE_KEY = "GlobberMode";
    public static final String MODE_NAME = "Globber";
    static Globber mGlobber = null;
    protected GlobberHelper mGlobberHelper = null;
    protected int mNumToFind = 0;
    protected int mNumDiffPairs = 0;
    protected GlobOverlay mGlobOverlay;
    protected OptionWorkspace mOptionPanel = new OptionWorkspace();
    protected APoint2D mCursorLoc = new APoint2D();
    protected APoint2D mLastPoint = new APoint2D();
    protected APoint2D mLastLocation = new APoint2D();
    protected boolean mDrawing = false;
    protected boolean mWorking = true;
    protected boolean mButton1Commits = false;
    String mMessage = "";
    protected Color mColor = Color.cyan;
    protected Set<HierPinT> mBest = new HashSet<HierPinT>();
    protected LinkedList<HierPort> mCandidates = new LinkedList();
    protected LinkedList<HierPort> mFilteredCandidates = new LinkedList();
    protected static APair<LinkedList<CandidatePairs>, LinkedList<AbstractPin>> mLastDiffPairSolution = null;
    protected HashMap<HierPort, APoint2D> mToWorldLoc = new HashMap();
    protected static LinkedList<Action> mMenuItems = new LinkedList();
    protected static boolean inUse = false;
    protected int mCostDir = 0;
    protected static final double[] mXSquishCost = new double[]{1.0, 2.0, 4.0, 8.0, 16.0, 0.5, 0.25, 0.1, 0.0};
    protected static String[] optAlgos = DiffPairFinder.CostFunctionCatalog;
    protected int optIdx = 0;
    protected String mOptDescription = "";
    protected String mOptAlgorithm = "";
    protected HashSet<KeyStroke> mMappedKeyStrokes = new HashSet();
    protected ACanvasInfo ci = new ACanvasInfo();
    protected Action diff = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Globber.this.optIdx = (Globber.this.optIdx + 1) % optAlgos.length;
            Globber.this.setOptAlgorithm(optAlgos[Globber.this.optIdx]);
            Globber.this.showMessage();
            Globber.this.findBest(Globber.this.mCursorLoc);
            Globber.this.mGlobOverlay.repaint();
        }
    };
    protected Action changeCost = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Globber.this.mCostDir = (Globber.this.mCostDir + 1) % mXSquishCost.length;
            Globber.this.setCostDirection(Globber.this.mCostDir);
            ALog.logInfo((String)("Changing cost to " + Globber.this.mCostDir));
            Globber.this.mGlobOverlay.repaint();
        }
    };
    static boolean stopping = false;

    public Globber() {
        this.setOptAlgorithm("h");
    }

    public static Globber create() {
        if (inUse) {
            return null;
        }
        inUse = true;
        Globber.clearLastSolution();
        mGlobber = new Globber();
        return mGlobber;
    }

    public void setCandidates(Set<HierPort> candidates) {
        this.mCandidates.clear();
        this.mCandidates.addAll(candidates);
        this.mToWorldLoc.clear();
        for (HierPort hp : this.mCandidates) {
            APoint2D p = hp.getWorldLoc();
            this.mToWorldLoc.put(hp, p);
        }
        this.updateFilteredCandidates();
    }

    public void setColor(Color color) {
        this.mColor = color;
    }

    public void setColor(String colorString) {
        this.mColor = AUtil.colorFromString((String)colorString);
    }

    public void setNumToFind(int numToFind) {
        this.mNumToFind = numToFind;
    }

    public void setNumDiffPairs(int numDiffPairs) {
        this.mNumDiffPairs = numDiffPairs;
    }

    public void setMessage(String message) {
        this.mMessage = message;
    }

    public void setBeginningOptAlgo(String optAlgo) {
        this.setOptAlgorithm(optAlgo);
        this.updateOptIdx();
    }

    public APoint2D getLastPoint() {
        return this.mLastLocation;
    }

    public static APair<LinkedList<CandidatePairs>, LinkedList<AbstractPin>> getLastSolution() {
        return mLastDiffPairSolution;
    }

    public static void clearLastSolution() {
        mLastDiffPairSolution = null;
    }

    public void allowButton1ToCommmit(boolean button1Commits) {
        this.mButton1Commits = button1Commits;
    }

    protected void updateFilteredCandidates() {
        this.mFilteredCandidates.clear();
        for (HierPort hp : this.mCandidates) {
            if (!this.mGlobberHelper.portOk(hp)) continue;
            this.mFilteredCandidates.add(hp);
        }
    }

    protected void showMessage() {
        Object message = "";
        if (this.mMessage != null && this.mMessage.length() > 0) {
            message = this.mMessage + "<br>";
        }
        message = (String)message + "Optimization: " + this.mOptDescription + "<br>";
        this.ci.message(this.mCursorLoc, (String)message);
        this.showDiffPairStatus(true);
    }

    protected void showDiffPairStatus(boolean show) {
        if (show) {
            OrbitIO.getApp().getWorkspace().setStatus(this.mOptDescription);
        } else {
            OrbitIO.getApp().getWorkspace().setStatus("");
        }
    }

    public void setOptAlgorithm(String algorithm) {
        this.mOptAlgorithm = algorithm;
        this.updateOptIdx();
        this.mOptDescription = DiffPairFinder.costToFunction((String)this.mOptAlgorithm).getName();
        this.mOptionPanel.setOptAlgorithm(this.mOptAlgorithm);
    }

    public void setCostDirection(int costDir) {
        this.mCostDir = costDir;
        this.mOptionPanel.setCostDirection(this.mCostDir);
    }

    protected void updateOptIdx() {
        for (int i = 0; i < optAlgos.length; ++i) {
            if (!optAlgos[i].equals(this.mOptAlgorithm)) continue;
            this.optIdx = i;
            break;
        }
    }

    public String getOptAlgorithm() {
        return this.mOptAlgorithm;
    }

    public void glob() {
        Action cancelGlobber;
        this.mWorking = true;
        DesignView2D v2 = (DesignView2D)OrbitIO.getCurView();
        DesignCanvas2D d2d = v2.getCanvas();
        d2d.getActionMap().put("Globber Mode Action Commit", new CommitGlobAction(this));
        d2d.bindKey("Globber Mode Action Commit", true);
        d2d.getActionMap().put("Globber Mode Action Cancel", new CancelGlobAction(this));
        d2d.bindKey("Globber Mode Action Cancel", true);
        d2d.getActionMap().put("Globber Mode Action Diff", this.diff);
        d2d.bindKey("Globber Mode Action Diff", true);
        d2d.getActionMap().put("Globber Mode Action Squish", this.changeCost);
        d2d.bindKey("Globber Mode Action Squish", true);
        mMenuItems.clear();
        Action endGlobber = d2d.getActionMap().get("Globber Mode Action Commit");
        if (endGlobber != null) {
            mMenuItems.add(endGlobber);
        }
        if ((cancelGlobber = d2d.getActionMap().get("Globber Mode Action Cancel")) != null) {
            mMenuItems.add(cancelGlobber);
        }
        if (this.mGlobberHelper != null) {
            this.mGlobberHelper.registerMenuItem(this, mMenuItems);
        }
        this.mView = (DesignView2D)OrbitIO.getCurView();
        this.mView.setMode(this);
        this.ci.show(this.mView);
        if (this.mGlobOverlay != null) {
            this.mView.removeOverlay(this.mGlobOverlay);
        }
        this.mGlobOverlay = new GlobOverlay();
        this.mView.addOverlay(this.mGlobOverlay);
        this.mGlobOverlay.requestFocus();
        this.mGlobOverlay.repaint();
    }

    @Override
    public void installMode(DesignView2D view) {
        super.installMode(view);
    }

    @Override
    public void uninstallMode() {
        if (!stopping) {
            Globber.stopGlobbing(this, false, true, this.mOptAlgorithm, this.mCursorLoc);
        }
        super.uninstallMode();
        this.ci.hide();
        this.showDiffPairStatus(false);
        this.leaveMode();
    }

    public static void stopGlobbing(Globber g, boolean accept, boolean uninstallingMode, String optAlgorithm, APoint2D pt) {
        g.setOptAlgorithm(optAlgorithm);
        g.moveTo(pt);
        stopping = true;
        g.leaveMode();
        g.mGlobberHelper.onGlobbingDone(g, accept, uninstallingMode);
        stopping = false;
    }

    public static boolean startGlobberExec(int num, int numDiffPairs, String msg, String beginningOptAlgo, boolean allowButton1ToCommmit, String colorString) {
        Cp.exec((String)"unset(\"_globber\");", (Object[])new Object[0]);
        Object obj = Cp.exec((String)"_globber = Globber.create();", (Object[])new Object[0]);
        if (obj == null) {
            return false;
        }
        Cp.exec((String)("_globber.setNumToFind(" + num + ");"), (Object[])new Object[0]);
        Cp.exec((String)("_globber.setNumDiffPairs(" + numDiffPairs + ");"), (Object[])new Object[0]);
        Cp.exec((String)("_globber.setMessage(\"" + msg + "\");"), (Object[])new Object[0]);
        Cp.exec((String)("_globber.setBeginningOptAlgo(\"" + beginningOptAlgo + "\");"), (Object[])new Object[0]);
        Cp.exec((String)("_globber.allowButton1ToCommmit(" + allowButton1ToCommmit + ");"), (Object[])new Object[0]);
        Cp.exec((String)("_globber.setColor(" + colorString + ");"), (Object[])new Object[0]);
        return true;
    }

    public static Globber startGlobber(int num, int numDiffPairs, String msg, String beginningOptAlgo, boolean allowButton1ToCommmit, AColor color) {
        Globber globber = Globber.create();
        if (globber == null) {
            return null;
        }
        globber.setNumToFind(num);
        globber.setNumDiffPairs(numDiffPairs);
        globber.setMessage(msg);
        globber.setBeginningOptAlgo(beginningOptAlgo);
        globber.allowButton1ToCommmit(allowButton1ToCommmit);
        globber.setColor((Color)color);
        globber.showDiffPairStatus(true);
        return globber;
    }

    public static void stopGlobbingExec(boolean accept, boolean uninstallingMode, APoint2D worldPoint) {
        if (mGlobber != null) {
            Cp.exec((String)"com.sigrity.orbit.ui.Globber.stopGlobbing(%s, %s, \"%s\", %dL, %dL);", (Object[])new Object[]{Boolean.toString(accept), Boolean.toString(uninstallingMode), Globber.mGlobber.mOptAlgorithm, worldPoint.getX(), worldPoint.getY()});
        }
    }

    public static void stopGlobbing(boolean accept, boolean uninstallingMode, String optAlgorithm, long x, long y) {
        if (mGlobber == null) {
            ALog.logWarn((String)"Globber is not active. Cannot stop globber.");
            return;
        }
        Globber.stopGlobbing(mGlobber, accept, uninstallingMode, optAlgorithm, new APoint2D(x, y));
    }

    protected void leaveMode() {
        DesignView2D v2;
        if (this.mView != null) {
            this.mView.removeOverlay(this.mGlobOverlay);
        }
        if ((v2 = (DesignView2D)OrbitIO.getCurView()) != null) {
            DesignCanvas2D d2d = v2.getCanvas();
            d2d.getActionMap().remove("commitGlob");
            d2d.unbindKeyGlobal("E");
            d2d.getActionMap().remove("cancelGlob");
            d2d.unbindKeyGlobal("ESCAPE");
            d2d.getActionMap().remove("diff");
            d2d.unbindKeyGlobal("O");
            d2d.getActionMap().remove("squish");
            d2d.unbindKeyGlobal("S");
        }
        this.mGlobOverlay = null;
        inUse = false;
        mGlobber = null;
    }

    public Set<HierPinT> getResults() {
        return this.mBest;
    }

    public void setPortFilter(GlobberHelper portFilter) {
        this.mGlobberHelper = portFilter;
        this.updateFilteredCandidates();
    }

    public static LinkedList<Action> getMenuItems() {
        return mMenuItems;
    }

    protected void moveTo(APoint2D pt) {
        this.mCursorLoc = pt;
        if (!this.mLastPoint.equals((Object)this.mCursorLoc)) {
            this.mLastLocation = this.mCursorLoc;
            this.findBest(this.mCursorLoc);
            if (this.mGlobOverlay != null) {
                this.mGlobOverlay.repaint();
            }
        }
        this.mLastPoint.setLoc(this.mCursorLoc.getX(), this.mCursorLoc.getY());
        this.ci.hide();
    }

    @Override
    public void mouseMoved(DesignView2D.MouseAction e) {
        APoint2D worldPoint = this.mView.getCanvas().getXForm().getWorldPt(e.getPoint());
        this.moveTo(worldPoint);
    }

    @Override
    public void mouseClicked(DesignView2D.MouseAction e) {
        if (this.mButton1Commits && e.getClickCount() == 1 && e.getButton() == 1) {
            Globber.stopGlobbingExec(true, false, this.mCursorLoc);
        } else {
            super.mouseClicked(e);
        }
    }

    protected void findBest(APoint2D worldPoint) {
        ArrayList<AbstractPin> apins = new ArrayList<AbstractPin>(this.mFilteredCandidates.size());
        for (HierPort hp : this.mFilteredCandidates) {
            HierPin hierPin = new HierPin((DevicePath)hp.first, hp.getPin());
            AbstractPin ap = new AbstractPin(hierPin);
            apins.add(ap);
        }
        Collections.sort(apins, AbstractPin.CompareString);
        DiffPairFinder.DistCostFunction costFunction = DiffPairFinder.costToFunction((String)this.mOptAlgorithm);
        int numSingles = this.mNumToFind - 2 * this.mNumDiffPairs;
        mLastDiffPairSolution = DiffPairFinder.find((APoint2D)worldPoint, apins, (int)this.mNumDiffPairs, (int)numSingles, (double)mXSquishCost[this.mCostDir], (DiffPairFinder.DistCostFunction)costFunction, null);
        ArrayList<AbstractPin> bpins = new ArrayList<AbstractPin>(this.mFilteredCandidates.size());
        for (CandidatePairs cp : (LinkedList)Globber.mLastDiffPairSolution.first) {
            bpins.add((AbstractPin)cp.first);
            bpins.add((AbstractPin)cp.second);
        }
        for (AbstractPin ap : (LinkedList)Globber.mLastDiffPairSolution.second) {
            bpins.add(ap);
        }
        mLastDiffPairSolution = DiffPairFinder.find((APoint2D)worldPoint, bpins, (int)this.mNumDiffPairs, (int)numSingles, (double)mXSquishCost[this.mCostDir], (DiffPairFinder.DistCostFunction)costFunction, null);
        this.mBest.clear();
        for (CandidatePairs cp : (LinkedList)Globber.mLastDiffPairSolution.first) {
            this.mBest.add(new HierPinT((DevicePath)((AbstractPin)cp.first).pin.first, (PinInstance)((AbstractPin)cp.first).pin.second));
            this.mBest.add(new HierPinT((DevicePath)((AbstractPin)cp.second).pin.first, (PinInstance)((AbstractPin)cp.second).pin.second));
        }
        for (AbstractPin ap : (LinkedList)Globber.mLastDiffPairSolution.second) {
            this.mBest.add(new HierPinT((DevicePath)ap.pin.first, (PinInstance)ap.pin.second));
        }
    }

    public static void testMe(String path, int num) {
        DevicePath devicePath = DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)path);
        if (devicePath == null) {
            ALog.logWarn((String)(path + " Is not a valid path"));
            return;
        }
        HashSet<HierPort> candidates = new HashSet<HierPort>();
        for (DevicePath dp : devicePath.getDescendants()) {
            DeviceTemplate dt = dp.getDeviceTemplate();
            if (dt.getSubstrate() != devicePath.getSubstrate()) continue;
            for (PinTemplate pinTemplate : dt.getPins()) {
                for (PortTemplate pt : pinTemplate.getPortTemplates()) {
                    HierPort hp = new HierPort(dp, pt);
                    candidates.add(hp);
                }
            }
        }
        Globber g = Globber.create();
        if (g == null) {
            ALog.logError((String)"Globber already running");
            return;
        }
        g.allowButton1ToCommmit(true);
        g.setNumToFind(num);
        class AnyUnused
        implements GlobberHelper {
            AnyUnused() {
            }

            @Override
            public void registerMenuItem(Globber g, LinkedList<Action> menuItems) {
                DesignView2D v2 = (DesignView2D)OrbitIO.getCurView();
                class NewAction
                extends AbstractAction {
                    public NewAction() {
                        this.putValue("Name", "New Action");
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ALog.logInfo((String)"New menu item added");
                    }
                }
                v2.getCanvas().getActionMap().put("Globber Mode Action New", new NewAction());
                v2.getCanvas().bindKey("Globber Mode Action New", true);
                Action newGlobber = v2.getCanvas().getActionMap().get("Globber Mode Action New");
                if (newGlobber != null) {
                    mMenuItems.add(newGlobber);
                }
            }

            @Override
            public boolean portOk(HierPort hp) {
                return hp.getPinTemplate().getNet().isUnused();
            }

            @Override
            public void onGlobbingDone(Globber g, boolean accept, boolean uninstallingMode) {
                if (accept) {
                    Globber.globberDone(g);
                }
            }
        }
        g.setPortFilter(new AnyUnused());
        g.setCandidates(candidates);
        g.setColor(new Color(255, 0, 0, 128));
        g.glob();
    }

    public static void globberDone(Globber g) {
        OrbitIO.getApp().refreshCurrentView(false);
        Set<HierPinT> results = g.getResults();
        Design design = Design.getDesign((Db)OrbitIO.getCurDb());
        Selection s = design.getCurSelection();
        s.clear();
        for (HierPinT hp : results) {
            s.add((DevicePath)hp.first, (DbObject)hp.second);
        }
    }

    @Override
    public String getName() {
        return MODE_NAME;
    }

    @Override
    public Cursor getCursor() {
        return null;
    }

    @Override
    protected void loadContextMenu(AbstractViewMode.ContextMenu menu, Point loc) {
        for (Action menuItem : Globber.getMenuItems()) {
            JMenuItem item = ObjectActionRegistry.getJMenuItem(menuItem);
            menu.add(item);
            UIUtil.setUniqueMnemonic((JPopupMenu)menu, (AbstractButton)item);
        }
        menu.add(new JSeparator());
        super.loadContextMenu(menu, loc);
    }

    @Override
    public JPanel getOptionPanel() {
        return this.mOptionPanel;
    }

    protected class OptionWorkspace
    extends JPanel {
        JComboBox<String> mCbAlg = new JComboBox();
        JComboBox<Integer> mCbCostDir;

        public OptionWorkspace() {
            for (String opt : DiffPairFinder.CostFunctionCatalog) {
                this.mCbAlg.addItem(opt);
            }
            this.mCbAlg.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    this.setText(DiffPairFinder.costToFunction((String)((String)value)).getName());
                    return this;
                }
            });
            this.mCbAlg.addActionListener(e -> {
                String alg = (String)this.mCbAlg.getSelectedItem();
                Globber.this.setOptAlgorithm(alg);
            });
            this.mCbCostDir = new JComboBox();
            for (int i = 0; i < mXSquishCost.length; ++i) {
                this.mCbCostDir.addItem(i);
            }
            this.mCbCostDir.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    this.setText("" + mXSquishCost[(Integer)value]);
                    return this;
                }
            });
            this.mCbCostDir.addActionListener(e -> {
                Integer idx = (Integer)this.mCbCostDir.getSelectedItem();
                Globber.this.setCostDirection(idx);
            });
            GridBagManager l = new GridBagManager((Container)this);
            l.add("Algorithm:", (GridBagConstraints)GridBagManager.LEFT);
            l.add(this.mCbAlg, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            l.add("Cost Direction:");
            l.add(this.mCbCostDir, (GridBagConstraints)GridBagManager.LEFT);
            l.addFillX();
        }

        public void setCostDirection(int costDir) {
            this.mCbCostDir.setSelectedItem(costDir);
        }

        public void setOptAlgorithm(String optAlgorithm) {
            this.mCbAlg.setSelectedItem(optAlgorithm);
        }
    }

    public class GlobOverlay
    extends JComponent {
        public GlobOverlay() {
            this.setOpaque(false);
            this.setBackground(new Color(0, 0, 0, 0));
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (Globber.this.mDrawing) {
                return;
            }
            Globber.this.mDrawing = true;
            Graphics2D g = (Graphics2D)graphics;
            DesignCanvas2D.prepareGraphics(g);
            HierPinHull hph = new HierPinHull();
            for (HierPinT hp : Globber.this.mBest) {
                hph.add(hp);
            }
            g.setColor(Globber.this.mColor);
            DesignView2D v2 = Globber.this.mView;
            DesignCanvas2D.XForm xform = v2.getCanvas().getXForm();
            DefaultViewDrawer.paintGeom(g, hph.getGeom(new AffineTransform()), xform, true, true);
            if (mLastDiffPairSolution != null && !Globber.this.mOptAlgorithm.equals("x")) {
                this.drawDiffPairs(g);
            }
            Globber.this.mDrawing = false;
        }

        protected void drawDiffPairs(Graphics2D g) {
            BasicStroke stroke = new BasicStroke(10.0f, 1, 1);
            g.setStroke(stroke);
            g.setColor(Color.green);
            for (CandidatePairs cp : (LinkedList)Globber.mLastDiffPairSolution.first) {
                APoint2D pp = ((AbstractPin)cp.first).loc;
                APoint2D pn = ((AbstractPin)cp.second).loc;
                Point p1 = Globber.this.mView.getCanvas().getXForm().getScreenPt(pp);
                Point p2 = Globber.this.mView.getCanvas().getXForm().getScreenPt(pn);
                Line2D.Float line = new Line2D.Float(p1, p2);
                g.draw(line);
            }
        }
    }

    public class DistanceSorter
    implements Comparator<HierPort> {
        APoint2D p;
        Map<HierPort, APoint2D> toWorldLoc;

        public DistanceSorter(APoint2D p, Map<HierPort, APoint2D> toWorldLoc) {
            this.p = p;
            this.toWorldLoc = toWorldLoc;
        }

        @Override
        public int compare(HierPort hp0, HierPort hp1) {
            boolean enableSquish = false;
            if (enableSquish) {
                long xDist = Math.abs(this.p.xDistance(this.toWorldLoc.get(hp0)));
                long yDist = Math.abs(this.p.yDistance(this.toWorldLoc.get(hp0)));
                long dist0 = (long)((double)xDist * mXSquishCost[Globber.this.mCostDir]) + yDist;
                xDist = Math.abs(this.p.xDistance(this.toWorldLoc.get(hp1)));
                yDist = Math.abs(this.p.yDistance(this.toWorldLoc.get(hp1)));
                long dist1 = (long)((double)xDist * mXSquishCost[Globber.this.mCostDir]) + yDist;
                return Long.compare(dist0, dist1);
            }
            return Long.compare(this.toWorldLoc.get(hp0).distance(this.p), this.toWorldLoc.get(hp1).distance(this.p));
        }
    }

    public static interface GlobberHelper {
        public void registerMenuItem(Globber var1, LinkedList<Action> var2);

        public boolean portOk(HierPort var1);

        public void onGlobbingDone(Globber var1, boolean var2, boolean var3);
    }

    public class CancelGlobAction
    extends AbstractAction {
        Globber g;

        public CancelGlobAction(Globber g) {
            super("Cancel Globbing");
            this.g = g;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Globber.this.mGlobOverlay != null) {
                Globber.stopGlobbingExec(false, false, Globber.this.mCursorLoc);
            }
        }
    }

    public class CommitGlobAction
    extends AbstractAction {
        Globber g;

        public CommitGlobAction(Globber g) {
            super("Commit Glob");
            this.g = g;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Globber.this.mGlobOverlay != null) {
                Globber.stopGlobbingExec(true, false, Globber.this.mCursorLoc);
            }
        }
    }
}

