/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbFieldDef;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.NamedGrid;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.AGrid;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.APatternHelpButton;
import com.sigrity.acl.ui.ATextField;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DbObjectKeyComparator;
import com.sigrity.orbit.ui.GridListCellRenderer;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GridChooser {
    protected static int COLS_FILTER = 6;

    private GridChooser() {
    }

    public static NamedGrid getGrid(Component owner, Substrate s, Unit unit) {
        return GridChooser.getGrid(owner, s, unit, (NamedGrid)null);
    }

    public static NamedGrid getGrid(Component owner, Substrate s, Unit unit, NamedGrid initial) {
        return GridChooser.getGrid(owner, s, unit, initial, null);
    }

    public static NamedGrid getGrid(Component owner, Substrate s, Unit unit, NamedGrid initial, Collection<NamedGrid> special) {
        return GridChooser.getGrid(owner, s, unit, initial, special, null);
    }

    public static NamedGrid getGrid(Component owner, Substrate s, Unit unit, final NamedGrid initial, final Collection<NamedGrid> special, final GridFilter filter) {
        return GridChooser.getGrid(owner, s, unit, new InitHook(){

            @Override
            public void initGridChooser(GCPanel gc) {
                gc.setSpecial(special);
                gc.setInitialGrid(initial);
                gc.setGridFilter(filter);
            }
        });
    }

    public static NamedGrid getGrid(Component owner, Substrate s, Unit unit, InitHook initHook) {
        GCDialog dlg = GridChooser.createGridChooserDlg(owner, unit);
        if (initHook != null) {
            initHook.initGridChooser(dlg.mChooserPnl);
        }
        dlg.setSubstrate(s);
        dlg.setModal(true);
        dlg.setVisible(true);
        return dlg.getSelectedGrid();
    }

    public static GCDialog createGridChooserDlg(Component owner, Unit unit) {
        return new GCDialog(UIUtil.getParentWindow((Component)owner), unit);
    }

    public static void editGrids(Component owner, Substrate s) {
        Db db = s.getDb();
        Unit unit = Design.getUnit((Db)db);
        GCDialog dlg = GridChooser.createGridChooserDlg(owner, unit);
        dlg.setTitle(String.format("Edit Grids (Substrate: %s)", s.getName()));
        dlg.mBtnOk.setVisible(false);
        dlg.mBtnCancel.setText("Close");
        dlg.setSubstrate(s);
        dlg.setModal(true);
        dlg.setVisible(true);
    }

    public static class GridEditDialog
    extends ADialog {
        protected Substrate mSubstrate;
        protected Unit mUnit;
        protected NamedGrid mNamedGrid;
        protected JComboBox<String> mCboName;
        protected JTextField mTxtOX;
        protected JTextField mTxtOY;
        protected JTextField mTxtDX;
        protected JTextField mTxtDY;
        protected Validator mValidator = null;
        protected boolean mAccepted = false;
        protected ActionListener mOk = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AFieldValidator.validateSelectedItem(mCboName);
                    double ox = AFieldValidator.getValidatedDouble((JTextField)mTxtOX);
                    double oy = AFieldValidator.getValidatedDouble((JTextField)mTxtOY);
                    double dx = AFieldValidator.getValidatedDouble((JTextField)mTxtDX);
                    double dy = AFieldValidator.getValidatedDouble((JTextField)mTxtDY);
                    if (mValidator != null && !mValidator.validate(this)) {
                        return;
                    }
                    if (dx <= 0.0) {
                        throw AFieldValidator.createException((String)("" + dx), (String)"spacing (<= 0)", null, (Component)mTxtDX);
                    }
                    if (dy <= 0.0) {
                        throw AFieldValidator.createException((String)("" + dy), (String)"spacing (<= 0)", null, (Component)mTxtDY);
                    }
                    String newName = this.getNewGridName();
                    if (!mNamedGrid.getName().equals(newName)) {
                        NamedGrid existing = NamedGrid.get((Substrate)mSubstrate, (String)newName);
                        if (existing != null && existing != mNamedGrid) {
                            throw AFieldValidator.createException((String)newName, (String)"name, it is already in use", null, mCboName);
                        }
                        mNamedGrid.setName(newName);
                    }
                    AGrid grid = new AGrid(mUnit.fromUser(dx), mUnit.fromUser(dy), mUnit.fromUser(ox), mUnit.fromUser(oy));
                    if (!mNamedGrid.getGrid().equals((Object)grid)) {
                        mNamedGrid.setGrid(grid);
                    }
                }
                catch (AFieldValidator.AFieldValidationException e1) {
                    return;
                }
                mAccepted = true;
                UIUtil.closeWindow((Window)((Object)this));
            }
        };

        public GridEditDialog(Window owner, Unit unit, Substrate s, NamedGrid grid) {
            super(owner, "Edit Grid", Dialog.ModalityType.APPLICATION_MODAL);
            this.mSubstrate = s;
            this.mUnit = unit;
            this.mNamedGrid = grid;
            this.init();
        }

        public void setValidator(Validator v) {
            this.mValidator = v;
        }

        public boolean getAccepted() {
            return this.mAccepted;
        }

        protected void init() {
            GridBagManager l = new GridBagManager(this.getContentPane());
            l.add("Name:");
            this.mCboName = (JComboBox)l.add(new JComboBox());
            for (String item : NamedGrid.SystemGridNames) {
                this.mCboName.addItem(item);
            }
            this.mCboName.setEditable(true);
            l.newline();
            l.add("Origin X:");
            this.mTxtOX = (JTextField)l.add((Component)new JTextField(10), (GridBagConstraints)GridBagManager.LEFT);
            l.add("Y:");
            this.mTxtOY = (JTextField)l.add((Component)new JTextField(10), (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            l.add("Spacing X:");
            this.mTxtDX = (JTextField)l.add((Component)new JTextField(10), (GridBagConstraints)GridBagManager.LEFT);
            l.add("Y:");
            this.mTxtDY = (JTextField)l.add((Component)new JTextField(10), (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            l.addFillY();
            l.newline();
            l.pushFillXRemainX();
            l.addFillX();
            JButton btnOK = (JButton)l.add((Component)new JButton("OK"), (GridBagConstraints)GridBagManager.RIGHT);
            btnOK.addActionListener(this.mOk);
            JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"), (GridBagConstraints)GridBagManager.RIGHT);
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOK);
            this.pack();
            this.setMinimumSize(this.getPreferredSize());
            UIUtil.center((Component)((Object)this));
            this.mCboName.setSelectedItem(this.mNamedGrid.getName());
            AGrid g = this.mNamedGrid.getGrid();
            this.mTxtOX.setText(this.mUnit.toUserStr(g.getOrignX()));
            this.mTxtOY.setText(this.mUnit.toUserStr(g.getOrignY()));
            this.mTxtDX.setText("" + Math.max(this.mUnit.toUser(g.getDeltaX()), 1.0E-6));
            this.mTxtDY.setText("" + Math.max(this.mUnit.toUser(g.getDeltaY()), 1.0E-6));
        }

        protected String getNewGridName() {
            Object o = this.mCboName.getSelectedItem();
            return o == null ? "" : o.toString().trim();
        }

        public static interface Validator {
            public boolean validate(GridEditDialog var1);
        }
    }

    public static class GCDialog
    extends ADialog {
        protected Unit mUnit;
        protected GCPanel mChooserPnl;
        protected JButton mBtnOk;
        protected JButton mBtnCancel;
        protected JLabel mLblStatus;
        protected WindowListener mDialogListener = new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                this.removeWindowListener(this);
            }
        };
        protected ActionListener mOk = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (mChooserPnl.getSelectedGrid() == null) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "You must select a NamedGrid to continue.", "Select NamedGrid", 0);
                    return;
                }
                UIUtil.closeWindow((Window)((Object)this));
            }
        };

        public GCDialog(Window owner, Unit unit) throws HeadlessException {
            super(owner);
            this.mUnit = unit;
            this.init();
        }

        public void setSubstrate(Substrate s) {
            this.mChooserPnl.setSubstrate(s);
        }

        public void setInitialGrid(NamedGrid initGrid) {
            this.mChooserPnl.setInitialGrid(initGrid);
        }

        public void setSpecial(Collection<NamedGrid> special) {
            this.mChooserPnl.setSpecial(special);
        }

        public NamedGrid getSelectedGrid() {
            return this.mChooserPnl.getSelectedGrid();
        }

        protected void init() {
            this.setTitle("Select Grid");
            GridBagManager l = new GridBagManager(this.getContentPane());
            this.mChooserPnl = new GCPanel(this.mUnit, true, true){

                @Override
                protected void setStatus(String text) {
                    mLblStatus.setText(text);
                }
            };
            l.add((Component)this.mChooserPnl, (GridBagConstraints)GridBagManager.FILLALL.noInsets());
            l.newline();
            l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
            this.mLblStatus = new JLabel("");
            l.add((Component)this.mLblStatus, (GridBagConstraints)GridBagManager.FILLX);
            this.mBtnOk = new JButton("OK");
            l.add((Component)this.mBtnOk, (GridBagConstraints)GridBagManager.RIGHT);
            this.mBtnOk.addActionListener(this.mOk);
            this.mBtnCancel = new JButton("Cancel");
            l.add((Component)this.mBtnCancel, (GridBagConstraints)GridBagManager.RIGHT);
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)this.mBtnCancel, (JButton)this.mBtnOk);
            this.pack();
            UIUtil.center((Component)((Object)this));
            this.addWindowListener(this.mDialogListener);
        }
    }

    public static class GCPanel
    extends JPanel {
        protected Unit mUnit;
        protected Substrate mSubstrate = null;
        protected NamedGrid mInitialGrid = null;
        protected Collection<NamedGrid> mSpecialGrids = null;
        protected NamedGrid mSelectedGrid = null;
        protected GridFilter mGridFilter = null;
        protected JPanel mCustomTopPnl = new JPanel();
        protected APatternHelpButton mPhbHelpPattern;
        protected ATextField mTxtFilter;
        protected JList<NamedGrid> mLstGrids;
        protected JButton mLinkAdd;
        protected JButton mLinkEdit;
        protected JButton mLinkDelete;
        protected JLabel mLblStatus;
        protected Vector<NamedGrid> mAllGrids;
        protected Timer mUpdateFilteredDataTimer;
        protected ActionListener mUpdateFilteredDataTask = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.updateFilteredData();
            }
        };
        protected Runnable mDoUpdateFilteredData = new Runnable(){

            @Override
            public void run() {
                this.updateFilteredData();
            }
        };
        protected ArrayList<GridListener> mGridListeners = new ArrayList();
        protected GridEditDialog.Validator mGridExistValidator = new GridEditDialog.Validator(){

            @Override
            public boolean validate(GridEditDialog dlg) {
                if (NamedGrid.get((Substrate)mSubstrate, (String)dlg.getName()) != null) {
                    dlg.mCboName.requestFocus();
                    dlg.mCboName.getEditor().selectAll();
                    String msg = String.format("A grid named '%s' already exits on %s '%s'.", dlg.getName(), mSubstrate.getDbClass().getName(), mSubstrate.getName());
                    JOptionPane.showMessageDialog(dlg.mCboName, msg, "Invalid Data", 0);
                    return false;
                }
                return true;
            }
        };
        protected MouseListener mGridMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && this.getSelectedGrid() != null) {
                    this.fireGridActivated(this.getSelectedGrid());
                }
            }
        };
        protected ListSelectionListener mListSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                this.fireGridSelected(this.getSelectedGrid());
            }
        };
        protected KeyListener mKeyListener = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyCode() == 10 && this.getSelectedGrid() != null) {
                    this.fireGridActivated(this.getSelectedGrid());
                }
            }
        };

        public GCPanel(Unit unit, boolean edit, boolean save) {
            this.mUnit = unit;
            GridBagManager l = new GridBagManager((Container)this);
            l.add((Component)this.mCustomTopPnl, (GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
            this.mCustomTopPnl.setVisible(false);
            l.newline();
            JLabel lblFilterPattern = l.add("Filter pattern:");
            l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.FILLX.noInsets());
            this.mTxtFilter = new ATextField(COLS_FILTER);
            l.add((Component)this.mTxtFilter, (GridBagConstraints)GridBagManager.FILLX);
            lblFilterPattern.setLabelFor(this.mTxtFilter);
            this.mTxtFilter.setActionHandler(this.mDoUpdateFilteredData);
            this.mTxtFilter.setInvokeActionOnTextUpdate(true);
            this.mPhbHelpPattern = new APatternHelpButton();
            l.add((Component)this.mPhbHelpPattern, (GridBagConstraints)GridBagManager.RIGHT);
            l.pop();
            l.newline();
            this.mLstGrids = new JList();
            JScrollPane spGridList = new JScrollPane(this.mLstGrids);
            l.add((Component)spGridList, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            this.mLstGrids.setCellRenderer(new GridListCellRenderer(this.mUnit));
            l.newline();
            this.mLblStatus = new JLabel("");
            l.add((Component)this.mLblStatus, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            this.mLblStatus.setVisible(false);
            this.setSelectionMode(0);
            if (edit) {
                l.newline();
                l.pushNoFill();
                this.mLinkAdd = (JButton)l.add((Component)this.createSmallButton("Add"), (GridBagConstraints)GridBagManager.LEFT);
                this.mLinkAdd.addActionListener(e -> this.addGrid());
                this.mLinkEdit = (JButton)l.add((Component)this.createSmallButton("Edit"), (GridBagConstraints)GridBagManager.LEFT);
                this.mLinkEdit.addActionListener(e -> {
                    if (this.getSelectedGrid() != null) {
                        this.editGrid();
                    }
                });
                this.mLinkDelete = (JButton)l.add((Component)this.createSmallButton("Delete"), (GridBagConstraints)GridBagManager.LEFT);
                this.mLinkDelete.addActionListener(e -> {
                    if (this.getSelectedGrid() != null) {
                        this.deleteGrid();
                    }
                });
                l.pop();
            }
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.mLstGrids.addMouseListener(this.mGridMouseListener);
            this.mLstGrids.getSelectionModel().addListSelectionListener(this.mListSelectionListener);
            this.mLstGrids.addKeyListener(this.mKeyListener);
        }

        @Override
        public void removeNotify() {
            this.mLstGrids.removeKeyListener(this.mKeyListener);
            this.mLstGrids.getSelectionModel().removeListSelectionListener(this.mListSelectionListener);
            this.mLstGrids.removeMouseListener(this.mGridMouseListener);
            super.removeNotify();
        }

        public void setSelectionMode(int mode) {
            this.mLstGrids.setSelectionMode(mode);
        }

        public void setSubstrate(Substrate s) {
            this.mSubstrate = s;
            this.updateAllGrids();
        }

        public void setInitialGrid(NamedGrid NamedGrid2) {
            this.mInitialGrid = NamedGrid2;
        }

        public void setGridFilter(GridFilter filter) {
            this.mGridFilter = filter;
        }

        public void setSpecial(Collection<NamedGrid> l) {
            this.mSpecialGrids = l;
        }

        public void setFilter(String prop, String filter) {
            this.mTxtFilter.setText(filter);
        }

        public JPanel getCustomTopPanel() {
            return this.mCustomTopPnl;
        }

        public NamedGrid getSelectedGrid() {
            this.mSelectedGrid = this.mLstGrids.getSelectedValue();
            return this.mSelectedGrid;
        }

        protected JButton createSmallButton(String label) {
            JButton b = new JButton(label);
            Font f = b.getFont();
            b.setFont(b.getFont().deriveFont((float)f.getSize() - 2.0f));
            b.setMargin(new Insets(1, 1, 1, 1));
            return b;
        }

        public void updateAllGrids() {
            this.mAllGrids = new Vector();
            for (NamedGrid l : NamedGrid.getNamedGrids((Substrate)this.mSubstrate)) {
                if (this.mGridFilter != null && !this.mGridFilter.includeGrid(l)) continue;
                this.mAllGrids.add(l);
            }
            Collections.sort(this.mAllGrids, new DbObjectKeyComparator());
            if (this.mSpecialGrids != null) {
                int i = 0;
                for (NamedGrid g : this.mSpecialGrids) {
                    this.mAllGrids.add(i++, g);
                }
            }
            this.updateFilteredData();
            this.selectedGridChanged();
        }

        protected void updateFilteredData() {
            if (!this.mTxtFilter.isEnabled()) {
                return;
            }
            Object filter = this.mTxtFilter.getText();
            if (((String)filter).length() == 0) {
                this.mLstGrids.setListData(this.mAllGrids);
                this.setStatus("");
                return;
            }
            if (!(((String)filter).contains("\\") || ((String)filter).contains(".") || ((String)filter).contains("["))) {
                filter = (String)filter + ".*";
            }
            try {
                Pattern pattern = Pattern.compile((String)filter);
                Vector<NamedGrid> filteredData = new Vector<NamedGrid>(this.mAllGrids.size());
                DbClass dbcGrid = this.mSubstrate.getDb().getDbClass(NamedGrid.class);
                DbFieldDef fdef = dbcGrid.getField("name");
                for (NamedGrid l : this.mAllGrids) {
                    if (this.mSpecialGrids != null && this.mSpecialGrids.contains(l)) {
                        filteredData.add(l);
                        continue;
                    }
                    String val = fdef.getStringValue((DbObject)l);
                    if (val == null) {
                        val = "";
                    }
                    if (!pattern.matcher(val).matches()) continue;
                    filteredData.add(l);
                }
                this.mLstGrids.setListData(filteredData);
                this.setStatus("List filtered.");
            }
            catch (PatternSyntaxException e) {
                this.setStatus("Invalid pattern, all data displayed.");
                this.mLstGrids.setListData(this.mAllGrids);
                this.mTxtFilter.requestFocus();
                return;
            }
        }

        protected void setStatus(String text) {
            this.mLblStatus.setVisible(text != null && text.length() > 0);
            this.mLblStatus.setText(text);
        }

        public void addGridListener(GridListener g) {
            this.mGridListeners.add(g);
        }

        public void removeGridListener(GridListener g) {
            this.mGridListeners.remove(g);
        }

        protected void fireGridActivated(NamedGrid g) {
            for (GridListener l : this.mGridListeners) {
                l.GridActivated(this.getSelectedGrid());
            }
        }

        protected void fireGridSelected(NamedGrid g) {
            this.selectedGridChanged();
            for (GridListener l : this.mGridListeners) {
                l.GridSelected(this.getSelectedGrid());
            }
        }

        protected void selectedGridChanged() {
            NamedGrid g = this.getSelectedGrid();
            boolean enableEdit = g != null && g != NamedGrid.NONE;
            this.mLinkEdit.setEnabled(enableEdit);
            this.mLinkDelete.setEnabled(enableEdit);
        }

        protected void addGrid() {
            NamedGrid g = new NamedGrid(this.mSubstrate, "Manufacturing Grid", new AGrid(this.mUnit.fromUser(0.005), this.mUnit.fromUser(0.005), 0L, 0L));
            GridEditDialog dlg = new GridEditDialog(UIUtil.getParentWindow((Component)this), this.mUnit, this.mSubstrate, g);
            dlg.setVisible(true);
            dlg.setValidator(this.mGridExistValidator);
            if (!dlg.getAccepted()) {
                return;
            }
            AGrid grid = g.getGrid();
            double dx = this.mUnit.toUser(grid.getDeltaX());
            double dy = this.mUnit.toUser(grid.getDeltaY());
            double ox = this.mUnit.toUser(grid.getOrignX());
            double oy = this.mUnit.toUser(grid.getOrignY());
            Cp.exec((String)"NamedGrid.create(%s, \"%s\", %f, %f, %f, %f, %d)", (Object[])new Object[]{CpHelper.getObjCmdStr(this.mSubstrate), g.getName(), dx, dy, ox, oy, g.getMajor()});
            this.updateAllGrids();
        }

        protected void editGrid() {
            NamedGrid g = this.getSelectedGrid();
            if (g == NamedGrid.NONE) {
                return;
            }
            GridEditDialog dlg = new GridEditDialog(UIUtil.getParentWindow((Component)this), this.mUnit, this.mSubstrate, g);
            dlg.setValidator(this.mGridExistValidator);
            dlg.setVisible(true);
            if (!dlg.getAccepted()) {
                return;
            }
            this.mLstGrids.repaint();
        }

        protected void deleteGrid() {
            NamedGrid g = this.getSelectedGrid();
            if (g == NamedGrid.NONE) {
                return;
            }
            String msg = String.format("Are you sure you want to delete grid '%s'?", g.toString());
            int response = JOptionPane.showConfirmDialog(this, msg, "Confirm Delete", 0, 3);
            if (response != 0) {
                return;
            }
            Cp.exec((String)"%s.deleteFromDb()", (Object[])new Object[]{CpHelper.getObjCmdStr(g)});
            this.updateAllGrids();
        }

        public static interface GridListener {
            public void GridSelected(NamedGrid var1);

            public void GridActivated(NamedGrid var1);
        }
    }

    public static interface GridFilter {
        public boolean includeGrid(NamedGrid var1);
    }

    public static interface InitHook {
        public void initGridChooser(GCPanel var1);
    }
}

