/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.Unit;
import com.sigrity.acl.db.std.NamedGrid;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class GridListCellRenderer
extends JLabel
implements ListCellRenderer<NamedGrid> {
    protected Unit mUnit = null;

    public GridListCellRenderer(Unit unit) {
        this.mUnit = unit;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends NamedGrid> list, NamedGrid value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        if (!(value instanceof NamedGrid)) {
            this.setText(value == null ? "" : value.toString());
            return this;
        }
        this.setOpaque(true);
        NamedGrid g = value;
        this.setText(g.getDesc(this.mUnit));
        if (g.isSystemGrid()) {
            this.setFont(this.getFont().deriveFont(1));
        }
        return this;
    }
}

