/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.db.std.NamedGrid;
import com.sigrity.acl.geom.AGrid;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;

public class GridOverlay
extends JComponent {
    public static final Color GRID_COLOR = Color.GRAY.brighter();
    public static final Color GRID_COLOR_XOR = Color.BLACK;
    public static final Color GRID_COLOR_ORIGIN = GRID_COLOR.brighter();
    protected DesignView2D mView;
    protected DevicePath mDevicePath;
    protected NamedGrid mGrid;

    public GridOverlay(DesignView2D view, DevicePath path, NamedGrid grid) {
        this.mView = view;
        this.mDevicePath = path;
        this.mGrid = grid;
    }

    public void setDevicePath(DevicePath path) {
        if (this.mDevicePath != path) {
            this.mDevicePath = path;
            this.repaint();
        }
    }

    public DevicePath getDevicePath() {
        return this.mDevicePath;
    }

    public void setGrid(NamedGrid grid) {
        if (this.mGrid != grid) {
            this.mGrid = grid;
            this.repaint();
        }
    }

    public NamedGrid getGrid() {
        return this.mGrid;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (!(graphics instanceof Graphics2D)) {
            assert (false);
            return;
        }
        if (this.mGrid == null || this.mDevicePath == null || !this.mGrid.isValid()) {
            return;
        }
        Graphics2D g = (Graphics2D)graphics;
        DesignCanvas2D.XForm xform = this.mView.getCanvas().getXForm();
        AGrid screenGrid = this.mGrid.getGrid().transform(xform.getWorldToScreenTransform());
        if (screenGrid == null || screenGrid.getDeltaX() < 5L || screenGrid.getDeltaY() < 5L) {
            return;
        }
        ARect viewBounds = this.mView.getViewBounds();
        ARect deviceBounds = this.mDevicePath.getBB();
        if (!deviceBounds.intersects(viewBounds)) {
            return;
        }
        ARect bounds = viewBounds.intersection(this.mDevicePath.getBB());
        this.drawGrid(g, bounds, this.mDevicePath.getOrigin(), xform);
    }

    protected void drawGrid(Graphics2D g, ARect bounds, APoint2D origin, DesignCanvas2D.XForm xform) {
        AGrid grid = this.mGrid.getGrid();
        APoint2D ll = grid.snapToGrid(bounds.getLL());
        Color oldColor = g.getColor();
        g.setColor(GRID_COLOR);
        g.setXORMode(GRID_COLOR_XOR);
        for (long y = ll.getY(); y < bounds.top(); y += grid.getDeltaY()) {
            if (y < bounds.bottom()) continue;
            for (long x = ll.getX(); x < bounds.right(); x += grid.getDeltaX()) {
                if (x < bounds.left()) continue;
                if (x == origin.getX() && y == origin.getY()) {
                    g.setColor(GRID_COLOR_ORIGIN);
                }
                int sx = xform.getScreenX(x);
                int sy = xform.getScreenY(y);
                g.drawLine(sx, sy, sx, sy);
                if (x != origin.getX() || y != origin.getY()) continue;
                g.setColor(GRID_COLOR);
            }
        }
        g.setColor(oldColor);
        g.setPaintMode();
    }
}

