/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AColor;
import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.optimizer.genetic.GeneticFinishingFunction;
import com.sigrity.acl.optimizer.genetic.GeneticOptimizationControllerThread;
import com.sigrity.acl.optimizer.genetic.GeneticOptimizerBroker;
import com.sigrity.acl.parsers.RecDecParser;
import com.sigrity.acl.ui.AButtonGroup;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.ADocumentAdapter;
import com.sigrity.acl.ui.AFileChooserControl;
import com.sigrity.acl.ui.AMultiLineDynamicGraph;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.UserCommands;
import com.sigrity.orbit.automation.GenericConnectionOptimizer;
import com.sigrity.orbit.automation.connOpt.GeneticConnectionOptimizer;
import com.sigrity.orbit.export.BallMapOut;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import com.sigrity.orbit.ui.wb_route.EvolveConnSolutionDlg;
import com.sigrity.tools.dbexplorer.DBEResources;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.text.html.HTMLEditorKit;

public class ICNetPlannerUI {
    protected static ICNetPlannerUI theNetPlannerUI;
    protected DevicePath mDiePath;
    protected DevicePath mPackagePath;
    protected ICNetPlannerDialog mDlg;
    protected String mDesignName;
    protected Db mMyDb;

    public static Db getDB() {
        return ICNetPlannerUI.theNetPlannerUI.mMyDb;
    }

    public static void newOne() {
        theNetPlannerUI = new ICNetPlannerUI();
        theNetPlannerUI.show(null);
        theNetPlannerUI.enableTabs();
    }

    public static void show() {
        if (theNetPlannerUI == null) {
            theNetPlannerUI = new ICNetPlannerUI();
        }
        theNetPlannerUI.show(OrbitIO.getMainWindow());
        theNetPlannerUI.enableTabs();
    }

    public void show(Window owner) {
        if (ICNetPlannerUI.theNetPlannerUI.mDlg == null) {
            ICNetPlannerUI.theNetPlannerUI.mDlg = owner instanceof Dialog ? new ICNetPlannerDialog((Dialog)owner) : (owner instanceof Frame ? new ICNetPlannerDialog((Frame)owner) : new ICNetPlannerDialog());
            ICNetPlannerUI.theNetPlannerUI.mDlg.setTitle("IC Net Planner");
        }
        ICNetPlannerUI.theNetPlannerUI.mDlg.setVisible(true);
    }

    protected String getDesignName() {
        if (this.mDesignName == null) {
            this.mDesignName = Design.getDesign((Db)this.mMyDb).getUserName();
        }
        return this.mDesignName.replace(".oio", "");
    }

    protected DevicePath getDiePath() {
        return this.mDiePath;
    }

    protected DevicePath getPackagePath() {
        return this.mPackagePath;
    }

    protected void determinePaths(Db db) {
        this.mDiePath = null;
        this.mPackagePath = null;
        if (db == null) {
            return;
        }
        Design design = Design.getDesign((Db)db);
        for (DevicePath dp : design.getDescendantDevices()) {
            if (dp.getLast().getType() == DeviceTemplate.Type.PACKAGE) {
                this.mPackagePath = dp;
            }
            if (dp.getLast().getType() != DeviceTemplate.Type.DIE) continue;
            this.mDiePath = dp;
        }
        this.makeCorrectHierarchy();
        if (this.mDiePath != null && this.mPackagePath != null) {
            for (DevicePath dp : design.getDescendantDevices()) {
                if (dp.getLast().getType() == DeviceTemplate.Type.PACKAGE) {
                    this.mPackagePath = dp;
                }
                if (dp.getLast().getType() != DeviceTemplate.Type.DIE) continue;
                this.mDiePath = dp;
            }
        }
    }

    protected void makeCorrectHierarchy() {
        if (this.mDiePath != null && this.mPackagePath != null) {
            Cp.exec((String)"Device.setParent(com.sigrity.orbit.ui.ICNetPlannerUI.getDB(), \"%s\", \"%s\")", (Object[])new Object[]{this.mDiePath.getLast().getKeyStr(), this.mPackagePath.getLast().getKeyStr()});
        }
    }

    public static void mapDieToPackage(String diePathS, String packagePathS) {
        if (diePathS == null || packagePathS == null) {
            return;
        }
        if (diePathS.isEmpty() || packagePathS.isEmpty()) {
            return;
        }
        DevicePath diePath = DevicePath.fromString((Db)ICNetPlannerUI.getDB(), (String)diePathS);
        DevicePath packagePath = DevicePath.fromString((Db)ICNetPlannerUI.getDB(), (String)packagePathS);
        if (diePath == null || packagePath == null) {
            return;
        }
        for (DevicePath children : diePath.getDescendants()) {
            DevicePath stopPathA = children.pathToParent(packagePath);
            for (PinInstance portA : children.getLast().getPins()) {
                Net n = portA.getNet();
                if (n.isUnused()) continue;
                NetMap.mapThroughPath((DevicePath)stopPathA, (Net)n);
            }
        }
        UserCommands.createConnections();
    }

    protected void flattenHierarchy() {
        Cp.exec((String)"Device.setParent(OrbitIO.getCurDb(), \"%s\", \"%s\")", (Object[])new Object[]{this.mDiePath.getLast().getKeyStr(), Design.getDesign((Db)OrbitIO.getCurDb()).getKeyStr()});
    }

    protected void enableTabs() {
        Db db = this.mMyDb;
        this.mDlg.statePackageTab(false);
        this.mDlg.stateDieTab(false);
        this.mDlg.stateOutTab(false);
        this.mDlg.stateOptTab(false);
        if (db != null) {
            this.mDlg.statePackageTab(true);
            this.mDlg.stateDieTab(true);
            this.mDlg.stateOutTab(true);
            int numPackages = 0;
            int numDie = 0;
            this.determinePaths(db);
            if (this.mDiePath != null && this.mPackagePath != null) {
                Design design = Design.getDesign((Db)db);
                for (DevicePath dp : design.getDescendantDevices()) {
                    if (dp.getLast().getType() == DeviceTemplate.Type.PACKAGE) {
                        ++numPackages;
                    }
                    if (dp.getLast().getType() != DeviceTemplate.Type.DIE) continue;
                    ++numDie;
                }
            }
            if (numDie == 1 && numPackages == 1) {
                this.makeCorrectHierarchy();
                this.mDlg.stateOptTab(true);
            }
        }
    }

    protected boolean designValid() {
        return true;
    }

    protected class ICNetPlannerDialog
    extends ADialog {
        protected JTabbedPane tabPane;
        protected AdminPanel adminPanel;
        protected PackagePanel packagePanel;
        protected DiePanel diePanel;
        protected OptPanel optPanel;
        protected OutPanel outPanel;
        Db.DbListener mDbListener;

        public ICNetPlannerDialog() throws HeadlessException {
            this.tabPane = new JTabbedPane(1, 1);
            this.adminPanel = new AdminPanel();
            this.packagePanel = new PackagePanel();
            this.diePanel = new DiePanel();
            this.optPanel = new OptPanel();
            this.outPanel = new OutPanel();
            this.mDbListener = new Db.DbListenerAdapter(){

                public void dbLoaded(Db db) {
                    ICNetPlannerUI.this.mMyDb = db;
                    ICNetPlannerUI.this.enableTabs();
                }

                public void dbClosing(Db db) {
                    ICNetPlannerUI.this.mMyDb = null;
                    ICNetPlannerUI.this.enableTabs();
                }
            };
            GridBagManager l = new GridBagManager(this.getContentPane());
            Icon ICON_DIE = DBEResources.ICON_DIE;
            Icon ICON_PACKAGE = DBEResources.ICON_PACKAGE;
            Icon ICON_COG = DBEResources.ICON_COG_EDIT;
            Icon ICON_DISK = OrbitIcons.SAVE_DISK;
            this.tabPane.addTab("Admin", ICON_COG, this.adminPanel, "Create or Load previous designs");
            this.tabPane.addTab("Package", ICON_PACKAGE, this.packagePanel, "Create a package");
            this.tabPane.addTab("Die", ICON_DIE, this.diePanel, "Create a die");
            this.tabPane.addTab("Optimize", null, this.optPanel, "Optimize connections from die to Package");
            this.tabPane.addTab("Output", ICON_DISK, this.outPanel, "Generate Outputs\t");
            l.add((Component)this.tabPane, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            l.newline();
            l.pushFillX();
            l.addFillX();
            JButton btnCancel = new JButton("Cancel");
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnCancel);
            this.pack();
            UIUtil.center((Component)((Object)this));
            this.setMinimumSize(this.getPreferredSize());
            this.setDefaultCloseOperation(1);
            this.setModal(false);
        }

        public ICNetPlannerDialog(Dialog owner) throws HeadlessException {
            super(owner);
            this.tabPane = new JTabbedPane(1, 1);
            this.adminPanel = new AdminPanel();
            this.packagePanel = new PackagePanel();
            this.diePanel = new DiePanel();
            this.optPanel = new OptPanel();
            this.outPanel = new OutPanel();
            this.mDbListener = new /* invalid duplicate definition of identical inner class */;
            GridBagManager l = new GridBagManager(this.getContentPane());
            Icon ICON_DIE = DBEResources.ICON_DIE;
            Icon ICON_PACKAGE = DBEResources.ICON_PACKAGE;
            Icon ICON_COG = DBEResources.ICON_COG_EDIT;
            Icon ICON_DISK = OrbitIcons.SAVE_DISK;
            this.tabPane.addTab("Admin", ICON_COG, this.adminPanel, "Create or Load previous designs");
            this.tabPane.addTab("Package", ICON_PACKAGE, this.packagePanel, "Create a package");
            this.tabPane.addTab("Die", ICON_DIE, this.diePanel, "Create a die");
            this.tabPane.addTab("Optimize", null, this.optPanel, "Optimize connections from die to Package");
            this.tabPane.addTab("Output", ICON_DISK, this.outPanel, "Generate Outputs\t");
            l.add((Component)this.tabPane, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            l.newline();
            l.pushFillX();
            l.addFillX();
            JButton btnCancel = new JButton("Cancel");
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnCancel);
            this.pack();
            UIUtil.center((Component)((Object)this));
            this.setMinimumSize(this.getPreferredSize());
            this.setDefaultCloseOperation(1);
            this.setModal(false);
        }

        public ICNetPlannerDialog(Frame owner) throws HeadlessException {
            super(owner);
            this.tabPane = new JTabbedPane(1, 1);
            this.adminPanel = new AdminPanel();
            this.packagePanel = new PackagePanel();
            this.diePanel = new DiePanel();
            this.optPanel = new OptPanel();
            this.outPanel = new OutPanel();
            this.mDbListener = new /* invalid duplicate definition of identical inner class */;
            GridBagManager l = new GridBagManager(this.getContentPane());
            Icon ICON_DIE = DBEResources.ICON_DIE;
            Icon ICON_PACKAGE = DBEResources.ICON_PACKAGE;
            Icon ICON_COG = DBEResources.ICON_COG_EDIT;
            Icon ICON_DISK = OrbitIcons.SAVE_DISK;
            this.tabPane.addTab("Admin", ICON_COG, this.adminPanel, "Create or Load previous designs");
            this.tabPane.addTab("Package", ICON_PACKAGE, this.packagePanel, "Create a package");
            this.tabPane.addTab("Die", ICON_DIE, this.diePanel, "Create a die");
            this.tabPane.addTab("Optimize", null, this.optPanel, "Optimize connections from die to Package");
            this.tabPane.addTab("Output", ICON_DISK, this.outPanel, "Generate Outputs\t");
            l.add((Component)this.tabPane, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            l.newline();
            l.pushFillX();
            l.addFillX();
            JButton btnCancel = new JButton("Cancel");
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnCancel);
            this.pack();
            UIUtil.center((Component)((Object)this));
            this.setMinimumSize(this.getPreferredSize());
            this.setDefaultCloseOperation(1);
            this.setModal(false);
        }

        public void addNotify() {
            super.addNotify();
            Db.addDbListener((Db.DbListener)this.mDbListener);
        }

        public void removeNotify() {
            Db.removeDbListener((Db.DbListener)this.mDbListener);
            super.removeNotify();
        }

        public void statePackageTab(boolean v) {
            this.tabPane.setEnabledAt(1, v);
        }

        public void stateDieTab(boolean v) {
            this.tabPane.setEnabledAt(2, v);
        }

        public void stateOptTab(boolean v) {
            this.tabPane.setEnabledAt(3, v);
        }

        public void stateOutTab(boolean v) {
            this.tabPane.setEnabledAt(4, v);
        }
    }

    protected class OutPanel
    extends JPanel {
        protected JRadioButton outOio = new JRadioButton("Generate .oio file");
        protected JRadioButton outDef = new JRadioButton("Generate .def file");
        protected JRadioButton outAIF = new JRadioButton("Generate .aif file");
        protected JRadioButton outCSVP = new JRadioButton("Generate .csv of package");
        protected JRadioButton outHTML = new JRadioButton("Generate .html of design");
        protected JRadioButton outBallMap = new JRadioButton("Generate Ball Map of package");
        protected AFileChooserControl fcForOUT = new AFileChooserControl(false);
        protected JButton generate = new JButton("Generate Outputs");
        protected AFileChooserControl fcForOIO = new AFileChooserControl(false);
        protected ActionListener generateAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ICNetPlannerUI.this.determinePaths(ICNetPlannerUI.this.mMyDb);
                DevicePath diePath = ICNetPlannerUI.this.getDiePath();
                DevicePath packagePath = ICNetPlannerUI.this.getPackagePath();
                String filePath = OutPanel.this.fcForOUT.getPath() + File.separatorChar;
                String designName = ICNetPlannerUI.this.getDesignName();
                if (OutPanel.this.outOio.isSelected()) {
                    String fullPath = filePath + designName + ".oio";
                    OrbitIO.getOrbitIO().saveCurrentDesignAs(fullPath);
                    OrbitGuiWS gws = OrbitIO.getOrbitIO().getWorkspace();
                    gws.addMRU(new File(fullPath));
                }
                if (OutPanel.this.outDef.isSelected()) {
                    Cp.exec(() -> OrbitIO.exportDEF(filePath + designName + ".def", diePath.toString(), true, true, false), (String)"OrbitIO.exportDEF(%s, \"%s\", true, true, false)", (Object[])new Object[]{Cp.getFileAsArgument((String)(filePath + designName + ".def")), diePath.toString()});
                }
                if (OutPanel.this.outAIF.isSelected()) {
                    Cp.exec((String)"OrbitIO.exportAIF(%s, \"%s\", false, true)", (Object[])new Object[]{Cp.getFileAsArgument((String)(filePath + designName + ".aif")), packagePath.toString()});
                }
                if (OutPanel.this.outHTML.isSelected()) {
                    Cp.exec((String)"OrbitIO.getOrbitIO().exportNetMapping(%s, \"%s\", new String[] {\"%s\"}, true, true)", (Object[])new Object[]{Cp.getFileAsArgument((String)(filePath + designName + ".html")), packagePath.toString(), diePath.toString()});
                }
                if (OutPanel.this.outCSVP.isSelected()) {
                    String fileName = filePath + designName + ".csv";
                    Cp.exec((String)"com.sigrity.orbit.export.PortCSVOut.writeNow(%s, \"%s\")", (Object[])new Object[]{Cp.getFileAsArgument((String)fileName), ICNetPlannerUI.this.mPackagePath});
                }
                if (OutPanel.this.outBallMap.isSelected()) {
                    BallMapOut.write(ICNetPlannerUI.getDB(), ICNetPlannerUI.this.mPackagePath.toString(), filePath + designName + "_BM");
                }
            }
        };

        public OutPanel() {
            GridBagManager l = new GridBagManager((Container)this);
            l.add((Component)this.outOio);
            l.newline();
            l.add((Component)this.outDef);
            l.newline();
            l.add((Component)this.outAIF);
            l.newline();
            l.add((Component)this.outHTML);
            l.newline();
            l.add((Component)this.outCSVP);
            l.newline();
            l.add((Component)this.outBallMap);
            l.newline();
            l.add((Component)this.fcForOUT, (GridBagConstraints)GridBagManager.FILLX);
            this.fcForOUT.setToolTipText("");
            this.fcForOUT.setMinimumSize(this.fcForOUT.getPreferredSize());
            this.fcForOUT.setFileSelectionMode(1);
            l.newline();
            l.addFillY();
            l.add((Component)this.generate, (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
            this.generate.addActionListener(this.generateAction);
            this.fcForOUT.getTextField().getDocument().addDocumentListener(new ADocumentAdapter(){

                @Override
                public void documentChanged(DocumentEvent e) {
                    OutPanel.this.enableControls();
                }
            });
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                    OutPanel.this.enableControls();
                }
            });
        }

        protected void enableControls() {
            this.outOio.setEnabled(true);
            this.outDef.setEnabled(false);
            this.outAIF.setEnabled(false);
            this.outHTML.setEnabled(false);
            this.outCSVP.setEnabled(false);
            this.outBallMap.setEnabled(false);
            this.generate.setEnabled(false);
            if (this.fcForOUT.getPath().length() > 0) {
                this.generate.setEnabled(true);
            }
            if (ICNetPlannerUI.this.mPackagePath != null || ICNetPlannerUI.this.mDiePath != null) {
                this.outAIF.setEnabled(true);
            }
            if (ICNetPlannerUI.this.mPackagePath != null && ICNetPlannerUI.this.mDiePath != null) {
                this.outHTML.setEnabled(true);
            }
            if (ICNetPlannerUI.this.mPackagePath != null) {
                this.outCSVP.setEnabled(true);
                this.outBallMap.setEnabled(true);
            }
            if (ICNetPlannerUI.this.mDiePath != null) {
                this.outDef.setEnabled(true);
            }
        }
    }

    protected class OptPanel
    extends JPanel
    implements GeneticFinishingFunction {
        JComboBox<EvolveConnSolutionDlg.Effort> mTime = new JComboBox();
        AMultiLineDynamicGraph mGOG = new AMultiLineDynamicGraph();
        protected JButton mBtnEvolve = new JButton("Optimize");
        protected boolean mStopState = false;
        GenericConnectionOptimizer mGCO = new GenericConnectionOptimizer();
        JTextPane mTxtPaneScrollArea = new JTextPane();
        protected ActionListener mEvolveButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!OptPanel.this.mStopState) {
                    OptPanel.this.evolve();
                } else {
                    GeneticOptimizationControllerThread.stopEvolution(ICNetPlannerUI.this.mMyDb.toString());
                    OptPanel.this.mStopState = false;
                    OptPanel.this.mBtnEvolve.setText("Go");
                }
            }
        };

        public OptPanel() {
            GridBagManager l = new GridBagManager((Container)this);
            l.pushNoFill();
            JLabel label1 = new JLabel("Effort:");
            l.add((Component)label1, (GridBagConstraints)GridBagManager.LEFT);
            this.mTime.setRenderer(new EffortComboBoxRender());
            l.add(this.mTime, (GridBagConstraints)GridBagManager.LEFT);
            l.addFillX();
            l.pop();
            l.newline();
            l.pushFill();
            this.mGOG.setBorder(BorderFactory.createEmptyBorder());
            l.add((Component)this.mGOG, (GridBagConstraints)GridBagManager.FILLALL);
            HTMLEditorKit ek = new HTMLEditorKit();
            this.mTxtPaneScrollArea.setEditorKit(ek);
            this.mTxtPaneScrollArea.setEditable(false);
            this.mTxtPaneScrollArea.setOpaque(false);
            this.mTxtPaneScrollArea.setBackground(this.getBackground());
            l.newline();
            l.add((Component)this.mTxtPaneScrollArea);
            l.pop();
            l.newline();
            l.add((Component)this.mBtnEvolve, (GridBagConstraints)GridBagManager.RIGHT);
            this.mBtnEvolve.addActionListener(this.mEvolveButtonListener);
            for (int i = 0; i < EvolveConnSolutionDlg.Effort.values().length; ++i) {
                this.mTime.addItem(EvolveConnSolutionDlg.Effort.values()[i]);
            }
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                    OptPanel.this.updateCommonList();
                }
            });
        }

        public void updateCommonList() {
            this.mGCO.setup2(ICNetPlannerUI.this.getDiePath().toString(), ICNetPlannerUI.this.getPackagePath().toString(), true, true, 10L, 2);
            List<String> pNames = this.mGCO.commonPersonalities();
            Object html = "<html>";
            html = (String)html + "Personalities Being Optimized: ";
            for (String p : pNames) {
                html = (String)html + "<br>";
                Color c = this.mGCO.getCommonColor(p);
                String color = String.format("<FONT COLOR=\"%s\">", AColor.formatColor((Color)c));
                html = (String)html + color;
                html = (String)html + p;
            }
            html = (String)html + "</html>";
            this.mTxtPaneScrollArea.setText((String)html);
        }

        @Override
        public void onGeneticOptimizationFinished() {
            GeneticOptimizationControllerThread.stopEvolution(ICNetPlannerUI.this.mMyDb.toString());
            this.mStopState = false;
            this.mBtnEvolve.setText("Go");
            this.mBtnEvolve.setEnabled(true);
            OrbitIO.getOrbitIO().zoomFitCurrentView();
            GeneticConnectionOptimizer gco = GeneticConnectionOptimizer.theGCO;
            if (gco == null || gco.startScore == null || gco.endScore != null) {
                // empty if block
            }
            DbExplorerPanel.refreshAll();
        }

        protected void evolve() {
            GeneticOptimizerBroker.removeMultiLineGraph(ICNetPlannerUI.this.mMyDb.toString());
            GeneticOptimizerBroker.addMultiLineGraph(ICNetPlannerUI.this.mMyDb.toString(), this.mGOG);
            ICNetPlannerUI.this.determinePaths(ICNetPlannerUI.this.mMyDb);
            EvolveConnSolutionDlg.Effort e = (EvolveConnSolutionDlg.Effort)((Object)this.mTime.getSelectedItem());
            if (e.getTime() == 0) {
                Cp.exec((String)"com.sigrity.orbit.automation.GenericConnectionOptimizer.opt2(\"%s\", \"%s\", %b, %dL, %d)", (Object[])new Object[]{ICNetPlannerUI.this.getDiePath().toString(), ICNetPlannerUI.this.getPackagePath(), true, 0, 0});
                UserCommands.createConnections();
            } else {
                this.mStopState = true;
                this.mBtnEvolve.setEnabled(false);
                this.paintImmediately(this.getBounds());
                GeneticOptimizerBroker.addFinishingFunction(ICNetPlannerUI.this.mMyDb.toString(), this);
                Cp.exec((String)"com.sigrity.orbit.automation.GenericConnectionOptimizer.opt2(\"%s\", \"%s\", %b, %dL, %d)", (Object[])new Object[]{ICNetPlannerUI.this.getDiePath().toString(), ICNetPlannerUI.this.getPackagePath(), false, e.getTime() * 60, e.getMaxPopulation()});
            }
            OrbitIO.getOrbitIO().zoomFitCurrentView();
            DbExplorerPanel.refreshAll();
        }

        class EffortComboBoxRender
        extends DefaultListCellRenderer {
            EffortComboBoxRender() {
            }

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                    if (-1 < index) {
                        list.setToolTipText(EvolveConnSolutionDlg.Effort.values()[index].getToolTip());
                    }
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                this.setFont(list.getFont());
                this.setText(value == null ? "" : value.toString());
                return this;
            }
        }
    }

    protected class DiePanel
    extends JPanel {
        protected AFileChooserControl fcForCSV = new AFileChooserControl(false);
        protected AFileChooserControl fcForLEF = new AFileChooserControl(false);
        protected JTextField mWidth = new JTextField("0", 10);
        protected JTextField mHeight = new JTextField("0", 10);
        protected JLabel lWidth = new JLabel("Die Width (microns):");
        protected JLabel lHeight = new JLabel("Die Heigth (microns):");
        protected JButton createDie = new JButton("Create Die Bounds");
        protected JButton importLef = new JButton("Import LEF");
        protected JButton build = new JButton("Build IO Cells");
        protected JButton edit = new JButton("Edit CSV File");
        protected JProgressBar mProgressMeter;
        protected RecDecParser.LoadListener mListener;
        JTextPane mTxtPaneScrollArea = new JTextPane();
        protected ActionListener somethingchanged = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiePanel.this.enableControls();
            }
        };
        protected ActionListener editAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String csvFile = ICNetPlannerUI.this.mDiePath.getLast().getTemplate().getSourceFile();
                UIUtil.openLocalEditor((String)"EditorCSV", (String)csvFile);
            }
        };
        protected ActionListener createAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ICNetPlannerUI.this.determinePaths(ICNetPlannerUI.this.mMyDb);
                boolean thisIsAnEdit = false;
                String oldFile = null;
                if (ICNetPlannerUI.this.mDiePath != null) {
                    thisIsAnEdit = true;
                    oldFile = ICNetPlannerUI.this.mDiePath.getLast().getTemplate().getSourceFile();
                }
                Substrate oldS = null;
                if (thisIsAnEdit) {
                    oldS = ICNetPlannerUI.this.mDiePath.getSubstrate();
                    Cp.exec((String)"com.sigrity.orbit.ui.DeleteDeviceUI.deleteDevice(OrbitIO.getCurDb(), \"%s\", true, true, false)", (Object[])new Object[]{ICNetPlannerUI.this.mDiePath.getLast().getKeyStr()});
                }
                Db db = ICNetPlannerUI.this.mMyDb;
                Unit unit = Design.getUnit((Db)db);
                Cp.exec((String)"com.sigrity.orbit.factory.PartFactory.makeDevice(\"Die\", \"DIE\", %dL, %dL)", (Object[])new Object[]{unit.fromUser(Double.parseDouble(DiePanel.this.mWidth.getText())), unit.fromUser(Double.parseDouble(DiePanel.this.mHeight.getText()))});
                if (thisIsAnEdit) {
                    ICNetPlannerUI.this.determinePaths(ICNetPlannerUI.this.mMyDb);
                    Substrate newS = ICNetPlannerUI.this.mDiePath.getLast().getSubstrate();
                    Cp.exec((String)"Substrate.change (\"%s\", \"%s\", \"%s\", true)", (Object[])new Object[]{ICNetPlannerUI.this.mDiePath.getLast().getTemplate().getKeyStr(), newS.getKeyStr(), oldS.getKeyStr()});
                    if (oldFile != null && !oldFile.isEmpty()) {
                        if (new File(oldFile).exists()) {
                            DiePanel.this.buildFromPath(oldFile);
                        } else {
                            ALog.logWarn((String)("The file " + oldFile + " was referrenced, but could not be found"));
                        }
                    }
                }
                DiePanel.this.enableControls();
                ICNetPlannerUI.this.enableTabs();
                DbExplorerPanel.refreshAll();
                OrbitIO.getOrbitIO().zoomFitCurrentView();
            }
        };
        protected ActionListener importAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List paths = DiePanel.this.fcForLEF.getPaths();
                boolean firstLef = true;
                for (String path : paths) {
                    if (path.toLowerCase().indexOf(".lef", 0) <= 0) continue;
                    DiePanel.this.doLefRead(path, firstLef);
                    firstLef = false;
                }
                DbExplorerPanel.refreshAll();
                OrbitIO.getOrbitIO().zoomFitCurrentView();
                ICNetPlannerUI.this.enableTabs();
                DiePanel.this.enableControls();
            }
        };
        protected ActionListener buildAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = DiePanel.this.fcForCSV.getPath();
                File f = new File(path);
                if (f.exists()) {
                    DiePanel.this.buildFromPath(path);
                    OrbitIO.getOrbitIO().zoomFitCurrentView();
                    DbExplorerPanel.refreshAll();
                    DiePanel.this.enableControls();
                } else {
                    ALog.logWarn((String)(path + " does not exist"));
                }
            }
        };

        public DiePanel() {
            GridBagManager l = new GridBagManager((Container)this);
            l.pushFill("Define Die Size");
            l.add((Component)this.lWidth, (GridBagConstraints)GridBagManager.LEFT);
            l.add((Component)this.mWidth, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            l.add((Component)this.lHeight, (GridBagConstraints)GridBagManager.LEFT);
            l.add((Component)this.mHeight, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            l.add((Component)this.createDie, (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
            l.addFillX();
            l.pop();
            l.newline();
            l.pushFill("Import Lefs");
            l.add((Component)this.fcForLEF, (GridBagConstraints)GridBagManager.FILLX);
            this.fcForLEF.setToolTipText("");
            this.fcForLEF.setMinimumSize(this.fcForCSV.getPreferredSize());
            l.newline();
            this.mProgressMeter = new JProgressBar(0, 100);
            this.mProgressMeter.setStringPainted(true);
            l.add((Component)this.mProgressMeter, (GridBagConstraints)GridBagManager.FILLX);
            l.newline();
            l.add((Component)this.importLef, (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
            AFileFilter lefFileFilter = AFileFilter.LEF;
            this.fcForLEF.addChoosableFileFilter(lefFileFilter);
            this.fcForLEF.setMultiple(true);
            l.pop();
            l.newline();
            l.pushFill("Read IO Cells");
            l.add((Component)this.fcForCSV, (GridBagConstraints)GridBagManager.FILLX);
            this.fcForCSV.setToolTipText("");
            this.fcForCSV.setMinimumSize(this.fcForCSV.getPreferredSize());
            this.fcForCSV.addChoosableFileFilter(AFileFilter.CSV);
            l.newline();
            l.add((Component)this.edit, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            l.add((Component)this.build, (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
            l.newline();
            HTMLEditorKit ek = new HTMLEditorKit();
            this.mTxtPaneScrollArea.setEditorKit(ek);
            this.mTxtPaneScrollArea.setEditable(false);
            this.mTxtPaneScrollArea.setOpaque(false);
            this.mTxtPaneScrollArea.setBackground(this.getBackground());
            l.add((Component)this.mTxtPaneScrollArea, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            l.addFillX();
            l.pop();
            l.addFillY();
            this.createDie.addActionListener(this.createAction);
            this.importLef.addActionListener(this.importAction);
            this.edit.addActionListener(this.editAction);
            this.build.addActionListener(this.buildAction);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                    DiePanel.this.enableControls();
                }
            });
            this.mListener = new RecDecParser.LoadListener(){

                @Override
                public void stats(int percent, int kbps, boolean done, String fileName) {
                    if (done) {
                        percent = 100;
                    }
                    DiePanel.this.mProgressMeter.setValue(percent);
                    String s = percent + "% of " + fileName;
                    DiePanel.this.mProgressMeter.setString(s);
                    Dimension d = DiePanel.this.mProgressMeter.getSize();
                    DiePanel.this.mProgressMeter.paintImmediately(0, 0, d.width, d.height);
                    if (done) {
                        OrbitIO.getOrbitIO().zoomFitCurrentView();
                    }
                }
            };
            RecDecParser.addLoadListener(this.mListener);
        }

        protected void enableControls() {
            ICNetPlannerUI.this.determinePaths(ICNetPlannerUI.this.mMyDb);
            this.mProgressMeter.setString("");
            this.mProgressMeter.setValue(0);
            if (ICNetPlannerUI.this.mDiePath == null) {
                this.importLef.setEnabled(false);
                this.build.setEnabled(false);
                this.edit.setEnabled(false);
            } else {
                this.importLef.setEnabled(true);
                this.build.setEnabled(true);
                ICNetPlannerUI.this.determinePaths(ICNetPlannerUI.this.mMyDb);
                this.edit.setEnabled(false);
                if (ICNetPlannerUI.this.mDiePath != null && ICNetPlannerUI.this.mDiePath.getLast().getTemplate() != null) {
                    File f1;
                    String csvFile;
                    File f;
                    if (this.fcForCSV.getPath() != null && (f = new File(this.fcForCSV.getPath())).exists()) {
                        this.build.setEnabled(true);
                    }
                    if ((csvFile = ICNetPlannerUI.this.mDiePath.getLast().getTemplate().getSourceFile()) != null && !csvFile.isEmpty() && (f1 = new File(csvFile)).exists()) {
                        this.edit.setEnabled(true);
                        this.fcForCSV.setPath(csvFile);
                        long tFile = f1.lastModified();
                        long tTemplate = ICNetPlannerUI.this.mDiePath.getLast().getTemplate().getSourceFileModifiedTime();
                        if (tFile > tTemplate) {
                            this.fcForCSV.getTextField().setBackground(Color.pink);
                        } else {
                            this.fcForCSV.getTextField().setBackground(Color.green);
                        }
                    }
                }
                long width = ICNetPlannerUI.this.mDiePath.getLast().getTemplate().getBounds(true).getBounds().width();
                long height = ICNetPlannerUI.this.mDiePath.getLast().getTemplate().getBounds(true).getBounds().height();
                Db db = ICNetPlannerUI.this.mMyDb;
                Unit unit = Design.getUnit((Db)db);
                Double dwidth = unit.toUser(width);
                Double dheight = unit.toUser(height);
                this.mWidth.setText(dwidth.toString());
                this.mHeight.setText(dheight.toString());
                this.mTxtPaneScrollArea.setText(this.getPadLimitedSize(ICNetPlannerUI.this.mDiePath.toString()));
            }
        }

        protected void buildFromPath(String filePath) {
            ICNetPlannerUI.this.determinePaths(ICNetPlannerUI.this.mMyDb);
            String dieName = ICNetPlannerUI.this.getDiePath().toString();
            Cp.exec((String)"com.sigrity.orbit.ui.DeviceTemplateUI.deleteIODevices(\"%s\", false)", (Object[])new Object[]{dieName});
            Cp.exec((String)"OrbitIO.importDieSpreadsheet(\"%s\", \"%s\")", (Object[])new Object[]{filePath, dieName});
            this.enableControls();
        }

        protected void doLefRead(String path, boolean first) {
            ICNetPlannerUI.this.determinePaths(ICNetPlannerUI.this.mMyDb);
            DevicePath dp = ICNetPlannerUI.this.getDiePath();
            if (dp == null) {
                return;
            }
            String sName = dp.getLast().getSubstrate().getName();
            Cp.exec((String)"com.sigrity.acl.parsers.LEFDEFParser ldp = new com.sigrity.acl.parsers.LEFDEFParser(curDb())", (Object[])new Object[0]);
            Cp.exec((String)("ldp.setSubstrateName ( \"" + sName + "\")"), (Object[])new Object[0]);
            boolean readBlocks = true;
            boolean readCores = true;
            boolean readCovers = true;
            boolean readEndCaps = true;
            boolean readRings = true;
            int verbosity = 1;
            boolean createSubstrate = false;
            Cp.exec((String)"ldp.parseLef(\"%s\", %b, %b, %b, %b, %b, %d, %b)", (Object[])new Object[]{path, readBlocks, readCores, readCovers, readEndCaps, readRings, verbosity, createSubstrate});
            Cp.exec((String)"String lastSub = ldp.getSubstrateName()", (Object[])new Object[0]);
        }

        public String getPadLimitedSize(String dPath) {
            DevicePath dp = DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)dPath);
            if (dp == null) {
                return "";
            }
            long topWidth = 0L;
            long botWidth = 0L;
            long leftHeight = 0L;
            long rightHeight = 0L;
            Db db = ICNetPlannerUI.this.mMyDb;
            Unit unit = Design.getUnit((Db)db);
            ArrayList<DevicePath> tops = new ArrayList<DevicePath>();
            ArrayList<DevicePath> bots = new ArrayList<DevicePath>();
            ArrayList<DevicePath> lefts = new ArrayList<DevicePath>();
            ArrayList<DevicePath> rights = new ArrayList<DevicePath>();
            for (DevicePath child : dp.getDescendants()) {
                if (child.getLast().hasChildren()) continue;
                Device d = child.getLast();
                String side = (String)d.getValue("side");
                if (side.equals("top")) {
                    topWidth += child.getBB().width();
                    topWidth += d.getGapInset().getX();
                    tops.add(child);
                }
                if (side.equals("bottom")) {
                    botWidth += child.getBB().width();
                    botWidth += d.getGapInset().getX();
                    bots.add(child);
                }
                if (side.equals("left")) {
                    leftHeight += child.getBB().height();
                    leftHeight += d.getGapInset().getX();
                    lefts.add(child);
                }
                if (!side.equals("right")) continue;
                rightHeight += child.getBB().height();
                rightHeight += d.getGapInset().getX();
                rights.add(child);
            }
            Collections.sort(bots, new DevicePath.DevicePathSortH());
            Collections.sort(tops, new DevicePath.DevicePathSortH());
            Collections.sort(lefts, new DevicePath.DevicePathSortV());
            Collections.sort(rights, new DevicePath.DevicePathSortV());
            if (bots.size() > 0) {
                rightHeight += ((DevicePath)bots.get(bots.size() - 1)).getBB().height();
                leftHeight += ((DevicePath)bots.get(0)).getBB().height();
            }
            if (rights.size() > 0) {
                topWidth += ((DevicePath)rights.get(rights.size() - 1)).getBB().height();
            }
            if (tops.size() > 0) {
                leftHeight += ((DevicePath)tops.get(0)).getBB().height();
                rightHeight += ((DevicePath)tops.get(tops.size() - 1)).getBB().height();
            }
            if (lefts.size() > 0) {
                // empty if block
            }
            String ret = String.format("<html>Minimum pad limited die size is (%s x %s)</html>", unit.toUserStr(Math.max(topWidth, botWidth)), unit.toUserStr(Math.max(leftHeight, rightHeight)));
            return ret;
        }
    }

    protected class PackagePanel
    extends JPanel {
        protected ButtonGroup fileTypeGroup = new AButtonGroup();
        protected JRadioButton aifRead;
        protected JRadioButton csvRead;
        protected JRadioButton paraCreate;
        protected JRadioButton updRead;
        protected JButton create = new JButton("Create");
        protected AFileChooserControl fcForCSV = new AFileChooserControl(false);
        protected AFileChooserControl fcForAIF = new AFileChooserControl(false);
        protected AFileChooserControl fcForUPD = new AFileChooserControl(false);
        protected JTextField mDiameter = new JTextField("0", 8);
        protected JLabel lDiameter = new JLabel("Pin Diameter (microns):");
        protected JTextField mPDiameter = new JTextField("0", 8);
        protected JButton edit = new JButton("Edit CSV File");
        protected JLabel lPDiameter = new JLabel("Pin Diameter (microns):");
        protected JLabel lPitch = new JLabel("Pin Pitch (microns):");
        protected JTextField mPitch = new JTextField("0", 8);
        protected JLabel lWidth = new JLabel("Width (microns):");
        protected JTextField mWidth = new JTextField("0", 8);
        protected JLabel lHeight = new JLabel("Height (microns):");
        protected JTextField mHeight = new JTextField("0", 8);
        protected JLabel lRings = new JLabel("Rings:");
        protected JTextField mRings = new JTextField("0", 8);
        protected JLabel lCenter = new JLabel("Center Matrix");
        protected JTextField mCenter = new JTextField("0", 8);
        Timer mPulseTimer;
        protected ActionListener somethingchanged = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PackagePanel.this.enableControls();
            }
        };
        protected ActionListener editAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String csvFile = ICNetPlannerUI.this.mPackagePath.getLast().getTemplate().getSourceFile();
                UIUtil.openLocalEditor((String)"EditorCSV", (String)csvFile);
            }
        };
        protected ActionListener createIt = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PackagePanel.this.removeCurrentPackage();
                Db db = ICNetPlannerUI.this.mMyDb;
                Unit unit = Design.getUnit((Db)db);
                if (PackagePanel.this.paraCreate.isSelected()) {
                    try {
                        int centerRows;
                        boolean byNumber = false;
                        long pinds = unit.fromUser(Double.parseDouble(PackagePanel.this.mPitch.getText()));
                        long w = unit.fromUser(Double.parseDouble(PackagePanel.this.mWidth.getText()));
                        long h = unit.fromUser(Double.parseDouble(PackagePanel.this.mHeight.getText()));
                        long pinsize = unit.fromUser(Double.parseDouble(PackagePanel.this.mPDiameter.getText())) / 2L;
                        int centerCols = centerRows = Integer.parseInt(PackagePanel.this.mCenter.getText());
                        int rows = 1;
                        int cols = 1;
                        int rings = Integer.parseInt(PackagePanel.this.mRings.getText());
                        Cp.exec((String)"com.sigrity.orbit.factory.PartFactory.makePackage(\"%s\", \"%s\", %b, %dL, %dL, %d, %d, %d, %d, %d, %dL, %dL, %dL, com.sigrity.acl.geom.AGeom.CompassCorners.NW, %s)", (Object[])new Object[]{"Package", "Package", byNumber, w, h, rows, cols, rings, centerRows, centerCols, pinsize, pinds, pinds, "null"});
                    }
                    catch (NumberFormatException err) {
                        ALog.logError((Throwable)err, (String)"Invalid string: %s", (Object[])new Object[]{err.getMessage()});
                    }
                }
                if (PackagePanel.this.aifRead.isSelected()) {
                    Cp.exec((String)"OrbitIO.importAIF(%s, true)", (Object[])new Object[]{Cp.getFileAsArgument((String)PackagePanel.this.fcForAIF.getPath())});
                }
                if (PackagePanel.this.csvRead.isSelected()) {
                    Cp.exec((String)"com.sigrity.orbit.factory.PartFactory.makeDevice(\"Package\", \"PACKAGE\", %s, %f, \"\", \"\", \"CIRCLE\")", (Object[])new Object[]{Cp.getFileAsArgument((String)PackagePanel.this.fcForCSV.getPath()), Double.parseDouble(PackagePanel.this.mDiameter.getText())});
                }
                ICNetPlannerUI.this.determinePaths(ICNetPlannerUI.getDB());
                if (ICNetPlannerUI.this.mDiePath != null && ICNetPlannerUI.this.mPackagePath != null) {
                    Cp.exec((String)"com.sigrity.orbit.ui.ICNetPlannerUI.mapDieToPackage (\"%s\", \"%s\")", (Object[])new Object[]{ICNetPlannerUI.this.mDiePath.toString(), ICNetPlannerUI.this.mPackagePath.toString()});
                }
                PackagePanel.this.enableControls();
                ICNetPlannerUI.this.enableTabs();
                DbExplorerPanel.refreshAll();
                OrbitIO.getOrbitIO().zoomFitCurrentView();
            }
        };

        public PackagePanel() {
            GridBagManager l = new GridBagManager((Container)this);
            GridBagManager.GridBagConstraintsEx rbc = GridBagManager.LEFT.insets(GridBagManager.LEFT.insets.left, 0);
            JPanel pnl = l.pushRemainX("Create Parametrically");
            this.paraCreate = new JRadioButton("Parametrically");
            this.paraCreate.setToolTipText("Define the package by paramters");
            l.add((Component)this.paraCreate);
            l.newline();
            l.add((Component)this.lWidth, (GridBagConstraints)rbc);
            l.add((Component)this.mWidth, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            l.add((Component)this.lHeight, (GridBagConstraints)rbc);
            l.add((Component)this.mHeight, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            l.add((Component)this.lPDiameter, (GridBagConstraints)rbc);
            l.add((Component)this.mPDiameter, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            l.add((Component)this.lPitch, (GridBagConstraints)rbc);
            l.add((Component)this.mPitch, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            l.newline();
            l.add((Component)this.lRings, (GridBagConstraints)rbc);
            l.add((Component)this.mRings, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            l.add((Component)this.lCenter, (GridBagConstraints)rbc);
            l.add((Component)this.mCenter, (GridBagConstraints)GridBagManager.LEFT);
            pnl.setMinimumSize(pnl.getPreferredSize());
            l.pop();
            l.newline();
            l.pushFill("Create by CSV");
            this.csvRead = new JRadioButton("CSV");
            this.csvRead.setToolTipText("Define the package by a comma separated value spreadsheet");
            l.add((Component)this.csvRead, (GridBagConstraints)rbc);
            l.add((Component)this.fcForCSV, (GridBagConstraints)GridBagManager.FILLX);
            this.fcForCSV.setToolTipText("");
            this.fcForCSV.setMinimumSize(this.fcForCSV.getPreferredSize());
            l.newline();
            l.add((Component)this.lDiameter, (GridBagConstraints)rbc);
            l.add((Component)this.mDiameter, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            l.add((Component)this.edit, (GridBagConstraints)GridBagManager.LEFT);
            l.pop();
            l.newline();
            l.pushFill("Create by AIF");
            this.aifRead = new JRadioButton("AIF");
            this.aifRead.setToolTipText("Define the package by a standard .aif format");
            l.add((Component)this.aifRead, (GridBagConstraints)rbc);
            l.add((Component)this.fcForAIF, (GridBagConstraints)GridBagManager.FILLX);
            this.fcForAIF.setToolTipText("");
            this.fcForAIF.setMinimumSize(this.fcForAIF.getPreferredSize());
            l.pop();
            l.newline();
            l.newline();
            l.addFillY();
            l.add((Component)this.create, (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
            this.create.addActionListener(this.createIt);
            this.fileTypeGroup.add(this.aifRead);
            this.fileTypeGroup.add(this.csvRead);
            this.fileTypeGroup.add(this.updRead);
            this.fileTypeGroup.add(this.paraCreate);
            this.aifRead.addActionListener(this.somethingchanged);
            this.csvRead.addActionListener(this.somethingchanged);
            this.paraCreate.addActionListener(this.somethingchanged);
            this.mDiameter.addActionListener(this.somethingchanged);
            this.edit.addActionListener(this.editAction);
            AFileFilter csvFF = new AFileFilter("csv", "CSV Format");
            csvFF.addExtension("lef");
            csvFF.setDescription("CSV Format");
            this.fcForCSV.addChoosableFileFilter(csvFF);
            this.fcForCSV.setMultiple(false);
            AFileFilter aifFF = new AFileFilter("aif", "AIF Format");
            aifFF.setDescription("aif Format");
            this.fcForAIF.addChoosableFileFilter(aifFF);
            this.fcForAIF.setMultiple(false);
            AFileFilter updFF = new AFileFilter("upd", "UPD Format");
            updFF.setDescription("upd Format");
            this.fcForUPD.addChoosableFileFilter(updFF);
            this.fcForUPD.setMultiple(false);
            this.paraCreate.setSelected(true);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                    PackagePanel.this.enableControls();
                }
            });
        }

        protected void enableControls() {
            File f;
            String csvFile;
            this.fcForAIF.setEnabled(this.aifRead.isSelected());
            this.fcForCSV.setEnabled(this.csvRead.isSelected());
            this.mDiameter.setEnabled(this.csvRead.isSelected());
            this.lDiameter.setEnabled(this.csvRead.isSelected());
            this.lPDiameter.setEnabled(this.paraCreate.isSelected());
            this.mPDiameter.setEnabled(this.paraCreate.isSelected());
            this.lPitch.setEnabled(this.paraCreate.isSelected());
            this.mPitch.setEnabled(this.paraCreate.isSelected());
            this.lWidth.setEnabled(this.paraCreate.isSelected());
            this.mWidth.setEnabled(this.paraCreate.isSelected());
            this.lHeight.setEnabled(this.paraCreate.isSelected());
            this.mHeight.setEnabled(this.paraCreate.isSelected());
            this.lRings.setEnabled(this.paraCreate.isSelected());
            this.mRings.setEnabled(this.paraCreate.isSelected());
            this.lCenter.setEnabled(this.paraCreate.isSelected());
            this.mCenter.setEnabled(this.paraCreate.isSelected());
            boolean okToCreate = false;
            if (this.csvRead.isSelected()) {
                this.create.setText("Create by CSV");
                okToCreate = this.mDiameter.getText().length() > 0;
                okToCreate = true;
                this.edit.setEnabled(false);
            }
            if (this.paraCreate.isSelected()) {
                this.create.setText("Create Parametrically");
                okToCreate = this.mWidth.getText().length() > 0;
                okToCreate &= this.mHeight.getText().length() > 0;
                okToCreate = true;
            }
            if (this.aifRead.isSelected()) {
                this.create.setText("Create by AIF");
                okToCreate = true;
            }
            ICNetPlannerUI.this.determinePaths(ICNetPlannerUI.this.mMyDb);
            this.edit.setEnabled(false);
            if (ICNetPlannerUI.this.mPackagePath != null && ICNetPlannerUI.this.mPackagePath.getLast().getTemplate() != null && (csvFile = ICNetPlannerUI.this.mPackagePath.getLast().getTemplate().getSourceFile()) != null && !csvFile.isEmpty() && (f = new File(csvFile)).exists()) {
                this.edit.setEnabled(true);
                this.fcForCSV.setPath(csvFile);
                long tFile = f.lastModified();
                long tTemplate = ICNetPlannerUI.this.mPackagePath.getLast().getTemplate().getSourceFileModifiedTime();
                if (tFile > tTemplate) {
                    this.fcForCSV.getTextField().setBackground(Color.pink);
                } else {
                    this.fcForCSV.getTextField().setBackground(Color.green);
                }
            }
            this.create.setEnabled(okToCreate);
        }

        protected void removeCurrentPackage() {
            ICNetPlannerUI.this.determinePaths(ICNetPlannerUI.this.mMyDb);
            if (ICNetPlannerUI.this.mPackagePath != null) {
                if (ICNetPlannerUI.this.mDiePath != null) {
                    ICNetPlannerUI.this.flattenHierarchy();
                }
                Cp.exec((String)"com.sigrity.orbit.ui.DeleteDeviceUI.deleteDevice(OrbitIO.getCurDb(), \"%s\", true, true, true)", (Object[])new Object[]{ICNetPlannerUI.this.mPackagePath.getLast().getKeyStr()});
            }
        }
    }

    protected class AdminPanel
    extends JPanel {
        protected ButtonGroup howToMakeMe = new AButtonGroup();
        protected JRadioButton createIt;
        protected JRadioButton readIt;
        protected JTextField mDesignField = new JTextField("MyDesign", 10);
        protected JLabel lDesignField = new JLabel("Design Name:");
        protected JButton create = new JButton("Start");
        protected AFileChooserControl fcForOIO = new AFileChooserControl(false);
        protected ActionListener somethingchanged = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdminPanel.this.enableControls();
            }
        };
        protected ActionListener createAction = e -> {
            if (this.createIt.isSelected()) {
                Cp.exec((String)"OrbitIO.getOrbitIO().createDesign(\"%s\")", (Object[])new Object[]{this.mDesignField.getText()});
                ICNetPlannerUI.this.mMyDb = OrbitIO.getCurDb();
                DbExplorerPanel.refreshAll();
            } else {
                Cp.exec((String)"OrbitIO.getOrbitIO().openDesign(%s)", (Object[])new Object[]{Cp.getFileAsArgument((String)this.fcForOIO.getPath())});
                DbExplorerPanel.refreshAll();
            }
            ICNetPlannerUI.this.enableTabs();
        };

        public AdminPanel() {
            GridBagManager l = new GridBagManager((Container)this);
            GridBagManager.GridBagConstraintsEx rbc = GridBagManager.LEFT.insets(GridBagManager.LEFT.insets.left, 0);
            l.pushNoFill();
            this.createIt = new JRadioButton("I would like to create a new design named:");
            this.createIt.setToolTipText("A new design will be created");
            l.add((Component)this.createIt, (GridBagConstraints)GridBagManager.LEFT);
            l.add((Component)this.mDesignField, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            l.pop();
            l.newline();
            this.readIt = new JRadioButton("I would like to start with a previous design");
            this.readIt.setToolTipText("");
            l.add((Component)this.readIt, (GridBagConstraints)rbc);
            l.newline();
            l.add((Component)this.fcForOIO, (GridBagConstraints)GridBagManager.FILLX);
            this.fcForOIO.setToolTipText("Load a previously created OrbitIO design (one die and one package only please)");
            this.fcForOIO.setMinimumSize(this.fcForOIO.getPreferredSize());
            l.newline();
            l.newline();
            l.newline();
            l.addFillY();
            l.add((Component)this.create, (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
            this.create.addActionListener(this.createAction);
            this.fcForOIO.addChoosableFileFilter(OrbitIO.OIO_FILE_FILTER);
            this.fcForOIO.setMultiple(false);
            this.fcForOIO.getTextField().addActionListener(this.somethingchanged);
            this.fcForOIO.getTextField().getDocument().addDocumentListener(new ADocumentAdapter(){

                @Override
                public void documentChanged(DocumentEvent e) {
                    AdminPanel.this.enableControls();
                }
            });
            this.howToMakeMe.add(this.createIt);
            this.howToMakeMe.add(this.readIt);
            this.createIt.setSelected(true);
            this.createIt.addActionListener(this.somethingchanged);
            this.readIt.addActionListener(this.somethingchanged);
            this.enableControls();
        }

        protected void enableControls() {
            this.fcForOIO.setEnabled(this.readIt.isSelected());
            boolean okToStart = false;
            if (this.createIt.isSelected() && this.mDesignField.getText().length() > 0) {
                okToStart = true;
                this.create.setText("Create Design");
            }
            if (this.readIt.isSelected() && this.fcForOIO.getPath().length() > 0) {
                okToStart = true;
                this.create.setText("Read Design");
            }
            this.create.setEnabled(okToStart);
        }
    }
}

