/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.ui.AComboBox;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.orbit.CCTFile.CCTFile;
import com.sigrity.orbit.OrbitIO;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class ImportCCTUI {
    public static boolean showMe(String devicePathString) {
        AFileChooser fc = new AFileChooser();
        ImportCCTOptionsPanel options = new ImportCCTOptionsPanel(fc);
        fc.setAccessory((JComponent)options);
        if (fc.showOpenDialog((Component)OrbitIO.getMainWindow()) != 0) {
            return false;
        }
        String fileType = "DesignFile";
        String ext = ".dsn";
        if (fc.getFileFilter().getDescription().contains("Route")) {
            fileType = "RouteFile";
            ext = ".rte";
        } else if (fc.getFileFilter().getDescription().contains("Wire")) {
            fileType = "WireFile";
            ext = ".wir";
        }
        File f = fc.getSelectedFile();
        Object path = f.getPath();
        if (!f.getName().contains(".")) {
            path = (String)path + ext;
        }
        Cp.exec((String)"OrbitIO.importCCTFile(%s, \"%s\", \"%s\")", (Object[])new Object[]{Cp.getFileAsArgument((String)path), devicePathString, fileType});
        return true;
    }

    private static class ImportCCTOptionsPanel
    extends JPanel {
        AComboBox<String> mFileType;
        AFileChooser mFc;
        AFileFilter mFilter = new AFileFilter("rte", "Route Files");

        public ImportCCTOptionsPanel(AFileChooser fc) {
            this.mFc = fc;
            this.setBorder(BorderFactory.createTitledBorder("Import options"));
            GridBagManager l = new GridBagManager((Container)this);
            JLabel la = new JLabel("File Type:");
            l.add((Component)la, (GridBagConstraints)GridBagManager.LEFT);
            this.mFileType = new AComboBox();
            l.add(this.mFileType, (GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
            l.newline();
            int n = CCTFile.FileType.values().length;
            CCTFile.FileType[] s = CCTFile.FileType.values();
            for (int i = 1; i < n; ++i) {
                this.mFileType.addItem((Object)s[i].name());
            }
            this.mFileType.addActionListener((ActionListener)new FileTypeSelect());
            this.mFileType.setSelectedItem((Object)CCTFile.FileType.RouteFile);
            this.mFc.setFileFilter((FileFilter)this.mFilter);
            l.newline();
            l.addFillY();
        }

        @Override
        public void addNotify() {
            super.addNotify();
        }

        protected class FileTypeSelect
        implements ActionListener {
            protected FileTypeSelect() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportCCTOptionsPanel.this.mFilter = ImportCCTOptionsPanel.this.mFileType.getSelectedItem().equals("DesignFile") ? new AFileFilter("dsn", "Design Files") : (ImportCCTOptionsPanel.this.mFileType.getSelectedItem().equals("WireFile") ? new AFileFilter("wir", "Wire Files") : new AFileFilter("rte", "Route Files"));
                ImportCCTOptionsPanel.this.mFc.setFileFilter((FileFilter)ImportCCTOptionsPanel.this.mFilter);
            }
        }
    }
}

