/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ACsvReader;
import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.pinMap.PinMapGenerator;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.filechooser.FileFilter;

public class ImportContactLayerDlg {
    protected static final String[] CONTACT_CONFIGURATION_FILE_HEADER = new String[]{"DevicePath A", "Contact Layer A", "DevicePath B", "Contact Layer B"};

    public static Action getAction() {
        return new AbstractAction("Import Contact Layer"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportContactLayerDlg.showUI();
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitIO.getCurDb() != null;
            }
        };
    }

    public static void showUI() {
        AFileChooser fc = new AFileChooser();
        fc.addChoosableFileFilter((FileFilter)AFileFilter.CSV);
        fc.setFileFilter((FileFilter)AFileFilter.CSV);
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(false);
        fc.setDialogTitle("Import CSV Contact Layer");
        if (fc.showOpenDialog((Component)OrbitIO.getMainWindow()) != 0) {
            return;
        }
        File fRuleFile = fc.getSelectedFile();
        if (fRuleFile == null) {
            return;
        }
        Cp.exec((String)"com.sigrity.orbit.ui.ImportContactLayerDlg.importContactLayer(%s);", (Object[])new Object[]{Cp.getFileAsArgument((File)fRuleFile)});
    }

    public static void importContactLayer(String filePath) {
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            ALog.logWarn((String)"Open an orbit design before runing this command.");
            return;
        }
        try (ACsvReader csvReader = ACsvReader.open((String)filePath);){
            csvReader.setSkipToHeader(true);
            if (!csvReader.validateHeader(CONTACT_CONFIGURATION_FILE_HEADER)) {
                ALog.logError((String)"Unexpected header in input file %s.", (Object[])new Object[]{filePath});
                ALog.logError((String)"Header should be %s", (Object[])new Object[]{Arrays.toString(CONTACT_CONFIGURATION_FILE_HEADER)});
                return;
            }
            csvReader.getRows().stream().filter(row -> !row[0].startsWith("#") && row[0] != null).forEach(row -> {
                ContactLayer contactLayer = ContactLayer.create((Db)db, (String)row[0], (String)row[1], (String)row[2], (String)row[3]);
                if (contactLayer != null) {
                    ALog.logInfo((String)"Set contact layer %s", (Object[])new Object[]{contactLayer.toString()});
                    PinMapGenerator.createPinMapFromPhysicalContact(db, contactLayer);
                }
            });
        }
    }

    private ImportContactLayerDlg() {
    }
}

