/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.google.common.io.Files;
import com.sigrity.acl.ABrowserControl;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.ADocumentAdapter;
import com.sigrity.acl.ui.AFileChooserControl;
import com.sigrity.acl.ui.AHtmlPane;
import com.sigrity.acl.ui.AListConnectionManager;
import com.sigrity.acl.ui.AListConnectionOverlay;
import com.sigrity.acl.ui.AListModel;
import com.sigrity.acl.ui.ATitledBorder;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.ui.atree.ALazyTreeNode;
import com.sigrity.acl.ui.atree.ATreeCellRenderer;
import com.sigrity.acl.ui.atree.ATreeModel;
import com.sigrity.acl.ui.atree.ATreeNode;
import com.sigrity.acl.xml.AXSaxUtil;
import com.sigrity.orbit.OrbitDbReader;
import com.sigrity.orbit.OrbitDbReaderFiltered;
import com.sigrity.orbit.OrbitDbReaderImport;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.xml.sax.Attributes;

public class ImportDbUI
extends ADialog {
    protected static ImportDbUI mCurImportDbUI = null;
    protected boolean mImported = false;
    protected AFileChooserControl mFileChooser;
    protected boolean mIsPathValid = false;
    protected JCheckBox mCbImportAll;
    protected JPanel mPnlImportSel;
    protected ATreeModel mTreeModel = null;
    protected JTree mTreeDesignHierarchy;
    protected JTextField mTxtStatus;
    protected JButton mBtnOk;

    public static boolean importDb(Window owner) {
        ImportDbUI ui = new ImportDbUI(owner);
        ui.setVisible(true);
        return ui.mImported;
    }

    public static boolean importDb(String path, String className, String key) {
        return ImportDbUI.importDb(path, className, key, false);
    }

    public static boolean importDb(String path, String className, String key, boolean quiet) {
        Db db = OrbitIO.getCurDb();
        File file = new File(path);
        if (!file.canRead()) {
            ALog.logError((String)"Unable to read '%s'.", (Object[])new Object[]{path});
            return false;
        }
        OrbitDbReaderImport dbr = new OrbitDbReaderImport(db);
        if (className == null || key == null) {
            if (!quiet) {
                ALog.logInfo((String)"Importing '%s'.", (Object[])new Object[]{path});
            }
        } else {
            DbClass dbClass = db.getDbClass(className);
            if (dbClass == null) {
                if (!quiet) {
                    ALog.logError((String)"Invalid database class '%s' specified.", (Object[])new Object[]{className});
                }
                return false;
            }
            if (!dbr.setImport(dbClass, key)) {
                if (!quiet) {
                    ALog.logError((String)"Unable to import specified item: %s '%s'.", (Object[])new Object[]{className, key});
                }
                return false;
            }
        }
        if (!dbr.read(path)) {
            ALog.logError((String)"Import failed.");
            return false;
        }
        if (!quiet) {
            ALog.logInfo((String)"Import complete.");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean importOIO(File file, OrbitDbReader.Scope scope, String scopeStr) {
        Object[] opts;
        String msg;
        Window uiOwner = OrbitIO.getMainWindow();
        String[] AllOpts = new String[]{"Current Design", "New Design", "Cancel"};
        Object[] OnlyNewOpts = new String[]{AllOpts[1], AllOpts[2]};
        Object details = "";
        for (String key : scope.getProps().keySet()) {
            if (((String)details).length() > 0) {
                details = (String)details + "\n";
            }
            details = (String)details + String.format("    %s: %s", key, scope.getProps().get(key));
        }
        details = ((String)details).length() == 0 ? ". " : String.format(":\n\n%s\n\n", details);
        ImportVersionCheck versionCheck = ImportVersionCheck.create(uiOwner, file);
        if (!versionCheck.getOK()) {
            return false;
        }
        if (OrbitIO.getCurDb() != null) {
            msg = String.format("The file '%s' contains data  for a '%s'%sWould you like to import the data into the current design or a new, empty design?", file.getPath(), scopeStr, details);
            opts = AllOpts;
        } else {
            msg = String.format("The file '%s' contains data  for a '%s', would you like to import the data into a new, empty design?", file.getPath(), scopeStr);
            opts = OnlyNewOpts;
        }
        JOptionPane op = new JOptionPane(msg, 3);
        op.setOptions(opts);
        JDialog dlg = op.createDialog(uiOwner, "Confirm Import");
        dlg.setVisible(true);
        Object res = op.getValue();
        if (res != AllOpts[0] && res != AllOpts[1]) {
            return false;
        }
        if (res == AllOpts[1]) {
            Design design = (Design)Cp.exec((String)"OrbitIO.createDesign().orElse(null)", (Object[])new Object[0]);
            if (design == null) {
                ALog.logError((String)"Error creating a new design.");
                return false;
            }
            return (Boolean)Cp.exec((String)"com.sigrity.orbit.ui.ImportDbUI.importDb(\"%s\", null, null)", (Object[])new Object[]{file.getPath()});
        }
        Db curDb = OrbitIO.getCurDb();
        ImportMergeOptsUI dlgOpts = new ImportMergeOptsUI(curDb, file);
        dlgOpts.setModal(true);
        dlgOpts.setVisible(true);
        if (!dlgOpts.getUserOked()) {
            return false;
        }
        Cp.exec((String)"unset(\"_dbr\")", (Object[])new Object[0]);
        Cp.exec((String)"_dbr = new com.sigrity.orbit.OrbitDbReaderImport(curDb())", (Object[])new Object[0]);
        if (versionCheck.getAllowOtherVersion()) {
            Cp.exec((String)"_dbr.setAllowDifferentVersion(true)", (Object[])new Object[0]);
        }
        try {
            Boolean readResult;
            OrbitDbReaderImport.ConflictOpt pco;
            for (Map.Entry<String, String> ent : dlgOpts.getSubstrateMap().entrySet()) {
                if (ent.getValue() == null) continue;
                Cp.exec((String)"_dbr.addSubstrateMap(\"%s\", \"%s\")", (Object[])new Object[]{ent.getKey(), ent.getValue()});
            }
            OrbitDbReaderImport.ConflictOpt tco = dlgOpts.getTemplateConflictOpt();
            if (tco != OrbitDbReaderImport.ConflictOpt.KeepDup) {
                Cp.exec((String)"_dbr.setConflictingTemplateOption(com.sigrity.orbit.OrbitDbReaderImport.ConflictOpt.%s)", (Object[])new Object[]{tco.name()});
            }
            if ((pco = dlgOpts.getPersonalityConflictOpt()) != OrbitDbReaderImport.ConflictOpt.KeepDup) {
                Cp.exec((String)"_dbr.setConflictingPersonalityOption(com.sigrity.orbit.OrbitDbReaderImport.ConflictOpt.%s)", (Object[])new Object[]{pco.name()});
            }
            boolean bl = (readResult = (Boolean)Cp.exec((String)"_dbr.read(\"%s\")", (Object[])new Object[]{file.getPath()})) == null ? false : readResult;
            return bl;
        }
        finally {
            Cp.exec((String)"unset(\"_dbr\")", (Object[])new Object[0]);
        }
    }

    public ImportDbUI(Window owner) {
        super(owner, "Import Design", Dialog.ModalityType.APPLICATION_MODAL);
        GridBagManager l = new GridBagManager(this.getContentPane());
        l.add("File:");
        this.mFileChooser = new AFileChooserControl();
        this.mFileChooser.addChoosableFileFilter(OrbitIO.OIO_FILE_FILTER);
        l.add((Component)this.mFileChooser, (GridBagConstraints)GridBagManager.FILLX);
        this.mFileChooser.getTextField().getDocument().addDocumentListener(new ADocumentAdapter(){

            @Override
            public void documentChanged(DocumentEvent e) {
                ImportDbUI.this.updateSelectedFile();
            }
        });
        l.newline();
        this.mCbImportAll = new JCheckBox("Import entire design");
        this.mCbImportAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportDbUI.this.importAllChanged();
            }
        });
        this.mPnlImportSel = new JPanel();
        this.mPnlImportSel.setBorder(new ATitledBorder("Import Selection", this.mPnlImportSel));
        this.mTreeModel = new ATreeModel(null);
        this.mTreeDesignHierarchy = new JTree((TreeModel)this.mTreeModel);
        this.mTreeDesignHierarchy.setCellRenderer((TreeCellRenderer)new ATreeCellRenderer());
        this.mTreeDesignHierarchy.setRootVisible(false);
        this.mTreeDesignHierarchy.setShowsRootHandles(true);
        DefaultTreeSelectionModel selModel = new DefaultTreeSelectionModel();
        selModel.setSelectionMode(1);
        this.mTreeDesignHierarchy.setSelectionModel(selModel);
        this.mTreeDesignHierarchy.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ImportDbUI.this.enableControls();
            }
        });
        l.pushFillXRemainX();
        this.mTxtStatus = new JTextField();
        this.mTxtStatus.setEditable(false);
        this.mTxtStatus.setFocusable(false);
        this.mTxtStatus.setBorder(null);
        l.add((Component)this.mTxtStatus, (GridBagConstraints)GridBagManager.FILLX);
        this.mBtnOk = new JButton("OK");
        l.add((Component)this.mBtnOk, (GridBagConstraints)GridBagManager.RIGHT);
        this.mBtnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportDbUI.this.ok();
            }
        });
        JButton btnCancel = new JButton("Cancel");
        l.add((Component)btnCancel, (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)this.mBtnOk);
        this.pack();
        UIUtil.center((Component)((Object)this));
        this.updateSelectedFile();
        mCurImportDbUI = this;
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 202) {
            mCurImportDbUI = null;
        }
        super.processWindowEvent(e);
    }

    protected void setStatus(String fmt, Object ... args) {
        if (fmt == null) {
            fmt = "";
        }
        String text = String.format(fmt, args);
        this.mTxtStatus.setText(text);
        Dimension d = this.mTxtStatus.getSize();
        this.mTxtStatus.paintImmediately(0, 0, d.width, d.height);
        this.mTxtStatus.setToolTipText(text.length() > 0 ? text : null);
    }

    protected void clearStatus() {
        this.setStatus("", new Object[0]);
    }

    protected void ok() {
        this.clearStatus();
        String className = "null";
        String key = "null";
        if (!this.mCbImportAll.isSelected()) {
            APair<String, String> sel = this.getSelectedImportItem();
            if (sel == null) {
                ALog.logError((String)"No item selected to import.");
                assert (false);
                return;
            }
            className = String.format("\"%s\"", sel.first);
            key = String.format("\"%s\"", sel.second);
        }
        this.mImported = (Boolean)Cp.exec((String)"com.sigrity.orbit.ui.ImportDbUI.importDb(%s, %s, %s)", (Object[])new Object[]{Cp.getFileAsArgument((String)this.mFileChooser.getPath()), className, key});
        if (this.mImported) {
            UIUtil.closeWindow((Window)((Object)this));
        } else {
            this.setStatus("Import failed", new Object[0]);
        }
    }

    protected void updateSelectedFile() {
        File file;
        this.mIsPathValid = false;
        this.clearStatus();
        this.clearTree();
        String filePath = this.mFileChooser.getPath();
        if (filePath != null && filePath.length() > 0 && (file = new File(filePath)).canRead()) {
            this.mIsPathValid = true;
            this.mCbImportAll.setSelected(true);
        }
        this.enableControls();
    }

    protected void importAllChanged() {
        this.clearStatus();
        if (!this.mCbImportAll.isSelected() && !this.getIsHierarchyLoaded()) {
            this.loadHierarchy();
        }
        this.enableControls();
    }

    protected boolean getIsHierarchyLoaded() {
        return this.getRootNode() != null;
    }

    protected Db getHierarchy() {
        if (this.getRootNode() == null) {
            return null;
        }
        return this.getRootNode().mDb;
    }

    protected void loadHierarchy() {
        this.setStatus("Loading hierarchy...", new Object[0]);
        String filePath = this.mFileChooser.getPath();
        Db db = OrbitDbReaderFiltered.readHierarchy(filePath);
        if (db == null) {
            this.setStatus("Unable to load '%s'", filePath);
            this.clearTree();
            return;
        }
        DbNode root = new DbNode(db);
        this.mTreeModel.setRoot((TreeNode)((Object)root));
        this.clearStatus();
    }

    protected void enableControls() {
        this.mCbImportAll.setEnabled(this.mIsPathValid);
        boolean dbHierLoaded = this.getRootNode() != null;
        UIUtil.setEnabled((Container)this.mPnlImportSel, (dbHierLoaded && !this.mCbImportAll.isSelected() ? 1 : 0) != 0);
        boolean canOk = false;
        if (this.mIsPathValid) {
            if (this.mCbImportAll.isSelected()) {
                canOk = true;
            } else if (this.getSelectedImportItem() != null) {
                canOk = true;
            }
        }
        this.mBtnOk.setEnabled(canOk);
    }

    protected APair<String, String> getSelectedImportItem() {
        TreePath tp = this.mTreeDesignHierarchy.getSelectionPath();
        if (tp == null) {
            return null;
        }
        Object o = tp.getLastPathComponent();
        if (o instanceof DeviceTemplateNode) {
            DeviceTemplateNode dtn = (DeviceTemplateNode)((Object)o);
            DeviceTemplate dt = dtn.mDeviceTemplate;
            String className = dt.getDbClass().getName();
            String key = dt.getKeyStr();
            return new APair((Object)className, (Object)key);
        }
        if (o instanceof DeviceNode) {
            DeviceNode dn = (DeviceNode)((Object)o);
            Device d = dn.mDevice;
            String className = d.getDbClass().getName();
            String key = d.getKeyStr();
            return new APair((Object)className, (Object)key);
        }
        return null;
    }

    protected DbNode getRootNode() {
        return (DbNode)((Object)this.mTreeModel.getRoot());
    }

    protected void clearTree() {
        DbNode root = this.getRootNode();
        if (root != null) {
            this.mTreeModel.setRoot(null);
        }
        this.enableControls();
    }

    public static Db getHierarchy(String path) {
        Db db;
        if (mCurImportDbUI != null && (db = mCurImportDbUI.getHierarchy()) != null) {
            File inFile = new File(path);
            String inCPath = null;
            try {
                inCPath = inFile.getCanonicalPath();
            }
            catch (IOException e) {
                ALog.logDebug((Throwable)e, (String)"Error getting canonical path for input path '%s'.", (Object[])new Object[]{path});
            }
            File dbFile = db.getFile();
            String dbCPath = null;
            try {
                dbCPath = dbFile.getCanonicalPath();
            }
            catch (IOException e) {
                ALog.logDebug((Throwable)e, (String)"Error getting canonical path for database path '%s'.", (Object[])new Object[]{path});
            }
            if (dbCPath != null && inCPath != null && dbCPath.equals(inCPath)) {
                return db;
            }
        }
        if ((db = OrbitDbReaderFiltered.readHierarchy(path)) == null) {
            ALog.logError((String)"Unable to load '%s'", (Object[])new Object[]{path});
            return null;
        }
        return db;
    }

    public static void showVersionNotes(Window owner, Db.Version verA, Db.Version verB) {
        String BR = "\n";
        boolean inOrder = verA.compareTo(verB) <= 0;
        final Db.Version verStart = inOrder ? verA : verB;
        final Db.Version verEnd = inOrder ? verB : verA;
        LinkedList<String> notes = new LinkedList<String>();
        int size = 0;
        File dbRelNotesDir = new File(AApp.getInstallDir(), "docs/ReleaseNotes/DbVersions");
        final Pattern verNotePattern = Pattern.compile("v(\\d+)\\.(\\d+)\\.(?i)html");
        for (File relNoteFile : dbRelNotesDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                int minor;
                Matcher matcher = verNotePattern.matcher(name);
                if (!matcher.matches()) {
                    return false;
                }
                int major = Integer.parseInt(matcher.group(1));
                Db.Version noteVer = new Db.Version(major, minor = Integer.parseInt(matcher.group(2)));
                return noteVer.compareTo(verStart) > 0 && noteVer.compareTo(verEnd) <= 0;
            }
        })) {
            try {
                String text = Files.asCharSource((File)relNoteFile, (Charset)Charset.forName("ISO-8859-1")).read();
                notes.add(text);
                size += text.length();
            }
            catch (IOException e) {
                ALog.logWarn((Throwable)e, (String)"Error reading Release Note '%s'.", (Object[])new Object[]{relNoteFile.getAbsolutePath()});
            }
        }
        if (notes.size() == 0) {
            JOptionPane.showMessageDialog(owner, "No release notes were found for this range of database versions.", "Database Version Notes", 1);
            return;
        }
        StringBuffer buf = new StringBuffer(size + notes.size() * "\n".length());
        for (String note : notes) {
            if (buf.length() > 0) {
                buf.append("\n");
            }
            buf.append(note);
        }
        String allNotes = buf.toString();
        final JDialog dlg = new JDialog(owner);
        dlg.setTitle("Database Version Notes");
        GridBagManager l = GridBagManager.layout((JDialog)dlg);
        AHtmlPane htmlNotes = new AHtmlPane();
        htmlNotes.setEditable(false);
        htmlNotes.setOpaque(false);
        htmlNotes.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                URL url = e.getURL();
                ABrowserControl.displayURL((URL)url);
            }
        });
        htmlNotes.setPreferredSize(new Dimension(600, 400));
        l.add((Component)new JScrollPane(htmlNotes), (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        l.newline();
        l.pushFillXRemainX();
        l.addFillX();
        JButton btnDone = (JButton)l.add((Component)new JButton("Close"));
        l.pop();
        btnDone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIUtil.closeWindow((Window)dlg);
            }
        });
        dlg.pack();
        htmlNotes.setText(allNotes);
        UIUtil.enableEscapeClose((Window)dlg, (AbstractButton)btnDone);
        UIUtil.center((Component)dlg);
        UIUtil.verifyWindowOnScreen((Window)dlg);
        btnDone.requestFocus();
        dlg.setVisible(true);
    }

    public static boolean getImportWithoutAsking(Db.Version verSrc, Db.Version verDest) {
        String name = String.format("NoPrompt%sTo%s", verSrc, verDest);
        return (Boolean)Settings.get((String)"ImportOIO", (String)name, (Object)Boolean.FALSE);
    }

    public static void setImportWithoutAsking(Db.Version verSrc, Db.Version verDest) {
        Settings settings = Settings.getSettings((String)"ImportOIO");
        String name = String.format("NoPrompt%sTo%s", verSrc, verDest);
        settings.putSetting(name, (Object)Boolean.TRUE);
        settings.save();
    }

    protected static class ImportVersionCheck {
        protected File mSrc;
        protected Window mUiOwner;
        protected boolean mOk = false;
        protected boolean mAllowOtherVersion = false;
        protected Db.Version mVersion = null;
        protected Error StopXmlRead = new Error();

        public static ImportVersionCheck create(Window uiOwner, File f) {
            ImportVersionCheck checker = new ImportVersionCheck(f, uiOwner);
            return checker;
        }

        public ImportVersionCheck(File src, Window uiOwner) {
            this.mUiOwner = uiOwner;
            this.mSrc = src;
            this.check();
        }

        public boolean getOK() {
            return this.mOk;
        }

        public boolean getAllowOtherVersion() {
            return this.mAllowOtherVersion;
        }

        public Db.Version getDbVersion() {
            return this.mVersion;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void check() {
            if (!this.mSrc.canRead()) {
                ALog.logError((String)"Can not read '%s'.", (Object[])new Object[]{this.mSrc.getPath()});
                return;
            }
            ZipFile zf = null;
            try {
                try {
                    block41: {
                        zf = new ZipFile(this.mSrc);
                        String path = zf.getName();
                        ZipEntry ze = zf.getEntry("db.xml");
                        if (ze == null) {
                            ALog.logError((String)"Invalid file structure in '%s'.", (Object[])new Object[]{path});
                        }
                        InputStream is = null;
                        try {
                            is = zf.getInputStream(ze);
                            if (this.readVersion(is)) break block41;
                        }
                        catch (IOException e) {
                            ALog.logError((Throwable)e, (String)"An I/O error occurred reading '%s'.", (Object[])new Object[]{path});
                            return;
                        }
                        try {
                            zf.close();
                            return;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return;
                    }
                    this.checkVersion();
                    return;
                }
                catch (ZipException path) {
                }
            }
            catch (IOException e) {
                ALog.logError((Throwable)e, (String)"An I/O error occurred reading '%s'.", (Object[])new Object[]{this.mSrc.getPath()});
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            FileInputStream is = null;
            try {
                is = new FileInputStream(this.mSrc);
                if (!this.readVersion(is)) {
                    return;
                }
                this.checkVersion();
                return;
            }
            catch (FileNotFoundException e) {
                ALog.logError((String)"File '%s' not found.", (Object[])new Object[]{this.mSrc.getPath()});
                return;
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException iOException) {}
            }
        }

        protected boolean readVersion(InputStream is) {
            AXSaxUtil.ElementHandler rootHandler = new AXSaxUtil.ElementHandler();
            AXSaxUtil.ElementHandler dbHandler = new AXSaxUtil.ElementHandler(){

                public void onStart(String namespaceURI, String localName, String qName, Attributes attr) {
                    String version = attr.getValue("version");
                    mVersion = OrbitDbReader.parseDbVersion((String)version);
                    if (mVersion == null) {
                        ALog.logError((String)"Invalid database version '%s' specified.", (Object[])new Object[]{version});
                    }
                    throw StopXmlRead;
                }
            };
            AXSaxUtil.SaxParser sp = new AXSaxUtil.SaxParser(rootHandler);
            rootHandler.setHandler("Db", dbHandler);
            boolean res = false;
            try {
                res = sp.parse(is);
            }
            catch (Throwable t) {
                if (t == this.StopXmlRead) {
                    res = this.mVersion != null;
                }
                ALog.logError((String)"Error reading database.");
                res = false;
            }
            return res;
        }

        protected void checkVersion() {
            if (OrbitIO.DBVERSION.equals((Object)this.mVersion)) {
                this.mOk = true;
                return;
            }
            if (ImportDbUI.getImportWithoutAsking(this.mVersion, OrbitIO.DBVERSION)) {
                ALog.logInfo((String)"Importing v%s database information into a v%s database. (User prompt has been disabled for these versions.)", (Object[])new Object[]{this.mVersion.toString(), OrbitIO.DBVERSION.toString()});
                this.mOk = true;
                return;
            }
            String msgFmt = "<style type='text/css'>body {font-size: 12pt; font-family: arial, sans-serif}div {margin-bottom: 6px}.right {text-align: right}</style><body><div>The version of the database to be imported is %s but the current database <br/>version is %s. Continuing the import may cause unexpected results.</div><div>Would you like to continue to import the database?</div><div class='right'><a href='#'>Click for version notes</a></div></body>";
            String msg = String.format(msgFmt, this.mVersion.toString(), OrbitIO.DBVERSION.toString());
            final JDialog dlg = new JDialog(this.mUiOwner);
            dlg.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
            dlg.setTitle("Confirm Import");
            GridBagManager l = GridBagManager.layout((JDialog)dlg);
            JEditorPane htmlMsg = new JEditorPane("text/html", msg);
            htmlMsg.setEditable(false);
            htmlMsg.setOpaque(false);
            htmlMsg.setFont(dlg.getFont());
            htmlMsg.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                        return;
                    }
                    ImportDbUI.showVersionNotes(dlg, mVersion, OrbitIO.DBVERSION);
                }
            });
            l.add((Component)htmlMsg, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            l.newline();
            final JCheckBox cbImportNoPrompt = (JCheckBox)l.add((Component)new JCheckBox("Import between these versions without asking"));
            l.newline();
            l.pushFillXRemainX();
            l.addFillX();
            JButton btnOk = (JButton)l.add((Component)new JButton("Yes, continue"));
            JButton btnCancel = (JButton)l.add((Component)new JButton("No, cancel"));
            l.pop();
            btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    mOk = true;
                    mAllowOtherVersion = true;
                    ALog.logInfo((String)"Importing v%s database information into a v%s database.", (Object[])new Object[]{mVersion.toString(), OrbitIO.DBVERSION.toString()});
                    if (cbImportNoPrompt.isSelected()) {
                        ImportDbUI.setImportWithoutAsking(mVersion, OrbitIO.DBVERSION);
                    }
                    UIUtil.closeWindow((Window)dlg);
                }
            });
            btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UIUtil.closeWindow((Window)dlg);
                }
            });
            dlg.pack();
            dlg.setMinimumSize(dlg.getPreferredSize());
            UIUtil.enableEscapeClose((Window)dlg, (AbstractButton)btnCancel);
            UIUtil.center((Component)dlg);
            btnOk.requestFocus();
            dlg.setVisible(true);
        }
    }

    public static class ImportMergeOptsUI
    extends ADialog {
        protected Db mTargetDb;
        protected File mSrcFile;
        protected boolean mUserOked = false;
        protected JList<String> mLstSrc;
        protected AListModel<String> mLstModelSrc;
        protected JList<String> mLstDst = new JList();
        protected AListModel<String> mLstModelDst;
        protected JComboBox<OrbitDbReaderImport.ConflictOpt> mCboConflictingTemplates;
        protected JComboBox<OrbitDbReaderImport.ConflictOpt> mCboConflictingPersonalities;
        protected JLabel mLblStatus = new JLabel();
        protected HashMap<String, String> mMap;
        protected UIUtil.APopupMenuProvider mListContextMenuProvider = new UIUtil.APopupMenuProvider(){

            public JPopupMenu getMenu(Component c, int x, int y) {
                int idx = mLstSrc.locationToIndex(new Point(x, y));
                if (idx < 0) {
                    return null;
                }
                final String src = mLstModelSrc.getItemAt(idx);
                JPopupMenu menu = new JPopupMenu(src);
                if (mMap.containsKey(src)) {
                    menu.add(new AbstractAction("Import as new Substrate"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            mMap.remove(src);
                            this.repaint();
                            this.refreshSubstratesStatus();
                        }
                    });
                }
                if (menu.getComponentCount() > 0) {
                    return menu;
                }
                return null;
            }
        };

        public ImportMergeOptsUI(Db targetDb, File srcFile) {
            super(OrbitIO.getMainWindow());
            Object s3;
            this.setTitle("Import Into Existing Design");
            this.mTargetDb = targetDb;
            this.mSrcFile = srcFile;
            Db dbImportSubstrates = OrbitDbReaderFiltered.readFiltered(this.mSrcFile.getPath(), new String[]{"Design", "Substrate", "Layer"});
            LinkedList<String> srcNames = new LinkedList<String>();
            for (Object s2 : dbImportSubstrates.getObjects(Substrate.class)) {
                srcNames.add(s2.getName());
            }
            Collections.sort(srcNames);
            LinkedList<String> destNames = new LinkedList<String>();
            for (Object s3 : this.mTargetDb.getObjects(Substrate.class)) {
                destNames.add(s3.getName());
            }
            Collections.sort(destNames);
            this.mLstModelSrc = AListModel.create(srcNames);
            this.mLstModelDst = AListModel.create(destNames);
            HashSet hashDst = new HashSet(destNames);
            this.mMap = new HashMap();
            s3 = srcNames.iterator();
            while (s3.hasNext()) {
                String s4;
                this.mMap.put(s4, hashDst.contains(s4 = (String)s3.next()) ? s4 : null);
            }
            this.mLstSrc = new JList<String>(this.mLstModelSrc);
            this.mLstSrc.setSelectionMode(0);
            this.mLstDst = new JList<String>(this.mLstModelDst);
            this.mLstDst.setSelectionMode(0);
            GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
            l.push("Substrate Mapping", (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            l.add("Source", (GridBagConstraints)GridBagManager.LEFT.insetVert(0));
            l.add("Target", (GridBagConstraints)GridBagManager.LEFT.insetVert(0));
            l.newline();
            l.add((Component)new JScrollPane(this.mLstSrc), (GridBagConstraints)GridBagManager.FILLALL);
            l.add((Component)new JScrollPane(this.mLstDst), (GridBagConstraints)GridBagManager.FILLALL);
            l.pop();
            l.newline();
            l.add("For duplicate child-device templates:");
            this.mCboConflictingTemplates = (JComboBox)l.add(new JComboBox<OrbitDbReaderImport.ConflictOpt>(OrbitDbReaderImport.ConflictOpt.values()), (GridBagConstraints)GridBagManager.LEFT);
            this.mCboConflictingTemplates.setToolTipText("Specify which template to use when an imported child device template has the same name as an existing device template in the target substrate.");
            this.mCboConflictingTemplates.setSelectedItem((Object)OrbitDbReaderImport.ConflictOpt.UseSrc);
            l.newline();
            l.add("For duplicate personalities:");
            this.mCboConflictingPersonalities = (JComboBox)l.add(new JComboBox<OrbitDbReaderImport.ConflictOpt>(OrbitDbReaderImport.ConflictOpt.values()), (GridBagConstraints)GridBagManager.LEFT);
            this.mCboConflictingPersonalities.setToolTipText("Specify which personality to use when an imported personality has the same name as an personality in the target substrate.");
            this.mCboConflictingPersonalities.setSelectedItem((Object)OrbitDbReaderImport.ConflictOpt.KeepDup);
            l.newline();
            l.push((GridBagConstraints)GridBagManager.FILLX_REMAINX.insetTop(12));
            l.add((Component)this.mLblStatus, (GridBagConstraints)GridBagManager.FILLX);
            JButton btnOk = (JButton)l.add((Component)new JButton("OK"));
            btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    mUserOked = true;
                    UIUtil.closeWindow((Window)((Object)this));
                }
            });
            JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOk);
            this.pack();
            UIUtil.center((Component)((Object)this));
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    String msg;
                    int res;
                    if (!mUserOked && (res = JOptionPane.showConfirmDialog((Component)((Object)this), msg = "Are you sure you want to cancel the operation?", "Confirm Cancel", 0, 3)) != 0) {
                        return;
                    }
                    this.dispose();
                }
            });
            AListConnectionOverlay.ListItemMapper<String, String> mapper = new AListConnectionOverlay.ListItemMapper<String, String>(){

                @Override
                public int getRightListIndex(int leftIndex) {
                    String left = mLstModelSrc.getItemAt(leftIndex);
                    String right = mMap.get(left);
                    return right == null ? -1 : mLstModelDst.indexOf(right);
                }

                @Override
                public void put(String l, String r) {
                    mMap.put(l, r);
                }
            };
            AListConnectionOverlay<String, String> glass = new AListConnectionOverlay<String, String>(this.mLstSrc, this.mLstDst, mapper);
            this.setGlassPane(glass);
            ((Component)glass).setVisible(true);
            new AListConnectionManager<String, String>(this.mLstSrc, this.mLstDst, (AListConnectionOverlay.ListItemMapper)mapper){

                @Override
                protected void updateStatus() {
                    this.refreshSubstratesStatus();
                }
            };
            UIUtil.installPopupMenu(this.mLstSrc, (UIUtil.APopupMenuProvider)this.mListContextMenuProvider);
            this.setStatus("Drag and drop or click/double-click to change mapping");
        }

        public boolean getUserOked() {
            return this.mUserOked;
        }

        public HashMap<String, String> getSubstrateMap() {
            return this.mMap;
        }

        public OrbitDbReaderImport.ConflictOpt getTemplateConflictOpt() {
            return (OrbitDbReaderImport.ConflictOpt)((Object)this.mCboConflictingTemplates.getSelectedItem());
        }

        public OrbitDbReaderImport.ConflictOpt getPersonalityConflictOpt() {
            return (OrbitDbReaderImport.ConflictOpt)((Object)this.mCboConflictingPersonalities.getSelectedItem());
        }

        protected void setStatus(String text) {
            if (text == null) {
                text = "";
            }
            this.mLblStatus.setText(text);
            this.mLblStatus.setToolTipText(text);
        }

        protected void refreshSubstratesStatus() {
            int idxSrc = this.mLstSrc.getSelectedIndex();
            if (idxSrc < 0) {
                this.mLstDst.setSelectedIndex(-1);
                this.setStatus(null);
                return;
            }
            String src = this.mLstModelSrc.getItemAt(idxSrc);
            String dst = this.mMap.get(src);
            int idxDst = dst == null ? -1 : this.mLstModelDst.indexOf(dst);
            this.mLstDst.setSelectedIndex(idxDst);
            this.setStatus(dst != null ? String.format("'%s' will be merged with '%s'", src, dst) : String.format("'%s' will be imported as a new substrate", src, dst));
        }
    }

    protected class DeviceTemplateNode
    extends Node {
        protected DeviceTemplate mDeviceTemplate;

        public DeviceTemplateNode(Node parent, DeviceTemplate deviceTemplate) {
            super(parent);
            this.mDeviceTemplate = deviceTemplate;
        }

        public String getText() {
            return this.mDeviceTemplate.getName();
        }

        public ArrayList<? extends ATreeNode> populateChildren() {
            return null;
        }

        public Icon getIcon() {
            return DbExplorerPanel.getIconForTemplate(this.mDeviceTemplate);
        }

        public boolean isLeaf() {
            return true;
        }
    }

    protected class DeviceTemplateListNode
    extends Node {
        public DeviceTemplateListNode(Node parent) {
            super(parent);
        }

        public String getText() {
            return "Device Templates";
        }

        public ArrayList<? extends ATreeNode> populateChildren() {
            Db db = ((DbNode)this.mParent).mDb;
            ArrayList<DeviceTemplateNode> children = new ArrayList<DeviceTemplateNode>();
            for (DeviceTemplate template : db.getObjects(DeviceTemplate.class)) {
                children.add(new DeviceTemplateNode(this, template));
            }
            return children;
        }
    }

    protected class DeviceNode
    extends Node {
        protected Device mDevice;

        public DeviceNode(Node parent, Device device) {
            super(parent);
            this.mDevice = device;
        }

        public String getText() {
            return this.mDevice.getName();
        }

        public Icon getIcon() {
            return DbExplorerPanel.getIconForDevice(this.mDevice);
        }

        public ArrayList<? extends ATreeNode> populateChildren() {
            ArrayList<DeviceNode> children = new ArrayList<DeviceNode>();
            for (Device d : this.mDevice.getChildren()) {
                children.add(new DeviceNode(this, d));
            }
            return children;
        }
    }

    protected class DeviceHiearchyNode
    extends Node {
        public DeviceHiearchyNode(DbNode parent) {
            super(parent);
        }

        public String getText() {
            return "Devices";
        }

        public ArrayList<? extends ATreeNode> populateChildren() {
            Db db = ((DbNode)this.mParent).mDb;
            ArrayList<DeviceNode> children = new ArrayList<DeviceNode>();
            Design design = Design.getDesign((Db)db);
            for (Device d : design.getRootDevices()) {
                children.add(new DeviceNode(this, d));
            }
            return children;
        }
    }

    protected class DbNode
    extends Node {
        protected Db mDb;

        public DbNode(Db db) {
            super(ImportDbUI.this.mTreeModel);
            this.mDb = db;
        }

        public String getText() {
            return this.mDb.getFile().getAbsolutePath();
        }

        public ArrayList<? extends ATreeNode> populateChildren() {
            ArrayList<Node> children = new ArrayList<Node>();
            children.add(new DeviceHiearchyNode(this));
            children.add(new DeviceTemplateListNode(this));
            return children;
        }
    }

    protected abstract class Node
    extends ALazyTreeNode {
        public Node(Node parent) {
            super((ATreeNode)parent);
        }

        public Node(ATreeModel model) {
            super(model);
        }

        public String toString() {
            return this.getText();
        }
    }

    protected class Model
    extends ATreeModel {
        protected Model() {
        }
    }
}

