/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.AFileChooserControl;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.CreateFromTemplateOrParametrically;
import com.sigrity.orbit.ui.core.DesignView2D;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class ImportDeviceFromPinsCsvUI
extends ADialog {
    protected JTextField mTxtName;
    protected AFileChooserControl mFileChooser;
    protected DeviceTemplate.Type mDeviceTemplateType;
    protected CreateFromTemplateOrParametrically mTemplateOrParametricPane = null;
    protected ActionListener mOk = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ImportDeviceFromPinsCsvUI.this.validateInput()) {
                return;
            }
            if (ImportDeviceFromPinsCsvUI.this.apply() == null) {
                return;
            }
            if (ImportDeviceFromPinsCsvUI.this.mTemplateOrParametricPane != null) {
                ImportDeviceFromPinsCsvUI.this.mTemplateOrParametricPane.close();
            }
            UIUtil.closeWindow((Window)((Object)ImportDeviceFromPinsCsvUI.this));
        }
    };

    public static void showDlg(DeviceTemplate.Type devType) {
        new ImportDeviceFromPinsCsvUI(OrbitIO.getMainWindow(), devType).setVisible(true);
    }

    public ImportDeviceFromPinsCsvUI(Component owner, DeviceTemplate.Type createType) {
        super(owner);
        this.mDeviceTemplateType = createType;
        this.setTitle(String.format("Create %s from CSV", createType.name()));
        this.setModal(true);
        GridBagManager l = GridBagManager.layout((Container)this.getContentPane());
        l.pushFill();
        l.add("Device Name");
        this.mTxtName = (JTextField)l.add((Component)new JTextField(20), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        this.mTxtName.setText(createType.name().substring(0, 1));
        l.newline();
        this.mFileChooser = (AFileChooserControl)l.add("Pin CSV File:", (Component)new AFileChooserControl(), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        this.mFileChooser.addChoosableFileFilter(AFileFilter.CSV);
        l.addFillX();
        l.pop();
        l.newline();
        if (this.mTemplateOrParametricPane == null) {
            Db db = OrbitIO.getCurDb();
            Design currentDesign = Design.getDesign((Db)db);
            l.pushFill("Options");
            this.mTemplateOrParametricPane = new CreateFromTemplateOrParametrically(currentDesign.getSubstrate(), null, null, false, createType);
            l.add((Component)this.mTemplateOrParametricPane, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            l.addFillX();
            l.pop();
            l.newline();
        }
        l.pushFill();
        l.addFillX();
        JButton btnOk = (JButton)l.add((Component)new JButton("OK"), (GridBagConstraints)GridBagManager.RIGHT);
        JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"), (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOk);
        this.pack();
        UIUtil.center((Component)((Object)this));
        btnOk.addActionListener(this.mOk);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (ImportDeviceFromPinsCsvUI.this.mTemplateOrParametricPane != null) {
                    ImportDeviceFromPinsCsvUI.this.mTemplateOrParametricPane.close();
                }
            }
        });
    }

    protected boolean validateInput() {
        try {
            AFieldValidator.validateText((JTextComponent)this.mTxtName);
            AFieldValidator.validateFileExists((JTextField)this.mFileChooser.getTextField());
            this.mTemplateOrParametricPane.validateSettings();
        }
        catch (AFieldValidator.AFieldValidationException e) {
            return false;
        }
        return true;
    }

    protected Device apply() {
        String name = this.mTxtName.getText();
        String csvPath = this.mFileChooser.getPath();
        String pinSize = this.mTemplateOrParametricPane.getSizeStr();
        String pinSize2 = this.mTemplateOrParametricPane.getSize2Str();
        String padShape = String.format("%s.%s", PadTemplate.PadShapeStyle.class.getName(), this.mTemplateOrParametricPane.getShape().name());
        Cp.exec((String)"unset(\"_deviceFactory\")", (Object[])new Object[0]);
        Cp.exec((String)"_deviceFactory = com.sigrity.orbit.factory.DeviceFactory.create(curDb())", (Object[])new Object[0]);
        Cp.exec((String)"_deviceFactory.setInstantiateAsDevices(%b)", (Object[])new Object[]{!this.mTemplateOrParametricPane.instantiateAsPins()});
        Cp.exec((String)"_deviceFactory.setPinFile(%s)", (Object[])new Object[]{Cp.getFileAsArgument((String)csvPath)});
        if (this.mTemplateOrParametricPane.fromTemplate()) {
            Cp.exec((String)"_deviceFactory.setPinFromTemplateName(\"%s\")", (Object[])new Object[]{this.mTemplateOrParametricPane.getTemplateName()});
        } else {
            Cp.exec((String)"_deviceFactory.setPinSize((double) %s)", (Object[])new Object[]{pinSize});
            Cp.exec((String)"_deviceFactory.setPinSizeB((double) %s)", (Object[])new Object[]{pinSize2});
            Cp.exec((String)"_deviceFactory.setPadShape(%s)", (Object[])new Object[]{padShape});
        }
        Object res = Cp.exec((String)"_deviceFactory.createDevice(\"%s\", %s.%s)", (Object[])new Object[]{name, DeviceTemplate.Type.class.getName(), this.mDeviceTemplateType.name()});
        Cp.exec((String)"unset(\"_deviceFactory\")", (Object[])new Object[0]);
        if (res instanceof Device) {
            AAppView v = OrbitIO.getCurView();
            if (v instanceof DesignView2D) {
                ((DesignView2D)v).getCanvas().zoomFit();
            }
            return (Device)res;
        }
        return null;
    }
}

