/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbFieldDef;
import com.sigrity.acl.db.DbLoader;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.xml.AXSaxUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.SymbolSpreadsheet;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.io.CharArrayWriter;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;

public class ImportSpreadsheetReader
extends SymbolSpreadsheet {
    static SymbolSpreadsheet.WorksheetRow mWorksheetRow = null;
    static SymbolSpreadsheet.WorksheetCell mWorksheetCell = null;
    static SymbolSpreadsheet.Style mStyle = null;
    public static final String TAG_WORKBOOK = "Workbook";
    public static final String TAG_WORKSHEET = "Worksheet";
    public static final String TAG_TABLE = "Table";
    public static final String TAG_ROW = "Row";
    public static final String TAG_COLUMN = "Column";
    public static final String TAG_CELL = "Cell";
    public static final String TAG_DATA = "Data";
    public static final String TAG_STYLE = "Styles/Style";
    public static final String TAG_FONT = "Font";
    public static final String TAG_BORDER = "Border";
    public static final String TAG_ALIGNMENT = "Alignment";
    public static final String TAG_INTERIOR = "Interior";
    public static final String NONAME = "NoName";
    protected final Db mDb;
    protected final File mInputFile;
    protected final String mPText;
    protected final String mSText;
    protected final String mColorSource;
    protected final String mDiameter;
    protected final String mPitch;
    protected double mScale = 1.0;
    protected Layer mLayer = null;
    protected Substrate mSubstrate = null;
    protected DeviceTemplate mDeviceTemplate = null;
    protected Device mDevice = null;
    protected PadTemplate mPadTemplate = null;
    protected long mRowMax = 0L;
    protected long mColMax = 0L;
    protected static AXSaxUtil.SaxParser mParser = null;
    protected Unit mUnit = null;

    public ImportSpreadsheetReader(Db db, File inputFile, String pText, String sText, String colSource, String diameter, String pitch) {
        this.mDb = db;
        this.mInputFile = inputFile;
        this.mPText = pText;
        this.mSText = sText;
        this.mColorSource = colSource;
        this.mDiameter = diameter;
        this.mPitch = pitch;
    }

    public ImportSpreadsheetReader(Db db, String inputFilePath, String pText, String sText, String colSource, String diameter, String pitch) {
        this(db, new File(inputFilePath), pText, sText, colSource, diameter, pitch);
    }

    public boolean read() {
        if (this.mDb == null) {
            ALog.logError((String)"No database specified as spreadsheet read target.");
            return false;
        }
        if (this.mInputFile == null) {
            ALog.logError((String)"No input file specified as spreadsheet read source.");
            return false;
        }
        this.mDb.setActiveLoader(new DbLoader(){

            public DbLoader.DbLoadingForeignKey getLoadingKeyVal(DbObject dbo, DbFieldDef keyField) {
                return null;
            }
        });
        this.mDb.setHistoryEnabled(false);
        this.mDb.setListenersEnabled(false);
        try {
            this.parseFile();
            this.createDb();
            this.createPins();
            ALog.logInfo((String)"Spreadsheet read of '%s' complete.", (Object[])new Object[]{this.mInputFile.getAbsolutePath()});
            if (OrbitIO.getApp().getWorkspace() != null) {
                ALog.logInfo((String)"Refreshing display...");
                DbExplorerPanel.refreshAll();
                OrbitIO.zoomFitViewsOf(this.mDb);
                ALog.logInfo((String)"Done.");
            }
        }
        finally {
            this.mDb.setActiveLoader(null);
            this.mDb.setListenersEnabled(true);
            this.mDb.setHistoryEnabled(true);
        }
        return true;
    }

    public void parseFile() {
        mParser = new AXSaxUtil.SaxParser();
        AXSaxUtil.ElementHandler rootH = mParser.setRootHandler(new AXSaxUtil.ElementHandler());
        AXSaxUtil.ElementHandler workBookHandler = new AXSaxUtil.ElementHandler();
        workBookHandler.handle(TAG_WORKSHEET, (AXSaxUtil.ElementHandler)new WorksheetHandler());
        workBookHandler.handle(TAG_STYLE, (AXSaxUtil.ElementHandler)new StyleHandler());
        rootH.handle(TAG_WORKBOOK, workBookHandler);
        mParser.parse(this.mInputFile);
        mParser = null;
    }

    protected void createDb() {
        this.mUnit = new Unit("SpreadsheetUnit", this.mScale * (double)Design.getInternalPerMicron((Db)this.mDb) / 1000.0);
        this.mSubstrate = Substrate.create((Db)this.mDb, (String)"Spreadsheet", (boolean)true);
        this.mSubstrate.setSourceFile(this.mInputFile.getAbsolutePath());
        this.mSubstrate.setSourceFileModifiedTime(this.mInputFile.lastModified());
        this.mSubstrate.setSourceType(DeviceTemplate.SourceType.SPREADSHEET);
        if (this.mScale != 1.0) {
            this.mSubstrate.setScale(Double.valueOf(this.mScale));
        }
        this.mLayer = Layer.create((Substrate)this.mSubstrate, (String)"TOP");
        this.mDeviceTemplate = DeviceTemplate.create((Substrate)this.mSubstrate, (String)NONAME, (boolean)true);
        this.mDeviceTemplate.setType(DeviceTemplate.Type.PACKAGE);
        this.mDeviceTemplate.setSourceType(DeviceTemplate.SourceType.SPREADSHEET);
        this.mDeviceTemplate.setSourceFile(this.mInputFile.getAbsolutePath());
        long pitch = (long)Double.parseDouble(this.mPitch);
        this.mDeviceTemplate.setBounds((AGeom)new ARect(0L, 0L, pitch + this.mRowMax * pitch, pitch + this.mColMax * pitch));
        Design parent = Design.getDesign((Db)this.mDb);
        String uniqueDevName = Device.getUniqueName((DeviceTemplate)parent, (String)NONAME);
        this.mDevice = Device.create((Db)this.mDb, (String)uniqueDevName, (DeviceTemplate)this.mDeviceTemplate, (DeviceTemplate)parent);
        this.mDevice.setLoc(new APoint2D(0L, 0L));
        Object startPadName = "SPad";
        int i = 0;
        while (PadTemplate.get((Db)this.mDb, (Substrate)this.mLayer.getSubstrate(), (String)startPadName) != null) {
            startPadName = (String)startPadName + i;
            ++i;
        }
        this.mPadTemplate = PadTemplate.create((Db)this.mDb, (Substrate)this.mLayer.getSubstrate(), (String)startPadName);
        long radius = (long)(0.5 * Double.parseDouble(this.mDiameter));
        LayerShape.create((Db)this.mDb, (Layer)this.mLayer, (DbObject)this.mPadTemplate, (AGeom)new ACircle(0L, 0L, radius));
    }

    protected void createPins() {
        for (Map.Entry<Long, SymbolSpreadsheet.WorksheetRow> row : ImportSpreadsheetReader.mWorksheet.rows.entrySet()) {
            SymbolSpreadsheet.WorksheetRow wsRow = row.getValue();
            for (SymbolSpreadsheet.WorksheetCell cell : wsRow.cells) {
                String[] str = cell.data.split("\\n|\\r");
                String pinName = "A";
                String netName = "NetUnused";
                if (this.mPText.equals("Pin Name")) {
                    pinName = str[0];
                } else {
                    netName = str[0];
                }
                if (this.mSText.equals("Pin Name")) {
                    pinName = str[1];
                } else if (this.mSText.equals("Net Name")) {
                    netName = str[1];
                }
                Net net = this.mDeviceTemplate.getNet(netName);
                if (net == null) {
                    net = Net.create((DeviceTemplate)this.mDeviceTemplate, (String)netName);
                }
                PinTemplate pinTemplate = PinTemplate.create((Net)net, (String)pinName);
                pinTemplate.setPadTemplate(this.mPadTemplate);
                pinTemplate.setType(PinTemplate.Type.BALLPAD);
                long pitch = (long)Double.parseDouble(this.mPitch);
                pinTemplate.setLoc(new APoint2D(wsRow.rowNum * pitch, cell.colNum * pitch));
                PinInstance pinInstance = new PinInstance(pinTemplate.getName(), this.mDevice, pinTemplate);
                this.mDb.add((DbObject)pinInstance);
            }
        }
    }

    class DataHandler
    extends AXSaxUtil.ElementHandler {
        DataHandler() {
        }

        public void onStart(String namespaceURI, String localName, String qName, Attributes attr) {
            String type;
            super.onStart(namespaceURI, localName, qName, attr);
            ImportSpreadsheetReader.mWorksheetCell.type = type = attr.getValue("ss:Type");
        }

        public void onEnd(String namespaceURI, String localName, String qName, CharArrayWriter data) {
            super.onEnd(namespaceURI, localName, qName, data);
            ImportSpreadsheetReader.mWorksheetCell.data = data.toString();
        }
    }

    class CellHandler
    extends AXSaxUtil.ElementHandler {
        CellHandler() {
            this.handle(ImportSpreadsheetReader.TAG_DATA, new DataHandler());
        }

        public void onStart(String namespaceURI, String localName, String qName, Attributes attr) {
            super.onStart(namespaceURI, localName, qName, attr);
            String styleId = attr.getValue("ss:StyleID");
            String colIndex = attr.getValue("ss:Index");
            long iNum = Long.parseLong(colIndex);
            ImportSpreadsheetReader.this.mColMax = Long.max(iNum, ImportSpreadsheetReader.this.mColMax);
            mWorksheetCell = new SymbolSpreadsheet.WorksheetCell(ImportSpreadsheetReader.mWorksheetRow.rowNum, iNum, styleId, "", "", "");
            ImportSpreadsheetReader.mWorksheetRow.cells.add(mWorksheetCell);
        }

        public void onEnd(String namespaceURI, String localName, String qName, CharArrayWriter data) {
            super.onEnd(namespaceURI, localName, qName, data);
        }
    }

    class RowHandler
    extends AXSaxUtil.ElementHandler {
        RowHandler() {
            this.handle(ImportSpreadsheetReader.TAG_CELL, new CellHandler());
        }

        public void onStart(String namespaceURI, String localName, String qName, Attributes attr) {
            super.onStart(namespaceURI, localName, qName, attr);
            String rowIndex = attr.getValue("ss:Index");
            long iNum = Long.parseLong(rowIndex);
            ImportSpreadsheetReader.this.mRowMax = Long.max(iNum, ImportSpreadsheetReader.this.mRowMax);
            mWorksheetRow = SymbolSpreadsheet.mWorksheet.rows.get(iNum);
            if (mWorksheetRow != null) {
                ALog.logInfo((String)"Duplicate row index %s found in file. It will be discarded.", (Object[])new Object[]{rowIndex});
                return;
            }
            mWorksheetRow = new SymbolSpreadsheet.WorksheetRow(iNum, "60", "0", "");
            SymbolSpreadsheet.mWorksheet.rows.put(iNum, mWorksheetRow);
        }

        public void onEnd(String namespaceURI, String localName, String qName, CharArrayWriter data) {
            super.onEnd(namespaceURI, localName, qName, data);
        }
    }

    class ColHandler
    extends AXSaxUtil.ElementHandler {
        ColHandler() {
        }

        public void onStart(String namespaceURI, String localName, String qName, Attributes attr) {
            super.onStart(namespaceURI, localName, qName, attr);
            String colIndex = attr.getValue("ss:Index");
            long iNum = Long.parseLong(colIndex);
            ImportSpreadsheetReader.this.mColMax = Long.max(iNum, ImportSpreadsheetReader.this.mColMax);
            String colWidth = attr.getValue("ss:Width");
            SymbolSpreadsheet.WorksheetCol wsCol = SymbolSpreadsheet.mWorksheet.cols.get(iNum);
            if (wsCol != null) {
                ALog.logInfo((String)"Duplicate column index %s found in file. It will be discarded.", (Object[])new Object[]{colIndex});
                return;
            }
            wsCol = new SymbolSpreadsheet.WorksheetCol(iNum, colWidth, "0", "");
            SymbolSpreadsheet.mWorksheet.cols.put(iNum, wsCol);
        }

        public void onEnd(String namespaceURI, String localName, String qName, CharArrayWriter data) {
            super.onEnd(namespaceURI, localName, qName, data);
        }
    }

    class TableHandler
    extends AXSaxUtil.ElementHandler {
        TableHandler() {
            this.handle(ImportSpreadsheetReader.TAG_COLUMN, new ColHandler());
            this.handle(ImportSpreadsheetReader.TAG_ROW, new RowHandler());
        }

        public void onStart(String namespaceURI, String localName, String qName, Attributes attr) {
            super.onStart(namespaceURI, localName, qName, attr);
        }

        public void onEnd(String namespaceURI, String localName, String qName, CharArrayWriter data) {
            super.onEnd(namespaceURI, localName, qName, data);
        }
    }

    class WorksheetHandler
    extends AXSaxUtil.ElementHandler {
        WorksheetHandler() {
            this.handle(ImportSpreadsheetReader.TAG_TABLE, new TableHandler());
        }

        public void onStart(String namespaceURI, String localName, String qName, Attributes attr) {
            super.onStart(namespaceURI, localName, qName, attr);
            if (localName.isEmpty() && qName.isEmpty()) {
                return;
            }
            String wsName = attr.getValue("ss:Name");
            SymbolSpreadsheet.mWorksheet = new SymbolSpreadsheet.Worksheet(wsName);
            SymbolSpreadsheet.mWorksheets.put(wsName, SymbolSpreadsheet.mWorksheet);
        }

        public void onEnd(String namespaceURI, String localName, String qName, CharArrayWriter data) {
            super.onEnd(namespaceURI, localName, qName, data);
        }
    }

    class InteriorHandler
    extends AXSaxUtil.ElementHandler {
        InteriorHandler() {
        }

        public void onStart(String namespaceURI, String localName, String qName, Attributes attr) {
            super.onStart(namespaceURI, localName, qName, attr);
            if (localName.isEmpty() && qName.isEmpty()) {
                return;
            }
            String color = attr.getValue("ss:Color");
            mStyle.createInterior("ss:Color", color);
        }

        public void onEnd(String namespaceURI, String localName, String qName, CharArrayWriter data) {
            super.onEnd(namespaceURI, localName, qName, data);
        }
    }

    class StyleHandler
    extends AXSaxUtil.ElementHandler {
        StyleHandler() {
            this.handle(ImportSpreadsheetReader.TAG_INTERIOR, new InteriorHandler());
        }

        public void onStart(String namespaceURI, String localName, String qName, Attributes attr) {
            super.onStart(namespaceURI, localName, qName, attr);
            if (localName.isEmpty() && qName.isEmpty()) {
                return;
            }
            String id = attr.getValue("ss:ID");
            String name = attr.getValue("ss:Name");
            mStyle = new SymbolSpreadsheet.Style(id, name, "");
            if (SymbolSpreadsheet.mStyles == null) {
                SymbolSpreadsheet.mStyles = new HashMap<String, SymbolSpreadsheet.Style>();
            }
            SymbolSpreadsheet.mStyles.put(id, mStyle);
        }

        public void onEnd(String namespaceURI, String localName, String qName, CharArrayWriter data) {
            super.onEnd(namespaceURI, localName, qName, data);
        }
    }
}

