/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AReflection;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.AFileChooserControl;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.ImportSpreadsheetReader;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ImportSymbolSpreadsheetUI {
    public static final String EXCEL_BALL_DIAMETER = "8000";
    public static final String EXCEL_BALL_PITCH = "10000";
    protected static JTextField mDiameter;
    protected static JTextField mPitch;
    protected static String mBallDiameter;
    protected static String mBallPitch;
    protected static JComboBox<String> mPTextCombo;
    protected static JComboBox<String> mSTextCombo;
    protected static String mPTextStr;
    protected static String mSTextStr;
    static final String[] mFieldTextList;
    protected static JComboBox<String> mColorSourceCombo;
    protected static String mColorSource;
    static final String[] mColorSourceList;
    public static final AFileFilter FileFilterXml;

    public static void show(Component owner, Db targetDb, String filePath) {
        mBallDiameter = EXCEL_BALL_DIAMETER;
        mBallPitch = EXCEL_BALL_PITCH;
        SSImportDlg dlg = new SSImportDlg(owner, targetDb, filePath);
        dlg.setVisible(true);
    }

    static {
        mBallDiameter = EXCEL_BALL_DIAMETER;
        mBallPitch = EXCEL_BALL_PITCH;
        mPTextStr = "";
        mSTextStr = "";
        mFieldTextList = new String[]{"None", "Net Name", "Pin Name"};
        mColorSource = "";
        mColorSourceList = new String[]{"None", "Personalities", "Interfaces/Personalities"};
        FileFilterXml = AFileFilter.XML;
    }

    protected static class SSImportDlg
    extends ADialog {
        protected AFileChooserControl mFileChooserControl;
        protected JRadioButton mBtnCurDesign = null;
        protected JRadioButton mBtnNewDesign;
        protected static ActionListener mPTextListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mPTextStr = mPTextCombo.getSelectedItem().toString();
            }
        };
        protected static ActionListener mSTextListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mSTextStr = mSTextCombo.getSelectedItem().toString();
            }
        };
        protected static ActionListener mColorSourceListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mColorSource = mColorSourceCombo.getSelectedItem().toString();
            }
        };
        protected static ActionListener mDiameterListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mBallDiameter = mDiameter.getText();
            }
        };
        protected static FocusListener mDiameterFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                mBallDiameter = mDiameter.getText();
            }
        };
        protected static ActionListener mPitchListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mBallPitch = mPitch.getText();
            }
        };
        protected static FocusListener mPitchFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                mBallPitch = mPitch.getText();
            }
        };

        protected SSImportDlg(Component owner, final Db targetDb, String daFilePath) {
            super(owner, "Import Symbol Spreadsheet", Dialog.ModalityType.DOCUMENT_MODAL);
            int i;
            this.setRecallBounds(false);
            GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
            this.mFileChooserControl = new AFileChooserControl();
            this.mFileChooserControl.setPath(daFilePath);
            this.mFileChooserControl.addChoosableFileFilter(FileFilterXml);
            l.add("File:");
            if (this.getFile() == null || !this.getFile().canRead()) {
                l.add((Component)this.mFileChooserControl, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            } else {
                l.add(this.getFile().getName()).setToolTipText(this.getFile().getAbsolutePath());
            }
            l.newline();
            this.mBtnNewDesign = new JRadioButton("A new design");
            if (targetDb != null) {
                l.push("Into", (GridBagConstraints)GridBagManager.LEFT_REMAINX);
                String curDesignName = targetDb.getFile() == null ? String.format("Unsaved Design %d", targetDb.getId()) : targetDb.getUserName();
                this.mBtnCurDesign = (JRadioButton)l.add((Component)new JRadioButton(String.format("The current design ('%s')", curDesignName)), (GridBagConstraints)GridBagManager.LEFT.insetVert(0));
                l.newline();
                l.add((Component)this.mBtnNewDesign, (GridBagConstraints)GridBagManager.LEFT.insetVert(0));
                l.addFillX();
                UIUtil.groupButtons((AbstractButton[])new AbstractButton[]{this.mBtnCurDesign, this.mBtnNewDesign});
                l.popNl();
            }
            if (this.mBtnCurDesign != null) {
                this.mBtnCurDesign.setSelected(true);
            } else {
                this.mBtnNewDesign.setSelected(true);
            }
            l.push("Cell data", (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            l.add("Primary Text:", (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            mPTextCombo = new JComboBox();
            l.add(mPTextCombo, (GridBagConstraints)GridBagManager.LEFT);
            for (i = 0; i < mFieldTextList.length; ++i) {
                if (mFieldTextList[i].equals("None")) continue;
                mPTextCombo.addItem(mFieldTextList[i]);
            }
            mPTextStr = mPTextCombo.getSelectedItem().toString();
            mPTextCombo.addActionListener(mPTextListener);
            l.add("Secondary Text: ", (GridBagConstraints)GridBagManager.RIGHT);
            mSTextCombo = new JComboBox();
            l.addNl(mSTextCombo, (GridBagConstraints)GridBagManager.LEFT);
            for (i = 0; i < mFieldTextList.length; ++i) {
                mSTextCombo.addItem(mFieldTextList[i]);
            }
            mSTextStr = mSTextCombo.getSelectedItem().toString();
            mSTextCombo.addActionListener(mSTextListener);
            l.add("Color Source:", (GridBagConstraints)GridBagManager.LEFT);
            mColorSourceCombo = new JComboBox();
            l.addNl(mColorSourceCombo, (GridBagConstraints)GridBagManager.LEFT);
            for (i = 0; i < mColorSourceList.length; ++i) {
                mColorSourceCombo.addItem(mColorSourceList[i]);
            }
            mColorSource = mColorSourceCombo.getSelectedItem().toString();
            mColorSourceCombo.addActionListener(mColorSourceListener);
            l.add("Ball Diameter:");
            mDiameter = new JTextField(ImportSymbolSpreadsheetUI.EXCEL_BALL_DIAMETER, 10);
            l.add((Component)mDiameter, (GridBagConstraints)GridBagManager.FILLX);
            mDiameter.addActionListener(mDiameterListener);
            mDiameter.addFocusListener(mDiameterFocusListener);
            l.add("Ball Pitch:");
            mPitch = new JTextField(ImportSymbolSpreadsheetUI.EXCEL_BALL_PITCH, 10);
            l.add((Component)mPitch, (GridBagConstraints)GridBagManager.FILLX);
            mPitch.addActionListener(mPitchListener);
            mPitch.addFocusListener(mPitchFocusListener);
            l.addFillY();
            l.popNl();
            l.push((GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
            l.addFillX();
            JButton btnOk = (JButton)l.add((Component)new JButton("OK"));
            JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
            l.pop();
            this.pack();
            UIUtil.center((Component)((Object)this));
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOk);
            btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        AFieldValidator.validateFileExists((JTextField)mFileChooserControl.getTextField());
                    }
                    catch (AFieldValidator.AFieldValidationException fve) {
                        return;
                    }
                    if (mBtnNewDesign.isSelected()) {
                        Design design = OrbitIO.getApp().createDesign().orElse(null);
                        if (design == null) {
                            ALog.logError((String)"Error creating a new design.");
                            return;
                        }
                    } else if (OrbitIO.getCurDb() != targetDb) {
                        Cp.exec((String)"OrbitIO.setCurrentDb(\"%s\")", (Object[])new Object[]{OrbitIO.getApp().getDbId(targetDb)});
                        if (OrbitIO.getCurDb() != targetDb) {
                            ALog.logError((String)"Unable to set target database '%s' as current database, the database may not be open.", (Object[])new Object[]{targetDb});
                            return;
                        }
                    }
                    Cp.exec((String)"unset(\"_isReader\")", (Object[])new Object[0]);
                    Cp.exec((String)"_isReader = new %s(curDb(), %s, \"%s\",\"%s\",\"%s\", \"%s\", \"%s\")", (Object[])new Object[]{AReflection.getJavaClassName(ImportSpreadsheetReader.class), Cp.getFileAsArgument((String)mFileChooserControl.getPath()), mPTextStr, mSTextStr, mColorSource, mBallDiameter, mBallPitch});
                    Object result = Cp.exec((String)"_isReader.read()", (Object[])new Object[0]);
                    Cp.exec((String)"unset(\"_isReader\")", (Object[])new Object[0]);
                    if (result != null && ((Boolean)result).booleanValue()) {
                        UIUtil.closeWindow((Window)((Object)this));
                    }
                }
            });
        }

        protected File getFile() {
            String path = this.mFileChooserControl.getPath();
            if (path == null || path.isEmpty()) {
                return null;
            }
            File file = new File(path);
            if (file.isFile() && file.canRead()) {
                return file;
            }
            return null;
        }
    }
}

