/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AColor;
import com.sigrity.acl.ACsvReader;
import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.ATriple;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.app.ViewAdapter;
import com.sigrity.acl.app.ViewListener;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbFieldDef;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.DbRelationDef;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.Selector;
import com.sigrity.acl.db.Selectors;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.DbObjectRatio;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Floorplan;
import com.sigrity.acl.db.std.FloorplanPin;
import com.sigrity.acl.db.std.Interface;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PersonalityMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.dbui.MovingSet;
import com.sigrity.acl.edaMgrs.HConnEngine;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.geom.GOD;
import com.sigrity.acl.ui.AColorChooserDlg;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.AHorizDivider;
import com.sigrity.acl.ui.AMenuUtil;
import com.sigrity.acl.ui.ASplitPane;
import com.sigrity.acl.ui.ATreeUtil;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.xml.AXDomUtil;
import com.sigrity.orbit.DesignSettings;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.DiffPairFinder;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.HierPinT;
import com.sigrity.orbit.HierPinTempWithNetAndInterface;
import com.sigrity.orbit.HierPort;
import com.sigrity.orbit.InterfaceCmds;
import com.sigrity.orbit.InterfaceStatus;
import com.sigrity.orbit.NetGraphPanel;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.OrbitIOSettings;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.automation.BundleMover;
import com.sigrity.orbit.cmd.NetCmd;
import com.sigrity.orbit.ui.ColumnsAutoSizer;
import com.sigrity.orbit.ui.DbObjectListPanel;
import com.sigrity.orbit.ui.FloorplanUI;
import com.sigrity.orbit.ui.GetObjectsChooserDlg;
import com.sigrity.orbit.ui.Globber;
import com.sigrity.orbit.ui.InterfaceCloneUI;
import com.sigrity.orbit.ui.InterfaceUI;
import com.sigrity.orbit.ui.OrbitGuiObjectActionRegistry;
import com.sigrity.orbit.ui.PersonalityUI;
import com.sigrity.orbit.ui.RulesRatioPanel;
import com.sigrity.orbit.ui.canvas_modes.GeometryDrawerMode;
import com.sigrity.orbit.ui.canvas_modes.InteractiveSelectMode;
import com.sigrity.orbit.ui.canvas_modes.InteractiveSelectionUI;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import com.sigrity.orbit.ui.intf.InterfaceRenderer;
import com.sigrity.orbit.ui.intf.IntfTreeNode;
import com.sigrity.orbit.ui.settings.SettingsUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InterfaceTreeUI
extends DbDialog {
    public static final Icon ICON_FLOORPLAN = UIUtil.getIcon(InterfaceTreeUI.class, (String)"res/iconFloorplan.png");
    public static final int INTERFACE_ICON_SIZE = 16;
    public static final String IMPORT_CSV_FILE = "importCSVFileName";
    public static final String RESTRICT_TO_PARENT = "FloorplanPinsRestrictToParent";
    private static InterfaceTreeUI theInterfaceTreeUI = null;
    private static Floorplan mTemporaryGlobbingFloorplan = null;
    private static LinkedList<PinTemplate> mPinTempsWithTemporaryFpPins = null;
    static WeakHashMap<Db, InterfaceTreeUI> mUIs;
    protected JTree mTree = null;
    protected IntfTreeNode mRoot = null;
    protected DefaultTreeModel mTreeModel = null;
    protected JLabel mInformationLabel = null;
    protected JScrollPane mScrollPane = null;
    protected InterfaceNetsPanel mInterfaceNetsPanel = null;
    protected FloorplanPanel mFloorplanPanel = null;
    protected GeometryDrawerMode mInterfacePinGeometryMode = null;
    protected boolean doingGlobbing = false;
    protected int mColumnWidth = 1;
    protected int mDesireWidth = 16;
    protected int mDesiredHeight = 600;
    protected String mUserLimitSubst = null;
    protected String mLimitSubst = null;
    protected IntfTreeNode mParentNode = null;
    protected TreePath mMainSelectedPath = null;
    protected GeometryDrawerMode.Mode mIntfMode = null;
    protected GeometryDrawerMode.Mode mUserSelectedIntfMode = null;
    protected boolean mUserSelectedIntfModeActive = false;
    protected String mAreaMode = Selection.AreaMode.Contain.toString();
    protected boolean mAllowStealing = false;
    protected boolean mUseIOPads = false;
    protected boolean mHasPins = false;
    protected DesignView2D.ViewMode mPrevMode = null;
    protected boolean mEditsEffectDecendents = true;
    protected JCheckBox mEditsEffectDecendentsCheckbox = null;
    protected ColumnsAutoSizer mColSizer = ColumnsAutoSizer.create().setDistributeExcessToLastCol(true);
    protected Interface mEditedNode = null;
    protected Interface mSelectedInterface = null;
    protected Floorplan mSelectedFloorplan = null;
    boolean mPinsInDecendentsNotBeingGlobbed = false;
    protected List<DbObject> mSubstratePersonalities = null;
    protected HistoryListener mHL = null;
    protected boolean mDisableModeChange = false;
    protected boolean mChangingDbObjects = false;
    public static final Color ColorOk;
    public static final Color ColorWarn;
    public static final Color ColorErr;
    public static final Color ColorInherit;
    public static final Color ColorOkSelected;
    public static final Color ColorWarnSelected;
    public static final Color ColorErrSelected;
    public static final Color ColorInheritSelected;
    public static final Color ColorWhiteSelected;
    boolean rePopulatingTree = false;
    DesignView2D.ViewModeListener mViewModeListener = new DesignView2D.ViewModeListener(){

        @Override
        public boolean settingMode(DesignView2D.ViewMode newMode) {
            return true;
        }

        @Override
        public void setMode(DesignView2D.ViewMode newMode) {
            if (newMode != null) {
                InterfaceTreeUI.this.doingGlobbing = newMode.getName().equals("Globber");
                InterfaceTreeUI.this.mUserSelectedIntfModeActive = newMode.getName().contains("Edit pins of floorplan");
            }
        }
    };
    protected Interface mGlobbingPartialFloorplan = null;
    protected static boolean mRepolulateDisabled;
    protected boolean repolulateScheduled = false;
    protected DbClass.DbObjectListener mDbObjectsListener = new DbClass.DbObjectAdapter(){

        public void removedObject(DbClass.ObjectRemove e) {
            InterfaceTreeUI.scheduleRepopulateTree();
        }

        public boolean removingObject(DbClass.ObjectRemove e) {
            InterfaceTreeUI.scheduleRepopulateTree();
            return true;
        }

        public void changedObject(DbClass.ObjectChange e) {
            InterfaceTreeUI.scheduleRepopulateTree();
        }

        public void addedObject(DbClass.ObjectAdd e) {
            if (!InterfaceTreeUI.this.mChangingDbObjects) {
                InterfaceTreeUI.scheduleRepopulateTree();
                InterfaceTreeUI.this.setupRelationListener(e.getDbObject().getDb());
            }
        }
    };
    protected DbClass.DbObjectListener mFloorplansListener = new DbClass.DbObjectAdapter(){

        public void addedObject(DbClass.ObjectAdd e) {
            if (!InterfaceTreeUI.this.mChangingDbObjects) {
                InterfaceTreeUI.this.mChangingDbObjects = true;
                InterfaceTreeUI.this.setupRelationListener(e.getDbObject().getDb());
                InterfaceTreeUI.this.mChangingDbObjects = false;
            }
        }
    };
    protected static LinkedList<TempMoveNet> listOfTempMovedNets;
    protected static LinkedList<TempMovePin> listOfTempMovedPins;
    protected TreeSelectionListener mSelectionChanged = new TreeSelectionListener(){
        private boolean inValueChanged = false;

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void valueChanged(TreeSelectionEvent e) {
            boolean multipleFloorplansSelected;
            int numSelectedFloorplans;
            block31: {
                IntfTreeNode parentNode;
                int n;
                DeviceTemplate parentTemplate;
                block26: {
                    TreePath newPath;
                    boolean enableSwapFloorplans;
                    block29: {
                        int n2;
                        TreePath[] treePathArray;
                        block30: {
                            block27: {
                                int numSelectedInterfaces;
                                block28: {
                                    if (this.inValueChanged) {
                                        return;
                                    }
                                    this.inValueChanged = true;
                                    numSelectedFloorplans = InterfaceTreeUI.this.getNumFloorplansSelected(InterfaceTreeUI.this.mTree.getSelectionModel());
                                    numSelectedInterfaces = InterfaceTreeUI.this.getNumInterfacesSelected(InterfaceTreeUI.this.mTree.getSelectionModel());
                                    enableSwapFloorplans = false;
                                    multipleFloorplansSelected = false;
                                    if (!e.isAddedPath() || InterfaceTreeUI.this.mTree.getSelectionModel().getSelectionCount() <= 1) break block27;
                                    newPath = e.getPath();
                                    if (numSelectedFloorplans <= 1 || numSelectedInterfaces != 0) break block28;
                                    multipleFloorplansSelected = true;
                                    if (numSelectedFloorplans != 2) break block29;
                                    parentTemplate = null;
                                    treePathArray = InterfaceTreeUI.this.mTree.getSelectionModel().getSelectionPaths();
                                    n2 = treePathArray.length;
                                    break block30;
                                }
                                if (numSelectedInterfaces == 1) {
                                    numSelectedFloorplans = 0;
                                    parentTemplate = InterfaceTreeUI.this.mTree.getSelectionModel().getSelectionPaths();
                                    n = ((TreePath[])parentTemplate).length;
                                    break block26;
                                } else {
                                    InterfaceTreeUI.this.mMainSelectedPath = null;
                                    LinkedList<TreePath> intfPaths = new LinkedList<TreePath>();
                                    for (TreePath path : InterfaceTreeUI.this.mTree.getSelectionModel().getSelectionPaths()) {
                                        IntfTreeNode parentNode2 = (IntfTreeNode)path.getLastPathComponent();
                                        if (parentNode2 == null || !(parentNode2.getUserObject() instanceof Interface)) continue;
                                        if (InterfaceTreeUI.this.mMainSelectedPath == null) {
                                            InterfaceTreeUI.this.mMainSelectedPath = path;
                                        }
                                        intfPaths.add(path);
                                        Floorplan.setHighlightedObject((DbObject)((Interface)parentNode2.getUserObject()));
                                    }
                                    InterfaceTreeUI.this.mTree.getSelectionModel().clearSelection();
                                    Iterator iterator = intfPaths.iterator();
                                    while (true) {
                                        if (!iterator.hasNext()) {
                                            InterfaceTreeUI.this.mInterfaceNetsPanel.removeColumns();
                                            InterfaceTreeUI.this.mInterfaceNetsPanel.setVisible(false);
                                            InterfaceTreeUI.this.mFloorplanPanel.setVisible(false);
                                            InterfaceTreeUI.this.mInformationLabel.setText(numSelectedInterfaces + " interfaces selected.");
                                            this.inValueChanged = false;
                                            OrbitApp.getApp().refreshCurrentView(false);
                                            return;
                                        }
                                        TreePath path = (TreePath)iterator.next();
                                        InterfaceTreeUI.this.mTree.getSelectionModel().addSelectionPath(path);
                                    }
                                }
                            }
                            InterfaceTreeUI.this.mMainSelectedPath = InterfaceTreeUI.this.mTree.getSelectionModel().getSelectionPath();
                            break block31;
                        }
                        for (int i = 0; i < n2; ++i) {
                            TreePath path = treePathArray[i];
                            parentNode = (IntfTreeNode)path.getLastPathComponent();
                            if (parentNode != null && parentNode.getUserObject() instanceof Floorplan && parentTemplate == null) {
                                Floorplan.setHighlightedObject((DbObject)((Floorplan)parentNode.getUserObject()));
                                parentTemplate = ((Floorplan)parentNode.getUserObject()).getDeviceTemplate();
                                continue;
                            }
                            if (parentNode == null || !(parentNode.getUserObject() instanceof Floorplan) || parentTemplate != ((Floorplan)parentNode.getUserObject()).getDeviceTemplate()) continue;
                            Floorplan.setHighlightedObject((DbObject)((Floorplan)parentNode.getUserObject()));
                            enableSwapFloorplans = true;
                        }
                    }
                    if (enableSwapFloorplans) break block31;
                    parentNode = (IntfTreeNode)newPath.getLastPathComponent();
                    break block31;
                }
                for (int i = 0; i < n; ++i) {
                    TreePath path = parentTemplate[i];
                    parentNode = (IntfTreeNode)path.getLastPathComponent();
                    if (parentNode == null || !(parentNode.getUserObject() instanceof Interface)) continue;
                    InterfaceTreeUI.this.mTree.getSelectionModel().clearSelection();
                    InterfaceTreeUI.this.mTree.getSelectionModel().setSelectionPath(path);
                    InterfaceTreeUI.this.mMainSelectedPath = path;
                    Floorplan.setHighlightedObject((DbObject)((Interface)parentNode.getUserObject()));
                    break;
                }
            }
            if (!multipleFloorplansSelected) {
                Floorplan.setHighlightedObject(null);
            }
            IntfTreeNode treeNode = null;
            TreePath leadSelPath = e.getNewLeadSelectionPath();
            InterfaceTreeUI.this.mSelectedInterface = null;
            InterfaceTreeUI.this.mSelectedFloorplan = null;
            InterfaceTreeUI.this.mSubstratePersonalities = null;
            InterfaceTreeUI.this.mInterfaceNetsPanel.resetStatus();
            if (leadSelPath == null) {
                InterfaceTreeUI.this.mInformationLabel.setText("Nothing selected");
            } else {
                treeNode = (IntfTreeNode)leadSelPath.getLastPathComponent();
                Object pathStr = InterfaceTreeUI.getInterfacePathString(treeNode.getParent());
                pathStr = pathStr != null && ((String)pathStr).length() > 0 ? (String)pathStr + "/" + Interface.nameFromToString((String)treeNode.toString()) : (String)pathStr + Interface.nameFromToString((String)treeNode.toString());
                if (treeNode != null && treeNode.getUserObject() instanceof Floorplan) {
                    if (numSelectedFloorplans > 1) {
                        InterfaceTreeUI.this.mInterfaceNetsPanel.removeColumns();
                        InterfaceTreeUI.this.mInterfaceNetsPanel.setVisible(false);
                        InterfaceTreeUI.this.mFloorplanPanel.setVisible(false);
                        InterfaceTreeUI.this.mInformationLabel.setText(numSelectedFloorplans + " floorplans selected.");
                        this.inValueChanged = false;
                        OrbitApp.getApp().refreshCurrentView(false);
                        return;
                    }
                    InterfaceTreeUI.this.mSelectedFloorplan = (Floorplan)treeNode.getUserObject();
                    InterfaceTreeUI.this.populateSubstratePersonalities();
                    InterfaceTreeUI.this.mInformationLabel.setText("Selected " + InterfaceTreeUI.this.mSelectedFloorplan.info());
                    Floorplan.setHighlightedObject((DbObject)InterfaceTreeUI.this.mSelectedFloorplan);
                } else {
                    InterfaceTreeUI.this.mSelectedInterface = Interface.find((Db)OrbitIO.getCurDb(), (String)pathStr);
                    if (InterfaceTreeUI.this.mSelectedInterface != null) {
                        InterfaceTreeUI.this.mInformationLabel.setText("Selected " + InterfaceTreeUI.this.mSelectedInterface.info());
                        InterfaceTreeUI.this.mInterfaceNetsPanel.setupArray(InterfaceTreeUI.this.mSelectedInterface);
                        Floorplan.setHighlightedObject((DbObject)InterfaceTreeUI.this.mSelectedInterface);
                    }
                }
            }
            if (InterfaceTreeUI.this.mSelectedInterface == null && InterfaceTreeUI.this.mSelectedFloorplan != null && treeNode != null) {
                IntfTreeNode parentNode = (IntfTreeNode)treeNode.getParent();
                Object obj = parentNode == null ? null : parentNode.getUserObject();
                Interface interface_ = InterfaceTreeUI.this.mSelectedInterface = obj instanceof Interface ? (Interface)obj : null;
            }
            if (InterfaceTreeUI.this.mSelectedInterface == null) {
                InterfaceTreeUI.this.mInterfaceNetsPanel.removeColumns();
                InterfaceTreeUI.this.mInterfaceNetsPanel.setVisible(false);
            } else {
                InterfaceTreeUI.this.mInterfaceNetsPanel.setVisible(true);
                InterfaceTreeUI.this.refreshNetTable();
            }
            InterfaceTreeUI.this.mFloorplanPanel.setVisible(InterfaceTreeUI.this.mSelectedFloorplan != null);
            if (InterfaceTreeUI.this.mSelectedFloorplan != null) {
                InterfaceTreeUI.this.mFloorplanPanel.update();
            }
            if (!InterfaceTreeUI.this.mDisableModeChange) {
                if (InterfaceTreeUI.this.mIntfMode != null && InterfaceTreeUI.this.mSelectedFloorplan == null) {
                    if (InterfaceTreeUI.this.mInterfacePinGeometryMode != null) {
                        InterfaceTreeUI.this.mInterfacePinGeometryMode.cancelDrawingMode();
                    }
                } else if (InterfaceTreeUI.this.mSelectedFloorplan != null && InterfaceTreeUI.this.setupForEditPins() == null && InterfaceTreeUI.this.mInterfacePinGeometryMode != null) {
                    InterfaceTreeUI.this.mInterfacePinGeometryMode.cancelDrawingMode();
                }
            }
            OrbitApp.getApp().refreshCurrentView(false);
            this.inValueChanged = false;
        }
    };
    protected ViewListener mInterfaceViewChangeListener = new ViewAdapter(){

        public void activeViewChanged(AAppView oldView, AAppView newView) {
            if (newView != null) {
                InterfaceTreeUI.setTheInterface(newView.getDb());
            }
        }
    };
    protected static JCheckBoxMenuItem visibleCheckbox;
    protected static JCheckBoxMenuItem useIOPadsCheckbox;
    final Comparator<HierPinTempWithNetAndInterface> PinTempWithNetAndInterfaceSort = (e1, e2) -> {
        if (e1.getInterface() != e2.getInterface()) {
            if (this.mSelectedFloorplan.getMyInterface() == e1.getInterface()) {
                return 1;
            }
            if (this.mSelectedFloorplan.getMyInterface() == e2.getInterface()) {
                return -1;
            }
        }
        if (e1.getNet() == null || e2.getNet() == null) {
            if (e1.getNet() == null) {
                return 1;
            }
            return -1;
        }
        if (e1.getNet().isUnused() && !e2.getNet().isUnused()) {
            return 1;
        }
        if (!e1.getNet().isUnused() && e2.getNet().isUnused()) {
            return -1;
        }
        return 0;
    };
    private List<HierPinTempWithNetAndInterface> mHierPinTempWithNetAndInterface = null;
    private Globber mGlobber = null;
    private MovingSet mGlobberMovingSet = null;

    static InterfaceTreeUI getTheInterfaceTreeUI() {
        return theInterfaceTreeUI;
    }

    private static void registerInterfaceUI() {
        Db.DbListenerAdapter theDbListener = new Db.DbListenerAdapter(){

            public void dbClosing(Db db) {
                InterfaceTreeUI.removeInterfaceUI(db);
                mTemporaryGlobbingFloorplan = null;
                mPinTempsWithTemporaryFpPins = null;
            }
        };
        Db.addDbListener((Db.DbListener)theDbListener);
    }

    static InterfaceTreeUI getTheInterface(Db db) {
        return mUIs.get(db);
    }

    private static boolean removeInterfaceUI(Db db) {
        boolean result;
        boolean bl = result = mUIs.remove(db) != null;
        if (theInterfaceTreeUI != null && theInterfaceTreeUI.getDb() == db) {
            theInterfaceTreeUI = null;
        }
        return result;
    }

    static void setTheInterface(Db db) {
        theInterfaceTreeUI = InterfaceTreeUI.getTheInterface(db);
    }

    public static boolean startGlobber(Db db, String floorplanKeyStr, boolean allowStealing, boolean restrictToParent) {
        return InterfaceTreeUI.startGlobber(db, floorplanKeyStr, allowStealing, restrictToParent, true);
    }

    public static boolean startGlobber(Db db, String floorplanKeyStr, boolean allowStealing, boolean restrictToParent, boolean useIOPads) {
        Floorplan fp = (Floorplan)db.getByKeyStr(Floorplan.class, floorplanKeyStr);
        InterfaceTreeUI.setTheInterface(db);
        if (theInterfaceTreeUI == null) {
            theInterfaceTreeUI = InterfaceTreeUI.createDialog(OrbitIO.getMainWindow(), db);
        }
        InterfaceTreeUI.theInterfaceTreeUI.mDb = db;
        InterfaceTreeUI.theInterfaceTreeUI.mSelectedFloorplan = fp;
        InterfaceTreeUI.theInterfaceTreeUI.mAllowStealing = allowStealing;
        InterfaceTreeUI.theInterfaceTreeUI.mUseIOPads = useIOPads;
        DesignSettings.set((Design)Design.getDesign((Db)db), (String)RESTRICT_TO_PARENT, (Object)restrictToParent);
        return theInterfaceTreeUI.dynamicGlob(fp);
    }

    public static int godBB(List<HierPort> list, boolean reset) {
        if (list == null) {
            return 0;
        }
        GOD.setAutoClose((boolean)false);
        for (HierPort port : list) {
            port.godBB(reset);
            reset = false;
        }
        GOD.setAutoClose((boolean)true);
        GOD.close();
        return list.size();
    }

    public static int godBB(Set<HierPort> list, boolean reset) {
        if (list == null) {
            return 0;
        }
        GOD.setAutoClose((boolean)false);
        for (HierPort port : list) {
            port.godBB(reset);
            reset = false;
        }
        GOD.setAutoClose((boolean)true);
        GOD.close();
        return list.size();
    }

    public static boolean godCenterX(Boolean reset, PinTemplate pin, DevicePath path) {
        boolean ans = false;
        for (PortTemplate port : pin.getPortTemplates()) {
            HierPort hport = new HierPort(path, port);
            if (!hport.godCenterX(reset.booleanValue())) continue;
            ans = true;
        }
        return ans;
    }

    public static void logHash(String str, Set<HierPort> list) {
        ALog.logDebug((String)("---- " + str));
        if (list == null) {
            ALog.logDebug((String)"null");
            return;
        }
        for (HierPort port : list) {
            ALog.logDebug((String)("Port= " + ((PortTemplate)port.getDbObject()).getDbObjId() + " " + port.toString()));
        }
    }

    public static void logList(String str, List<HierPort> list) {
        ALog.logDebug((String)("---- " + str));
        if (list == null) {
            ALog.logDebug((String)"null");
            return;
        }
        for (HierPort port : list) {
            ALog.logDebug((String)("Port= " + ((PortTemplate)port.getDbObject()).getDbObjId() + " " + port.toString()));
        }
    }

    @Deprecated
    public static boolean getRestrictToParent(Db db) {
        return (Boolean)DesignSettings.get((Design)Design.getDesign((Db)db), (String)RESTRICT_TO_PARENT, Boolean.class, (Object)false);
    }

    public static void setEditedNode(Interface newInterface, boolean force) {
        if (theInterfaceTreeUI == null) {
            return;
        }
        if (InterfaceTreeUI.theInterfaceTreeUI.mEditedNode == newInterface) {
            InterfaceTreeUI.theInterfaceTreeUI.mDisableModeChange = true;
        }
        InterfaceTreeUI.theInterfaceTreeUI.mEditedNode = newInterface;
        IntfTreeNode node = InterfaceTreeUI.findUserNode(InterfaceTreeUI.theInterfaceTreeUI.mRoot, InterfaceTreeUI.theInterfaceTreeUI.mEditedNode);
        if (node != null) {
            ((IntfTreeNode)node.getParent()).sort();
            theInterfaceTreeUI.refreshNode(node, false);
        } else if (!InterfaceTreeUI.theInterfaceTreeUI.mChangingDbObjects && newInterface != null && newInterface.getParent() == null) {
            InterfaceTreeUI.scheduleRepopulateTree();
        }
        InterfaceTreeUI.theInterfaceTreeUI.mDisableModeChange = false;
    }

    public void rePopulateTree() {
        if (this.mDb == null || this.mDb.closed()) {
            return;
        }
        this.rePopulatingTree = true;
        ATreeUtil.NodeTextTreeState treeState = ATreeUtil.NodeTextTreeState.from((JTree)this.mTree);
        this.mDisableModeChange = true;
        this.mTree.clearSelection();
        for (int i = 0; i < this.mRoot.getChildCount(); ++i) {
            IntfTreeNode cur = (IntfTreeNode)this.mRoot.getChildAt(i);
            this.mTreeModel.removeNodeFromParent(cur);
        }
        this.mRoot.removeAllChildren();
        this.mTreeModel.reload();
        this.createNodes(this.mRoot);
        this.mTree.expandPath(new TreePath(this.mRoot.getPath()));
        treeState.to(this.mTree);
        this.rePopulatingTree = false;
        this.mDisableModeChange = true;
    }

    public static void setEditedNode(Interface newInterface) {
        InterfaceTreeUI.setEditedNode(newInterface, false);
    }

    public InterfaceTreeUI(Db db, Window owner) {
        super(db, (Component)owner);
    }

    public static InterfaceTreeUI createDialog(Window owner, Db db) {
        InterfaceTreeUI dlg = null;
        if (db == null) {
            return null;
        }
        dlg = InterfaceTreeUI.getTheInterface(db);
        if (dlg == null) {
            dlg = new InterfaceTreeUI(db, owner);
            dlg.init();
            theInterfaceTreeUI = dlg;
        }
        return dlg;
    }

    protected void init() {
        OrbitGuiWS ws;
        mUIs.put(this.getDb(), this);
        this.setTitle("Interface Editor");
        GridBagManager lMain = new GridBagManager(this.getContentPane());
        JSplitPane spMain = (JSplitPane)lMain.add((Component)new ASplitPane(0), (GridBagConstraints)GridBagManager.FILLALL_REMAINX.noInsets());
        JPanel pnlTop = new JPanel();
        spMain.setTopComponent(pnlTop);
        GridBagManager lTop = GridBagManager.layout((Container)pnlTop);
        JPanel pnlTopLeft = new JPanel();
        JPanel pnlTopRight = new JPanel();
        lTop.add((Component)new ASplitPane(1, pnlTopLeft, pnlTopRight), (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        GridBagManager lTopLeft = GridBagManager.layout((Container)pnlTopLeft);
        GridBagManager lTopRight = GridBagManager.layout((Container)pnlTopRight);
        this.mRoot = new IntfTreeNode();
        this.mTreeModel = new DefaultTreeModel(this.mRoot);
        this.mTree = new JTree(this.mTreeModel);
        this.mTree.setEditable(false);
        this.mTree.getSelectionModel().setSelectionMode(4);
        this.mTree.getSelectionModel().addTreeSelectionListener(this.mSelectionChanged);
        this.mTree.setShowsRootHandles(true);
        this.mTree.setRootVisible(false);
        this.mTree.setFocusTraversalKeysEnabled(true);
        this.installTreePopupMenu();
        this.mTree.setCellRenderer(new InterfaceRenderer());
        this.createNodes(this.mRoot);
        this.mTree.expandPath(new TreePath(this.mRoot.getPath()));
        this.mScrollPane = new JScrollPane(this.mTree);
        lTopLeft.addNl((Component)new AHorizDivider("<html><b>Interfaces"), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        lTopLeft.add((Component)this.mScrollPane, (GridBagConstraints)GridBagManager.FILLALL);
        this.mScrollPane.setPreferredSize(new Dimension(200, 250));
        this.mScrollPane.setMinimumSize(new Dimension(150, 100));
        lTopLeft.newline();
        this.mInformationLabel = lTopLeft.add("No interface selected.", (GridBagConstraints)GridBagManager.TOPLEFT);
        this.mFloorplanPanel = new FloorplanPanel();
        lTopRight.add((Component)this.mFloorplanPanel, (GridBagConstraints)GridBagManager.FILLALL.noInsets());
        this.mFloorplanPanel.setVisible(false);
        pnlTopRight.setPreferredSize(new Dimension(300, 320));
        pnlTopRight.setMinimumSize(new Dimension(240, 240));
        JPanel pnlBottom = new JPanel();
        spMain.setBottomComponent(pnlBottom);
        GridBagManager lBottom = GridBagManager.layout((Container)pnlBottom);
        this.mInterfaceNetsPanel = new InterfaceNetsPanel();
        lBottom.add((Component)this.mInterfaceNetsPanel, (GridBagConstraints)GridBagManager.FILLALL.noInsets());
        this.mInterfaceNetsPanel.setVisible(false);
        pnlBottom.setMinimumSize(new Dimension(400, 100));
        pnlBottom.setPreferredSize(new Dimension(400, 300));
        this.mAreaMode = (Boolean)Settings.get((String)"GUI", (String)"SelectFloorplanPinsInside", (Object)true) != false ? Selection.AreaMode.Contain.toString() : Selection.AreaMode.Touch.toString();
        this.mUserSelectedIntfMode = (GeometryDrawerMode.Mode)((Object)Settings.get((String)"GUI", (String)"SelectFloorplanGeometry", (Object)((Object)GeometryDrawerMode.Mode.START_RECTANGLE)));
        this.mUserSelectedIntfModeActive = false;
        this.mAllowStealing = (Boolean)Settings.get((String)"GUI", (String)"SelectFloorplanPinsAllowStealing", (Object)false);
        this.mUseIOPads = (Boolean)Settings.get((String)"GUI", (String)"SelectFloorplanUseIOPads", (Object)false);
        this.mEditsEffectDecendents = (Boolean)Settings.get((String)"GUI", (String)"FloorplanEditsEffectDecendents", (Object)true);
        this.mEditsEffectDecendentsCheckbox.setSelected(this.mEditsEffectDecendents);
        this.pack();
        this.setMinimumSize(this.getMinimumSize());
        UIUtil.center((Component)((Object)this), (boolean)true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                OrbitGuiWS ws;
                if (InterfaceTreeUI.this.mInterfacePinGeometryMode != null) {
                    InterfaceTreeUI.this.mInterfacePinGeometryMode.cancelDrawingMode();
                }
                boolean needToRefresh = Floorplan.getHighlightedObjectList() != null;
                Floorplan.setHighlightedObject(null);
                if (needToRefresh) {
                    OrbitApp.getApp().refreshCurrentView(false);
                }
                InterfaceTreeUI.this.mInterfaceNetsPanel.removeColumns();
                Settings.set((String)"GUI", (String)"SelectFloorplanPinsInside", (Object)InterfaceTreeUI.this.mAreaMode.equals("inside"));
                Settings.set((String)"GUI", (String)"SelectFloorplanGeometry", (Object)((Object)InterfaceTreeUI.this.mUserSelectedIntfMode));
                InterfaceTreeUI.this.mUserSelectedIntfModeActive = false;
                Settings.set((String)"GUI", (String)"SelectFloorplanPinsAllowStealing", (Object)InterfaceTreeUI.this.mAllowStealing);
                Settings.set((String)"GUI", (String)"SelectFloorplanUseIOPads", (Object)InterfaceTreeUI.this.mUseIOPads);
                Settings.set((String)"GUI", (String)"FloorplanEditsEffectDecendents", (Object)InterfaceTreeUI.this.mEditsEffectDecendents);
                Settings.save((String)"GUI");
                InterfaceTreeUI.this.mMainSelectedPath = null;
                OrbitIO oio = OrbitIO.getApp();
                OrbitGuiWS orbitGuiWS = ws = oio == null ? null : oio.getWorkspace();
                if (ws != null) {
                    ws.removeViewListener(InterfaceTreeUI.this.mInterfaceViewChangeListener);
                }
                if (OrbitIO.getCurView() != null) {
                    ((DesignView2D)OrbitIO.getCurView()).removeModeListener(InterfaceTreeUI.this.mViewModeListener);
                }
                mUIs.remove(InterfaceTreeUI.this.getDb());
            }
        });
        Db db = OrbitIO.getCurDb();
        DbHistory h = db.getHistory();
        this.mHL = new HistoryListener();
        h.addListener((DbHistory.Listener)this.mHL);
        DbClass dbc = db.getDbClass(Interface.class);
        dbc.addObjectListener(this.mDbObjectsListener, DbClass.DbObjectEventType.getUpdated());
        dbc = db.getDbClass(FloorplanPin.class);
        if (dbc == null) {
            dbc = db.addDbClass(FloorplanPin.class);
        }
        dbc.addObjectListener(this.mDbObjectsListener, DbClass.DbObjectEventType.getUpdated());
        dbc = db.getDbClass(DbObjectRatio.class);
        if (dbc == null) {
            dbc = db.addDbClass(DbObjectRatio.class);
        }
        dbc.addObjectListener(this.mDbObjectsListener, DbClass.DbObjectEventType.getUpdated());
        DbClass.DbObjectEventType[] personalityEvents = new DbClass.DbObjectEventType[]{DbClass.DbObjectEventType.ADDED, DbClass.DbObjectEventType.REMOVED};
        dbc = db.getDbClass(Personality.class);
        if (dbc == null) {
            dbc = db.addDbClass(Personality.class);
        }
        dbc.addObjectListener(this.mDbObjectsListener, personalityEvents);
        this.setupRelationListener(db);
        OrbitIO oio = OrbitIO.getApp();
        OrbitGuiWS orbitGuiWS = ws = oio == null ? null : oio.getWorkspace();
        if (ws != null) {
            ws.addViewListener(this.mInterfaceViewChangeListener);
        }
        ((DesignView2D)OrbitIO.getCurView()).addModeListener(this.mViewModeListener);
    }

    protected void setGlobbingPartialFloorplan(Interface intf) {
        InterfaceTreeUI.setRepolulateDisabled(intf != null);
        this.mGlobbingPartialFloorplan = intf;
    }

    protected static void setRepolulateDisabled(boolean flag) {
        mRepolulateDisabled = flag;
    }

    protected static void scheduleRepopulateTree() {
        if (mRepolulateDisabled) {
            return;
        }
        if (!InterfaceTreeUI.theInterfaceTreeUI.repolulateScheduled && !InterfaceTreeUI.theInterfaceTreeUI.mChangingDbObjects) {
            InterfaceTreeUI.theInterfaceTreeUI.repolulateScheduled = true;
            EventQueue.invokeLater(() -> {
                if (theInterfaceTreeUI != null) {
                    theInterfaceTreeUI.rePopulateTree();
                    theInterfaceTreeUI.refreshNetsTable();
                    InterfaceTreeUI.theInterfaceTreeUI.repolulateScheduled = false;
                }
            });
        }
    }

    protected void setupRelationListener(Db db) {
        DbRelationDef dbrd = db.getRelation("Floorplan-myInterface");
        if (dbrd != null) {
            dbrd.addRelationListener((DbRelationDef.DbRelationListener)new DbRelationDef.DbRelationAdapter(){

                public void unrelated(DbRelationDef.RelationChange change) {
                    InterfaceTreeUI.scheduleRepopulateTree();
                }

                public void related(DbRelationDef.RelationChange change) {
                    InterfaceTreeUI.scheduleRepopulateTree();
                }
            }, DbRelationDef.RELATION_UPDATED);
        }
    }

    protected Interface editedInterface(DbObject dbo) {
        if (dbo instanceof Interface) {
            return (Interface)dbo;
        }
        if (dbo instanceof Floorplan) {
            return ((Floorplan)dbo).getMyInterface();
        }
        if (dbo instanceof FloorplanPin) {
            return ((FloorplanPin)dbo).getOwner() != null ? ((FloorplanPin)dbo).getOwner().getMyInterface() : null;
        }
        return null;
    }

    public void populateSubstratePersonalities() {
        this.mSubstratePersonalities = Personality.getPersonalities((DeviceTemplate)this.mSelectedFloorplan.getDeviceTemplate(), (Personality.Type)Personality.Type.PORT).collect(Collectors.toCollection(ArrayList::new));
        Collections.sort(this.mSubstratePersonalities, DbObject.CompareKeyStr);
        this.mSubstratePersonalities.add(0, null);
    }

    private IntfTreeNode getSelectedIntfTreeNode(boolean returnRootIfNone) {
        IntfTreeNode parentNode = null;
        TreePath parentPath = this.mMainSelectedPath;
        if (parentPath == null) {
            if (returnRootIfNone) {
                parentNode = this.mRoot;
            }
        } else {
            parentNode = (IntfTreeNode)parentPath.getLastPathComponent();
        }
        return parentNode;
    }

    public String getSelectedInterfaceTreeString() {
        TreePath parentPath = this.mMainSelectedPath;
        if (parentPath == null) {
            return "";
        }
        IntfTreeNode parentNode = (IntfTreeNode)parentPath.getLastPathComponent();
        Object pathStr = InterfaceTreeUI.getInterfacePathString(parentNode.getParent());
        pathStr = pathStr != null && ((String)pathStr).length() > 0 ? (String)pathStr + "/" + Interface.nameFromToString((String)parentNode.toString()) : (String)pathStr + Interface.nameFromToString((String)parentNode.toString());
        return pathStr;
    }

    public IntfTreeNode addObject() {
        IntfTreeNode parentNode = this.getSelectedIntfTreeNode(true);
        return this.addObject(parentNode, true);
    }

    protected int getNumFloorplansSelected(TreeSelectionModel model) {
        int ans = 0;
        for (TreePath path : model.getSelectionPaths()) {
            IntfTreeNode parentNode = (IntfTreeNode)path.getLastPathComponent();
            if (parentNode == null || !(parentNode.getUserObject() instanceof Floorplan)) continue;
            ++ans;
        }
        return ans;
    }

    protected List<Floorplan> getFloorplansSelected(TreeSelectionModel model) {
        ArrayList<Floorplan> ans = new ArrayList<Floorplan>();
        for (TreePath path : model.getSelectionPaths()) {
            IntfTreeNode parentNode = (IntfTreeNode)path.getLastPathComponent();
            if (parentNode == null || !(parentNode.getUserObject() instanceof Floorplan)) continue;
            ans.add((Floorplan)parentNode.getUserObject());
        }
        return ans;
    }

    protected int getNumInterfacesSelected(TreeSelectionModel model) {
        int ans = 0;
        for (TreePath path : model.getSelectionPaths()) {
            IntfTreeNode parentNode = (IntfTreeNode)path.getLastPathComponent();
            if (parentNode == null || !(parentNode.getUserObject() instanceof Interface)) continue;
            ++ans;
        }
        return ans;
    }

    protected List<Interface> getInterfacesSelected(TreeSelectionModel model) {
        ArrayList<Interface> ans = new ArrayList<Interface>();
        for (TreePath path : model.getSelectionPaths()) {
            IntfTreeNode parentNode = (IntfTreeNode)path.getLastPathComponent();
            if (parentNode == null || !(parentNode.getUserObject() instanceof Interface)) continue;
            ans.add((Interface)parentNode.getUserObject());
        }
        return ans;
    }

    protected APair<Integer, ARect> addShowMe(FloorplanPin cur, int cnt, ARect bounds, APair<Integer, ARect> ans) {
        if (ans == null) {
            ans = APair.create((Object)cnt, (Object)bounds);
        }
        for (PinInstance pinInst : AIterableItr.itr((Stream)cur.getPinInstances())) {
            Device device = pinInst.getDevice();
            if (device == null) continue;
            for (DevicePath pinDevPath : device.getHierarchicalInstances()) {
                if (!cur.getDevicePath().isEndOf(pinDevPath)) continue;
                APair aPair = ans;
                Integer n = (Integer)aPair.first;
                aPair.first = (Integer)aPair.first + 1;
                Integer n2 = aPair.first;
                if (ans.second == null) {
                    ans.second = pinInst.getWorldBounds(pinDevPath);
                } else {
                    ((ARect)ans.second).expand(pinInst.getWorldBounds(pinDevPath));
                }
                ShowMeTheWay.addHierPin(new HierPin(pinDevPath, pinInst));
            }
        }
        return ans;
    }

    protected APair<Integer, ARect> showMeAllSelected(Floorplan floorplan, int cnt, ARect bounds) {
        APair<Integer, ARect> ans = APair.create((Object)cnt, (Object)bounds);
        for (FloorplanPin cur : floorplan.getAllDescendantPins()) {
            ans = this.addShowMe(cur, (Integer)ans.first, (ARect)ans.second, ans);
        }
        return ans;
    }

    protected APair<Integer, ARect> showMeAllSelected() {
        APair<Integer, ARect> ans = APair.create((Object)0, null);
        for (TreePath path : this.mTree.getSelectionModel().getSelectionPaths()) {
            IntfTreeNode parentNode = (IntfTreeNode)path.getLastPathComponent();
            if (parentNode != null && parentNode.getUserObject() instanceof Floorplan) {
                ans = this.showMeAllSelected((Floorplan)parentNode.getUserObject(), (Integer)ans.first, (ARect)ans.second);
                continue;
            }
            if (parentNode == null || !(parentNode.getUserObject() instanceof Interface)) continue;
            for (Floorplan floorplan : ((Interface)parentNode.getUserObject()).getFloorplans()) {
                ans = this.showMeAllSelected(floorplan, (Integer)ans.first, (ARect)ans.second);
            }
        }
        return ans;
    }

    protected APair<Integer, ARect> showMeAndZoomNear(InterfaceStatus.StatusEntry mEntry, Floorplan floorplan, APair<Integer, ARect> ans) {
        if (mEntry == null) {
            ans = this.showMeAllSelected();
        } else {
            for (FloorplanPin cur : this.mInterfaceNetsPanel.getInterfaceStatus().listOfFPPins(mEntry, floorplan)) {
                ans = this.addShowMe(cur, 0, null, ans);
            }
        }
        return ans;
    }

    private static void addPinTemplateToList(PinTemplate pinTmp) {
        if (mPinTempsWithTemporaryFpPins == null) {
            mPinTempsWithTemporaryFpPins = new LinkedList();
        }
        if (!mPinTempsWithTemporaryFpPins.contains(pinTmp)) {
            mPinTempsWithTemporaryFpPins.add(pinTmp);
        }
    }

    public static void setTemporaryGlobbingFloorplan(Floorplan fp) {
        mTemporaryGlobbingFloorplan = fp;
    }

    public static void restoreOriginalPinOwnersIfNecessary(boolean andRemoveNets) {
        if (mTemporaryGlobbingFloorplan == null) {
            return;
        }
        for (FloorplanPin fpPin : AUtil.linkedList((Iterator)mTemporaryGlobbingFloorplan.getPins())) {
            fpPin.setOwner(mTemporaryGlobbingFloorplan.getParentFloorplan());
        }
        if (mPinTempsWithTemporaryFpPins != null) {
            for (PinTemplate pinTmp : mPinTempsWithTemporaryFpPins) {
                pinTmp.restoreOriginalPinOwners();
            }
        }
        InterfaceTreeUI.moveTemporaryNetsBack();
    }

    public static void temporarlyMovePin(Db db, String pinKeyString, String toInterfaceStr) {
        FloorplanPin pin = (FloorplanPin)db.getByKeyStr(FloorplanPin.class, pinKeyString);
        pin.getPinTemplate().storeOriginalPinOwner(pin.getOwner(), pin.getDevicePath());
        if (listOfTempMovedPins == null) {
            listOfTempMovedPins = new LinkedList();
        }
        TempMovePin tmp = new TempMovePin(db, pinKeyString, toInterfaceStr);
        listOfTempMovedPins.add(tmp);
    }

    public static void temporarlyMoveNet(Db db, String netKeyString, String fromInterfaceStr, String toInterfaceStr, String floorplanPinKeyStr, String floorplanKeyStr) {
        if (floorplanPinKeyStr.length() > 0 && floorplanKeyStr.length() > 0) {
            FloorplanPin floorplanPin = (FloorplanPin)db.getByKeyStr(FloorplanPin.class, floorplanPinKeyStr);
            Floorplan floorplan = (Floorplan)db.getByKeyStr(Floorplan.class, floorplanKeyStr);
            if (floorplanPin != null && floorplan != null) {
                floorplanPin.setOwner(floorplan);
            }
        }
        if (listOfTempMovedNets == null) {
            listOfTempMovedNets = new LinkedList();
        }
        TempMoveNet tmp = new TempMoveNet(db, netKeyString, fromInterfaceStr, toInterfaceStr);
        listOfTempMovedNets.add(tmp);
    }

    public static void moveTemporaryNetsBack() {
        if (listOfTempMovedNets == null) {
            if (listOfTempMovedPins != null) {
                for (TempMovePin tmp : listOfTempMovedPins) {
                    tmp.moveBack();
                }
            }
            listOfTempMovedPins = null;
            return;
        }
        for (TempMoveNet tmp : listOfTempMovedNets) {
            tmp.moveBack();
        }
        listOfTempMovedNets = null;
    }

    protected boolean allowPartialGlobbing(int curRow, int column, InterfaceStatus interfaceStatus, JTable table) {
        Floorplan floorplan = null;
        boolean pickedRowSelected = false;
        for (int row : table.getSelectedRows()) {
            FloorplanPin pin;
            if (row == curRow) {
                pickedRowSelected = true;
            }
            if ((pin = interfaceStatus.getAPin(row, column)) == null) continue;
            if (floorplan == null) {
                floorplan = pin.getOwner();
                continue;
            }
            if (floorplan == pin.getOwner()) continue;
            return false;
        }
        FloorplanPin pin = interfaceStatus.getAPin(curRow, column);
        return pin == null || pickedRowSelected || floorplan == null || floorplan == pin.getOwner();
    }

    private void processRow(int row, Interface temporaryInterface, InterfaceStatus status, String interfaceName, String tempInterfaceName, int curColumn) {
        if (status.getHasExplicitNets()) {
            Floorplan fp = temporaryInterface.getFloorplan(temporaryInterface.getParent().getInterfaceStatus().getHasExplicitNets() ? curColumn - 1 : curColumn);
            Net net = status.getIntefaceNet(row);
            FloorplanPin pin = status.getAPin(row, curColumn);
            String pinStr = "";
            if (pin != null) {
                pinStr = pin.getKeyStr();
            }
            Cp.exec((String)("com.sigrity.orbit.ui.InterfaceTreeUI.temporarlyMoveNet(curDb(), \"" + net.getKeyStr() + "\", \"" + interfaceName + "\", \"" + tempInterfaceName + "\", \"" + pinStr + "\", \"" + fp.getKeyStr() + "\")"), (Object[])new Object[0]);
        } else {
            FloorplanPin pin = status.getAPin(row, curColumn);
            Cp.exec((String)("com.sigrity.orbit.ui.InterfaceTreeUI.temporarlyMovePin(curDb(), \"" + pin.getKeyStr() + "\", \"" + tempInterfaceName + "\")"), (Object[])new Object[0]);
        }
    }

    public static InterfaceTreeUI storeOriginalFPsForPins(Db db, String floorplanStr) {
        Floorplan floorplan = (Floorplan)db.getByKeyStr(Floorplan.class, floorplanStr);
        LinkedList pins = floorplan.getAllDescendantPins(true);
        for (FloorplanPin fpPin : pins) {
            fpPin.getPinTemplate().storeOriginalPinOwner(fpPin.getOwner(), fpPin.getDevicePath());
            InterfaceTreeUI.addPinTemplateToList(fpPin.getPinTemplate());
        }
        if (theInterfaceTreeUI == null) {
            theInterfaceTreeUI = InterfaceTreeUI.createDialog(OrbitIO.getMainWindow(), db);
        }
        InterfaceTreeUI.theInterfaceTreeUI.mDb = db;
        InterfaceTreeUI.theInterfaceTreeUI.mAllowStealing = false;
        InterfaceTreeUI.theInterfaceTreeUI.mUseIOPads = false;
        return theInterfaceTreeUI;
    }

    public void prepareForPartialGlobbing(Db db, String tempIntfStr, String floorplanStr) {
        Interface temporaryInterface = (Interface)db.getByKeyStr(Interface.class, tempIntfStr);
        Floorplan floorplan = (Floorplan)db.getByKeyStr(Floorplan.class, floorplanStr);
        this.mSelectedFloorplan = temporaryInterface.getFloorplan(floorplan.getDeviceTemplate(), false);
        InterfaceTreeUI.setTemporaryGlobbingFloorplan(this.mSelectedFloorplan);
        floorplan.getMyInterface().resetInterfaceStatus();
    }

    public void globSelectedNets(Floorplan floorplan, JTable table, int numRows, int curRow, int curColumn, boolean pickedRowSelected) {
        InterfaceTreeUI.setRepolulateDisabled(true);
        String interfaceName = floorplan.getMyInterface().toStringPath();
        String tempInterfaceName = interfaceName + "/TemporaryInterfaceForPartialGlobbing";
        InterfaceStatus status = floorplan.getMyInterface().getInterfaceStatus();
        try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)floorplan.getDb(), (String)"Glob Partial Floorplan");){
            Cp.exec((String)("_temporaryInterface = com.sigrity.acl.db.std.Interface.getOrCreate(curDb(), \"" + tempInterfaceName + "\", false)"), (Object[])new Object[0]);
            Interface temporaryInterface = Interface.getOrCreate((Db)floorplan.getDb(), (String)tempInterfaceName, (boolean)false);
            Cp.exec((String)("com.sigrity.acl.db.std.Interface.setColorFromString(curDb(), \"" + temporaryInterface.toStringPath() + "\", \"" + AUtil.colorToString((Color)AColor.getComplementary((Color)temporaryInterface.getParent().getColor())) + "\");"), (Object[])new Object[0]);
            this.setGlobbingPartialFloorplan(temporaryInterface);
            Cp.exec((String)("com.sigrity.acl.db.std.Interface.setCount(curDb(), \"" + tempInterfaceName + "\", " + numRows + ")"), (Object[])new Object[0]);
            Cp.exec((String)("_theInterfaceTreeUI = com.sigrity.orbit.ui.InterfaceTreeUI.storeOriginalFPsForPins(curDb(), \"" + floorplan.getKeyStr() + "\")"), (Object[])new Object[0]);
            for (int row : table.getSelectedRows()) {
                this.processRow(row, temporaryInterface, status, interfaceName, tempInterfaceName, curColumn);
            }
            if (!pickedRowSelected) {
                this.processRow(curRow, temporaryInterface, status, interfaceName, tempInterfaceName, curColumn);
            }
            Cp.exec((String)("_theInterfaceTreeUI.prepareForPartialGlobbing(curDb(), \"" + temporaryInterface.getKeyStr() + "\", \"" + floorplan.getKeyStr() + "\")"), (Object[])new Object[0]);
        }
        Cp.exec((String)("com.sigrity.orbit.ui.InterfaceTreeUI.startGlobber(curDb(), \"" + this.mSelectedFloorplan.getKeyStr() + "\", false, true, false);"), (Object[])new Object[0]);
    }

    public static String getInterfacePathString(TreeNode node) {
        if (node == null) {
            return null;
        }
        if (node.getParent() == null) {
            return Interface.nameFromToString((String)node.toString());
        }
        String parentStr = InterfaceTreeUI.getInterfacePathString(node.getParent());
        if (parentStr.length() > 0) {
            return parentStr + "/" + Interface.nameFromToString((String)node.toString());
        }
        return Interface.nameFromToString((String)node.toString());
    }

    public void expandAll(boolean expand) {
        if (expand) {
            ATreeUtil.expandAll((JTree)InterfaceTreeUI.theInterfaceTreeUI.mTree);
        } else {
            ATreeUtil.compressAll((JTree)InterfaceTreeUI.theInterfaceTreeUI.mTree, (boolean)false);
        }
    }

    private IntfTreeNode addObject(IntfTreeNode parent, boolean shouldBeVisible) {
        Object pathStr;
        if (parent == null) {
            parent = this.mRoot;
        }
        pathStr = (pathStr = InterfaceTreeUI.getInterfacePathString(parent.getParent())) != null && ((String)pathStr).length() > 0 ? (String)pathStr + "/" + Interface.nameFromToString((String)parent.toString()) : (String)pathStr + Interface.nameFromToString((String)parent.toString());
        this.mChangingDbObjects = true;
        if (parent.getParent() == null) {
            Cp.exec((String)"com.sigrity.orbit.ui.InterfaceTreeUI.setEditedNode(com.sigrity.acl.db.std.Interface.createDefaultRoot(curDb()));", (Object[])new Object[0]);
        } else {
            Cp.exec((String)("com.sigrity.orbit.ui.InterfaceTreeUI.setEditedNode(com.sigrity.acl.db.std.Interface.createDefault(curDb(), \"" + (String)pathStr + "\"));"), (Object[])new Object[0]);
        }
        this.mChangingDbObjects = false;
        this.setupRelationListener(this.mEditedNode.getDb());
        IntfTreeNode childNode = new IntfTreeNode(this.mEditedNode);
        this.mTreeModel.insertNodeInto(childNode, parent, parent.getChildCount());
        if (shouldBeVisible) {
            this.addFloorplans(childNode, this.mEditedNode, true);
            TreePath path = new TreePath(childNode.getPath());
            this.mTree.setSelectionPath(path);
            this.mMainSelectedPath = path;
            this.mTree.scrollPathToVisible(path);
        }
        InterfaceTreeUI.scheduleRepopulateTree();
        this.editSelectedNode();
        return childNode;
    }

    public void chooseColor(Color c) {
        IntfTreeNode parentNode = this.getSelectedIntfTreeNode(true);
        String pathStr = InterfaceTreeUI.getInterfacePathString(parentNode);
        if (parentNode != null && parentNode.getParent() != null) {
            this.mChangingDbObjects = true;
            Cp.exec((String)("com.sigrity.orbit.ui.InterfaceTreeUI.setEditedNode(com.sigrity.acl.db.std.Interface.setColorFromString(curDb(), \"" + pathStr + "\", \"" + AUtil.colorToString((Color)c) + "\"));"), (Object[])new Object[0]);
            this.mChangingDbObjects = false;
            OrbitApp.getApp().refreshCurrentView(false);
        }
    }

    public void refreshNode(IntfTreeNode editedNode, boolean andChildren) {
        if (andChildren) {
            for (int i = 0; i < editedNode.getChildCount(); ++i) {
                IntfTreeNode cur = (IntfTreeNode)editedNode.getChildAt(i);
                this.refreshNode(cur, false);
            }
        }
        TreePath path = new TreePath(editedNode.getPath());
        this.mTree.scrollPathToVisible(path);
        this.mDisableModeChange = true;
        this.mTree.setSelectionPath(path);
        this.mMainSelectedPath = path;
        this.mDisableModeChange = false;
    }

    public void removeColor() {
        ALog.logInfo((String)"This will remove the color association to this node");
    }

    public void drawArea() {
        ALog.logInfo((String)"This will put the user in a mode where they can draw a polygon or lasso an area");
    }

    public void removeArea() {
        ALog.logInfo((String)"This will remove the association to the polygon");
    }

    public void associateRule() {
        ALog.logInfo((String)"This will allow the user to associate a rule to this node");
    }

    public void removeRule() {
        ALog.logInfo((String)"This will remove the association to the rule");
    }

    private Interface getSelected(IntfTreeNode parentNode) {
        TreePath parentPath;
        if (parentNode == null) {
            parentNode = this.getSelectedIntfTreeNode(true);
        }
        parentNode = (parentPath = this.mMainSelectedPath) == null ? this.mRoot : (IntfTreeNode)parentPath.getLastPathComponent();
        Object pathStr = InterfaceTreeUI.getInterfacePathString(parentNode.getParent());
        pathStr = pathStr != null && ((String)pathStr).length() > 0 ? (String)pathStr + "/" + Interface.nameFromToString((String)parentNode.toString()) : (String)pathStr + Interface.nameFromToString((String)parentNode.toString());
        return Interface.find((Db)OrbitIO.getCurDb(), (String)pathStr);
    }

    protected void selectPinsByArea(AGeom worldGeom, boolean outlineOnlyMode, boolean shiftPressed, boolean ctrlPressed) {
        APair<Interface, Floorplan> selectedItem = null;
        selectedItem = ctrlPressed ? this.getSelectedInterfaceOrFloorplan() : this.setupForEditPins();
        if (selectedItem == null) {
            return;
        }
        this.mChangingDbObjects = true;
        Object ans = Cp.exec((String)"com.sigrity.orbit.InterfaceCmds.associatePinsWithFloorplan(curDb(), \"%s\", \"%s\", \"%s\", \"%s\", %s, %s, \"%s\", %s);", (Object[])new Object[]{((Interface)selectedItem.first).toStringPath(), ((Floorplan)selectedItem.second).getKeyStr(), worldGeom.getAsStringArg(), this.mAreaMode, Boolean.toString(ctrlPressed), Boolean.toString(outlineOnlyMode), this.mLimitSubst, Boolean.toString(this.mUseIOPads)});
        String msg = ans instanceof String ? (String)ans : null;
        this.mChangingDbObjects = false;
        if (msg != null && msg.length() > 0) {
            ALog.logWarn((String)msg);
        }
        this.refreshNetTable();
        if (!ctrlPressed) {
            this.addFloorplans(selectedItem.second == null ? this.mParentNode : (IntfTreeNode)this.mParentNode.getParent(), (Interface)selectedItem.first, true);
        } else {
            this.refreshNode(this.mParentNode, selectedItem.second == null);
            this.repaint();
            if (this.mSelectedFloorplan != null) {
                this.mFloorplanPanel.update();
            }
        }
    }

    static void showMePinsOfInterfaceOrFloorplan(Interface intf, Floorplan limitToFloorplan) {
    }

    public APair<Interface, Floorplan> getSelectedInterfaceOrFloorplan() {
        this.mParentNode = this.getSelectedIntfTreeNode(true);
        Interface intf = this.getSelected(this.mParentNode);
        Floorplan floorplan = null;
        if (this.mParentNode != null && this.mParentNode.getUserObject() instanceof Floorplan) {
            floorplan = (Floorplan)this.mParentNode.getUserObject();
            intf = floorplan.getMyInterface();
        }
        return new APair((Object)intf, floorplan);
    }

    public APair<Interface, Floorplan> setupForEditPins() {
        APair<Interface, Floorplan> selectedItem = this.getSelectedInterfaceOrFloorplan();
        this.mLimitSubst = this.mUserLimitSubst;
        if (selectedItem.second == null) {
            return null;
        }
        this.mLimitSubst = ((Floorplan)selectedItem.second).getSubstrate().getName();
        return selectedItem;
    }

    public void associatePins(GeometryDrawerMode.Mode intfMode) {
        if (this.rePopulatingTree) {
            return;
        }
        if (this.mInterfacePinGeometryMode != null) {
            this.mInterfacePinGeometryMode.cancelDrawingMode();
        }
        this.mIntfMode = intfMode;
        APair<Interface, Floorplan> selectedItem = this.setupForEditPins();
        if (selectedItem == null) {
            return;
        }
        this.mInterfacePinGeometryMode = new GeometryDrawerMode(((DesignView2D)OrbitIO.getCurView()).getCurMode(), new EditPinsAdaptor());
        this.mInterfacePinGeometryMode.setMode(this.mIntfMode);
        ((DesignView2D)OrbitIO.getCurView()).setMode(this.mInterfacePinGeometryMode);
    }

    public void removeAllPins() {
        try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)"Remove All Pins");){
            for (TreePath path : this.mTree.getSelectionModel().getSelectionPaths()) {
                IntfTreeNode parentNode = (IntfTreeNode)path.getLastPathComponent();
                if (parentNode == null || !(parentNode.getUserObject() instanceof Floorplan)) continue;
                Floorplan floorplan = (Floorplan)parentNode.getUserObject();
                Cp.exec((String)"Floorplan.removeAllPins(curDb(), \"%s\", true);", (Object[])new Object[]{floorplan.getKeyStr()});
            }
        }
    }

    private void associateSelectedPins(boolean mRemoveMode) {
        IntfTreeNode parentNode = this.getSelectedIntfTreeNode(true);
        Interface intf = this.getSelected(parentNode);
        Floorplan floorplan = null;
        if (parentNode != null && parentNode.getUserObject() instanceof Floorplan) {
            floorplan = (Floorplan)parentNode.getUserObject();
            intf = floorplan.getMyInterface();
        }
        Objects.requireNonNull(floorplan);
        this.mChangingDbObjects = true;
        Cp.exec((String)"com.sigrity.orbit.InterfaceCmds.associateSelectedPinsWithFloorplan(curDb(), \"%s\", \"%s\", %s);", (Object[])new Object[]{intf.toStringPath(), floorplan.getKeyStr(), Boolean.toString(mRemoveMode)});
        this.mChangingDbObjects = false;
        this.refreshNetTable();
        if (!mRemoveMode) {
            this.addFloorplans((IntfTreeNode)parentNode.getParent(), intf, true);
        } else {
            this.refreshNode(parentNode, floorplan == null);
            if (this.mSelectedFloorplan != null) {
                this.mFloorplanPanel.update();
            }
            this.repaint();
        }
        OrbitApp.getApp().refreshCurrentView(false);
    }

    public List<ATriple<Net, HierInst<PinTemplate>, Interface>> removeHierPins(List<ATriple<Net, HierInst<PinTemplate>, Interface>> startList, Set<HierPort> removeSet) {
        LinkedList<ATriple<Net, HierInst<PinTemplate>, Interface>> ans = new LinkedList<ATriple<Net, HierInst<PinTemplate>, Interface>>();
        if (startList == null) {
            return ans;
        }
        for (ATriple<Net, HierInst<PinTemplate>, Interface> triple : startList) {
            boolean found = false;
            Iterator<HierPort> iterator = removeSet.iterator();
            while (iterator.hasNext()) {
                HierPort hpObj;
                HierPort hp = hpObj = iterator.next();
                if (!((HierInst)triple.second).getPath().isEndOf(hp.getPath()) || hp.getPinTemplate() != ((HierInst)triple.second).getDbObject()) continue;
                found = true;
                break;
            }
            if (found) continue;
            ans.add(triple);
        }
        return ans;
    }

    private DesignView2D.ViewMode getPrevMode() {
        DesignView2D.ViewMode prevMode = ((DesignView2D)OrbitIO.getCurView()).getCurMode();
        if (prevMode == null) {
            ((DesignView2D)OrbitIO.getCurView()).setMode("InspectMode");
            prevMode = ((DesignView2D)OrbitIO.getCurView()).getCurMode();
        }
        return prevMode;
    }

    void chooseGlobberCanidates() {
        if (this.mGlobber != null) {
            ChooseCandidates chooseCandidates = new ChooseCandidates(this.mSelectedFloorplan, this.mAllowStealing, this.mUseIOPads);
            this.mGlobber.setCandidates(chooseCandidates.getCandidates());
        }
    }

    public static void setAllowStealing(boolean val) {
        Settings.set((String)"GUI", (String)"SelectFloorplanPinsAllowStealing", (Object)val);
        if (theInterfaceTreeUI != null) {
            InterfaceTreeUI.theInterfaceTreeUI.mAllowStealing = val;
            theInterfaceTreeUI.chooseGlobberCanidates();
        }
    }

    public static void setUseIOPads(boolean val) {
        Settings.set((String)"GUI", (String)"SelectFloorplanUseIOPads", (Object)val);
        if (theInterfaceTreeUI != null) {
            InterfaceTreeUI.theInterfaceTreeUI.mUseIOPads = val;
            theInterfaceTreeUI.chooseGlobberCanidates();
        }
    }

    public static void setRestrictToParent(Db db, boolean flag) {
        DesignSettings.set((Design)Design.getDesign((Db)db), (String)RESTRICT_TO_PARENT, (Object)flag);
        if (theInterfaceTreeUI != null && theInterfaceTreeUI.getDb() == db) {
            theInterfaceTreeUI.chooseGlobberCanidates();
        }
    }

    public boolean dynamicGlob(Floorplan floorplan) {
        if (!floorplan.getIncludeNoneInIOPersonalityList() && floorplan.getIOPersonalities().isEmpty()) {
            Cp.exec((String)"Floorplan.setIncludeNoneInIOPersonalityList(curDb(), \"%s\", %b)", (Object[])new Object[]{floorplan.getKeyStr(), true});
            ALog.logDebug((String)"Use default none personality filter");
        }
        DevicePath aDevicePath = this.mSelectedFloorplan.getADevicePathNear(0L, 0L);
        Interface intf = floorplan.getMyInterface();
        int numInDecendents = floorplan.getNumFloorplanPins(true) - floorplan.getNumFloorplanPins(false);
        this.mSelectedFloorplan = floorplan;
        this.mHasPins = floorplan.getNumFloorplanPins() > 0;
        boolean bl = this.mPinsInDecendentsNotBeingGlobbed = numInDecendents > 0;
        if (this.mPinsInDecendentsNotBeingGlobbed) {
            ALog.logInfo((String)"%d pins(s) in descendant interfaces are not being globbed, because they have already been positioned.", (Object[])new Object[]{numInDecendents});
        }
        int numDiffPairs = intf.getDiffPairs(floorplan, !this.mHasPins, aDevicePath).size();
        int numPinsToGlob = intf.getExpectedIOCount() - numInDecendents;
        if (numPinsToGlob == 0) {
            numDiffPairs = intf.getDiffPairs(floorplan, true, aDevicePath).size();
            numPinsToGlob = intf.getExpectedIOCount();
        }
        this.mPrevMode = this.getPrevMode();
        ChooseCandidates chooseCandidates = new ChooseCandidates(floorplan, this.mAllowStealing, this.mUseIOPads);
        if (intf.getExpectedIOCount() == 0) {
            OrbitApp.logAndDisplayWarningDialog((String)"This interface's expected count needs to be greater than 0 to use this command. Cannot start globber.", (String)"Warning");
            this.mGlobberMovingSet.setDynamicDrawingSet(null);
            this.mChangingDbObjects = false;
            ((DesignView2D)OrbitIO.getCurView()).getCanvas().refresh();
            return false;
        }
        if (chooseCandidates.getCnt() == 0) {
            if (chooseCandidates.getNumInOtherFloorplans() > 0 && (floorplan.getIncludeNoneInIOPersonalityList() || !floorplan.getIOPersonalities().isEmpty())) {
                String msg = "No candidate pins exist. " + chooseCandidates.getNumWithNetsAssigned() + " are already assigned to a net. " + chooseCandidates.getNumInOtherFloorplans() + " are in another floorplan. Cannot start globber unless 'Allow Stealing' is turned on. Turn it on now?";
                ALog.logInfo((String)msg);
                int r = JOptionPane.showConfirmDialog((Component)((Object)this), msg, "Confirm Setting Change", 1, 3);
                if (r != 0) {
                    if (this.mGlobberMovingSet != null) {
                        this.mGlobberMovingSet.setDynamicDrawingSet(null);
                    }
                    this.mChangingDbObjects = false;
                    ((DesignView2D)OrbitIO.getCurView()).getCanvas().refresh();
                    ALog.logInfo((String)"Globber not started.");
                    return false;
                }
                this.mAllowStealing = true;
                chooseCandidates = new ChooseCandidates(floorplan, this.mAllowStealing, this.mUseIOPads);
            } else {
                boolean stop = false;
                Object msg = "No candidate pins exist. ";
                if (chooseCandidates.getNumWithNetsAssigned() > 0) {
                    msg = (String)msg + chooseCandidates.getNumWithNetsAssigned() + " are already assigned to a net. ";
                }
                if (chooseCandidates.getNumInOtherFloorplans() > 0) {
                    msg = (String)msg + chooseCandidates.getNumInOtherFloorplans() + " are in another floorplan. ";
                }
                if (!this.mAllowStealing) {
                    msg = (String)msg + "Enabling 'Allow Stealing' may allow candidate pins to be found. ";
                }
                if (floorplan.getMyInterface().getParent() != null) {
                    msg = (String)msg + "Or add pins to parent floorplan before globbing this one.";
                }
                OrbitApp.logAndDisplayWarningDialog((String)msg, (String)"Warning");
                if (stop) {
                    if (this.mGlobberMovingSet != null) {
                        this.mGlobberMovingSet.setDynamicDrawingSet(null);
                    }
                    this.mChangingDbObjects = false;
                    ((DesignView2D)OrbitIO.getCurView()).getCanvas().refresh();
                    return false;
                }
            }
        } else {
            if (chooseCandidates.getCnt() < floorplan.getMyInterface().getExpectedIOCount()) {
                Object msg;
                if (floorplan.getParentFloorplan() != null) {
                    msg = "Parent Floorplan does not have enough pins to use for this floorplan. For these child floorplans, populate the parent floorplan first. Use 'Edit pins -> remove all pins' from this floorplan to start over";
                } else {
                    msg = "Only " + chooseCandidates.getCnt() + " pins are available on the substrate. " + floorplan.getMyInterface().getExpectedIOCount() + " are required for the floorplan. Glob will not complete floorplans IO requirement.";
                    if (chooseCandidates.getCnt() == 0) {
                        msg = "No pins are available on the substrate. " + floorplan.getMyInterface().getExpectedIOCount() + " are required for the floorplan. Glob will not complete floorplans IO requirement.";
                    }
                }
                OrbitApp.logAndDisplayWarningDialog((String)msg, (String)"Warning");
                return false;
            }
            if (chooseCandidates.getCnt() == floorplan.getMyInterface().getExpectedIOCount()) {
                Object msg;
                if (floorplan.getParentFloorplan() != null) {
                    msg = "Parent Floorplan has just enough pins to use for this floorplan. Either click on the canvas to select this location or right click to 'Allow stealing' if other locations are desired.";
                } else {
                    msg = "Only " + chooseCandidates.getCnt() + " pins are available on the substrate. " + floorplan.getMyInterface().getExpectedIOCount() + " are required for the floorplan. Globber has only one valid location to place the pins.";
                    if (!this.mAllowStealing) {
                        msg = (String)msg + " Turning 'Allow stealing' on may open up other locations.";
                    }
                }
                OrbitApp.logAndDisplayWarningDialog((String)msg, (String)"Warning");
            }
        }
        this.mGlobber = Globber.startGlobber(numPinsToGlob, numDiffPairs, "Floorplan: " + floorplan.getName() + " Diff Pairs: " + numDiffPairs, DiffPairFinder.getInitialDiffPairAlgo((Db)floorplan.getDb(), (DbObject)floorplan, (String[])DiffPairFinder.CostFunctionCatalog), true, AColor.withAlpha((Color)floorplan.getMyInterface().getColor(), (int)(mTemporaryGlobbingFloorplan != null ? 50 : 75)));
        if (this.mGlobber == null) {
            ALog.logError((String)"Already In Dynamic Globber");
            this.mChangingDbObjects = false;
            ((DesignView2D)OrbitIO.getCurView()).getCanvas().refresh();
            return false;
        }
        if (this.mHasPins) {
            this.mChangingDbObjects = true;
            this.mHierPinTempWithNetAndInterface = floorplan.getMyInterface().recordInfoBeforeMovement(floorplan, this.mPinsInDecendentsNotBeingGlobbed);
            this.mHierPinTempWithNetAndInterface.sort(this.PinTempWithNetAndInterfaceSort);
            if (floorplan.getNumFloorplanPins() > floorplan.getMyInterface().getExpectedIOCount()) {
                ALog.logDebug((String)"Glob is eliminating some pins because there are more than the expected count");
            }
            this.addFloorplansToDynamicDrawingSetSoStaticVersionWillNotBeDrawn(floorplan);
            ((DesignView2D)OrbitIO.getCurView()).getCanvas().refresh();
        } else {
            this.mHierPinTempWithNetAndInterface = new LinkedList<HierPinTempWithNetAndInterface>();
        }
        this.mGlobber.setPortFilter(new FpIoPins(chooseCandidates));
        this.mGlobber.setCandidates(chooseCandidates.getCandidates());
        if (this.mInterfacePinGeometryMode != null) {
            this.mInterfacePinGeometryMode.cancelDrawingMode();
        }
        this.doingGlobbing = true;
        this.mGlobber.glob();
        this.mChangingDbObjects = false;
        return true;
    }

    private void addFloorplansToDynamicDrawingSetSoStaticVersionWillNotBeDrawn(Floorplan mFloorplan) {
        Selection.SelSet objects = new Selection.SelSet();
        this.mGlobberMovingSet = new MovingSet(false);
        LinkedList list = Floorplan.selfAndChildren((Interface)mFloorplan.getMyInterface(), null, (DeviceTemplate)mFloorplan.getDeviceTemplate());
        for (Floorplan fp : list) {
            for (DevicePath devPath : fp.getDeviceTemplate().getHierarchicalInstances()) {
                objects.add(devPath, (DbObject)fp);
            }
        }
        this.mGlobberMovingSet.setSelSet(new Selection.SelSet());
        this.mGlobberMovingSet.setDynamicDrawingSet(objects);
        ((DesignView2D)OrbitIO.getCurView()).setBeingMoved(this.mGlobberMovingSet);
    }

    public void exportSelectedNodes() {
        AFileChooser fc = new AFileChooser();
        AFileFilter filter = new AFileFilter("inf", "Interface File");
        fc.setFileFilter((FileFilter)filter);
        if (fc.showSaveDialog((Component)OrbitIO.getMainWindow()) != 0) {
            return;
        }
        File f = fc.getSelectedFile();
        Object path = f.getPath();
        if (fc.getFileFilter() == filter && !f.getName().contains(".")) {
            path = (String)path + ".inf";
        }
        Cp.exec((String)"Interface.openExport(%s);", (Object[])new Object[]{Cp.getFileAsArgument((String)path)});
        LinkedList<Interface> list = new LinkedList<Interface>();
        for (TreePath treePath : this.mTree.getSelectionModel().getSelectionPaths()) {
            IntfTreeNode parentNode = (IntfTreeNode)treePath.getLastPathComponent();
            if (parentNode == null || !(parentNode.getUserObject() instanceof Interface)) continue;
            Interface intf = (Interface)parentNode.getUserObject();
            Interface decendent = intf.descendantInList(list);
            if (decendent != null) {
                list.remove(decendent);
                list.add(intf);
                continue;
            }
            if (intf.ancestorInList(list) != null) continue;
            list.add(intf);
        }
        for (Interface intf : list) {
            Cp.exec((String)"Interface.export(curDb(), \"%s\");", (Object[])new Object[]{intf.toStringPath()});
        }
        Cp.exec((String)"Interface.closeExport();", (Object[])new Object[0]);
    }

    private static Personality getPersonality(Floorplan floorplan, String personalityName) {
        if (personalityName.equals("<NONE>")) {
            return null;
        }
        return Personality.getPersonality((DeviceTemplate)floorplan.getDeviceTemplate(), (Personality.Type)Personality.Type.PORT, (String)personalityName).orElse(null);
    }

    private static boolean importInterfaceCheckExisting(Element intfElem, Interface relToInterface) {
        Db db = OrbitIO.getCurDb();
        String interfaceName = intfElem.getAttribute("Name");
        Interface intf = relToInterface != null ? relToInterface.findChildAnsestory(interfaceName) : Interface.find((Db)db, (String)interfaceName);
        return intf != null;
    }

    private static boolean importInterface(Element intfElem, Interface relToInterface) {
        Interface intf;
        Db db = OrbitIO.getCurDb();
        String interfaceName = intfElem.getAttribute("Name");
        Interface interface_ = intf = relToInterface != null ? relToInterface.findChildAnsestory(interfaceName) : Interface.find((Db)db, (String)interfaceName);
        if (intf != null) {
            ALog.logWarn((String)"Interface '%s' already exists. Overwriting ...", (Object[])new Object[]{interfaceName});
            intf.deleteSelfAndChildren();
        }
        boolean ans = true;
        int ioCnt = Integer.parseInt(intfElem.getAttribute("IOCount"));
        int colorInt = Integer.parseInt(intfElem.getAttribute("Color"));
        String netRef = intfElem.getAttribute("NetsReferencedBy");
        String netRefSub = intfElem.getAttribute("NetsReferencedSub");
        DeviceTemplate netsDevTemp = null;
        if (netRef != null && netRefSub != null && !netRef.isEmpty() && !netRefSub.isEmpty()) {
            Substrate sub = Substrate.getSubstrate((Db)db, (String)netRefSub);
            if (sub == null) {
                ALog.logWarn((String)("Substrate '" + netRefSub + "' does not exist. Skipping Interface '" + interfaceName + "'."));
                return false;
            }
            netsDevTemp = DeviceTemplate.getDeviceTemplate((Substrate)sub, (String)netRef);
            if (netsDevTemp == null) {
                ALog.logWarn((String)("DeviceTemplate '" + netRef + "' does not exist. Skipping Interface '" + interfaceName + "'."));
                return false;
            }
        }
        intf = Interface.create((Db)db, (String)Interface.nameFromAncestoryString((String)interfaceName), (Interface)(relToInterface != null ? relToInterface.findParentOfAncestry(interfaceName) : Interface.findParent((Db)db, (String)interfaceName)), (int)ioCnt, (boolean)false, (boolean)true);
        intf.setColor(colorInt);
        if (netsDevTemp != null) {
            intf.setNetsReferencedWRT(netsDevTemp);
        }
        for (Element netElem : AXDomUtil.getChildElems((Node)intfElem, (String)"Net")) {
            String netName = netElem.getAttribute("Name");
            Net net = Net.get((DeviceTemplate)netsDevTemp, (String)netName);
            if (net != null) {
                intf.addNet(net);
                continue;
            }
            ALog.logWarn((String)"Net '%s' does not exist and cannot be associated with interface '%s'.", (Object[])new Object[]{netName, interfaceName});
            ans = false;
        }
        for (Element fpElem : AXDomUtil.getChildElems((Node)intfElem, (String)"Floorplan")) {
            String floorplanName = fpElem.getAttribute("Name");
            String subStr = fpElem.getAttribute("Substrate");
            Substrate sub = Substrate.getSubstrate((Db)db, (String)subStr);
            if (sub == null) {
                ALog.logWarn((String)"Substrate '%s' not found for Device Template '%s'. Skipping floorplan...", (Object[])new Object[]{subStr, floorplanName});
                ans = false;
                continue;
            }
            Floorplan floorplan = intf.getFloorplan(DeviceTemplate.getDeviceTemplate((Substrate)sub, (String)floorplanName), false);
            if (floorplan == null) {
                ALog.logWarn((String)"Floorplan '%s' not found. Skipping floorplan...", (Object[])new Object[]{floorplanName});
                ans = false;
                continue;
            }
            for (Element perElem : AXDomUtil.getChildElems((Node)fpElem, (String)"Personality")) {
                String personalityName = perElem.getAttribute("Name");
                Optional personality = Personality.getPersonality((DeviceTemplate)floorplan.getDeviceTemplate(), (Personality.Type)Personality.Type.PORT, (String)personalityName);
                if (!personality.isPresent()) continue;
                PersonalityUI.addDbObjectToPersonality((DbObject)floorplan, (Personality)personality.get());
            }
            for (Element ratioElem : AXDomUtil.getChildElems((Node)fpElem, (String)"Ratio")) {
                String obj1Name = ratioElem.getAttribute("Object1");
                String obj2Name = ratioElem.getAttribute("Object2");
                int num = Integer.parseInt(ratioElem.getAttribute("Numerator"));
                int dem = Integer.parseInt(ratioElem.getAttribute("Denominator"));
                double tol = Double.parseDouble(ratioElem.getAttribute("Tolerance"));
                Personality personality1 = InterfaceTreeUI.getPersonality(floorplan, obj1Name);
                Personality personality2 = InterfaceTreeUI.getPersonality(floorplan, obj2Name);
                if (personality1 == null && personality2 == null) continue;
                DbObjectRatio.create((DbObject)floorplan, (DbObject)personality1, (DbObject)personality2, (int)num, (int)dem, (double)tol);
            }
        }
        for (Element childElem : AXDomUtil.getChildElems((Node)intfElem, (String)"Interface")) {
            ans &= InterfaceTreeUI.importInterface(childElem, relToInterface);
        }
        InterfaceCmds.assignExistingPinsToFloorplanForAllDecendents(intf);
        return ans;
    }

    public static void importInterfaces(String fileName) {
        File file = new File(fileName);
        Element doc = AXDomUtil.getDocumentElement((File)file);
        boolean allRead = true;
        for (Element elFactory : AXDomUtil.getChildElems((Node)doc, (String)"Interface")) {
            allRead &= InterfaceTreeUI.importInterface(elFactory, null);
        }
        InterfaceTreeUI.theInterfaceTreeUI.mDisableModeChange = false;
        InterfaceTreeUI.scheduleRepopulateTree();
        if (!allRead) {
            OrbitApp.logAndDisplayWarningDialog((String)"Some data not read. See message window for details.", (String)"Warning");
        }
    }

    public static int importInterfacesConflictChecker(String fileName, String relToInterfaceString) {
        int ans = 0;
        Db db = OrbitIO.getCurDb();
        File file = new File(fileName);
        Element doc = AXDomUtil.getDocumentElement((File)file);
        for (Element elFactory : AXDomUtil.getChildElems((Node)doc, (String)"Interface")) {
            Interface intf;
            if (!InterfaceTreeUI.importInterfaceCheckExisting(elFactory, intf = relToInterfaceString == null ? null : Interface.find((Db)db, (String)relToInterfaceString))) continue;
            ++ans;
        }
        return ans;
    }

    public static void importInterfaces(String fileName, String relToInterfaceString) {
        Db db = OrbitIO.getCurDb();
        File file = new File(fileName);
        Element doc = AXDomUtil.getDocumentElement((File)file);
        boolean allRead = true;
        if (theInterfaceTreeUI != null) {
            InterfaceTreeUI.theInterfaceTreeUI.mDisableModeChange = true;
        }
        for (Element elFactory : AXDomUtil.getChildElems((Node)doc, (String)"Interface")) {
            Interface intf = Interface.find((Db)db, (String)relToInterfaceString);
            allRead &= InterfaceTreeUI.importInterface(elFactory, intf);
            intf.adjustCountForNetsIfNecessary(false);
        }
        if (theInterfaceTreeUI != null) {
            InterfaceTreeUI.theInterfaceTreeUI.mDisableModeChange = false;
            InterfaceTreeUI.scheduleRepopulateTree();
        }
        if (!allRead) {
            OrbitApp.logAndDisplayWarningDialog((String)"Some data not read. See message window for details.", (String)"Warning");
        }
    }

    public static void importInterfacesCSV(Db db, String fileName) {
        Personality.resetColor();
        try (ACsvReader csvReader = ACsvReader.open((String)fileName);){
            Design design = Design.getDesign((Db)db);
            design.setValue(IMPORT_CSV_FILE, (Object)fileName);
            if (theInterfaceTreeUI != null) {
                InterfaceTreeUI.theInterfaceTreeUI.mDisableModeChange = true;
            }
            HashSet existingAndMismatches = AUtil.hashSet((Iterator)db.getObjects(Interface.class));
            LinkedList<Interface> interfacesNeedCnts = new LinkedList<Interface>();
            LinkedList<Interface> allInterfaces = new LinkedList<Interface>();
            for (String[] row : csvReader.getRows()) {
                boolean first = true;
                int ioCnt = 0;
                Interface intf = null;
                for (String cell : row) {
                    if (first) {
                        ioCnt = -1;
                        intf = Interface.getOrCreate((Db)db, (String)cell, (boolean)false);
                        allInterfaces.add(intf);
                        first = false;
                        continue;
                    }
                    if (cell.length() > 0) {
                        ioCnt = Integer.valueOf(cell);
                        intf.setExpectedIOCount(ioCnt);
                        continue;
                    }
                    interfacesNeedCnts.add(intf);
                }
            }
            block7: while (!interfacesNeedCnts.isEmpty()) {
                for (Interface interf : interfacesNeedCnts) {
                    if (!interf.allChildrenHaveCount()) continue;
                    interf.setExpectedIOCount(interf.childrenCount());
                    interfacesNeedCnts.remove(interf);
                    continue block7;
                }
            }
            int warning = 0;
            for (Interface interf : allInterfaces) {
                if (!interf.getChildren().hasNext() || interf.getExpectedIOCount() >= interf.childrenCount()) continue;
                ++warning;
                existingAndMismatches.add(interf);
                ALog.logWarn((String)"Interface '%s' count(%d) does not match total of childrens count(%d).", (Object[])new Object[]{interf.toStringPath(), interf.getExpectedIOCount(), interf.childrenCount()});
            }
            if (warning > 0) {
                OrbitApp.logAndDisplayWarningDialog((String)"Some interface expected counts were not consistant. See message window for details. The program will automatically correct the counts. Use Edit->Undo if the results are not acceptable.", (String)"Warning");
            }
            for (Interface interf : allInterfaces) {
                if (existingAndMismatches == null || existingAndMismatches.contains(interf)) continue;
                interf.adjustAncestorsCountIfNecessary(true);
            }
            if (theInterfaceTreeUI != null) {
                InterfaceTreeUI.theInterfaceTreeUI.mDisableModeChange = false;
                InterfaceTreeUI.scheduleRepopulateTree();
            }
        }
    }

    private void importInterfaces(JTree tree) {
        AFileChooser fc = new AFileChooser();
        AFileFilter filter = new AFileFilter("inf", "Interface File");
        fc.setFileFilter((FileFilter)filter);
        if (fc.showOpenDialog((Component)OrbitIO.getMainWindow()) != 0) {
            return;
        }
        this.mDisableModeChange = true;
        File file = fc.getSelectedFile();
        try {
            if (this.getNumInterfacesSelected(this.mTree.getSelectionModel()) > 0) {
                String msg;
                int r;
                IntfTreeNode parentNode;
                int conflicts = 0;
                for (TreePath path : tree.getSelectionPaths()) {
                    parentNode = (IntfTreeNode)path.getLastPathComponent();
                    if (parentNode == null || !(parentNode.getUserObject() instanceof Interface)) continue;
                    conflicts += InterfaceTreeUI.importInterfacesConflictChecker(file.getCanonicalPath(), ((Interface)parentNode.getUserObject()).toStringPath());
                }
                if (conflicts > 0 && (r = JOptionPane.showConfirmDialog((Component)((Object)this), msg = conflicts + " interface(s) found in file that conflict with the current database. Continue and overwrite conflicting interfaces? ", "Confirm Overwrite", 1, 3)) == 0) {
                    conflicts = 0;
                }
                if (conflicts == 0) {
                    for (TreePath path : tree.getSelectionPaths()) {
                        parentNode = (IntfTreeNode)path.getLastPathComponent();
                        if (parentNode == null || !(parentNode.getUserObject() instanceof Interface)) continue;
                        Cp.exec((String)"com.sigrity.orbit.ui.InterfaceTreeUI.importInterfaces(%s, \"%s\")", (Object[])new Object[]{Cp.getFileAsArgument((File)file), ((Interface)parentNode.getUserObject()).toStringPath()});
                    }
                }
            } else {
                String msg;
                int r;
                int conflicts = InterfaceTreeUI.importInterfacesConflictChecker(file.getCanonicalPath(), null);
                if (conflicts > 0 && (r = JOptionPane.showConfirmDialog((Component)((Object)this), msg = conflicts + " interface(s) found in file that conflict with the current database. Continue and overwrite conflicting interfaces?", "Confirm Overwrite", 1, 3)) == 0) {
                    conflicts = 0;
                }
                if (conflicts == 0) {
                    Cp.exec((String)"com.sigrity.orbit.ui.InterfaceTreeUI.importInterfaces(%s)", (Object[])new Object[]{Cp.getFileAsArgument((File)file)});
                }
            }
        }
        catch (IOException e) {
            ALog.logWarn((Throwable)e, (String)"Problem importing interfaces.", (Object[])new Object[0]);
        }
    }

    public void importInterfacesCSV() {
        AFileChooser fc = new AFileChooser();
        AFileFilter filter = new AFileFilter("csv", "Interface CSV File");
        fc.setFileFilter((FileFilter)filter);
        String defaultFile = (String)Design.getDesign((Db)OrbitIO.getCurDb()).getValue(IMPORT_CSV_FILE);
        if (defaultFile != null) {
            fc.setSelectedFile(new File(defaultFile));
        }
        if (fc.showOpenDialog((Component)OrbitIO.getMainWindow()) != 0) {
            return;
        }
        this.mDisableModeChange = true;
        File file = fc.getSelectedFile();
        Cp.exec((String)"com.sigrity.orbit.ui.InterfaceTreeUI.importInterfacesCSV(curDb(), %s)", (Object[])new Object[]{Cp.getFileAsArgument((File)file)});
    }

    public void deleteObject() {
        int r;
        IntfTreeNode parentNode = this.getSelectedIntfTreeNode(false);
        if (parentNode == null || !(parentNode.getUserObject() instanceof Interface)) {
            ALog.logInfo((String)"Cannot find selected interface node.");
            return;
        }
        Object object = parentNode.getUserObject();
        String msg = null;
        if (object instanceof Interface) {
            msg = this.getNumInterfacesSelected(this.mTree.getSelectionModel()) == 1 ? String.format("Delete interface '%s' and all its children?", ((Interface)object).getName()) : String.format("Delete %d interfaces and all their children?", this.getNumInterfacesSelected(this.mTree.getSelectionModel()));
        }
        if ((r = JOptionPane.showConfirmDialog((Component)((Object)this), msg, "Confirm Delete", 1, 3)) == 0) {
            this.mChangingDbObjects = true;
            if (object instanceof Interface) {
                for (TreePath path : this.mTree.getSelectionModel().getSelectionPaths()) {
                    parentNode = (IntfTreeNode)path.getLastPathComponent();
                    object = parentNode.getUserObject();
                    Cp.exec((String)"com.sigrity.acl.db.std.Interface.delete(curDb(), \"%s\");", (Object[])new Object[]{((Interface)object).toStringPath()});
                }
            }
            this.mChangingDbObjects = false;
            this.mTree.clearSelection();
            InterfaceTreeUI.scheduleRepopulateTree();
            OrbitApp.getApp().refreshCurrentView(false);
        }
    }

    static IntfTreeNode findUserNode(IntfTreeNode curNode, Object userObject) {
        for (int i = 0; i < curNode.getChildCount(); ++i) {
            IntfTreeNode ans;
            IntfTreeNode cur = (IntfTreeNode)curNode.getChildAt(i);
            if (cur.getUserObject() == userObject) {
                return cur;
            }
            if (!(cur.getUserObject() instanceof Interface) || (ans = InterfaceTreeUI.findUserNode(cur, userObject)) == null) continue;
            return ans;
        }
        return null;
    }

    public void setSelectedVisible(boolean vis) {
        for (TreePath path : this.mTree.getSelectionModel().getSelectionPaths()) {
            IntfTreeNode parentNode = (IntfTreeNode)path.getLastPathComponent();
            if (parentNode == null || !(parentNode.getUserObject() instanceof Interface)) continue;
            Cp.exec((String)("com.sigrity.acl.db.std.Interface.setVisible(curDb(), \"" + ((Interface)parentNode.getUserObject()).toStringPath() + "\", " + Boolean.toString(vis) + ");"), (Object[])new Object[0]);
        }
    }

    public void selectPins(boolean ioOnly) {
        IntfTreeNode parentNode = this.getSelectedIntfTreeNode(true);
        Design currentDesign = OrbitIO.getCurDesign();
        Selection s = currentDesign.getCurSelection();
        Object object = parentNode.getUserObject();
        if (object instanceof Floorplan) {
            s.clearData(true);
            if (ioOnly) {
                InterfaceCmds.selectFloorplanIOPins(s, (Floorplan)object);
            } else {
                InterfaceCmds.selectFloorplanPins(s, (Floorplan)object);
            }
            OrbitApp.getApp().refreshCurrentView(false);
        } else if (object instanceof Interface) {
            s.clearData(true);
            for (Floorplan floorplan : ((Interface)object).getFloorplans()) {
                if (ioOnly) {
                    InterfaceCmds.selectFloorplanIOPins(s, floorplan);
                    continue;
                }
                InterfaceCmds.selectFloorplanPins(s, floorplan);
            }
            OrbitApp.getApp().refreshCurrentView(false);
        }
    }

    public void zoomTo() {
        ARect overallBounds = null;
        for (TreePath path : this.mTree.getSelectionModel().getSelectionPaths()) {
            IntfTreeNode parentNode = (IntfTreeNode)path.getLastPathComponent();
            Object object = parentNode.getUserObject();
            AGeom geom = null;
            if (parentNode != null && object instanceof Floorplan) {
                DevicePath devPath = ((Floorplan)object).getDeviceTemplate().getPathToPresentUser();
                if (devPath != null) {
                    geom = ((Floorplan)object).getHull(devPath, true);
                }
            } else if (object instanceof Interface) {
                AGeom aGeom = geom = ((Interface)object).getGeom() == null ? null : ((Interface)object).getGeom();
            }
            if (geom == null) continue;
            ARect bounds = geom.getBounds();
            if (overallBounds == null) {
                overallBounds = bounds;
                continue;
            }
            overallBounds.expand(bounds);
        }
        if (overallBounds == null) {
            return;
        }
        overallBounds.changeSizeBy(0.1);
        ((DesignView2D)OrbitIO.getCurView()).getCanvas().getXForm().setWorld(overallBounds);
        ((DesignView2D)OrbitIO.getCurView()).getCanvas().refresh();
    }

    public void removePins() {
        ALog.logInfo((String)"This will remove the association to the pins");
    }

    private Set<Floorplan> getDescendantChildFloorplan(IntfTreeNode node) {
        LinkedHashSet<Floorplan> s = new LinkedHashSet<Floorplan>();
        Enumeration<TreeNode> e = node.preorderEnumeration();
        while (e.hasMoreElements()) {
            IntfTreeNode i = (IntfTreeNode)e.nextElement();
            if (!i.isLeaf() || !(i.getUserObject() instanceof Floorplan)) continue;
            s.add((Floorplan)i.getUserObject());
        }
        return s;
    }

    private IntfTreeNode addFloorplans(IntfTreeNode cur, Interface intf, boolean makeVisibleNow) {
        TreePath startingSelection = this.mMainSelectedPath;
        LinkedList<IntfTreeNode> newItems = new LinkedList<IntfTreeNode>();
        IntfTreeNode info = null;
        Set<Floorplan> floorplanInChild = this.getDescendantChildFloorplan(cur);
        for (Floorplan floorplan : intf.getFloorplans()) {
            if (floorplanInChild.contains(floorplan)) continue;
            info = new IntfTreeNode(floorplan);
            cur.add(info);
            info.setAllowsChildren(false);
            newItems.add(info);
        }
        if (makeVisibleNow) {
            this.mDisableModeChange = true;
            this.mTreeModel.reload(cur);
            for (IntfTreeNode node : newItems) {
                TreePath path = new TreePath(node.getPath());
                this.mTree.setSelectionPath(path);
                this.mMainSelectedPath = path;
                this.mTree.scrollPathToVisible(path);
            }
            if (startingSelection != null) {
                this.mTree.setSelectionPath(startingSelection);
                this.mMainSelectedPath = startingSelection;
            }
            this.mDisableModeChange = false;
        }
        return info;
    }

    private IntfTreeNode createNode(IntfTreeNode parent, Interface intf) {
        IntfTreeNode cur = new IntfTreeNode(intf);
        parent.add(cur);
        this.addFloorplans(cur, intf, false);
        for (Interface i : intf.getChildren()) {
            this.createNode(cur, i);
        }
        return cur;
    }

    private void createRootNode(IntfTreeNode top, Interface intf) {
        IntfTreeNode category = new IntfTreeNode(intf);
        top.add(category);
        this.addFloorplans(category, intf, false);
        intf.getChildren().forEach(child -> this.createNode(category, (Interface)child));
    }

    private void createNodes(IntfTreeNode top) {
        this.mDb.getObjects(Interface.class).stream().filter(intf -> intf.getParent() == null).forEach(intf -> this.createRootNode(top, (Interface)intf));
    }

    protected void installTreePopupMenu() {
        KeyStroke POPUP_KEYSTROKE = KeyStroke.getKeyStroke(121, 64);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath sel = InterfaceTreeUI.this.mMainSelectedPath;
                if (sel != null) {
                    Rectangle r = InterfaceTreeUI.this.mTree.getPathBounds(sel);
                    Point p = new Point();
                    if (r == null) {
                        p.x = 0;
                        p.y = 0;
                    } else {
                        p.x = r.x;
                        p.y = r.y + r.height;
                    }
                    InterfaceTreeUI.this.showTreeContextMenu(sel.getLastPathComponent(), p.x, p.y);
                } else {
                    InterfaceTreeUI.this.showTreeContextMenu(null, 0, 0);
                }
            }
        };
        ActionMap am = this.mTree.getActionMap();
        am.put(action, action);
        this.mTree.getInputMap().put(POPUP_KEYSTROKE, action);
        this.mTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int row = InterfaceTreeUI.this.mTree.getRowForLocation(e.getX(), e.getY());
                if (row == -1) {
                    row = InterfaceTreeUI.this.mTree.getClosestRowForLocation(e.getX(), e.getY());
                    Rectangle rect = InterfaceTreeUI.this.mTree.getRowBounds(row);
                    if (row == -1 || (double)e.getX() >= rect.getMaxX() || (double)e.getY() > rect.getMaxY()) {
                        InterfaceTreeUI.this.mTree.clearSelection();
                    }
                }
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                Interface intf;
                Color intfColor;
                String title;
                AColorChooserDlg dlg;
                Color newColor;
                TreePath path = InterfaceTreeUI.this.mTree.getPathForLocation(e.getX(), e.getY());
                if (path == null) {
                    return;
                }
                Rectangle r = InterfaceTreeUI.this.mTree.getPathBounds(path);
                IntfTreeNode parentNode = InterfaceTreeUI.this.getSelectedIntfTreeNode(false);
                Object object = null;
                if (parentNode != null) {
                    object = parentNode.getUserObject();
                }
                if (object instanceof Interface && e.getPoint().getX() < r.getX() + 16.0 && (newColor = (dlg = AColorChooserDlg.createDialog((Component)InterfaceTreeUI.this.mTree, title = String.format("%s Color", object), intfColor = (intf = (Interface)object).getColor())).doModal()) != null) {
                    InterfaceTreeUI.this.chooseColor(newColor);
                }
            }

            protected void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    e.getSource();
                    TreePath p = InterfaceTreeUI.this.mTree.getPathForLocation(e.getX(), e.getY());
                    if (p != null) {
                        InterfaceTreeUI.this.mDisableModeChange = true;
                        if (!InterfaceTreeUI.this.mTree.getSelectionModel().isPathSelected(p)) {
                            InterfaceTreeUI.this.mTree.setSelectionPath(p);
                        }
                        InterfaceTreeUI.this.mMainSelectedPath = p;
                        InterfaceTreeUI.this.mDisableModeChange = false;
                        InterfaceTreeUI.this.showTreeContextMenu(p.getLastPathComponent(), e.getX(), e.getY());
                    } else {
                        InterfaceTreeUI.this.showTreeContextMenu(null, e.getX(), e.getY());
                    }
                }
            }
        });
    }

    public static void assignExistingPinsToFloorplanForAllDecendents(Db db, String ancestry) {
        Interface intf = Interface.find((Db)db, (String)ancestry);
        if (intf == null) {
            return;
        }
        if (theInterfaceTreeUI != null) {
            InterfaceTreeUI.theInterfaceTreeUI.mChangingDbObjects = true;
        }
        InterfaceCmds.assignExistingPinsToFloorplanForAllDecendents(intf);
        if (theInterfaceTreeUI != null) {
            InterfaceTreeUI.theInterfaceTreeUI.mChangingDbObjects = false;
        }
    }

    private void showTreeContextMenu(Object o, int x, int y) {
        LinkedList<JMenuItem> menuItems = this.createContextMenu();
        JPopupMenu m = new JPopupMenu();
        for (JMenuItem mi : menuItems) {
            if (mi == null) {
                m.addSeparator();
                continue;
            }
            m.add(mi);
            UIUtil.setUniqueMnemonic((JPopupMenu)m, (AbstractButton)mi);
        }
        AMenuUtil.setMnemonics((JPopupMenu)m, (boolean)true, (boolean)true);
        OrbitIO.getGuiWorkspace().beautify(m);
        m.show(this.mTree, x, y);
    }

    private void cloneNode() {
        IntfTreeNode editedNode = this.getSelectedIntfTreeNode(true);
        InterfaceCloneUI.createDialog(OrbitIO.getMainWindow(), this.getSelected(editedNode));
        this.refreshNode(editedNode, false);
    }

    private void editSelectedNode() {
        IntfTreeNode editedNode = this.getSelectedIntfTreeNode(true);
        InterfaceUI.showEditDialog(OrbitIO.getMainWindow(), this.getSelected(editedNode));
        this.refreshNode(editedNode, false);
        Interface intf = this.getSelected(null);
        if (intf != null) {
            this.mInformationLabel.setText("Selected " + intf.info());
        }
    }

    private void refreshNetsTable() {
        if (this.mDb == null || this.mDb.closed()) {
            return;
        }
        if (this.mSelectedInterface != null) {
            this.mSelectedInterface.resetInterfaceStatus();
        }
        theInterfaceTreeUI.refreshNetTable();
    }

    private void editNets() {
        this.setEnabled(false);
        GetObjectsChooserDlg.createDialog(OrbitIO.getMainWindow(), new InterfaceUI.GetDbObjectsChooserAdaptor(this.mSelectedInterface, () -> {
            this.refreshNetTable();
            this.refreshNode(this.getSelectedIntfTreeNode(true), false);
            Interface intf = this.getSelected(null);
            if (intf != null) {
                this.mInformationLabel.setText("Selected " + intf.info());
            }
        }, () -> theInterfaceTreeUI.setEnabled(true)), false);
    }

    private void populateEditMenuItems(List<JMenuItem> items, Object object) {
        Interface selInterface = object instanceof Interface ? (Interface)object : null;
        Floorplan selFloorplan = object instanceof Floorplan ? (Floorplan)object : null;
        int selInterfaceCount = this.getNumInterfacesSelected(this.mTree.getSelectionModel());
        int selFloorplanCount = this.getNumFloorplansSelected(this.mTree.getSelectionModel());
        List<Interface> selInterfaces = this.getInterfacesSelected(this.mTree.getSelectionModel());
        List<Floorplan> selFloorplans = this.getFloorplansSelected(this.mTree.getSelectionModel());
        int selTotalCount = this.mTree.getSelectionCount();
        if (object == null) {
            items.add(new JMenuItem(new AbstractAction("New Interface..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InterfaceTreeUI.this.addObject(null, true);
                }
            }));
            items.add(null);
            items.add(new JMenuItem(new AbstractAction("Expand All"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InterfaceTreeUI.this.expandAll(true);
                }
            }));
            items.add(new JMenuItem(new AbstractAction("Compress All"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InterfaceTreeUI.this.expandAll(false);
                }
            }));
            items.add(null);
            items.add(new JMenuItem(new AbstractAction("Interface Defaults..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SettingsUI.showSettingsDialog(OrbitIO.getMainWindow(), "Design");
                }
            }));
        }
        if (selFloorplanCount == 0 || selInterfaceCount > 0) {
            items.add(new JMenuItem(new AbstractAction("Import..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InterfaceTreeUI.this.importInterfaces(InterfaceTreeUI.this.mTree);
                }
            }));
        }
        if (selInterface != null && selTotalCount == 1) {
            JMenu menu = new JMenu("Interface");
            items.add(menu);
            menu.add(new JMenuItem(new AbstractAction("Add Child"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InterfaceTreeUI.this.addObject();
                }
            }));
            menu.add(new JMenuItem(new AbstractAction("Clone"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InterfaceTreeUI.this.cloneNode();
                }
            }));
            menu.add(new JMenuItem(new AbstractAction("Edit"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InterfaceTreeUI.this.editSelectedNode();
                }
            }));
            menu.add(new JMenuItem(new InterfaceUI.ActionFixUpInterface((Interface)object)));
            items.add(new JMenuItem(new AbstractAction("Edit Nets..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InterfaceTreeUI.this.editNets();
                }
            }));
            items.add(visibleCheckbox);
            items.add(new JMenuItem(new OrbitGuiObjectActionRegistry.ActionShowDetails(null, (DbObject)selInterface, null, null)));
            visibleCheckbox.setSelected(((Interface)object).getVisible());
            JMenu selMenu = new InterfaceUI.ActionSelectInterfacePinMenu(selInterface).getJMenu();
            items.add(selMenu);
        }
        if (selInterface != null) {
            items.add(new JMenuItem(new AbstractAction("Export..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InterfaceTreeUI.this.exportSelectedNodes();
                }
            }));
            items.add(new JMenuItem(new AbstractAction("Delete"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InterfaceTreeUI.this.deleteObject();
                }
            }));
            items.add(new JMenuItem(new InterfaceUI.ActionContractInterfaces(selInterfaces.toArray(new Interface[0]))));
        }
        JMenu addSelector = null;
        if (selFloorplan != null && selTotalCount == 1) {
            items.add(new JMenuItem(new OrbitGuiObjectActionRegistry.ActionShowDetails(null, (DbObject)selFloorplan, null, null)));
            items.add(new JMenuItem(new FloorplanUI.ActionDynamicGlob(selFloorplan)));
            items.add(new JMenuItem(new FloorplanUI.ActionPartitionFloorplanByPersonality(selFloorplan)));
            JMenu viewSelector = new JMenu("Assign Pins by Area");
            items.add(viewSelector);
            JMenuItem mi = new JRadioButtonMenuItem(new AbstractAction("Inside"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InterfaceTreeUI.this.mAreaMode = Selection.AreaMode.Contain.toString();
                }
            });
            viewSelector.add(mi);
            mi.setSelected(this.mAreaMode.equals(Selection.AreaMode.Contain.toString()));
            UIUtil.setUniqueMnemonic((JMenu)viewSelector, (AbstractButton)mi);
            mi = new JRadioButtonMenuItem(new AbstractAction("Touching"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InterfaceTreeUI.this.mAreaMode = Selection.AreaMode.Touch.toString();
                }
            });
            viewSelector.add(mi);
            mi.setSelected(this.mAreaMode.equals(Selection.AreaMode.Touch.toString()));
            UIUtil.setUniqueMnemonic((JMenu)viewSelector, (AbstractButton)mi);
            items.add(useIOPadsCheckbox);
            useIOPadsCheckbox.setSelected(this.mUseIOPads);
            JMenu selMenu = new JMenu("Select");
            items.add(selMenu);
            selMenu.add(new JMenuItem(new AbstractAction("Descendant Floorplan Pins"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InterfaceTreeUI.this.selectPins(false);
                }
            }));
            selMenu.add(new JMenuItem(new AbstractAction("Floorplan Pins"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InterfaceTreeUI.this.selectPins(true);
                }
            }));
            mi = new JMenuItem(new AbstractAction("Add/Remove on Canvas"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignView2D.ViewMode sm = ((DesignView2D)OrbitIO.getCurView()).getMode("InteractiveSelectMode");
                    InteractiveSelectionUI.SelectFilter selDlg = sm == null ? null : ((InteractiveSelectMode)sm).getSelectFilter();
                    String geomType = selDlg == null ? "Standard" : selDlg.getGeometryType();
                    InterfaceTreeUI.this.mUserSelectedIntfModeActive = true;
                    switch (geomType) {
                        case "Standard": {
                            InterfaceTreeUI.this.mUserSelectedIntfMode = GeometryDrawerMode.Mode.START_RECTANGLE;
                            break;
                        }
                        case "Polygon": {
                            InterfaceTreeUI.this.mUserSelectedIntfMode = GeometryDrawerMode.Mode.START_POLYGON;
                            break;
                        }
                        case "Lasso": {
                            InterfaceTreeUI.this.mUserSelectedIntfMode = GeometryDrawerMode.Mode.START_LASSO;
                            break;
                        }
                        case "Path": {
                            InterfaceTreeUI.this.mUserSelectedIntfMode = GeometryDrawerMode.Mode.START_PATH;
                            break;
                        }
                        default: {
                            InterfaceTreeUI.this.mUserSelectedIntfMode = GeometryDrawerMode.Mode.START_RECTANGLE;
                        }
                    }
                    InterfaceTreeUI.this.associatePins(InterfaceTreeUI.this.mUserSelectedIntfMode);
                }
            });
            addSelector = new JMenu("Edit Pins");
            items.add(addSelector);
            addSelector.add(mi);
            UIUtil.setUniqueMnemonic((JMenu)addSelector, (AbstractButton)mi);
            mi = addSelector.add(new JMenuItem(new AbstractAction("Add Selected Pins"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InterfaceTreeUI.this.associateSelectedPins(false);
                }
            }));
            UIUtil.setUniqueMnemonic((JMenu)addSelector, (AbstractButton)mi);
            mi = addSelector.add(new JMenuItem(new AbstractAction("Remove Selected Pins"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InterfaceTreeUI.this.associateSelectedPins(true);
                }
            }));
            UIUtil.setUniqueMnemonic((JMenu)addSelector, (AbstractButton)mi);
            items.add(new JMenuItem(new FloorplanUI.ActionMovePinOnCursor(selFloorplan)));
        }
        if (selFloorplan != null && selFloorplanCount > 1) {
            items.add(new JMenuItem(new FloorplanUI.ActionSwapFloorplanPin(selFloorplans.toArray(new Floorplan[0]))));
        }
        if (selFloorplan != null) {
            if (addSelector == null) {
                addSelector = new JMenu("Edit Pins");
                items.add(addSelector);
            }
            JMenuItem mi = addSelector.add(new JMenuItem(new AbstractAction("Remove All Pins"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InterfaceTreeUI.this.removeAllPins();
                }
            }));
            UIUtil.setUniqueMnemonic((JMenu)addSelector, (AbstractButton)mi);
        }
    }

    public void populateMenuItems(List<JMenuItem> items) {
        IntfTreeNode parentNode = this.getSelectedIntfTreeNode(false);
        int selInterfaceCount = this.getNumInterfacesSelected(this.mTree.getSelectionModel());
        int selTotalCount = this.mTree.getSelectionModel().getSelectionCount();
        Object object = null;
        if (parentNode != null) {
            object = parentNode.getUserObject();
        }
        if (!this.doingGlobbing) {
            this.populateEditMenuItems(items, object);
        }
        if (selTotalCount > 1 && selInterfaceCount == selTotalCount) {
            JMenu menu = new JMenu("Set Selected");
            items.add(menu);
            menu.add(new JMenuItem(new AbstractAction("Visible"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InterfaceTreeUI.this.setSelectedVisible(true);
                }
            }));
            menu.add(new JMenuItem(new AbstractAction("Invisible"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InterfaceTreeUI.this.setSelectedVisible(false);
                }
            }));
        }
        if (selTotalCount > 0) {
            JMenu showMenu = new JMenu("Show");
            items.add(showMenu);
            showMenu.add(new JMenuItem(new AbstractAction("Me All Pins"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InterfaceTreeUI.this.showMeAllSelected();
                }
            }));
            showMenu.add(new JMenuItem(new AbstractAction("Me All Pins and Zoom"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    APair<Integer, ARect> ans = InterfaceTreeUI.this.showMeAndZoomNear(null, null, null);
                    if (ans.second == null) {
                        return;
                    }
                    ((ARect)ans.second).changeSizeBy((Integer)ans.first > 1 ? 0.1 : 15.0);
                    ((DesignView2D)OrbitIO.getCurView()).getCanvas().getXForm().setWorld((ARect)ans.second);
                    ((DesignView2D)OrbitIO.getCurView()).getCanvas().refresh();
                }
            }));
            items.add(new JMenuItem(new AbstractAction("Zoom To"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InterfaceTreeUI.this.zoomTo();
                }
            }));
        }
    }

    protected LinkedList<JMenuItem> createContextMenu() {
        LinkedList<JMenuItem> menuItems = new LinkedList<JMenuItem>();
        this.populateMenuItems(menuItems);
        return menuItems;
    }

    public void refreshNetTable() {
        if (this.mSelectedInterface != null) {
            this.mInterfaceNetsPanel.setupArray(this.mSelectedInterface);
        }
        this.mInterfaceNetsPanel.setupColumns();
    }

    public void setInterfaceMode(GeometryDrawerMode mode) {
        this.mInterfacePinGeometryMode = mode;
    }

    public static void swapPins(DevicePath origDevPath, PinInstance origPinInst, HierPinTempWithNetAndInterface h1, DevicePath newDevPath, PinInstance newPinInst, HierPinTempWithNetAndInterface h2, BundleMover bundleMover) {
        PinTemplate origPinTemplate = origPinInst.getPinTemplate();
        PinTemplate newPinTemplate = newPinInst.getPinTemplate();
        bundleMover.moveBundlePin(origDevPath, origPinInst, newDevPath, newPinInst);
        bundleMover.moveBundlePin(newDevPath, newPinInst, origDevPath, origPinInst);
        NetMap.resetNet((HierInst)new HierInst(origDevPath, (DbObject)origPinTemplate), (Net)h2.getNet(), (boolean)true);
        NetMap.resetNet((HierInst)new HierInst(newDevPath, (DbObject)newPinTemplate), (Net)h1.getNet(), (boolean)true);
    }

    public static void swapPins(FloorplanPin pin1, FloorplanPin pin2, BundleMover bundleMover) {
        Net net1 = pin1.getSubstrateNet();
        Net net2 = pin2.getSubstrateNet();
        Floorplan floorplan1 = pin1.getOwner();
        Floorplan floorplan2 = pin2.getOwner();
        bundleMover.moveBundlePin(pin1.getDevicePath(), pin1.getAnInstance(), pin2.getDevicePath(), pin2.getAnInstance());
        bundleMover.moveBundlePin(pin2.getDevicePath(), pin2.getAnInstance(), pin1.getDevicePath(), pin1.getAnInstance());
        pin1.setNet(net2);
        pin2.setNet(net1);
        pin1.setOwner(floorplan2);
        pin2.setOwner(floorplan1);
    }

    public static void swapPins(Db db, String keyStr1, String keyStr2) {
        Floorplan floorplan1 = (Floorplan)db.getByKeyStr(Floorplan.class, keyStr1);
        Floorplan floorplan2 = (Floorplan)db.getByKeyStr(Floorplan.class, keyStr2);
        if (floorplan1 == null || floorplan2 == null) {
            ALog.logWarn((String)"Invalid floorplan from '%s' or '%s'", (Object[])new Object[]{keyStr1, keyStr2});
            return;
        }
        try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)db, (String)"Swap Floorplan Pins");){
            List personalities1 = floorplan1.getPersonalitiesOfPins();
            for (Personality personality : personalities1) {
                BundleMover bundleMover = new BundleMover();
                bundleMover.startBundleMove();
                List list1 = floorplan1.getPinsWithPersonality(personality);
                List list2 = floorplan2.getPinsWithPersonality(personality);
                Collections.sort(list1, FloorplanPin.CompareLocation);
                Collections.sort(list2, FloorplanPin.CompareLocation);
                for (int i = 0; i < Math.min(list1.size(), list2.size()); ++i) {
                    InterfaceTreeUI.swapPins((FloorplanPin)list1.get(i), (FloorplanPin)list2.get(i), bundleMover);
                }
                bundleMover.endBundleMove();
            }
        }
        OrbitApp.getApp().refreshCurrentView(false);
    }

    static {
        InterfaceTreeUI.registerInterfaceUI();
        mUIs = new WeakHashMap();
        ColorOk = AColor.mix((Color)Color.GREEN, (Color)Color.WHITE, (float)0.3f);
        ColorWarn = AColor.mix((Color)Color.YELLOW, (Color)Color.WHITE, (float)0.3f);
        ColorErr = AColor.mix((Color)Color.RED, (Color)Color.WHITE, (float)0.3f);
        ColorInherit = AColor.mix((Color)Color.CYAN, (Color)Color.WHITE, (float)0.3f);
        ColorOkSelected = AColor.mix((Color)Color.GREEN, (Color)Color.WHITE, (float)0.7f);
        ColorWarnSelected = AColor.mix((Color)Color.YELLOW, (Color)Color.WHITE, (float)0.7f);
        ColorErrSelected = AColor.mix((Color)Color.RED, (Color)Color.WHITE, (float)0.7f);
        ColorInheritSelected = AColor.mix((Color)Color.CYAN, (Color)Color.WHITE, (float)0.7f);
        ColorWhiteSelected = AColor.mix((Color)Color.GRAY, (Color)Color.WHITE, (float)0.3f);
        mRepolulateDisabled = false;
        listOfTempMovedNets = null;
        listOfTempMovedPins = null;
        visibleCheckbox = new JCheckBoxMenuItem(new AbstractAction("Visible", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                Interface intf = theInterfaceTreeUI.getSelected(null);
                Cp.exec((String)("com.sigrity.acl.db.std.Interface.setVisible(curDb(), \"" + intf.toStringPath() + "\", " + Boolean.toString(visibleCheckbox.getState()) + ");"), (Object[])new Object[0]);
            }
        });
        useIOPadsCheckbox = new JCheckBoxMenuItem(new AbstractAction("Use IO Pads", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                Cp.exec((String)"com.sigrity.orbit.ui.InterfaceTreeUI.setUseIOPads(%b);", (Object[])new Object[]{useIOPadsCheckbox.getState()});
                InterfaceTreeUI.theInterfaceTreeUI.mUseIOPads = useIOPadsCheckbox.getState();
            }
        });
    }

    protected class HistoryListener
    extends DbHistory.ListenerAdapter {
        protected HistoryListener() {
        }

        public void endUndoRedo(boolean isRedo) {
            Interface.resetAllStatus((Db)OrbitIO.getCurDb());
            InterfaceTreeUI.scheduleRepopulateTree();
        }
    }

    protected static class ActionShowMeNetOnAllSubstrates
    extends AbstractAction {
        protected Net mNet;

        public ActionShowMeNetOnAllSubstrates(Net net) {
            super("Select this net on all substrates");
            this.mNet = net;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Design currentDesign = OrbitIO.getCurDesign();
            Selection s = currentDesign.getCurSelection();
            s.clearData(true);
            DeviceTemplate template = this.mNet.getDeviceTemplate();
            for (DevicePath devPath : template.getHierarchicalInstances()) {
                for (NetMap cur : NetMap.getConnectedNets((Net)this.mNet, (DevicePath)devPath)) {
                    NetCmd.selectNet((Net)cur.getChildNet(), (boolean)true, (Selection)s);
                    s.add((DbObject)cur.getChildNet());
                }
            }
            NetCmd.selectNet((Net)this.mNet, (boolean)true, (Selection)s);
            s.add((DbObject)this.mNet);
            OrbitApp.getApp().refreshCurrentView(false);
        }
    }

    protected static class ActionCreateChildInterface
    extends AbstractAction {
        protected Interface mParentInf;
        protected List<Net> mNets;

        public ActionCreateChildInterface(Interface parentInf, List<Net> childNets) {
            super(String.format("Create Child Interface by Nets (%d)", childNets.size()));
            this.mParentInf = parentInf;
            this.mNets = childNets;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object childName = this.mParentInf.getName() + "-child";
            childName = Interface.getUniqueName((Db)this.mParentInf.getDb(), (String)childName);
            Interface childInterface = (Interface)Cp.exec((String)"Interface.create(curDb(), \"%s\", curDb().getByKeyStr(Interface.class, \"%s\"), %d, %b);", (Object[])new Object[]{childName, this.mParentInf.getKeyStr(), this.mNets.size(), true});
            String path = childInterface.toStringPath();
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)"Edit Floorplan Nets");){
                for (Net net : this.mNets) {
                    Cp.exec((String)"com.sigrity.acl.db.std.Interface.addNet(OrbitIO.getCurDb(), \"%s\", \"%s\");", (Object[])new Object[]{path, net.getKeyStr()});
                }
            }
            Cp.exec((String)"com.sigrity.orbit.ui.InterfaceTreeUI.assignExistingPinsToFloorplanForAllDecendents(OrbitIO.getCurDb(), \"%s\");", (Object[])new Object[]{path});
            OrbitIO.getApp().refreshCurrentView(false);
        }
    }

    protected static class ActionSelectPinsOfNets
    extends AbstractAction {
        protected List<Net> mNets;

        public ActionSelectPinsOfNets(List<Net> nets) {
            super(String.format("Select Pins of Nets (%d)", nets.size()));
            this.mNets = nets;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Design currentDesign = OrbitIO.getCurDesign();
            Selection s = currentDesign.getCurSelection();
            s.clearData(true);
            DeviceTemplate dt = InterfaceTreeUI.theInterfaceTreeUI.mSelectedInterface.getDeviceTemplateForReferencedSubstrate();
            for (Net net : this.mNets) {
                NetCmd.selectNetPins((Net)net, (boolean)true, (Selection)s, (DeviceTemplate)dt);
            }
            OrbitApp.getApp().refreshCurrentView(false);
        }
    }

    protected static class ActionAssignExistingPinsToFloorplan
    extends AbstractAction {
        public ActionAssignExistingPinsToFloorplan() {
            super("Assign Existing Pins of Key Nets to Floorplans");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec((String)"com.sigrity.orbit.ui.InterfaceTreeUI.assignExistingPinsToFloorplanForAllDecendents(curDb(), \"%s\");", (Object[])new Object[]{InterfaceTreeUI.theInterfaceTreeUI.mSelectedInterface.toStringPath()});
            theInterfaceTreeUI.refreshNetTable();
            InterfaceTreeUI.scheduleRepopulateTree();
            OrbitApp.getApp().refreshCurrentView(false);
        }
    }

    protected static class ActionExportNetsTable
    extends AbstractAction {
        public ActionExportNetsTable() {
            super("Export Nets Table...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AFileChooser fc = new AFileChooser();
            AFileFilter filter = new AFileFilter("csv", "Interface Nets Table File");
            fc.setFileFilter((FileFilter)filter);
            if (fc.showSaveDialog((Component)OrbitIO.getMainWindow()) != 0) {
                return;
            }
            File f = fc.getSelectedFile();
            Object path = f.getPath();
            if (fc.getFileFilter() == filter && !f.getName().contains(".")) {
                path = (String)path + ".csv";
            }
            Cp.exec((String)"com.sigrity.acl.db.std.Interface.exportNetsTable(curDb(), %s, \"%s\", true);", (Object[])new Object[]{Cp.getFileAsArgument((String)path), InterfaceTreeUI.theInterfaceTreeUI.mSelectedInterface.toStringPath()});
        }
    }

    protected static class ActionAutoAssignToFloorplan
    extends AbstractAction {
        public ActionAutoAssignToFloorplan(String txt) {
            super(txt);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InterfaceTreeUI.theInterfaceTreeUI.mChangingDbObjects = true;
            Cp.exec((String)"com.sigrity.acl.db.std.Interface.autoAssignNetsToPins(curDb(), \"%s\");", (Object[])new Object[]{InterfaceTreeUI.theInterfaceTreeUI.mSelectedInterface.getKeyStr()});
            InterfaceTreeUI.theInterfaceTreeUI.mChangingDbObjects = false;
            if (Interface.getAutoAssignWarning() != null) {
                OrbitApp.logAndDisplayWarningDialog((String)Interface.getAutoAssignWarning(), (String)"Warning");
            }
            theInterfaceTreeUI.refreshNetTable();
            OrbitApp.getApp().refreshCurrentView(false);
        }
    }

    class FpIoPins
    implements Globber.GlobberHelper {
        boolean mMovingAsIfAtParentLevel;
        boolean mMovePinsInDecendents;

        public FpIoPins(ChooseCandidates chooseCandidates) {
            this.mMovingAsIfAtParentLevel = chooseCandidates.mMovingAsIfAtParentLevel;
            this.mMovePinsInDecendents = chooseCandidates.mMovePinsInDecendents;
        }

        @Override
        public void registerMenuItem(Globber g, LinkedList<Action> menuItems) {
            DesignView2D v2 = (DesignView2D)OrbitIO.getCurView();
            class StealingAction
            extends AbstractAction {
                public StealingAction() {
                    super("Allow stealing");
                    this.putValue("SwingSelectedKey", true);
                    if (!InterfaceTreeUI.this.mAllowStealing) {
                        this.putValue("InitUnChecked", true);
                    }
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractButton abstractButton = (AbstractButton)e.getSource();
                    Cp.exec((String)"com.sigrity.orbit.ui.InterfaceTreeUI.setAllowStealing(%s);", (Object[])new Object[]{Boolean.toString(abstractButton.getModel().isSelected())});
                }
            }
            v2.getCanvas().getActionMap().put("Allow stealing", new StealingAction());
            class IoPadsAction
            extends AbstractAction {
                public IoPadsAction() {
                    super("Use I/O Pads");
                    this.putValue("SwingSelectedKey", true);
                    if (!InterfaceTreeUI.this.mUseIOPads) {
                        this.putValue("InitUnChecked", true);
                    }
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractButton abstractButton = (AbstractButton)e.getSource();
                    Cp.exec((String)"com.sigrity.orbit.ui.InterfaceTreeUI.setUseIOPads(%s);", (Object[])new Object[]{Boolean.toString(abstractButton.getModel().isSelected())});
                }
            }
            v2.getCanvas().getActionMap().put("Use I/O Pads", new IoPadsAction());
            Action newGlobber = v2.getCanvas().getActionMap().get("Allow stealing");
            if (newGlobber != null) {
                Globber.getMenuItems().add(newGlobber);
                newGlobber = v2.getCanvas().getActionMap().get("Use I/O Pads");
                Globber.getMenuItems().add(newGlobber);
            }
        }

        @Override
        public boolean portOk(HierPort hp) {
            return true;
        }

        @Override
        public void onGlobbingDone(Globber g, boolean accept, boolean uninstallingMode) {
            OrbitIO.getApp().refreshCurrentView(false);
            DesignView2D v2d = (DesignView2D)OrbitIO.getCurView();
            if (v2d == null) {
                return;
            }
            v2d.setBeingMoved(null);
            Db db = OrbitIO.getCurDb();
            InterfaceTreeUI.this.setGlobbingPartialFloorplan(null);
            if (accept) {
                boolean connectionsNeedToUpdate = db.getObjectCount(Connection.class) > 0;
                Set<HierPinT> results = g.getResults();
                DevicePath aDevicePath = results.iterator().next().getPath();
                aDevicePath = aDevicePath.pathToSubstrate();
                InterfaceTreeUI.this.mChangingDbObjects = true;
                InterfaceTreeUI.this.mSelectedFloorplan.setAlignmentAlgo(g.getOptAlgorithm());
                DiffPairFinder.setInitialDiffPairAlog((Db)db, (String)g.getOptAlgorithm());
                try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)db, (String)"Globber");){
                    if (mTemporaryGlobbingFloorplan != null) {
                        mTemporaryGlobbingFloorplan.getMyInterface().getParent().resetInterfaceStatus();
                    }
                    if (mTemporaryGlobbingFloorplan != null || !this.mMovingAsIfAtParentLevel && InterfaceTreeUI.this.mSelectedFloorplan.getParentFloorplan() != null && InterfaceTreeUI.this.mSelectedFloorplan.getMyInterface().getParent() != null) {
                        InterfaceTreeUI.this.mSelectedFloorplan.movePinsToParent(true);
                    } else {
                        InterfaceTreeUI.this.mSelectedFloorplan.removePins(true, this.mMovePinsInDecendents);
                    }
                    ArrayList<HierPinT> addList = new ArrayList<HierPinT>(results);
                    Collections.sort(addList, HierPinT.CompareLocation);
                    InterfaceTreeUI.this.mSelectedFloorplan.addHierPinT(addList);
                    this.recordLastGlobSolution();
                    Interface.reAssignNetsToFloorplanPins((Floorplan)InterfaceTreeUI.this.mSelectedFloorplan, (boolean)InterfaceTreeUI.this.mPinsInDecendentsNotBeingGlobbed, (DevicePath)aDevicePath);
                    this.moveAffectedBundlePins(addList);
                    InterfaceTreeUI.this.mHierPinTempWithNetAndInterface = null;
                    if (mTemporaryGlobbingFloorplan != null) {
                        InterfaceTreeUI.restoreOriginalPinOwnersIfNecessary(false);
                    }
                    if (Interface.getAutoAssignWarning() != null) {
                        OrbitApp.logAndDisplayWarningDialog((String)Interface.getAutoAssignWarning(), (String)"Warning");
                        Interface.resetAutoAssignWarning();
                    }
                    if (connectionsNeedToUpdate) {
                        HConnEngine ce = new HConnEngine(OrbitIO.getCurDb());
                        ce.createConnections();
                    }
                }
                InterfaceTreeUI.this.mChangingDbObjects = false;
            } else if (InterfaceTreeUI.this.mHasPins) {
                InterfaceTreeUI.restoreOriginalPinOwnersIfNecessary(false);
                InterfaceTreeUI.this.mChangingDbObjects = false;
                InterfaceTreeUI.this.mSelectedFloorplan.getMyInterface().clearHierPinTempWithNetAndInterface();
            } else {
                InterfaceTreeUI.restoreOriginalPinOwnersIfNecessary(false);
            }
            if (mTemporaryGlobbingFloorplan != null) {
                Interface curInterface = mTemporaryGlobbingFloorplan.getMyInterface();
                curInterface.setParent(null);
                curInterface.deleteFromDb();
                mTemporaryGlobbingFloorplan = null;
            }
            InterfaceTreeUI.this.doingGlobbing = false;
            if (!uninstallingMode && InterfaceTreeUI.this.mPrevMode != null) {
                v2d.setMode(InterfaceTreeUI.this.mPrevMode);
                InterfaceTreeUI.this.mUserSelectedIntfModeActive = InterfaceTreeUI.this.mPrevMode.getName().contains("Edit pins of floorplan");
            }
            InterfaceTreeUI.scheduleRepopulateTree();
        }

        private void recordLastGlobSolution() {
            String fieldName = "lastGLobSolution";
            if (InterfaceTreeUI.this.mSelectedFloorplan != null) {
                DbFieldDef fd = InterfaceTreeUI.this.mSelectedFloorplan.getDbClass().getField(fieldName);
                if (fd == null) {
                    InterfaceTreeUI.this.mSelectedFloorplan.getDbClass().addSoftField(fieldName, APair.class, false);
                }
                InterfaceTreeUI.this.mSelectedFloorplan.setValue(fieldName, Globber.getLastSolution());
            }
        }

        private void moveAffectedBundlePins(List<HierPinT> addList) {
            BundleMover bMover = new BundleMover();
            bMover.startBundleMove();
            for (HierPinTempWithNetAndInterface cur : InterfaceTreeUI.this.mHierPinTempWithNetAndInterface) {
                if (cur.getPinTemplate().getNet().isUnused() || cur.getSubstrateNet() == cur.getNet()) continue;
                Net tmp = cur.getNet();
                HierPinTempWithNetAndInterface other = HierPinTempWithNetAndInterface.find(InterfaceTreeUI.this.mHierPinTempWithNetAndInterface, (Net)cur.getSubstrateNet());
                if (other == null) continue;
                cur.setNet(other.getNet());
                other.setNet(tmp);
            }
            for (HierPinT hierPin : addList) {
                HierPinTempWithNetAndInterface trpl = HierPinTempWithNetAndInterface.find(InterfaceTreeUI.this.mHierPinTempWithNetAndInterface, (HierPinT)hierPin);
                if (trpl == null) continue;
                DevicePath originalAbsDevicePath = trpl.getPath();
                Device originalDevice = originalAbsDevicePath.getLast();
                if (originalDevice == null) {
                    DeviceTemplate dt = originalAbsDevicePath.getDeviceTemplate();
                    originalDevice = dt.getAnInstance();
                }
                PinInstance originalPinInstance = originalDevice.getPin(trpl.getPinTemplate());
                DevicePath newAbsDevicePath = hierPin.getPath();
                Device newDevice = newAbsDevicePath.getLast();
                if (newDevice == null) {
                    DeviceTemplate dt = newAbsDevicePath.getDeviceTemplate();
                    newDevice = dt.getAnInstance();
                }
                PinTemplate newPinTemplate = hierPin.getPin();
                PinInstance newPinInstance = newDevice.getPin(newPinTemplate);
                DevicePath path = newAbsDevicePath.getRelativePathFromAnchor(InterfaceTreeUI.this.mSelectedFloorplan.getDeviceTemplate());
                if (!this.mMovingAsIfAtParentLevel && InterfaceTreeUI.this.mSelectedFloorplan.getParentFloorplan() != null) {
                    HierPinTempWithNetAndInterface cur = InterfaceTreeUI.this.mSelectedFloorplan.getMyInterface().findInParentHier(path, newPinInstance);
                    InterfaceTreeUI.swapPins(trpl.getPath(), originalPinInstance, trpl, path, newPinInstance, cur, bMover);
                    FloorplanPin fpOldPin = originalPinInstance.getPinTemplate().findFloorplanPin(trpl.getPath());
                    if (fpOldPin != null && fpOldPin.getMyInterface() != cur.getInterface()) {
                        fpOldPin.moveToInterface(cur.getInterface());
                    }
                } else {
                    bMover.moveBundlePin(trpl.getPath(), originalPinInstance, path, newPinInstance);
                }
                FloorplanPin fpPin = newPinTemplate.findFloorplanPin(path);
                if (this.mMovePinsInDecendents || fpPin.getMyInterface() == trpl.getInterface()) continue;
                fpPin.moveToInterface(trpl.getInterface());
            }
            bMover.endBundleMove();
        }
    }

    protected static class ChooseCandidates {
        int cnt = 0;
        int numInOtherFloorplans = 0;
        int numWithNetsAssigned = 0;
        HashSet<HierPort> candidates = null;
        Floorplan mFloorplan;
        boolean mIncludeNonePersonality;
        List<Personality> mPersonalitiesFilter;
        Set<PinTemplate.Type> ignorePinTypes;
        boolean mAllowStealing;
        boolean mUseIOPads;
        boolean mMovingAsIfAtParentLevel;
        boolean mMovePinsInDecendents;

        int getCnt() {
            return this.cnt;
        }

        int getNumInOtherFloorplans() {
            return this.numInOtherFloorplans;
        }

        int getNumWithNetsAssigned() {
            return this.numWithNetsAssigned;
        }

        HashSet<HierPort> getCandidates() {
            return this.candidates;
        }

        boolean isValidCandidate(DevicePath dp, PinTemplate pinTemplate) {
            FloorplanPin fpPin;
            if (this.ignorePinTypes.contains(pinTemplate.getType())) {
                return false;
            }
            if (!this.mUseIOPads && pinTemplate.getType() == PinTemplate.Type.IOPAD) {
                return false;
            }
            boolean allowStealing = this.mAllowStealing;
            int numParentFPPins = this.mFloorplan.getNumParentFloorplanPins(false);
            int numInThis = this.mFloorplan.getNumFloorplanPins(true);
            if (this.mFloorplan.getParentFloorplan() != null && numParentFPPins + numInThis >= this.mFloorplan.getMyInterface().getExpectedIOCount()) {
                boolean restrictToParent = true;
                Floorplan parentFp = this.mFloorplan.getParentFloorplan();
                FloorplanPin fpPin2 = pinTemplate.findFloorplanPin(dp);
                if (this.mMovingAsIfAtParentLevel) {
                    restrictToParent = false;
                    if (fpPin2 != null && fpPin2.getOwner() != this.mFloorplan && !allowStealing) {
                        return false;
                    }
                }
                boolean bl = allowStealing = this.mAllowStealing || restrictToParent && parentFp != null && !this.mFloorplan.isInSiblingOrDescendantsOfSibling(fpPin2);
                if (restrictToParent) {
                    if (fpPin2 != null && parentFp != null && fpPin2.getMyInterface() == parentFp.getMyInterface()) {
                        return true;
                    }
                    if (fpPin2 != null && allowStealing && this.mFloorplan.isInSiblingOrDescendantsOfSibling(fpPin2)) {
                        return true;
                    }
                    if (fpPin2 == null ? this.mFloorplan.getMyInterface().getParent() != null : !this.mFloorplan.isInThisOrParentOrHasNoParent(fpPin2) && (!allowStealing || !this.mFloorplan.isInSiblingOrDescendantsOfSibling(fpPin2))) {
                        return false;
                    }
                }
            } else if (!this.mAllowStealing && (fpPin = pinTemplate.findFloorplanPin(dp)) != null && this.mFloorplan.contains(fpPin, true, true) == null) {
                ++this.numInOtherFloorplans;
                return false;
            }
            if (!allowStealing && !this.mFloorplan.getMyInterface().isNetUnusedOrKeyNetIncludingMappings(NetMap.getSubstrateNet((Net)pinTemplate.getNet(), (DevicePath)dp, (boolean)true), this.mFloorplan)) {
                ++this.numWithNetsAssigned;
                return false;
            }
            return true;
        }

        List<Personality> getPersonalityList(PinTemplate pinTemplate, DevicePath dp) {
            APair validAndPersonalityList = PersonalityMap.getPersonalityList((PinTemplate)pinTemplate, (DevicePath)dp);
            if (!((Boolean)validAndPersonalityList.first).booleanValue()) {
                return null;
            }
            return (List)validAndPersonalityList.second;
        }

        void addCandidates(DevicePath dp, PinTemplate pinTemplate) {
            ++this.cnt;
            for (PortTemplate pt : pinTemplate.getPortTemplates()) {
                HierPort hp = new HierPort(dp, pt);
                this.candidates.add(hp);
            }
        }

        private void generateCandidates() {
            this.candidates = new HashSet();
            DeviceTemplate template = this.mFloorplan.getDeviceTemplate();
            boolean hasPinsInDescendants = this.mFloorplan.getNumFloorplanPins(true) - this.mFloorplan.getNumFloorplanPins(false) > 0;
            Floorplan parentFp = this.mFloorplan.getParentFloorplan();
            for (DevicePath devicePath : template.getHierarchicalInstances()) {
                for (DevicePath dp : devicePath.getDescendants()) {
                    DeviceTemplate dt = dp.getDeviceTemplate();
                    if (dt.getSubstrate() != template.getSubstrate() || !this.mFloorplan.canBeIn(dp)) continue;
                    block2: for (PinTemplate pinTemplate : dt.getPins()) {
                        Net substrateNet = NetMap.getSubstrateNet((Net)pinTemplate.getNet(), (DevicePath)dp, (boolean)true);
                        Floorplan descendantFloorplan = this.mFloorplan.getDescendantFloorplanForNet(substrateNet, true);
                        if (!this.mMovePinsInDecendents && hasPinsInDescendants && descendantFloorplan != null && descendantFloorplan != this.mFloorplan) continue;
                        List<Personality> pinPerList = null;
                        if (!this.isValidCandidate(dp, pinTemplate) || (pinPerList = this.getPersonalityList(pinTemplate, dp)) == null) continue;
                        FloorplanPin fpPin = pinTemplate.findFloorplanPin(dp);
                        if (fpPin != null && (fpPin.getOwner() == this.mFloorplan || parentFp != null && fpPin.getMyInterface() == parentFp.getMyInterface())) {
                            this.addCandidates(dp, pinTemplate);
                            continue;
                        }
                        if (this.mIncludeNonePersonality && pinPerList.isEmpty()) {
                            this.addCandidates(dp, pinTemplate);
                            continue;
                        }
                        for (Personality personality : pinPerList) {
                            if (!this.mPersonalitiesFilter.isEmpty() && !this.mPersonalitiesFilter.contains(personality)) continue;
                            this.addCandidates(dp, pinTemplate);
                            continue block2;
                        }
                    }
                }
            }
        }

        public ChooseCandidates(Floorplan floorplan, boolean allowStealing, boolean useIOPad, List<Personality> personalitiesFilter, boolean includeNone) {
            this.mAllowStealing = allowStealing;
            this.mUseIOPads = useIOPad;
            this.mMovingAsIfAtParentLevel = false;
            this.mMovePinsInDecendents = false;
            this.mFloorplan = floorplan;
            int numParentFPPins = this.mFloorplan.getNumParentFloorplanPins(false);
            Floorplan parentFp = this.mFloorplan.getParentFloorplan();
            if (parentFp != null && numParentFPPins == 0) {
                this.mMovingAsIfAtParentLevel = true;
            } else {
                int numInDecendents = floorplan.getNumFloorplanPins(true) - floorplan.getNumFloorplanPins(false);
                int numPinsToGlob = floorplan.getMyInterface().getExpectedIOCount() - numInDecendents;
                if (numPinsToGlob == 0) {
                    this.mMovePinsInDecendents = true;
                    this.mMovingAsIfAtParentLevel = true;
                }
            }
            this.mIncludeNonePersonality = includeNone;
            this.mPersonalitiesFilter = personalitiesFilter;
            this.ignorePinTypes = AUtil.hashSet((Object[])((PinTemplate.Type[])Settings.get((String)"UserPreferences", (String)"DefaultSelectIgnorePinTypes", (Object)OrbitIOSettings.DEFAULT_SELECT_IGNORE_PIN_TYPES_DEFAULT)));
            this.generateCandidates();
        }

        public ChooseCandidates(Floorplan floorplan, boolean allowStealing, boolean useIOPad) {
            this(floorplan, allowStealing, useIOPad, floorplan.getIOPersonalities(), floorplan.getIncludeNoneInIOPersonalityList());
        }
    }

    public class EditPinsAdaptor
    implements GeometryDrawerMode.GeometryDrawerHelper {
        @Override
        public String getModeName() {
            return "Edit pins of floorplan";
        }

        @Override
        public void selectByArea(AGeom worldGeom, boolean outlineOnlyMode, boolean shiftPressed, boolean ctrlPressed) {
            InterfaceTreeUI.this.selectPinsByArea(worldGeom, outlineOnlyMode, shiftPressed, ctrlPressed);
        }

        @Override
        public void cancelDrawingMode() {
            InterfaceTreeUI.this.setInterfaceMode(null);
            InterfaceTreeUI.this.mIntfMode = null;
        }

        @Override
        public AGeom getSpotlightGeom() {
            return null;
        }
    }

    protected class ActionDynamicGlobPins
    extends AbstractAction {
        protected int mRow;
        protected int mNumRows;
        protected int mColumn;
        protected InterfaceStatus mInterfaceStatus;
        protected Floorplan mFloorplan;
        protected JTable mTable;
        protected boolean mPickedRowSelected;

        public ActionDynamicGlobPins(int curRow, int column, InterfaceStatus interfaceStatus, JTable table) {
            super("Dynamic Glob selected pins of Floorplan '" + interfaceStatus.getFloorplan(column).getName() + "'");
            this.mColumn = column;
            this.mFloorplan = interfaceStatus.getFloorplan(column);
            this.mRow = curRow;
            this.mInterfaceStatus = interfaceStatus;
            this.mTable = table;
            this.mPickedRowSelected = false;
            this.mNumRows = 0;
            for (int row : this.mTable.getSelectedRows()) {
                ++this.mNumRows;
                if (row != this.mRow) continue;
                this.mPickedRowSelected = true;
            }
            if (!this.mPickedRowSelected) {
                ++this.mNumRows;
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InterfaceTreeUI.this.globSelectedNets(this.mFloorplan, this.mTable, this.mNumRows, this.mRow, this.mColumn, this.mPickedRowSelected);
        }
    }

    protected static class ActionClearSelectedRows
    extends AbstractAction {
        protected JTable mTable;

        public ActionClearSelectedRows(JTable table) {
            super("Clear Selected Rows");
            this.mTable = table;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.mTable.clearSelection();
        }
    }

    public static class TempMovePin {
        protected Db mDb;
        protected FloorplanPin mFpPin;
        protected Floorplan mFromFloorplan;
        protected Floorplan mToFloorplan;

        public TempMovePin(Db db, String pin, String toIntf) {
            this.mDb = db;
            this.mFpPin = (FloorplanPin)db.getByKeyStr(FloorplanPin.class, pin);
            this.mFromFloorplan = this.mFpPin.getOwner();
            Interface toInterface = Interface.find((Db)db, (String)toIntf);
            this.mToFloorplan = toInterface.getFloorplan(this.mFromFloorplan.getDeviceTemplate(), true);
            this.mFpPin.setOwner(this.mToFloorplan);
        }

        public void moveBack() {
            if (this.mFromFloorplan == null || this.mFromFloorplan.getMyInterface() == null) {
                return;
            }
            this.mFromFloorplan.getMyInterface().resetInterfaceStatus();
        }
    }

    public static class TempMoveNet {
        protected Db mDb;
        protected String mNetKeyStr;
        protected String mFromInterfaceStr;
        protected String mToInterfaceStr;

        public TempMoveNet(Db db, String net, String from, String to) {
            this.mDb = db;
            this.mNetKeyStr = net;
            this.mFromInterfaceStr = from;
            this.mToInterfaceStr = to;
            Interface.removeNet((Db)this.mDb, (String)from, (String)net, (boolean)false);
            Interface.addNet((Db)this.mDb, (String)to, (String)net);
        }

        public void moveBack() {
            Interface.moveNet((Db)this.mDb, (String)this.mToInterfaceStr, (String)this.mFromInterfaceStr, (String)this.mNetKeyStr);
        }
    }

    protected class ActionShowMeRowAndZoom
    extends AbstractAction {
        protected int mRow;
        protected InterfaceStatus mInterfaceStatus;
        protected JTable mTable;

        public ActionShowMeRowAndZoom(int row, InterfaceStatus interfaceStatus, JTable table) {
            super("Show Me All Pins In Row(s) and Zoom");
            this.mRow = row;
            this.mInterfaceStatus = interfaceStatus;
            this.mTable = table;
        }

        public APair<Integer, ARect> processRow(int row, APair<Integer, ARect> ans) {
            InterfaceStatus.StatusEntry statusEntry = this.mInterfaceStatus.getEntry(row);
            for (FloorplanPin pin : InterfaceTreeUI.this.mInterfaceNetsPanel.getInterfaceStatus().listOfFPPins(statusEntry, null)) {
                ans = InterfaceTreeUI.this.addShowMe(pin, ans == null ? 0 : (Integer)ans.first, ans == null ? null : (ARect)ans.second, ans);
            }
            return ans;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            APair<Integer, ARect> ans = null;
            boolean found = false;
            for (int row : this.mTable.getSelectedRows()) {
                ans = this.processRow(row, ans);
                if (row != this.mRow) continue;
                found = true;
            }
            if (!found) {
                ans = this.processRow(this.mRow, ans);
            }
            if (ans.second == null) {
                return;
            }
            ((ARect)ans.second).changeSizeBy((Integer)ans.first > 1 ? 0.1 : 15.0);
            ((DesignView2D)OrbitIO.getCurView()).getCanvas().getXForm().setWorld((ARect)ans.second);
            ((DesignView2D)OrbitIO.getCurView()).getCanvas().refresh();
        }
    }

    protected class ActionShowMeRow
    extends AbstractAction {
        protected int mRow;
        protected InterfaceStatus mInterfaceStatus;
        protected JTable mTable;

        public ActionShowMeRow(int row, InterfaceStatus interfaceStatus, JTable table) {
            super("Show Me All Pins in Row(s)");
            this.mRow = row;
            this.mInterfaceStatus = interfaceStatus;
            this.mTable = table;
        }

        public APair<Integer, ARect> processRow(int row, APair<Integer, ARect> ans) {
            InterfaceStatus.StatusEntry statusEntry = this.mInterfaceStatus.getEntry(row);
            for (FloorplanPin pin : InterfaceTreeUI.this.mInterfaceNetsPanel.getInterfaceStatus().listOfFPPins(statusEntry, null)) {
                InterfaceTreeUI.this.addShowMe(pin, 0, null, ans);
            }
            return ans;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            APair<Integer, ARect> ans = null;
            boolean found = false;
            for (int row : this.mTable.getSelectedRows()) {
                ans = this.processRow(row, ans);
                if (row != this.mRow) continue;
                found = true;
            }
            if (!found) {
                ans = this.processRow(this.mRow, ans);
            }
            if (ans == null) {
                return;
            }
            if (ans.second == null) {
                return;
            }
            ((ARect)ans.second).changeSizeBy((Integer)ans.first > 1 ? 0.1 : 15.0);
            ((DesignView2D)OrbitIO.getCurView()).getCanvas().getXForm().setWorld((ARect)ans.second);
            ((DesignView2D)OrbitIO.getCurView()).getCanvas().refresh();
        }
    }

    protected class ActionShowZoomNearMe
    extends AbstractAction {
        protected int mRow;
        protected int mColumn;
        protected InterfaceStatus mInterfaceStatus;
        protected JTable mTable;

        public ActionShowZoomNearMe(int row, int column, InterfaceStatus interfaceStatus, JTable table) {
            super("Show Me and Zoom Near");
            this.mRow = row;
            this.mColumn = column;
            this.mInterfaceStatus = interfaceStatus;
            this.mTable = table;
        }

        public APair<Integer, ARect> processRow(int row, APair<Integer, ARect> ans) {
            InterfaceStatus.StatusEntry statusEntry = this.mInterfaceStatus.getEntry(row);
            Floorplan floorplan = this.mInterfaceStatus.getFloorplan(this.mColumn);
            return InterfaceTreeUI.this.showMeAndZoomNear(statusEntry, floorplan, ans);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            APair<Integer, ARect> ans = null;
            boolean found = false;
            for (int row : this.mTable.getSelectedRows()) {
                ans = this.processRow(row, ans);
                if (row != this.mRow) continue;
                found = true;
            }
            if (!found) {
                ans = this.processRow(this.mRow, ans);
            }
            if (ans.second == null) {
                return;
            }
            ((ARect)ans.second).changeSizeBy((Integer)ans.first > 1 ? 0.1 : 15.0);
            ((DesignView2D)OrbitIO.getCurView()).getCanvas().getXForm().setWorld((ARect)ans.second);
            ((DesignView2D)OrbitIO.getCurView()).getCanvas().refresh();
        }
    }

    protected class ActionShowMe
    extends AbstractAction {
        protected int mRow;
        protected int mColumn;
        protected InterfaceStatus mInterfaceStatus;
        protected JTable mTable;

        public ActionShowMe(int row, int column, InterfaceStatus interfaceStatus, JTable table) {
            super("Show Me");
            this.mRow = row;
            this.mColumn = column;
            this.mInterfaceStatus = interfaceStatus;
            this.mTable = table;
        }

        public void processRow(int row) {
            APair ans = APair.create((Object)0, null);
            InterfaceStatus.StatusEntry statusEntry = this.mInterfaceStatus.getEntry(row);
            Floorplan floorplan = this.mInterfaceStatus.getFloorplan(this.mColumn);
            for (FloorplanPin cur : InterfaceTreeUI.this.mInterfaceNetsPanel.getInterfaceStatus().listOfFPPins(statusEntry, floorplan)) {
                InterfaceTreeUI.this.addShowMe(cur, 0, null, (APair<Integer, ARect>)ans);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean found = false;
            for (int row : this.mTable.getSelectedRows()) {
                this.processRow(row);
                if (row != this.mRow) continue;
                found = true;
            }
            if (!found) {
                this.processRow(this.mRow);
            }
        }
    }

    public class InterfaceNetsPanel
    extends JPanel {
        protected JScrollPane mScrollNetsInfoPane = null;
        protected JTable mNetsTable = null;
        protected NetTableCellRenderer mNetTableCellRenderer = null;
        protected TableCellRenderer tcr = null;
        protected NetTableModel mNetTableModel = null;
        protected InterfaceStatus mInterfaceStatus = null;
        protected JLabel mTableLabel = null;
        protected TransferHandler mTransferHandler = new TransferHandler(){

            @Override
            protected Transferable createTransferable(JComponent c) {
                if (InterfaceTreeUI.this.mSelectedFloorplan != null) {
                    ALog.logInfo((String)("Globbing started, please release mouse button for floorplan " + InterfaceTreeUI.this.mSelectedFloorplan.asString()));
                    int numRows = 0;
                    int curRow = 0;
                    for (int row : InterfaceNetsPanel.this.mNetsTable.getSelectedRows()) {
                        ++numRows;
                        curRow = row;
                    }
                    int curColumn = InterfaceNetsPanel.this.mInterfaceStatus.getHasExplicitNets() ? 1 : 0;
                    for (Floorplan floorplan : InterfaceTreeUI.this.mSelectedInterface.getSortedFloorplanList()) {
                        ++curColumn;
                        if (floorplan != InterfaceTreeUI.this.mSelectedFloorplan) continue;
                        break;
                    }
                    InterfaceTreeUI.this.globSelectedNets(InterfaceTreeUI.this.mSelectedFloorplan, InterfaceNetsPanel.this.mNetsTable, numRows, curRow, curColumn, true);
                }
                return null;
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 0x40000001;
            }

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                return false;
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                return true;
            }
        };

        public InterfaceStatus getInterfaceStatus() {
            return this.mInterfaceStatus;
        }

        public InterfaceNetsPanel() {
            this.init();
        }

        public void resetStatus() {
            this.mInterfaceStatus = null;
        }

        public void init() {
            GridBagManager l = GridBagManager.layout((Container)this);
            l.addNl((Component)new AHorizDivider("<html><b>Floorplan Nets Table"), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            this.mNetsTable = new JTable();
            JTableHeader jth = this.mNetsTable.getTableHeader();
            this.tcr = jth.getDefaultRenderer();
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            InterfaceTreeUI.this.mColumnWidth = metrics.charWidth('m');
            this.mNetsTable.setFillsViewportHeight(true);
            this.mNetsTable.setRowSelectionAllowed(true);
            this.mNetsTable.setCellSelectionEnabled(false);
            this.mNetsTable.setAutoResizeMode(0);
            this.mNetTableModel = new NetTableModel();
            this.mNetsTable.setModel(this.mNetTableModel);
            this.mNetTableModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    InterfaceTreeUI.this.mColSizer.sizeColumnsToFit(InterfaceNetsPanel.this.mNetsTable);
                }
            });
            this.mNetsTable.setSelectionMode(2);
            this.mNetTableCellRenderer = new NetTableCellRenderer();
            this.mNetsTable.setDefaultRenderer(Object.class, this.mNetTableCellRenderer);
            this.mNetsTable.setRowSelectionAllowed(true);
            this.mNetsTable.setColumnSelectionAllowed(false);
            this.mScrollNetsInfoPane = new JScrollPane(this.mNetsTable);
            this.mScrollNetsInfoPane.setHorizontalScrollBarPolicy(30);
            this.mScrollNetsInfoPane.setPreferredSize(new Dimension(200, 250));
            this.mScrollNetsInfoPane.setMinimumSize(new Dimension(200, 250));
            this.mScrollNetsInfoPane.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    super.componentResized(e);
                    InterfaceTreeUI.this.mColSizer.distributeExcessToLastCol(InterfaceNetsPanel.this.mNetsTable);
                }
            });
            this.mNetsTable.addMouseListener(new TableButtonMouseListener());
            l.add((Component)this.mScrollNetsInfoPane, (GridBagConstraints)GridBagManager.FILLALL);
        }

        protected void removeColumns() {
            int num = this.mNetsTable.getColumnCount();
            while (this.mNetsTable.getColumnCount() > 0) {
                TableColumn tc = this.mNetsTable.getColumnModel().getColumn(num - 1);
                this.mNetsTable.removeColumn(tc);
                --num;
            }
        }

        protected boolean canCreateChildInterface(List<Net> selNets, Interface inf) {
            HashSet<Net> s = new HashSet<Net>(selNets);
            for (Interface childInf : inf.getChildren()) {
                for (Net childNet : childInf.getNets(true)) {
                    if (!s.contains(childNet)) continue;
                    return false;
                }
            }
            return true;
        }

        protected void setupColumns() {
            this.removeColumns();
            if (InterfaceTreeUI.this.mSelectedInterface == null) {
                return;
            }
            TableColumn col = null;
            this.removeColumns();
            ColumnHeaderRender chr = new ColumnHeaderRender();
            this.mNetsTable.getTableHeader().addMouseListener(new ColumnButtonMouseListener());
            this.mNetsTable.clearSelection();
            int modelIndex = 0;
            if (this.mInterfaceStatus.getHasExplicitNets()) {
                col = new TableColumn();
                col.setModelIndex(modelIndex++);
                this.mNetsTable.addColumn(col);
                FontMetrics metrics = this.getFontMetrics(this.getFont());
                String str = "Key Nets(" + this.mInterfaceStatus.getExplicitNetsCount() + ") : <" + DeviceTemplate.getUserDisplayName((DeviceTemplate)InterfaceTreeUI.this.mSelectedInterface.getNetsReferencedWRT()) + ">";
                InterfaceTreeUI.this.mColumnWidth = metrics.stringWidth(str);
                col.setIdentifier(str);
                col.setHeaderValue(str);
                col.setResizable(true);
                col.setHeaderRenderer(chr);
            }
            for (Floorplan floorplan : InterfaceTreeUI.this.mSelectedInterface.getSortedFloorplanList()) {
                col = new TableColumn();
                col.setModelIndex(modelIndex++);
                this.mNetsTable.addColumn(col);
                FontMetrics metrics = this.getFontMetrics(this.getFont());
                InterfaceTreeUI.this.mColumnWidth = metrics.stringWidth(floorplan.toString());
                col.setIdentifier(floorplan);
                col.setHeaderValue(floorplan);
                col.setResizable(true);
                col.setHeaderRenderer(chr);
            }
            this.mNetsTable.repaint();
            InterfaceTreeUI.this.mColSizer.sizeColumnsToFit(this.mNetsTable);
        }

        public void setupArray(Interface mSelectedInterface) {
            this.mInterfaceStatus = mSelectedInterface.getInterfaceStatus();
        }

        protected void initializeDragAndDrop() {
            this.mNetsTable.setTransferHandler(this.mTransferHandler);
            this.mNetsTable.setDragEnabled(true);
            this.mNetsTable.setDropMode(DropMode.ON);
        }

        public class NetTableCellRenderer
        extends DefaultTableCellRenderer {
            @Override
            public Component getTableCellRendererComponent(JTable table, Object o, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, o, isSelected, hasFocus, row, column);
                if (mRepolulateDisabled) {
                    return this;
                }
                this.setIcon(null);
                this.setText(null);
                this.setForeground(Color.black);
                this.setBackground(Color.white);
                this.setToolTipText("");
                int numInRow = InterfaceNetsPanel.this.mInterfaceStatus.getRefPinCountForRow(row);
                int numOfFPs = InterfaceNetsPanel.this.mInterfaceStatus.getColCount(false);
                Net net = InterfaceNetsPanel.this.mInterfaceStatus.getIntefaceNet(row);
                if (net == null) {
                    for (int i = 0; i < InterfaceNetsPanel.this.mInterfaceStatus.getColCount(false); ++i) {
                        FloorplanPin pin = InterfaceNetsPanel.this.mInterfaceStatus.getReferencePin(row, i);
                        if (pin == null || Net.isDiffPair((Net)pin.getSubstrateNet()) == null) continue;
                        net = pin.getSubstrateNet();
                        break;
                    }
                }
                if (Net.isDiffPair((Net)net) != null) {
                    this.setForeground(Color.DARK_GRAY);
                }
                if (column == 0 && InterfaceNetsPanel.this.mInterfaceStatus.getHasExplicitNets()) {
                    if (InterfaceTreeUI.this.mSelectedInterface.hasNet(net)) {
                        Objects.requireNonNull(net);
                        if (isSelected) {
                            this.setBackground(ColorWhiteSelected);
                        }
                        this.setToolTipText(String.format("Net '%s' is defined on this interface '%s'", net.getName(), InterfaceTreeUI.this.mSelectedInterface.getName()));
                    } else {
                        Interface intf = InterfaceTreeUI.this.mSelectedInterface.isNetInDescendant(net);
                        if (intf != null) {
                            Objects.requireNonNull(net);
                            this.setToolTipText(String.format("Net '%s' is inherited from decendant interface '%s'.", net.getName(), intf.getName()));
                            this.setBackground(isSelected ? ColorInheritSelected : ColorInherit);
                        } else {
                            this.setToolTipText("Net is not assigned");
                            this.setBackground(isSelected ? ColorErrSelected : ColorErr);
                        }
                    }
                } else if (numOfFPs == 1) {
                    if (numInRow == 1) {
                        this.setBackground(isSelected ? ColorOkSelected : ColorOk);
                    } else {
                        this.setBackground(isSelected ? ColorErrSelected : ColorErr);
                    }
                } else if (numOfFPs > 1) {
                    if (numInRow == numOfFPs) {
                        this.setBackground(isSelected ? ColorOkSelected : ColorOk);
                    } else if (numInRow >= 2) {
                        this.setBackground(isSelected ? ColorWarnSelected : ColorWarn);
                    } else {
                        this.setBackground(isSelected ? ColorErrSelected : ColorErr);
                    }
                } else {
                    this.setBackground(isSelected ? ColorErrSelected : ColorErr);
                }
                if (column == 0 && InterfaceNetsPanel.this.mInterfaceStatus.getHasExplicitNets()) {
                    if (net != null) {
                        this.setText(net.getName());
                    } else {
                        this.setText("");
                    }
                } else {
                    APair netPinDesc = InterfaceNetsPanel.this.mInterfaceStatus.getTextDescription(row, column, true, ", ");
                    this.setText((String)netPinDesc.first);
                    this.setToolTipText((String)netPinDesc.second);
                }
                return this;
            }
        }

        public class ColumnHeaderRender
        implements TableCellRenderer {
            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (InterfaceNetsPanel.this.tcr == null || InterfaceTreeUI.this.mSelectedInterface == null) {
                    return null;
                }
                Component component = InterfaceNetsPanel.this.tcr.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!(component instanceof JLabel)) {
                    return null;
                }
                JLabel label = (JLabel)component;
                if (column == 0 && InterfaceNetsPanel.this.mInterfaceStatus.getHasExplicitNets()) {
                    label.setText("Key Nets(" + InterfaceNetsPanel.this.mInterfaceStatus.getExplicitNetsCount() + ") : <" + DeviceTemplate.getUserDisplayName((DeviceTemplate)InterfaceTreeUI.this.mSelectedInterface.getNetsReferencedWRT()) + ">");
                } else {
                    Floorplan fp = InterfaceTreeUI.this.mSelectedInterface.getFloorplan(column - (InterfaceNetsPanel.this.mInterfaceStatus.getHasExplicitNets() ? 1 : 0));
                    if (fp != null) {
                        label.setToolTipText(fp.info());
                        label.setText(fp.getName());
                    } else {
                        return null;
                    }
                }
                return component;
            }
        }

        class NetTableModel
        extends AbstractTableModel {
            @Override
            public int getColumnCount() {
                return InterfaceNetsPanel.this.mInterfaceStatus == null ? 0 : InterfaceNetsPanel.this.mInterfaceStatus.getColCount(true);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }

            @Override
            public int getRowCount() {
                return InterfaceNetsPanel.this.mInterfaceStatus == null ? 0 : InterfaceNetsPanel.this.mInterfaceStatus.getRowCount();
            }

            @Override
            public String getColumnName(int column) {
                if (column == 0 && InterfaceNetsPanel.this.mInterfaceStatus.getHasExplicitNets()) {
                    return "Key Nets(" + InterfaceNetsPanel.this.mInterfaceStatus.getExplicitNetsCount() + ") : <" + DeviceTemplate.getUserDisplayName((DeviceTemplate)InterfaceTreeUI.this.mSelectedInterface.getNetsReferencedWRT()) + ">";
                }
                Floorplan fp = InterfaceTreeUI.this.mSelectedInterface.getFloorplan(column - (InterfaceNetsPanel.this.mInterfaceStatus.getHasExplicitNets() ? 1 : 0));
                return fp == null ? null : fp.toString();
            }

            @Override
            public Object getValueAt(int row, int column) {
                Object ans = "";
                if (mRepolulateDisabled) {
                    return ans;
                }
                if (column == 0 && InterfaceNetsPanel.this.mInterfaceStatus.getHasExplicitNets()) {
                    Net net = InterfaceNetsPanel.this.mInterfaceStatus.getIntefaceNet(row);
                    if (net != null) {
                        ans = net.getName();
                    }
                } else {
                    FloorplanPin fpPin = InterfaceNetsPanel.this.mInterfaceStatus.getAPin(row, column);
                    int cnt = InterfaceNetsPanel.this.mInterfaceStatus.getPinCount(row, column);
                    if (fpPin != null) {
                        List topNetList = fpPin.getTopNet();
                        if (topNetList != null) {
                            ans = topNetList.size() == 1 ? fpPin.getNetNameWithCount(cnt) : (cnt == 1 ? "???" : "??? + (" + cnt + ")");
                            if (!(topNetList.size() == 1 && ((Net)((HierInst)topNetList.get((int)0)).second).isUnused() || InterfaceNetsPanel.this.mInterfaceStatus.getRefPinCountForRow(row) > 1 || InterfaceNetsPanel.this.mInterfaceStatus.getColCount(true) == 1 || fpPin.getPinTemplate() == null)) {
                                ans = fpPin.getNetNameWithCount(cnt);
                            }
                        } else if (fpPin.getPinTemplate() != null) {
                            ans = fpPin.getNetNameWithCount(cnt);
                        }
                    }
                }
                return ans;
            }
        }

        class ColumnButtonMouseListener
        extends MouseAdapter {
            JPopupMenu popup;

            ColumnButtonMouseListener() {
            }

            protected void showPopup(MouseEvent e) {
                int column = InterfaceNetsPanel.this.mNetsTable.columnAtPoint(e.getPoint());
                if (column < 0) {
                    return;
                }
                if (column == 0) {
                    this.popup = new JPopupMenu();
                    if (InterfaceNetsPanel.this.mInterfaceStatus.getHasExplicitNets()) {
                        if (InterfaceTreeUI.this.mSelectedInterface.hasPinWithoutNetMapped()) {
                            this.popup.add(new ActionAutoAssignToFloorplan("Auto Assign to Floorplans"));
                        }
                        this.popup.add(new ActionAssignExistingPinsToFloorplan());
                    }
                    this.popup.add(new ActionExportNetsTable());
                    this.popup.add(new JMenuItem(new AbstractAction("Edit Nets..."){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            InterfaceTreeUI.this.editNets();
                        }
                    }));
                    this.popup.add(new JMenuItem(new AbstractAction("Refresh"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            InterfaceTreeUI.this.refreshNetsTable();
                        }
                    }));
                    OrbitIO.getGuiWorkspace().getContextMenuWorkspace().light(this.popup);
                    this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
            }
        }

        class TableButtonMouseListener
        extends MouseAdapter {
            JPopupMenu popup = null;

            TableButtonMouseListener() {
            }

            protected void showPopup(MouseEvent e) {
                int row = InterfaceNetsPanel.this.mNetsTable.rowAtPoint(e.getPoint());
                if (row < 0) {
                    return;
                }
                this.popup = new JPopupMenu();
                int column = InterfaceNetsPanel.this.mNetsTable.columnAtPoint(e.getPoint());
                if (column < 0) {
                    return;
                }
                int selCount = InterfaceNetsPanel.this.mNetsTable.getSelectedRowCount();
                ArrayList<Net> selNets = new ArrayList<Net>();
                for (int selIdx : InterfaceNetsPanel.this.mNetsTable.getSelectedRows()) {
                    selNets.add(InterfaceNetsPanel.this.mInterfaceStatus.getIntefaceNet(selIdx));
                }
                if (selCount == 0) {
                    selNets.add(InterfaceNetsPanel.this.mInterfaceStatus.getIntefaceNet(row));
                }
                if (InterfaceNetsPanel.this.canCreateChildInterface(selNets, InterfaceNetsPanel.this.mInterfaceStatus.getInterface())) {
                    this.popup.add(new ActionCreateChildInterface(InterfaceNetsPanel.this.mInterfaceStatus.getInterface(), selNets));
                }
                if (column == 0 && InterfaceNetsPanel.this.mInterfaceStatus.getHasExplicitNets()) {
                    Net net = InterfaceNetsPanel.this.mInterfaceStatus.getIntefaceNet(row);
                    if (net == null) {
                        return;
                    }
                    this.popup.add(new ActionSelectPinsOfNets(selNets));
                    OrbitIO.getGuiWorkspace().getContextMenuWorkspace().light(this.popup);
                    this.popup.show(e.getComponent(), e.getX(), e.getY());
                    return;
                }
                int adjColumn = InterfaceNetsPanel.this.mInterfaceStatus.getAdjustedColumn(column);
                if (selCount <= 1) {
                    FloorplanPin fpPin = InterfaceNetsPanel.this.mInterfaceStatus.getReferencePin(row, adjColumn);
                    if (fpPin != null) {
                        DevicePath path = fpPin.getDevicePath();
                        AbstractList items = new ArrayList<JMenuItem>();
                        items.add(new JMenuItem(new ActionShowMe(row, column, InterfaceNetsPanel.this.mInterfaceStatus, InterfaceNetsPanel.this.mNetsTable)));
                        items.add(new JMenuItem(new ActionShowZoomNearMe(row, column, InterfaceNetsPanel.this.mInterfaceStatus, InterfaceNetsPanel.this.mNetsTable)));
                        items.add(new JMenuItem(new ActionShowMeRow(row, InterfaceNetsPanel.this.mInterfaceStatus, InterfaceNetsPanel.this.mNetsTable)));
                        items.add(new JMenuItem(new ActionShowMeRowAndZoom(row, InterfaceNetsPanel.this.mInterfaceStatus, InterfaceNetsPanel.this.mNetsTable)));
                        items = AMenuUtil.groupByFirstWord(items.iterator());
                        for (JMenuItem item : items) {
                            this.popup.add(item);
                        }
                        if (fpPin.getPinTemplate() != null) {
                            Net n = fpPin.getNet();
                            this.popup.add(NetGraphPanel.createShowNetGraphAction(OrbitIO.getMainWindow(), path, n));
                        }
                        this.popup.add(new JSeparator());
                    }
                    if (InterfaceTreeUI.this.allowPartialGlobbing(row, column, InterfaceNetsPanel.this.mInterfaceStatus, InterfaceNetsPanel.this.mNetsTable)) {
                        this.popup.add(new ActionDynamicGlobPins(row, column, InterfaceNetsPanel.this.mInterfaceStatus, InterfaceNetsPanel.this.mNetsTable));
                    }
                }
                OrbitIO.getGuiWorkspace().getContextMenuWorkspace().light(this.popup);
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
            }
        }
    }

    public class FloorplanPanel
    extends JPanel {
        protected static final int NUM_COLS = 12;
        protected JTextField mPinCount = null;
        protected JTextField mActualIOCount = null;
        protected JTextField mRequiredIOCount = null;
        protected DbObjectListPanel mIOPersonalitiesListPanel = null;
        protected RulesRatioPanel mRulesRatioPanel = null;
        protected PersonalityRatioAdaptor mPersonalityRatioAdaptor = null;
        protected List<DbObject> copiedObject1s = null;
        protected List<DbObject> copiedObject2s = null;
        protected List<Integer> copiedNums = null;
        protected List<Integer> copiedDems = null;
        protected List<Double> copiedTols = null;
        protected List<DbObject> copiedPersonalitiesList = null;
        protected ActionListener mEditsEffectDecendentsPopListener = e -> {
            InterfaceTreeUI.this.mEditsEffectDecendents = InterfaceTreeUI.this.mEditsEffectDecendentsCheckbox.isSelected();
        };

        public FloorplanPanel() {
            this.init();
        }

        private void init() {
            GridBagManager l = GridBagManager.layout((Container)this);
            l.addNl((Component)new AHorizDivider("Floorplan Details"), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            l.push("Pin Count", (GridBagConstraints)GridBagManager.FILLX);
            this.mPinCount = new JTextField("", 12);
            this.mPinCount.setEditable(false);
            l.add((Component)this.mPinCount, (GridBagConstraints)GridBagManager.FILLX);
            this.mPinCount.setToolTipText("The total number of floorplan pins in this floorplan including any in children/descendent floorplans.");
            l.pop();
            l.push("IO Count", (GridBagConstraints)GridBagManager.FILLX);
            JLabel label = new JLabel("Required:");
            l.add((Component)label, (GridBagConstraints)GridBagManager.LEFT);
            this.mRequiredIOCount = new JTextField("", 12);
            this.mRequiredIOCount.setEditable(false);
            this.mRequiredIOCount.setToolTipText("The total number of floorplan pins needed at this level of the floorplan hierarchy, as specified by the Edit dialog for the interface that owns this floorplan.");
            l.add((Component)this.mRequiredIOCount, (GridBagConstraints)GridBagManager.FILLX);
            label = new JLabel("Actual:");
            l.add((Component)label, (GridBagConstraints)GridBagManager.LEFT);
            this.mActualIOCount = new JTextField("", 12);
            this.mActualIOCount.setEditable(false);
            this.mActualIOCount.setToolTipText("The actual number of io pins at this level of the floorplan hierarchy. IO Pins must match the personality/ies specified in the 'IO Personalities' List below to be counted.");
            l.add((Component)this.mActualIOCount, (GridBagConstraints)GridBagManager.FILLX);
            l.popNl();
            JPanel ioPanel = l.push("IO Personalities Filter", (GridBagConstraints)GridBagManager.FILLALL.width(2));
            ioPanel.setToolTipText("List personalities (or NONE) that are valid for use in this floorplan. If this field is blank, then pins of all peronalities (or NONE) will be considered for globbing.");
            this.mIOPersonalitiesListPanel = new DbObjectListPanel(InterfaceTreeUI.this.mDb, new IOPersonailtiesListener());
            l.add((Component)this.mIOPersonalitiesListPanel, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            this.mIOPersonalitiesListPanel.setToolTipText("List personalities (or NONE) that are valid for use in this floorplan. If this field is blank, then pins of all peronalities (or NONE) will be considered for globbing.");
            l.newline();
            InterfaceTreeUI.this.mEditsEffectDecendentsCheckbox = new JCheckBox("Edit affect all child interfaces");
            InterfaceTreeUI.this.mEditsEffectDecendentsCheckbox.setSelected(InterfaceTreeUI.this.mEditsEffectDecendents);
            InterfaceTreeUI.this.mEditsEffectDecendentsCheckbox.addActionListener(this.mEditsEffectDecendentsPopListener);
            l.addNl((Component)InterfaceTreeUI.this.mEditsEffectDecendentsCheckbox, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            l.popNl();
            l.push("Ratios", (GridBagConstraints)GridBagManager.FILLALL.width(2));
            this.mPersonalityRatioAdaptor = new PersonalityRatioAdaptor();
            this.mRulesRatioPanel = new RulesRatioPanel(InterfaceTreeUI.this.mDb, this.mPersonalityRatioAdaptor);
            l.add((Component)this.mRulesRatioPanel, (GridBagConstraints)GridBagManager.FILLALL);
            l.popNl();
        }

        public void update() {
            this.mPinCount.setText(Integer.toString(InterfaceTreeUI.this.mSelectedFloorplan.getNumFloorplanPins()));
            this.mRequiredIOCount.setText(Integer.toString(InterfaceTreeUI.this.mSelectedFloorplan.getMyInterface().getExpectedIOCount()));
            this.mActualIOCount.setText(InterfaceTreeUI.this.mSelectedFloorplan.getIOCountStr(true));
            try {
                if (InterfaceTreeUI.this.mSelectedFloorplan.getMyInterface().getExpectedIOCount() == InterfaceTreeUI.this.mSelectedFloorplan.getIOCount(true)) {
                    this.mActualIOCount.setBackground(ColorOk);
                } else {
                    this.mActualIOCount.setBackground(ColorErr);
                }
            }
            catch (Floorplan.InvalidDataException e) {
                this.mActualIOCount.setBackground(ColorErr);
            }
            this.mIOPersonalitiesListPanel.refresh();
            this.mRulesRatioPanel.refresh();
            InterfaceTreeUI.this.populateSubstratePersonalities();
        }

        public void removeRatiosContaining(DbObject obj) {
            for (int i = this.mPersonalityRatioAdaptor.getNumRatios() - 1; i >= 0; --i) {
                if (this.mPersonalityRatioAdaptor.getDbObject1(i) != obj && this.mPersonalityRatioAdaptor.getDbObject2(i) != obj) continue;
                this.mPersonalityRatioAdaptor.removeRatio(i);
            }
        }

        public class IOPersonailtiesListener
        implements DbObjectListPanel.DbObjectListListener {
            @Override
            public String getTitle() {
                return "IO Personailties";
            }

            @Override
            public String getUserObjectName() {
                return "Pin Personality";
            }

            @Override
            public List<DbObject> getObjects() {
                if (InterfaceTreeUI.this.mSelectedFloorplan == null) {
                    return null;
                }
                List perList = PersonalityMap.getPersonalities((Personality.Type)Personality.Type.PORT, (DbObject)InterfaceTreeUI.this.mSelectedFloorplan).map(PersonalityMap::getPersonality).distinct().collect(Collectors.toCollection(ArrayList::new));
                ArrayList<DbObject> objList = new ArrayList<DbObject>();
                if (InterfaceTreeUI.this.mSelectedFloorplan.getIncludeNoneInIOPersonalityList()) {
                    objList.add(null);
                }
                objList.addAll(perList);
                if (objList.isEmpty()) {
                    objList.add(null);
                }
                return objList;
            }

            @Override
            public String cellText(DbObject obj) {
                if (obj == null) {
                    return "<NONE>";
                }
                if (obj instanceof Personality) {
                    return ((Personality)obj).getName();
                }
                return null;
            }

            @Override
            public Color cellIconColor(DbObject obj, boolean isSelected) {
                if (obj instanceof Personality) {
                    return ((Personality)obj).getColor();
                }
                return null;
            }

            @Override
            public void addObject(DbObject obj) {
                if (obj == null) {
                    Cp.exec((String)"com.sigrity.acl.db.std.Floorplan.setIncludeNoneInIOPersonalityList(curDb(), \"%s\", true, %s);", (Object[])new Object[]{InterfaceTreeUI.this.mSelectedFloorplan.getKeyStr(), Boolean.toString(InterfaceTreeUI.this.mEditsEffectDecendents)});
                } else if (obj instanceof Personality && InterfaceTreeUI.this.mSelectedFloorplan.getDeviceTemplate().equals(((Personality)obj).getOwner())) {
                    Cp.exec((String)"com.sigrity.orbit.ui.PersonalityUI.addFloorplanToPersonality(\"Floorplan\", \"%s\", \"%s\", %s);", (Object[])new Object[]{InterfaceTreeUI.this.mSelectedFloorplan.getKeyStr(), obj.getKeyStr(), Boolean.toString(InterfaceTreeUI.this.mEditsEffectDecendents)});
                } else {
                    return;
                }
                FloorplanPanel.this.mIOPersonalitiesListPanel.refresh();
                FloorplanPanel.this.update();
                InterfaceTreeUI.scheduleRepopulateTree();
            }

            @Override
            public void removeObject(DbObject obj) {
                if (obj == null || obj instanceof Personality) {
                    if (obj == null) {
                        Cp.exec((String)("com.sigrity.acl.db.std.Floorplan.setIncludeNoneInIOPersonalityList(curDb(), \"" + InterfaceTreeUI.this.mSelectedFloorplan.getKeyStr() + "\", false, " + Boolean.toString(InterfaceTreeUI.this.mEditsEffectDecendents) + ");"), (Object[])new Object[0]);
                    } else {
                        Cp.exec((String)("com.sigrity.orbit.ui.PersonalityUI.removeDbObjectFromPersonality(\"Floorplan\", \"" + InterfaceTreeUI.this.mSelectedFloorplan.getKeyStr() + "\", \"" + obj.getKeyStr() + "\", " + Boolean.toString(InterfaceTreeUI.this.mEditsEffectDecendents) + ");"), (Object[])new Object[0]);
                    }
                    FloorplanPanel.this.removeRatiosContaining(obj);
                    FloorplanPanel.this.update();
                    InterfaceTreeUI.scheduleRepopulateTree();
                }
            }

            @Override
            public List<Selector.Property<?>> getOverridePropertyList() {
                ArrayList ans = new ArrayList();
                for (Selector.Property prop : Selectors.PinPersonalitySelector.Descriptor.getProperties(OrbitIO.getCurDb())) {
                    if (prop.getName().equals("substrate")) continue;
                    ans.add(prop);
                }
                return ans;
            }

            @Override
            public List<Object> getOverridePropertyValueList(Selector.Property<?> prop) {
                if (prop.getName().equals("name")) {
                    List ans = Personality.getPersonalities((DeviceTemplate)InterfaceTreeUI.this.mSelectedFloorplan.getDeviceTemplate(), (Personality.Type)Personality.Type.PORT).collect(Collectors.toCollection(ArrayList::new));
                    Collections.sort(ans, (a, b) -> {
                        if (a instanceof DbObject && b instanceof DbObject) {
                            return ((DbObject)a).compareAlphaNumericTo((DbObject)b);
                        }
                        return a.toString().compareTo(b.toString());
                    });
                    ans.add(0, "<NONE>");
                    return ans;
                }
                return null;
            }

            @Override
            public boolean enableCopyPaste() {
                return true;
            }

            @Override
            public void copyObjects(List<DbObject> items) {
                FloorplanPanel.this.copiedPersonalitiesList = items;
            }

            @Override
            public List<DbObject> getPasteObjects() {
                return FloorplanPanel.this.copiedPersonalitiesList;
            }

            @Override
            public Selector.Descriptor<?> getDescriptor() {
                return Selectors.PinPersonalitySelector.Descriptor;
            }
        }

        public class PersonalityRatioAdaptor
        implements RulesRatioPanel.RulesRatioListener {
            @Override
            public String getTitle() {
                return "Pin Personality Ratio";
            }

            @Override
            public int getNumRatios() {
                return InterfaceTreeUI.this.mSelectedFloorplan == null ? 0 : InterfaceTreeUI.this.mSelectedFloorplan.numPersonailityRatios();
            }

            @Override
            public String getPairText(int row) {
                DbObjectRatio pRatio = InterfaceTreeUI.this.mSelectedFloorplan.getPersonalityRatio(row);
                String name1 = "<NONE>";
                if (pRatio.getDbObject1() != null) {
                    name1 = ((Personality)pRatio.getDbObject1()).getName();
                }
                String name2 = "<NONE>";
                if (pRatio.getDbObject2() != null) {
                    name2 = ((Personality)pRatio.getDbObject2()).getName();
                }
                return name1 + " : " + name2;
            }

            @Override
            public Color getBackgroundColor(int row, int column) {
                if (column < 2) {
                    return null;
                }
                DbObjectRatio pRatio = InterfaceTreeUI.this.mSelectedFloorplan.getPersonalityRatio(row);
                if (InterfaceTreeUI.this.mSelectedFloorplan.getPersonalityCount((Personality)pRatio.getDbObject1()) == 0 || InterfaceTreeUI.this.mSelectedFloorplan.getPersonalityCount((Personality)pRatio.getDbObject2()) == 0) {
                    return ColorErr;
                }
                switch (pRatio.characterizeMatch((double)InterfaceTreeUI.this.mSelectedFloorplan.getPersonalityCount((Personality)pRatio.getDbObject1()) / (double)InterfaceTreeUI.this.mSelectedFloorplan.getPersonalityCount((Personality)pRatio.getDbObject2()))) {
                    case Exact: {
                        return ColorOk;
                    }
                    case WithinTolerance: {
                        return ColorWarn;
                    }
                }
                return ColorErr;
            }

            @Override
            public void removeRatio(int row) {
                DbObjectRatio pRatio = InterfaceTreeUI.this.mSelectedFloorplan.getPersonalityRatio(row);
                Cp.exec((String)("com.sigrity.acl.db.std.DbObjectRatio.delete(curDb(), \"" + pRatio.getKeyStr() + "\");"), (Object[])new Object[0]);
            }

            @Override
            public List<DbObject> getList() {
                return InterfaceTreeUI.this.mSubstratePersonalities;
            }

            @Override
            public String getText(DbObject obj) {
                if (obj instanceof Personality) {
                    return ((Personality)obj).getName();
                }
                return obj.getKeyStr();
            }

            @Override
            public Icon getIcon(DbObject obj) {
                if (obj instanceof Personality) {
                    return new AColorIcon(16, 16, ((Personality)obj).getColor());
                }
                return null;
            }

            @Override
            public void setRatio(DbObject obj1, DbObject obj2, int r1, int r2, double tolerance) {
                DbObjectRatio pRatio = InterfaceTreeUI.this.mSelectedFloorplan.find((Personality)obj1, (Personality)obj2);
                boolean reversed = false;
                if (pRatio == null) {
                    pRatio = InterfaceTreeUI.this.mSelectedFloorplan.find((Personality)obj2, (Personality)obj1);
                    boolean bl = reversed = pRatio != null;
                }
                if (pRatio == null) {
                    String simpleName = "";
                    String str1 = "<NONE>";
                    if (obj1 != null) {
                        str1 = obj1.getKeyStr();
                        simpleName = obj1.getClass().getSimpleName();
                    }
                    String str2 = "<NONE>";
                    if (obj2 != null) {
                        str2 = obj2.getKeyStr();
                        simpleName = obj2.getClass().getSimpleName();
                    }
                    Cp.exec((String)"com.sigrity.acl.db.std.DbObjectRatio.create(curDb(), \"%s\", \"%s\", \"%s\", \"%s\", \"%s\");", (Object[])new Object[]{InterfaceTreeUI.this.mSelectedFloorplan.getClass().getSimpleName(), InterfaceTreeUI.this.mSelectedFloorplan.getKeyStr(), simpleName, str1, str2});
                    pRatio = InterfaceTreeUI.this.mSelectedFloorplan.find((Personality)obj1, (Personality)obj2);
                }
                if (reversed) {
                    Cp.exec((String)"com.sigrity.acl.db.std.DbObjectRatio.setRatio(curDb(), \"%s\", %d, %d, %f);", (Object[])new Object[]{pRatio.getKeyStr(), r2, r1, tolerance});
                } else {
                    Cp.exec((String)"com.sigrity.acl.db.std.DbObjectRatio.setRatio(curDb(), \"%s\", %d, %d, %f);", (Object[])new Object[]{pRatio.getKeyStr(), r1, r2, tolerance});
                }
                FloorplanPanel.this.mRulesRatioPanel.refresh();
            }

            @Override
            public DbObject getDbObject1(int row) {
                return InterfaceTreeUI.this.mSelectedFloorplan.getPersonalityRatio(row).getDbObject1();
            }

            @Override
            public DbObject getDbObject2(int row) {
                return InterfaceTreeUI.this.mSelectedFloorplan.getPersonalityRatio(row).getDbObject2();
            }

            @Override
            public int getRatioNumerator(int row) {
                return InterfaceTreeUI.this.mSelectedFloorplan.getPersonalityRatio(row).getRatioNumerator();
            }

            @Override
            public int getRatioDenominator(int row) {
                return InterfaceTreeUI.this.mSelectedFloorplan.getPersonalityRatio(row).getRatioDenominator();
            }

            @Override
            public double getTolerance(int row) {
                return InterfaceTreeUI.this.mSelectedFloorplan.getPersonalityRatio(row).getTolerance();
            }

            @Override
            public String getActualText(int row) {
                DbObjectRatio pRatio = InterfaceTreeUI.this.mSelectedFloorplan.getPersonalityRatio(row);
                if (InterfaceTreeUI.this.mSelectedFloorplan.getPersonalityCount((Personality)pRatio.getDbObject2()) == 0) {
                    return InterfaceTreeUI.this.mSelectedFloorplan.getPersonalityCount((Personality)pRatio.getDbObject1()) + " : " + InterfaceTreeUI.this.mSelectedFloorplan.getPersonalityCount((Personality)pRatio.getDbObject2());
                }
                double ratio = (double)InterfaceTreeUI.this.mSelectedFloorplan.getPersonalityCount((Personality)pRatio.getDbObject1()) / (double)InterfaceTreeUI.this.mSelectedFloorplan.getPersonalityCount((Personality)pRatio.getDbObject2());
                return String.format("%.2f", ratio);
            }

            @Override
            public boolean enableCopyPaste() {
                return true;
            }

            @Override
            public void copyObjects(List<DbObject> obj1List, List<DbObject> obj2List, List<Integer> numList, List<Integer> demList, List<Double> tolList) {
                FloorplanPanel.this.copiedObject1s = obj1List;
                FloorplanPanel.this.copiedObject2s = obj2List;
                FloorplanPanel.this.copiedNums = numList;
                FloorplanPanel.this.copiedDems = demList;
                FloorplanPanel.this.copiedTols = tolList;
            }

            @Override
            public List<DbObject> getPasteObject1s() {
                return FloorplanPanel.this.copiedObject1s;
            }

            @Override
            public List<DbObject> getPasteObject2s() {
                return FloorplanPanel.this.copiedObject2s;
            }

            @Override
            public List<Integer> getNums() {
                return FloorplanPanel.this.copiedNums;
            }

            @Override
            public List<Integer> getDems() {
                return FloorplanPanel.this.copiedDems;
            }

            @Override
            public List<Double> getTols() {
                return FloorplanPanel.this.copiedTols;
            }
        }
    }
}

