/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Floorplan;
import com.sigrity.acl.db.std.FloorplanPin;
import com.sigrity.acl.db.std.Interface;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.AActionGroup;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.InterfaceCmds;
import com.sigrity.orbit.ObjectActionRegistry;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.ui.GetObjectsChooserDlg;
import com.sigrity.orbit.ui.InterfaceTreeUI;
import com.sigrity.orbit.ui.core.DesignView2D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class InterfaceUI {
    public static final ObjectActionRegistry.ActionFactory<Selection> ActionFactorySelection = (selection, constraints) -> {
        long count = 0L;
        ArrayList<Interface> infs = new ArrayList<Interface>();
        for (Interface i : selection.get(Interface.class)) {
            infs.add(i);
        }
        count = infs.size();
        if (count == 0L) {
            return AEmptyItr.create();
        }
        LinkedList<AbstractAction> actions = new LinkedList<AbstractAction>();
        if (count == 1L) {
            Interface intf = (Interface)infs.get(0);
            actions.add(new ActionEditInterface(intf));
            actions.add(new ActionDeleteInterface(intf));
            actions.add(new ActionSelectInterfacePinMenu(intf));
            actions.add(new ActionShowInterfaceMenu(intf));
            actions.add(new ActionZoomToInterface(intf));
            actions.add(new ActionVisibleInterface(intf));
            actions.add(new ActionFixUpInterface(intf));
            actions.add(new ActionEditInterfaceNets(intf));
        }
        if (count > 0L) {
            Interface[] intfsa = infs.toArray(new Interface[0]);
            actions.add(new ActionContractInterfaces(intfsa));
        }
        return actions.iterator();
    };

    private InterfaceUI() {
    }

    public static InterfaceEditDialog showEditDialog(Window owner, Interface intf) {
        InterfaceEditDialog dlg = null;
        if (intf == null || intf.getDb() == null) {
            return null;
        }
        dlg = new InterfaceEditDialog(intf, owner);
        dlg.initEdit();
        dlg.setVisible(true);
        return dlg;
    }

    public static Interface showSelectDialog(Window owner, Interface intf) {
        InterfaceSelectDialog dlg = new InterfaceSelectDialog(OrbitIO.getCurDb(), OrbitIO.getMainWindow());
        dlg.setSelectedInterface(intf);
        dlg.setVisible(true);
        return dlg.getAnswer();
    }

    public static class InterfaceEditDialog
    extends DbDialog {
        protected InterfaceEditDialog theDialog = null;
        protected JTextField mName = null;
        protected JTextField mCount = null;
        static Interface editedNode = null;
        protected JButton mButOk = new JButton("Ok");
        protected JButton mButCancel = new JButton("Cancel");
        protected ActionListener mCountChanged = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        protected ActionListener mNameChanged = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        protected ActionListener mOk = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Interface intf = Interface.find((Db)editedNode.getDb(), (String)editedNode.toStringPath());
                Object newNamePath = editedNode.getParent() != null ? editedNode.getParent().toStringPath() + "/" + mName.getText() : mName.getText();
                Interface newInterface = Interface.find((Db)editedNode.getDb(), (String)newNamePath);
                if (newInterface != null && newInterface != intf) {
                    JOptionPane.showMessageDialog((Component)((Object)theDialog), "An interface with this name already exists. Choose a new name.", "Warning", 0);
                    return;
                }
                Cp.exec((String)("com.sigrity.acl.db.std.Interface.rename(curDb(), \"" + editedNode.toStringPath() + "\", \"" + mName.getText() + "\");"), (Object[])new Object[0]);
                Cp.exec((String)("com.sigrity.orbit.ui.InterfaceTreeUI.setEditedNode(com.sigrity.acl.db.std.Interface.setCount(curDb(), \"" + editedNode.toStringPath() + "\", " + mCount.getText() + "));"), (Object[])new Object[0]);
                theDialog.dispatchEvent(new WindowEvent((Window)((Object)theDialog), 201));
            }
        };

        public InterfaceEditDialog(Interface intf, Window owner) {
            super(intf.getDb(), (Component)owner);
            editedNode = intf;
            this.mDb = intf.getDb();
        }

        protected void initEdit() {
            this.setTitle("Interface Editor");
            GridBagManager l = new GridBagManager(this.getContentPane());
            l.push("Interface", (GridBagConstraints)GridBagManager.FILLALL);
            JLabel la = new JLabel("Name:");
            this.mName = new JTextField("", 20);
            this.mName.setText(editedNode.getName());
            this.mName.addActionListener(this.mNameChanged);
            la.setLabelFor(this.mName);
            l.add((Component)la, (GridBagConstraints)GridBagManager.LEFT);
            l.add((Component)this.mName, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            la = new JLabel("IO Count:");
            this.mCount = new JTextField("", 5);
            this.mCount.setText(String.valueOf(editedNode.getExpectedIOCount()));
            this.mCount.addActionListener(this.mCountChanged);
            la.setLabelFor(this.mCount);
            l.add((Component)la, (GridBagConstraints)GridBagManager.LEFT);
            l.add((Component)this.mCount, (GridBagConstraints)GridBagManager.LEFT);
            l.addFillX();
            l.addFillY();
            l.popNl();
            this.mButOk.addActionListener(this.mOk);
            l.push((GridBagConstraints)GridBagManager.RIGHT_REMAINX);
            l.add((Component)this.mButOk, (GridBagConstraints)GridBagManager.RIGHT);
            l.add((Component)this.mButCancel, (GridBagConstraints)GridBagManager.RIGHT);
            UIUtil.enableDefaultBtn((JDialog)((Object)this), (JButton)this.mButOk);
            UIUtil.enableEscapeClose((Window)((Object)this), (AbstractButton)this.mButCancel);
            l.popNl();
            this.pack();
            this.setMinimumSize(new Dimension(540, 300));
            this.setMinimumSize(this.getPreferredSize());
            this.setModal(true);
            this.theDialog = this;
            UIUtil.center((Component)((Object)this));
            UIUtil.enforceDialogMinSize((Window)((Object)this));
        }
    }

    public static class InterfaceSelectDialog
    extends DbDialog {
        Interface mAnswer = null;
        JComboBox<Interface> mInterfaceCb = null;
        JTextField mName = null;
        JTextField mCount = null;

        public InterfaceSelectDialog(Db db, Component owner) {
            super(db, owner);
            this.setTitle("Select Interface");
            GridBagManager l = new GridBagManager(this.getContentPane());
            List<Interface> intfs = db.getObjects(Interface.class).stream().sorted((x, y) -> x.getName().compareTo(y.getName())).collect(Collectors.toList());
            this.mInterfaceCb = new JComboBox<Interface>(intfs.toArray(new Interface[intfs.size()]));
            this.mInterfaceCb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Interface t = (Interface)mInterfaceCb.getSelectedItem();
                    if (t != null) {
                        mAnswer = t;
                        mName.setText(t.getName());
                        mCount.setText("" + t.getExpectedIOCount());
                    }
                }
            });
            this.mName = new JTextField("", 5);
            this.mCount = new JTextField("", 5);
            l.pushFill();
            l.add((Component)new JLabel("Interface:"), (GridBagConstraints)GridBagManager.LEFT);
            l.add(this.mInterfaceCb, (GridBagConstraints)GridBagManager.FILLX);
            l.newline();
            l.add((Component)new JLabel("Name:"), (GridBagConstraints)GridBagManager.LEFT);
            l.add((Component)this.mName, (GridBagConstraints)GridBagManager.FILLX);
            l.newline();
            l.add((Component)new JLabel("Count:"), (GridBagConstraints)GridBagManager.LEFT);
            l.add((Component)this.mCount, (GridBagConstraints)GridBagManager.FILLX);
            l.pop();
            l.newline();
            JButton mOkBtn = new JButton("Ok");
            JButton mCancelBtn = new JButton("Cancel");
            mOkBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (mAnswer != null) {
                        Interface intf = Interface.find((Db)mAnswer.getDb(), (String)mAnswer.toStringPath());
                        Object newNamePath = mAnswer.getParent() != null ? mAnswer.getParent().toStringPath() + "/" + mName.getText() : mName.getText();
                        Interface newInterface = Interface.find((Db)mAnswer.getDb(), (String)newNamePath);
                        if (newInterface != null && newInterface != intf) {
                            JOptionPane.showMessageDialog((Component)((Object)this), "An interface with this name already exists. Choose a new name.", "Warning", 0);
                            return;
                        }
                        Cp.exec((String)("com.sigrity.acl.db.std.Interface.rename(curDb(), \"" + mAnswer.toStringPath() + "\", \"" + mName.getText() + "\");"), (Object[])new Object[0]);
                        Cp.exec((String)("com.sigrity.orbit.ui.InterfaceTreeUI.setEditedNode(com.sigrity.acl.db.std.Interface.setCount(curDb(), \"" + mAnswer.toStringPath() + "\", " + mCount.getText() + "));"), (Object[])new Object[0]);
                    }
                    this.dispatchEvent(new WindowEvent((Window)((Object)this), 201));
                }
            });
            mCancelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    mAnswer = null;
                    this.dispatchEvent(new WindowEvent((Window)((Object)this), 201));
                }
            });
            l.add((Component)mOkBtn, (GridBagConstraints)GridBagManager.RIGHT);
            l.add((Component)mCancelBtn, (GridBagConstraints)GridBagManager.RIGHT);
            UIUtil.enableDefaultBtn((JDialog)((Object)this), (JButton)mOkBtn);
            UIUtil.enforceDialogMinSize((Window)((Object)this));
            this.setModal(true);
            UIUtil.center((Component)((Object)this));
        }

        public void setSelectedInterface(Interface intf) {
            this.mInterfaceCb.setSelectedItem(intf);
        }

        public Interface getAnswer() {
            return this.mAnswer;
        }
    }

    public static class ActionZoomToInterface
    extends AbstractAction {
        protected Interface intf;
        protected DevicePath dp;

        public ActionZoomToInterface(Interface intf) {
            super("Zoom To");
            this.intf = intf;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ARect overallBounds = this.intf.getGeom().getBounds();
            overallBounds.changeSizeBy(0.1);
            ((DesignView2D)OrbitIO.getCurView()).getCanvas().getXForm().setWorld(overallBounds);
            ((DesignView2D)OrbitIO.getCurView()).getCanvas().refresh();
        }
    }

    public static class ActionFixUpInterface
    extends AbstractAction {
        protected Interface intf;

        public ActionFixUpInterface(Interface intf) {
            super("Fix Up");
            this.intf = intf;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec((String)"Interface.fixUpInterface(curDb(), \"%s\")", (Object[])new Object[]{this.intf.toStringPath()});
        }
    }

    public static class ActionSelectInterfacePin
    extends AbstractAction {
        protected Interface intf;
        protected boolean ioOnly;

        public ActionSelectInterfacePin(Interface intf, boolean ioOnly) {
            super(ioOnly ? "Select Interface Pins" : "Select Descendant Interface Pins");
            this.intf = intf;
            this.ioOnly = ioOnly;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Design currentDesign = OrbitIO.getCurDesign();
            Selection s = currentDesign.getCurSelection();
            for (Floorplan floorplan : this.intf.getFloorplans()) {
                if (this.ioOnly) {
                    InterfaceCmds.selectFloorplanIOPins(s, floorplan);
                    continue;
                }
                InterfaceCmds.selectFloorplanPins(s, floorplan);
            }
            OrbitApp.getApp().refreshCurrentView(false);
        }
    }

    public static class ActionDeleteInterface
    extends AbstractAction {
        protected Interface intf;

        public ActionDeleteInterface(Interface intf) {
            super("Delete");
            this.intf = intf;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec((String)"com.sigrity.acl.db.std.Interface.delete(curDb(), \"%s\");", (Object[])new Object[]{this.intf.toStringPath()});
        }
    }

    public static class ActionEditInterface
    extends AbstractAction {
        protected Interface intf;

        public ActionEditInterface(Interface intf) {
            super("Edit");
            this.intf = intf;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InterfaceUI.showEditDialog(OrbitIO.getMainWindow(), this.intf);
        }
    }

    public static class ActionVisibleInterface
    extends AbstractAction {
        protected Interface intf;

        public ActionVisibleInterface(Interface intf) {
            super("Visible");
            this.intf = intf;
            this.putValue("SwingSelectedKey", intf.getVisible());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec((String)"com.sigrity.acl.db.std.Interface.setVisible(curDb(), \"%s\", %b);", (Object[])new Object[]{this.intf.toStringPath(), !this.intf.getVisible()});
        }
    }

    public static class ActionSelectInterfacePinMenu
    extends AActionGroup {
        public ActionSelectInterfacePinMenu(Interface intf) {
            this.putValue("Name", "Select");
            ActionSelectInterfacePin self = new ActionSelectInterfacePin(intf, true);
            ActionSelectInterfacePin descendant = new ActionSelectInterfacePin(intf, false);
            self.putValue("Name", "Interface Pins");
            descendant.putValue("Name", "Interface Descendant Pins");
            this.addActions(AUtil.arrayList((Object[])new Action[]{self, descendant}).iterator());
        }
    }

    public static class ActionShowInterfacePin
    extends AbstractAction {
        private Interface[] intfs;
        private ARect showBounds;

        public ActionShowInterfacePin(Interface ... interfaces) {
            super("Show Me All Pins");
            this.intfs = (Interface[])interfaces.clone();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.showBounds = null;
            for (Interface intf : this.intfs) {
                for (Floorplan fp : intf.getFloorplans()) {
                    for (FloorplanPin fpp : fp.getPins()) {
                        for (PinInstance pinInst : AIterableItr.itr((Stream)fpp.getPinInstances())) {
                            Device device = pinInst.getDevice();
                            if (device == null) continue;
                            for (DevicePath pinDevPath : device.getHierarchicalInstances()) {
                                if (!fpp.getDevicePath().isEndOf(pinDevPath)) continue;
                                ShowMeTheWay.addHierPin(new HierPin(pinDevPath, pinInst));
                                if (this.showBounds == null) {
                                    this.showBounds = pinInst.getWorldBounds(pinDevPath);
                                    continue;
                                }
                                this.showBounds.expand(pinInst.getWorldBounds(pinDevPath));
                            }
                        }
                    }
                }
            }
        }

        public ARect getShowBounds() {
            return this.showBounds;
        }
    }

    public static class ActionShowZoomInterfacePin
    extends AbstractAction {
        private Interface[] intfs;

        public ActionShowZoomInterfacePin(Interface ... interfaces) {
            super("Show Me All Pins And Zoom");
            this.intfs = (Interface[])interfaces.clone();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ActionShowInterfacePin v = new ActionShowInterfacePin(this.intfs);
            v.actionPerformed(null);
            ARect ans = v.getShowBounds();
            if (ans != null) {
                ans.changeSizeBy(0.1);
                ((DesignView2D)OrbitIO.getCurView()).getCanvas().getXForm().setWorld(ans);
                ((DesignView2D)OrbitIO.getCurView()).getCanvas().refresh();
            }
        }
    }

    public static class ActionShowInterfaceMenu
    extends AActionGroup {
        public ActionShowInterfaceMenu(Interface intf) {
            this.putValue("Name", "Show");
            ActionShowInterfacePin me = new ActionShowInterfacePin(intf);
            ActionShowZoomInterfacePin meAndZoom = new ActionShowZoomInterfacePin(intf);
            me.putValue("Name", "Me All Pins");
            meAndZoom.putValue("Name", "Me All Pins and Zoom");
            this.addActions(AUtil.arrayList((Object[])new Action[]{me, meAndZoom}).iterator());
        }
    }

    public static class ActionEditInterfaceNets
    extends AbstractAction {
        protected Interface intf;

        public ActionEditInterfaceNets(Interface intf) {
            super("Edit Nets");
            this.intf = intf;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GetObjectsChooserDlg.createDialog(OrbitIO.getMainWindow(), new GetDbObjectsChooserAdaptor(this.intf), false);
        }
    }

    public static class GetDbObjectsChooserAdaptor
    implements GetObjectsChooserDlg.GetObjectsChooserHelper {
        protected Interface mSelectedInterface;
        protected Db mDb;
        protected boolean showNonSelectableNets = (Boolean)Settings.get((String)"GUI", (String)"ShowNonSelectableNets", (Object)true);
        protected boolean showNetsAlreadySelected = (Boolean)Settings.get((String)"GUI", (String)"ShowAlreadySelectedNets", (Object)true);
        protected Runnable mDoneRunner;
        protected Runnable mCloseRunner;
        final Comparator<Net> NET_BY_NAME_ORDER = new Comparator<Net>(){

            @Override
            public int compare(Net e1, Net e2) {
                return e1.compareByNameTo((DbObject)e2);
            }
        };

        public GetDbObjectsChooserAdaptor(Interface intf) {
            this.mSelectedInterface = intf;
            this.mDb = intf.getDb();
        }

        public GetDbObjectsChooserAdaptor(Interface intf, Runnable doneRunner, Runnable closeRunner) {
            this(intf);
            this.mDoneRunner = doneRunner;
            this.mCloseRunner = closeRunner;
        }

        @Override
        public Db getDb() {
            return this.mDb;
        }

        @Override
        public String getTitle() {
            return String.format("Edit Interface %s Nets", this.mSelectedInterface.getName());
        }

        @Override
        public String getUserObjectName() {
            return "Net";
        }

        @Override
        public void doDoneCommand(Vector<Object> list, Object relObject) {
            DeviceTemplate devTemplate = (DeviceTemplate)relObject;
            String interfacePath = this.mSelectedInterface.toStringPath();
            if (this.mSelectedInterface.getNetsReferencedWRT() != devTemplate) {
                Cp.exec((String)("com.sigrity.acl.db.std.Interface.setSubstrateDevTemplate(curDb(), \"" + this.mSelectedInterface.toStringPath() + "\", \"" + devTemplate.getKeyStr() + "\");"), (Object[])new Object[0]);
                Cp.exec((String)"com.sigrity.acl.db.std.Interface.removeAllNets(curDb(), \"%s\", true);", (Object[])new Object[]{interfacePath});
            } else {
                Cp.exec((String)"com.sigrity.acl.db.std.Interface.removeAllNets(curDb(), \"%s\", false);", (Object[])new Object[]{interfacePath});
            }
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)"Edit Floorplan Nets");){
                for (Object obj : list) {
                    Net netObj = (Net)obj;
                    String netKeyStr = netObj.getKeyStr();
                    Interface intf = this.mSelectedInterface.isNetInAncestor(netObj);
                    if (intf != null) {
                        Cp.exec((String)"com.sigrity.acl.db.std.Interface.removeNet(curDb(), \"%s\", \"%s\");", (Object[])new Object[]{intf.toStringPath(), netKeyStr});
                    }
                    Cp.exec((String)"com.sigrity.acl.db.std.Interface.addNet(curDb(), \"%s\", \"%s\");", (Object[])new Object[]{interfacePath, netKeyStr});
                }
            }
            Cp.exec((String)("com.sigrity.orbit.ui.InterfaceTreeUI.assignExistingPinsToFloorplanForAllDecendents(curDb(), \"" + this.mSelectedInterface.toStringPath() + "\");"), (Object[])new Object[0]);
            if (this.mSelectedInterface.getNetsReferencedWRT() != null) {
                Cp.exec((String)("com.sigrity.acl.db.std.Interface.autoAssignNetsToFloorplanPins(curDb(), \"" + this.mSelectedInterface.getFloorplan(this.mSelectedInterface.getNetsReferencedWRT(), true).getKeyStr() + "\");"), (Object[])new Object[0]);
                OrbitApp.getApp().refreshCurrentView(false);
            }
            if (this.mDoneRunner != null) {
                this.mDoneRunner.run();
            }
        }

        @Override
        public void doClosingCommand() {
            if (this.mCloseRunner != null) {
                this.mCloseRunner.run();
            }
            Settings.set((String)"GUI", (String)"ShowNonSelectableNets", (Object)this.showNonSelectableNets);
            Settings.set((String)"GUI", (String)"ShowAlreadySelectedNets", (Object)this.showNetsAlreadySelected);
        }

        @Override
        public String getObjectString(Object obj) {
            return ((Net)obj).getName();
        }

        @Override
        public boolean getObjectCanBeAdded(Object obj, Object relObject) {
            List lst = this.mSelectedInterface.getNetsAllowedToBeAdded((DeviceTemplate)relObject);
            return lst.contains(obj);
        }

        @Override
        public boolean getObjectCanBeRemoved(Object obj, Object relObject) {
            List lst = this.mSelectedInterface.getNonRemoveableNets((DeviceTemplate)relObject);
            return !lst.contains(obj);
        }

        @Override
        public String getCurrentListToolTipText(Object net, Object relObject) {
            if (this.mSelectedInterface.getNetsReferencedWRT() != null && this.mSelectedInterface.getNetsReferencedWRT() == relObject) {
                Interface intf = this.mSelectedInterface.isNetInAncestor((Net)net);
                if (intf != null) {
                    return "This net exists in an ancestor, '" + intf.getName() + "'. Pressing 'Done' will pull it to this level.";
                }
                intf = this.mSelectedInterface.isNetInDescendant((Net)net);
                if (intf != null) {
                    return "This net exists in decendent interface '" + intf.getName() + "'. It is already inherited at this level.";
                }
            }
            return "";
        }

        @Override
        public String getCompleteListToolTipText(Object net, Object relObject) {
            Interface intf = this.mSelectedInterface.isNetInAnotherInterface((Net)net);
            if (intf != null) {
                return "This net is defined in Interface '" + intf.getName() + "'.";
            }
            if (this.mSelectedInterface.getNetsReferencedWRT() == relObject) {
                intf = this.mSelectedInterface.isNetInDescendant((Net)net);
                if (intf != null) {
                    return "This net is already defined in decendent interface '" + intf.getName() + "' and is aleady being inherited at this level.";
                }
                intf = this.mSelectedInterface.isNetInAncestorDescendants((Net)net);
                if (intf != null) {
                    return "This net is defined in another branch (Interface '" + intf.getName() + "') of an ansestor of this interface";
                }
                intf = this.mSelectedInterface.isNetInAncestor((Net)net);
                if (intf != null) {
                    return "This net is defined in ansestor Interface '" + intf.getName() + "'.";
                }
            }
            return "";
        }

        @Override
        public Color getObjectBackground(Object net, boolean selected, Object relObject, boolean completeList) {
            if (this.mSelectedInterface.isNetInAnotherInterface((Net)net) != null) {
                return InterfaceTreeUI.ColorErr;
            }
            if (completeList) {
                if (this.mSelectedInterface.getNetsReferencedWRT() == relObject) {
                    if (this.mSelectedInterface.isNetInAncestor((Net)net) != null) {
                        if (!selected) {
                            return InterfaceTreeUI.ColorWarn;
                        }
                    } else if (this.mSelectedInterface.isNetInDescendant((Net)net) != null) {
                        if (!selected) {
                            return InterfaceTreeUI.ColorInherit;
                        }
                    } else if (this.mSelectedInterface.isNetInAncestorDescendants((Net)net) != null) {
                        return InterfaceTreeUI.ColorErr;
                    }
                }
            } else if (!selected && this.mSelectedInterface.getNetsReferencedWRT() != null && this.mSelectedInterface.getNetsReferencedWRT() == relObject) {
                if (this.mSelectedInterface.isNetInAncestor((Net)net) != null) {
                    return InterfaceTreeUI.ColorWarn;
                }
                if (this.mSelectedInterface.isNetInDescendant((Net)net) != null) {
                    return InterfaceTreeUI.ColorInherit;
                }
            }
            return null;
        }

        @Override
        public List<Object> getPropertyValueList(Object relObject) {
            LinkedList<Object> ans = new LinkedList<Object>();
            if (this.mSelectedInterface == null) {
                return ans;
            }
            for (Net net : this.mSelectedInterface.getCandidateNets((DeviceTemplate)relObject)) {
                if (!this.showNonSelectableNets && (this.mSelectedInterface.isNetInAnotherInterface(net) != null || this.mSelectedInterface.isNetInAncestorDescendants(net) != null)) continue;
                ans.add(net);
            }
            return ans;
        }

        @Override
        public List<Object> getDefaultCurrentList() {
            LinkedList<Object> ans = new LinkedList<Object>();
            if (this.mSelectedInterface != null && this.mSelectedInterface.getNets(false) != null) {
                for (Net net : this.mSelectedInterface.getNets(true)) {
                    ans.add(net);
                }
            }
            return ans;
        }

        @Override
        public boolean includeRelObjectFilter() {
            return true;
        }

        @Override
        public boolean includeRelObjectNone() {
            return false;
        }

        @Override
        public boolean onlyShowList() {
            return false;
        }

        @Override
        public Object getDefaultRelObject() {
            if (this.mSelectedInterface == null || this.mSelectedInterface.getNetsReferencedWRT() == null) {
                return null;
            }
            return this.mSelectedInterface.getNetsReferencedWRT();
        }

        @Override
        public String relObjectLabel() {
            return "Choose Nets From:";
        }

        @Override
        public String getRelObjectToString(Object relObject) {
            return DeviceTemplate.getUserDisplayName((DeviceTemplate)((DeviceTemplate)relObject));
        }

        @Override
        public LinkedList<Object> getSortedRelObjectList() {
            LinkedList relFloorplans = this.mSelectedInterface.getSortedFloorplanList();
            LinkedList<Object> relObjects = new LinkedList<Object>();
            for (Floorplan floorplan : relFloorplans) {
                relObjects.add(floorplan.getDeviceTemplate());
            }
            return relObjects;
        }

        @Override
        public boolean doValidateRelObjectChange(Object newRelObject, Vector<Object> list) {
            if (this.mSelectedInterface.getNetsReferencedWRT() == null ? !list.isEmpty() : newRelObject != this.mSelectedInterface.getNetsReferencedWRT() && (this.mSelectedInterface.getRoot().hasNetsAtOtherHierarchyLevels(this.mSelectedInterface) || !list.isEmpty())) {
                int r;
                String msg = "Changing the substrate requires removing all nets from this interface. Change Anyway?";
                if (this.mSelectedInterface.getRoot().hasNetsAtOtherHierarchyLevels(this.mSelectedInterface)) {
                    msg = "Changing the substrate requires removing all nets from this interface at all hierarchal levels. Change Anyway?";
                }
                if ((r = JOptionPane.showConfirmDialog(null, msg, "Confirm Change", 1, 3)) == 2 || r == 1) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public <T> Comparator<T> getComparator() {
            return this.NET_BY_NAME_ORDER;
        }

        @Override
        public int getNumCheckboxes() {
            return 2;
        }

        @Override
        public boolean getCheckboxChecked(int index) {
            switch (index) {
                case 0: {
                    return this.showNonSelectableNets;
                }
            }
            return this.showNetsAlreadySelected;
        }

        @Override
        public String getCheckboxTitle(int index) {
            switch (index) {
                case 0: {
                    return "Show nets that cannot be selected (already in another interface).";
                }
                case 1: {
                    return "Show nets already in 'Current Nets' list.";
                }
            }
            return null;
        }

        @Override
        public String getCheckboxTooltip(int index) {
            switch (index) {
                case 0: {
                    return "Show nets with red background, that are not selectable.";
                }
                case 1: {
                    return "Show nets in left 'Nets' list (below) that also appear in the right 'Current Nets' list(below)";
                }
            }
            return null;
        }

        @Override
        public void notifyCheckboxChanged(String title, boolean newValue) {
            if (title.equals("Show nets that cannot be selected (already in another interface).")) {
                this.showNonSelectableNets = newValue;
            } else {
                this.showNetsAlreadySelected = newValue;
            }
        }

        @Override
        public boolean includeItemsInCurSelectionInMainList() {
            return this.showNetsAlreadySelected;
        }
    }

    public static class ActionContractInterfaces
    extends AbstractAction {
        private Interface[] intfs;

        public ActionContractInterfaces(Interface ... interfaces) {
            super("Assign a Common Parent");
            this.intfs = (Interface[])interfaces.clone();
            Interface parentInf = this.intfs[0].getParent();
            for (Interface intf : this.intfs) {
                if (intf.getParent() == parentInf) continue;
                this.setEnabled(false);
                return;
            }
            if (parentInf == null) {
                DeviceTemplate dt = this.intfs[0].getNetsReferencedWRT();
                for (Interface intf : this.intfs) {
                    if (intf.getNetsReferencedWRT() == dt) continue;
                    this.setEnabled(false);
                    return;
                }
            }
        }

        public static String getPrefixName(List<String> strs) {
            String ret = strs.get(0);
            for (String s : strs) {
                int prefixLen;
                for (prefixLen = 0; prefixLen < s.length() && prefixLen < ret.length() && s.charAt(prefixLen) == ret.charAt(prefixLen); ++prefixLen) {
                }
                if (prefixLen > 0) {
                    ret = ret.substring(0, prefixLen);
                    continue;
                }
                return ret;
            }
            return ret;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Db db = this.intfs[0].getDb();
            Interface parentIntf = this.intfs[0].getParent();
            Interface targetIntf = null;
            targetIntf = parentIntf == null ? (Interface)Cp.exec((String)"com.sigrity.acl.db.std.Interface.createDefaultRoot(OrbitIO.getCurDb())", (Object[])new Object[0]) : (Interface)Cp.exec((String)"com.sigrity.acl.db.std.Interface.createDefault(OrbitIO.getCurDb(), \"%s\")", (Object[])new Object[]{parentIntf.toStringPath()});
            if (targetIntf == null) {
                return;
            }
            String intfName = ActionContractInterfaces.getPrefixName(Arrays.asList(this.intfs).stream().map(Interface::getName).collect(Collectors.toList()));
            intfName = Interface.getUniqueName((Db)db, (String)intfName);
            int ioCount = 0;
            for (Interface intf : this.intfs) {
                ioCount += intf.getExpectedIOCount();
            }
            Cp.exec((String)"InterfaceCmds.setInterfaceValue(OrbitIO.getCurDb(), \"%s\", \"%s\", %d)", (Object[])new Object[]{targetIntf.toStringPath(), intfName, ioCount});
            Interface selIntf = InterfaceUI.showSelectDialog(OrbitIO.getMainWindow(), targetIntf);
            if (selIntf != targetIntf) {
                Cp.exec((String)"com.sigrity.acl.db.std.Interface.delete(curDb(), \"%s\")", (Object[])new Object[]{targetIntf.getKeyStr()});
            }
            if (selIntf == null) {
                return;
            }
            targetIntf = selIntf;
            for (Interface intf : this.intfs) {
                Cp.exec((String)"InterfaceCmds.setInterfaceParent(OrbitIO.getCurDb(), \"%s\", \"%s\")", (Object[])new Object[]{intf.toStringPath(), targetIntf.toStringPath()});
            }
            if (parentIntf != null) {
                Cp.exec((String)"InterfaceCmds.setInterfaceParent(OrbitIO.getCurDb(), \"%s\", \"%s\")", (Object[])new Object[]{targetIntf.toStringPath(), parentIntf.toString()});
            } else {
                Cp.exec((String)"InterfaceCmds.setInterfaceParent(OrbitIO.getCurDb(), \"%s\", null)", (Object[])new Object[]{targetIntf.toStringPath()});
            }
            if (parentIntf != null) {
                parentIntf.resetInterfaceStatus();
            }
            targetIntf.resetInterfaceStatus();
        }
    }
}

