/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.orbit.OrbitIO;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LEFDEFExportOptionsPanel
extends JPanel {
    JCheckBox mExportNets;
    JCheckBox mExportSynthesizedDevices;
    JTextField mTxtDevTmpltPrefix;
    JComboBox<String> mDieList;

    public LEFDEFExportOptionsPanel() {
        this.setBorder(BorderFactory.createTitledBorder("Def Export options"));
        GridBagManager l = new GridBagManager((Container)this);
        JLabel label1 = new JLabel("Die:");
        l.add((Component)label1, (GridBagConstraints)GridBagManager.LEFT);
        this.mDieList = new JComboBox();
        l.add(this.mDieList, (GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
        l.newline();
        this.mExportNets = new JCheckBox("Export Nets");
        l.add((Component)this.mExportNets, (GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
        l.newline();
        this.mExportSynthesizedDevices = new JCheckBox("Export Synthesized Devices");
        l.add((Component)this.mExportSynthesizedDevices, (GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
        l.newline();
        l.addFillY();
        this.populate();
    }

    protected void populate() {
        this.mDieList.removeAllItems();
        Db db = OrbitIO.getApp().getCurrentDb();
        for (Device d : db.getObjects(Device.class)) {
            DeviceTemplate t;
            if (!d.getIsSubstrate() || (t = d.getTemplate()).getType() != DeviceTemplate.Type.DIE && t.getType() != DeviceTemplate.Type.INTERPOSER) continue;
            this.mDieList.addItem(d.getShortName());
        }
    }

    public boolean getExportSynthesized() {
        return this.mExportSynthesizedDevices.isSelected();
    }

    public boolean getExportNets() {
        return this.mExportNets.isSelected();
    }

    public Device getDie() {
        String name = (String)this.mDieList.getSelectedItem();
        return Device.getADeviceByName((Db)OrbitIO.getApp().getCurrentDb(), (String)name);
    }
}

