/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbFieldDef;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.APatternHelpButton;
import com.sigrity.acl.ui.ATextField;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.ui.LayerListCellRenderer;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LayerChooser {
    protected static int COLS_FILTER = 6;

    public static Layer getLayer(Component owner, Substrate s) {
        return LayerChooser.getLayer(owner, s, (Layer)null);
    }

    public static Layer getLayer(Component owner, Substrate s, Layer initial) {
        return LayerChooser.getLayer(owner, s, initial, null);
    }

    public static Layer getLayer(Component owner, Substrate s, Layer initialLayer, Layer special) {
        return LayerChooser.getLayer(owner, s, initialLayer, special, null);
    }

    public static Layer getLayer(Component owner, Substrate s, final Layer initialLayer, final Layer special, final LayerFilter filter) {
        return LayerChooser.getLayer(owner, s, new InitHook(){

            @Override
            public void initLayerChooser(LCPanel lc) {
                lc.setSpecial(special);
                lc.setInitialLayer(initialLayer);
                lc.setLayerFilter(filter);
            }
        });
    }

    public static Layer getLayer(Component owner, Substrate s, InitHook initHook) {
        LCDialog dlg = new LCDialog(owner);
        if (initHook != null) {
            initHook.initLayerChooser(dlg.mChooserPnl);
        }
        dlg.setSubstrate(s);
        dlg.setModal(true);
        UIUtil.center((Component)((Object)dlg));
        dlg.setVisible(true);
        return dlg.getSelectedLayer();
    }

    public static class LCPanel
    extends JPanel {
        protected Substrate mSubstrate = null;
        protected Layer mInitialLayer = null;
        protected Layer mSpecialLayer = null;
        protected Layer mSelectedLayer = null;
        protected LayerFilter mLayerFilter = null;
        protected Comparator<Layer> mLayerSortComparator = Layer.TopFirstSort;
        protected JPanel mCustomTopPnl = new JPanel();
        protected APatternHelpButton mPhbHelpPattern;
        protected ATextField mTxtFilter;
        protected JList<Layer> mLstLayers;
        protected Vector<Layer> mAllLayers;
        protected JLabel mLblStatus;
        protected Timer mUpdateFilteredDataTimer;
        protected ActionListener mUpdateFilteredDataTask = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.updateFilteredData();
            }
        };
        protected Runnable mDoUpdateFilteredData = new Runnable(){

            @Override
            public void run() {
                this.updateFilteredData();
            }
        };
        protected LinkedHashSet<LayerListener> mLayerListeners = new LinkedHashSet();
        protected MouseListener mLayerMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && this.getSelectedLayer() != null) {
                    this.fireLayerActivated(this.getSelectedLayer());
                }
            }
        };
        protected ListSelectionListener mListSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                this.fireLayerSelected(this.getSelectedLayer());
            }
        };
        protected KeyListener mKeyListener = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyCode() == 10 && this.getSelectedLayer() != null) {
                    this.fireLayerActivated(this.getSelectedLayer());
                }
            }
        };

        public LCPanel() {
            GridBagManager l = new GridBagManager((Container)this);
            l.add((Component)this.mCustomTopPnl, (GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
            this.mCustomTopPnl.setVisible(false);
            l.newline();
            JLabel lblFilterPattern = l.add("Filter pattern:");
            l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.FILLX.noInsets());
            this.mTxtFilter = new ATextField(COLS_FILTER);
            l.add((Component)this.mTxtFilter, (GridBagConstraints)GridBagManager.FILLX);
            lblFilterPattern.setLabelFor(this.mTxtFilter);
            this.mTxtFilter.setActionHandler(this.mDoUpdateFilteredData);
            this.mTxtFilter.setInvokeActionOnTextUpdate(true);
            this.mPhbHelpPattern = new APatternHelpButton();
            l.add((Component)this.mPhbHelpPattern, (GridBagConstraints)GridBagManager.RIGHT);
            l.pop();
            l.newline();
            this.mLstLayers = new JList();
            JScrollPane spLayerList = new JScrollPane(this.mLstLayers);
            l.add((Component)spLayerList, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            this.mLstLayers.setCellRenderer(new LayerListCellRenderer());
            l.newline();
            this.mLblStatus = new JLabel("");
            l.add((Component)this.mLblStatus, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            this.mLblStatus.setVisible(false);
            this.setSelectionMode(0);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.mLstLayers.addMouseListener(this.mLayerMouseListener);
            this.mLstLayers.getSelectionModel().addListSelectionListener(this.mListSelectionListener);
            this.mLstLayers.addKeyListener(this.mKeyListener);
        }

        @Override
        public void removeNotify() {
            this.mLstLayers.removeKeyListener(this.mKeyListener);
            this.mLstLayers.getSelectionModel().removeListSelectionListener(this.mListSelectionListener);
            this.mLstLayers.removeMouseListener(this.mLayerMouseListener);
            super.removeNotify();
        }

        public void setSelectionMode(int mode) {
            this.mLstLayers.setSelectionMode(mode);
        }

        public void setSortComparator(Comparator<Layer> comparator) {
            this.mLayerSortComparator = comparator;
        }

        public void setSubstrate(Substrate s) {
            this.mSubstrate = s;
            this.updateAllLayers();
        }

        public void setInitialLayer(Layer layer) {
            this.mInitialLayer = layer;
        }

        public void setLayerFilter(LayerFilter filter) {
            this.mLayerFilter = filter;
        }

        public void setSpecial(Layer l) {
            this.mSpecialLayer = l;
        }

        public void setFilter(String prop, String filter) {
            this.mTxtFilter.setText(filter);
        }

        public JPanel getCustomTopPanel() {
            return this.mCustomTopPnl;
        }

        public void setSelectedLayer(Layer layer) {
            for (Layer l : this.mAllLayers) {
                if (layer != l) continue;
                this.mLstLayers.setSelectedValue(l, true);
                break;
            }
        }

        public Layer getSelectedLayer() {
            this.mSelectedLayer = this.mLstLayers.getSelectedValue();
            return this.mSelectedLayer;
        }

        public void updateAllLayers() {
            this.mAllLayers = new Vector();
            if (this.mSubstrate != null) {
                for (Layer l : this.mSubstrate.getLayers()) {
                    if (this.mLayerFilter != null && !this.mLayerFilter.includeLayer(l)) continue;
                    this.mAllLayers.add(l);
                }
            }
            Collections.sort(this.mAllLayers, this.mLayerSortComparator);
            if (this.mSpecialLayer != null) {
                this.mAllLayers.add(0, this.mSpecialLayer);
            }
            this.updateFilteredData();
        }

        protected void updateFilteredData() {
            if (!this.mTxtFilter.isEnabled()) {
                return;
            }
            Object filter = this.mTxtFilter.getText();
            if (((String)filter).length() == 0) {
                this.mLstLayers.setListData(this.mAllLayers);
                this.setStatus("");
                return;
            }
            if (!(((String)filter).contains("\\") || ((String)filter).contains(".") || ((String)filter).contains("["))) {
                filter = (String)filter + ".*";
            }
            try {
                Pattern pattern = Pattern.compile((String)filter);
                Vector<Layer> filteredData = new Vector<Layer>(this.mAllLayers.size());
                DbClass dbcLayer = this.mSubstrate.getDb().getDbClass(Layer.class);
                DbFieldDef fdef = dbcLayer.getField("name");
                for (Layer l : this.mAllLayers) {
                    if (l == this.mSpecialLayer) {
                        filteredData.add(l);
                        continue;
                    }
                    String val = fdef.getStringValue((DbObject)l);
                    if (val == null) {
                        val = "";
                    }
                    if (!pattern.matcher(val).matches()) continue;
                    filteredData.add(l);
                }
                this.mLstLayers.setListData(filteredData);
                this.setStatus("List filtered.");
            }
            catch (PatternSyntaxException e) {
                this.setStatus("Invalid pattern, all data displayed.");
                this.mLstLayers.setListData(this.mAllLayers);
                this.mTxtFilter.requestFocus();
                return;
            }
        }

        protected void setStatus(String text) {
            this.mLblStatus.setVisible(text != null && text.length() > 0);
            this.mLblStatus.setText(text);
        }

        public void addLayerListener(LayerListener l) {
            this.mLayerListeners.add(l);
        }

        public void removeLayerListener(LayerListener l) {
            this.mLayerListeners.remove(l);
        }

        protected void fireLayerActivated(Layer d) {
            for (LayerListener l : this.mLayerListeners) {
                l.layerActivated(this.getSelectedLayer());
            }
        }

        protected void fireLayerSelected(Layer d) {
            for (LayerListener l : this.mLayerListeners) {
                l.layerSelected(this.getSelectedLayer());
            }
        }

        public static interface LayerListener {
            public void layerSelected(Layer var1);

            public void layerActivated(Layer var1);
        }
    }

    public static class LCDialog
    extends ADialog {
        protected LCPanel mChooserPnl;
        protected JLabel mLblStatus;
        protected LCPanel.LayerListener mLayerListener = new LCPanel.LayerListener(this){
            final /* synthetic */ LCDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void layerSelected(Layer d) {
            }

            @Override
            public void layerActivated(Layer l) {
                this.this$0.mOk.actionPerformed(null);
            }
        };
        protected WindowListener mDialogListener = new WindowAdapter(this){
            final /* synthetic */ LCDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void windowClosed(WindowEvent e) {
                this.this$0.removeWindowListener(this);
                this.this$0.mChooserPnl.removeLayerListener(this.this$0.mLayerListener);
            }
        };
        protected ActionListener mOk = new ActionListener(this){
            final /* synthetic */ LCDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.this$0.mChooserPnl.getSelectedLayer() == null) {
                    JOptionPane.showMessageDialog((Component)((Object)this.this$0), "You must select a layer to continue.", "Select Layer", 0);
                    return;
                }
                UIUtil.closeWindow((Window)((Object)this.this$0));
            }
        };

        public LCDialog() throws HeadlessException {
            this.init();
        }

        public LCDialog(Component owner) throws HeadlessException {
            super(owner);
            this.init();
        }

        public void setSubstrate(Substrate s) {
            this.mChooserPnl.setSubstrate(s);
        }

        public void setInitialLayer(Layer initLayer) {
            this.mChooserPnl.setInitialLayer(initLayer);
        }

        public void setSpecial(Layer special) {
            this.mChooserPnl.setSpecial(special);
        }

        public Layer getSelectedLayer() {
            return this.mChooserPnl.getSelectedLayer();
        }

        protected void init() {
            this.setTitle("Select Layer");
            GridBagManager l = new GridBagManager(this.getContentPane());
            this.mChooserPnl = new LCPanel(){

                @Override
                protected void setStatus(String text) {
                    mLblStatus.setText(text);
                }
            };
            l.add((Component)this.mChooserPnl, (GridBagConstraints)GridBagManager.FILLALL.noInsets());
            l.newline();
            l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
            this.mLblStatus = new JLabel("");
            l.add((Component)this.mLblStatus, (GridBagConstraints)GridBagManager.FILLX);
            JButton btnOk = new JButton("OK");
            l.add((Component)btnOk, (GridBagConstraints)GridBagManager.RIGHT);
            btnOk.addActionListener(this.mOk);
            JButton btnCancel = new JButton("Cancel");
            l.add((Component)btnCancel, (GridBagConstraints)GridBagManager.RIGHT);
            l.pop();
            this.mChooserPnl.addLayerListener(this.mLayerListener);
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOk);
            this.pack();
            UIUtil.center((Component)((Object)this));
            this.addWindowListener(this.mDialogListener);
        }
    }

    public static interface LayerFilter {
        public boolean includeLayer(Layer var1);
    }

    public static interface InitHook {
        public void initLayerChooser(LCPanel var1);
    }
}

