/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Substrate;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class LayerConstraintFrame
extends JPanel {
    JTable mTable;
    ArrayList<LayerConstraintUIModel> mUIModelList = new ArrayList();

    public LayerConstraintFrame(Substrate substrate) {
        super(new GridLayout(1, 0));
        this.loadUIModel(substrate);
        this.mTable = new JTable(new LayerConstraintModel(this.mUIModelList, substrate)){
            ConstraintCellRenderer r;
            {
                this.r = new ConstraintCellRenderer();
            }

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel);
            }

            @Override
            public TableCellRenderer getCellRenderer(int arg0, int arg1) {
                return this.r;
            }

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
                Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
                if (c instanceof JComponent) {
                    JComponent jc = (JComponent)c;
                    jc.setToolTipText("Set Layer Type");
                }
                return c;
            }
        };
        LayerCellEditor e = new LayerCellEditor();
        this.mTable.getColumnModel().getColumn(1).setCellEditor(e);
        this.mTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.mTable.setFillsViewportHeight(true);
        this.mTable.setRowSelectionAllowed(false);
        JScrollPane scrollPane = new JScrollPane(this.mTable);
        this.add(scrollPane);
        this.loadValues();
    }

    protected void loadUIModel(Substrate s) {
        for (Layer l : s.getLayers(Layer.TopFirstSort)) {
            LayerConstraintUIModel uiModel = new LayerConstraintUIModel();
            uiModel.name = l.getName();
            uiModel.changed = false;
            uiModel.exposedValue = l.getType();
            this.mUIModelList.add(uiModel);
        }
    }

    public void doSave(Substrate substrate, boolean saveOnlyChanged) {
        LayerCellEditor e = (LayerCellEditor)this.mTable.getColumnModel().getColumn(1).getCellEditor();
        e.done();
        int size = this.mUIModelList.size();
        for (int i = 0; i < size; ++i) {
            LayerConstraintUIModel uiModel = this.mUIModelList.get(i);
            if (!uiModel.changed && saveOnlyChanged) continue;
            String sVal = ((Layer.LayerType)uiModel.exposedValue).toString();
            Cp.exec((String)("com.sigrity.acl.db.std.Layer.setLayerType (\"" + substrate.getADevicePathUsing().getString() + "\", \"" + uiModel.name + "\", \"" + sVal + "\");"), (Object[])new Object[0]);
        }
    }

    public void loadValues() {
        LayerConstraintModel lcm = (LayerConstraintModel)this.mTable.getModel();
        Substrate substrate = lcm.mSubstrate;
        int row = 0;
        for (Layer l : substrate.getLayers(Layer.TopFirstSort)) {
            LayerConstraintUIModel uim = lcm.mUIModel.get(row++);
            uim.name = l.getName();
            uim.exposedValue = l.getType();
        }
    }

    class LayerConstraintModel
    extends AbstractTableModel {
        Substrate mSubstrate;
        ArrayList<LayerConstraintUIModel> mUIModel;
        private String[] columnNames = new String[]{"Layer", "Type"};

        LayerConstraintModel(ArrayList<LayerConstraintUIModel> uiModel, Substrate substrate) {
            this.mUIModel = uiModel;
            this.mSubstrate = substrate;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.mUIModel.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public String getRowName(int row) {
            return this.mUIModel.get((int)row).name;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return this.mUIModel.get((int)row).name;
            }
            return this.mUIModel.get((int)row).exposedValue;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
        }
    }

    static class ConstraintCellRenderer
    extends DefaultTableCellRenderer {
        ConstraintCellRenderer() {
        }

        @Override
        public void setValue(Object value) {
            this.setText(value == null ? "" : value.toString());
            this.setToolTipText("This is a tip");
        }
    }

    class LayerCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        LayerConstraintUIModel uim = null;
        Object originalValue;
        Boolean requiresValidation = false;
        JComboBox<String> box = null;

        LayerCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.uim = LayerConstraintFrame.this.mUIModelList.get(row);
            this.originalValue = this.uim.exposedValue;
            this.box = new JComboBox();
            for (Layer.LayerType l : Layer.LayerType.values()) {
                this.box.addItem(l.toString());
            }
            return this.box;
        }

        @Override
        public Object getCellEditorValue() {
            String s = this.box.getSelectedItem().toString();
            this.uim.exposedValue = Layer.LayerType.valueOf((String)s);
            this.uim.changed = true;
            return this.uim.exposedValue;
        }

        public void done() {
            this.fireEditingStopped();
        }
    }

    static class LayerConstraintUIModel {
        protected String name;
        protected Object exposedValue;
        protected boolean changed;

        LayerConstraintUIModel() {
        }
    }
}

