/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.google.common.collect.ImmutableMap;
import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AStream;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.dbui.render.LayerListRenderer;
import com.sigrity.acl.ui.AFillLayout;
import com.sigrity.acl.ui.AListConnectionManager;
import com.sigrity.acl.ui.AListConnectionOverlay;
import com.sigrity.acl.ui.AListModel;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.ui.LayerUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.TransferHandler;
import rx.Observable;
import rx.subjects.PublishSubject;

public class LayerMappingPanel
extends JLayeredPane {
    protected Db mDb;
    protected JPanel mMain = new JPanel();
    protected AListConnectionOverlay<Layer, Layer> mGlass;
    protected HashMap<Layer, Layer> mMappings = new HashMap();
    protected boolean mAllowCreate = false;
    protected HashSet<Layer> mRightNew = new HashSet();
    protected JList<Layer> mLstLeft = new JList();
    protected JList<Layer> mLstRight = new JList();
    protected JLabel mLblLayerMapStatus = new JLabel();
    protected UIUtil.APopupMenuProvider mLeftContextMenuProvider = new UIUtil.APopupMenuProvider(){

        public JPopupMenu getMenu(Component c, int x, int y) {
            JList lst = (JList)c;
            int idx = lst.locationToIndex(new Point(x, y));
            if (idx < 0) {
                return null;
            }
            final Layer l = (Layer)lst.getModel().getElementAt(idx);
            JPopupMenu menu = new JPopupMenu(l.getName());
            if (LayerMappingPanel.this.getRightMapped(l) != null) {
                menu.add(new AbstractAction(String.format("Ignore layer '%s'", l.getName())){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LayerMappingPanel.this.removeMappingForLeft(l);
                        LayerMappingPanel.this.repaint();
                    }
                });
            }
            if (!LayerMappingPanel.this.mRightNew.contains(LayerMappingPanel.this.getRightMapped(l)) && !LayerMappingPanel.this.hasLayerNamed(LayerMappingPanel.this.mLstRight, l.getName())) {
                menu.add(new AbstractAction(String.format("Create layer '%s'", l.getName())){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Layer rl = Layer.create(null, (String)l.getName());
                        LayerMappingPanel.this.addRightLayer(rl);
                        LayerMappingPanel.this.addMapping(l, rl);
                        LayerMappingPanel.this.repaint();
                    }
                });
            }
            if (menu.getComponentCount() > 0) {
                return menu;
            }
            return null;
        }
    };
    protected UIUtil.APopupMenuProvider mRightContextMenuProvider = new UIUtil.APopupMenuProvider(){

        public JPopupMenu getMenu(Component c, int x, int y) {
            JList lst = (JList)c;
            final int idx = lst.locationToIndex(new Point(x, y));
            if (idx < 0) {
                return null;
            }
            final LayerListModel lm = (LayerListModel)lst.getModel();
            final Layer rl = (Layer)lm.getElementAt(idx);
            JPopupMenu menu = new JPopupMenu(rl.getName());
            if (rl.getDb() == null) {
                if (idx > 0) {
                    menu.add(new AbstractAction(String.format("Move up", rl.getName())){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Layer layer = (Layer)lm.removeItem(idx);
                            lm.addItem(idx - 1, layer);
                            LayerMappingPanel.this.repaint();
                        }
                    });
                }
                if (idx < lm.getSize() - 1) {
                    menu.add(new AbstractAction(String.format("Move down", rl.getName())){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Layer layer = (Layer)lm.removeItem(idx);
                            lm.addItem(idx + 1, layer);
                            LayerMappingPanel.this.repaint();
                        }
                    });
                }
                menu.add(new AbstractAction(String.format("Edit pending new layer '%s'...", rl.getName())){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Map curLayers = LayerMappingPanel.this.getRightLayers().collect(Collectors.toMap(Layer::getName, Function.identity()));
                        Predicate<String> newNameValidator = newName -> {
                            Layer curLayer = (Layer)curLayers.get(newName);
                            return curLayer == null || curLayer == rl;
                        };
                        LayerUI.EditLayerDlg dlg = new LayerUI.EditLayerDlg(LayerMappingPanel.this, LayerMappingPanel.this.mDb, rl, newNameValidator);
                        if (dlg.doModal()) {
                            LayerMappingPanel.this.repaint();
                        }
                    }
                });
                menu.add(new AbstractAction(String.format("Remove pending new layer '%s'", rl.getName())){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LayerMappingPanel.this.removeMappingsForRight(rl);
                        LayerMappingPanel.this.removeRightLayer(rl);
                        LayerMappingPanel.this.repaint();
                    }
                });
            }
            if (menu.getComponentCount() > 0) {
                return menu;
            }
            return null;
        }
    };
    protected PublishSubject<Void> mMappingsChangedSubject = PublishSubject.create();

    public LayerMappingPanel(Db db) {
        this.mDb = db;
        this.setLayout(new AFillLayout());
        this.add(this.mMain);
        this.setLayer(this.mMain, JLayeredPane.DEFAULT_LAYER);
        GridBagManager l = new GridBagManager((Container)this.mMain);
        l.push("Layer Mapping", (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        l.add("From", (GridBagConstraints)GridBagManager.LEFT.insetVert(0));
        l.add("To", (GridBagConstraints)GridBagManager.LEFT.insetVert(0));
        l.newline();
        l.add((Component)new JScrollPane(this.mLstLeft), (GridBagConstraints)GridBagManager.FILLALL);
        this.mLstLeft.setCellRenderer(new LayerListRenderer());
        l.add((Component)new JScrollPane(this.mLstRight), (GridBagConstraints)GridBagManager.FILLALL);
        this.mLstRight.setCellRenderer(new LayerListRenderer());
        l.newline();
        l.add((Component)this.mLblLayerMapStatus, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        l.pop();
        this.mLstLeft.setSelectionMode(0);
        this.mLstRight.setModel(new LayerListModel((Iterable<Layer>)AEmptyItr.create()));
        this.mLstRight.setSelectionMode(0);
        ListMapper listMapper = new ListMapper();
        this.mGlass = new AListConnectionOverlay<Layer, Layer>(this.mLstLeft, this.mLstRight, listMapper);
        this.mGlass.setOpaque(false);
        this.add(this.mGlass);
        this.setLayer(this.mGlass, JLayeredPane.DEFAULT_LAYER + 1);
        AListConnectionManager<Layer, Layer> lcm = new AListConnectionManager<Layer, Layer>(this.mLstLeft, this.mLstRight, (AListConnectionOverlay.ListItemMapper)listMapper){

            @Override
            protected void updateStatus() {
                Layer layerL = (Layer)this.mLstLeft.getSelectedValue();
                if (layerL == null) {
                    this.mLstRight.setSelectedIndex(-1);
                    LayerMappingPanel.this.setLayerMapStatus(null);
                    return;
                }
                Layer layerR = LayerMappingPanel.this.getRightMapped(layerL);
                LayerMappingPanel.this.setLayerMapStatus(layerR == null ? String.format("Layer '%s' will be ignored.", layerL.getName()) : String.format("Layer '%s' will be mapped to '%s'.", layerL.getName(), layerR.getName()));
                LayerMappingPanel.this.repaint();
            }
        };
        UIUtil.installPopupMenu(this.mLstLeft, (UIUtil.APopupMenuProvider)this.mLeftContextMenuProvider);
        UIUtil.installPopupMenu(this.mLstRight, (UIUtil.APopupMenuProvider)this.mRightContextMenuProvider);
        this.setLayerMapStatus("Drag and drop or click/double-click to set matching layers");
        this.mLstRight.setTransferHandler(new AListConnectionManager.TransferHandlerRight(lcm){
            DataFlavor mFlavor = new DataFlavor(Layer.class, "Layer");
            DataFlavor[] mFlavors = new DataFlavor[]{this.mFlavor};

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                if (super.importData(support)) {
                    LayerMappingPanel.this.mLstRight.setDropMode(DropMode.ON);
                    return true;
                }
                if (support.isDataFlavorSupported(this.mFlavor)) {
                    LayerMappingPanel.this.mLstRight.setDropMode(DropMode.INSERT);
                    return true;
                }
                LayerMappingPanel.this.mLstRight.setDropMode(DropMode.ON);
                return false;
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                int oldIdx;
                if (super.importData(support)) {
                    return true;
                }
                if (!support.isDataFlavorSupported(this.mFlavor)) {
                    return false;
                }
                Layer dragLayer = null;
                try {
                    Layer temp;
                    dragLayer = temp = (Layer)support.getTransferable().getTransferData(this.mFlavor);
                }
                catch (Exception e) {
                    ALog.logWarn((Throwable)e, (String)"Error getting transfer data.", (Object[])new Object[0]);
                    return false;
                }
                LayerListModel lm = (LayerListModel)LayerMappingPanel.this.mLstRight.getModel();
                JList.DropLocation dropLoc = (JList.DropLocation)support.getDropLocation();
                int idx = dropLoc.getIndex();
                if (idx == -1) {
                    idx = lm.getSize();
                }
                if ((oldIdx = lm.indexOf(dragLayer)) >= 0) {
                    lm.removeItem(oldIdx);
                    if (oldIdx <= idx) {
                        --idx;
                    }
                }
                lm.addItem(idx, dragLayer);
                LayerMappingPanel.this.mLstRight.setSelectedValue(dragLayer, true);
                LayerMappingPanel.this.repaint();
                return true;
            }

            Layer getDragLayer() {
                Layer val = LayerMappingPanel.this.mLstRight.getSelectedValue();
                return val == null || val.getDb() != null ? null : val;
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 0x40000000;
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                final Layer l = this.getDragLayer();
                if (l == null) {
                    return null;
                }
                Transferable transferable = new Transferable(){

                    @Override
                    public boolean isDataFlavorSupported(DataFlavor flavor) {
                        return flavor == mFlavor;
                    }

                    @Override
                    public DataFlavor[] getTransferDataFlavors() {
                        return mFlavors;
                    }

                    @Override
                    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                        if (flavor != mFlavor) {
                            throw new UnsupportedFlavorException(flavor);
                        }
                        return l;
                    }
                };
                return transferable;
            }
        });
    }

    public void setAllowCreate(boolean allowCreate) {
        this.mAllowCreate = allowCreate;
        this.mLstRight.setDragEnabled(allowCreate);
    }

    public boolean getAllowCreate() {
        return this.mAllowCreate;
    }

    public void setLeftLayers(Stream<Layer> layers) {
        this.clearMappings();
        this.mLstLeft.setModel(new LayerListModel(layers));
    }

    public void setRightLayers(Stream<Layer> layers) {
        this.clearMappings();
        this.mLstRight.setModel(new LayerListModel(layers));
    }

    public void setLeftLayers(Substrate substrate) {
        this.setLeftLayers(substrate.getLayers().stream().sorted(Layer.TopFirstSort));
    }

    public void setRightLayers(Substrate substrate) {
        this.setRightLayers(substrate.getLayers().stream().sorted(Layer.TopFirstSort));
    }

    public void addRightLayer(Layer l) {
        ((LayerListModel)this.mLstRight.getModel()).addItem(l);
        this.mRightNew.add(l);
    }

    public void removeRightLayer(Layer rl) {
        LayerListModel llm = (LayerListModel)this.mLstRight.getModel();
        int idx = llm.indexOf(rl);
        if (idx >= 0) {
            llm.removeItem(idx);
        }
        this.mRightNew.remove(rl);
        this.removeMappingsForRight(rl);
    }

    public Stream<Layer> getLeftLayers() {
        return AStream.of((int)0, (int)(this.mLstLeft.getModel().getSize() - 1), this.mLstLeft.getModel()::getElementAt);
    }

    public Stream<Layer> getRightLayers() {
        return AStream.of((int)0, (int)(this.mLstRight.getModel().getSize() - 1), this.mLstRight.getModel()::getElementAt);
    }

    public void clearMappings() {
        this.mMappings.clear();
        this.fireMappingsChanged();
    }

    public void addMapping(String leftName, String rightName) {
        Layer right;
        Layer left = leftName == null ? null : (Layer)this.getLeftLayers().filter(l -> l != null && AUtil.equals((Object)l.getName(), (Object)leftName)).findFirst().orElse(null);
        Layer layer = right = rightName == null ? null : (Layer)this.getRightLayers().filter(l -> l != null && AUtil.equals((Object)l.getName(), (Object)rightName)).findFirst().orElse(null);
        if (leftName != null && left == null || rightName != null && right == null) {
            return;
        }
        this.addMapping(left, right);
    }

    public void addMapping(Layer left, Layer right) {
        LayerListModel rightLayers;
        this.mMappings.put(left, right);
        LayerListModel leftLayers = (LayerListModel)this.mLstLeft.getModel();
        if (!leftLayers.contains(left)) {
            leftLayers.addItem(left);
        }
        if (!(rightLayers = (LayerListModel)this.mLstRight.getModel()).contains(right)) {
            rightLayers.addItem(right);
        }
        this.fireMappingsChanged();
    }

    public void removeMappingForLeft(Layer left) {
        this.mMappings.remove(left);
        this.fireMappingsChanged();
    }

    public void removeMappingsForRight(Layer right) {
        this.getLeftMapped(right).collect(Collectors.toList()).forEach(this::removeMappingForLeft);
    }

    public ImmutableMap<Layer, Layer> getMappings() {
        return ImmutableMap.copyOf(this.mMappings);
    }

    public Layer getRightMapped(Layer left) {
        return this.mMappings.get(left);
    }

    public Stream<Layer> getLeftMapped(Layer right) {
        return this.mMappings.entrySet().stream().filter(entry -> entry.getValue() == right).map(Map.Entry::getKey);
    }

    protected void setLayerMapStatus(String s) {
        this.mLblLayerMapStatus.setText(s);
    }

    public Observable<Void> observeMappings() {
        return this.mMappingsChangedSubject;
    }

    public void fireMappingsChanged() {
        this.mMappingsChangedSubject.onNext(null);
    }

    private boolean hasLayerNamed(JList<Layer> l, String name) {
        return AStream.of((int)0, (int)(l.getModel().getSize() - 1), l.getModel()::getElementAt).map(Layer::getName).filter(curName -> curName.equals(name)).findAny().isPresent();
    }

    public void logMappings() {
        this.getMappings().forEach((a, b) -> ALog.logInfo((String)"%s -> %s", (Object[])new Object[]{a.getName(), b == null ? null : b.getName()}));
    }

    protected static class LayerListModel
    extends AListModel<Layer> {
        public LayerListModel(Iterable<Layer> layers) {
            layers.forEach(this::addItem);
        }

        public LayerListModel(Stream<Layer> layers) {
            layers.forEach(this::addItem);
        }

        public LayerListModel(Substrate s) {
            this(s.getLayers().stream().sorted(Layer.TopFirstSort));
        }
    }

    protected class ListMapper
    implements AListConnectionOverlay.ListItemMapper<Layer, Layer> {
        protected ListMapper() {
        }

        @Override
        public int getRightListIndex(int leftIndex) {
            Layer left = LayerMappingPanel.this.mLstLeft.getModel().getElementAt(leftIndex);
            Layer right = LayerMappingPanel.this.getRightMapped(left);
            return right == null ? -1 : ((LayerListModel)LayerMappingPanel.this.mLstRight.getModel()).indexOf(right);
        }

        @Override
        public void put(Layer l, Layer r) {
            LayerMappingPanel.this.addMapping(l, r);
        }
    }
}

