/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.google.common.collect.Lists;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APatternColor;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.AValidator;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.dbui.render.SubstrateListRenderer;
import com.sigrity.acl.ui.AColorChooserDlg;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.ASpinner;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DesignSettings;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.cmd.LayerCommands;
import com.sigrity.orbit.ui.CreateSubstrateUI;
import com.sigrity.orbit.ui.DesignDialog;
import com.sigrity.orbit.ui.core.ViewColorizer;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public class LayerUI {
    public static final String DESIGN = "<Design>";

    private LayerUI() {
    }

    @Deprecated
    public static LayerDlg createDlg(Window owner, Db db, String substrateToUse) {
        return new LayerDlg(owner, db, substrateToUse);
    }

    public static ViewColorizer getViewColorizer(Db db) {
        AValidator.validateNotNull((Object)db);
        Design design = Design.getDesign((Db)db, (boolean)false);
        if (design == null) {
            return null;
        }
        return (ViewColorizer)DesignSettings.get((Design)design, (String)"ViewColorizer", ViewColorizer.class);
    }

    public static boolean getLayerVisible(Layer l) {
        AValidator.validateNotNull((Object)l);
        ViewColorizer colorizer = LayerUI.getViewColorizer(l.getDb());
        if (colorizer == null) {
            return false;
        }
        ViewColorizer.LayerKey key = colorizer.getLayerKey(l, true);
        assert (key != null);
        return colorizer.getDisplay(null, (ViewColorizer.Key)key);
    }

    public static boolean setLayerVisible(Db db, String layerKeyStr, boolean visible) {
        AValidator.validateNotNull((Object)db);
        Layer l = (Layer)db.getByKeyStr(Layer.class, layerKeyStr);
        if (l == null) {
            return false;
        }
        LayerCommands.setLayerVisible(l, visible);
        return true;
    }

    public static boolean setLayerVisible(Db db, String layerKeyStr, String path, boolean visible) {
        AValidator.validateNotNull((Object)db);
        Layer l = (Layer)db.getByKeyStr(Layer.class, layerKeyStr);
        DevicePath dp = DevicePath.fromString((Db)db, (String)path);
        if (l == null || dp == null) {
            return false;
        }
        LayerCommands.setLayerVisible(l, visible, dp);
        return true;
    }

    public static void toggleLayerVisible(Layer l) {
        try (DbHistory.DbTransaction txn = DbHistory.newDbTransaction((Db)l.getDb(), (String)"Layer Visible");){
            boolean visible = !LayerUI.getLayerVisible(l);
            Cp.exec((String)"%s.setLayerVisible(curDb(), \"%s\", %b)", (Object[])new Object[]{LayerUI.class.getName(), l.getKeyStr(), visible});
        }
    }

    public static boolean changeLayerColor(Layer l) {
        AValidator.validateNotNull((Object)l);
        ViewColorizer colorizer = LayerUI.getViewColorizer(l.getDb());
        if (colorizer == null) {
            return false;
        }
        ViewColorizer.LayerKey key = colorizer.getLayerKey(l, true);
        String title = String.format("%s Color", colorizer.getDescription((Object)key));
        AColorChooserDlg dlg = AColorChooserDlg.createDialog((Component)OrbitIO.getMainWindow(), title, colorizer.findColor(null, (ViewColorizer.Key)key));
        Color newColor = dlg.doModal();
        if (newColor == null) {
            return false;
        }
        try (DbHistory.DbTransaction txn = DbHistory.newDbTransaction((Db)l.getDb(), (String)"Change Layer Color");){
            Cp.exec((String)"%s.setLayerColor(\"%s\", \"%s\")", (Object[])new Object[]{LayerCommands.class.getName(), l.getKeyStr(), AUtil.colorToString((Color)newColor)});
        }
        return true;
    }

    public static void editLayer(Layer l) {
        EditLayerDlg eld = new EditLayerDlg(OrbitIO.getMainWindow(), l.getSubstrate(), l);
        if (eld.doModal()) {
            OrbitIO.getApp().refreshCurrentView();
        }
    }

    private static boolean allLayersVisibleState(Iterable<Layer> layers, boolean visState) {
        for (Layer l : layers) {
            if (LayerUI.getLayerVisible(l) == visState) continue;
            return false;
        }
        return true;
    }

    public static class ActionInheritParentView
    extends AbstractAction {
        protected Layer mLayer;
        protected DevicePath mPath;

        public ActionInheritParentView(Layer l, DevicePath path) {
            super("Inherit Setting from Parent");
            this.setEnabled(!path.isEmpty());
            this.mPath = path;
            this.mLayer = l;
        }

        public ActionInheritParentView(DevicePath path) {
            this(null, path);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ViewColorizer vc = OrbitIO.getCurColorizer();
            if (this.mLayer != null) {
                vc.removeDisplayInfo(this.mPath, (ViewColorizer.Key)vc.getLayerKey(this.mLayer, true));
            } else {
                Substrate sub = this.mPath.getSubstrate();
                for (Layer l : sub.getLayers()) {
                    vc.removeDisplayInfo(this.mPath, (ViewColorizer.Key)vc.getLayerKey(l, true));
                }
            }
        }
    }

    public static class ActionEditLayer
    extends AbstractAction {
        protected Layer mLayer;

        public ActionEditLayer(Layer l) {
            super(String.format("Edit Layer '%s'...", l.getName()));
            this.mLayer = l;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LayerUI.editLayer(this.mLayer);
        }
    }

    public static class ActionSetLayerColor
    extends AbstractAction {
        protected Layer mLayer;

        public ActionSetLayerColor(Layer l) {
            super(String.format("Set Color for Layer '%s'...", l.getName()));
            this.mLayer = l;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LayerUI.changeLayerColor(this.mLayer);
        }
    }

    public static class ActionToggleLayerVisibility
    extends AbstractAction {
        protected Layer mLayer;
        protected Runnable mCallback;

        public ActionToggleLayerVisibility(Layer l, Runnable callback) {
            super(String.format("Turn %s Layer '%s'", LayerUI.getLayerVisible(l) ? "off" : "on", l.getName()));
            this.mLayer = l;
            this.mCallback = callback;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LayerUI.toggleLayerVisible(this.mLayer);
            OrbitIO.getApp().refreshCurrentView();
            if (this.mCallback != null) {
                this.mCallback.run();
            }
        }
    }

    public static class ActionSetAllLayersVisible
    extends AbstractAction {
        protected List<Layer> mLayers;
        protected boolean mVisible;
        protected Runnable mCallback;

        public ActionSetAllLayersVisible(String name, Iterable<Layer> layers, boolean visible, Runnable callback) {
            super(name);
            this.mLayers = Lists.newLinkedList(layers);
            this.mVisible = visible;
            this.mCallback = callback;
            if (LayerUI.allLayersVisibleState(this.mLayers, visible)) {
                this.setEnabled(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean modified = false;
            for (Layer l : this.mLayers) {
                if (!LayerUI.getLayerVisible(l) != this.mVisible) continue;
                Cp.exec((String)"%s.setLayerVisible(curDb(), \"%s\", %b)", (Object[])new Object[]{LayerUI.class.getName(), l.getKeyStr(), this.mVisible});
                modified = true;
            }
            if (modified) {
                if (this.mCallback != null) {
                    this.mCallback.run();
                }
                OrbitIO.getApp().refreshCurrentView();
            }
        }
    }

    public static class EditLayerDlg
    extends DesignDialog {
        protected static final double DEFAULT_HEIGHT = 10.0;
        protected Substrate mSubstrate;
        protected Predicate<String> mNameValidator = null;
        protected Layer mLayer;
        protected int mNewLayerOrder = -1;
        protected boolean mSavedData = false;
        protected JTextField mTxtLayerName;
        protected JComboBox<Layer.LayerType> mCboType;
        protected JTextField mTxtHeight;

        public EditLayerDlg(Component owner, Substrate substrate, Layer layer) {
            super(substrate.getDb(), owner);
            if (layer != null) {
                this.setTitle(String.format("Edit Layer '%s'", layer.getName()));
            } else {
                this.setTitle(String.format("Create Layer in Substrate '%s'", substrate.getName()));
            }
            this.mSubstrate = substrate;
            this.init(layer);
        }

        public EditLayerDlg(Component owner, Db db, Layer layer, Predicate<String> nameValidator) {
            super(db, owner);
            this.mNameValidator = nameValidator;
            this.init(layer);
        }

        public void init(Layer layer) {
            this.mLayer = layer;
            GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
            l.pushFill("Layer");
            if (this.mSubstrate != null) {
                l.add("Substrate:");
                JLabel substrateLabel = new JLabel(this.mSubstrate.getName(), DbExplorerPanel.getIconForSubstrate(this.mSubstrate), 2);
                l.add((Component)substrateLabel);
                l.newline();
            }
            l.add("Name:");
            this.mTxtLayerName = (JTextField)l.add((Component)new JTextField(20), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            l.newline();
            l.add("Type");
            this.mCboType = (JComboBox)l.add(new JComboBox<Layer.LayerType>(Layer.LayerType.values()));
            l.newline();
            l.add("Height:");
            this.mTxtHeight = (JTextField)l.add((Component)new JTextField(10));
            l.addFillY();
            l.popNl();
            l.pushFillXRemainX();
            l.addFillX();
            JButton btnOk = (JButton)l.add((Component)new JButton("OK"));
            JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
            l.pop();
            btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!this.validateData()) {
                        return;
                    }
                    if (mLayer == null) {
                        String name = mTxtLayerName.getText();
                        Layer.LayerType type = (Layer.LayerType)mCboType.getSelectedItem();
                        long height = this.getUnitDist().fromUser(AFieldValidator.getDouble((JTextField)mTxtHeight, (double)10.0));
                        Cp.exec((String)"Layer.create(curDb(), \"%s\", \"%s\", \"%s\", %dL, %d)", (Object[])new Object[]{mSubstrate.getName(), name, type.name(), height, mNewLayerOrder});
                        mSavedData = true;
                    } else {
                        String newName = mTxtLayerName.getText();
                        Layer.LayerType newType = (Layer.LayerType)mCboType.getSelectedItem();
                        long newHeight = this.getUnitDist().fromUser(AFieldValidator.getDouble((JTextField)mTxtHeight, (double)10.0));
                        if (mLayer.getDb() != null) {
                            if (!newName.equals(mLayer.getName())) {
                                Cp.exec((String)"Layer.get(curDb(), \"%s\", \"%s\").setName(\"%s\")", (Object[])new Object[]{mSubstrate.getName(), mLayer.getName(), newName});
                                mSavedData = true;
                            }
                            if (newType != mLayer.getType()) {
                                Cp.exec((String)"Layer.get(curDb(), \"%s\", \"%s\").setType(\"%s\")", (Object[])new Object[]{mSubstrate.getName(), mLayer.getName(), newType.name()});
                                mSavedData = true;
                            }
                            if (newHeight != mLayer.getHeight()) {
                                Cp.exec((String)"Layer.get(curDb(), \"%s\", \"%s\").setHeight(%dL)", (Object[])new Object[]{mSubstrate.getName(), mLayer.getName(), newHeight});
                                mSavedData = true;
                            }
                        } else {
                            mLayer.setName(newName);
                            mLayer.setType(newType);
                            mLayer.setHeight(newHeight);
                            mSavedData = true;
                        }
                    }
                    UIUtil.closeWindow((Window)((Object)this));
                }
            });
            if (this.mLayer != null) {
                this.mTxtLayerName.setText(this.mLayer.getName());
                this.mCboType.setSelectedItem(this.mLayer.getType());
                this.mTxtHeight.setText(this.getUnitDist().toUserStr(this.mLayer.getHeight()));
            } else {
                this.mTxtHeight.setText(Double.toString(10.0));
            }
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOk);
            this.pack();
            this.setMinimumSize(this.getPreferredSize());
            UIUtil.center((Component)((Object)this));
        }

        public boolean doModal() {
            this.setModal(true);
            this.setVisible(true);
            return this.mSavedData;
        }

        public void setNewLayerOrder(int o) {
            this.mNewLayerOrder = o;
        }

        public Layer getLayer() {
            return this.mLayer;
        }

        protected boolean validateData() {
            try {
                AFieldValidator.validateText((JTextComponent)this.mTxtLayerName);
                AFieldValidator.validateDouble((JTextField)this.mTxtHeight);
                String newLayerName = this.mTxtLayerName.getText();
                if ((this.mLayer == null || this.mLayer.getDb() == null || !newLayerName.equals(this.mLayer.getName())) && (this.mSubstrate != null && this.mSubstrate.getLayer(newLayerName) != null || this.mNameValidator != null && !this.mNameValidator.test(newLayerName))) {
                    throw AFieldValidator.createException((String)"already in use", (String)"Layer Name", null, (Component)this.mTxtLayerName);
                }
            }
            catch (AFieldValidator.AFieldValidationException e) {
                return false;
            }
            return true;
        }
    }

    protected static class LayerListModel
    extends AbstractListModel<Layer> {
        protected ArrayList<Layer> mLayers = new ArrayList();

        protected LayerListModel() {
        }

        @Override
        public int getSize() {
            return this.mLayers.size();
        }

        @Override
        public Layer getElementAt(int index) {
            return this.mLayers.get(index);
        }

        public void clear() {
            int size = this.mLayers.size();
            if (size == 0) {
                return;
            }
            this.mLayers.clear();
            this.fireIntervalRemoved(this, 0, size - 1);
        }

        public void addLayer(Layer l) {
            int index = this.mLayers.size();
            this.mLayers.add(l);
            this.fireIntervalAdded(this, index, index);
        }
    }

    public static class LayerListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            APatternColor c;
            super.getListCellRendererComponent(list, (Object)null, index, isSelected, cellHasFocus);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            this.setOpaque(true);
            if (value == null) {
                this.setText("NO CANDIDATE LAYER");
                return this;
            }
            Layer layer = (Layer)value;
            String text = String.format("%d: %s", layer.getOrder(), layer.getName());
            this.setText(text);
            ViewColorizer colorizer = LayerUI.getViewColorizer(layer.getDb());
            APatternColor aPatternColor = c = colorizer == null ? null : colorizer.getColor(null, layer, true);
            if (c != null) {
                this.setIcon((Icon)new AColorIcon(16, 16, c.getColor()));
            } else {
                this.setIcon(null);
            }
            return this;
        }
    }

    public static class LayerDlg
    extends DbDialog {
        protected JComboBox<Substrate> mCboSubstrate;
        protected JList<Layer> mLstLayers = new JList();
        protected LayerListModel mLayers = new LayerListModel();
        protected JButton mBtnAdd;
        protected JButton mBtnEdit;
        protected JButton mBtnDelete;
        protected JButton mBtnUp;
        protected JButton mBtnDown;

        public LayerDlg(Window owner, Db db, String substrateToUse) {
            super(db, (Component)owner);
            this.setTitle("Edit Layers");
            GridBagManager l = new GridBagManager(this.getContentPane());
            l.add("Substrate:");
            l.newline();
            this.mCboSubstrate = new JComboBox();
            l.add(this.mCboSubstrate, (GridBagConstraints)GridBagManager.FILLX);
            this.mCboSubstrate.addActionListener(e -> {
                if (this.mCboSubstrate.getSelectedItem() != null) {
                    this.updateLayers();
                } else {
                    CreateSubstrateUI.showMe(this.mDb, OrbitIO.getMainWindow());
                    this.updateSubstrates(null);
                    this.updateLayers();
                }
            });
            this.mCboSubstrate.setRenderer(new SubstrateListRenderer("New Substrate..."));
            l.newline();
            l.addNl("Layers:", (GridBagConstraints)GridBagManager.LEFT.insetBottom(0));
            this.mLstLayers = new JList<Layer>(this.mLayers);
            JScrollPane spLayers = new JScrollPane(this.mLstLayers);
            l.add((Component)spLayers, (GridBagConstraints)GridBagManager.FILLALL);
            this.mLstLayers.setCellRenderer(new LayerListCellRenderer());
            this.mLstLayers.setSelectionMode(0);
            this.mLstLayers.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    this.enableButtons();
                }
            });
            this.mLstLayers.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1 && e.getClickCount() == 2) {
                        mBtnEdit.doClick();
                    }
                }
            });
            l.newline();
            l.push((GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
            GridBagManager.GridBagConstraintsEx btnCs = GridBagManager.LEFT.insetTop(0).insetBottom(12);
            ASpinner spin = new ASpinner(ASpinner.SpinnerLayout.HORIZONTAL);
            spin.setUpToolTip("Move selected layer up");
            spin.addUpActionListener(e -> this.moveSelected(true));
            spin.setDownToolTip("Move selected layer down");
            spin.addDownActionListener(e -> this.moveSelected(false));
            l.add((Component)spin, (GridBagConstraints)btnCs.insetRight(20));
            l.addFillX();
            this.mBtnAdd = new JButton("Add...");
            this.mBtnAdd.setMargin(new Insets(1, 0, 1, 0));
            this.mBtnAdd.setToolTipText("Add a new layer");
            this.mBtnAdd.addActionListener(e -> {
                Substrate s = this.getSubstrate();
                if (s == null) {
                    ALog.logInfo((String)"Please select one of substrates.");
                    return;
                }
                EditLayerDlg dlg = new EditLayerDlg(this.mBtnAdd, s, null);
                Layer selLayer = this.mLstLayers.getSelectedValue();
                if (selLayer != null) {
                    dlg.setNewLayerOrder(selLayer.getOrder());
                } else {
                    ListModel<Layer> m = this.mLstLayers.getModel();
                    int newLayerOrder = 0;
                    if (m.getSize() > 0) {
                        newLayerOrder = m.getElementAt(0).getOrder() + 1;
                    }
                    dlg.setNewLayerOrder(newLayerOrder);
                }
                if (dlg.doModal()) {
                    this.updateLayers();
                    this.mLstLayers.setSelectedValue(dlg.getLayer(), true);
                }
            });
            l.add((Component)this.mBtnAdd, (GridBagConstraints)btnCs);
            this.mBtnEdit = new JButton("Edit...");
            this.mBtnEdit.setMargin(new Insets(1, 0, 1, 0));
            this.mBtnEdit.setToolTipText("Edit the selected layer");
            this.mBtnEdit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditLayerDlg dlg = new EditLayerDlg(mBtnAdd, this.getSubstrate(), this.getLayer());
                    if (dlg.doModal()) {
                        this.updateLayers();
                        mLstLayers.setSelectedValue(dlg.getLayer(), true);
                    }
                }
            });
            l.add((Component)this.mBtnEdit, (GridBagConstraints)btnCs);
            this.mBtnDelete = new JButton("Delete");
            this.mBtnDelete.setMargin(new Insets(1, 0, 1, 0));
            this.mBtnDelete.setToolTipText("Delete the selected layer");
            this.mBtnDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Layer l = this.getLayer();
                    int idx = mLstLayers.getSelectedIndex();
                    String relTypes = l.getRelatedTypeString();
                    if (relTypes != null) {
                        String msg = String.format("The layer '%s' has related %s objects, do you want to delete the layer and all its related objects?", l.getName(), relTypes);
                        int confirm = JOptionPane.showConfirmDialog(mBtnDelete, msg, "Confirm Delete", 0);
                        if (confirm != 0) {
                            return;
                        }
                        Cp.exec((String)"Layer.get(curDb(), \"%s\", \"%s\").deleteFromDb(true)", (Object[])new Object[]{l.getSubstrate().getName(), l.getName()});
                    } else {
                        Cp.exec((String)"Layer.get(curDb(), \"%s\", \"%s\").deleteFromDb(false)", (Object[])new Object[]{l.getSubstrate().getName(), l.getName()});
                    }
                    this.updateLayers();
                    if (idx >= mLayers.getSize()) {
                        --idx;
                    }
                    if (idx >= 0) {
                        mLstLayers.setSelectedIndex(idx);
                    }
                }
            });
            l.add((Component)this.mBtnDelete, (GridBagConstraints)btnCs);
            l.popNl();
            l.pushFillXRemainX();
            l.addFillX();
            JButton btnClose = new JButton("Close");
            l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
            l.pop();
            this.updateSubstrates(substrateToUse);
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, null);
            this.pack();
            UIUtil.center((Component)((Object)this));
        }

        protected void updateSubstrates(String substrateToUse) {
            this.mCboSubstrate.removeAllItems();
            for (Substrate s : this.mDb.getObjects(Substrate.class)) {
                if (substrateToUse != null && !substrateToUse.equals(s.getName())) continue;
                this.mCboSubstrate.addItem(s);
            }
            if (substrateToUse == null) {
                this.mCboSubstrate.addItem(null);
            }
            this.enableButtons();
        }

        protected void updateLayers() {
            this.mLayers.clear();
            Substrate s = this.getSubstrate();
            if (this.mDb == null || s == null) {
                return;
            }
            s.validateLayerOrder();
            for (Layer l : s.getLayers(Layer.TopFirstSort)) {
                this.mLayers.addLayer(l);
            }
        }

        protected Substrate getSubstrate() {
            return (Substrate)this.mCboSubstrate.getSelectedItem();
        }

        protected Layer getLayer() {
            return this.mLstLayers.getSelectedValue();
        }

        protected void moveSelected(boolean up) {
            Layer moveLayer = this.mLstLayers.getSelectedValue();
            int moveIndex = this.mLstLayers.getSelectedIndex();
            int moveOrder = moveLayer.getOrder();
            int otherIndex = moveIndex + (up ? -1 : 1);
            Layer otherLayer = this.mLayers.getElementAt(otherIndex);
            int otherOrder = otherLayer.getOrder();
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)this.mDb, (String)"Move Layer");){
                Cp.exec((String)"%s.setOrder(%d)", (Object[])new Object[]{CpHelper.getObjCmdStr(moveLayer), otherOrder});
                Cp.exec((String)"%s.setOrder(%d)", (Object[])new Object[]{CpHelper.getObjCmdStr(otherLayer), moveOrder});
            }
            this.updateLayers();
            int newIndex = this.mLayers.mLayers.indexOf(moveLayer);
            this.mLstLayers.setSelectedIndex(newIndex);
            this.mLstLayers.scrollRectToVisible(this.mLstLayers.getCellBounds(newIndex, newIndex));
            this.enableButtons();
        }

        protected void enableButtons() {
            int selIdx = this.mLstLayers.getSelectedIndex();
            this.mBtnEdit.setEnabled(selIdx >= 0);
            this.mBtnDelete.setEnabled(selIdx >= 0);
        }
    }
}

