/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.FilteringIterator;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.ProcessingIterator;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.dbui.render.SubstrateListRenderer;
import com.sigrity.acl.parsers.LEFDEFParser;
import com.sigrity.acl.parsers.TokenParser;
import com.sigrity.acl.ui.AButtonGroup;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.AList;
import com.sigrity.acl.ui.AListModel;
import com.sigrity.acl.ui.APatternHelpButton;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.lic.LSession;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.SubstrateTemplate;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;

public class LefDefUI
extends DbDialog {
    protected LefDefPanel mLefDefPanel;
    protected JButton mBtnOk = new JButton("Apply");

    public static Action getAction() {
        return new AbstractAction("Import LEF/DEF..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LefDefUI.showDialog();
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitApp.getCurDesign() != null;
            }
        };
    }

    public static void showDialog() {
        LefDefUI.showDialog(AApp.getApp().getMainWin());
    }

    public static void showDialog(Component owner) {
        LefDefUI.showDialog(owner, null);
    }

    public static void showDialog(Component owner, Substrate defaultSubstrate) {
        LefDefUI lefDefUI = new LefDefUI(OrbitApp.getCurDb(), owner);
        lefDefUI.mLefDefPanel.setSelectedSubstrate(defaultSubstrate);
        lefDefUI.setVisible(true);
    }

    public static boolean isLef(File f) {
        return AFileFilter.LEF.isExtFile(f) || AFileFilter.TLEF.isExtFile(f);
    }

    public static boolean isDef(File f) {
        if (f == null) {
            return false;
        }
        return AFileFilter.DEF.isExtFile(f) || AFileFilter.DEFGZ.isExtFile(f);
    }

    public static boolean isTechLef(File f) {
        if (f == null) {
            return false;
        }
        if (AFileFilter.LEF.isExtFile(f)) {
            String filename = f.getName().toLowerCase();
            return filename.endsWith("_sub.lef") || filename.contains("tech");
        }
        return AFileFilter.TLEF.isExtFile(f);
    }

    public LefDefUI(Db db, Component owner) {
        super(db, owner);
        this.setTitle("LEF/DEF Reader");
        GridBagManager l = new GridBagManager(this.getContentPane());
        this.mLefDefPanel = (LefDefPanel)l.addNl((Component)new LefDefPanel(), (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        l.pushFillX();
        l.addFillX();
        l.add((Component)this.mBtnOk, (GridBagConstraints)GridBagManager.RIGHT);
        this.mBtnOk.addActionListener(event -> this.mLefDefPanel.doOk());
        this.mBtnOk.setEnabled(false);
        JButton btnCancel = new JButton("Close");
        l.add((Component)btnCancel, (GridBagConstraints)GridBagManager.RIGHT);
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)this.mBtnOk);
        l.pop();
        this.pack();
        UIUtil.center((Component)((Object)this));
        this.setMinimumSize(this.getPreferredSize());
    }

    protected static class FileListItem
    extends AList.AListItem {
        protected File mFile;

        public FileListItem(File file) {
            super(file.getPath());
            this.mFile = file;
            this.setIsSelected(true);
        }

        public File getFile() {
            return this.mFile;
        }

        public boolean isLef() {
            return LefDefUI.isLef(this.mFile);
        }

        public boolean isDef() {
            return LefDefUI.isDef(this.mFile);
        }

        public boolean isTechLef() {
            return LefDefUI.isTechLef(this.mFile);
        }
    }

    protected class LefDefPanel
    extends JPanel {
        private static final String CreateNewSubstrate = "<Create new Substrate>";
        protected AListModel<FileListItem> mFiles;
        protected AList<FileListItem> mLstFiles;
        protected ToggleAllFiles mCbSelectDeselectAll;
        protected AButtonGroup mBgMessageLevel = new AButtonGroup();
        protected JRadioButton mNoMessages;
        protected JRadioButton mNormalMessages;
        protected JRadioButton mHyperMessages;
        protected JCheckBox mPreserveHierarchy;
        protected JCheckBox mUniquify;
        protected JCheckBox mReadNets;
        protected JCheckBox mReadWires;
        protected JCheckBox mReadSpecialNets;
        protected JCheckBox mSpecialReadWires;
        protected JCheckBox mReadBlocks;
        protected JCheckBox mReadCores;
        protected JCheckBox mReadEndCaps;
        protected JCheckBox mReadCovers;
        protected JCheckBox mReadRings;
        protected JCheckBox mReadObstacles;
        protected JCheckBox mUpdateExisting;
        protected JCheckBox mKeepEmptyPins;
        protected JCheckBox mCreateDefaultNetName;
        protected JCheckBox mSkipPins;
        protected JCheckBox mCbScale;
        protected JTextField mTxtScaleFactor;
        protected JProgressBar mProgressMeter;
        private transient TokenParser.LoadListener mListener;
        protected JComboBox<Substrate> mSubstrateList;
        protected transient Object mCreateSubstrateChoice;
        protected JLabel mSubstrateLabel;
        protected JLabel mCreateSubstrateLabel;
        protected JTextField mTxtCreateSubstrateName;
        protected JTextField mTxtIgnoreLayerPattern;
        protected transient Consumer<File> mIgnoreDef = null;
        protected transient DocumentListener mEnterName = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                LefDefPanel.this.enableControls();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LefDefPanel.this.enableControls();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                LefDefPanel.this.enableControls();
            }
        };
        protected transient ActionListener mControlsChanged = e -> this.enableControls();

        private void moveUpTechLef() {
            FileListItem item;
            int i;
            AListModel<FileListItem> newFiles = new AListModel<FileListItem>();
            HashSet<Integer> techLefs = new HashSet<Integer>();
            List<FileListItem> currentFiles = this.mFiles.getList();
            for (i = 0; i < currentFiles.size(); ++i) {
                item = currentFiles.get(i);
                if (!item.isTechLef()) continue;
                newFiles.addItem(newFiles.getSize(), item);
                techLefs.add(i);
            }
            for (i = 0; i < currentFiles.size(); ++i) {
                if (techLefs.contains(i)) continue;
                item = currentFiles.get(i);
                newFiles.addItem(item);
            }
            this.mFiles.setContents(newFiles.getList());
        }

        public LefDefPanel() {
            GridBagManager.GridBagConstraintsEx rbc = GridBagManager.LEFT_REMAINX.insets(GridBagManager.LEFT.insets.left, 0);
            GridBagManager l = new GridBagManager((Container)this);
            l.pushFill("Import Files");
            this.mFiles = new AListModel();
            this.mLstFiles = new AList<FileListItem>((ListModel<FileListItem>)this.mFiles);
            this.mLstFiles.setShowCheckBoxes(true);
            this.mLstFiles.addCheckListener(item -> this.mCbSelectDeselectAll.repaint());
            this.mLstFiles.setCellRenderer(new AList.SelectFileCellRenderer<FileListItem>(this.mLstFiles){

                @Override
                public Component getListCellRendererComponent(JList<? extends FileListItem> list, FileListItem value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    if (value instanceof FileListItem) {
                        FileListItem fli = value;
                        if (fli.isDef()) {
                            this.mLabel.setFont(this.getFont().deriveFont(1));
                        } else {
                            this.mLabel.setFont(this.getFont());
                        }
                        File f = fli.getFile();
                        this.mLabel.setText(String.format("<html>%s <font color='gray'>[%s]</font></html>", f.getName(), f.getAbsolutePath()));
                        this.mLabel.setToolTipText(f.getAbsolutePath());
                    }
                    return this;
                }
            });
            UIUtil.installPopupMenu(this.mLstFiles, (UIUtil.APopupMenuProvider)new FilesPopup());
            JScrollPane spFiles = new JScrollPane(this.mLstFiles);
            l.add((Component)spFiles, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            spFiles.setMinimumSize(new Dimension(200, 50));
            l.newline();
            JButton btnAddFiles = (JButton)l.add((Component)((JButton)UIUtil.makeFootButton((AbstractButton)new JButton("Add files..."))));
            btnAddFiles.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AFileChooser fc = new AFileChooser();
                    fc.addChoosableFileFilter((FileFilter)AFileFilter.DEF);
                    fc.addChoosableFileFilter((FileFilter)AFileFilter.DEFGZ);
                    fc.addChoosableFileFilter((FileFilter)AFileFilter.LEF);
                    fc.addChoosableFileFilter((FileFilter)AFileFilter.TLEF);
                    fc.setFileFilter((FileFilter)AFileFilter.LEFDEF_FAMILY);
                    fc.setMultiSelectionEnabled(true);
                    fc.setFileSelectionMode(2);
                    JPanel pnlOpts = new JPanel();
                    GridBagManager l = GridBagManager.layout((Container)pnlOpts);
                    l.addNl("For selected directories:", (GridBagConstraints)GridBagManager.LEFT.noInsets().insetLeft(4));
                    JCheckBox cbRecurse = (JCheckBox)l.add((Component)new JCheckBox("Include subdirectories"), (GridBagConstraints)GridBagManager.LEFT.noInsets().insetLeft(12));
                    l.addFillAll();
                    fc.setAccessory((JComponent)pnlOpts);
                    int fcResult = fc.showDialog(LefDefPanel.this.mLstFiles, "Add");
                    if (fcResult != 0) {
                        return;
                    }
                    LefDefPanel.this.mIgnoreDef = f -> {
                        LefDefPanel.this.mIgnoreDef = null;
                        String msg = String.format("Only one DEF file may be selected for import.\n\n'%s' is already selected. Additional DEF files are being ignored.", ((FileListItem)LefDefPanel.this.getSelectedDefs().next()).getFile().getPath());
                        JOptionPane.showMessageDialog(LefDefPanel.this.mLstFiles, msg, "DEF Warning", 2);
                    };
                    for (File f2 : fc.getSelectedFiles()) {
                        if (!f2.isFile()) continue;
                        LefDefPanel.this.addFile(f2);
                    }
                    for (File f2 : fc.getSelectedFiles()) {
                        if (!f2.isDirectory()) continue;
                        LefDefPanel.this.addDir(f2, cbRecurse.isSelected());
                    }
                    LefDefPanel.this.moveUpTechLef();
                    LefDefPanel.this.mIgnoreDef = null;
                    LefDefPanel.this.mCbSelectDeselectAll.repaint();
                }
            });
            l.addFillX();
            JButton btnRemoveUnsel = (JButton)UIUtil.makeFootButton((AbstractButton)new JButton("Remove Unselected"));
            btnRemoveUnsel.addActionListener(e -> {
                for (FileListItem i : AUtil.linkedList(this.mFiles.getList())) {
                    if (i.getIsSelected()) continue;
                    this.mFiles.removeItem(this.mFiles.indexOf(i));
                }
            });
            l.add((Component)btnRemoveUnsel);
            this.mCbSelectDeselectAll = (ToggleAllFiles)l.add((Component)new ToggleAllFiles());
            l.pop();
            l.push("Options", (GridBagConstraints)GridBagManager.TOPLEFT);
            l.pushRemainX();
            this.mSubstrateLabel = new JLabel("Substrate:");
            this.mSubstrateLabel.setToolTipText("<html>A new substrate can be created for each set of LEFs read. Normally, a set of LEFs requires a single <br>substrate. Therefore, if you do multiple imports (e.g., to choose files from different directories) it <br>may be desirable to use <bold>Create a new Substrate</bold> only for the first set of LEFs. On subsequent <br>reads for the same substrate, choose the appropriate substrate.<br><br>When reading a DEF file that does not reference any devices from LEF files (i.e., only a die outline), <br>an existing substrate can be selected.</html>");
            l.add((Component)this.mSubstrateLabel, (GridBagConstraints)GridBagManager.LEFT);
            this.mSubstrateList = new JComboBox();
            this.mSubstrateList.setRenderer(new SubstrateListRenderer(CreateNewSubstrate));
            l.add(this.mSubstrateList, (GridBagConstraints)GridBagManager.FILLX);
            l.newline();
            this.mCreateSubstrateLabel = new JLabel("Substrate name:");
            l.pushFillXRemainX();
            l.add((Component)this.mCreateSubstrateLabel, (GridBagConstraints)GridBagManager.LEFT.indent().insetTop(0));
            this.mCreateSubstrateLabel.setEnabled(false);
            this.mTxtCreateSubstrateName = (JTextField)l.add((Component)new JTextField(10), (GridBagConstraints)GridBagManager.FILLX_REMAINX.insetTop(0));
            this.mTxtCreateSubstrateName.setText("substrate");
            this.mTxtCreateSubstrateName.setEnabled(false);
            this.mTxtCreateSubstrateName.getDocument().addDocumentListener(this.mEnterName);
            l.pop();
            l.popNl();
            l.pushFill("DEF Components");
            this.mReadBlocks = new JCheckBox("Read Blocks");
            this.mReadBlocks.setSelected(true);
            l.addNl((Component)this.mReadBlocks, (GridBagConstraints)rbc);
            this.mReadBlocks.setToolTipText("DEF components of BLOCK will be read");
            this.mReadCores = new JCheckBox("Read Cores");
            this.mReadCores.setSelected(true);
            l.addNl((Component)this.mReadCores, (GridBagConstraints)rbc);
            this.mReadCores.setToolTipText("DEF components of CORE will be read");
            this.mReadEndCaps = new JCheckBox("Read End Caps");
            this.mReadEndCaps.setSelected(true);
            l.addNl((Component)this.mReadEndCaps, (GridBagConstraints)rbc);
            this.mReadEndCaps.setToolTipText("DEF components of ENDCAP will be read");
            this.mReadCovers = new JCheckBox("Read Covers and Bumps");
            this.mReadCovers.setSelected(true);
            l.addNl((Component)this.mReadCovers, (GridBagConstraints)rbc);
            this.mReadCovers.setToolTipText("DEF components of Cover will be read");
            this.mReadRings = new JCheckBox("Read Rings");
            this.mReadRings.setSelected(true);
            l.addNl((Component)this.mReadRings, (GridBagConstraints)rbc);
            this.mReadRings.setToolTipText("DEF components of Ring will be read");
            l.pop();
            l.push("DEF Nets/Wires", (GridBagConstraints)GridBagManager.FILLALL);
            this.mReadNets = new JCheckBox("Read Nets");
            this.mReadNets.setSelected(true);
            l.addNl((Component)this.mReadNets, (GridBagConstraints)rbc);
            this.mReadNets.setToolTipText("Read DEF NETS and apply to device pins");
            this.mReadNets.addActionListener(this.mControlsChanged);
            this.mReadWires = new JCheckBox("Read Wires");
            this.mReadWires.setSelected(true);
            l.addNl((Component)this.mReadWires, (GridBagConstraints)rbc);
            this.mReadWires.setToolTipText("Read wires defined in DEF NETS");
            this.mReadSpecialNets = new JCheckBox("Read Special Nets");
            this.mReadSpecialNets.setSelected(true);
            l.addNl((Component)this.mReadSpecialNets, (GridBagConstraints)rbc);
            this.mReadSpecialNets.setToolTipText("Read DEF SPECIALNETS and apply to device pins");
            this.mReadSpecialNets.addActionListener(this.mControlsChanged);
            this.mSpecialReadWires = new JCheckBox("Read Special Wires");
            this.mSpecialReadWires.setSelected(true);
            l.addNl((Component)this.mSpecialReadWires, (GridBagConstraints)rbc);
            this.mSpecialReadWires.setToolTipText("Read wires defined in DEF SPECIALNETS");
            l.addFillX();
            l.addFillY();
            l.popNl();
            this.mCreateDefaultNetName = new JCheckBox("Create default net names on Unused pins");
            this.mCreateDefaultNetName.setToolTipText("<html> A net will be created for every pin read.</html");
            this.mCreateDefaultNetName.setSelected(true);
            l.addNl((Component)this.mCreateDefaultNetName, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            this.mSkipPins = new JCheckBox("Ignore the PINS section of a .def file");
            this.mSkipPins.setToolTipText("<html> Skip the PINS section of a .def file <br> The PINS section if it exist usually contains information already extracted.</html");
            this.mSkipPins.setSelected(false);
            l.addNl((Component)this.mSkipPins, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            this.mKeepEmptyPins = new JCheckBox("Keep LEF MACRO PIN Without Shapes");
            this.mKeepEmptyPins.setToolTipText("<html> Some LEF MACRO PINs, especially when ignoring layers, will result in definitions <br>that have no shapes.</html");
            this.mKeepEmptyPins.setSelected(true);
            l.addNl((Component)this.mKeepEmptyPins, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            this.mUpdateExisting = new JCheckBox("Update existing templates");
            this.mUpdateExisting.setToolTipText("<html>During LEF read, update existing templates or ignore any macro where a template of the same name already exists</html>");
            l.addNl((Component)this.mUpdateExisting, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            l.push((GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
            this.mCbScale = (JCheckBox)l.add((Component)new JCheckBox("Process shrink amount:"));
            this.mTxtScaleFactor = (JTextField)l.add((Component)new JTextField(10));
            this.mTxtScaleFactor.setText("1.0");
            this.mTxtScaleFactor.setEnabled(false);
            this.mCbScale.addActionListener(e -> this.mTxtScaleFactor.setEnabled(this.mCbScale.isSelected()));
            l.popNl();
            l.pushFillX("Information Level");
            this.mNoMessages = new JRadioButton("Errors Only");
            this.mNoMessages.setToolTipText(String.format("%s", "No Informational Messages will be printed during read"));
            l.addNl((Component)this.mNoMessages, (GridBagConstraints)rbc);
            this.mNormalMessages = new JRadioButton("Normal");
            this.mNormalMessages.setToolTipText("A menagerie of messages chosen to help the casual user");
            l.addNl((Component)this.mNormalMessages, (GridBagConstraints)rbc);
            this.mHyperMessages = new JRadioButton("Exhaustive");
            this.mHyperMessages.setToolTipText("Every message possible");
            l.addNl((Component)this.mHyperMessages, (GridBagConstraints)rbc);
            this.mBgMessageLevel.add(this.mNoMessages);
            this.mBgMessageLevel.add(this.mNormalMessages);
            this.mBgMessageLevel.add(this.mHyperMessages);
            l.addFillX();
            l.addFillY();
            l.popNl();
            l.pushFillX("Preferences");
            l.add("Ignore Layer Pattern for .LEFs:");
            l.newline();
            this.mTxtIgnoreLayerPattern = new JTextField(18);
            this.mTxtIgnoreLayerPattern.setToolTipText("Any layer whose name matches this regular expression will be ignored on .lef reads. Useful for make reads faster");
            Settings userPrefs = Settings.getSettings((String)"UserPreferences");
            String ignoreLayerLefPattern = (String)userPrefs.getSetting("LefIgnoreLayerPattern", (Object)"VIA.*");
            this.mTxtIgnoreLayerPattern.setText(ignoreLayerLefPattern);
            l.add((Component)this.mTxtIgnoreLayerPattern, (GridBagConstraints)GridBagManager.FILLX);
            l.add((Component)new APatternHelpButton(), (GridBagConstraints)GridBagManager.LEFT);
            l.addFillX();
            l.popNl();
            l.popNl();
            this.mProgressMeter = new JProgressBar(0, 100);
            this.mProgressMeter.setStringPainted(true);
            l.add((Component)this.mProgressMeter, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            this.mNoMessages.setSelected(true);
            this.populateSubstrateList();
            this.enableControls();
            this.mSubstrateList.addActionListener(event -> this.enableControls());
        }

        public void addFile(File f) {
            if (LefDefUI.isDef(f) && this.getSelectedDefs().hasNext()) {
                if (this.mIgnoreDef != null) {
                    this.mIgnoreDef.accept(f);
                }
                return;
            }
            this.mFiles.addItem(new FileListItem(f));
        }

        public void addDir(File dir, boolean recurse) {
            for (File f : dir.listFiles()) {
                if (!f.isFile() || f.isHidden() || !LefDefUI.isLef(f) && !LefDefUI.isDef(f)) continue;
                this.addFile(f);
            }
            if (recurse) {
                for (File f : dir.listFiles()) {
                    if (!f.isDirectory() || f.isHidden()) continue;
                    this.addDir(f, recurse);
                }
            }
        }

        protected void populateSubstrateList() {
            Db db = LefDefUI.this.mDb;
            Object lastSelect = this.mSubstrateList.getSelectedItem();
            this.mSubstrateList.removeAllItems();
            this.mSubstrateList.addItem(null);
            LinkedList<SubstrateTemplate> sts = SubstrateTemplate.getSubstrateInstances(db, true, false, DeviceTemplate.Type.DIE);
            for (SubstrateTemplate st : sts) {
                this.mSubstrateList.addItem((Substrate)st.getFirst());
            }
            this.mSubstrateList.setSelectedItem(lastSelect);
        }

        public void setSelectedSubstrate(Substrate substrate) {
            this.mSubstrateList.setSelectedItem(substrate);
        }

        private boolean validateInput() {
            try {
                if (!this.mTxtIgnoreLayerPattern.getText().isEmpty()) {
                    AFieldValidator.validateRegex((JTextComponent)this.mTxtIgnoreLayerPattern);
                }
                if (this.mCbScale.isSelected()) {
                    AFieldValidator.validateDouble((JTextField)this.mTxtScaleFactor);
                }
            }
            catch (AFieldValidator.AFieldValidationException e) {
                return false;
            }
            return true;
        }

        private void savePreferences() {
            Settings userPrefs = Settings.getSettings((String)"UserPreferences");
            userPrefs.putSetting("LefIgnoreLayerPattern", (Object)this.mTxtIgnoreLayerPattern.getText());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doOk() {
            if (!this.validateInput()) {
                return;
            }
            this.savePreferences();
            Db db = LefDefUI.this.mDb;
            if (db == null) {
                JOptionPane.showMessageDialog(this, "There is no open design.", LefDefUI.this.getTitle(), 0);
                return;
            }
            if (!this.getSelectedFiles().hasNext()) {
                JOptionPane.showMessageDialog(this, "No files are selected to import.", LefDefUI.this.getTitle(), 0);
                return;
            }
            Substrate s = (Substrate)this.mSubstrateList.getSelectedItem();
            if (s != null && this.mCbScale.isSelected()) {
                String msg;
                int result;
                double newScale = AFieldValidator.getDouble((JTextField)this.mTxtScaleFactor, (double)1.0);
                double curScale = s.getScale();
                if (!Double.isNaN(curScale) && curScale != newScale && (result = JOptionPane.showConfirmDialog(this, msg = String.format("The selected substrate scale is %s which does not match the requested read scale %s.\nAre you sure you want to read the new data using the requested scale factor (%s)?", Double.toString(curScale), Double.toString(newScale), Double.toString(newScale)), "Warning", 2, 2)) != 0) {
                    return;
                }
            }
            Cp.exec((String)"unset(\"_ldpCtx\")", (Object[])new Object[0]);
            Cp.exec(() -> {
                LEFDEFParser.Context ldpCtx = LEFDEFParser.Context.create();
            }, (String)"_ldpCtx = com.sigrity.acl.parsers.LEFDEFParser.Context.create()", (Object[])new Object[0]);
            try {
                this.beginProgressMeter();
                boolean firstLef = true;
                boolean validFile = false;
                for (FileListItem lefFileItem : this.getSelectedLefs()) {
                    this.doLefRead(lefFileItem.getFile().getPath(), firstLef);
                    lefFileItem.setIsSelected(false);
                    firstLef = false;
                    validFile = true;
                }
                for (FileListItem defFileItem : this.getSelectedDefs()) {
                    this.doDefRead(defFileItem.getFile().getPath());
                    defFileItem.setIsSelected(false);
                    validFile = true;
                }
                this.endProgressMeter();
                OrbitIO.getApp().zoomFitCurrentView();
                this.getSelectedFiles().stream().forEach(f -> ALog.logWarn((String)"File: '%s' is selected but not read as it is neither a LEF nor a LEF.", (Object[])new Object[]{f.getAbsolutePath()}));
                if (!validFile) {
                    ALog.logInfo((String)"No valid Lef or Def file selected. Make sure that the files have the correct extensions (.lef/.tlef/.def) and also have proper read access.");
                }
            }
            finally {
                Cp.exec((String)"unset(\"_ldpCtx\")", (Object[])new Object[0]);
                this.mLstFiles.repaint();
                this.mCbSelectDeselectAll.repaint();
                this.populateSubstrateList();
                this.mSubstrateList.repaint();
            }
        }

        private void beginProgressMeter() {
            this.mListener = new TokenParser.LoadListener(){

                @Override
                public void stats(int percent, int kbps, boolean done, String fileName) {
                    if (done) {
                        percent = 100;
                    }
                    LefDefPanel.this.mProgressMeter.setValue(percent);
                    String s = percent + "% of " + fileName;
                    LefDefPanel.this.mProgressMeter.setString(s);
                    Dimension d = LefDefPanel.this.mProgressMeter.getSize();
                    LefDefPanel.this.mProgressMeter.paintImmediately(0, 0, d.width, d.height);
                }
            };
            TokenParser.addLoadListener(this.mListener);
        }

        private void endProgressMeter() {
            TokenParser.removeLoadListener(this.mListener);
        }

        private int getVerbosity() {
            int verbosity = 2;
            if (this.mNormalMessages.isSelected()) {
                verbosity = 1;
            }
            if (this.mHyperMessages.isSelected()) {
                verbosity = 0;
            }
            return verbosity;
        }

        private void doLefRead(String path, boolean first) {
            int verbosity = this.getVerbosity();
            boolean readObstacles = true;
            boolean readBlocks = true;
            boolean readCores = true;
            boolean readCovers = true;
            boolean readEndCaps = true;
            boolean readRings = true;
            Substrate substrateChoice = (Substrate)this.mSubstrateList.getSelectedItem();
            boolean createSubstrate = substrateChoice == null && first;
            Cp.exec((String)"unset(\"ldp\")", (Object[])new Object[0]);
            LEFDEFParser ldp = null;
            LEFDEFParser.Context _ldpCtx = null;
            Cp.exec(() -> {
                try {
                    LEFDEFParser lEFDEFParser = new LEFDEFParser(LefDefUI.this.mDb);
                }
                catch (LSession.NoLicenseException e) {
                    ALog.logError((Throwable)e);
                }
            }, (String)"com.sigrity.acl.parsers.LEFDEFParser ldp = new com.sigrity.acl.parsers.LEFDEFParser(curDb())", (Object[])new Object[0]);
            if (Cp.getValue((String)"_ldpCtx") != null) {
                Cp.exec(() -> ldp.setContext(_ldpCtx), (String)"ldp.setContext(_ldpCtx)", (Object[])new Object[0]);
            }
            if (this.mKeepEmptyPins.isSelected()) {
                Cp.exec(() -> ldp.setKeepEmptyPins(true), (String)"ldp.setKeepEmptyPins(true)", (Object[])new Object[0]);
            } else {
                Cp.exec(() -> ldp.setKeepEmptyPins(false), (String)"ldp.setKeepEmptyPins(false)", (Object[])new Object[0]);
            }
            if (this.mCreateDefaultNetName.isSelected()) {
                Cp.exec(() -> ldp.setCreateDefaultNetNamesOnPins(true), (String)"ldp.setCreateDefaultNetNamesOnPins(true)", (Object[])new Object[0]);
            } else {
                Cp.exec(() -> ldp.setCreateDefaultNetNamesOnPins(false), (String)"ldp.setCreateDefaultNetNamesOnPins(false)", (Object[])new Object[0]);
            }
            if (this.mUpdateExisting.isSelected()) {
                Cp.exec(() -> ldp.setIgnoreExistingTemplates(false), (String)"ldp.setIgnoreExistingTemplates(false)", (Object[])new Object[0]);
                Cp.exec(() -> ldp.setUpdateExistingTemplates(true), (String)"ldp.setUpdateExistingTemplates(true)", (Object[])new Object[0]);
            }
            if (createSubstrate) {
                Cp.exec(() -> ldp.setSubstrateName(this.mTxtCreateSubstrateName.getText()), (String)"ldp.setSubstrateName(\"%s\")", (Object[])new Object[]{this.mTxtCreateSubstrateName.getText()});
            } else if (substrateChoice == null) {
                Cp.exec(() -> ldp.setSubstrateName(this.mTxtCreateSubstrateName.getText()), (String)"ldp.setSubstrateName(\"%s\")", (Object[])new Object[]{this.mTxtCreateSubstrateName.getText()});
            } else {
                Cp.exec(() -> ldp.setSubstrateName(substrateChoice.getName()), (String)"ldp.setSubstrateName(\"%s\")", (Object[])new Object[]{substrateChoice.getName()});
            }
            if (this.mCbScale.isSelected()) {
                Cp.exec(() -> ldp.setScale(AFieldValidator.getDouble((JTextField)this.mTxtScaleFactor, (double)1.0)), (String)"ldp.setScale(%f)", (Object[])new Object[]{AFieldValidator.getDouble((JTextField)this.mTxtScaleFactor, (double)1.0)});
            }
            if (readObstacles) {
                Cp.exec(() -> ldp.setReadObstaclesOnLayer(".*"), (String)"ldp.setReadObstaclesOnLayer(\".*\")", (Object[])new Object[0]);
            }
            Cp.exec(() -> ldp.setVerbosity(verbosity), (String)"ldp.setVerbosity(%d)", (Object[])new Object[]{verbosity});
            Cp.exec(() -> ldp.setReadBlocks(readBlocks), (String)"ldp.setReadBlocks(%b)", (Object[])new Object[]{readBlocks});
            Cp.exec(() -> ldp.setReadCores(readCores), (String)"ldp.setReadCores(%b)", (Object[])new Object[]{readCores});
            Cp.exec(() -> ldp.setReadCovers(readCovers), (String)"ldp.setReadCovers(%b)", (Object[])new Object[]{readCovers});
            Cp.exec(() -> ldp.setReadEndCaps(readEndCaps), (String)"ldp.setReadEndCaps(%b)", (Object[])new Object[]{readEndCaps});
            Cp.exec(() -> ldp.setReadRings(readRings), (String)"ldp.setReadRings(%b)", (Object[])new Object[]{readRings});
            Cp.exec(() -> ldp.setCreateSubstrate(createSubstrate), (String)"ldp.setCreateSubstrate(%b)", (Object[])new Object[]{createSubstrate});
            Cp.exec(() -> ldp.parseLEF(path), (String)"ldp.parseLEF(%s);", (Object[])new Object[]{Cp.getFileAsArgument((String)path)});
            Cp.exec(() -> ldp.getSubstrateName(), (String)"String lastSub = ldp.getSubstrateName()", (Object[])new Object[0]);
            Cp.exec((String)"unset(\"ldp\")", (Object[])new Object[0]);
        }

        private void doDefRead(String path) {
            int verbosity = this.getVerbosity();
            boolean uniquify = false;
            boolean addUnusedPins = true;
            boolean readBlocks = this.mReadBlocks.isSelected();
            boolean readCores = this.mReadCores.isSelected();
            boolean readCovers = this.mReadCovers.isSelected();
            boolean readEndCaps = this.mReadEndCaps.isSelected();
            boolean readRings = this.mReadRings.isSelected();
            boolean readNets = this.mReadNets.isSelected();
            boolean readWires = this.mReadWires.isSelected();
            boolean readSpecialNets = this.mReadSpecialNets.isSelected();
            boolean readSpecialWires = this.mSpecialReadWires.isSelected();
            Substrate substrateChoice = (Substrate)this.mSubstrateList.getSelectedItem();
            LEFDEFParser ldp = (LEFDEFParser)Cp.getValue((String)"ldp");
            if (ldp == null) {
                Cp.exec(() -> {
                    try {
                        LEFDEFParser lEFDEFParser = new LEFDEFParser(LefDefUI.this.mDb);
                    }
                    catch (LSession.NoLicenseException e) {
                        ALog.logError((Throwable)e);
                    }
                }, (String)"ldp = new com.sigrity.acl.parsers.LEFDEFParser(curDb());", (Object[])new Object[0]);
                LEFDEFParser.Context ldpCtx = (LEFDEFParser.Context)Cp.getValue((String)"_ldpCtx");
                if (ldpCtx != null) {
                    Cp.exec(() -> ldp.setContext(ldpCtx), (String)"ldp.setContext(_ldpCtx);", (Object[])new Object[0]);
                }
            }
            if (substrateChoice != null) {
                Cp.exec(() -> ldp.setSubstrateName(substrateChoice.getName()), (String)"ldp.setSubstrateName(\"%s\")", (Object[])new Object[]{substrateChoice.getName()});
            } else {
                Cp.exec(() -> ldp.setSubstrateName(this.mTxtCreateSubstrateName.getText()), (String)("ldp.setSubstrateName(\"" + this.mTxtCreateSubstrateName.getText() + "\")"), (Object[])new Object[0]);
            }
            if (this.mCbScale.isSelected()) {
                Cp.exec(() -> ldp.setScale(AFieldValidator.getDouble((JTextField)this.mTxtScaleFactor, (double)1.0)), (String)"ldp.setScale(%f)", (Object[])new Object[]{AFieldValidator.getDouble((JTextField)this.mTxtScaleFactor, (double)1.0)});
            }
            if (this.mSkipPins.isSelected()) {
                Cp.exec(() -> ldp.skipPins(true), (String)"ldp.skipPins(true)", (Object[])new Object[0]);
            } else {
                Cp.exec(() -> ldp.skipPins(false), (String)"ldp.skipPins(false)", (Object[])new Object[0]);
            }
            Cp.exec(() -> ldp.setReadBlocks(readBlocks), (String)"ldp.setReadBlocks(%b)", (Object[])new Object[]{readBlocks});
            Cp.exec(() -> ldp.setReadCores(readCores), (String)"ldp.setReadCores(%b)", (Object[])new Object[]{readCores});
            Cp.exec(() -> ldp.setReadCovers(readCovers), (String)"ldp.setReadCovers(%b)", (Object[])new Object[]{readCovers});
            Cp.exec(() -> ldp.setReadEndCaps(readEndCaps), (String)"ldp.setReadEndCaps(%b)", (Object[])new Object[]{readEndCaps});
            Cp.exec(() -> ldp.setReadRings(readRings), (String)"ldp.setReadRings(%b)", (Object[])new Object[]{readRings});
            Cp.exec(() -> ldp.setReadNets(readNets), (String)"ldp.setReadNets(%b)", (Object[])new Object[]{readNets});
            Cp.exec(() -> ldp.setReadRegularWires(readWires), (String)"ldp.setReadRegularWires(%b)", (Object[])new Object[]{readWires});
            Cp.exec(() -> ldp.setReadSpecialNets(readSpecialNets), (String)"ldp.setReadSpecialNets(%b)", (Object[])new Object[]{readSpecialNets});
            Cp.exec(() -> ldp.setReadSpecialWires(readSpecialWires), (String)"ldp.setReadSpecialWires(%b)", (Object[])new Object[]{readSpecialWires});
            Cp.exec(() -> ldp.setVerbosity(verbosity), (String)"ldp.setVerbosity(%d)", (Object[])new Object[]{verbosity});
            Cp.exec(() -> ldp.setUniqueify(uniquify), (String)"ldp.setUniqueify(%b)", (Object[])new Object[]{uniquify});
            Cp.exec(() -> ldp.setJustMacroPattern(""), (String)"ldp.setJustMacroPattern(\"\")", (Object[])new Object[0]);
            Cp.exec(() -> ldp.setAddUnusedPins(addUnusedPins), (String)"ldp.setAddUnusedPins(%b)", (Object[])new Object[]{addUnusedPins});
            Cp.exec(() -> ldp.parseDEF(path), (String)"ldp.parseDEF(%s);", (Object[])new Object[]{Cp.getFileAsArgument((String)path)});
            Cp.exec((String)"unset(\"ldp\");", (Object[])new Object[0]);
            this.populateSubstrateList();
        }

        protected void enableControls() {
            this.mReadNets.setEnabled(true);
            this.mReadWires.setEnabled(true);
            this.mReadSpecialNets.setEnabled(true);
            this.mSpecialReadWires.setEnabled(true);
            this.mReadCores.setEnabled(true);
            this.mReadBlocks.setEnabled(true);
            this.mReadCovers.setEnabled(true);
            this.mReadEndCaps.setEnabled(true);
            this.mReadRings.setEnabled(true);
            if (!this.mReadNets.isSelected()) {
                this.mReadWires.setEnabled(false);
                this.mReadWires.setSelected(false);
            }
            if (!this.mReadSpecialNets.isSelected()) {
                this.mSpecialReadWires.setEnabled(false);
                this.mSpecialReadWires.setSelected(false);
            }
            Substrate choseSubstrate = (Substrate)this.mSubstrateList.getSelectedItem();
            boolean enableOk = true;
            boolean enableSubstrateName = false;
            this.mSubstrateLabel.setForeground(Color.BLACK);
            this.mCreateSubstrateLabel.setForeground(Color.BLACK);
            if (choseSubstrate == null) {
                enableSubstrateName = true;
            }
            this.mCreateSubstrateLabel.setEnabled(enableSubstrateName);
            this.mTxtCreateSubstrateName.setEnabled(enableSubstrateName);
            if (this.mTxtCreateSubstrateName.isEnabled() && this.mTxtCreateSubstrateName.getText().trim().isEmpty()) {
                this.mCreateSubstrateLabel.setForeground(Color.RED);
                enableOk = false;
            }
            LefDefUI.this.mBtnOk.setEnabled(enableOk);
        }

        public IterableIterator<File> getSelectedFiles() {
            return new ProcessingIterator<FileListItem, File>(this.mFiles.getList().iterator()){

                protected File process(FileListItem i) {
                    return i.getIsSelected() ? i.getFile() : null;
                }
            };
        }

        public IterableIterator<FileListItem> getSelectedLefs() {
            return new FilteringIterator<FileListItem>(this.mFiles.getList().iterator()){

                protected boolean include(FileListItem i) {
                    return i.getIsSelected() && i.isLef();
                }
            };
        }

        public IterableIterator<FileListItem> getSelectedDefs() {
            return new FilteringIterator<FileListItem>(this.mFiles.getList().iterator()){

                protected boolean include(FileListItem i) {
                    return i.getIsSelected() && i.isDef();
                }
            };
        }

        public boolean allFilesChecked() {
            if (this.mFiles.getSize() == 0) {
                return false;
            }
            for (FileListItem i : this.mFiles.getList()) {
                if (i.getIsSelected()) continue;
                return false;
            }
            return true;
        }

        protected class FilesPopup
        implements UIUtil.APopupMenuProvider {
            protected FilesPopup() {
            }

            public JPopupMenu getMenu(Component c, int x, int y) {
                int row = LefDefPanel.this.mLstFiles.locationToIndex(new Point(x, y));
                JPopupMenu menu = new JPopupMenu();
                if (row >= 0) {
                    if (!LefDefPanel.this.mLstFiles.isSelectedIndex(row)) {
                        LefDefPanel.this.mLstFiles.addSelectionInterval(row, row);
                    }
                    menu.add(new AbstractAction("Move To Top"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            for (FileListItem o : LefDefPanel.this.mLstFiles.getSelectedValuesList()) {
                                int idx = LefDefPanel.this.mFiles.indexOf(o);
                                if (idx < 0) continue;
                                LefDefPanel.this.mFiles.removeItem(idx);
                                LefDefPanel.this.mFiles.addItem(0, o);
                            }
                        }
                    });
                    menu.add(new AbstractAction("Move Up"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            for (FileListItem o : LefDefPanel.this.mLstFiles.getSelectedValuesList()) {
                                int idx = LefDefPanel.this.mFiles.indexOf(o);
                                if (idx <= 0) continue;
                                LefDefPanel.this.mFiles.removeItem(idx);
                                LefDefPanel.this.mFiles.addItem(idx - 1, o);
                            }
                        }
                    });
                    menu.add(new AbstractAction("Move Down"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            for (FileListItem o : LefDefPanel.this.mLstFiles.getSelectedValuesList()) {
                                int idx = LefDefPanel.this.mFiles.indexOf(o);
                                if (idx >= LefDefPanel.this.mFiles.getSize() - 1) continue;
                                LefDefPanel.this.mFiles.removeItem(idx);
                                LefDefPanel.this.mFiles.addItem(idx + 1, o);
                            }
                        }
                    });
                    menu.add(new AbstractAction("Remove"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            for (FileListItem o : LefDefPanel.this.mLstFiles.getSelectedValuesList()) {
                                int idx = LefDefPanel.this.mFiles.indexOf(o);
                                if (idx < 0) continue;
                                LefDefPanel.this.mFiles.removeItem(idx);
                            }
                        }
                    });
                }
                if (LefDefPanel.this.mFiles.getSize() > 0) {
                    menu.add(new AbstractAction("Remove All"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            for (FileListItem i : AUtil.linkedList(LefDefPanel.this.mFiles.getList())) {
                                LefDefPanel.this.mFiles.removeItem(LefDefPanel.this.mFiles.indexOf(i));
                            }
                        }
                    });
                }
                OrbitIO.getApp().getWorkspace().beautify(menu);
                return menu.getComponentCount() == 0 ? null : menu;
            }
        }

        protected class ToggleAllFiles
        extends JCheckBox
        implements ActionListener {
            protected ToggleAllFiles() {
                this.addActionListener(this);
                this.setText("Select/deselect all");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean pick = !LefDefPanel.this.allFilesChecked();
                for (FileListItem i : LefDefPanel.this.mFiles.getList()) {
                    i.setIsSelected(pick);
                }
                LefDefPanel.this.mLstFiles.repaint();
            }

            @Override
            public void paint(Graphics g) {
                this.setSelected(LefDefPanel.this.allFilesChecked());
                super.paint(g);
            }
        }
    }
}

