/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.dbui.render.LayerListRenderer;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AOctagon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPort;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.factory.ContactPadFactory;
import com.sigrity.orbit.ui.wb_route.PadTemplateComboBox;
import com.sigrity.tools.dbexplorer.DBEResources;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class MountingMgmtDlg
extends ADialog {
    protected DevicePath devicePath;
    protected Layer toLayer;
    protected Layer fromLayer;
    protected Db db;
    protected JRadioButton allPins;
    protected JRadioButton justSelectedPins;
    protected JLabel saveMessageLabel;
    protected JLabel doMessageLabel;
    protected JButton createContactsButton;
    protected JButton removeContactsButton;
    protected JButton saveValuesButton;
    protected JButton closeButton;
    protected JComboBox<Layer> fromLayerList;
    protected JComboBox<Layer> toLayerList;
    protected JComboBox<String> geomList;
    protected PadTemplateComboBox mComboPadTemplate;
    protected JTextField geomSize;
    protected JLabel sizeLabel;
    protected JRadioButton byGeom;
    protected JRadioButton byPadstack;
    protected final String SelectedPinsText = "Just Selected Pins";
    protected final String AllPinsText = "All Candidate Pins";
    protected boolean selectionChanging = false;
    protected PinSelectionListener mSelectionListener;
    protected final String MATCH_BUMP = "Match Bump";
    protected ActionListener constructionMannerChanged = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MountingMgmtDlg.this.byGeom.isSelected()) {
                MountingMgmtDlg.this.toLayerList.setEnabled(true);
                MountingMgmtDlg.this.fromLayerList.setEnabled(true);
                MountingMgmtDlg.this.mComboPadTemplate.setEnabled(false);
                MountingMgmtDlg.this.geomList.setEnabled(true);
            } else {
                MountingMgmtDlg.this.toLayerList.setEnabled(false);
                MountingMgmtDlg.this.fromLayerList.setEnabled(false);
                MountingMgmtDlg.this.mComboPadTemplate.setEnabled(true);
                MountingMgmtDlg.this.geomList.setEnabled(false);
            }
        }
    };
    protected ActionListener saveAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Unit unit = Design.getUnit((Db)OrbitIO.getCurDb());
            Cp.exec((String)"Device _d = DevicePath.fromEscapedString(OrbitIO.getCurDb(), \"%s\").getLast()", (Object[])new Object[]{MountingMgmtDlg.this.devicePath.escapedString()});
            Cp.exec((String)"Substrate _sFrom = _d.getSubstrate()", (Object[])new Object[0]);
            Cp.exec((String)"Substrate _sTo = _d.getParent().getSubstrate()", (Object[])new Object[0]);
            Cp.exec((String)"Layer _lFrom = _sFrom.getLayer(\"%s\")", (Object[])new Object[]{((Layer)MountingMgmtDlg.this.fromLayerList.getSelectedItem()).getName()});
            Cp.exec((String)"Layer _lTo = _sTo.getLayer(\"%s\")", (Object[])new Object[]{((Layer)MountingMgmtDlg.this.toLayerList.getSelectedItem()).getName()});
            Cp.exec((String)"_d.setMountLayer(_lTo)", (Object[])new Object[0]);
            Cp.exec((String)"_d.setMyMountLayer(_lFrom)", (Object[])new Object[0]);
            String s = MountingMgmtDlg.this.geomSize.getText();
            long iSize = 0L;
            if (!MountingMgmtDlg.this.geomList.getSelectedItem().equals("Match Bump")) {
                if (!AFieldValidator.isValidDouble((String)s)) {
                    ALog.logWarn((String)(s + " is not a valid number"));
                    return;
                }
                iSize = unit.fromUser(Double.parseDouble(s));
            }
            if (MountingMgmtDlg.this.geomList.getSelectedItem().equals("Square")) {
                Cp.exec((String)"com.sigrity.acl.geom.ARect _g = new com.sigrity.acl.geom.ARect(%dL, %dL, %dL, %dL)", (Object[])new Object[]{-iSize / 2L, -iSize / 2L, iSize / 2L, iSize / 2L});
                Cp.exec((String)"_d.setContactGeom(_g)", (Object[])new Object[0]);
                Cp.exec((String)"unset(\"_g\")", (Object[])new Object[0]);
            } else if (MountingMgmtDlg.this.geomList.getSelectedItem().equals("Circle")) {
                Cp.exec((String)"com.sigrity.acl.geom.ACircle _g = new com.sigrity.acl.geom.ACircle(0, 0, %dL)", (Object[])new Object[]{iSize / 2L});
                Cp.exec((String)"_d.setContactGeom(_g)", (Object[])new Object[0]);
                Cp.exec((String)"unset(\"_g\")", (Object[])new Object[0]);
            } else if (MountingMgmtDlg.this.geomList.getSelectedItem().equals("Octagon")) {
                Cp.exec((String)"com.sigrity.acl.geom.AOctagon _g = new com.sigrity.acl.geom.AOctagon(%dL)", (Object[])new Object[]{iSize / 2L});
                Cp.exec((String)"_d.setContactGeom(_g)", (Object[])new Object[0]);
                Cp.exec((String)"unset(\"_g\")", (Object[])new Object[0]);
            } else {
                Cp.exec((String)"_d.setContactGeom(null)", (Object[])new Object[0]);
            }
            Cp.exec((String)"unset(\"_d\")", (Object[])new Object[0]);
        }
    };
    protected ActionListener createAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Unit unit = Design.getUnit((Db)OrbitIO.getCurDb());
            Cp.exec((String)"com.sigrity.orbit.factory.ContactPadFactory _factory = new com.sigrity.orbit.factory.ContactPadFactory()", (Object[])new Object[0]);
            Cp.exec((String)"_factory.setToPath(\"%s\")", (Object[])new Object[]{MountingMgmtDlg.this.devicePath.getParent().escapedString()});
            Cp.exec((String)"_factory.setFromPath(\"%s\")", (Object[])new Object[]{MountingMgmtDlg.this.devicePath.escapedString()});
            Cp.exec((String)"_factory.setFromLayer(\"%s\")", (Object[])new Object[]{((Layer)MountingMgmtDlg.this.fromLayerList.getSelectedItem()).getName()});
            Cp.exec((String)"_factory.setToLayer(\"%s\")", (Object[])new Object[]{((Layer)MountingMgmtDlg.this.toLayerList.getSelectedItem()).getName()});
            if (MountingMgmtDlg.this.byGeom.isSelected()) {
                String s = MountingMgmtDlg.this.geomSize.getText();
                long iSize = 0L;
                if (!MountingMgmtDlg.this.geomList.getSelectedItem().equals("Match Bump")) {
                    if (!AFieldValidator.isValidDouble((String)s)) {
                        ALog.logWarn((String)(s + " is not a valid number"));
                        return;
                    }
                    iSize = unit.fromUser(Double.parseDouble(s));
                }
                if (MountingMgmtDlg.this.geomList.getSelectedItem().equals("Square")) {
                    Cp.exec((String)"com.sigrity.acl.geom.ARect _g = new com.sigrity.acl.geom.ARect(%dL, %dL, %dL, %dL)", (Object[])new Object[]{-iSize / 2L, -iSize / 2L, iSize / 2L, iSize / 2L});
                    Cp.exec((String)"_factory.setContactGeom(_g)", (Object[])new Object[0]);
                    Cp.exec((String)"unset(\"_g\")", (Object[])new Object[0]);
                } else if (MountingMgmtDlg.this.geomList.getSelectedItem().equals("Circle")) {
                    Cp.exec((String)"com.sigrity.acl.geom.ACircle _g = new com.sigrity.acl.geom.ACircle(0, 0, %dL)", (Object[])new Object[]{iSize / 2L});
                    Cp.exec((String)"_factory.setContactGeom(_g)", (Object[])new Object[0]);
                    Cp.exec((String)"unset(\"_g\")", (Object[])new Object[0]);
                } else if (MountingMgmtDlg.this.geomList.getSelectedItem().equals("Octagon")) {
                    Cp.exec((String)"com.sigrity.acl.geom.AOctagon _g = new com.sigrity.acl.geom.AOctagon(%dL)", (Object[])new Object[]{iSize / 2L});
                    Cp.exec((String)"_factory.setContactGeom(_g)", (Object[])new Object[0]);
                    Cp.exec((String)"unset(\"_g\")", (Object[])new Object[0]);
                }
            } else {
                PadTemplate pt = (PadTemplate)MountingMgmtDlg.this.mComboPadTemplate.getSelectedItem();
                Cp.exec((String)"_factory.setPadTemplateToUse(\"%s\");", (Object[])new Object[]{pt.getName()});
            }
            Cp.exec((String)"_factory.makePadsForBumps(%b)", (Object[])new Object[]{MountingMgmtDlg.this.justSelectedPins.isSelected()});
            Cp.exec((String)"unset(\"_factory\")", (Object[])new Object[0]);
            OrbitIO.getApp().refreshCurrentView(false);
        }
    };
    protected ActionListener removeAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec((String)"com.sigrity.orbit.factory.ContactPadFactory _factory = new com.sigrity.orbit.factory.ContactPadFactory()", (Object[])new Object[0]);
            Cp.exec((String)"_factory.setToPath(\"%s\")", (Object[])new Object[]{MountingMgmtDlg.this.devicePath.getParent().escapedString()});
            Cp.exec((String)"_factory.setFromPath(\"%s\")", (Object[])new Object[]{MountingMgmtDlg.this.devicePath.escapedString()});
            Cp.exec((String)"_factory.setFromLayer(\"%s\")", (Object[])new Object[]{((Layer)MountingMgmtDlg.this.fromLayerList.getSelectedItem()).getName()});
            Cp.exec((String)"_factory.setToLayer(\"%s\")", (Object[])new Object[]{((Layer)MountingMgmtDlg.this.toLayerList.getSelectedItem()).getName()});
            Cp.exec((String)"_factory.removeCurrentContactDevice()", (Object[])new Object[0]);
            Cp.exec((String)"_factory.removeInstantiatedContactPads(%b)", (Object[])new Object[]{MountingMgmtDlg.this.justSelectedPins.isSelected()});
            Cp.exec((String)"unset(\"_factory\")", (Object[])new Object[0]);
            OrbitIO.getApp().refreshCurrentView(false);
        }
    };
    protected MouseListener mMouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger()) {
                MountingMgmtDlg.this.popupMenu(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                MountingMgmtDlg.this.popupMenu(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                MountingMgmtDlg.this.popupMenu(e);
            }
        }
    };

    public DevicePath getDevicePath() {
        return this.devicePath;
    }

    public void setDevicePath(DevicePath devicePath) {
        this.devicePath = devicePath;
    }

    public Layer getParentLayer() {
        return this.toLayer;
    }

    public void setParentLayer(Layer parentLayer) {
        this.toLayer = parentLayer;
    }

    protected MountingMgmtDlg(DevicePath dp) {
        super(OrbitIO.getMainWindow());
        this.setModal(true);
        this.setTitle("Contact Parameters");
        this.setDevicePath(dp);
        this.setDefaultCloseOperation(2);
        GridBagManager l = new GridBagManager((Container)((Object)this));
        this.db = OrbitIO.getCurDb();
        l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.FILLALL);
        this.fromLayerList = new JComboBox();
        JLabel label = new JLabel("Layers of" + dp.toString());
        label.setIcon(DbExplorerPanel.getIconForDevice(dp.getLast()));
        l.add((Component)label, (GridBagConstraints)GridBagManager.LEFT);
        l.add(this.fromLayerList, (GridBagConstraints)GridBagManager.LEFT);
        JLabel l2 = new JLabel();
        if (dp.getLast().getFlipped()) {
            l2.setText("Chip Down");
            l2.setIcon(DBEResources.ICON_ARROW_DN);
            l2.setToolTipText("This device is flipped on its parent and the layer list will be reversed from the stackup");
        } else {
            l2.setText("Chip Up");
            l2.setIcon(DBEResources.ICON_ARROW_UP);
            l2.setToolTipText("This device is not flipped on its parent and the layer list will be stackup order");
        }
        l.add((Component)l2);
        l.newline();
        this.toLayerList = new JComboBox();
        JLabel label1 = new JLabel("Layers of " + dp.getParent().toString());
        label1.setIcon(DbExplorerPanel.getIconForDevice(dp.getParent().getLast()));
        l.add((Component)label1, (GridBagConstraints)GridBagManager.LEFT);
        l.add(this.toLayerList, (GridBagConstraints)GridBagManager.LEFT);
        l.newline();
        LayerListRenderer r = new LayerListRenderer();
        this.fromLayerList.setRenderer(r);
        this.fromLayerList.addMouseListener(this.mMouseListener);
        this.fromLayerList.addActionListener(new MyListSelectionListener());
        this.toLayerList.setRenderer(r);
        this.toLayerList.addMouseListener(this.mMouseListener);
        this.toLayerList.addActionListener(new MyListSelectionListener());
        l.pop();
        l.newline();
        JPanel whatPinsPanel = new JPanel();
        Border etch = BorderFactory.createEtchedBorder();
        whatPinsPanel.setBorder(BorderFactory.createTitledBorder(etch, "Create Contact Pads For"));
        l.push((Container)whatPinsPanel, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
        ButtonGroup optGroup = new ButtonGroup();
        this.allPins = new JRadioButton("All Candidate Pins");
        this.justSelectedPins = new JRadioButton("Just Selected Pins");
        l.add((Component)this.allPins);
        l.add((Component)this.justSelectedPins);
        optGroup.add(this.allPins);
        optGroup.add(this.justSelectedPins);
        this.allPins.setSelected(true);
        l.popNl();
        JPanel howToCreatePanel = new JPanel();
        etch = BorderFactory.createEtchedBorder();
        howToCreatePanel.setBorder(BorderFactory.createTitledBorder(etch, "Construction Style"));
        l.push((Container)howToCreatePanel, (GridBagConstraints)GridBagManager.FILLX);
        ButtonGroup constructionGroup = new ButtonGroup();
        this.byGeom = new JRadioButton("By Geometry");
        this.byPadstack = new JRadioButton("By Padstack");
        this.byGeom.addActionListener(this.constructionMannerChanged);
        this.byPadstack.addActionListener(this.constructionMannerChanged);
        l.add((Component)this.byGeom);
        l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.FILLX);
        this.geomList = new JComboBox();
        l.add(this.geomList, (GridBagConstraints)GridBagManager.LEFT);
        this.geomList.addItem("Square");
        this.geomList.addItem("Circle");
        this.geomList.addItem("Octagon");
        this.geomList.addItem("Match Bump");
        this.geomList.addActionListener(new MyGeomListener());
        this.geomList.setRenderer(new GeomRenderer());
        this.sizeLabel = new JLabel("Size:");
        l.add((Component)this.sizeLabel);
        this.geomSize = new JTextField(10);
        this.geomSize.setMinimumSize(this.geomSize.getPreferredSize());
        l.add((Component)this.geomSize, (GridBagConstraints)GridBagManager.FILLX);
        l.pop();
        l.newline();
        l.add((Component)this.byPadstack);
        this.mComboPadTemplate = (PadTemplateComboBox)l.add((Component)new PadTemplateComboBox(this.devicePath.getParent()), (GridBagConstraints)GridBagManager.FILLX);
        constructionGroup.add(this.byGeom);
        constructionGroup.add(this.byPadstack);
        this.byGeom.setSelected(true);
        l.pop();
        l.newline();
        JPanel b = new JPanel();
        l.push((Container)b, (GridBagConstraints)GridBagManager.RIGHT);
        l.add("", (GridBagConstraints)GridBagManager.RIGHT);
        this.saveValuesButton = new JButton("Save Values");
        l.add((Component)this.saveValuesButton, (GridBagConstraints)GridBagManager.RIGHT);
        this.saveValuesButton.addActionListener(this.saveAction);
        l.pop();
        l.newline();
        JPanel btnPanel = new JPanel();
        l.push((Container)btnPanel, (GridBagConstraints)GridBagManager.RIGHT);
        this.doMessageLabel = new JLabel("");
        l.add((Component)this.doMessageLabel, (GridBagConstraints)GridBagManager.LEFT);
        Font btnFont = this.doMessageLabel.getFont();
        this.doMessageLabel.setFont(btnFont.deriveFont((float)btnFont.getSize() - 4.0f));
        this.removeContactsButton = new JButton("Remove Contacts");
        this.removeContactsButton.addActionListener(this.removeAction);
        l.add((Component)this.removeContactsButton, (GridBagConstraints)GridBagManager.RIGHT);
        this.createContactsButton = new JButton("Create Contacts");
        l.add((Component)this.createContactsButton, (GridBagConstraints)GridBagManager.RIGHT);
        JButton btnClose = new JButton("Close");
        l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
        this.createContactsButton.addActionListener(this.createAction);
        this.mSelectionListener = new PinSelectionListener();
        Selection s = Selection.getCurrentSelectionForDb((Db)this.db);
        s.addSelectionListener((Selection.SelectionListener)this.mSelectionListener);
        this.updateCounts();
        l.pop();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, (JButton)this.saveValuesButton);
        this.pack();
        UIUtil.center((Component)((Object)this));
        this.updateLayerList();
        Dimension d = this.getPreferredSize();
        this.setPreferredSize(d);
        this.setMinimumSize(d);
        this.setVisible(true);
    }

    public void removeNotify() {
        super.removeNotify();
        Selection s = Selection.getCurrentSelectionForDb((Db)this.db);
        if (s != null && this.mSelectionListener != null) {
            s.removeSelectionListener((Selection.SelectionListener)this.mSelectionListener);
        }
    }

    protected void updateStatus() {
    }

    protected void popupMenu(MouseEvent e) {
    }

    public static boolean mountable(DevicePath dp) {
        if (dp == null) {
            return false;
        }
        DevicePath parentPath = dp.getParent();
        if (parentPath.isEmpty() && parentPath.getIsAbsolute()) {
            return false;
        }
        Substrate parentSubstrate = parentPath.getSubstrate();
        return parentSubstrate != null;
    }

    protected void updateCounts() {
        APair<LinkedList<HierPort>, LinkedList<HierPort>> ports = ContactPadFactory.getPotentialContactPins(this.devicePath);
        int all = ((LinkedList)ports.first).size();
        int selected = ((LinkedList)ports.second).size();
        this.allPins.setText("All Candidate Pins (" + all + ")");
        this.justSelectedPins.setText("Just Selected Pins (" + selected + ")");
    }

    protected void updateLayerList() {
        DevicePath dp = this.devicePath;
        Substrate s = dp.getSubstrate();
        LinkedList<Layer> list = new LinkedList<Layer>();
        for (Layer layer : s.getLayers(Layer.OrderComparator)) {
            list.add(layer);
        }
        if (!dp.getLast().getFlipped()) {
            Collections.reverse(list);
        }
        for (Layer layer : list) {
            this.fromLayerList.addItem(layer);
        }
        int fromLayerSize = list.size();
        list.clear();
        s = dp.getParent().getSubstrate();
        for (Layer l : s.getLayers(Layer.OrderComparator)) {
            list.add(0, l);
        }
        for (Layer l : list) {
            this.toLayerList.addItem(l);
        }
        if (this.devicePath.getLast().getMyMountLayer() != null) {
            this.fromLayerList.setSelectedItem(this.devicePath.getLast().getMyMountLayer());
        } else {
            this.fromLayerList.setSelectedIndex(fromLayerSize - 1);
        }
        if (this.devicePath.getLast().getMountLayer() != null) {
            this.toLayerList.setSelectedItem(this.devicePath.getLast().getMountLayer());
        }
        Unit unit = Design.getUnit((Db)OrbitIO.getCurDb());
        AGeom g = this.devicePath.getLast().getContactGeom();
        if (g == null) {
            this.geomList.setSelectedItem("Match Bump");
            this.geomSize.setText("");
        } else if (g instanceof ARect) {
            this.geomList.setSelectedItem("Square");
            this.geomSize.setText(unit.toUserStr(((ARect)g).width()));
        } else if (g instanceof AOctagon) {
            this.geomList.setSelectedItem("Octagon");
            this.geomSize.setText(unit.toUserStr(((AOctagon)g).radius() * 2L));
        } else if (g instanceof ACircle) {
            this.geomList.setSelectedItem("Circle");
            this.geomSize.setText(unit.toUserStr(((ACircle)g).getR() * 2L));
        }
    }

    public static MountingMgmtDlg show(DevicePath dp) {
        if (!MountingMgmtDlg.mountable(dp)) {
            ALog.logInfo((String)"Device Path '%s' cannot be mounted.", (Object[])new Object[]{dp});
            return null;
        }
        return new MountingMgmtDlg(dp);
    }

    static class GeomRenderer
    extends DefaultListCellRenderer {
        GeomRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            this.setText((String)value);
            return c;
        }
    }

    public static interface PopupMenuHandler {
        public void handlePopup(int var1, int var2);
    }

    class MyGeomListener
    implements ActionListener {
        MyGeomListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (MountingMgmtDlg.this.geomList.getSelectedItem().equals("Match Bump")) {
                MountingMgmtDlg.this.geomSize.setEnabled(false);
                MountingMgmtDlg.this.sizeLabel.setEnabled(false);
                MountingMgmtDlg.this.sizeLabel.setText("");
            } else {
                MountingMgmtDlg.this.geomSize.setEnabled(true);
                MountingMgmtDlg.this.sizeLabel.setEnabled(true);
                if (MountingMgmtDlg.this.geomList.getSelectedItem().equals("Square")) {
                    MountingMgmtDlg.this.sizeLabel.setText("Size");
                } else {
                    MountingMgmtDlg.this.sizeLabel.setText("Diameter");
                }
            }
        }
    }

    class MyListSelectionListener
    implements ActionListener {
        MyListSelectionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
        }
    }

    class PinSelectionListener
    implements Selection.SelectionListener {
        PinSelectionListener() {
        }

        public void selectionChanged(HashMap<DbClass, Selection.SelSet> set) {
            if (MountingMgmtDlg.this.selectionChanging) {
                return;
            }
            MountingMgmtDlg.this.selectionChanging = true;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MountingMgmtDlg.this.updateCounts();
                    MountingMgmtDlg.this.selectionChanging = false;
                }
            });
        }
    }
}

