/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AStream;
import com.sigrity.acl.ATransformUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.cmd.ShapeCommands;
import com.sigrity.orbit.ui.DesignDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTextField;

public class MoveEdgeUI {
    protected MoveEdgeUI() {
    }

    public static MoveEdgeDlg createDlg(Window owner, Db db, ShapeCommands.HierGeom<?> hierGeom, int[] afterVert, ShapeCommands.NeighborPoints snapPts, ShapeCommands.SnapAngle snapAngle) {
        return new MoveEdgeDlg(owner, db, hierGeom, afterVert, snapPts, snapAngle);
    }

    public static class MoveEdgeDlg
    extends DesignDialog {
        protected JTextField mOffsetX;
        protected JTextField mOffsetY;
        protected JButton mBtnApply;
        protected JButton mBtnClose;
        protected DbHistory.DbTransaction mTransaction;

        public MoveEdgeDlg(Window owner, Db db, final ShapeCommands.HierGeom<?> hierGeom, final int[] verts, final ShapeCommands.NeighborPoints snapPts, final ShapeCommands.SnapAngle snapAngle) {
            super(db, owner);
            if (hierGeom == null) {
                return;
            }
            final DevicePath devPath = hierGeom.getPath();
            final AffineTransform hierX = hierGeom.getPathTransform();
            AGeom geom = hierGeom.getGeom();
            if (geom instanceof ACircle) {
                ALog.logInfo((String)"Not supporting circle editing parametrically yet");
                return;
            }
            if (geom instanceof ARect) {
                geom = geom.toPoly();
            }
            if (!(geom instanceof APolygon)) {
                return;
            }
            APolygon poly = (APolygon)geom;
            if (verts[0] < 0 || verts[0] > poly.getPointCount() - 1) {
                ALog.logError((String)"Attempt to move edge of %s with invalid vertex index %d.", (Object[])new Object[]{hierGeom.getGeom(), verts[0]});
                return;
            }
            Design design = Design.getDesign((Db)db);
            if (design == null) {
                return;
            }
            this.setTitle("Move Edge");
            GridBagManager l = new GridBagManager(this.getContentPane());
            l.newline();
            l.push("", (GridBagConstraints)GridBagManager.CENTER);
            l.newline();
            l.addNl("Offset by (microns):");
            l.add("X:");
            this.mOffsetX = (JTextField)l.addNl((Component)new JTextField("0", 10));
            this.mOffsetX.setToolTipText("X-Offset");
            this.mOffsetX.setEditable(true);
            l.add("Y:");
            this.mOffsetY = (JTextField)l.addNl((Component)new JTextField("0", 10));
            this.mOffsetY.setToolTipText("Y-Offset");
            this.mOffsetY.setEditable(true);
            l.popNl();
            l.push("", (GridBagConstraints)GridBagManager.CENTER);
            this.mBtnApply = (JButton)l.add((Component)new JButton("Apply"));
            this.mBtnApply.setEnabled(true);
            this.mBtnClose = (JButton)l.add((Component)new JButton("Close"));
            this.mBtnApply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Unit unit = this.getUnitDist();
                    long offsetX = unit.fromUserString(mOffsetX.getText());
                    long offsetY = unit.fromUserString(mOffsetY.getText());
                    APoint2D[] grabPtsWorld = (APoint2D[])ShapeCommands.getEditPoints(hierGeom.getGeom()).map(pt -> pt.transform(hierX)).toArray(APoint2D[]::new);
                    APoint2D[] editPtsWorld = (APoint2D[])Arrays.stream(verts).mapToObj(idx -> grabPtsWorld[idx]).toArray(APoint2D[]::new);
                    APoint2D xlate = new APoint2D(offsetX, offsetY);
                    Optional<APair<Integer, APoint2D>> newPt = ShapeCommands.move(editPtsWorld, xlate, snapPts, snapAngle);
                    Stream<APoint2D> devRelPts = Arrays.stream(editPtsWorld).map(pt -> this.getDeviceRelativePt(devPath, (APoint2D)pt));
                    try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)this.getDb(), (String)"Move Edge");){
                        AStream.zip(Arrays.stream(verts).boxed(), devRelPts).forEach(idxPt -> Cp.exec((String)"ShapeCommands.moveEditPoint(iseShape, %d, %dL, %dL)", (Object[])new Object[]{idxPt.first, ((APoint2D)idxPt.second).getX(), ((APoint2D)idxPt.second).getY()}));
                        newPt.ifPresent(idxPt -> {
                            int idx = (Integer)idxPt.first == 0 ? verts[0] : verts[1] + 1;
                            APoint2D pt = this.getDeviceRelativePt(devPath, (APoint2D)idxPt.second);
                            Cp.exec((String)"ShapeCommands.insertVertex(iseShape, %d, %dL, %dL)", (Object[])new Object[]{idx, pt.getX(), pt.getY()});
                        });
                    }
                    OrbitIO.getApp().refreshCurrentView(false);
                }
            });
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)this.mBtnClose, (JButton)this.mBtnApply);
            this.pack();
            this.setVisible(true);
            this.setMinimumSize(this.getPreferredSize());
            UIUtil.center((Component)((Object)this));
            this.mTransaction = DbHistory.newDbTransaction((Db)this.mDb, (String)"Move Edge");
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    mTransaction.close();
                }
            });
        }

        public APoint2D getDeviceRelativePt(DevicePath dp, APoint2D worldPt) {
            if (dp == null) {
                return worldPt;
            }
            return worldPt.transform(ATransformUtil.inverse((AffineTransform)dp.getTransform()));
        }
    }
}

