/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AColor;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AStream;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.FilteringIterator;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.ADocumentAdapter;
import com.sigrity.acl.ui.AFloatWindow;
import com.sigrity.acl.ui.AListSearcher;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.NetFilters;
import com.sigrity.orbit.ObjectActionRegistry;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.cmd.NetCmd;
import com.sigrity.orbit.ui.NetMgmtPanel;
import com.sigrity.orbit.ui.NetUI;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import com.sigrity.orbit.ui.core.OrbitHotkey;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import com.sigrity.tools.dbexplorer.DbObjectTransferable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.TransferHandler;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Position;

public class NetListPanel
extends JPanel
implements Comparable<NetListPanel> {
    protected NetFinder mFinder = null;
    protected JList<Net> mList;
    protected Color mFilteredColor;
    protected Color mIconShadow = new AColor(this.getBackground()).withAlpha(160);
    protected DbClass.DbObjectListener mNetListener = new DbClass.DbObjectAdapter(){

        public boolean removingObject(DbClass.ObjectRemove e) {
            Net n = (Net)e.getDbObject();
            if (n.getDeviceTemplate() != NetListPanel.this.getDeviceTemplate()) {
                return true;
            }
            NetListPanel.this.getNetlistModel().removeNet(n);
            return true;
        }

        public void changedObject(DbClass.ObjectChange e) {
            Net n = (Net)e.getDbObject();
            if (n.getDeviceTemplate() != NetListPanel.this.getDeviceTemplate()) {
                return;
            }
            int idx = NetListPanel.this.getNetlistModel().getIndexOf(n);
            if (idx < 0) {
                return;
            }
            Rectangle bounds = NetListPanel.this.mList.getCellBounds(idx, idx);
            NetListPanel.this.mList.repaint(bounds);
        }

        public void addedObject(DbClass.ObjectAdd e) {
            Net n = (Net)e.getDbObject();
            if (n.getDeviceTemplate() != NetListPanel.this.getDeviceTemplate()) {
                return;
            }
            if (NetListPanel.this.getNetlistModel().include(n)) {
                NetListPanel.this.getNetlistModel().addNet(n);
            }
        }
    };
    protected DbClass.DbObjectListener mNetMapListener = new DbClass.DbObjectAdapter(){

        public boolean removingObject(DbClass.ObjectRemove e) {
            this.repaintIfRelated((DbClass.DbObjectEvent)e);
            return true;
        }

        public void changedObject(DbClass.ObjectChange e) {
            this.repaintIfRelated((DbClass.DbObjectEvent)e);
        }

        public void addedObject(DbClass.ObjectAdd e) {
            this.repaintIfRelated((DbClass.DbObjectEvent)e);
        }

        protected void repaintIfRelated(DbClass.DbObjectEvent e) {
            Net childNet;
            DeviceTemplate childDevT;
            DeviceTemplate parentDevT;
            NetMap nm = (NetMap)e.getDbObject();
            Net parentNet = nm.getParentNet();
            DeviceTemplate deviceTemplate = parentDevT = parentNet == null ? null : parentNet.getDeviceTemplate();
            if (parentDevT == NetListPanel.this.getDeviceTemplate()) {
                NetListPanel.this.repaint();
            }
            DeviceTemplate deviceTemplate2 = childDevT = (childNet = nm.getChildNet()) == null ? null : childNet.getDeviceTemplate();
            if (childDevT == NetListPanel.this.getDeviceTemplate()) {
                NetListPanel.this.repaint();
            }
        }
    };
    protected MouseListener mContextMenuAdapter = new UIUtil.AAbstractPopupMenuAdapter(){
        protected MouseEvent mMaybeShowEvent = null;

        protected void maybeShowPopup(MouseEvent e) {
            this.mMaybeShowEvent = e;
            super.maybeShowPopup(e);
            this.mMaybeShowEvent = null;
        }

        public void showMenu(Component component, int x, int y) {
            Net clickedNet;
            NetListModel nlm = NetListPanel.this.getNetlistModel();
            JPopupMenu menu = new JPopupMenu();
            menu.add(NetListPanel.this.mFindNet);
            menu.add(new JSeparator());
            ButtonGroup bgShow = new ButtonGroup();
            JRadioButtonMenuItem miShowAll = new JRadioButtonMenuItem(new ActionShowAllNets());
            JRadioButtonMenuItem miShowMapped = new JRadioButtonMenuItem(new ActionShowMappedNets());
            JRadioButtonMenuItem miShowUnmapped = new JRadioButtonMenuItem(new ActionShowUnmappedNets());
            bgShow.add(miShowAll);
            bgShow.add(miShowMapped);
            bgShow.add(miShowUnmapped);
            for (Object b2 : AUtil.getIterable(bgShow.getElements())) {
                menu.add((Component)b2);
            }
            JMenu menuFilter = new JMenu("Filter Nets");
            menu.add(menuFilter);
            for (final DeviceTemplate.NetFilter nf : OrbitIO.getOrbitIO().getNetFilters()) {
                AbstractAction a2 = new AbstractAction(nf.getName()){
                    {
                        super(arg0);
                        this.putValue("ShortDescription", nf.getDescription());
                        if (NetFilters.equals((DeviceTemplate.NetFilter)NetListPanel.this.getFilter(), (DeviceTemplate.NetFilter)nf)) {
                            this.putValue("SwingSelectedKey", true);
                        }
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        NetListPanel.this.setFilter(nf);
                    }
                };
                JCheckBoxMenuItem mi = new JCheckBoxMenuItem(a2);
                mi.setToolTipText(nf.getDescription());
                menuFilter.add(mi);
            }
            int clickedIndex = NetListPanel.this.mList.locationToIndex(new Point(x, y));
            if (clickedIndex >= 0 && !NetListPanel.this.mList.isSelectedIndex(clickedIndex)) {
                if (this.mMaybeShowEvent != null && this.mMaybeShowEvent.isControlDown()) {
                    NetListPanel.this.mList.addSelectionInterval(clickedIndex, clickedIndex);
                } else if (this.mMaybeShowEvent != null && this.mMaybeShowEvent.isShiftDown()) {
                    NetListPanel.this.mList.addSelectionInterval(NetListPanel.this.mList.getLeadSelectionIndex(), clickedIndex);
                } else {
                    NetListPanel.this.mList.setSelectedIndex(clickedIndex);
                }
            }
            List<Net> selection = NetListPanel.this.mList.getSelectedValuesList();
            FilteringIterator<Net> selNotDel = new FilteringIterator<Net>(selection.iterator()){

                protected boolean include(Net n) {
                    return n.getDb() != null;
                }
            };
            LinkedList selNets = AUtil.linkedList((Iterator)selNotDel);
            int selNetCount = selNets.size();
            LinkedList<AbstractAction> clickedNetItems = new LinkedList<AbstractAction>();
            Net net = clickedNet = clickedIndex >= 0 ? nlm.getElementAt(clickedIndex) : null;
            if (clickedNet != null && clickedNet.getDb() != null) {
                ObjectActionRegistry oar;
                if (nlm.isParentList()) {
                    if (NetMap.getChildNets((Net)clickedNet).hasNext()) {
                        clickedNetItems.add(new ShowOnlyMappedChildDevices(clickedNet));
                        clickedNetItems.add(new UnmapChildrenAction(clickedNet));
                    }
                } else {
                    Device childDevice = NetListPanel.this.getDevice();
                    NetMap netMap = NetMap.getParentNetMap((Device)childDevice, (Net)clickedNet);
                    if (netMap != null) {
                        clickedNetItems.add(new UnmapParentAction(netMap));
                    }
                }
                LinkedList<Action> generalNetActions = new LinkedList<Action>();
                DeleteNetAction actionDelNet = new DeleteNetAction(clickedNet);
                generalNetActions.add(actionDelNet);
                OrbitIO oio = OrbitIO.getOrbitIO();
                OrbitGuiWS gws = oio == null ? null : oio.getWorkspace();
                ObjectActionRegistry objectActionRegistry = oar = gws == null ? null : gws.getObjectActionRegistry();
                if (oar != null) {
                    if (nlm.isParentList()) {
                        for (Action a3 : oar.getActions(clickedNet)) {
                            generalNetActions.add(a3);
                        }
                    } else {
                        for (Action a4 : oar.getActions(HierInst.create((DevicePath)new DevicePath(NetListPanel.this.getDevice()), (DbObject)clickedNet))) {
                            generalNetActions.add(a4);
                        }
                    }
                }
                Collections.sort(generalNetActions, (a, b) -> AUtil.compare((Comparable)((Object)("" + a.getValue("Name"))), (Object)("" + b.getValue("Name"))));
                clickedNetItems.addAll(generalNetActions);
            }
            if (menu.getComponentCount() > 0) {
                menu.add(new JSeparator());
            }
            menu.add(new CreateNetAction(NetListPanel.this.getDeviceTemplate()));
            LinkedList<AbstractAction> selNetsActions = new LinkedList<AbstractAction>();
            if (selection.size() > 1) {
                selNetsActions.add(new DeleteSelectedNetsAction(String.format("Delete Selected Nets (%d)", selNetCount), selNets));
                if (nlm.isParentList()) {
                    selNetsActions.add(new UnmapChildNetsAction(selNets));
                } else {
                    selNetsActions.add(new UnmapParentNetsAction(selNets));
                    NetListPanel.this.getMapToParentAction(NetListPanel.this).ifPresent(a -> selNetsActions.add((AbstractAction)a));
                }
            }
            if (!selNetsActions.isEmpty()) {
                if (!clickedNetItems.isEmpty()) {
                    JMenu clickedNetMenu = new JMenu(clickedNet.getName());
                    clickedNetItems.forEach(a -> clickedNetMenu.add(ObjectActionRegistry.getJMenuItem(a)));
                    menu.add(clickedNetMenu);
                }
                if (selNets.size() > 1) {
                    JMenu selNetsMenu = new JMenu(String.format("Selected Nets (%d)", selNetCount));
                    selNetsActions.forEach(a -> selNetsMenu.add(ObjectActionRegistry.getJMenuItem(a)));
                    menu.add(selNetsMenu);
                }
            } else if (!clickedNetItems.isEmpty()) {
                menu.add(new JSeparator());
                clickedNetItems.forEach(a -> menu.add(ObjectActionRegistry.getJMenuItem(a)));
            }
            menu.add(new NetUI.ActionBulkCreateChildNet(NetListPanel.this.getDeviceTemplate()));
            if (OrbitIO.getGuiWorkspace() != null) {
                OrbitIO.getGuiWorkspace().beautify(menu);
            }
            menu.show(component, x, y);
        }
    };
    protected Action mFindNet = new AbstractAction("Find", OrbitIcons.SRCH){

        @Override
        public void actionPerformed(ActionEvent e) {
            NetListPanel.this.mFinder.setVisible(true);
            NetListPanel.this.mFinder.requestFocus();
        }
    };
    protected MouseAdapter mMouseListener = new MouseAdapter(){
        protected MouseEvent mPressEvent = null;

        @Override
        public void mousePressed(MouseEvent e) {
            int idx = NetListPanel.this.mList.locationToIndex(e.getPoint());
            if (idx == -1) {
                return;
            }
            NetListPanel.this.mList.requestFocus();
            this.mPressEvent = e;
            e.consume();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.mPressEvent == null) {
                return;
            }
            e.consume();
            int dx = Math.abs(e.getX() - this.mPressEvent.getX());
            int dy = Math.abs(e.getY() - this.mPressEvent.getY());
            if (dx > 5 || dy > 5) {
                JComponent c = (JComponent)e.getSource();
                TransferHandler handler = c.getTransferHandler();
                handler.exportAsDrag(c, this.mPressEvent, 2);
                this.mPressEvent = null;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.mPressEvent = null;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                int index = NetListPanel.this.mList.locationToIndex(e.getPoint());
                if (index < 0) {
                    return;
                }
                NetListModel nlm = NetListPanel.this.getNetlistModel();
                Net net = nlm.getElementAt(index);
                if (net.getDb() == null) {
                    return;
                }
                NetMgmtPanel nmp = (NetMgmtPanel)UIUtil.getAncestorOfType((Component)NetListPanel.this, NetMgmtPanel.class);
                if (nmp != null) {
                    nmp.setActivedNetMassage(nlm.mDevice, net);
                    nmp.mActiveNet = net;
                    nmp.mActiveDev = nlm.mDevice;
                    nmp.mActiveContactPins = null;
                    nmp.revalidate();
                    nmp.repaint();
                }
            }
        }
    };
    protected ListSelectionListener mSelectionListener = e -> {};
    protected TransferHandler mTransferHandler = new TransferHandler(){
        protected DbObjectTransferable.NetListTransferable mCurrentDragItem = null;

        @Override
        public int getSourceActions(JComponent c) {
            return 0x40000003;
        }

        @Override
        public void exportAsDrag(JComponent comp, InputEvent e, int action) {
            List<Net> nets;
            super.exportAsDrag(comp, e, action);
            NetListPanel nlSrc = (NetListPanel)UIUtil.getAncestorOfType((Component)comp, NetListPanel.class);
            NetMgmtPanel nmp = (NetMgmtPanel)UIUtil.getAncestorOfType((Component)nlSrc, NetMgmtPanel.class);
            Device deviceParent = nmp.getDevice();
            if (nlSrc.getDevice() == deviceParent) {
                if (!(e instanceof MouseEvent)) {
                    return;
                }
                MouseEvent me = (MouseEvent)e;
                int index = NetListPanel.this.mList.locationToIndex(me.getPoint());
                if (index < 0) {
                    return;
                }
                NetListPanel.this.mList.setSelectedIndex(index);
                nets = NetListPanel.this.mList.getSelectedValuesList();
            } else {
                nets = NetListPanel.this.mList.getSelectedValuesList();
            }
            this.mCurrentDragItem = new DbObjectTransferable.NetListTransferable(nets, NetListPanel.this);
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            super.exportDone(source, data, action);
            this.mCurrentDragItem = null;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            return this.mCurrentDragItem;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            DbObjectTransferable.NetListTransferable.UIData data;
            Transferable transferable = support.getTransferable();
            if (!transferable.isDataFlavorSupported(DbObjectTransferable.NetListTransferable.NetListFlavor)) {
                return false;
            }
            try {
                data = (DbObjectTransferable.NetListTransferable.UIData)((Object)transferable.getTransferData(DbObjectTransferable.NetListTransferable.NetListFlavor));
            }
            catch (Exception e) {
                ALog.logError((Throwable)e, (String)"Error getting transfer data.", (Object[])new Object[0]);
                return false;
            }
            NetListPanel sourcePanel = (NetListPanel)data.getSource();
            NetListPanel target = (NetListPanel)UIUtil.getAncestorOfType((Component)support.getComponent(), NetListPanel.class);
            if (target == null || target == data.getSource()) {
                return false;
            }
            NetMgmtPanel nmp = (NetMgmtPanel)UIUtil.getAncestorOfType((Component)NetListPanel.this, NetMgmtPanel.class);
            Device mainDevice = nmp.getDevice();
            JList.DropLocation dropLoc = (JList.DropLocation)support.getDropLocation();
            int dropIndex = dropLoc.getIndex();
            if (support.getDropAction() == 2) {
                support.setDropAction(0x40000000);
            }
            support.setShowDropLocation(true);
            if (target.getDevice() == mainDevice && sourcePanel.getDevice() != mainDevice && support.getUserDropAction() == 1) {
                support.setShowDropLocation(false);
                support.setDropAction(1);
            }
            if (dropIndex < 0) {
                if (target.getDevice() == mainDevice && sourcePanel.getDevice() != mainDevice) {
                    support.setDropAction(1);
                    return true;
                }
                return false;
            }
            if (target.getDevice() != mainDevice && sourcePanel.getDevice() != mainDevice) {
                return false;
            }
            if (support.getDropAction() == 0x40000000) {
                Net netTarget;
                Net net = netTarget = dropIndex >= 0 ? target.getNetlistModel().getElementAt(dropIndex) : null;
                if (netTarget != null && netTarget.isUnused()) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            NetMgmtPanel nmp;
            Device deviceParent;
            Device deviceTarget;
            Net netTarget;
            DbObjectTransferable.NetListTransferable.UIData data;
            if (!support.getTransferable().isDataFlavorSupported(DbObjectTransferable.NetListTransferable.NetListFlavor)) {
                return false;
            }
            try {
                data = (DbObjectTransferable.NetListTransferable.UIData)((Object)support.getTransferable().getTransferData(DbObjectTransferable.NetListTransferable.NetListFlavor));
            }
            catch (Exception e) {
                ALog.logError((Throwable)e, (String)"Error getting transferred data.", (Object[])new Object[0]);
                return false;
            }
            List<Net> netsSource = data.getNets();
            NetListPanel nlSource = (NetListPanel)data.getSource();
            Device deviceSource = nlSource.getDevice();
            NetListPanel nlTarget = (NetListPanel)UIUtil.getAncestorOfType((Component)support.getComponent(), NetListPanel.class);
            JList.DropLocation dropLoc = (JList.DropLocation)support.getDropLocation();
            int dropIdx = dropLoc.getIndex();
            Net net = netTarget = dropIdx >= 0 ? nlTarget.getNetlistModel().getElementAt(dropIdx) : null;
            if (netTarget != null && netTarget.isUnused()) {
                netTarget = null;
            }
            if ((deviceTarget = nlTarget.getDevice()) == (deviceParent = (nmp = (NetMgmtPanel)UIUtil.getAncestorOfType((Component)nlTarget, NetMgmtPanel.class)).getDevice())) {
                if (support.getDropAction() == 1) {
                    netTarget = null;
                }
                if (netTarget == null) {
                    String netName = netsSource.get(0).getName();
                    if ((netName = NetListPanel.this.queryUserForNetName(deviceTarget, netName)) == null) {
                        return false;
                    }
                    Substrate substrate = deviceTarget == null ? null : deviceTarget.getSubstrate();
                    String substrateName = substrate == null ? "null" : String.format("\"%s\"", substrate.getName());
                    netTarget = (Net)Cp.exec((String)"Net.create(curDb(), \"%s\", \"%s\", %s)", (Object[])new Object[]{nlTarget.getNetlistModel().mDeviceTemplate.getName(), netName, substrateName});
                    if (netTarget == null) {
                        return false;
                    }
                    nlTarget.getNetlistModel().addNet(netTarget);
                }
                boolean mapped = true;
                for (Net netSource : netsSource) {
                    if (NetCmd.recordMapNet((Device)deviceSource, (Net)netSource, (Net)netTarget)) continue;
                    mapped = false;
                }
                if (!mapped) {
                    return false;
                }
            } else if (deviceSource == deviceParent) {
                if (netsSource.size() != 1) {
                    ALog.logError((String)"Must map from a single parent net.");
                    return false;
                }
                if (!NetCmd.recordMapNet((Device)deviceTarget, (Net)netTarget, (Net)netsSource.get(0))) {
                    return false;
                }
            } else {
                NetUI.NetDlg dlg = (NetUI.NetDlg)((Object)UIUtil.getAncestorOfType((Component)NetListPanel.this, NetUI.NetDlg.class));
                if (dlg != null) {
                    dlg.setStatus("Direct mapping of nets between child devices is not currently supported.");
                    return false;
                }
            }
            StringBuilder netDesc = new StringBuilder(netsSource.size() == 1 ? "net" : "nets");
            for (int i = 0; i < netsSource.size(); ++i) {
                if (i == 0) {
                    netDesc.append(String.format(" '%s'", netsSource.get(i).getName()));
                    continue;
                }
                netDesc.append(String.format(", '%s'", netsSource.get(i).getName()));
            }
            ALog.logInfo((String)"Mapped '%s' %s to '%s' net '%s'.", (Object[])new Object[]{deviceSource == null ? "<Design>" : deviceSource.getName(), netDesc, deviceTarget == null ? "<Design>" : deviceTarget.getName(), netTarget == null ? "[invalid]" : netTarget.getName()});
            nlTarget.repaint();
            nlSource.repaint();
            return true;
        }
    };

    public NetListPanel(NetListModel dataModel) {
        final JScrollPane sp = new JScrollPane(20, 30){

            @Override
            protected JViewport createViewport() {
                return new JViewport(){
                    {
                        this.setOpaque(false);
                        this.setBackground(new Color(0, 0, 0, 0));
                    }

                    @Override
                    protected void paintComponent(Graphics g) {
                        super.paintComponent(g);
                        if (this.getView() != NetListPanel.this.mList) {
                            return;
                        }
                        Include include = NetListPanel.this.getNetlistModel().getInclude();
                        if (include != Include.ALL) {
                            Graphics2D g2 = (Graphics2D)g;
                            Color oldColor = g2.getColor();
                            g2.setColor(NetListPanel.this.mFilteredColor);
                            Rectangle r = this.getBounds();
                            int max = Math.max(r.width, r.height) * 2;
                            for (int x = 0; x <= max; x += 8) {
                                g2.drawLine(x, 0, 0, x);
                            }
                            g2.setColor(oldColor);
                        }
                    }
                };
            }
        };
        this.mList = new JList<Net>((ListModel)dataModel){

            protected Rectangle getFilterIconBounds(JViewport vp, Icon icon) {
                int x = vp.getWidth() - this.getX() - icon.getIconWidth() - 1;
                int y = vp.getHeight() - this.getY() - icon.getIconHeight() - 1;
                return new Rectangle(x, y, icon.getIconWidth() + 2, icon.getIconHeight() + 2);
            }

            @Override
            public int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
                ListModel model = this.getModel();
                int modelSize = model.getSize();
                if (startIndex < 0 || startIndex >= modelSize || prefix == null) {
                    return -1;
                }
                int dir = bias == Position.Bias.Forward ? 1 : -1;
                int index = startIndex;
                prefix = prefix.toUpperCase();
                do {
                    Net net;
                    String text;
                    if (!(text = (net = (Net)model.getElementAt(index)).getName().toUpperCase()).startsWith(prefix)) continue;
                    return index;
                } while ((index = (index + dir + modelSize) % modelSize) != startIndex);
                return -1;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Include include = NetListPanel.this.getNetlistModel().getInclude();
                if (include != Include.ALL) {
                    JViewport vp = sp.getViewport();
                    Icon icon = include == Include.MAPPED ? OrbitIcons.NETMAP : OrbitIcons.NETMAP_NO;
                    Rectangle r = this.getFilterIconBounds(vp, icon);
                    Color oldColor = g.getColor();
                    g.setColor(NetListPanel.this.mIconShadow);
                    g.fillRect(r.x - 1, r.y - 1, r.width + 2, r.height + 2);
                    g.setColor(oldColor);
                    icon.paintIcon(vp, g, r.x, r.y);
                }
            }

            public String getNetToolTipText(Net net) {
                StringBuilder toolTipText = new StringBuilder("Pins: ");
                int count = 0;
                for (PinTemplate dtp : net.getPins()) {
                    if (count > 0) {
                        toolTipText.append("<br>");
                    }
                    String portName = dtp.getName();
                    toolTipText.append(portName);
                    if (++count < 24) continue;
                    toolTipText.append("<br>...");
                    break;
                }
                return String.format("<html>%s</html>", toolTipText);
            }

            @Override
            public String getToolTipText(MouseEvent event) {
                ListModel model = this.getModel();
                int index = NetListPanel.this.mList.locationToIndex(event.getPoint());
                if (index < 0 || index >= model.getSize()) {
                    return null;
                }
                Net net = (Net)model.getElementAt(index);
                return this.getNetToolTipText(net);
            }
        };
        sp.setViewportView(this.mList);
        this.mList.setDragEnabled(true);
        this.mList.addMouseListener(this.mMouseListener);
        this.mList.addMouseMotionListener(this.mMouseListener);
        this.mList.addMouseListener(this.mContextMenuAdapter);
        this.mList.addListSelectionListener(this.mSelectionListener);
        this.mList.setTransferHandler(this.mTransferHandler);
        this.mList.setOpaque(false);
        this.mList.setBackground(new Color(0, 0, 0, 0));
        this.mFilteredColor = this.mList.getSelectionBackground();
        this.setInclude(Include.ALL);
        String ACTION_FIND = "Find";
        this.mList.getActionMap().put("Find", this.mFindNet);
        this.mList.getInputMap().put(OrbitHotkey.getKeyStroke("UI Search"), "Find");
        GridBagManager l = GridBagManager.layout((Container)this);
        this.mFinder = (NetFinder)l.addNl((Component)new NetFinder(), (GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
        this.mFinder.setVisible(false);
        l.add((Component)sp, (GridBagConstraints)GridBagManager.FILLALL_REMAINX.noInsets());
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (!this.getNetlistModel().mNets.isEmpty()) {
            this.setMinimumSize(this.getPreferredSize());
        } else {
            this.setMinimumSize(new Dimension(50, 0));
        }
        this.setNetListenersEnabled(true);
    }

    @Override
    public void removeNotify() {
        this.setNetListenersEnabled(false);
        super.removeNotify();
    }

    protected void setNetListenersEnabled(boolean enable) {
        Db db;
        DbClass.DbObjectEventType[] events = new DbClass.DbObjectEventType[]{DbClass.DbObjectEventType.ADDED, DbClass.DbObjectEventType.CHANGED, DbClass.DbObjectEventType.REMOVING};
        DeviceTemplate devT = this.getDeviceTemplate();
        Db db2 = db = devT == null ? null : devT.getDb();
        if (db != null) {
            DbClass dbcNet = db.getDbClass(Net.class);
            DbClass dbcNetMap = db.getDbClass(NetMap.class);
            if (enable) {
                dbcNet.addObjectListener(this.mNetListener, events);
                dbcNetMap.addObjectListener(this.mNetMapListener, events);
            } else {
                if (dbcNet != null) {
                    dbcNet.removeObjectListener(this.mNetListener, events);
                }
                if (dbcNetMap != null) {
                    dbcNetMap.removeObjectListener(this.mNetMapListener, events);
                }
            }
        }
    }

    public NetListModel getNetlistModel() {
        return (NetListModel)this.mList.getModel();
    }

    @Override
    public int compareTo(NetListPanel o) {
        return this.getNetlistModel().compareTo(o.getNetlistModel());
    }

    public void setCellRenderer(ListCellRenderer<Object> r) {
        ListCellRenderer<Net> renderer;
        this.mList.setCellRenderer(r);
        ListModel<Net> m = this.mList.getModel();
        if (m != null && m.getSize() > 1000 && (renderer = this.mList.getCellRenderer()) != null) {
            int w = 10;
            int h = 10;
            for (int index = 0; index < 1000; ++index) {
                Net value = m.getElementAt(index);
                Component c = r.getListCellRendererComponent(this.mList, value, index, false, false);
                Dimension cellSize = c.getPreferredSize();
                w = Math.max(cellSize.width, w);
                h = Math.max(cellSize.height, h);
            }
            this.mList.setFixedCellWidth(w);
            this.mList.setFixedCellHeight(h);
        }
    }

    public String getListTitle() {
        return this.getNetlistModel().getListTitle();
    }

    public JList<Net> getList() {
        return this.mList;
    }

    public Device getDevice() {
        return this.getNetlistModel().getDevice();
    }

    public DeviceTemplate getDeviceTemplate() {
        return this.getNetlistModel().getDeviceTemplate();
    }

    public void setInclude(Include include) {
        if (include == this.getNetlistModel().getInclude()) {
            return;
        }
        this.getNetlistModel().setInclude(include);
    }

    public void setFilter(DeviceTemplate.NetFilter filter) {
        this.getNetlistModel().setFilter(filter);
    }

    public DeviceTemplate.NetFilter getFilter() {
        return this.getNetlistModel().getFilter();
    }

    protected Net lookupNet(String name) {
        return this.getNetlistModel().mDeviceTemplate.getNet(name);
    }

    protected void repaintNetManagementPanel() {
        NetMgmtPanel nmp = (NetMgmtPanel)UIUtil.getAncestorOfType((Component)this, NetMgmtPanel.class);
        if (nmp != null) {
            nmp.repaint();
        }
    }

    protected String queryUserForNetName(Device targetDevice, String defaultName) {
        final ADialog dlg = new ADialog((Component)this, "New Net Name", Dialog.ModalityType.APPLICATION_MODAL);
        GridBagManager l = GridBagManager.layout((Container)dlg.getContentPane());
        l.add("Name:");
        final JTextField tfName = (JTextField)l.add((Component)new JTextField(20), (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        l.push((GridBagConstraints)GridBagManager.FILLX_REMAINX);
        final JButton btnOk = (JButton)l.add((Component)new JButton("OK"), (GridBagConstraints)GridBagManager.RIGHT);
        JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"), (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        tfName.getDocument().addDocumentListener(new ADocumentAdapter(){

            @Override
            public void documentChanged(DocumentEvent e) {
                String curName = tfName.getText().trim();
                btnOk.setEnabled(NetListPanel.this.lookupNet(curName) == null);
            }
        });
        final StringBuffer name = new StringBuffer();
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String netName = tfName.getText().trim();
                if (NetListPanel.this.lookupNet(netName) != null) {
                    JOptionPane.showMessageDialog(NetListPanel.this, "There is already a netnamed '" + netName + "'.", "Invalid Name", 0);
                    return;
                }
                name.append(netName);
                UIUtil.closeWindow((Window)dlg);
            }
        });
        UIUtil.enableEscCloseDefaultMinSize((JDialog)dlg, (AbstractButton)btnCancel, (JButton)btnOk);
        UIUtil.center((Component)dlg);
        tfName.setText(defaultName);
        dlg.setVisible(true);
        if (name.length() > 0) {
            return name.toString();
        }
        return null;
    }

    protected Optional<Action> getMapToParentAction(final NetListPanel childList) {
        final NetListPanel parentList = childList.getNetlistModel().getParentList();
        if (parentList == null) {
            return Optional.empty();
        }
        final List<Net> childSelection = childList.getList().getSelectedValuesList();
        if (childSelection.isEmpty()) {
            return Optional.empty();
        }
        final List<Net> parentSelection = parentList.getList().getSelectedValuesList();
        if (parentSelection.size() != childSelection.size()) {
            return Optional.empty();
        }
        return Optional.of(new AbstractAction("Map to selected parents"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Device childDevice = NetListPanel.this.getNetlistModel().getDevice();
                AStream.zip(parentSelection.stream(), childSelection.stream()).forEach(pair -> {
                    if (!NetCmd.recordMapNet((Device)childDevice, (Net)((Net)pair.second), (Net)((Net)pair.first))) {
                        ALog.logError((String)"Parent net '%s' wasn not mapped to child device '%s' net '%s'.", (Object[])new Object[]{((Net)pair.first).getName()});
                    }
                });
                parentList.repaint();
                childList.repaint();
            }
        });
    }

    public static class NetListLabel
    extends JLabel {
        protected NetListPanel mNetList;

        public NetListLabel(NetListPanel netList) {
            super(netList.getListTitle(), DbExplorerPanel.getIconForDevice(netList.getDevice()), 10);
            this.mNetList = netList;
            this.setBorder(BorderFactory.createLineBorder(this.getBackground().darker()));
            this.setLabelFor(this.mNetList);
            this.setTransferHandler(netList.getTransferHandler());
        }
    }

    public static class NetListModel
    extends AbstractListModel<Net>
    implements Comparable<NetListModel> {
        protected Device mDevice;
        protected DeviceTemplate mDeviceTemplate;
        protected NetListPanel mParentList;
        protected Include mInclude = Include.ALL;
        protected DeviceTemplate.NetFilter mNetFilter = null;
        protected ArrayList<Net> mNets = new ArrayList();

        public NetListModel(Device d, NetListPanel parentList) {
            this.mDevice = d;
            this.mDeviceTemplate = d.getTemplate();
            this.mParentList = parentList;
            this.mNetFilter = OrbitIO.getOrbitIO().getDefaultNetFilter();
            assert (parentList == null || d != null);
            this.populateNets(false);
        }

        public int getIndexByName(String name) {
            for (int i = 0; i < this.mNets.size(); ++i) {
                if (!this.mNets.get(i).getName().equals(name)) continue;
                return i;
            }
            return -1;
        }

        public NetListModel(Db db) {
            this.mDeviceTemplate = Design.getDesign((Db)db);
            this.mParentList = null;
            this.mNetFilter = null;
            this.populateNets(false);
        }

        public boolean isParentList() {
            return this.getParentList() == null;
        }

        public NetListPanel getParentList() {
            return this.mParentList;
        }

        @Override
        public Net getElementAt(int index) {
            return this.mNets.get(index);
        }

        @Override
        public int getSize() {
            return this.mNets.size();
        }

        public String getListTitle() {
            if (this.mDevice == null) {
                return "<Design>";
            }
            return this.mDevice.getName();
        }

        @Override
        public int compareTo(NetListModel o) {
            return this.getListTitle().compareTo(o.getListTitle());
        }

        public int getIndexOf(Net net) {
            return this.mNets.indexOf(net);
        }

        public Device getDevice() {
            return this.mDevice;
        }

        public DeviceTemplate getDeviceTemplate() {
            return this.mDeviceTemplate;
        }

        public void addNet(Net net) {
            if (this.mNets.contains(net)) {
                return;
            }
            this.mNets.add(net);
            int idx = this.mNets.size() - 1;
            this.fireIntervalAdded(this, idx, idx);
        }

        public boolean removeNet(Net net) {
            int index = this.mNets.indexOf(net);
            if (index < 0) {
                return false;
            }
            if (this.mNets.remove(index) == null) {
                return false;
            }
            this.fireIntervalRemoved(this, index, index);
            return true;
        }

        public Include getInclude() {
            return this.mInclude;
        }

        public void setInclude(Include inc) {
            this.mInclude = inc;
            this.populateNets(true);
        }

        public void setFilter(DeviceTemplate.NetFilter f) {
            DeviceTemplate.NetFilter filter;
            DeviceTemplate.NetFilter netFilter = filter = f == null || f instanceof NetFilters.AllFilter ? null : f;
            if (filter == this.mNetFilter) {
                return;
            }
            this.mNetFilter = filter;
            this.populateNets(true);
        }

        public DeviceTemplate.NetFilter getFilter() {
            return this.mNetFilter;
        }

        protected void populateNets(boolean fireEvent) {
            int oldSize = this.mNets.size();
            this.mNets.clear();
            if (oldSize > 0 && fireEvent) {
                this.fireIntervalRemoved(this, 0, oldSize - 1);
            }
            for (Net n : this.mDeviceTemplate.getNets()) {
                if (n.isUnused() || !this.include(n)) continue;
                this.mNets.add(n);
            }
            Collections.sort(this.mNets, Net.NameComparator);
            int newSize = this.mNets.size();
            if (newSize > 0 && fireEvent) {
                this.fireIntervalAdded(this, 0, newSize - 1);
            }
        }

        protected boolean include(Net n) {
            if (this.mNetFilter != null && !this.mNetFilter.include(n)) {
                return false;
            }
            if (this.mInclude == Include.MAPPED) {
                return this.isMapped(n);
            }
            if (this.mInclude == Include.UNMAPPED) {
                return !this.isMapped(n);
            }
            return true;
        }

        protected boolean isMapped(Net net) {
            if (this.isParentList()) {
                return NetMap.getChildNets((Net)net).hasNext();
            }
            return NetMap.getParentNetMap((Device)this.mDevice, (Net)net) != null;
        }
    }

    protected class NetFinder
    extends JPanel {
        protected AListSearcher.UI mSearchCtrl;

        public NetFinder() {
            GridBagManager l = GridBagManager.layout((Container)this);
            this.mSearchCtrl = (AListSearcher.UI)l.add((Component)new AListSearcher.UI("Find:", NetListPanel.this.mList, new AListSearcher.ListItemToString(){

                @Override
                public String toString(Object listItem) {
                    if (listItem instanceof Net) {
                        Net net = (Net)listItem;
                        if (net.getDb() == null) {
                            return "<Deleted>";
                        }
                        return net.getName();
                    }
                    return listItem == null ? "" : listItem.toString();
                }
            }), (GridBagConstraints)GridBagManager.FILLX.noInsets());
            this.mSearchCtrl.setButtonIcons(OrbitIcons.SRCH_PREV, OrbitIcons.SRCH_PREV_X, OrbitIcons.SRCH_NEXT, OrbitIcons.SRCH_NEXT_X);
            this.mSearchCtrl.setButtonText(null, null);
            JButton btnClose = (JButton)l.add((Component)new JButton());
            btnClose.setIcon(AFloatWindow.ICON_CLOSE);
            btnClose.setMargin(new Insets(0, 0, 0, 0));
            btnClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NetFinder.this.setVisible(false);
                }
            });
            String ACTION_CLOSE = "CloseControl";
            this.getActionMap().put("CloseControl", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NetFinder.this.setVisible(false);
                }
            });
            this.getInputMap(1).put(KeyStroke.getKeyStroke("ESCAPE"), "CloseControl");
        }

        @Override
        public void requestFocus() {
            NetFinder nf;
            Component curFocus = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (curFocus != null && (nf = (NetFinder)UIUtil.getAncestorOfType((Component)curFocus, NetFinder.class)) != null && nf == this) {
                return;
            }
            this.mSearchCtrl.requestFocus();
        }
    }

    protected class UnmapChildrenAction
    extends AbstractAction {
        protected Net mParentNet;

        public UnmapChildrenAction(Net parentNet) {
            this.mParentNet = parentNet;
            this.putValue("Name", "Unmap all children");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Boolean result = (Boolean)Cp.exec((String)"NetMap.unmapAllChildren(curDb(), \"%s\")", (Object[])new Object[]{this.mParentNet.getKeyStr()});
            if (!result.booleanValue()) {
                return;
            }
            NetListPanel.this.repaintNetManagementPanel();
        }
    }

    protected class ShowOnlyMappedChildDevices
    extends AbstractAction {
        protected Net mParentNet;

        public ShowOnlyMappedChildDevices(Net parentNet) {
            super("Show Only Mapped Child Device Columns \u2192");
            this.mParentNet = parentNet;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HashSet<Device> mappedChildren = new HashSet<Device>();
            for (NetMap nm : NetMap.getChildNets((Net)this.mParentNet)) {
                mappedChildren.add(nm.getDevice());
            }
            NetMgmtPanel nmp = (NetMgmtPanel)UIUtil.getAncestorOfType((Component)NetListPanel.this, NetMgmtPanel.class);
            for (Component c : nmp.mPnlChildNets.getComponents()) {
                JLabel l;
                Component labelFor;
                if (c instanceof JLabel && (labelFor = (l = (JLabel)c).getLabelFor()) instanceof NetListPanel) {
                    if (mappedChildren.contains(((NetListPanel)labelFor).getDevice())) {
                        c.setVisible(true);
                    } else {
                        c.setVisible(false);
                    }
                }
                if (!(c instanceof NetListPanel)) continue;
                if (mappedChildren.contains(((NetListPanel)c).getDevice())) {
                    c.setVisible(true);
                    continue;
                }
                c.setVisible(false);
            }
        }
    }

    protected class UnmapParentAction
    extends AbstractAction {
        protected NetMap mNetMap;

        public UnmapParentAction(NetMap netMap) {
            this.mNetMap = netMap;
            String name = String.format("Unmap parent ('%s')", netMap.getParentNet().getName());
            this.putValue("Name", name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Boolean result = (Boolean)Cp.exec((String)"NetMap.unmap(curDb(), \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{this.mNetMap.getDevice().getKeyStr(), this.mNetMap.getChildNet().getName(), this.mNetMap.getParentNet().getKeyStr()});
            if (!result.booleanValue()) {
                return;
            }
            NetListPanel.this.repaintNetManagementPanel();
        }
    }

    protected class DeleteNetAction
    extends AbstractAction {
        protected Net mNet;

        public DeleteNetAction(Net net) {
            super("Delete Net");
            this.mNet = net;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (NetUI.DeleteNetUI.delete(NetListPanel.this, this.mNet)) {
                NetListPanel.this.repaintNetManagementPanel();
            }
        }
    }

    protected class RenameNetAction
    extends AbstractAction {
        protected Net mNet;

        public RenameNetAction(Net net) {
            super("Rename Net...");
            this.mNet = net;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (NetUI.RenameNetUI.rename(NetListPanel.this, this.mNet)) {
                NetListPanel.this.repaintNetManagementPanel();
            }
        }
    }

    protected class CreateNetAction
    extends AbstractAction {
        protected DeviceTemplate mDeviceTemplate;

        public CreateNetAction(DeviceTemplate dt) {
            super("Create Net...");
            this.mDeviceTemplate = dt;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Net newNet = NetUI.AddNetUI.addNet(NetListPanel.this, this.mDeviceTemplate);
            if (newNet == null) {
                return;
            }
            NetListPanel.this.mList.setModel(NetListPanel.this.getDevice() == null ? new NetListModel(this.mDeviceTemplate.getDb()) : new NetListModel(NetListPanel.this.getDevice(), NetListPanel.this.getNetlistModel().getParentList()));
            NetListPanel.this.mList.setSelectedValue(newNet, true);
        }
    }

    protected class DeleteSelectedNetsAction
    extends AbstractAction {
        private final LinkedList<Net> selNets;

        private DeleteSelectedNetsAction(String name, LinkedList<Net> selNets) {
            super(name);
            this.selNets = selNets;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.selNets.isEmpty()) {
                return;
            }
            String msg = String.format("Delete %d Nets?", this.selNets.size());
            int conf = JOptionPane.showConfirmDialog(NetListPanel.this, msg, "Confirm Delete", 0);
            if (conf != 0) {
                return;
            }
            DbHistory history = this.selNets.get(0).getDb().getHistory();
            try (DbHistory.DbTransaction transaction = history.newDbTransaction("Delete Nets");){
                for (Net n : this.selNets) {
                    boolean moved;
                    if (n.getContents().hasNext() && !(moved = ((Boolean)Cp.exec((String)"curDb().getByKeyStr(Net.class, \"%s\").moveContents(null)", (Object[])new Object[]{n.getKeyStr()})).booleanValue())) {
                        ALog.logError((String)"Unable to move net '%s' contents to NetUnused, the net is not being deleted.", (Object[])new Object[]{n.getName()});
                        continue;
                    }
                    Cp.exec((String)"curDb().getByKeyStr(Net.class, \"%s\").deleteFromDb()", (Object[])new Object[]{n.getKeyStr()});
                }
            }
            NetListPanel.this.repaintNetManagementPanel();
        }
    }

    protected class UnmapChildNetsAction
    extends AbstractAction {
        private final LinkedList<Net> selNets;

        protected UnmapChildNetsAction(LinkedList<Net> selNets) {
            super("Unmap all children of selected Nets");
            this.selNets = selNets;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.selNets.isEmpty()) {
                return;
            }
            String msg = String.format("Unmap all children of %d Nets?", this.selNets.size());
            int conf = JOptionPane.showConfirmDialog(NetListPanel.this, msg, "Confirm Unmap", 0);
            if (conf != 0) {
                return;
            }
            boolean deleted = false;
            DbHistory history = this.selNets.get(0).getDb().getHistory();
            try (DbHistory.DbTransaction transaction = history.newDbTransaction("Unmap Nets");){
                for (Net n : this.selNets) {
                    deleted |= ((Boolean)Cp.exec((String)"NetMap.unmapAllChildren(curDb(), \"%s\")", (Object[])new Object[]{n.getKeyStr()})).booleanValue();
                }
            }
            if (deleted) {
                NetListPanel.this.repaintNetManagementPanel();
            }
        }
    }

    protected class UnmapParentNetsAction
    extends AbstractAction {
        private final LinkedList<Net> selNets;

        protected UnmapParentNetsAction(LinkedList<Net> selNets) {
            super("Unmap all parents of selected Nets");
            this.selNets = selNets;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Device childDevice = NetListPanel.this.getDevice();
            boolean changed = false;
            for (Net childNet : this.selNets) {
                NetMap netMap = NetMap.getParentNetMap((Device)childDevice, (Net)childNet);
                if (netMap == null) continue;
                changed |= ((Boolean)Cp.exec((String)"NetMap.unmap(curDb(), \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{netMap.getDevice().getKeyStr(), netMap.getChildNet().getName(), netMap.getParentNet().getKeyStr()})).booleanValue();
            }
            if (changed) {
                NetListPanel.this.repaintNetManagementPanel();
            }
        }
    }

    protected class ActionShowUnmappedNets
    extends AbstractAction {
        ActionShowUnmappedNets() {
            super("Show Unmapped");
            NetListModel nlm = NetListPanel.this.getNetlistModel();
            Include curShow = nlm.getInclude();
            this.putValue("SwingSelectedKey", curShow == Include.UNMAPPED);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NetListPanel.this.setInclude(Include.UNMAPPED);
        }
    }

    protected class ActionShowMappedNets
    extends AbstractAction {
        ActionShowMappedNets() {
            super("Show Mapped");
            NetListModel nlm = NetListPanel.this.getNetlistModel();
            Include curShow = nlm.getInclude();
            this.putValue("SwingSelectedKey", curShow == Include.MAPPED);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NetListPanel.this.setInclude(Include.MAPPED);
        }
    }

    protected class ActionShowAllNets
    extends AbstractAction {
        ActionShowAllNets() {
            super("Show All");
            NetListModel nlm = NetListPanel.this.getNetlistModel();
            Include curShow = nlm.getInclude();
            this.putValue("SwingSelectedKey", curShow == Include.ALL);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NetListPanel.this.setInclude(Include.ALL);
        }
    }

    public static enum Include {
        ALL,
        MAPPED,
        UNMAPPED;

    }
}

