/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.sigrity.acl.ALog;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.dbui.render.DeviceListRenderer;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AHistoryTextField;
import com.sigrity.acl.ui.APatternHelpButton;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.NetMapBulkUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class NetMapBulkCreateChildUI {
    public static final Icon ICON_MORE = UIUtil.ICON_MORE;
    public static final Icon ICON_MAPPED = UIUtil.ICON_WARN;
    public static final Icon ICON_MAPPED_SAME = UIUtil.ICON_INFO;
    public static final Icon ICON_CONFLICT = UIUtil.ICON_ERR;
    public static final Color COLOR_MATCHED = new Color(0xCCFFCC);
    protected static final Color COLOR_MATCHED_SELECTED = null;

    private NetMapBulkCreateChildUI() {
    }

    public static void show(Component owner, DeviceTemplate parentDevT) {
        NetMapBulkCreateChildDialog dlg = new NetMapBulkCreateChildDialog(owner, parentDevT);
        dlg.pack();
        dlg.setVisible(true);
    }

    public static class NetMapBulkCreateChildDialog
    extends ADialog {
        protected Device mChildDevice;
        protected DeviceTemplate mParentTemplate;
        protected AHistoryTextField mTxtSourceRegex;
        protected AHistoryTextField mTxtTargetRegex;
        protected BulkCreateSourceNetList mLstSourceNets;
        protected JList<String> mLstTargetNames;
        protected JLabel mStatus;
        protected String mStatusExt;
        protected NetMapBulkUI.NetListModel mAllSourceNets = new NetMapBulkUI.NetListModel();
        protected NetMapBulkUI.NetListModel mSelectedSourceNets = new NetMapBulkUI.NetListModel();
        protected JCheckBox mIgnoreCaseSelect;
        protected ArrayList<List<String>> mCapturedValues = new ArrayList();
        protected DefaultListModel<String> mTargetNames = new DefaultListModel();
        protected BiMap<Net, String> mSource2TargetNetName = HashBiMap.create();
        protected int mOldToolTipDismissDelay;
        protected CardLayout mCard;
        protected JList<Device> mChildDevices;
        protected JPanel mBulkPanel = new JPanel();
        protected static final String CARD_SELECT = "select";
        protected static final String CARD_BULK = "bulkCreate";
        protected AHistoryTextField.UpdateListener mTargetSelectorChange = hint -> {
            this.updateTargetNames();
            if (hint == AHistoryTextField.UpdateHint.ACTION) {
                this.mTxtTargetRegex.saveCurrentEntryToHistory();
            }
        };
        protected AHistoryTextField.UpdateListener mSourceMatcherChange = hint -> {
            this.setStatus(null);
            this.updateSelectedSourceNets();
            if (hint == AHistoryTextField.UpdateHint.ACTION) {
                this.mTxtSourceRegex.saveCurrentEntryToHistory();
            }
        };
        protected ListSelectionListener mSourceSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                Net netChild = (Net)mLstSourceNets.getSelectedValue();
                if (netChild == null) {
                    return;
                }
                String parentName = (String)mSource2TargetNetName.get((Object)netChild);
                if (parentName == null) {
                    mLstTargetNames.clearSelection();
                } else {
                    int idx = mTargetNames.indexOf(parentName);
                    if (idx != -1) {
                        mLstTargetNames.setSelectedIndex(idx);
                        mLstTargetNames.ensureIndexIsVisible(idx);
                    }
                }
            }
        };
        protected ListSelectionListener mTargetSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                String parentName = mLstTargetNames.getSelectedValue();
                if (parentName == null) {
                    return;
                }
                Net netChild = (Net)mSource2TargetNetName.inverse().get((Object)parentName);
                if (netChild == null) {
                    assert (false) : "Unmatched parent name in parent name list.";
                    mLstSourceNets.clearSelection();
                } else {
                    NetMapBulkUI.NetListModel nlm = (NetMapBulkUI.NetListModel)mLstSourceNets.getModel();
                    int idx = nlm.mNets.indexOf(netChild);
                    if (idx != -1) {
                        mLstSourceNets.setSelectedIndex(idx);
                        mLstSourceNets.ensureIndexIsVisible(idx);
                    }
                }
            }
        };
        protected ActionListener mApplyListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceTemplate.NetFilter childFilter = mLstSourceNets.getNetFilter();
                Object result = Cp.exec((String)"NetCommands.bulkCreateChildNets(curDb(), \"%s\", %s, \"%s\", %d, \"%s\")", (Object[])new Object[]{mChildDevice.getKeyStr(), childFilter == null ? "null" : childFilter.getScriptRef(), this.getSourceRegex(), this.getSourceRegexFlags(), this.getTargetRegex()});
                long mapped = 0L;
                if (result instanceof Long) {
                    mapped = (Long)result;
                    String msg = mapped == 1L ? "1 new net mapped." : String.format("%d new nets mapped.", mapped);
                    ALog.logInfo((String)msg);
                    this.setStatus(msg);
                } else {
                    ALog.logWarn((Throwable)new Throwable(), (String)"Unexpected result returned from NetMap.bulkCreateParentNets(): %s", (Object[])new Object[]{"" + result});
                    this.setStatus("Unexpected result returned from NetMap.bulkCreateParentNets() command.");
                }
                mTxtSourceRegex.saveCurrentEntryToHistory();
                mTxtTargetRegex.saveCurrentEntryToHistory();
                this.repaint();
            }
        };
        protected DefaultListCellRenderer mSourceListCellRenderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String targetName;
                super.getListCellRendererComponent(list, (Object)null, index, isSelected, cellHasFocus);
                Net net = (Net)value;
                this.setText(net.getName());
                StringBuilder toolTip = new StringBuilder(String.format("<b>%s</b>", net.getName()));
                if (mCapturedValues.size() > index) {
                    List<String> values = mCapturedValues.get(index);
                    for (int i = 0; i < values.size(); ++i) {
                        if (i == 0) {
                            toolTip.append("<br>Captured values:");
                        }
                        toolTip.append(String.format("<br>&nbsp;&nbsp;&nbsp;%%%d: '%s'", i, values.get(i)));
                    }
                }
                if ((targetName = (String)mSource2TargetNetName.get((Object)net)) != null) {
                    if (isSelected) {
                        this.setBackground(COLOR_MATCHED_SELECTED);
                    } else {
                        this.setBackground(COLOR_MATCHED);
                    }
                    if (toolTip.length() > 0) {
                        toolTip.append("<br>");
                    }
                    toolTip.append("Will create and map to: " + targetName);
                }
                for (NetMap nm : NetMap.getChildNets((Net)net)) {
                    Net childNet = nm.getChildNet();
                    if (!childNet.getName().equals(targetName)) {
                        this.setIcon(ICON_MAPPED);
                        toolTip.append("<br>Currently mapped to: " + childNet.getName());
                        continue;
                    }
                    this.setIcon(ICON_MAPPED_SAME);
                    toolTip.append("<br>Already mapped to: " + childNet.getName());
                }
                this.setToolTipText("<html>" + toolTip + "</html>");
                return this;
            }
        };
        protected DefaultListCellRenderer mTargetListCellRenderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Net parentNet;
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (mChildDevice == null) {
                    return this;
                }
                String targetName = (String)value;
                this.setText(targetName);
                Object toolTip = String.format("<b>%s</b>", targetName);
                Net existingNet = mChildDevice.getTemplate().getNet(targetName);
                if (existingNet != null) {
                    this.setIcon(ICON_CONFLICT);
                    toolTip = (String)toolTip + "<br>Net already exists: " + existingNet.getName();
                }
                if ((parentNet = (Net)mSource2TargetNetName.inverse().get((Object)targetName)) != null) {
                    if (isSelected) {
                        this.setBackground(COLOR_MATCHED_SELECTED);
                    } else {
                        this.setBackground(COLOR_MATCHED);
                    }
                    if (((String)toolTip).length() > 0) {
                        toolTip = (String)toolTip + "<br>";
                    }
                    toolTip = (String)toolTip + "Created from: " + parentNet.getName();
                } else assert (false) : "No matching child net found.";
                this.setToolTipText("<html>" + (String)toolTip + "</html>");
                return this;
            }
        };

        private String getSourceName() {
            return String.format("Parent: '%s'", this.mParentTemplate.getName());
        }

        private String getTargetName() {
            return String.format("Child: '%s'", this.mChildDevice == null ? "?" : this.mChildDevice.getName());
        }

        private void updateTitle() {
            this.setTitle(String.format("Bulk Creation Child Nets - %s >>> %s", this.mParentTemplate.getName(), this.mChildDevice == null ? "?" : this.mChildDevice.getName()));
        }

        private void updateChooseDevice() {
            this.updateBulkPanel();
            this.updateAllSourceNets();
            this.updateTargetNames();
            this.updateTitle();
            this.mTxtSourceRegex.setText("(.*)");
            this.mTxtTargetRegex.setText("{1}");
        }

        public JPanel createChildListPanel() {
            JPanel panel = new JPanel();
            GridBagManager l = new GridBagManager((Container)panel);
            l.push("Bulk Create Child Device", (GridBagConstraints)GridBagManager.FILLALL);
            DefaultListModel<Device> model = new DefaultListModel<Device>();
            for (Device d : this.mParentTemplate.getChildren()) {
                model.addElement(d);
            }
            this.mChildDevices = new JList(model);
            this.mChildDevices.setSelectionMode(0);
            this.mChildDevices.setCellRenderer(new DeviceListRenderer());
            this.mChildDevices.setBorder(BorderFactory.createEtchedBorder());
            l.add((Component)new JScrollPane(this.mChildDevices), (GridBagConstraints)GridBagManager.FILLALL.anchor(18));
            JButton nextButton = new JButton("Next");
            nextButton.addActionListener(e -> {
                if (this.mChildDevices.getSelectedValue() != null) {
                    this.mChildDevice = this.mChildDevices.getSelectedValue();
                    this.updateChooseDevice();
                    this.mCard.show(this.getContentPane(), CARD_BULK);
                } else {
                    ALog.logInfo((String)"Please select one of child devices.");
                }
            });
            nextButton.setToolTipText("Start bulk creation");
            l.add((Component)nextButton, (GridBagConstraints)GridBagManager.RIGHT.anchor(16));
            l.pop();
            return panel;
        }

        public JPanel updateBulkPanel() {
            JPanel panel = new JPanel();
            GridBagManager l = GridBagManager.layout((Container)panel);
            l.pushFill();
            l.pushFill(this.getSourceName());
            l.add("Selector:");
            this.mTxtSourceRegex = new AHistoryTextField("MRU", "BulkNetMap_Matcher", 12);
            l.add((Component)((Object)this.mTxtSourceRegex), (GridBagConstraints)GridBagManager.FILLX);
            l.add((Component)new APatternHelpButton(), (GridBagConstraints)GridBagManager.RIGHT);
            this.mTxtSourceRegex.setMinimumSize(this.mTxtSourceRegex.getPreferredSize());
            this.mTxtSourceRegex.setUpdateListener(this.mSourceMatcherChange);
            this.mTxtSourceRegex.setInvokeActionOnTextUpdate(true);
            this.mTxtSourceRegex.setAutoSave(false);
            l.newline();
            l.add("Selected:", (GridBagConstraints)GridBagManager.TOPLEFT);
            this.mLstSourceNets = new BulkCreateSourceNetList();
            JScrollPane spSourceNets = new JScrollPane(this.mLstSourceNets);
            l.add((Component)spSourceNets, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            this.mLstSourceNets.setSelectionMode(0);
            this.mLstSourceNets.getSelectionModel().addListSelectionListener(this.mSourceSelectionListener);
            this.mLstSourceNets.setCellRenderer(this.mSourceListCellRenderer);
            l.newline();
            this.mIgnoreCaseSelect = new JCheckBox("Case insensitive match");
            l.add((Component)this.mIgnoreCaseSelect, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            this.mIgnoreCaseSelect.addActionListener(e -> this.updateSelectedSourceNets());
            l.pop();
            l.pushFill(this.getTargetName());
            l.add("Name Pattern:");
            this.mTxtTargetRegex = new AHistoryTextField("MRU", "BulkNetMap_Selector", 12);
            l.add((Component)((Object)this.mTxtTargetRegex), (GridBagConstraints)GridBagManager.FILLX);
            l.add((Component)new APatternHelpButton(), (GridBagConstraints)GridBagManager.RIGHT);
            this.mTxtTargetRegex.setMinimumSize(this.mTxtTargetRegex.getPreferredSize());
            this.mTxtTargetRegex.setUpdateListener(this.mTargetSelectorChange);
            this.mTxtTargetRegex.setInvokeActionOnTextUpdate(true);
            this.mTxtTargetRegex.setAutoSave(false);
            l.newline();
            l.add("New Name:", (GridBagConstraints)GridBagManager.TOPLEFT);
            this.mLstTargetNames = new JList<String>(this.mTargetNames);
            JScrollPane spParentNets = new JScrollPane(this.mLstTargetNames);
            l.add((Component)spParentNets, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            this.mLstTargetNames.setSelectionMode(0);
            this.mLstTargetNames.getSelectionModel().addListSelectionListener(this.mTargetSelectionListener);
            this.mLstTargetNames.setCellRenderer(this.mTargetListCellRenderer);
            l.pop();
            Container mainPanel = l.getCurrentContainer();
            Dimension d = mainPanel.getPreferredSize();
            d.height = (int)((double)d.height * 2.5);
            mainPanel.setPreferredSize(d);
            l.pop();
            l.newline();
            l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
            this.mStatus = new JLabel();
            l.add((Component)this.mStatus, (GridBagConstraints)GridBagManager.FILLX);
            JButton btnApply = new JButton("Create");
            l.add((Component)btnApply, (GridBagConstraints)GridBagManager.RIGHT);
            btnApply.addActionListener(this.mApplyListener);
            JButton btnClose = new JButton("Close");
            l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, null);
            this.mBulkPanel.removeAll();
            this.mBulkPanel.setLayout(new BorderLayout());
            this.mBulkPanel.add((Component)panel, "Center");
            return panel;
        }

        public NetMapBulkCreateChildDialog(Component owner, DeviceTemplate parentDevT) {
            super(owner, "Bulk Net Creation", Dialog.ModalityType.APPLICATION_MODAL);
            this.mCard = new CardLayout();
            this.setLayout(this.mCard);
            this.mChildDevice = null;
            this.mParentTemplate = parentDevT;
            JPanel bulkMainPanel = this.mBulkPanel;
            JPanel childPanel = this.createChildListPanel();
            this.add(childPanel, CARD_SELECT);
            this.add(bulkMainPanel, CARD_BULK);
            this.updateChooseDevice();
            this.pack();
            UIUtil.center((Component)((Object)this));
        }

        public void addNotify() {
            super.addNotify();
            this.mOldToolTipDismissDelay = ToolTipManager.sharedInstance().getDismissDelay();
            ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        }

        public void removeNotify() {
            ToolTipManager.sharedInstance().setDismissDelay(this.mOldToolTipDismissDelay);
            super.removeNotify();
        }

        protected String expandSourceRegex(String regex) {
            if (!(((String)regex).contains("\\") || ((String)regex).contains(".") || ((String)regex).contains("[") || ((String)regex).contains("$"))) {
                regex = (String)regex + ".*";
            }
            return regex;
        }

        protected String getSourceRegex() {
            String childRegex = this.mTxtSourceRegex.getText();
            childRegex = this.expandSourceRegex(childRegex);
            return childRegex;
        }

        protected int getSourceRegexFlags() {
            int flags = 0;
            if (this.mIgnoreCaseSelect.isSelected()) {
                flags |= 2;
            }
            return flags;
        }

        protected String getTargetRegex() {
            return this.mTxtTargetRegex.getText();
        }

        protected void updateAllSourceNets() {
            this.mAllSourceNets.clear();
            for (Net n : this.mParentTemplate.getNets()) {
                if (n.isUnused() || !NetMapBulkUI.include(this.mLstSourceNets.getNetFilter(), n)) continue;
                this.mAllSourceNets.add(n);
            }
            this.mAllSourceNets.sort();
            this.updateSelectedSourceNets();
        }

        protected void updateSelectedSourceNets() {
            this.updateSelectedSourceNetsWithRegex();
            this.updateTargetNames();
        }

        protected void updateSelectedSourceNetsWithRegex() {
            String selector = this.mTxtSourceRegex.getText();
            if (selector.length() == 0) {
                this.mLstSourceNets.setModel((ListModel)this.mAllSourceNets);
                this.setStatus("All child nets displayed.");
                return;
            }
            this.mSelectedSourceNets.clear();
            this.mCapturedValues.clear();
            selector = this.expandSourceRegex(selector);
            int flags = this.getSourceRegexFlags();
            try {
                Pattern pattern = Pattern.compile(selector, flags);
                for (Net n : this.mAllSourceNets.mNets) {
                    Matcher matcher;
                    String val = n.getName();
                    if (val == null) {
                        val = "";
                    }
                    if (!(matcher = pattern.matcher(val)).matches()) continue;
                    this.mSelectedSourceNets.add(n);
                    int groupCount = matcher.groupCount();
                    ArrayList<String> curValues = new ArrayList<String>();
                    this.mCapturedValues.add(curValues);
                    for (int i = 0; i <= groupCount; ++i) {
                        curValues.add(matcher.group(i));
                    }
                }
                this.mLstSourceNets.setModel((ListModel)this.mSelectedSourceNets);
                this.setStatus("Child nets selected.");
                if (this.mCapturedValues.size() > 0) {
                    int groupCount = this.mCapturedValues.get(0).size();
                    if (groupCount == 1) {
                        this.addStatus("Captured 1 value per child net.");
                    } else {
                        this.addStatus("Captured %d values per child net.", groupCount);
                    }
                }
            }
            catch (PatternSyntaxException e) {
                this.setStatus("Invalid child net pattern, all child nets displayed, no mapping performed.");
                this.mTargetNames.clear();
                return;
            }
        }

        protected void updateTargetNames() {
            this.mTargetNames.clear();
            this.mSource2TargetNetName.clear();
            String regex = this.mTxtTargetRegex.getText();
            if (regex.isEmpty()) {
                this.addStatus("No target pattern specified, no mapping to perform.");
                return;
            }
            if (this.mCapturedValues.isEmpty()) {
                this.addStatus("No source name values captured, no mapping to perform.");
                return;
            }
            NetMap.generateNames(this.mSelectedSourceNets.getList(), (String)regex, this.mCapturedValues, (NetMap.GenerateNameNotification)new NetMap.GenerateNameNotification(){

                public void generate(Net refNet, String newName) {
                    mSource2TargetNetName.put((Object)refNet, (Object)newName);
                    mTargetNames.addElement(newName);
                }
            });
            this.mLstTargetNames.repaint();
            this.mLstSourceNets.repaint();
            this.addStatus("Target net names updated.");
        }

        protected NetMapBulkUI.NetListModel getChildNetListModel() {
            return this.mLstSourceNets.getNetListModel();
        }

        protected void setStatus(String text) {
            if (this.mStatus == null) {
                return;
            }
            this.mStatus.setIcon(null);
            this.mStatus.setText(text == null ? "" : text);
            this.mStatus.setToolTipText(text);
            this.mStatusExt = null;
        }

        protected void addStatus(String text) {
            if (this.mStatus == null) {
                return;
            }
            if (this.mStatus.getText().length() == 0) {
                this.setStatus(text);
                return;
            }
            if (this.mStatus.getIcon() == null) {
                this.mStatus.setIcon(ICON_MORE);
                this.mStatusExt = this.mStatus.getText();
            }
            this.mStatusExt = this.mStatusExt + "<br>" + text;
            this.mStatus.setToolTipText(String.format("<html>%s</html>", this.mStatusExt));
        }

        protected void addStatus(String format, Object ... args) {
            this.addStatus(String.format(format, args));
        }

        public class BulkCreateSourceNetList
        extends NetMapBulkUI.NetList {
            public BulkCreateSourceNetList() {
                this.mNetFilter = OrbitIO.getApp().getDefaultNetFilter();
            }

            @Override
            public void setNetFilter(DeviceTemplate.NetFilter nf) {
                super.setNetFilter(nf);
                NetMapBulkCreateChildDialog.this.updateAllSourceNets();
            }
        }
    }
}

