/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.sigrity.acl.AColor;
import com.sigrity.acl.ALog;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AHistoryTextField;
import com.sigrity.acl.ui.APatternHelpButton;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.NetMapBulkUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class NetMapBulkCreateUI
extends ADialog {
    public static final Icon ICON_MORE = UIUtil.ICON_MORE;
    public static final Icon ICON_MAPPED = UIUtil.ICON_WARN;
    public static final Icon ICON_MAPPED_SAME = UIUtil.ICON_INFO;
    public static final Icon ICON_CONFLICT = UIUtil.ICON_ERR;
    public static final Color COLOR_MATCHED = new Color(0xCCFFCC);
    protected static Color COLOR_MATCHED_SELECTED = null;
    protected Device mChildDevice;
    protected DeviceTemplate mParentTemplate;
    protected AHistoryTextField mTxtChildRegex;
    protected BulkCreateChildNetList mLstChildNets;
    protected AHistoryTextField mTxtParentRegex;
    protected JList<String> mLstParentNames;
    protected JLabel mStatus;
    protected String mStatusExt;
    protected NetMapBulkUI.NetListModel mAllChildNets = new NetMapBulkUI.NetListModel();
    protected NetMapBulkUI.NetListModel mSelectedChildNets = new NetMapBulkUI.NetListModel();
    protected JCheckBox mIgnoreCaseSelect;
    protected ArrayList<List<String>> mCapturedValues = new ArrayList();
    protected DefaultListModel<String> mParentNames = new DefaultListModel();
    protected BiMap<Net, String> mChildNet2ParentName = HashBiMap.create();
    protected int mOldToolTipDismissDelay;
    protected AHistoryTextField.UpdateListener mParentSelectorChange = new AHistoryTextField.UpdateListener(){

        @Override
        public void update(AHistoryTextField.UpdateHint hint) {
            NetMapBulkCreateUI.this.updateParentNames();
            if (hint == AHistoryTextField.UpdateHint.ACTION) {
                NetMapBulkCreateUI.this.mTxtParentRegex.saveCurrentEntryToHistory();
            }
        }
    };
    protected AHistoryTextField.UpdateListener mChildMatcherChange = new AHistoryTextField.UpdateListener(){

        @Override
        public void update(AHistoryTextField.UpdateHint hint) {
            NetMapBulkCreateUI.this.setStatus(null);
            NetMapBulkCreateUI.this.updateSelectedChildNets();
            if (hint == AHistoryTextField.UpdateHint.ACTION) {
                NetMapBulkCreateUI.this.mTxtChildRegex.saveCurrentEntryToHistory();
            }
        }
    };
    protected ListSelectionListener mChildSelectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            Net netChild = (Net)NetMapBulkCreateUI.this.mLstChildNets.getSelectedValue();
            if (netChild == null) {
                return;
            }
            String parentName = (String)NetMapBulkCreateUI.this.mChildNet2ParentName.get((Object)netChild);
            if (parentName == null) {
                NetMapBulkCreateUI.this.mLstParentNames.clearSelection();
            } else {
                int idx = NetMapBulkCreateUI.this.mParentNames.indexOf(parentName);
                if (idx != -1) {
                    NetMapBulkCreateUI.this.mLstParentNames.setSelectedIndex(idx);
                    NetMapBulkCreateUI.this.mLstParentNames.ensureIndexIsVisible(idx);
                }
            }
        }
    };
    protected ListSelectionListener mParentSelectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            String parentName = NetMapBulkCreateUI.this.mLstParentNames.getSelectedValue();
            if (parentName == null) {
                return;
            }
            Net netChild = (Net)NetMapBulkCreateUI.this.mChildNet2ParentName.inverse().get((Object)parentName);
            if (netChild == null) {
                assert (false) : "Unmatched parent name in parent name list.";
                NetMapBulkCreateUI.this.mLstChildNets.clearSelection();
            } else {
                NetMapBulkUI.NetListModel nlm = (NetMapBulkUI.NetListModel)NetMapBulkCreateUI.this.mLstChildNets.getModel();
                int idx = nlm.mNets.indexOf(netChild);
                if (idx != -1) {
                    NetMapBulkCreateUI.this.mLstChildNets.setSelectedIndex(idx);
                    NetMapBulkCreateUI.this.mLstChildNets.ensureIndexIsVisible(idx);
                }
            }
        }
    };
    protected ActionListener mApplyListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DeviceTemplate.NetFilter childFilter = NetMapBulkCreateUI.this.mLstChildNets.getNetFilter();
            Object result = Cp.exec((String)"NetMap.bulkCreateParentNets(curDb(), \"%s\", %s, \"%s\", %d, \"%s\")", (Object[])new Object[]{NetMapBulkCreateUI.this.mChildDevice.getKeyStr(), childFilter == null ? "null" : childFilter.getScriptRef(), NetMapBulkCreateUI.this.getChildRegex(), NetMapBulkCreateUI.this.getChildRegexFlags(), NetMapBulkCreateUI.this.getParentRegex()});
            long mapped = 0L;
            if (result instanceof Long) {
                mapped = (Long)result;
                String msg = mapped == 1L ? "1 new net mapped." : String.format("%d new nets mapped.", mapped);
                ALog.logInfo((String)msg);
                NetMapBulkCreateUI.this.setStatus(msg);
            } else {
                ALog.logWarn((Throwable)new Throwable(), (String)"Unexpected result returned from NetMap.bulkCreateParentNets(): %s", (Object[])new Object[]{"" + result});
                NetMapBulkCreateUI.this.setStatus("Unexpected result returned from NetMap.bulkCreateParentNets() command.");
            }
            NetMapBulkCreateUI.this.mTxtChildRegex.saveCurrentEntryToHistory();
            NetMapBulkCreateUI.this.mTxtParentRegex.saveCurrentEntryToHistory();
            NetMapBulkCreateUI.this.repaint();
        }
    };
    protected DefaultListCellRenderer mChildListCellRenderer = new DefaultListCellRenderer(){

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Net existingParent;
            String parentName;
            super.getListCellRendererComponent(list, (Object)null, index, isSelected, cellHasFocus);
            Net net = (Net)value;
            this.setText(net.getName());
            Object toolTip = String.format("<b>%s</b>", net.getName());
            if (NetMapBulkCreateUI.this.mCapturedValues.size() > index) {
                List<String> values = NetMapBulkCreateUI.this.mCapturedValues.get(index);
                for (int i = 0; i < values.size(); ++i) {
                    if (i == 0) {
                        toolTip = (String)toolTip + "<br>Captured values:";
                    }
                    toolTip = (String)toolTip + String.format("<br>&nbsp;&nbsp;&nbsp;%%%d: '%s'", i, values.get(i));
                }
            }
            if ((parentName = (String)NetMapBulkCreateUI.this.mChildNet2ParentName.get((Object)net)) != null) {
                if (isSelected) {
                    if (COLOR_MATCHED_SELECTED == null) {
                        COLOR_MATCHED_SELECTED = AColor.mix((Color)this.getBackground(), (Color)COLOR_MATCHED, (float)0.8f);
                    }
                    this.setBackground(COLOR_MATCHED_SELECTED);
                } else {
                    this.setBackground(COLOR_MATCHED);
                }
                if (((String)toolTip).length() > 0) {
                    toolTip = (String)toolTip + "<br>";
                }
                toolTip = (String)toolTip + "Will create and map to: " + parentName;
            }
            if ((existingParent = NetMap.getParentNet((Device)NetMapBulkCreateUI.this.mChildDevice, (Net)net)) != null) {
                if (!existingParent.getName().equals(parentName)) {
                    this.setIcon(ICON_MAPPED);
                    toolTip = (String)toolTip + "<br>Currently mapped to: " + existingParent.getName();
                } else {
                    this.setIcon(ICON_MAPPED_SAME);
                    toolTip = (String)toolTip + "<br>Already mapped to: " + existingParent.getName();
                }
            }
            this.setToolTipText("<html>" + (String)toolTip + "</html>");
            return this;
        }
    };
    protected DefaultListCellRenderer mParentListCellRenderer = new DefaultListCellRenderer(){

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Net childNet;
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            String parentName = (String)value;
            this.setText(parentName);
            Object toolTip = String.format("<b>%s</b>", parentName);
            Net existingParent = NetMapBulkCreateUI.this.mParentTemplate.getNet(parentName);
            if (existingParent != null) {
                this.setIcon(ICON_CONFLICT);
                toolTip = (String)toolTip + "<br>Net already exists: " + existingParent.getName();
            }
            if ((childNet = (Net)NetMapBulkCreateUI.this.mChildNet2ParentName.inverse().get((Object)parentName)) != null) {
                if (isSelected) {
                    if (COLOR_MATCHED_SELECTED == null) {
                        COLOR_MATCHED_SELECTED = AColor.mix((Color)this.getBackground(), (Color)COLOR_MATCHED, (float)0.8f);
                    }
                    this.setBackground(COLOR_MATCHED_SELECTED);
                } else {
                    this.setBackground(COLOR_MATCHED);
                }
                if (((String)toolTip).length() > 0) {
                    toolTip = (String)toolTip + "<br>";
                }
                toolTip = (String)toolTip + "Created from: " + childNet.getName();
            } else assert (false) : "No matching child net found.";
            this.setToolTipText("<html>" + (String)toolTip + "</html>");
            return this;
        }
    };

    public static void bulkMap(Component owner, Device child) {
        NetMapBulkCreateUI dlg = new NetMapBulkCreateUI(owner, child);
        dlg.pack();
        dlg.setVisible(true);
    }

    public NetMapBulkCreateUI(Component owner, Device childDevice) {
        super(owner, "Bulk Net Creation", Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle(String.format("Bulk Creation Parent Nets - %s", childDevice.getName()));
        this.mChildDevice = childDevice;
        this.mParentTemplate = childDevice.getParent();
        GridBagManager l = GridBagManager.layout((Container)this.getContentPane());
        l.pushFill();
        l.pushFill(this.mChildDevice.getName());
        l.add("Selector:");
        this.mTxtChildRegex = new AHistoryTextField("MRU", "BulkNetMap_Matcher", 12);
        l.add((Component)((Object)this.mTxtChildRegex), (GridBagConstraints)GridBagManager.FILLX);
        l.add((Component)new APatternHelpButton(), (GridBagConstraints)GridBagManager.RIGHT);
        this.mTxtChildRegex.setMinimumSize(this.mTxtChildRegex.getPreferredSize());
        this.mTxtChildRegex.setUpdateListener(this.mChildMatcherChange);
        this.mTxtChildRegex.setInvokeActionOnTextUpdate(true);
        this.mTxtChildRegex.setAutoSave(false);
        l.newline();
        l.add("Selected:", (GridBagConstraints)GridBagManager.TOPLEFT);
        this.mLstChildNets = new BulkCreateChildNetList();
        JScrollPane spChildNets = new JScrollPane(this.mLstChildNets);
        l.add((Component)spChildNets, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        this.mLstChildNets.setSelectionMode(0);
        this.mLstChildNets.getSelectionModel().addListSelectionListener(this.mChildSelectionListener);
        this.mLstChildNets.setCellRenderer(this.mChildListCellRenderer);
        l.newline();
        this.mIgnoreCaseSelect = new JCheckBox("Case insensitive match");
        l.add((Component)this.mIgnoreCaseSelect, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
        this.mIgnoreCaseSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NetMapBulkCreateUI.this.updateSelectedChildNets();
            }
        });
        l.pop();
        l.pushFill(this.mParentTemplate.getName());
        l.add("Name Pattern:");
        this.mTxtParentRegex = new AHistoryTextField("MRU", "BulkNetMap_Selector", 12);
        l.add((Component)((Object)this.mTxtParentRegex), (GridBagConstraints)GridBagManager.FILLX);
        l.add((Component)new APatternHelpButton(), (GridBagConstraints)GridBagManager.RIGHT);
        this.mTxtParentRegex.setMinimumSize(this.mTxtParentRegex.getPreferredSize());
        this.mTxtParentRegex.setUpdateListener(this.mParentSelectorChange);
        this.mTxtParentRegex.setInvokeActionOnTextUpdate(true);
        this.mTxtParentRegex.setAutoSave(false);
        l.newline();
        l.add("New Name:", (GridBagConstraints)GridBagManager.TOPLEFT);
        this.mLstParentNames = new JList<String>(this.mParentNames);
        JScrollPane spParentNets = new JScrollPane(this.mLstParentNames);
        l.add((Component)spParentNets, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        this.mLstParentNames.setSelectionMode(0);
        this.mLstParentNames.getSelectionModel().addListSelectionListener(this.mParentSelectionListener);
        this.mLstParentNames.setCellRenderer(this.mParentListCellRenderer);
        l.pop();
        Container mainPanel = l.getCurrentContainer();
        Dimension d = mainPanel.getPreferredSize();
        d.height *= 3;
        mainPanel.setPreferredSize(d);
        l.pop();
        l.newline();
        l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
        this.mStatus = new JLabel();
        l.add((Component)this.mStatus, (GridBagConstraints)GridBagManager.FILLX);
        JButton btnApply = new JButton("Create");
        l.add((Component)btnApply, (GridBagConstraints)GridBagManager.RIGHT);
        btnApply.addActionListener(this.mApplyListener);
        JButton btnClose = new JButton("Close");
        l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, null);
        this.pack();
        UIUtil.center((Component)((Object)this));
        this.mTxtChildRegex.setText("(.*)");
        this.mTxtParentRegex.setText("{1}");
        this.updateAllChildNets();
        this.updateParentNames();
    }

    public void addNotify() {
        super.addNotify();
        this.mOldToolTipDismissDelay = ToolTipManager.sharedInstance().getDismissDelay();
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
    }

    public void removeNotify() {
        ToolTipManager.sharedInstance().setDismissDelay(this.mOldToolTipDismissDelay);
        super.removeNotify();
    }

    protected String expandChildRegex(String childRegex) {
        if (!(((String)childRegex).contains("\\") || ((String)childRegex).contains(".") || ((String)childRegex).contains("[") || ((String)childRegex).contains("$"))) {
            childRegex = (String)childRegex + ".*";
        }
        return childRegex;
    }

    protected String getChildRegex() {
        String childRegex = this.mTxtChildRegex.getText();
        childRegex = this.expandChildRegex(childRegex);
        return childRegex;
    }

    protected int getChildRegexFlags() {
        int flags = 0;
        if (this.mIgnoreCaseSelect.isSelected()) {
            flags |= 2;
        }
        return flags;
    }

    protected String getParentRegex() {
        String regex = this.mTxtParentRegex.getText();
        return regex;
    }

    protected void updateAllChildNets() {
        this.mAllChildNets.clear();
        for (Net n : this.mChildDevice.getNets()) {
            if (n.isUnused() || !NetMapBulkUI.include(this.mLstChildNets.getNetFilter(), n)) continue;
            this.mAllChildNets.add(n);
        }
        this.mAllChildNets.sort();
        this.updateSelectedChildNets();
    }

    protected void updateSelectedChildNets() {
        this._updateSelectedChildNets();
        this.updateParentNames();
    }

    protected void _updateSelectedChildNets() {
        String selector = this.mTxtChildRegex.getText();
        if (selector.length() == 0) {
            this.mLstChildNets.setModel((ListModel)this.mAllChildNets);
            this.setStatus("All child nets displayed.");
            return;
        }
        this.mSelectedChildNets.clear();
        this.mCapturedValues.clear();
        selector = this.expandChildRegex(selector);
        int flags = this.getChildRegexFlags();
        try {
            Pattern pattern = Pattern.compile(selector, flags);
            for (Net n : this.mAllChildNets.mNets) {
                Matcher matcher;
                String val = n.getName();
                if (val == null) {
                    val = "";
                }
                if (!(matcher = pattern.matcher(val)).matches()) continue;
                this.mSelectedChildNets.add(n);
                int groupCount = matcher.groupCount();
                ArrayList<String> curValues = new ArrayList<String>();
                this.mCapturedValues.add(curValues);
                for (int i = 0; i <= groupCount; ++i) {
                    curValues.add(matcher.group(i));
                }
            }
            this.mLstChildNets.setModel((ListModel)this.mSelectedChildNets);
            this.setStatus("Child nets selected.");
            if (this.mCapturedValues.size() > 0) {
                int groupCount = this.mCapturedValues.get(0).size();
                if (groupCount == 1) {
                    this.addStatus("Captured 1 value per child net.");
                } else {
                    this.addStatus("Captured %d values per child net.", groupCount);
                }
            }
        }
        catch (PatternSyntaxException e) {
            this.setStatus("Invalid child net pattern, all child nets displayed, no mapping performed.");
            this.mParentNames.clear();
            return;
        }
    }

    protected void updateParentNames() {
        this.mParentNames.clear();
        this.mChildNet2ParentName.clear();
        String regex = this.mTxtParentRegex.getText();
        if (regex.length() == 0) {
            this.addStatus("No parent pattern specified, no mapping to perform.");
            return;
        }
        if (this.mCapturedValues.size() == 0) {
            this.addStatus("No child name values captured, no mapping to perform.");
            return;
        }
        NetMap.generateNames(this.mSelectedChildNets.getList(), (String)regex, this.mCapturedValues, (NetMap.GenerateNameNotification)new NetMap.GenerateNameNotification(){

            public void generate(Net refNet, String newName) {
                NetMapBulkCreateUI.this.mChildNet2ParentName.put((Object)refNet, (Object)newName);
                NetMapBulkCreateUI.this.mParentNames.addElement(newName);
            }
        });
        this.mLstParentNames.repaint();
        this.mLstChildNets.repaint();
        this.addStatus("Parent net names updated.");
    }

    protected NetMapBulkUI.NetListModel getChildNetListModel() {
        return this.mLstChildNets.getNetListModel();
    }

    protected void setStatus(String text) {
        if (this.mStatus == null) {
            return;
        }
        this.mStatus.setIcon(null);
        this.mStatus.setText(text == null ? "" : text);
        this.mStatus.setToolTipText(text);
        this.mStatusExt = null;
    }

    protected void addStatus(String text) {
        if (this.mStatus == null) {
            return;
        }
        if (this.mStatus.getText().length() == 0) {
            this.setStatus(text);
            return;
        }
        if (this.mStatus.getIcon() == null) {
            this.mStatus.setIcon(ICON_MORE);
            this.mStatusExt = this.mStatus.getText();
        }
        this.mStatusExt = this.mStatusExt + "<br>" + text;
        this.mStatus.setToolTipText(String.format("<html>%s</html>", this.mStatusExt));
    }

    protected void addStatus(String format, Object ... args) {
        this.addStatus(String.format(format, args));
    }

    public class BulkCreateChildNetList
    extends NetMapBulkUI.NetList {
        public BulkCreateChildNetList() {
            this.mNetFilter = OrbitIO.getApp().getDefaultNetFilter();
        }

        @Override
        public void setNetFilter(DeviceTemplate.NetFilter nf) {
            super.setNetFilter(nf);
            NetMapBulkCreateUI.this.updateAllChildNets();
        }
    }
}

