/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AColor;
import com.sigrity.acl.ALog;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AHistoryTextField;
import com.sigrity.acl.ui.APatternHelpButton;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.NetFilters;
import com.sigrity.orbit.OrbitIO;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class NetMapBulkUI {
    public static final Icon ICON_MORE = UIUtil.ICON_MORE;
    public static final Icon ICON_MAPPED = UIUtil.ICON_WARN;
    public static final Icon ICON_MAPPED_SAME = UIUtil.ICON_INFO;
    protected static Color COLOR_MATCHED = new Color(0xCCFFCC);
    protected static Color COLOR_MATCHED_SELECTED = null;

    public static void bulkMap(Component owner, Device child) {
        BulkMapDlg dlg = new BulkMapDlg(owner, child);
        dlg.pack();
        dlg.setVisible(true);
    }

    protected static boolean include(DeviceTemplate.NetFilter filter, Net n) {
        return filter == null || filter.include(n);
    }

    public static class ParentChildrenNetMap {
        protected HashMap<Net, ArrayList<Net>> mParent2Children = new HashMap();
        protected HashMap<Net, Net> mChild2Parent = new HashMap();

        public void clear() {
            this.mParent2Children.clear();
            this.mChild2Parent.clear();
        }

        public void put(Net parent, Net child) {
            ArrayList<Object> children;
            Net oldParent = this.mChild2Parent.put(child, parent);
            if (oldParent != null) {
                children = this.mParent2Children.get(oldParent);
                children.remove(child);
            }
            if ((children = this.mParent2Children.get(parent)) == null) {
                children = new ArrayList();
                this.mParent2Children.put(parent, children);
            }
            children.add(child);
        }

        public ArrayList<Net> getChildren(Net parent) {
            return this.mParent2Children.get(parent);
        }

        public Net getParent(Net child) {
            return this.mChild2Parent.get(child);
        }

        public Set<Net> getAllParents() {
            return this.mParent2Children.keySet();
        }
    }

    protected static class NetListModel
    extends AbstractListModel<Net> {
        protected LinkedList<Net> mNets = new LinkedList();

        protected NetListModel() {
        }

        @Override
        public Net getElementAt(int index) {
            return this.mNets.get(index);
        }

        @Override
        public int getSize() {
            return this.mNets.size();
        }

        public void clear() {
            int oldLen = this.mNets.size();
            if (oldLen == 0) {
                return;
            }
            this.mNets.clear();
            this.fireIntervalRemoved(this, 0, oldLen - 1);
        }

        public void add(Net n) {
            this.mNets.add(n);
            this.fireIntervalAdded(this, this.mNets.size() - 1, this.mNets.size() - 1);
        }

        public void sort() {
            Collections.sort(this.mNets, Net.NameComparator);
            this.fireContentsChanged(this, 0, this.mNets.size() - 1);
        }

        public Net getNetAt(int index) {
            return this.mNets.get(index);
        }

        public List<Net> getList() {
            return Collections.unmodifiableList(this.mNets);
        }
    }

    protected static class NetList
    extends JList<Net> {
        protected DeviceTemplate.NetFilter mNetFilter = OrbitIO.getApp().getDefaultNetFilter();

        public NetList() {
            this.setModel(new NetListModel());
            UIUtil.installPopupMenu((Component)this, (UIUtil.APopupMenuProvider)new UIUtil.APopupMenuProvider(){

                public JPopupMenu getMenu(Component c, int x, int y) {
                    JPopupMenu popup = new JPopupMenu();
                    JMenu filterMenu = new JMenu("Filter Nets");
                    popup.add(filterMenu);
                    for (final DeviceTemplate.NetFilter nf : OrbitIO.getApp().getNetFilters()) {
                        filterMenu.add(new JCheckBoxMenuItem(new AbstractAction(nf.getName()){
                            {
                                super(arg0);
                                this.putValue("ShortDescription", nf.getDescription());
                                if (NetFilters.equals((DeviceTemplate.NetFilter)this.getNetFilter(), (DeviceTemplate.NetFilter)nf)) {
                                    this.putValue("SwingSelectedKey", true);
                                }
                            }

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                this.setNetFilter(nf);
                            }
                        }));
                    }
                    return popup;
                }
            });
        }

        public NetListModel getNetListModel() {
            return (NetListModel)this.getModel();
        }

        @Override
        public void setModel(ListModel<Net> model) {
            if (model == this.getModel()) {
                return;
            }
            super.setModel(model);
        }

        public void setNetFilter(DeviceTemplate.NetFilter nf) {
            this.mNetFilter = nf;
        }

        public DeviceTemplate.NetFilter getNetFilter() {
            return this.mNetFilter;
        }
    }

    public static class BulkMapDlg
    extends ADialog {
        protected DeviceTemplate mParentTemplate;
        protected Device mChildDevice;
        protected AHistoryTextField mTxtParentRegex;
        protected NetList mLstParentNets;
        protected AHistoryTextField mTxtChildRegex;
        protected NetList mLstChildNets;
        protected JLabel mStatus;
        protected String mStatusExt;
        protected NetListModel mAllParentNets = new NetListModel();
        protected NetListModel mSelectedParentNets = new NetListModel();
        protected List<List<String>> mCapturedValues = new ArrayList<List<String>>();
        protected JCheckBox mIgnoreCaseSelect;
        protected NetListModel mAllChildNets = new NetListModel();
        protected NetListModel mMatchedChildNets = new NetListModel();
        protected JCheckBox mIngoreCaseMatch;
        protected boolean mUpdatingSelection = false;
        protected ParentChildrenNetMap mMap = new ParentChildrenNetMap();
        protected int mOldToolTipDismissDelay;
        protected AHistoryTextField.UpdateListener mParentSelectorChange = new AHistoryTextField.UpdateListener(){

            @Override
            public void update(AHistoryTextField.UpdateHint hint) {
                this.updateSelectedParentNets();
                if (hint == AHistoryTextField.UpdateHint.ACTION) {
                    mTxtParentRegex.saveCurrentEntryToHistory();
                }
            }
        };
        protected AHistoryTextField.UpdateListener mChildMatcherChange = new AHistoryTextField.UpdateListener(){

            @Override
            public void update(AHistoryTextField.UpdateHint hint) {
                this.setStatus(null);
                this.updateMatchedChildNets();
                if (hint == AHistoryTextField.UpdateHint.ACTION) {
                    mTxtChildRegex.saveCurrentEntryToHistory();
                }
            }
        };
        protected ListSelectionListener mParentSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting() || mUpdatingSelection) {
                    return;
                }
                Net netParent = (Net)mLstParentNets.getSelectedValue();
                if (netParent == null) {
                    return;
                }
                mUpdatingSelection = true;
                ArrayList<Net> children = mMap.getChildren(netParent);
                mLstChildNets.clearSelection();
                if (children != null) {
                    NetListModel nlm = (NetListModel)mLstChildNets.getModel();
                    for (Net child : children) {
                        int idx = nlm.mNets.indexOf(child);
                        if (idx == -1) continue;
                        mLstChildNets.addSelectionInterval(idx, idx);
                        mLstChildNets.ensureIndexIsVisible(idx);
                    }
                }
                mUpdatingSelection = false;
            }
        };
        protected ListSelectionListener mChildSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting() || mUpdatingSelection) {
                    return;
                }
                Net netChild = (Net)mLstChildNets.getSelectedValue();
                if (netChild == null) {
                    return;
                }
                mUpdatingSelection = true;
                mLstChildNets.clearSelection();
                mLstChildNets.setSelectedValue(netChild, true);
                Net netParent = mMap.getParent(netChild);
                mLstParentNets.clearSelection();
                if (netParent != null) {
                    NetListModel nlm = (NetListModel)mLstParentNets.getModel();
                    int idx = nlm.mNets.indexOf(netParent);
                    if (idx != -1) {
                        mLstParentNets.setSelectedIndex(idx);
                        mLstParentNets.ensureIndexIsVisible(idx);
                    }
                }
                mUpdatingSelection = false;
            }
        };
        protected ActionListener mApplyListener = e -> {
            Object result;
            DeviceTemplate.NetFilter parentFilter = this.mLstParentNets.getNetFilter();
            DeviceTemplate.NetFilter childFilter = this.mLstChildNets.getNetFilter();
            Db db = OrbitIO.getCurDb();
            DbHistory history = db.getHistory();
            try (DbHistory.DbTransaction transaction = history.newDbTransaction("Bulk Net Map");){
                result = Cp.exec((String)"NetMap.bulkMap(curDb(), \"%s\", \"%s\", %d, \"%s\", %d, %s, %s)", (Object[])new Object[]{this.mChildDevice.getKeyStr(), this.getParentRegex(), this.getParentRegexFlags(), this.getChildRegex(), this.getChildRegexFlags(), parentFilter == null ? "null" : parentFilter.getScriptRef(), childFilter == null ? "null" : childFilter.getScriptRef()});
            }
            long mapped = 0L;
            if (result instanceof Long) {
                mapped = (Long)result;
                String msg = mapped == 1L ? "1 net mapped." : String.format("%d nets mapped.", mapped);
                ALog.logInfo((String)msg);
                this.setStatus(msg);
            } else {
                ALog.logWarn((Throwable)new Throwable(), (String)"Unexpected result returned from NetMap.bulkMap(): %s", (Object[])new Object[]{"" + result});
                this.setStatus("Unexpected result returned from NetMap.bulkMap() command.");
            }
            this.mTxtParentRegex.saveCurrentEntryToHistory();
            this.mTxtChildRegex.saveCurrentEntryToHistory();
            this.repaint();
        };

        public BulkMapDlg(Component owner, Device childDevice) {
            super(owner, "Bulk Net Mapping", Dialog.ModalityType.APPLICATION_MODAL);
            this.setTitle(String.format("Bulk Net Mapping - %s", childDevice.getName()));
            this.mChildDevice = childDevice;
            this.mParentTemplate = childDevice.getParent();
            GridBagManager l = GridBagManager.layout((Container)this.getContentPane());
            l.pushFill();
            l.pushFill(this.mParentTemplate.getName());
            l.add("Selector:");
            this.mTxtParentRegex = new AHistoryTextField("MRU", "BulkNetMap_Selector", 12);
            l.add((Component)((Object)this.mTxtParentRegex), (GridBagConstraints)GridBagManager.FILLX);
            l.add((Component)new APatternHelpButton(), (GridBagConstraints)GridBagManager.RIGHT);
            this.mTxtParentRegex.setMinimumSize(this.mTxtParentRegex.getPreferredSize());
            this.mTxtParentRegex.setUpdateListener(this.mParentSelectorChange);
            this.mTxtParentRegex.setInvokeActionOnTextUpdate(true);
            this.mTxtParentRegex.setAutoSave(false);
            l.newline();
            l.add("Selected:", (GridBagConstraints)GridBagManager.TOPLEFT);
            this.mLstParentNets = new ParentNetList();
            JScrollPane spParentNets = new JScrollPane(this.mLstParentNets);
            l.add((Component)spParentNets, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            this.mLstParentNets.setSelectionMode(0);
            this.mLstParentNets.getSelectionModel().addListSelectionListener(this.mParentSelectionListener);
            new ParentRenderer(this.mLstParentNets);
            l.newline();
            this.mIgnoreCaseSelect = new JCheckBox("Case insensitive select");
            l.add((Component)this.mIgnoreCaseSelect, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            this.mIgnoreCaseSelect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.updateSelectedParentNets();
                }
            });
            l.pop();
            l.pushFill(this.mChildDevice.getName());
            l.add("Matcher:");
            this.mTxtChildRegex = new AHistoryTextField("MRU", "BulkNetMap_Matcher", 12);
            l.add((Component)((Object)this.mTxtChildRegex), (GridBagConstraints)GridBagManager.FILLX);
            l.add((Component)new APatternHelpButton(), (GridBagConstraints)GridBagManager.RIGHT);
            this.mTxtChildRegex.setMinimumSize(this.mTxtChildRegex.getPreferredSize());
            this.mTxtChildRegex.setUpdateListener(this.mChildMatcherChange);
            this.mTxtChildRegex.setInvokeActionOnTextUpdate(true);
            this.mTxtChildRegex.setAutoSave(false);
            l.newline();
            l.add("Matched:", (GridBagConstraints)GridBagManager.TOPLEFT);
            this.mLstChildNets = new ChildNetList();
            JScrollPane spChildNets = new JScrollPane(this.mLstChildNets);
            l.add((Component)spChildNets, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            this.mLstChildNets.setSelectionMode(2);
            this.mLstChildNets.getSelectionModel().addListSelectionListener(this.mChildSelectionListener);
            new ChildRenderer(this.mLstChildNets);
            l.newline();
            this.mIngoreCaseMatch = new JCheckBox("Case insensitive match");
            l.add((Component)this.mIngoreCaseMatch, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            this.mIngoreCaseMatch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.updateMatchedChildNets();
                }
            });
            l.pop();
            Container mainPanel = l.getCurrentContainer();
            Dimension d = mainPanel.getPreferredSize();
            d.height *= 3;
            mainPanel.setPreferredSize(d);
            l.pop();
            l.newline();
            l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
            this.mStatus = new JLabel();
            l.add((Component)this.mStatus, (GridBagConstraints)GridBagManager.FILLX);
            JButton btnApply = new JButton("Map");
            l.add((Component)btnApply, (GridBagConstraints)GridBagManager.RIGHT);
            btnApply.addActionListener(this.mApplyListener);
            JButton btnClose = new JButton("Close");
            l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, null);
            this.pack();
            UIUtil.center((Component)((Object)this));
            this.mTxtParentRegex.setText("(.*)");
            this.mTxtChildRegex.setText("{1}");
            this.updateAllParentNets();
            this.updateAllChildNets();
        }

        public void addNotify() {
            super.addNotify();
            this.mOldToolTipDismissDelay = ToolTipManager.sharedInstance().getDismissDelay();
            ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        }

        public void removeNotify() {
            ToolTipManager.sharedInstance().setDismissDelay(this.mOldToolTipDismissDelay);
            super.removeNotify();
        }

        protected String expandParentRegex(String parentRegex) {
            if (!(((String)parentRegex).contains("\\") || ((String)parentRegex).contains(".") || ((String)parentRegex).contains("[") || ((String)parentRegex).contains("$"))) {
                parentRegex = (String)parentRegex + ".*";
            }
            return parentRegex;
        }

        protected String getParentRegex() {
            String parentRegex = this.mTxtParentRegex.getText();
            parentRegex = this.expandParentRegex(parentRegex);
            return parentRegex;
        }

        protected int getParentRegexFlags() {
            int flags = 0;
            if (this.mIgnoreCaseSelect.isSelected()) {
                flags |= 2;
            }
            return flags;
        }

        protected String getChildRegex() {
            String regex = this.mTxtChildRegex.getText();
            return regex;
        }

        protected int getChildRegexFlags() {
            int flags = 0;
            if (this.mIngoreCaseMatch.isSelected()) {
                flags |= 2;
            }
            return flags;
        }

        protected void updateAllParentNets() {
            this.mAllParentNets.clear();
            for (Net n : this.mParentTemplate.getNets(this.mLstParentNets.getNetFilter(), false)) {
                this.mAllParentNets.add(n);
            }
            this.mAllParentNets.sort();
            this.updateSelectedParentNets();
        }

        protected void updateSelectedParentNets() {
            this._updateSelectedParentNets();
            this.updateMatchedChildNets();
        }

        protected void _updateSelectedParentNets() {
            String selector = this.mTxtParentRegex.getText();
            if (selector.length() == 0) {
                this.mLstParentNets.setModel(this.mAllParentNets);
                this.setStatus("All parent nets displayed.");
                return;
            }
            this.mSelectedParentNets.clear();
            this.mCapturedValues.clear();
            selector = this.expandParentRegex(selector);
            int flags = this.getParentRegexFlags();
            try {
                Pattern pattern = Pattern.compile(selector, flags);
                for (Net n : this.mAllParentNets.mNets) {
                    Matcher matcher;
                    String val = n.getName();
                    if (val == null) {
                        val = "";
                    }
                    if (!(matcher = pattern.matcher(val)).matches()) continue;
                    this.mSelectedParentNets.add(n);
                    int groupCount = matcher.groupCount();
                    ArrayList<String> curValues = new ArrayList<String>();
                    this.mCapturedValues.add(curValues);
                    for (int i = 0; i <= groupCount; ++i) {
                        curValues.add(matcher.group(i));
                    }
                }
                this.mLstParentNets.setModel(this.mSelectedParentNets);
                this.setStatus("Parent nets selected.");
                if (this.mCapturedValues.size() > 0) {
                    int groupCount = this.mCapturedValues.get(0).size();
                    if (groupCount == 1) {
                        this.addStatus("Captured 1 value per parent net.");
                    } else {
                        this.addStatus("Captured %d values per parent net.", groupCount);
                    }
                }
            }
            catch (PatternSyntaxException e) {
                this.setStatus("Invalid parent net pattern, all nets displayed.");
                this.mLstParentNets.setModel(this.mAllParentNets);
                return;
            }
        }

        protected void updateAllChildNets() {
            this.mAllChildNets.clear();
            for (Net n : this.mChildDevice.getNets()) {
                if (n.isUnused() || !NetMapBulkUI.include(this.mLstChildNets.getNetFilter(), n)) continue;
                this.mAllChildNets.add(n);
            }
            this.mAllChildNets.sort();
            this.updateMatchedChildNets();
        }

        protected void updateMatchedChildNets() {
            if (this.mTxtChildRegex == null) {
                return;
            }
            UpdateMatchedChildNets updater = new UpdateMatchedChildNets();
            updater.run();
            this.mLstParentNets.repaint();
            this.addStatus("Child nets matched.");
        }

        protected NetListModel getParentNetListModel() {
            return this.mLstParentNets.getNetListModel();
        }

        protected NetListModel getChildNetListModel() {
            return this.mLstChildNets.getNetListModel();
        }

        protected void setStatus(String text) {
            if (this.mStatus == null) {
                return;
            }
            this.mStatus.setIcon(null);
            this.mStatus.setText(text == null ? "" : text);
            this.mStatus.setToolTipText(text);
            this.mStatusExt = null;
        }

        protected void addStatus(String text) {
            if (this.mStatus == null) {
                return;
            }
            if (this.mStatus.getText().length() == 0) {
                this.setStatus(text);
                return;
            }
            if (this.mStatus.getIcon() == null) {
                this.mStatus.setIcon(ICON_MORE);
                this.mStatusExt = this.mStatus.getText();
            }
            this.mStatusExt = this.mStatusExt + "<br>" + text;
            this.mStatus.setToolTipText(String.format("<html>%s</html>", this.mStatusExt));
        }

        protected void addStatus(String format, Object ... args) {
            this.addStatus(String.format(format, args));
        }

        protected class ChildNetList
        extends NetList {
            public ChildNetList() {
                this.setCellRenderer(new ChildRenderer(this));
            }

            @Override
            public void setNetFilter(DeviceTemplate.NetFilter nf) {
                super.setNetFilter(nf);
                BulkMapDlg.this.updateAllChildNets();
            }
        }

        protected class ParentNetList
        extends NetList {
            public ParentNetList() {
                this.setCellRenderer(new ParentRenderer(this));
            }

            @Override
            public void setNetFilter(DeviceTemplate.NetFilter nf) {
                super.setNetFilter(nf);
                BulkMapDlg.this.updateAllParentNets();
            }
        }

        protected class ChildRenderer
        extends DefaultListCellRenderer {
            protected NetList mNetList;

            public ChildRenderer(NetList nl) {
                this.mNetList = nl;
            }

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                Net net = (Net)value;
                this.setText(net.getName());
                Net parent = BulkMapDlg.this.mMap.getParent(net);
                if (isSelected && parent != null) {
                    if (COLOR_MATCHED_SELECTED == null) {
                        COLOR_MATCHED_SELECTED = AColor.mix((Color)this.getBackground(), (Color)COLOR_MATCHED, (float)0.8f);
                    }
                    this.setBackground(COLOR_MATCHED_SELECTED);
                } else if (parent != null) {
                    this.setBackground(COLOR_MATCHED);
                } else if (isSelected) {
                    // empty if block
                }
                Object tt = String.format("<b>%s</b>", net.getName());
                tt = (String)tt + "<br>Will map to: " + (parent == null ? "" : parent.getName());
                Net existingParent = NetMap.getParentNet((Device)BulkMapDlg.this.mChildDevice, (Net)net);
                if (existingParent != null) {
                    if (existingParent != parent) {
                        this.setIcon(ICON_MAPPED);
                        tt = (String)tt + "<br>Currently mapped to: " + existingParent.getName();
                    } else {
                        this.setIcon(ICON_MAPPED_SAME);
                        tt = (String)tt + "<br>Already mapped to: " + existingParent.getName();
                    }
                }
                this.setToolTipText("<html>" + (String)tt + "</html>");
                return this;
            }
        }

        protected class ParentRenderer
        extends DefaultListCellRenderer {
            protected NetList mNetList;

            public ParentRenderer(NetList nl) {
                this.mNetList = nl;
            }

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                boolean hasMappedChildren;
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                Net net = (Net)value;
                this.setText(net.getName());
                ArrayList<Net> children = BulkMapDlg.this.mMap.getChildren(net);
                boolean bl = hasMappedChildren = children != null && children.size() > 0;
                if (isSelected && hasMappedChildren) {
                    if (COLOR_MATCHED_SELECTED == null) {
                        COLOR_MATCHED_SELECTED = AColor.mix((Color)this.getBackground(), (Color)COLOR_MATCHED, (float)0.8f);
                    }
                    this.setBackground(COLOR_MATCHED_SELECTED);
                } else if (hasMappedChildren) {
                    this.setBackground(COLOR_MATCHED);
                } else if (isSelected) {
                    // empty if block
                }
                this.setToolTipText("<html>" + this.getToolTipText(net, children) + "</html>");
                return this;
            }

            public String getToolTipText(Net net, ArrayList<Net> children) {
                Object tt = String.format("<b>%s</b>", net.getName());
                tt = (String)tt + "<br>Captured values:";
                int idx = this.mNetList.getNetListModel().mNets.indexOf(net);
                if (BulkMapDlg.this.mCapturedValues.size() > idx) {
                    List<String> values = BulkMapDlg.this.mCapturedValues.get(idx);
                    for (int i = 0; i < values.size(); ++i) {
                        tt = (String)tt + String.format("<br>&nbsp;&nbsp;&nbsp;{%d}: '%s'", i, values.get(i));
                    }
                } else {
                    tt = (String)tt + "none";
                }
                if (children != null && children.size() > 0) {
                    tt = (String)tt + "<br>Matches: ";
                    for (Net child : children) {
                        tt = (String)tt + String.format("<br>&nbsp;&nbsp;&nbsp;%s", child.getName());
                    }
                }
                return tt;
            }
        }

        protected class UpdateMatchedChildNets
        implements Runnable {
            protected UpdateMatchedChildNets() {
            }

            @Override
            public void run() {
                BulkMapDlg.this.mMatchedChildNets.clear();
                BulkMapDlg.this.mMap.clear();
                BulkMapDlg.this.mLstChildNets.setModel(BulkMapDlg.this.mMatchedChildNets);
                String regex = BulkMapDlg.this.getChildRegex();
                if (regex.length() == 0) {
                    BulkMapDlg.this.addStatus("No child matcher specified, no mapping performed.");
                    return;
                }
                if (BulkMapDlg.this.mCapturedValues.size() == 0) {
                    BulkMapDlg.this.addStatus("No selected parent nets, no mapping performed.");
                    return;
                }
                int flags = BulkMapDlg.this.getChildRegexFlags();
                NetMap.matchNets(BulkMapDlg.this.mSelectedParentNets.mNets, BulkMapDlg.this.mAllChildNets.mNets, (String)regex, (int)flags, BulkMapDlg.this.mCapturedValues, (NetMap.MatchNetsNotification)new NetMap.MatchNetsNotification(){

                    public void match(Net parent, Net child) {
                        BulkMapDlg.this.mMatchedChildNets.add(child);
                        BulkMapDlg.this.mMap.put(parent, child);
                    }

                    public void error(String msg) {
                        BulkMapDlg.this.addStatus(msg);
                    }
                });
            }
        }
    }
}

