/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AStream;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.ui.AList;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.NetTable;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class NetMappingExportOptionsPanel
extends JPanel {
    protected DefaultMutableTreeNode mRoot = new DefaultMutableTreeNode("Substrates");
    protected JTree mSubstrateTree = new JTree(this.mRoot);
    protected AList<AList.AListItem> mChildDevices = new AList();
    protected JCheckBox mProducePicture = new JCheckBox("Save snapshot picture");
    protected JCheckBox mOpenHtml = new JCheckBox("Open report when complete");
    protected JRadioButton mCSV = new JRadioButton("CSV");
    protected JRadioButton mHTML = new JRadioButton("HTML");
    protected TreeSelectionListener mTreeListener = e -> this.createChildNodes();
    protected ActionListener mFormatChanged = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (NetMappingExportOptionsPanel.this.mCSV.isSelected()) {
                NetMappingExportOptionsPanel.this.mProducePicture.setEnabled(false);
            } else {
                NetMappingExportOptionsPanel.this.mProducePicture.setEnabled(true);
            }
        }
    };

    public NetMappingExportOptionsPanel() {
        this.init();
    }

    public boolean isProducePicture() {
        return this.mProducePicture.isSelected();
    }

    public boolean isOpenHtmlImmediately() {
        return this.mOpenHtml.isSelected();
    }

    public DevicePath getSelectedDevicePath() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.mSubstrateTree.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        SimpleDevicePathName n = (SimpleDevicePathName)node.getUserObject();
        return n.mDevicepath;
    }

    public List<DevicePath> getSelectedChildDevices() {
        LinkedList<DevicePath> ds = new LinkedList<DevicePath>();
        ListModel m = this.mChildDevices.getModel();
        for (int i = 0; i < m.getSize(); ++i) {
            AList.AListItem item = (AList.AListItem)m.getElementAt(i);
            if (!item.getIsSelected()) continue;
            Device d = (Device)item.getKey();
            ds.add(d.getADevicePath());
        }
        return ds;
    }

    protected void init() {
        this.mSubstrateTree.setCellRenderer(new IconRender());
        this.mProducePicture.setSelected(true);
        this.mOpenHtml.setSelected(true);
        this.createNodes(this.mRoot, null);
        this.expandAll(new TreePath(this.mRoot));
        if (this.mRoot.getChildCount() > 0) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)this.mRoot.getFirstChild();
            this.mSubstrateTree.setSelectionPath(new TreePath(n.getPath()));
        }
        this.mSubstrateTree.setRootVisible(false);
        this.mSubstrateTree.addTreeSelectionListener(this.mTreeListener);
        GridBagManager l = new GridBagManager((Container)this);
        l.pushFill("Output Format");
        l.add((Component)this.mCSV);
        l.add((Component)this.mHTML);
        UIUtil.groupButtons((AbstractButton[])new AbstractButton[]{this.mCSV, this.mHTML});
        this.mCSV.addActionListener(this.mFormatChanged);
        this.mHTML.addActionListener(this.mFormatChanged);
        l.popNl();
        l.pushFill("Substrate device");
        JScrollPane spSub = new JScrollPane(this.mSubstrateTree);
        spSub.setPreferredSize(new Dimension(200, 150));
        l.add((Component)spSub, (GridBagConstraints)GridBagManager.FILLALL);
        l.popNl();
        l.pushFill("Direct child devices :");
        l.newline();
        this.mChildDevices.setShowCheckBoxes(true);
        JScrollPane spChild = new JScrollPane(this.mChildDevices);
        spChild.setPreferredSize(new Dimension(200, 150));
        l.add((Component)spChild, (GridBagConstraints)GridBagManager.FILLALL);
        l.popNl();
        l.add((Component)this.mProducePicture, (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        l.add((Component)this.mOpenHtml, (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        this.createChildNodes();
        this.mHTML.setSelected(true);
    }

    public boolean isSelectedHTML() {
        return this.mHTML.isSelected();
    }

    protected void expandAll(TreePath parent) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(path);
            }
        }
        this.mSubstrateTree.expandPath(parent);
    }

    protected void createNodes(DefaultMutableTreeNode root, Device device) {
        Db db = OrbitIO.getApp().getCurrentDb();
        if (device == null) {
            Design design = Design.getDesign((Db)db);
            design.getRootDevices().stream().filter(NetTable::isSubstrate).sorted().forEach(d -> this.createNodes(root, (Device)d));
        } else {
            SimpleDevicePathName name = new SimpleDevicePathName(device.getADevicePath());
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(name);
            root.add(node);
            device.getChildren().stream().filter(NetTable::isSubstrate).sorted().forEach(cd -> this.createNodes(node, (Device)cd));
        }
    }

    protected void createChildNodes() {
        this.mChildDevices.removeAll();
        DevicePath path = this.getSelectedDevicePath();
        if (path == null) {
            return;
        }
        Vector v = new Vector();
        AStream.of((Iterable)path.getLast().getDescendants()).filter(NetTable::isSubstrate).sorted().forEach(d -> {
            Icon icon = DbExplorerPanel.getIconForTemplate(d.getTemplate());
            AList.AListItem i = new AList.AListItem(d.getName(), icon, d);
            i.setIsSelected(true);
            v.add(i);
        });
        this.mChildDevices.setListData(v);
        this.mChildDevices.updateUI();
    }

    protected class SimpleDevicePathName {
        protected DevicePath mDevicepath;

        SimpleDevicePathName(DevicePath path) {
            this.mDevicepath = path;
        }

        public String toString() {
            if (this.mDevicepath == null) {
                return "";
            }
            String name = this.mDevicepath.toString();
            int i = name.lastIndexOf("/");
            return name.substring(i + 1);
        }
    }

    protected class IconRender
    extends DefaultTreeCellRenderer {
        protected IconRender() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object o = node.getUserObject();
            if (o instanceof SimpleDevicePathName) {
                SimpleDevicePathName nodeInfo = (SimpleDevicePathName)o;
                Icon icon = DbExplorerPanel.getIconForTemplate(nodeInfo.mDevicepath.getLast().getTemplate());
                this.setIcon(icon);
            }
            return this;
        }
    }
}

