/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.orbit.OrbitIO;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class NetMappingExportUI {
    public static boolean showMe() {
        AFileChooser fc = new AFileChooser();
        ExportOptionsPanel options = new ExportOptionsPanel();
        fc.setDialogTitle("Export CSV Net Mapping");
        fc.setAccessory((JComponent)options);
        fc.setFileFilter((FileFilter)AFileFilter.CSV);
        if (fc.showSaveDialog((Component)OrbitIO.getMainWindow()) != 0) {
            return false;
        }
        File f = fc.getSelectedFile();
        Object path = f.getPath();
        if (!f.getName().contains(".")) {
            path = (String)path + ".csv";
        }
        ALog.logInfo((String)"Exporting Net Assignment to %s", (Object[])new Object[]{path});
        Cp.exec((String)"NetMapExportCsv(%s, %s)", (Object[])new Object[]{Cp.getFileAsArgument((String)path), options.exportNetUnused()});
        return true;
    }

    private static class ExportOptionsPanel
    extends JPanel {
        JCheckBox mExportNetUnused;

        public ExportOptionsPanel() {
            this.setBorder(BorderFactory.createTitledBorder("Export options"));
            GridBagManager l = new GridBagManager((Container)this);
            this.mExportNetUnused = new JCheckBox("Export NetUnused");
            this.mExportNetUnused.setSelected(false);
            l.add((Component)this.mExportNetUnused, (GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
            l.newline();
            l.addFillY();
        }

        @Override
        public void addNotify() {
            super.addNotify();
        }

        public boolean exportNetUnused() {
            return this.mExportNetUnused.isSelected();
        }
    }
}

