/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.orbit.OrbitIO;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class NetMappingImportUI {
    public static boolean showMe() {
        AFileChooser fc = new AFileChooser();
        ImportOptionsPanel options = new ImportOptionsPanel();
        fc.setDialogTitle("Import CSV Net Mapping");
        fc.setAccessory((JComponent)options);
        fc.setFileFilter((FileFilter)AFileFilter.CSV);
        if (fc.showOpenDialog((Component)OrbitIO.getMainWindow()) != 0) {
            return false;
        }
        File f = fc.getSelectedFile();
        Object path = f.getPath();
        if (!f.getName().contains(".")) {
            path = (String)path + ".csv";
        }
        Cp.exec((String)"com.sigrity.orbit.export.NetMapImport.setAutoCreateParentNets(%s)", (Object[])new Object[]{options.autoCreateParentNets()});
        Cp.exec((String)"com.sigrity.orbit.export.NetMapImport.setAutoCreateTopNets(%s)", (Object[])new Object[]{options.autoCreateTopNets()});
        Cp.exec((String)"com.sigrity.orbit.export.NetMapImport.importCsv(%s)", (Object[])new Object[]{Cp.getFileAsArgument((String)path)});
        return true;
    }

    private static class ImportOptionsPanel
    extends JPanel {
        JCheckBox mAutoCreateParentNets;
        JCheckBox mAutoCreateTopNets;

        public ImportOptionsPanel() {
            this.setBorder(BorderFactory.createTitledBorder("Import options"));
            GridBagManager l = new GridBagManager((Container)this);
            this.mAutoCreateParentNets = new JCheckBox("Auto create parent nets");
            this.mAutoCreateParentNets.setToolTipText("<html>If a parent net is specified and it does not exist,the parent net will be created and the reference net will be mapped to it.</html>");
            this.mAutoCreateParentNets.setSelected(true);
            l.add((Component)this.mAutoCreateParentNets, (GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
            l.newline();
            this.mAutoCreateTopNets = new JCheckBox("Auto create top nets");
            this.mAutoCreateTopNets.setToolTipText("<html>If a top net is specified and it does not exist,the top net will be created and the reference net will be mapped to it.</html>");
            this.mAutoCreateTopNets.setSelected(true);
            l.add((Component)this.mAutoCreateTopNets, (GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
            l.newline();
            l.addFillY();
        }

        @Override
        public void addNotify() {
            super.addNotify();
        }

        public boolean autoCreateParentNets() {
            return this.mAutoCreateParentNets.isSelected();
        }

        public boolean autoCreateTopNets() {
            return this.mAutoCreateTopNets.isSelected();
        }
    }
}

