/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AColor;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.ASplitPane;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.NetListPanel;
import com.sigrity.orbit.ui.NetMapBulkCreateUI;
import com.sigrity.orbit.ui.NetMapBulkUI;
import com.sigrity.orbit.ui.NetUI;
import com.sigrity.orbit.ui.OrbitIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ToolTipManager;

public class NetMgmtPanel
extends JPanel {
    protected Db mDb;
    protected Device mDevice;
    protected Net mActiveNet;
    protected Device mActiveDev;
    protected List<HierInst<PinTemplate>> mActiveContactPins;
    protected List<NetListPanel> mNetLists = new LinkedList<NetListPanel>();
    protected NetListPanel mParentList;
    protected JPanel mPnlChildNets;
    protected MouseListener mListsMenuAdapter = new UIUtil.AAbstractPopupMenuAdapter(){

        public void showMenu(Component component, int x, int y) {
            JLabel lbl;
            Component labelFor;
            JPopupMenu menu = new JPopupMenu();
            menu.add(new ShowSelectListsMenuItem());
            menu.add(new ShowAllListsAction());
            Component clickedOn = component.getComponentAt(x, y);
            if (clickedOn instanceof JLabel && (labelFor = (lbl = (JLabel)clickedOn).getLabelFor()) instanceof NetListPanel) {
                NetListPanel nl = (NetListPanel)labelFor;
                menu.add(new HideListAction(nl));
                menu.add(new ShowOnlyAction(nl));
                menu.addSeparator();
                menu.add(new ShowBulkMapMenuItem(lbl));
                menu.add(new ShowBulkCreateMenuItem(lbl));
            }
            if (OrbitIO.getGuiWorkspace() != null) {
                OrbitIO.getGuiWorkspace().beautify(menu);
            }
            menu.show(component, x, y);
        }
    };

    public NetMgmtPanel(Db db, Device device, boolean showIOPad, boolean showBump) {
        if (db != null) {
            this.mDb = db;
        }
        if (device != null) {
            this.mDevice = device;
            this.mDb = this.mDevice.getDb();
        }
        assert (this.mDb != null);
        NetListCellRenderer listCellRenderer = new NetListCellRenderer(this);
        ToolTipManager.sharedInstance().registerComponent(this);
        GridBagManager topLayout = new GridBagManager((Container)this);
        ASplitPane splitMain = new ASplitPane();
        topLayout.add((Component)splitMain, (GridBagConstraints)GridBagManager.FILLALL.noInsets());
        NetListPanel.NetListModel nlm = this.mDevice != null ? new NetListPanel.NetListModel(this.mDevice, null) : new NetListPanel.NetListModel(this.mDb);
        this.mParentList = new NetListPanel(nlm);
        this.mParentList.setCellRenderer(listCellRenderer);
        splitMain.setLeftComponent(this.mParentList);
        JPanel pnlRight = new JPanel();
        GridBagManager rightLayout = GridBagManager.layout((Container)pnlRight);
        splitMain.setRightComponent(pnlRight);
        this.mPnlChildNets = new JPanel();
        this.mPnlChildNets.addMouseListener(this.mListsMenuAdapter);
        this.reloadNetListsForDeviceType(showIOPad, showBump);
        JScrollPane spNetLists = new JScrollPane(20, 30);
        spNetLists.setViewportView(this.mPnlChildNets);
        rightLayout.add((Component)spNetLists, (GridBagConstraints)GridBagManager.FILLALL_REMAINX.noInsets());
        rightLayout.newline();
        rightLayout.pushFillXRemainX();
        rightLayout.addFillX();
        rightLayout.pop();
    }

    public void reloadNetListsForDeviceType(boolean showIOPad, boolean showBump) {
        Design design = Design.getDesign((Db)this.mDb);
        NetListCellRenderer listCellRenderer = new NetListCellRenderer(this);
        this.mPnlChildNets.removeAll();
        this.mNetLists.clear();
        GridBagManager childNetsLayout = new GridBagManager((Container)this.mPnlChildNets);
        IterableIterator devices = this.mDevice == null ? design.getRootDevices() : this.mDevice.getChildren();
        for (Device child : devices) {
            DeviceTemplate dt = child.getTemplate();
            if (!showIOPad && dt.getType() == DeviceTemplate.Type.PAD || !showBump && dt.getType() == DeviceTemplate.Type.BUMP) continue;
            NetListPanel.NetListModel m = new NetListPanel.NetListModel(child, this.mParentList);
            NetListPanel nl = new NetListPanel(m);
            nl.setCellRenderer(listCellRenderer);
            this.mNetLists.add(nl);
        }
        Collections.sort(this.mNetLists);
        for (NetListPanel list : this.mNetLists) {
            NetListPanel.NetListLabel lbl = new NetListPanel.NetListLabel(list);
            childNetsLayout.add((Component)lbl, (GridBagConstraints)GridBagManager.FILLX.insets(4, 4, 0, 4));
        }
        childNetsLayout.newline();
        for (NetListPanel list : this.mNetLists) {
            childNetsLayout.add((Component)list, (GridBagConstraints)GridBagManager.FILLALL);
        }
        this.mNetLists.add(this.mParentList);
    }

    public Device getDevice() {
        return this.mDevice;
    }

    public String getDeviceName() {
        if (this.mDevice == null) {
            return "<Design>";
        }
        return this.mDevice.getName();
    }

    public boolean isActiveNet(Device device, Net net) {
        if (this.mActiveNet == null) {
            return false;
        }
        if (device == this.mActiveDev) {
            return net == this.mActiveNet;
        }
        Net parentNet = device == this.mDevice ? net : NetMap.getParentNet((Device)device, (Net)net);
        Net activeParentNet = this.mActiveDev == this.mDevice ? this.mActiveNet : NetMap.getParentNet((Device)this.mActiveDev, (Net)this.mActiveNet);
        return parentNet != null && activeParentNet != null && parentNet == activeParentNet;
    }

    public void setActivedNetMassage(Device device, Net net) {
        if (device == this.mDevice || device == null) {
            int childNetCount = 0;
            int childCount = 0;
            for (NetListPanel nl : this.mNetLists) {
                NetListPanel.NetListModel nlm = nl.getNetlistModel();
                int index = -1;
                if (nlm.mDevice == this.mDevice) {
                    index = nlm.getIndexOf(net);
                } else {
                    boolean foundOne = false;
                    IterableIterator maps = NetMap.getChildNets((Device)nlm.mDevice, (Net)net);
                    while (maps.hasNext()) {
                        NetMap nm = (NetMap)maps.next();
                        if (index == -1) {
                            index = nlm.getIndexOf(nm.getChildNet());
                        }
                        ++childNetCount;
                        if (foundOne) continue;
                        foundOne = true;
                        ++childCount;
                    }
                }
                if (index == -1) continue;
                nl.getList().ensureIndexIsVisible(index);
            }
            NetUI.NetDlg nd = (NetUI.NetDlg)((Object)UIUtil.getAncestorOfType((Component)this, NetUI.NetDlg.class));
            if (nd != null) {
                String netClause = childNetCount == 1 ? "is 1 net" : String.format("are %d nets", childNetCount);
                String childClause = childCount == 1 ? "1 child device" : String.format("%d child devices", childCount);
                String devName = this.mDevice == null ? "Design" : this.mDevice.getName();
                String msg = String.format("There %s on %s associated with '%s' net '%s'.", netClause, childClause, devName, net.getName());
                nd.setStatus(msg);
            }
        } else {
            Net parentNet = NetMap.getParentNet((Device)device, (Net)net);
            if (parentNet == null) {
                NetUI.NetDlg nd = (NetUI.NetDlg)((Object)UIUtil.getAncestorOfType((Component)this, NetUI.NetDlg.class));
                if (nd != null) {
                    String msg = String.format("'%s' net '%s' does not map to a net on '%s'.", device.getName(), net.getName(), this.getDeviceName());
                    nd.setStatus(msg);
                }
            } else {
                this.setActivedNetMassage(null, parentNet);
            }
        }
    }

    public boolean isParentList(NetListPanel list) {
        return list.getDevice() == this.mDevice;
    }

    public NetListPanel.NetListLabel getLabelFor(NetListPanel netList) {
        for (Component c : this.mPnlChildNets.getComponents()) {
            if (!(c instanceof NetListPanel.NetListLabel) || ((NetListPanel.NetListLabel)c).getLabelFor() != netList) continue;
            return (NetListPanel.NetListLabel)c;
        }
        return null;
    }

    public static class NetListCellRenderer
    extends DefaultListCellRenderer {
        static final Color ACTIVE_NET_COLOR = new Color(255, 255, 127, 255);
        static final Color PINMAP_NET_COLOR = new Color(152, 251, 152, 255);
        protected NetMgmtPanel mNetMgmtPnl;

        public NetListCellRenderer(NetMgmtPanel nmp) {
            this.mNetMgmtPnl = nmp;
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, (Object)null, index, isSelected, cellHasFocus);
            NetListPanel nl = (NetListPanel)UIUtil.getAncestorOfType(list, NetListPanel.class);
            Net n = (Net)value;
            if (n == null || n.getDb() == null) {
                this.setText("<Deleted>");
                this.setForeground(AColor.mix((Color)this.getForeground(), (Color)Color.GRAY, (float)0.33f));
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                } else {
                    this.setBackground(AColor.CLEAR);
                }
                return this;
            }
            boolean isParentList = this.mNetMgmtPnl.isParentList(nl);
            Device d = nl.getNetlistModel().mDevice;
            if (d != null) {
                if (isParentList) {
                    if (NetMap.getChildNets((Net)n).hasNext()) {
                        this.setIcon(OrbitIcons.NETMAP_DOWN);
                    }
                } else {
                    Net parentNet = NetMap.getParentNet((Device)d, (Net)n);
                    if (parentNet != null) {
                        this.setIcon(OrbitIcons.NETMAP_UP);
                    }
                }
            }
            this.setText(n.getName());
            if (this.mNetMgmtPnl.isActiveNet(nl.getNetlistModel().mDevice, n)) {
                if (isSelected) {
                    this.setBackground(AColor.mix((Color)ACTIVE_NET_COLOR, (Color)list.getSelectionBackground(), (float)0.66f));
                } else {
                    this.setBackground(ACTIVE_NET_COLOR);
                }
            } else if (isSelected) {
                this.setBackground(list.getSelectionBackground());
            } else {
                this.setBackground(AColor.CLEAR);
            }
            return this;
        }
    }

    protected class ShowOnlyAction
    extends AbstractAction {
        protected NetListPanel mNetList;

        public ShowOnlyAction(NetListPanel nl) {
            super("Hide All Other Devices");
            this.mNetList = nl;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComponent parent = (JComponent)this.mNetList.getParent();
            for (Component c : NetMgmtPanel.this.mPnlChildNets.getComponents()) {
                JLabel l;
                Component labelFor;
                if (c instanceof JLabel && (labelFor = (l = (JLabel)c).getLabelFor()) instanceof NetListPanel && labelFor != this.mNetList) {
                    c.setVisible(false);
                    parent.setComponentZOrder(c, parent.getComponentCount() - 1);
                }
                if (!(c instanceof NetListPanel) || c == this.mNetList) continue;
                c.setVisible(false);
                parent.setComponentZOrder(c, parent.getComponentCount() - 1);
            }
        }
    }

    protected class HideListAction
    extends AbstractAction {
        protected NetListPanel mNetList;

        public HideListAction(NetListPanel nl) {
            super("Hide This Device");
            this.mNetList = nl;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComponent parent = (JComponent)this.mNetList.getParent();
            for (Component c : NetMgmtPanel.this.mPnlChildNets.getComponents()) {
                if (!(c instanceof JLabel) || ((JLabel)c).getLabelFor() != this.mNetList) continue;
                c.setVisible(false);
                parent.setComponentZOrder(c, parent.getComponentCount() - 1);
            }
            this.mNetList.setVisible(false);
        }
    }

    protected class ShowListAction
    extends AbstractAction {
        protected JLabel mLabel;

        public ShowListAction(JLabel label) {
            super(label.getText());
            this.mLabel = label;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.mLabel.setVisible(true);
            this.mLabel.getLabelFor().setVisible(true);
        }
    }

    protected class ShowAllListsAction
    extends AbstractAction {
        public ShowAllListsAction() {
            super("Show All Devices");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (Component c : NetMgmtPanel.this.mPnlChildNets.getComponents()) {
                if (c instanceof JLabel && ((JLabel)c).getLabelFor() instanceof NetListPanel) {
                    c.setVisible(true);
                }
                if (!(c instanceof NetListPanel)) continue;
                c.setVisible(true);
            }
        }
    }

    protected class ShowSelectListsDlg
    extends ADialog {
        protected JList<JLabel> mList;
        protected KeyListener mKeyListener;
        protected MouseListener mMouseListener;

        public ShowSelectListsDlg() {
            super((Component)NetMgmtPanel.this, "Show Devices", Dialog.ModalityType.APPLICATION_MODAL);
            this.mKeyListener = new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    super.keyTyped(e);
                    if (e.isConsumed()) {
                        return;
                    }
                    if (e.getKeyChar() == ' ') {
                        ShowSelectListsDlg.this.toggleItems(ShowSelectListsDlg.this.mList.getSelectedIndices());
                    }
                }
            };
            this.mMouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 1) {
                        Point lstPoint = e.getPoint();
                        int idx = ShowSelectListsDlg.this.mList.locationToIndex(lstPoint);
                        JLabel label = ShowSelectListsDlg.this.mList.getModel().getElementAt(idx);
                        CellRenderer renderer = (CellRenderer)ShowSelectListsDlg.this.mList.getCellRenderer();
                        Rectangle cellBounds = ShowSelectListsDlg.this.mList.getCellBounds(idx, idx);
                        renderer.getListCellRendererComponent(ShowSelectListsDlg.this.mList, label, idx, false, false);
                        renderer.setBounds(0, 0, cellBounds.width, cellBounds.height);
                        Point rendererPoint = new Point(lstPoint);
                        rendererPoint.translate(-cellBounds.x, -cellBounds.y);
                        if (renderer.getComponentAt(rendererPoint) == renderer.mCb) {
                            ShowSelectListsDlg.this.toggleItems(new int[]{idx});
                        }
                    }
                }
            };
            GridBagManager l = new GridBagManager(this.getContentPane());
            this.mList = new JList(new DefaultListModel());
            JScrollPane sp = new JScrollPane(this.mList);
            l.add((Component)sp, (GridBagConstraints)GridBagManager.FILLALL);
            this.mList.setCellRenderer(new CellRenderer());
            this.mList.addMouseListener(this.mMouseListener);
            this.mList.addKeyListener(this.mKeyListener);
            for (Component c : NetMgmtPanel.this.mPnlChildNets.getComponents()) {
                if (!(c instanceof JLabel) || !(((JLabel)c).getLabelFor() instanceof NetListPanel)) continue;
                ((DefaultListModel)this.mList.getModel()).addElement((JLabel)c);
            }
            l.newline();
            l.pushFillX();
            JButton btnClose = new JButton("Close");
            l.addFillX();
            l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, null);
            this.pack();
            UIUtil.center((Component)((Object)this));
        }

        protected void toggleItems(int[] items) {
            for (int idx : items) {
                JLabel label;
                label.setVisible(!(label = this.mList.getModel().getElementAt(idx)).isVisible());
                label.getLabelFor().setVisible(label.isVisible());
                UIUtil.repaintListItem(this.mList, (int)idx);
            }
        }

        class CellRenderer
        extends JPanel
        implements ListCellRenderer<JLabel> {
            protected JCheckBox mCb = new JCheckBox();
            protected JLabel mLabel = new JLabel();

            public CellRenderer() {
                this.setLayout(new FlowLayout(0, 0, 0));
                this.add(this.mCb);
                this.mCb.setOpaque(false);
                this.mCb.setBackground(new Color(0, 0, 0, 0));
                this.add(this.mLabel);
            }

            @Override
            public Component getListCellRendererComponent(JList<? extends JLabel> list, JLabel value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel lbl = value;
                NetListPanel nl = (NetListPanel)lbl.getLabelFor();
                this.mLabel.setText(lbl.getText());
                this.mCb.setSelected(nl.isVisible());
                this.setEnabled(list.isEnabled());
                this.setFont(list.getFont());
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                return this;
            }
        }
    }

    protected class ShowSelectListsMenuItem
    extends AbstractAction {
        public ShowSelectListsMenuItem() {
            super("Show Devices...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ShowSelectListsDlg dlg = new ShowSelectListsDlg();
            dlg.setVisible(true);
        }
    }

    protected class ShowBulkCreateMenuItem
    extends AbstractAction {
        protected JLabel mLblNetList;

        public ShowBulkCreateMenuItem(JLabel lbl) {
            super("Bulk Create Parent Nets...");
            this.mLblNetList = lbl;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NetListPanel nl = (NetListPanel)this.mLblNetList.getLabelFor();
            NetMapBulkCreateUI.bulkMap(this.mLblNetList, nl.getDevice());
        }
    }

    protected class ShowBulkMapMenuItem
    extends AbstractAction {
        protected JLabel mLblNetList;

        public ShowBulkMapMenuItem(JLabel lbl) {
            super("Bulk Map...");
            this.mLblNetList = lbl;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NetListPanel nl = (NetListPanel)this.mLblNetList.getLabelFor();
            NetMapBulkUI.bulkMap(this.mLblNetList, nl.getDevice());
        }
    }
}

